var g_tr069Data;
/*global common_success,isAjaxReturnOK,saveAjaxData,object2xml,isButtonEnable,clearAllErrorLabel,firewall_label_dmz_ip_address_invalid,dialup_hint_ip_address_empty,showErrorUnderTextbox,$,button_enable,onRadioChange,getAjaxData,xml2object,isValidIpAddress,showErrorUnderTextbox,showInfoDialog*/


function check_interval(port) {
    if ( !IsDigital( port ) )
    {
        return false;
    }
    if (10 > port || port > 2678400) {
        return false;
    }

    return true;
}


function initPage() {
    getAjaxData('api/cwmp/basic-info', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            g_tr069Data = ret.response;
	    if (typeof(g_moduleswitch.encrypt_enabled) != 'undefined' && g_moduleswitch.encrypt_enabled == 1) {
	    	if (typeof(g_tr069Data.username) != 'undefined' && g_tr069Data.username != null && g_tr069Data.username != '') {                
				g_tr069Data.password = COMMON_PASSWORD_VALUE;
	        }
	    }			
            $("input[name='tr069_periodic_notification'][value=" + g_tr069Data.periodicinformenable + ']').attr('checked', true);
            $('#tr069_notification_interval').val(g_tr069Data.periodicinforminterval);
			$('#tr069_url').val(g_tr069Data.url);
			$('#tr069_username').val(g_tr069Data.username);
			$('#tr069_password').val(g_tr069Data.password);
        }
    });
}

function isValidTr069Url(url)
{
    var i = 0;
    if( 0 != url.indexOf("http://") && 0 != url.indexOf("https://"))
	{
		return false;
	}
	if( url == "http://" || url == "https://")
	{
		return false;
	}
	for(i = 0; i < url.length; i++)
	{
		if(url.charAt(i)>='A' &&url.charAt(i) <= 'Z')
		{
			continue;
		}
		if(url.charAt(i)>='a' &&url.charAt(i) <= 'z')
		{
			continue;
		}
		if(url.charAt(i)>='0' &&url.charAt(i) <= '9')
		{
			continue;
		}
		if(url.charAt(i)=='.' || url.charAt(i)=='-' || url.charAt(i)=='_' ||url.charAt(i)==':' || url.charAt(i)=='/')
		{
			continue;
		}
		return false;
	}
	return true;
}
function validateTr069() {
	var tr069NoticeInterval = $('#tr069_notification_interval').val();
	if(!check_interval(tr069NoticeInterval))
	{
		showErrorUnderTrEx('tr069_notification_interval', IDS_tr069_interval_error);
		$('#tr069_notification_interval').focus();
        return false;
	}
	
	//----
	var tr069Url = $('#tr069_url').val();
	if(!isValidTr069Url(tr069Url)) {
		showErrorUnderTrEx('tr069_url', IDS_tr069_urlfilter_error);
		$('#tr069_url').focus();
        return false;
	}
	
	//----
	var tr069Username = $('#tr069_username').val();
	if ('' == tr069Username || false == checkInputChar(tr069Username)) {
		showErrorUnderTrEx('tr069_username', dialup_hilink_hint_username_invalidate);
		$('#tr069_username').focus();
        return false;
	}
	//--
	var tr069Password = $('#tr069_password').val();
	if ('' == tr069Password || false == checkInputChar(tr069Password)) {
		showErrorUnderTrEx('tr069_password', dialup_hilink_hint_password_invalidate);
		$('#tr069_password').focus();
        return false;
	}
    return true;
}
function apply() {
    clearAllErrorLabel();
    clearPasswordStrength();
    if (!isButtonEnable('apply_button'))
    {
        return;
    }
    if (validateTr069())
	{
        g_tr069Data.periodicinformenable = $("[name='tr069_periodic_notification']:checked").val();
        g_tr069Data.periodicinforminterval = $('#tr069_notification_interval').val();
		g_tr069Data.url = $('#tr069_url').val();
		g_tr069Data.username = $('#tr069_username').val();
		g_tr069Data.password = $('#tr069_password').val();
   	 	if (checkPostIndex(0)) {
        	delete g_tr069Data.password;
    	}
        var xmlstr = object2xml('request', g_tr069Data);
        button_enable('apply_button', '0');
        saveAjaxData('api/cwmp/basic-info', xmlstr, function($xml) {
            var ret = xml2object($xml);
            if (isAjaxReturnOK(ret)) {
                showInfoDialog(common_success);
            }
            else {
                button_enable('apply_button', '1');
                initPage();
            }
		},{
    		enc:true
        });
    }
}

function showPwdStrength(password,username) {
    $('#' + password).live("keydown keypress keyup focus change", function(event) {
        if(("keydown" == event.type || "keypress" == event.type || "keyup" == event.type)
        && (37 == event.keyCode || 38 == event.keyCode || 39 == event.keyCode || 40 == event.keyCode)) {
            return;
        }
        if($('#' + password).val().length > 0) {
            clearPasswordStrength();
            showPasswordStrength(password);
            setPWDStrengthColor(checkPWStrength($('#' + password).val(),$('#' + username).val()));
        } else {
            setPWDStrengthColor(0);
        }
    });
}

$(document).ready(function() {
	clickPasswordEvent('tr069_password',0);
    $('input').bind('change input paste cut keydown', function(e) {
        if(MACRO_KEYCODE != e.keyCode){
            button_enable('apply_button', '1');
        }
        
    });
    //$("[name='dmz_status']").click(function() {
    //});
    button_enable('apply_button', '0');
    showPwdStrength('tr069_password','tr069_username');
    initPage();
});