var g_server = null;

$(document).ready(function() {
    button_enable('apply', '0');
    init_time();

    $("#apply").click(function() {
        if (!isButtonEnable('apply')) {
            return;
        }
        apply();
    });
    $("#check_prack").click(function() {
    	button_enable('apply', '1');
    });

    $('.input_style').bind('input change cut paste keydown', function(e) {
        if (MACRO_KEYCODE != e.keyCode) {
            button_enable('apply', '1');
        }
    });
});

function set_data() {

    $('#input_registerexpires').val(g_server.registerexpires);
    $('#input_sessionexpires').val(g_server.sessionexpires);
    $('#input_minisessionexpires').val(g_server.minisessionexpires);

    $('#check_prack').get(0).checked = (g_server.pracksupport == 1);
}

function init_time() {
    getAjaxData('api/voice/sipadvance', function($xml) {
        var cap_ret = xml2object($xml);
        if ('response' == cap_ret.type) {
            g_server = cap_ret.response;
            set_data();
        }
    }, {
        sync : true
    });
}
function get_data() {

    g_server.registerexpires = $.trim($('#input_registerexpires').val());
    g_server.sessionexpires = $.trim($('#input_sessionexpires').val());
    g_server.minisessionexpires = $.trim($('#input_minisessionexpires').val());

    g_server.pracksupport = $('#check_prack').get(0).checked ? 1 : 0;
}

function apply() {
    clearAllErrorLabel();

    if (!check_expirestime()) {
        return false;
    }
    get_data();
    button_enable('apply', '0');

    var sendata = g_server;
    var newXmlString = object2xml('request', sendata);
    saveAjaxData('api/voice/sipadvance', newXmlString, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            init_time();
            showInfoDialog(common_success);
        } else {
            button_enable('apply','1');
            if ( typeof (ret.error) != 'undefined' && ret.error.code == ERROR_SYSTEM_BUSY) {
                showInfoDialog(common_system_busy);
            } else {
                showInfoDialog(common_fail);
            }
        }
    });
}
function check_time(time,min,max) {
    if ( !IsDigital( time ) )
    {
        return false;
    }
    if (min > time || time > max) {
        return false;
    }

    return true;
}
function check_expirestime(type) {
    if (!check_time($.trim($('#input_registerexpires').val()),60,65535)) {
        showErrorUnderTrEx('input_registerexpires', IDS_VOIP_SIPAdvanceErrStr1);
        return false;
    }
    var input_sessionexpires=$.trim($('#input_sessionexpires').val());
    var input_minisessionexpires=$.trim($('#input_minisessionexpires').val());
    if (!check_time(input_sessionexpires,100,3600)) {
        showErrorUnderTrEx('input_sessionexpires', IDS_VOIP_SIPAdvanceErrStr3);
        return false;
    }
    if (!check_time(input_minisessionexpires,90,1800)) {
        showErrorUnderTrEx('input_minisessionexpires', IDS_VOIP_SIPAdvanceErrStr4);
        return false;
    }
    if(parseInt(input_sessionexpires,10)<parseInt(input_minisessionexpires,10)){
        showErrorUnderTrEx('input_sessionexpires', IDS_VOIP_SIPAdvanceErrStr7);
        return false;
    }
    return true;
}