var log_content = '';
var log_unit = '';
var content_time = '';
var content_level = '';
var content_module = '';
var content_result = '';
var content_info = '';
var content_separator = "\t\t";
var content_end = "\n";

function addLogList() {
    var i = 0;
    var logStr = "<div class='logContainer'>";
    for (i = 0; i < arguments.length; i++) {
        logStr += "<div class='log_" + i + "'>";
        logStr += arguments[i];
        logStr += "</div>";
    }
    logStr += "</div>";
    return logStr;
}

function getNewLog() {
    getAjaxData("api/syslog/querylog", function($xml) {
            var ret = xml2object($xml);
            if (ret.type == 'response') {
                var log = ret.response;
                var content_list = log.content.split(';');
                var logList = new Array();
                var log_len = 0;
                if (content_list.length > 0) {
                    $.each(content_list, function(n, value) {
                            if (value != '' && typeof(value) != 'undefined') {
                                log_unit = value.split(',');
                                if (log_unit.length > 0) {
                                    content_time = log_unit[0];
                                    content_level = window['log_level_' + log_unit[1]];
                                    content_module = window['log_module_' + log_unit[2]];
                                    content_result = window['log_ret_' + log_unit[3]];
                                    content_info = window['log_id_' + log_unit[4]];
                                    if (!content_level || !content_module || !content_result || !content_info) {
                                    return;
                                }
                                log_content = addLogList(content_time, content_module, content_result, content_info);
                                logList[log_len] = log_content;
                                log_len++;
                            }
                        }
                    });
            }
            $("#level_select").val(log.currentlevel);
            $("#show_log_area").html(logList.join("\n"));
        }
    }, {
        sync: true
    });
}
/*---------------------get config data---------------------------*/
function getConfigLevel() {
    var html = "";
    for (var i = 0; i < 4; i++) {
        html += "<option value = '" + i + "'>" + eval("log_label_" + i) + "</option>";
    }
    $("#level_select").append(html);
}

function getCurrentLog(level) {
    var apply_level = {
        loglevel: level
    };
    var apply_req = object2xml("request", apply_level);
    saveAjaxData("api/syslog/querylog", apply_req, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            call_dialog(common_confirm, firewall_hint_submit_list_item, common_ok, "pop_OK", common_cancel, "pop_Cancel");
            $("#pop_OK").click(function() {
                clearDialog();
                getNewLog();
            });
        } else {
            showInfoDialog(common_failed);
        }
    }, {
        sync: true
    });
}

/*------------------function ready---------------------*/
$(document).ready(function() {
    getConfigLevel();
    getNewLog();
    $("#log_items").html(" (   0" + log_label_display + "  " + log_label_total + "0  )");
    $("#apply_button").bind("click", function() {
        getCurrentLog($("#level_select").val());
    });
    $("#clear_log").bind("click", function() {
        var clear = {
            command: "clear"
        };
        var apply_req = object2xml("request", clear);
        saveAjaxData("api/syslog/processlog ", apply_req, function($xml) {
            var ret = xml2object($xml);
            if (isAjaxReturnOK(ret)) {
                showInfoDialog(common_success);
                getNewLog();
            } else {
                showInfoDialog(common_failed);
            }
        });
    })
    $("#export_log").click(function() {
        showWaitingDialog(common_waiting, sd_hint_wait_a_few_moments);
        var lang = {
            language: LANGUAGE_DATA.current_language
        }
        var postData = object2xml("request", lang);
        saveAjaxData("api/syslog/downlog", postData, function($xml) {
            var ret = xml2object($xml);
            if (isAjaxReturnOK(ret)) {
                closeWaitingDialog();
                window.location.href = "syslog_export.log";
            }
        });
    });
});
