/*===========================================================================
DT??衧2o??????a?o
<DT???>        <o???>           <?o?a|o?>          <?㡧a?o?>
dwx270728       2015-03-10       DTS2014122701264   B315s-936??ip1y??1???|????????衧a?|?1??㡧????
DTS2015102109309    2015/11/23          lwx297026            ?B31x????IP filter?:IP Filter??WAN IP??????
===========================================================================*/
var LAN_IP_FILTER_NUM = 32;
var ok_flag = 0;
var add_flag = 0;

var protocolStatusArray = [
[PROTOCOL_BOTH, firewall_label_tcp_or_udp],
[PROTOCOL_TCP, firewall_label_tcp],
[PROTOCOL_UDP, firewall_label_udp],
[PROTOCOL_IMCP, firewall_label_imcp]
];

var filterStatusArray = [
[FILTER_DISABLED, common_off],
[FILTER_ENABLED, common_on]
];

var g_source_num = 0;
var firewall_status = null;
var BLACK_URL = "black";
var WHITE_URL = "white";
var FILTER_MODE_BLACK = 0;
var FILTER_MODE_WHITE = 1;
var g_new_filter_mode = FILTER_MODE_BLACK;

function addLanipFilter(insertNode) {
    var addLine = null;
    var i = 1;
    if("" !== arguments[1] && 'undefined' !== arguments[1]) 
    {
        addLine = "<tr class='user_add_line show_ip_filter_"+arguments[1]+"'>";
    }
    for ( i = 2; i < arguments.length; i++ ) {
        addLine += "<td class='lanipfiltertd'>" + arguments[i] + "</td>";
    }
    addLine += "<td class='user_options clr_blue_hover' width='105'><span class=\"button_edit_list clr_blue\">" + common_edit + "</span><span class=\"button_delete_list clr_blue\">" + common_delete + "</span></td></tr>";

    var currentTrTotal = $(insertNode).size();
    $(insertNode).eq(currentTrTotal - 2).after(addLine);
}

function ipTranApply(ipaddr) {
    var ipout = [];
    var ipoutstring = '';
    var idx = 0;
    if (ipaddr == null || ipaddr == undefined || ipaddr == '') {
        return '';
    }

    ipout = ipaddr.split('.');
    if (ipout.length != 4) {
        return '';
    } else {
        for (idx = 3; idx >= 0; idx--) {
            if (ipout[idx] == '*') {
                ipout[idx] = '0';
            } else {
                break;
            }
        }
    }
    ipoutstring = ipoutstring.concat(ipout[0], '.', ipout[1], '.', ipout[2], '.', ipout[3]);
    return ipoutstring;
}

function ipTranGet(ipAddress, num) {
    var ipout = [];
    var ipoutstring = '';
    var i = 0;
    if (null == ipAddress || undefined == ipAddress || '' == ipAddress) {
        return '';
    }

    ipout = ipAddress.split('.');
    if (ipout.length != 4) {
        return '';
    } else {
        for (i = 3; i > -1; i--) {
            if ('0' == ipout[i]) {
                if (num > 0) {
                    ipout[i] = '*';
                    num--;
                } else {
                    break;
                }
            } else {
                break;
            }
        }
    }
    ipoutstring = ipoutstring.concat(ipout[0], '.', ipout[1], '.', ipout[2], '.', ipout[3]);
    return ipoutstring;
}

function ipGetMaskNum(ipAddress) {
    var ipout = [];
    var ipoutstring = '';
    var i = 0;
    var ipaddNum = 0;
    if (null == ipAddress || undefined == ipAddress || '' == ipAddress) {
        return '';
    }

    ipout = ipAddress.split('.');
    if (ipout.length != 4) {
        return '';
    } else {
        for (i = 3; i > -1; i--) {
            if (ipout[i] == '*') {
                ipaddNum++;
            } else {
                break;
            }
        }
    }
    return ipaddNum;
}

function sourceIpTranApplyValid(ipaddr) {
    var ipout = [];
    var ipoutstring = '';
    var i = 0;
    if (ipaddr == null || ipaddr == undefined || ipaddr == '') {
        return '';
    }

    ipout = ipaddr.split('.');
    if (ipout.length != 4) {
        return '';
    } else {
        for (i = 3; i > -1; i--) {
            if (ipout[i] == '*') {
                ipout[i] = '0';
            } else {
                break;
            }
        }
    }
    ipoutstring = ipoutstring.concat(ipout[0], '.', ipout[1], '.', ipout[2], '.', ipout[3]);
    return ipoutstring;
}

function isValidIpAddressForIPFilter(address) {
    var addrParts = address.split('.');
    if (addrParts.length != 4) {
        return false;
    }
    if((addrParts[0] == '*')&&(addrParts[1] == '*')&&(addrParts[2] == '*')&&(addrParts[3] == '*'))
    {
        return false;
    }
    for (i = 0; i < 4; i++) {
        if ((addrParts[i] == '*') && (i != 3)) {
            if (addrParts[i + 1] != '*') {
                return false;
            }
        }
        if (true == (isNaN(addrParts[i])) && (addrParts[i] != '*')) {
            return false;
        }

        if ('' == addrParts[i]) {
            return false;
        }

        if (addrParts[i].indexOf(' ') != -1) {
            return false;
        }

        if ((0 == addrParts[i].indexOf('0')) && (1 != addrParts[i].length)) {
            return false;
        }
    }

    if ((addrParts[0] <= 0 || addrParts[0] == 127 || addrParts[0] > 223) ||
    (addrParts[1] < 0 || addrParts[1] > 255) ||
    (addrParts[2] < 0 || addrParts[2] > 255) ||
    (addrParts[3] < 0 || addrParts[3] >= 255)) {
        return false;
    }

    return true;
}

function checkIpPort(value, name) {
    if ('' == value ) {
        showQtip(name, firewall_hint_port_empty);
        return false;
    } else if (!(isVaildPortForIPFilter(value, name))) {
        return false;
    }
    return true;
}
function isValidIpv4Address(IPAddress, isLan) {
    if ('' == IPAddress ||
        !isValidIpAddressForIPFilter(IPAddress) ||
        IPAddress == dhcpLanIPAddress
    ) {
        return false;
    }

    if (isLan && !isSameSubnetAddrs(sourceIpTranApplyValid(IPAddress), dhcpLanIPAddress, dhcpLanNetmask)) {
        return false;
    }

    return true;
}

function isValidIpv6(IPAddress){
	if (!isValidIpv6Address(IPAddress) || !verifyIpv6str(IPAddress) )  {
			return false;
		}
	 return true;
}
function isVaildValue() {
    $.each($('.qtip-defaults'), function() {
        $(this).remove();
    });
    var lanIPFilterLanAddress = $.trim($('#input_lan_ip_address').val());
    var lanIPFilterLanPort = $.trim($('#input_lan_ip_port').val());
    var lanIPFilterWanAddress = $.trim($('#input_wan_ip_address').val());
    var lanIPFilterWanPort = $.trim($('#input_wan_ip_port').val());
    if ('0' != g_config_firewall.lanipfilter.lan_enable) {
        if (!isValidIpv4Address(lanIPFilterLanAddress, true) && !isValidIpv6(lanIPFilterLanAddress)) {
            showQtip('input_lan_ip_address', dialup_hint_ip_address_empty);
            return false;
        }

        if(!($('#select_protocol_status').val()==1)) {
            if(!(checkIpPort(lanIPFilterLanPort, 'input_lan_ip_port'))) {
                return false;
            }
        }
    }
    if ('0' != g_config_firewall.lanipfilter.wan) {
        if ('' == lanIPFilterWanAddress ||
        (!isValidIpAddressForIPFilter(lanIPFilterWanAddress) || !isValidIpv4Address(lanIPFilterLanAddress, true)) &&
        (!isValidIpv6(lanIPFilterWanAddress) || !isValidIpv6(lanIPFilterLanAddress))
        ) {
            showQtip('input_wan_ip_address', dialup_hint_ip_address_empty);
            return false;
        }        
        if(isSameSubnetAddrs(lanIPFilterLanAddress,lanIPFilterWanAddress,subnetMask) && isValidIpAddressForIPFilter(lanIPFilterWanAddress)) {
            showQtip('input_wan_ip_address', IDS_dialup_hint_wan_ip_address);
            return false;
        }
        if(!($('#select_protocol_status').val()==1)) {
            if(!(checkIpPort(lanIPFilterWanPort, 'input_wan_ip_port'))) {
                return false;
            }
        }
    }
    return true;
}

var g_filters = null;

function UpdateIpFilter()
{
    getAjaxData('api/security/lan-ip-filter', function($xml) {
        var ret = xml2object($xml);
        if(ret.type == 'response') {
            g_filters = ret.response.IPFilters.IPFilter;
        }
    },{
        sync: true
    });
}

function showIPFiters(filterPolicy)
{
    var filters = g_filters;
    var lanPort;
    var wanPort;
    var protocolStatus;
    var filterStatus;
    var lastFilter;
    var policyType;

    if (filters) {
        if ($.isArray(filters)) {
            $(filters).each(function(i) {
                lanPort = portJoin(filters[i].LanIPFilterLanStartPort, filters[i].LanIPFilterLanEndPort);
                wanPort = portJoin(filters[i].LanIPFilterWanStartPort, filters[i].LanIPFilterWanEndPort);
                if(lanPort=='0'&&wanPort=='0'){
                    lanPort='';
                    wanPort='';
                }
                policyType = (0 == filters[i].LanIPFilterPolicy ? BLACK_URL:WHITE_URL);
                protocolStatus = getDArrayElement(protocolStatusArray, filters[i].LanIPFilterProtocol, 'value');
                filterStatus = getDArrayElement(filterStatusArray, filters[i].LanIPFilterStatus, 'value');
                var LanIPAddress = XSSResolveCannotParseChar(filters[i].LanIPFilterLanStartAddress);
                if(isValidIpv4Address(filters[i].LanIPFilterLanStartAddress, true)){
                    LanIPAddress = ipTranGet(XSSResolveCannotParseChar(filters[i].LanIPFilterLanStartAddress), filters[i].LanIPFilterSrcStartIPMask);
                }
                var WANIPAddress = XSSResolveCannotParseChar(filters[i].LanIPFilterWanStartAddress);
                if(isValidIpv4Address(filters[i].LanIPFilterWanStartAddress, false)){
                    WANIPAddress = ipTranGet(XSSResolveCannotParseChar(filters[i].LanIPFilterWanStartAddress), filters[i].LanIPFilterDestStartIPMask);
                }
                if ('0' == g_config_firewall.lanipfilter.wan)
                {
                    addLanipFilter(
                        $('#service_list tr'),
                        policyType,
                        LanIPAddress,
                        lanPort,
                        protocolStatus,
                        filterStatus
                    );
                }
                else if ('0' == g_config_firewall.lanipfilter.lan_enable)
                {
                    addLanipFilter(
                        $('#service_list tr'),
                        policyType,
                        WANIPAddress,
                        wanPort,
                        protocolStatus,
                        filterStatus
                    );
                }
                else
                {
                    addLanipFilter(
                        $('#service_list tr'),
                        policyType,
                        LanIPAddress,
                        lanPort,
                        WANIPAddress,
                        wanPort,
                        protocolStatus,
                        filterStatus
                    );
                }
            });

            lastFilter = filters[filters.length - 1];

        }
        else
        {
            lanPort = portJoin(filters.LanIPFilterLanStartPort, filters.LanIPFilterLanEndPort);
            wanPort = portJoin(filters.LanIPFilterWanStartPort, filters.LanIPFilterWanEndPort);

            if(lanPort=='0'&&wanPort=='0'){
                lanPort='';
                wanPort='';
            }

            protocolStatus = getDArrayElement(protocolStatusArray, filters.LanIPFilterProtocol, 'value');
            filterStatus = getDArrayElement(filterStatusArray, filters.LanIPFilterStatus, 'value');
            policyType = (0 == filters.LanIPFilterPolicy ? BLACK_URL:WHITE_URL);

            var LanIPAddress = XSSResolveCannotParseChar(filters.LanIPFilterLanStartAddress);
            if(isValidIpv4Address(filters.LanIPFilterLanStartAddress, true)){
                LanIPAddress = ipTranGet(XSSResolveCannotParseChar(filters.LanIPFilterLanStartAddress), filters.LanIPFilterSrcStartIPMask);
            }
            var WANIPAddress = XSSResolveCannotParseChar(filters.LanIPFilterWanStartAddress);
            if(isValidIpv4Address(filters.LanIPFilterWanStartAddress, false)){
                WANIPAddress = ipTranGet(XSSResolveCannotParseChar(filters.LanIPFilterWanStartAddress), filters.LanIPFilterDestStartIPMask);
            }
            if ('0' == g_config_firewall.lanipfilter.wan)
            {
                addLanipFilter(
                    $('#service_list tr'),
                    policyType,
                    LanIPAddress,
                    lanPort,
                    protocolStatus,
                    filterStatus
                );
            }
            else if ('0' == g_config_firewall.lanipfilter.lan_enable)
            {
                addLanipFilter(
                    $('#service_list tr'),
                    policyType,
                    WANIPAddress,
                    wanPort,
                    protocolStatus,
                    filterStatus
                );
            }
            else
            {
                addLanipFilter(
                    $('#service_list tr'),
                    policyType,
                    LanIPAddress,
                    lanPort,
                    WANIPAddress,
                    wanPort,
                    protocolStatus,
                    filterStatus
                );
            }

            lastFilter = filters;
        }

        $('#input_lan_ip_address').val(lastFilter.LanIPFilterLanStartAddress);
        $('#input_lan_ip_port').val(lanPort);
        $('#input_wan_ip_address').val(lastFilter.LanIPFilterWanStartAddress);
        $('#input_wan_ip_port').val(wanPort);
    }
    else
    {
        $('#input_lan_ip_address').val("");
        $('#input_lan_ip_port').val("");
        $('#input_wan_ip_address').val("");
        $('#input_wan_ip_port').val("");
    }

    if(filterPolicy == FILTER_MODE_WHITE) {
        $(".show_ip_filter_white").show();
        $(".show_ip_filter_black").hide();
    }
    else {
        $(".show_ip_filter_white").hide();
        $(".show_ip_filter_black").show();
    }
    
}

function onRadioChange()
{
   $('.user_add_line').remove();
   if($('.urlfilter_mode').length > 0) {
        if($("#blacklist_enable").get(0).checked) {
            g_new_filter_mode = FILTER_MODE_BLACK;
            showIPFiters(FILTER_MODE_BLACK);
        }
        else {
            g_new_filter_mode = FILTER_MODE_WHITE; 
            showIPFiters(FILTER_MODE_WHITE);
        }
    }

    button_enable('apply', '1');

    if(FILTER_MODE_BLACK == g_new_filter_mode)
    {
        if ($('.show_ip_filter_black').length >= LAN_IP_FILTER_NUM/2)
        {
            button_enable('add_item', '0');
        }
        else
        {
            button_enable('add_item', '1');
        }
    }
    else
    {
        if ($('.show_ip_filter_white').length >= LAN_IP_FILTER_NUM/2)
        {
            button_enable('add_item', '0');
        }
        else
        {
            button_enable('add_item', '1');
        }
    }
}

function initPage() {
    button_enable('apply', '0');

    $("#blacklist_enable").click(function(){
        onRadioChange();
    });
    $("#whitelist_enable").click(function(){
        onRadioChange();
    });
    $('.user_add_line').remove();
    getAjaxData('api/security/firewall-switch', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            firewall_status = ret.response;
        }
    }, {
        sync: true
    });
    getAjaxData('api/dhcp/settings', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            dhcpPageVar = ret.response;
            initDhcp();
        }
    });
    getAjaxData('api/security/lan-ip-filter', function($xml) {
        var ret = xml2object($xml);
        var filters = ret.response.IPFilters.IPFilter;
        g_filters = filters;
        var filterPolicy = parseInt(ret.response.FirewallIpFilterPolicy,10);
        var lanPort;
        var wanPort;
        var protocolStatus;
        var filterStatus;
        var lastFilter;
        var policyType;

        if (filters) {
            if ($.isArray(filters)) {
                $(filters).each( function(i) {
                    lanPort = portJoin(filters[i].LanIPFilterLanStartPort, filters[i].LanIPFilterLanEndPort);
                    wanPort = portJoin(filters[i].LanIPFilterWanStartPort, filters[i].LanIPFilterWanEndPort);

                    if(lanPort=='0'&&wanPort=='0') {
                        lanPort='';
                        wanPort='';
                    }

                    policyType = (0 == filters[i].LanIPFilterPolicy ? BLACK_URL:WHITE_URL);
                    protocolStatus = getDArrayElement(protocolStatusArray, filters[i].LanIPFilterProtocol, 'value');
                    filterStatus = getDArrayElement(filterStatusArray, filters[i].LanIPFilterStatus, 'value');
	                var LanIPAddress = XSSResolveCannotParseChar(filters[i].LanIPFilterLanStartAddress);
	                if(isValidIpv4Address(filters[i].LanIPFilterLanStartAddress, true)){
	                    LanIPAddress = ipTranGet(XSSResolveCannotParseChar(filters[i].LanIPFilterLanStartAddress), filters[i].LanIPFilterSrcStartIPMask);
	                }
	                var WANIPAddress = XSSResolveCannotParseChar(filters[i].LanIPFilterWanStartAddress);
	                if(isValidIpv4Address(filters[i].LanIPFilterWanStartAddress, false)){
	                    WANIPAddress = ipTranGet(XSSResolveCannotParseChar(filters[i].LanIPFilterWanStartAddress), filters[i].LanIPFilterDestStartIPMask);
	                }
                    if ('0' == g_config_firewall.lanipfilter.wan) {
                        addLanipFilter(
                        $('#service_list tr'),
                        policyType,
                        LanIPAddress,
                        lanPort,
                        protocolStatus,
                        filterStatus
                        );
                    } else if ('0' == g_config_firewall.lanipfilter.lan_enable) {
                        addLanipFilter(
                        $('#service_list tr'),
                            policyType,
                        WANIPAddress,
                        wanPort,
                        protocolStatus,
                        filterStatus
                        );
                    } else {
                        addLanipFilter(
                        $('#service_list tr'),
                            policyType,
                        LanIPAddress,
                        lanPort,
                        WANIPAddress,
                        wanPort,
                        protocolStatus,
                        filterStatus
                        );
                    }
                });
                lastFilter = filters[filters.length - 1];

            } else {
                lanPort = portJoin(filters.LanIPFilterLanStartPort, filters.LanIPFilterLanEndPort);
                wanPort = portJoin(filters.LanIPFilterWanStartPort, filters.LanIPFilterWanEndPort);

                if(lanPort=='0'&&wanPort=='0') {
                    lanPort='';
                    wanPort='';
                }

                protocolStatus = getDArrayElement(protocolStatusArray, filters.LanIPFilterProtocol, 'value');
                filterStatus = getDArrayElement(filterStatusArray, filters.LanIPFilterStatus, 'value');
                policyType = (0 == filters.LanIPFilterPolicy ? BLACK_URL:WHITE_URL);
				var LanIPAddress = XSSResolveCannotParseChar(filters.LanIPFilterLanStartAddress);
	            if(isValidIpv4Address(filters.LanIPFilterLanStartAddress, true)){
	                LanIPAddress = ipTranGet(XSSResolveCannotParseChar(filters.LanIPFilterLanStartAddress), filters.LanIPFilterSrcStartIPMask);
	            }
	            var WANIPAddress = XSSResolveCannotParseChar(filters.LanIPFilterWanStartAddress);
	            if(isValidIpv4Address(filters.LanIPFilterWanStartAddress, false)){
	                WANIPAddress = ipTranGet(XSSResolveCannotParseChar(filters.LanIPFilterWanStartAddress), filters.LanIPFilterDestStartIPMask);
	            }
                if ('0' == g_config_firewall.lanipfilter.wan) {
                    addLanipFilter(
                    $('#service_list tr'),
                        policyType,
                    LanIPAddress,
                    lanPort,
                    protocolStatus,
                    filterStatus
                    );
                } else if ('0' == g_config_firewall.lanipfilter.lan_enable) {
                    addLanipFilter(
                    $('#service_list tr'),
                        policyType,
                    WANIPAddress,
                    wanPort,
                    protocolStatus,
                    filterStatus
                    );
                } else {
                    addLanipFilter(
                    $('#service_list tr'),
                        policyType,
                    LanIPAddress,
                    lanPort,
                    WANIPAddress,
                    wanPort,
                    protocolStatus,
                    filterStatus
                    );
                }

                lastFilter = filters;
            }

            $('#input_lan_ip_address').val(lastFilter.LanIPFilterLanStartAddress);
            $('#input_lan_ip_port').val(lanPort);
            $('#input_wan_ip_address').val(lastFilter.LanIPFilterWanStartAddress);
            $('#input_wan_ip_port').val(wanPort);
        } else {
            $('#input_lan_ip_address').val("");
            $('#input_lan_ip_port').val("");
            $('#input_wan_ip_address').val("");
            $('#input_wan_ip_port').val("");
        }

        if (FILTER_MODE_BLACK === filterPolicy) {
            $("#blacklist_enable").get(0).checked = true;
            $("#whitelist_enable").get(0).checked = false;
            g_new_filter_mode = FILTER_MODE_BLACK;
        }
        else {
            $("#blacklist_enable").get(0).checked = false;
            $("#whitelist_enable").get(0).checked = true;
            g_new_filter_mode = FILTER_MODE_WHITE;
        }

        if(filterPolicy == FILTER_MODE_WHITE) {
            $(".show_ip_filter_white").show();
            $(".show_ip_filter_black").hide();
        }
        else {
            $(".show_ip_filter_white").hide();
            $(".show_ip_filter_black").show();
        }

        if(FILTER_MODE_BLACK == filterPolicy)
        {
            if ($('.show_ip_filter_black').length >= LAN_IP_FILTER_NUM/2)
            {
                button_enable('add_item', '0');
            }
        }
        else
        {
            if ($('.show_ip_filter_white').length >= LAN_IP_FILTER_NUM/2)
            {
               button_enable('add_item', '0');
            }
        }

        if (firewall_status != null && firewall_status.FirewallMainSwitch == 0) {
            button_enable('add_item', '0');
            $('#service_list').attr('disabled', true);
            $('.button_edit_list').removeClass('clr_blue').addClass('clr_gray');
            $('.button_delete_list').removeClass('clr_blue').addClass('clr_gray');
            $('input[name=radio]').attr('disabled', true);
            showInfoDialog(IDS_security_message_firewall_disabled);
            return false;
        }
        if (firewall_status != null &&
        firewall_status.FirewallIPFilterSwitch == 0) {
            button_enable('add_item', '0');
            $('#service_list').attr('disabled', true);
            $('.button_edit_list').removeClass('clr_blue').addClass('clr_gray');
            $('.button_delete_list').removeClass('clr_blue').addClass('clr_gray');
            $('input[name=radio]').attr('disabled', true);
            showInfoDialog(IDS_security_message_ip_address_disabled);
        }
    });
}

function lanIPFilter_getConfig() {
    LAN_IP_FILTER_NUM = parseInt(g_config_firewall.lanipfilter.number,10);
    if ('0' == g_config_firewall.lanipfilter.wan) {
        $('.wan_th').hide();
    } else {
        $('.wan_th').show();
    }

    if ('0' == g_config_firewall.lanipfilter.lan_enable) {
        $('.lan_th').hide();
    } else {
        $('.lan_th').show();
    }

    if ('0' == g_config_firewall.lanipfilter.protocol_imcp) {

        protocolStatusArray = [ [PROTOCOL_BOTH, firewall_label_tcp_or_udp],
        [PROTOCOL_TCP, firewall_label_tcp],
        [PROTOCOL_UDP, firewall_label_udp]];
    }
}

function checkBeforPostData() {
    var ret = true;
    $('.user_add_line').each( function(i) {
		if(isValidIpv4Address($(this).children().eq(0).text(), false)){
	        var wanIp = "";
	        if('0' != g_config_firewall.lanipfilter.lan_enable) {
	            wanIp = ipTranApply($(this).children().eq(2).text());
	        } else {
	            wanIp = ipTranApply($(this).children().eq(0).text());
	        }

	        if("" == wanIp) {
	            showInfoDialog(dialup_hint_ip_address_empty);
	            ret = false;
	        }
		}
    });
    return ret;
}
var subnetMask = null;
function lanIPFilter_getNetmask() {    
    getAjaxData('api/dhcp/settings', function($xml) {
        var ret = xml2object($xml);
        if(ret.type == 'response') {
            subnetMask = ret.response.DhcpLanNetmask;
        }
    });
}
$(document).ready( function() {
    lanIPFilter_getNetmask();
    lanIPFilter_getConfig();
    initPage();
    $('.user_options').attr('width','105');
    var currentAllVal = null;
    var editIndex = null;
    var editWanIpAddr = null;
    var editWanPort = null;
    var editProtocol = null;
    var editStatus = null;
    $('.button_edit_list').live('click', function() {
        if ((($(".add_item_control:hidden").size() > 0) && ($('#edit_item_ok').size() < 1))
        && ((firewall_status != null && firewall_status.FirewallMainSwitch == 1) && (firewall_status != null && firewall_status.FirewallIPFilterSwitch == 1))) {
            editIndex = $('.button_edit_list').index(this);
            // save the value before user edit
            currentAllVal = $('.user_add_line').eq(editIndex).html();
            var editLanIpFilter = $(this).parent().siblings();
            if('0' != g_config_firewall.lanipfilter.lan_enable) {
                var editLanIpAddr = editLanIpFilter.eq(0);
                var editLanPort = editLanIpFilter.eq(1);
                if('0' != g_config_firewall.lanipfilter.wan) {
                    editWanIpAddr = editLanIpFilter.eq(2);
                    editWanPort = editLanIpFilter.eq(3);
                    editProtocol = editLanIpFilter.eq(4);
                    editStatus = editLanIpFilter.eq(5);
                } else {
                    editProtocol = editLanIpFilter.eq(2);
                    editStatus = editLanIpFilter.eq(3);
                }

            } else {
                editWanIpAddr = editLanIpFilter.eq(0);
                editWanPort = editLanIpFilter.eq(1);
                editProtocol = editLanIpFilter.eq(2);
                editStatus = editLanIpFilter.eq(3);
            }

            var htmlProtocol = editProtocol.html();
            var htmlStatus = editStatus.html();
            if ('0' != g_config_firewall.lanipfilter.lan_enable) {
                editLanIpAddr.html('<input type="text" value="' + editLanIpAddr.html() + '" id="input_lan_ip_address"></td>');
                editLanPort.html('<input type="text" value="' + editLanPort.html() + '" id="input_lan_ip_port"></td>');
            }
            if ('0' != g_config_firewall.lanipfilter.wan) {
                editWanIpAddr.html('<input type="text" value="' + editWanIpAddr.html() + '" id="input_wan_ip_address"></td>');
                editWanPort.html('<input type="text" value="' + editWanPort.html() + '" id="input_wan_ip_port"></td>');
            }

            createSelect(editProtocol, 'select_protocol_status', protocolStatusArray);
            createSelect(editStatus, 'select_status', filterStatusArray);

            $('#select_protocol_status').val(getDArrayElement(protocolStatusArray, htmlProtocol, 'key'));
            $('#select_status').val(getDArrayElement(filterStatusArray, htmlStatus, 'key'));

            $(this).parent().html('<a class="clr_blue" id="edit_item_ok" href="javascript:void(0);">' + common_ok +
            '</a><a class="clr_blue" id="edit_item_cancel" href="javascript:void(0);">' + common_cancel + '</a>');

            hideAddItemControl();
            $('.user_add_line input').eq(0).focus();
            if($('#select_protocol_status').val()==1) {
                $('#input_lan_ip_port').val('');
                $('#input_wan_ip_port').val('');
                $('#input_lan_ip_port').attr('disabled', 'disabled');
                $('#input_wan_ip_port').attr('disabled', 'disabled');
            }
            $('#select_protocol_status').change( function() {
                if($('#select_protocol_status').val()==1) {
                    $('#input_lan_ip_port').val('');
                    $('#input_wan_ip_port').val('');
                    $('#input_lan_ip_port').attr('disabled', 'disabled');
                    $('#input_wan_ip_port').attr('disabled', 'disabled');
                } else {
                    $('#input_lan_ip_port').removeAttr('disabled');
                    $('#input_wan_ip_port').removeAttr('disabled');
                }
            });
            $('#edit_item_cancel').live('click', function() {
                $('.user_add_line').eq(editIndex).html(currentAllVal);
                $('.qtip').qtip('destroy');
                if (!isButtonEnable('add_item')) {
                    button_enable('add_item', '1');
                    $('input[name=radio]').attr('disabled', false);
                    if((1 == ok_flag) || (1 == add_flag)) {
                        button_enable('apply', '1');
                    }
                }
                if(FILTER_MODE_BLACK == g_new_filter_mode)
                {
                    if ($('.show_ip_filter_black').length >= LAN_IP_FILTER_NUM/2)
                    {
                        button_enable('add_item', '0');
                    }
                }
                else
                {
                    if ($('.show_ip_filter_white').length >= LAN_IP_FILTER_NUM/2)
                    {
                        button_enable('add_item', '0');
                    }
                }
            });
            $('#add_item').live('click', function() {
                if (isButtonEnable('add_item')) {
                    $('.user_add_line').eq(editIndex).html(currentAllVal);
                    $('.qtip').qtip('destroy');
                }
            });
            button_enable('apply', '0');
            button_enable('add_item', '0');
            $('input[name=radio]').attr('disabled', true);		
        }

    });

    /* BEGIN PN:DTS2014122701264 add by dwx270728 2015-03-10 */	
    function checkLanIPFilterData(lanAddress,lanPort,wanAddress,wanPort,serviceOption,statusOption)
    {
        var _lanAddress = '';
        var _lanPort = '';
        var _wanAddress = '';
        var _wanPort = '';
        var _serviceOption = '';
        var _statusOption = '';
        var RnFlag = true;
		if($("#whitelist_enable").get(0).checked){
            $('.user_add_line.show_ip_filter_white').each(function(i){
            _lanAddress = $(this).children().eq(0).text();
            _lanPort = $(this).children().eq(1).text();
            _wanAddress = $(this).children().eq(2).text();
            _wanPort = $(this).children().eq(3).text();
            _serviceOption = $(this).children().eq(4).text();
            _statusOption = $(this).children().eq(5).text();

            if((lanAddress.toLowerCase() == _lanAddress.toLowerCase())
            && (lanPort == _lanPort)
            && (wanAddress.toLowerCase() == _wanAddress.toLowerCase())
            && (wanPort == _wanPort)
            && (serviceOption == _serviceOption)
            && (statusOption == _statusOption))
            {
               showInfoDialog(IDS_security_lanfilter_repetition);
               RnFlag  = false;
               return false;//each() return 
            }
            }
            )
        }
        if($("#blacklist_enable").get(0).checked){
            $('.user_add_line.show_ip_filter_black').each(function(i){
            _lanAddress = $(this).children().eq(0).text();
            _lanPort = $(this).children().eq(1).text();
            _wanAddress = $(this).children().eq(2).text();
            _wanPort = $(this).children().eq(3).text();
            _serviceOption = $(this).children().eq(4).text();
            _statusOption = $(this).children().eq(5).text();

            if((lanAddress.toLowerCase() == _lanAddress.toLowerCase())
            && (lanPort == _lanPort)
            && (wanAddress.toLowerCase() == _wanAddress.toLowerCase())
            && (wanPort == _wanPort)
            && (serviceOption == _serviceOption)
            && (statusOption == _statusOption))
            {
               showInfoDialog(IDS_security_lanfilter_repetition);
               RnFlag  = false;
               return false;//each() return 
            }
            }
            )
        }
        return RnFlag;//checkLanIPFilterData() return 
    }
    /* END PN:  DTS2014122701264 add by dwx270728 2015-03-10 */	
	
    $('#edit_item_ok').live('click', function() {
        if (isVaildValue()) {
            var lanAddress = $.trim($('#input_lan_ip_address').val());
            var lanPort = $.trim($('#input_lan_ip_port').val());
            var wanAddress = $.trim($('#input_wan_ip_address').val());
            var wanPort = $.trim($('#input_wan_ip_port').val());
            var serviceOption = $('#select_protocol_status option:selected').text();
            var statusOption = $('#select_status option:selected').text();

            /* BEGIN PN:DTS2014122701264 add by dwx270728 2015-03-10 */		  
            if(!checkLanIPFilterData(lanAddress,lanPort,wanAddress,wanPort,serviceOption,statusOption))
            {
               return false;
            }
            /* END PN:  DTS2014122701264 add by dwx270728 2015-03-10 */

            hideAddItemControl();
            var editLanIpFilter = $(this).parent().siblings();
            if ('0' != g_config_firewall.lanipfilter.lan_enable) {
                editLanIpFilter.eq(0).html(lanAddress);
                editLanIpFilter.eq(1).html(lanPort);
                if('0' != g_config_firewall.lanipfilter.wan) {
                    editLanIpFilter.eq(2).html(wanAddress);
                    editLanIpFilter.eq(3).html(wanPort);
                    editLanIpFilter.eq(4).html(serviceOption);
                    editLanIpFilter.eq(5).html(statusOption);
                } else {
                    editLanIpFilter.eq(2).html(serviceOption);
                    editLanIpFilter.eq(3).html(statusOption);
                }

            } else {
                editLanIpFilter.eq(0).html(wanAddress);
                editLanIpFilter.eq(1).html(wanPort);
                editLanIpFilter.eq(2).html(serviceOption);
                editLanIpFilter.eq(3).html(statusOption);
            }

            $(this).parent().html('<span class=\"button_edit_list clr_blue\">' + common_edit +
            '</span><span class=\"button_delete_list clr_blue\">' + common_delete + '</span>');

            currentAllVal = $('.user_add_line').eq(editIndex).html();
            button_enable('apply', '1');
            button_enable('add_item', '1');
            $('input[name=radio]').attr('disabled', false);
            ok_flag = 1;
            if(FILTER_MODE_BLACK == g_new_filter_mode)
            {
                if ($('.show_ip_filter_black').length >= LAN_IP_FILTER_NUM/2)
                {
                    button_enable('add_item', '0');
                }
            }
            else
            {
                if ($('.show_ip_filter_white').length >= LAN_IP_FILTER_NUM/2)
                {
                    button_enable('add_item', '0');
                }
            }
        }
    });
    $('#add_item_ok').live('click', function() {
        if (isVaildValue()) {
            var lanAddress = $.trim($('#input_lan_ip_address').val());
            var lanPort = $.trim($('#input_lan_ip_port').val());
            var wanAddress = $.trim($('#input_wan_ip_address').val());
            var wanPort = $.trim($('#input_wan_ip_port').val());
            var serviceOption = $('#select_protocol_status option:selected').text();
            var statusOption = $('#select_status option:selected').text();
            lanAddress = XSSResolveCannotParseChar(lanAddress);
            wanAddress = XSSResolveCannotParseChar(wanAddress);

            /* BEGIN PN:DTS2014122701264 add by dwx270728 2015-03-10 */			
            if(!checkLanIPFilterData(lanAddress,lanPort,wanAddress,wanPort,serviceOption,statusOption))
            {
               return false;
            }	
            /* END PN:  DTS2014122701264 add by dwx270728 2015-03-10 */	    		
            
            hideAddItemControl();
            var policyType = (true == $("#blacklist_enable").get(0).checked ? BLACK_URL:WHITE_URL);

            if ('0' == g_config_firewall.lanipfilter.wan) {
                addLanipFilter($('#service_list tr'), policyType, lanAddress, lanPort, serviceOption, statusOption);
            } else if('0' == g_config_firewall.lanipfilter.lan_enable) {
                addLanipFilter($('#service_list tr'), policyType, wanAddress, wanPort, serviceOption, statusOption);
            } else {
                addLanipFilter($('#service_list tr'), policyType, lanAddress, lanPort, wanAddress, wanPort, serviceOption, statusOption);
            }

            button_enable('apply', '1');

            $('input[name=radio]').attr('disabled', false);
            if(FILTER_MODE_BLACK == g_new_filter_mode)
            {
                if ($('.show_ip_filter_black').length >= LAN_IP_FILTER_NUM/2)
                {
                    button_enable('add_item', '0');
                }
            }
            else
            {
                if ($('.show_ip_filter_white').length >= LAN_IP_FILTER_NUM/2)
                {
                    button_enable('add_item', '0');
                }
            }
            add_flag = 1;
        }
        return false;
    });
    //hide add item control
    $('#add_item_cancel').live('click', function() {
        hideAddItemControl();
        $('input[name=radio]').attr('disabled', false);
        if((1 == add_flag) || (1 == ok_flag)) {
            button_enable('apply', '1');
        }
        return false;
    });
    //show add item control
    $('#add_item').click( function() {
        if (isButtonEnable('add_item')) {
            showAddItemControl();
            $('.add_item_control input').eq(0).focus();
            button_enable('apply', '0');
            $('input[name=radio]').attr('disabled', true);
            $('#input_lan_ip_address').removeAttr('disabled');
            $('#input_lan_ip_port').removeAttr('disabled');
            $('#input_wan_ip_address').removeAttr('disabled');
            $('#input_wan_ip_port').removeAttr('disabled');
            if($('#select_protocol_status').val()==1) {
                $('#input_lan_ip_port').attr('disabled', 'disabled');
                $('#input_wan_ip_port').attr('disabled', 'disabled');
            }
        }
    });
    //if there hasn't any add or delete button it won't work
    $(".button_delete_list").live("click", function() {
        if($(".add_item_control:hidden").size() > 0 && $("#edit_item_ok").size() < 1
        && ((firewall_status != null && firewall_status.FirewallMainSwitch == 1) && (firewall_status != null && firewall_status.FirewallIPFilterSwitch == 1))) {
            var deleteIndex = $(".button_delete_list").index(this);
            call_dialog(common_delete, firewall_hint_delete_list_item, common_ok, "pop_OK", common_cancel, "pop_Cancel");
            $("#pop_OK").click( function() {
                deleteFilter(deleteIndex, $(".user_add_line"));
                clearDialog();
                button_enable("apply", "1");
                button_enable("add_item", "1");
                $('input[name=radio]').attr('disabled', false);
            });
        }
    });
    function postData() {
        var submitObject = {};
        var IPFilterArray = [];

        $('.show_ip_filter_black').each(function(i) {
            var lanPort = '';
            var wanPort = ['', ''];
            var lanIp = '';
            var wanIp = '';
            var lanIpMask = '';
            var wanIpMask = '';
            var submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(4).text(), 'key');
            var submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(5).text(), 'key');
            if ('0' == g_config_firewall.lanipfilter.lan_enable) {
                lanPort = portPartsParse('1-65535');
                lanIp = '0.0.0.0';
                lanIpMask = '4';
                wanPort = portPartsParse($(this).children().eq(1).text());
                wanIp = ipTranApply($(this).children().eq(0).text());
                wanIpMask = ipGetMaskNum($(this).children().eq(0).text());
                submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(2).text(), 'key');
                submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(3).text(), 'key');
            }
            else
            {
                var lanText = $(this).children().eq(0).text();
                if (isValidIpv6Address(lanText)) {
                    lanIp = lanText;
                    lanIpMask = 0;
                } else {
                    lanIp = ipTranApply(lanText);
                    lanIpMask = ipGetMaskNum(lanText);
                }
                lanPort = portPartsParse($(this).children().eq(1).text());
                if('1' == g_config_firewall.lanipfilter.wan)
                {
                    var wanText = $(this).children().eq(2).text();
                    if (isValidIpv6Address(wanText)) {
                        wanIp = wanText;
                        wanIpMask = 0;
                    } else {
                        wanIp = ipTranApply(wanText);
                        wanIpMask = ipGetMaskNum(wanText);
                    }
                    wanPort = portPartsParse($(this).children().eq(3).text());
                    submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(4).text(), 'key');
                    submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(5).text(), 'key');
                } else {
                    submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(2).text(), 'key');
                    submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(3).text(), 'key');
                }
            }

            var filter = {
                LanIPFilterProtocol: submitServerProtocol,
                LanIPFilterStatus: submitServerStatus,
                LanIPFilterLanStartAddress: lanIp,
                LanIPFilterLanEndAddress: '',
                LanIPFilterLanStartPort: lanPort[0],
                LanIPFilterLanEndPort: lanPort[1],
                LanIPFilterWanStartAddress: wanIp,
                LanIPFilterWanEndAddress: '',
                LanIPFilterWanStartPort: wanPort[0],
                LanIPFilterWanEndPort: wanPort[1],
                LanIPFilterSrcStartIPMask: lanIpMask,
                LanIPFilterDestStartIPMask: wanIpMask,
                LanIPFilterPolicy: '0'
            };
            IPFilterArray.push(filter);
        });

       $('.show_ip_filter_white').each(function(i) {
            var lanPort = '';
            var wanPort = ['', ''];
            var lanIp = '';
            var wanIp = '';
            var lanIpMask = '';
            var wanIpMask = '';
            var submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(4).text(), 'key');
            var submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(5).text(), 'key');
            if ('0' == g_config_firewall.lanipfilter.lan_enable)
            {
                lanPort = portPartsParse('1-65535');
                lanIp = '0.0.0.0';
                lanIpMask = '4';
                wanPort = portPartsParse($(this).children().eq(1).text());
                wanIp = ipTranApply($(this).children().eq(0).text());
                wanIpMask = ipGetMaskNum($(this).children().eq(0).text());
                submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(2).text(), 'key');
                submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(3).text(), 'key');
            }
            else
            {
                var lanText = $(this).children().eq(0).text();
                if (isValidIpv6Address(lanText)) {
                    lanIp = lanText;
                    lanIpMask = 0;
                } else {
                    lanIp = ipTranApply(lanText);
                    lanIpMask = ipGetMaskNum(lanText);
                }
                
                lanPort = portPartsParse($(this).children().eq(1).text());
                if('1' == g_config_firewall.lanipfilter.wan)
                {
                    var wanText = $(this).children().eq(2).text();
                    if (isValidIpv6Address(wanText)) {
                        wanIp = wanText;
                        wanIpMask = 0;
                    } else {
                        wanIp = ipTranApply(wanText);
                        wanIpMask = ipGetMaskNum(wanText);
                    }
                    wanPort = portPartsParse($(this).children().eq(3).text());
                    submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(4).text(), 'key');
                    submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(5).text(), 'key');
                }
                else
                {
                    submitServerProtocol = getDArrayElement(protocolStatusArray, $(this).children().eq(2).text(), 'key');
                    submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(3).text(), 'key');
                }
            }


            var filter = {
                LanIPFilterProtocol: submitServerProtocol,
                LanIPFilterStatus: submitServerStatus,
                LanIPFilterLanStartAddress: lanIp,
                LanIPFilterLanEndAddress: '',
                LanIPFilterLanStartPort: lanPort[0],
                LanIPFilterLanEndPort: lanPort[1],
                LanIPFilterWanStartAddress: wanIp,
                LanIPFilterWanEndAddress: '',
                LanIPFilterWanStartPort: wanPort[0],
                LanIPFilterWanEndPort: wanPort[1],
                LanIPFilterSrcStartIPMask: lanIpMask,
                LanIPFilterDestStartIPMask: wanIpMask,
                LanIPFilterPolicy: '1'
            };
            IPFilterArray.push(filter);
        });

        var policyType = (true == $("#blacklist_enable").get(0).checked ? FILTER_MODE_BLACK:FILTER_MODE_WHITE);
        submitObject = {
            FireWallLanIPFilterPolicy: policyType,
            IPFilters: {
                IPFilter: IPFilterArray
            }
        };
        var submitData = object2xml('request', submitObject);

        saveAjaxData('api/security/lan-ip-filter', submitData, function($xml) {
            var ret = xml2object($xml);
            if (isAjaxReturnOK(ret)) {
                UpdateIpFilter();
                showInfoDialog(common_success);
                button_enable('apply', '0');
            } else {
                showInfoDialog(common_failed);
                initPage();
            }
        });
    }

    $('#apply').click( function() {
        if (isButtonEnable('apply')) {
            if ('1' == g_config_firewall.lanipfilter.wan) {
                if(checkBeforPostData()) {
                    showConfirmDialog(firewall_hint_submit_list_item, postData);
                } else {
                    button_enable('apply', '0');
                }
            } else {
                showConfirmDialog(firewall_hint_submit_list_item, postData);
            }
        }
        ok_flag = 0;
        add_flag = 0;
    });
    initSelectOption('select_protocol_status', protocolStatusArray);
    initSelectOption('select_status', filterStatusArray);
    $('#select_protocol_status').change( function() {
        if($('#select_protocol_status').val()==1) {
            $('#input_lan_ip_port').val('');
            $('#input_wan_ip_port').val('');
            $('#input_lan_ip_port').attr('disabled', 'disabled');
            $('#input_wan_ip_port').attr('disabled', 'disabled');
        } else {
            $('#input_lan_ip_port').removeAttr('disabled');
            $('#input_wan_ip_port').removeAttr('disabled');
        }
    });
});