// JavaScript Document
var g_device_array = [];
var g_device_config = {};
var g_device_info = {};
var g_device_single = '';
var g_device_mode_2g = 0;
var g_device_mode_3g = 2;
var g_device_mode_4g = 7;
var g_device_single = '';
var g_device_mode = '';
var g_device_address = {};
var g_device_txpower = '';

function getDeviceInfo() {
	getAjaxData('api/monitoring/status', function($xml) {
		var ret = xml2object($xml);
		if (ret.type == 'response') {
			G_MonitoringStatus = ret;
		}
	}, {
		sync: true
	});
	getAjaxData('api/device/signal', function($xml) {
		var ret = xml2object($xml);
		if (ret.type == 'response') {
			g_device_single = ret ;
			g_device_mode = parseInt(g_device_single.response.mode, 10) ;
		}
	}, {
		sync: true
	});
	getAjaxData('api/device/txpower', function($xml) {
		var ret = xml2object($xml);
		if (ret.type == 'response') {
			g_device_txpower = ret ;
		}
	}, {
		sync: true
	});
	// get the ip address
	if(g_device_config.dhcpipaddress || g_device_config.dhcplannetmask){
		getAjaxData('api/dhcp/settings',function($xml){
			var ret = xml2object($xml);
			if(ret.type == 'response'){
				g_device_address = ret;
			}
		},{
			sync: true
		});
	}
	getAjaxData('api/device/information', function($xml) {
		var device_ret = xml2object($xml);
		if (device_ret.type == 'response') {
			g_device_info = device_ret.response;
			g_device_info.WanIPAddress = G_MonitoringStatus.response.WanIPAddress;
			g_device_info.WanIPv6Address = G_MonitoringStatus.response.WanIPv6Address;
			// make the address to g_device_info
			if(g_device_address.response){
			    g_device_info.DhcpIPAddress = g_device_address.response.DhcpIPAddress;
			    g_device_info.DhcpLanNetmask = g_device_address.response.DhcpLanNetmask;
			}
			if (g_device_mode == g_device_mode_2g || g_device_mode == g_device_mode_3g || g_device_mode == g_device_mode_4g) {
				g_device_info.pci = g_device_single.response.pci;
				g_device_info.sc = g_device_single.response.sc;
				g_device_info.cell_id = g_device_single.response.cell_id;
				g_device_info.rsrq = g_device_single.response.rsrq;
				g_device_info.rsrp = g_device_single.response.rsrp;
				g_device_info.rssi = g_device_single.response.rssi;
				g_device_info.sinr = g_device_single.response.sinr;
				g_device_info.rscp = g_device_single.response.rscp;
				g_device_info.ecio = g_device_single.response.ecio;
				g_device_info.stxPwr = g_device_txpower.response.stxPwr;
				g_device_info.sPuschPwr = g_device_txpower.response.sPuschPwr;
				g_device_info.sPucchPwr = g_device_txpower.response.sPucchPwr;
				g_device_info.sSrsPwr = g_device_txpower.response.sSrsPwr;
				g_device_info.sPrachPwr = g_device_txpower.response.sPrachPwr;		
				g_device_info.usUlMcs = g_device_txpower.response.usUlMcs;					
				g_device_info.usDlMcs = g_device_txpower.response.usDlMcs;
				g_device_info.usDlMcs1 = g_device_txpower.response.usDlMcs1;
				g_device_info.usUlEarfcn = g_device_txpower.response.usUlEarfcn;
				g_device_info.usDlEarfcn = g_device_txpower.response.usDlEarfcn;
				g_device_info.ucSubframeAssign = g_device_txpower.response.ucSubframeAssign;		
				g_device_info.ucSubframePatterns = g_device_txpower.response.ucSubframePatterns;		
				g_device_info.aucRrcStatus = g_device_txpower.response.aucRrcStatus;	
			}
		} else {
			log.error('Error, no data');
		}
	}, {
		sync: true
	});
}

function getDeviceConfig() {
	getConfigData('config/deviceinformation/config.xml', function($xml) {
		var config_ret = _xml2feature($xml);
        if ('undefined' !== config_ret && null !== config_ret)
        {
			g_device_config = config_ret;
		}
	}, {
		sync: true
	});
}

function createListForDevice(_name, _value) {
	var tdName = '';
	var values = common_unknown;
	var row = '';
	switch (_name) {
		case 'DeviceName':
			tdName = system_label_device_name;
			break;

		case 'SerialNumber':
			tdName = system_label_serial_number;
			break;

		case 'Imei':
			if (g_net_mode_status == MACRO_NET_MODE_W ) {
				if (g_device_info.Imei != '') {
					tdName =system_label_imei;
				}
			}
			break;

		case 'Imsi':
			tdName = device_information_imsi;
			break;

		case 'HardwareVersion':
			tdName = system_label_hardware_version;
			break;

		case 'SoftwareVersion':
			tdName = system_label_software_version;
			break;

		case 'WebUIVersion':
			tdName = system_label_webui_version;
			break;
		case 'MacAddress1':
			tdName = wlan_label_lan_mac_address;
			break;
		case 'MacAddress2':
			if (g_device_info.MacAddress2 != '') {
				tdName = wlan_label_wan_mac_address;
			}
			break;
		case 'Iccid':
			tdName = system_label_iccid;
			break;
		case 'Msisdn':
			tdName = system_label_my_number;
			break;
		case 'ProductFamily':
			tdName = system_label_product_family;
			break;
		case 'Classify':
			tdName = system_label_classify;
			break;
		case 'WanIPAddress':
			tdName = system_label_wanip_address;
			break;
		case 'Esn' :
			if (g_net_mode_status == MACRO_NET_MODE_C ) {
				if (g_device_info.Esn != '') {
					tdName = system_label_esn;
				}
			}
			break;
		case 'Meid' :
			if (g_net_mode_status == MACRO_NET_MODE_C ) {
				if(g_device_info.Esn != '' && g_device_info.Esn.charAt(0) == '8' && g_device_info.Esn.charAt(1) == '0' ) {
					tdName = system_label_meid;
				}
			}

			break;
		case 'WanIPv6Address':
			tdName = system_label_wan_IPv6_addr;
			break;
		/************************************* ******device_single */

		case 'pci':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_pci;
			}
			break;
		case 'sc':
			if (g_device_mode == g_device_mode_3g) {
				tdName = IDS_system_label_sc;
			}
			break;
		case 'cell_id':
			if(g_device_mode == g_device_mode_3g || g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_cell_id;
			}
			break;
		case 'rsrq':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_rsrq;
			}
			break;
		case 'rsrp':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_rsrp;
			}
			break;
		case 'rssi':
			if (g_device_mode == g_device_mode_2g || g_device_mode == g_device_mode_3g || g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_rssi;
			}
			break;
		case 'sinr':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_sinr;
			}
			break;
		case 'rscp':
			if (g_device_mode == g_device_mode_3g) {
				tdName = IDS_system_label_rscp;
			}
			break;
		case 'ecio':
			if (g_device_mode == g_device_mode_3g) {
				tdName = IDS_system_label_ecio;
			}
			break;
		case 'DhcpIPAddress':
			tdName = IDS_mac_setting_ip_address;
			break;
		case 'DhcpLanNetmask':
			tdName = IDS_mac_setting_subnet_mask;
			break;
		case 'stxPwr':
			if (g_device_mode == g_device_mode_2g || g_device_mode == g_device_mode_3g) {
				tdName = IDS_system_label_stxPwr;
			}
			break;
		case 'sPuschPwr':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_sPuschPwr;
			}
			break;
		case 'sPucchPwr':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_sPucchPwr;
			}
			break;
		case 'sSrsPwr':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_sSrsPwr;
			}
			break;
		case 'sPrachPwr':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_sPrachPwr;
			}
			break;
		case 'usUlMcs':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_usUlMcs;
			}
			break;
		case 'usDlMcs':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_usDlMcs;
			}
			break;
		case 'usDlMcs1':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_usDlMcs1;
			}
			break;
		case 'usUlEarfcn':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_usUlEarfcn;
			}
			break;
		case 'usDlEarfcn':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_usDlEarfcn;
			}
			break;
		case 'ucSubframeAssign':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_ucSubframeAssign;
			}
			break;
		case 'ucSubframePatterns':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_ucSubframePatterns;
			}
			break;
		case 'aucRrcStatus':
			if(g_device_mode == g_device_mode_4g) {
				tdName = IDS_system_label_aucRrcStatus;
			}
			break;		
		default:
			break;
	}
	if (tdName == '') {
		return row;
	}	
    if (tdName == system_label_my_number || tdName == wlan_label_wan_mac_address)
    {
		row = '<tr><td>' + tdName + common_colon + "</td><td class='info_value success_phone_number'>" + (_value == '' ? values : _value) + '</td></tr>';
    }
    else if(tdName == wlan_label_lan_mac_address)
    {
        	row = '<tr><td>' + tdName + common_colon + "</td><td class='info_value success_phone_number'>" + (_value == '' ? values : _value.toUpperCase()) + '</td></tr>'; 
    }
    else
    {
		row = '<tr><td>' + tdName + common_colon + "</td><td class='info_value'>" + (_value == '' ? values : _value) + '</td></tr>';
	}
	return row;

}

//Switch device info to display refrence device configuration xml
function setDeviceDisplay(_device_config, _device_info) {
	var list_content = '';
	var p = '';
	for (p in _device_info) {
		if (_device_config[p.toLowerCase()]) {
			if (typeof(_device_info[p]) != 'undefinded') {
				list_content += createListForDevice(p, _device_info[p]);
            }
            else {
				log.error("device dosen't exsited");
			}
		}
	}
	$('.diviceInfo_table').html(list_content);
}

function updateDeviceInfo () {
	if(g_net_mode_change ==  MACRO_NET_MODE_CHANGE) {
		getDeviceInfo();
		setDeviceDisplay(g_device_config, g_device_info);
		resetNetModeChange();
	}
}

getDeviceConfig();

$(document).ready( function() {
	getDeviceInfo();
	setDeviceDisplay(g_device_config, g_device_info);
	if(g_net_mode_type == MACRO_NET_DUAL_MODE) {
		addStatusListener('updateDeviceInfo ()');
	}
	$('#refresh').bind('click', function() {
		getDeviceInfo();
		setDeviceDisplay(g_device_config, g_device_info);
	});
});