var TIMER_INTERVAL = 6000;
var interval_ret = null;

function get_antenna_status() {
    getAjaxData('api/device/antenna_status',function($xml){
        var ret = xml2object($xml);
        if(ret.type == 'response'){
            var antenna1_status = (ret.response.antenna1_status == 0)? diagnosis_label_buildin:diagnosis_label_external;
            var antenna2_status = (ret.response.antenna2_status == 0)? diagnosis_label_buildin:diagnosis_label_external;
            $("#antenna1_state").text(antenna1_status);
            $("#antenna2_state").text(antenna2_status);
        }
    },{
        sync: true
    });
}

function get_antenna_mode() {
    getAjaxData('api/device/antenna_settings', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            $('#select_antenna_mode').val(ret.response.antenna_type);
            if('3' == ret.response.antenna_type) {
                interval_ret = setInterval(get_antenna_status,TIMER_INTERVAL);
            }
        }
    },{
        sync: true
    });
}

function addhintAntanna() {
    if('3'== $("#select_antenna_mode").val()) {
        $("#auto_antenna_note").show();
    }
    else {
        $("#auto_antenna_note").hide();
    }
}


function initPage() {
    if(null !=interval_ret) {
        clearInterval(interval_ret);
        interval_ret = null;
    }
    get_antenna_status();
    get_antenna_mode();
    addhintAntanna();
    button_enable("apply_button", 0);  
}

function onApply() {
    var antenna_mode = $("#select_antenna_mode").val();
    var data = { 
        antenna_type: antenna_mode 
    };
    var newXmlSetString = object2xml('request', data);
    saveAjaxData("api/device/antenna_settings", newXmlSetString, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            showInfoDialog(common_success);
            button_enable("apply_button", "0");
        }
        else {
            showInfoDialog(common_fail);
        }
        initPage();
    });
}

function onSelectAntannaMode() {
    button_enable("apply_button", 1);
    addhintAntanna();
}

$(document).ready(function() {
    initPage();
    $("#apply_button").click(function() {
        if(isButtonEnable('apply_button')) {
            onApply();
        }
    });
    $("#select_antenna_mode").bind("change", onSelectAntannaMode);
});