var g_advance = {};
var codec = [];

$(document).ready(function() {

    init_advance();

    $("#apply").click(function() {
        apply();
    });
    
});
function get_data() {
    g_advance.primarycodec = $.trim($('#codec_select1').val());
    g_advance.secondcodec = $.trim($('#codec_select2').val());
    g_advance.thirdcodec = $.trim($('#codec_select3').val());
    g_advance.fourthcodec = $.trim($('#codec_select4').val());
    g_advance.fifthcodec = $.trim($('#codec_select5').val());
    g_advance.sixthcodec = $.trim($('#codec_select6').val());
}

function set_data() {
    $('#codec_select1').val(g_advance.primarycodec);
    $('#codec_select2').val(g_advance.secondcodec);
    $('#codec_select3').val(g_advance.thirdcodec);
    $('#codec_select4').val(g_advance.fourthcodec);
    $('#codec_select5').val(g_advance.fifthcodec);
    $('#codec_select6').val(g_advance.sixthcodec);
}

function checkcodec()
{
    var codec1 = $.trim($('#codec_select1').val());
    var codec2 = $.trim($('#codec_select2').val());
    var codec3 = $.trim($('#codec_select3').val());
    var codec4 = $.trim($('#codec_select4').val());
    var codec5 = $.trim($('#codec_select5').val());
    var codec6 = $.trim($('#codec_select6').val());

    if (codec1 == codec2 || codec1 == codec3 || codec1 == codec4 || codec1 == codec5 || codec1 == codec6)
    {
        showErrorUnderTrEx('codec_select1', IDS_VOIP_SipCodecErrStr0);
        return false;
    }
    
    if (codec2 == codec3 || codec2 == codec4 || codec2 == codec5 || codec2 == codec6)
    {
        showErrorUnderTrEx('codec_select2', IDS_VOIP_SipCodecErrStr0);
        return false;
    }
    
    if (codec3 == codec4 || codec3 == codec5 || codec3 == codec6)
    {
        showErrorUnderTrEx('codec_select3', IDS_VOIP_SipCodecErrStr0);
        return false;
    }
    
    if (codec4 == codec5 || codec4 == codec6)
    {
        showErrorUnderTrEx('codec_select4', IDS_VOIP_SipCodecErrStr0);
        return false;
    }
    
    if (codec5 == codec6)
    {
        showErrorUnderTrEx('codec_select5', IDS_VOIP_SipCodecErrStr0);
        return false;
    }
}

function apply() {
    clearAllErrorLabel();

    if (false == checkcodec())
    {
        return false;
    }
    
    var submitObject = {};
    var codecArray = [];
    var codeitem1 = {
        index : codec[$.trim($('#codec_select1').val())],
        codec : $.trim($('#codec_select1').val()),
        priority: 1
    };
    
    var codeitem2 = {
        index : codec[$.trim($('#codec_select2').val())],
        codec : $.trim($('#codec_select2').val()),
        priority: 2
    };

    var codeitem3 = {
        index : codec[$.trim($('#codec_select3').val())],
        codec : $.trim($('#codec_select3').val()),
        priority: 3
    };

    var codeitem4 = {
        index : codec[$.trim($('#codec_select4').val())],
        codec : $.trim($('#codec_select4').val()),
        priority: 4
    };

    var codeitem5 = {
        index : codec[$.trim($('#codec_select5').val())],
        codec : $.trim($('#codec_select5').val()),
        priority: 5
    };

    var codeitem6 = {
        index : codec[$.trim($('#codec_select6').val())],
        codec : $.trim($('#codec_select6').val()),
        priority: 6
    };
    codecArray.push(codeitem1);
    codecArray.push(codeitem2);
    codecArray.push(codeitem3);
    codecArray.push(codeitem4);
    codecArray.push(codeitem5);
    codecArray.push(codeitem6);
    submitObject = {
        codec : codecArray
    };
    
    var submitData = object2xml('request', submitObject);
    saveAjaxData('api/voice/advancecodec', submitData, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            init_advance();
            showInfoDialog(common_success);
        } else {
            showInfoDialog(common_failed);
            initPage();
        }
    });
}

function init_advance() {
    getAjaxData('api/voice/advancecodec', function($xml) {
        var cap_ret = xml2object($xml);
        if ('response' == cap_ret.type) {                        
            if (null != cap_ret.response.codec) {
                var codeclist = CreateArray(cap_ret.response.codec);
                $(codeclist).each( function(i) {
                    priority = XSSResolveCannotParseChar(codeclist[i].priority);
                    codec[codeclist[i].codec] = codeclist[i].index;
                    if (1 == priority)
                    {
                        g_advance.primarycodec = codeclist[i].codec;
                    }
                    else if (2 == priority)
                    {
                        g_advance.secondcodec = codeclist[i].codec;
                    }
                    else if (3 == priority)
                    {
                        g_advance.thirdcodec = codeclist[i].codec;
                    }
                    else if (4 == priority)
                    {
                        g_advance.fourthcodec = codeclist[i].codec;
                    }
                    else if (5 == priority)
                    {
                        g_advance.fifthcodec = codeclist[i].codec;
                    }
                    else if (6 == priority)
                    {
                        g_advance.sixthcodec = codeclist[i].codec;
                    }
                });
            } 
            else 
            {
                g_advance.primarycodec = "";
                g_advance.secondcodec = "";
                g_advance.thirdcodec = "";
                g_advance.fourthcodec = "";
                g_advance.fifthcodec = "";
                g_advance.sixthcodec = "";
            }

            set_data();
        }
    }, {
        sync : true
    });
}

