var ListInfo = null;
var PostInfo = [];
var currIndex = 0;

var RANGE_OK = 0;
var COMMON_ERROR = 1;
var ORDER_ERROR = 2;


function isSameSubnetAddrs(Ip1, Ip2, mask)
{
    addrParts1 = Ip1.split(".");
    addrParts2 = Ip2.split(".");
    maskParts = mask.split(".");
    for(i=0; i<4; i++)
    {
        if(((Number(addrParts1[i]))&(Number(maskParts[i])))
            != ((Number(addrParts2[i]))&(Number(maskParts[i]))))
        {
            return false;
        }
    }
    return true;
}

function ipAddress2DecNum(address)
{
    var addrParts = address.split('.');
    var num = 0;

    for (i = 0; i < 4; i++)
    {
        num += parseInt(addrParts[i], 10) * Math.pow(256, 3 - i);
    }
    return num;
}

function isHostIpAddress(Ip, Mask)
{
    var addr = ipAddress2DecNum(Ip);
    var mask = ipAddress2DecNum(Mask);
    if ((0 == (addr & (~mask))) || ((~mask) == (addr & (~mask))) )
    {
        return false;
    }
    return true;
}

function getStatus(status)
{
    return (1 == status)?(acl_AclEnable):(acl_AclDisable);
}

function getDirection(direction)
{
    return (("WAN" == direction)?("Internet"):(direction));
}

function getRealDirection(direction)
{
    return (("Internet" == direction)?("WAN"):(direction));
}

function getRealAction(action)
{
    return ((acl_AclAccept == action)?("accept"):("drop"));
}

function getRealStatus(status)
{
    return (("Enabled" == status)?('1'):('0'));
}

function getRealStatusEn(status)
{
    return (("Enable" == status)?('1'):('0'));
}

function aclLoadform()
{
    var j=0;
    var innerHTML = '<table class="table_list">\n';
    innerHTML += '<tr >\n';
    innerHTML += '<th>' + acl_ACLIndex + '<\/th>\n';
    innerHTML += '<th>' + acl_ServiceProc + '<\/th>\n';
    innerHTML += '<th>' + acl_AccessDirection + '<\/th>\n';
    innerHTML += '<th>' + acl_IpRange + '<\/th>\n';
    innerHTML += '<th>' + acl_AclActionName + '<\/th>\n';
    innerHTML += '<th>' + acl_Status + '<\/th>\n';
    innerHTML += '<th>' + acl_ACLOption + '<\/th>\n';
    innerHTML += '<\/tr>\n';

    for (var i = 0; i < ListInfo.length; i++)
    {
        // these protol types maybe not safe, so filter them
        if(("ACS" === ListInfo[i].service)
            ||("SAMBA" === ListInfo[i].service)
            ||("TELNET" === ListInfo[i].service)
            ||("SSH" === ListInfo[i].service)
            ||("FTP" === ListInfo[i].service))
        {
            continue;
        }

        PostInfo.push(ListInfo[i]);

        innerHTML += '<TR id="record_' + i +'" class="acl_content_list" >\n';
        innerHTML += '<TD class="module_content_td_right_border">' + (j+1) + '<\/TD>\n';
        innerHTML += '<TD class="module_content_td_right_border">' + ListInfo[i].service + '<\/TD>\n';
        innerHTML += '<TD class="module_content_td_right_border">' + getDirection(ListInfo[i].direction) + '<\/TD>\n';
        j++;

        if (ListInfo[i].startip == ListInfo[i].endip)
        {
            if('' === ListInfo[i].startip)
            {
                innerHTML += '<TD class="module_content_td_right_border">' + '&nbsp;' + '<\/TD>\n';
            }
            else
            {
                innerHTML += '<TD class="module_content_td_right_border">' + ListInfo[i].startip + '<\/TD>\n';
            }
        }
        else
        {
            innerHTML += '<TD class="module_content_td_right_border">' + ListInfo[i].startip;
            innerHTML += '-' + ListInfo[i].endip + '<\/TD>\n';
        }

        if("WAN" == ListInfo[i].direction)
        {
            innerHTML += '<TD class="module_content_td_right_border">' + acl_AclAccept + '<\/TD>\n';
        }
        else if("LAN" == ListInfo[i].direction)
        {
            innerHTML += '<TD class="module_content_td_right_border">' + acl_AclDrop + '<\/TD>\n';
        }

        innerHTML += '<TD class="module_content_td_right_border">' + getStatus(ListInfo[i].status) + '<\/TD>\n';

        innerHTML += '<TD class="user_options clr_blue_hover" align="center">';
        innerHTML += '<span class="button_edit_list clr_blue">';
        innerHTML += acl_ACLEdit + '<\/span><\/TD>\n';
        innerHTML += '<\/TR>\n';
    }
    innerHTML += '<\/table>\n';
    $('#list_div').html(innerHTML);
    $('#formEditTable').hide();
}

function aclinitPage()
{
    ListInfo = null;
    PostInfo = [];
    currIndex = 0;

    // get lan ip address and net mask info
    getAjaxData('api/dhcp/settings', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            dhcpPageVar = ret.response;
            initDhcp();
        }
    });

    // read acl rule list from sdk
    getAjaxData('api/security/acls', function($xml) {
        var ret = xml2object($xml);
        if ('response' == ret.type)
        {
            ListInfo = ret.response.acls.acl;
        }
    }, {
        sync: true
    });

    // update the page display
    aclLoadform();
}

function getSplitStr(inputStr)
{
    var aftersplit = null;
    aftersplit = inputStr.split('-');
    return aftersplit;
}

function isNeedSpit(inputStr)
{
    if(inputStr.indexOf('-') >= 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

function filterBlank(inputStr)
{
    var tmpValue = inputStr;
    tmpValue = tmpValue.replace(/^[ ]*/, "") ;
    tmpValue = tmpValue.replace(/[ ]*$/, "") ;
    return tmpValue;
}

function ipv6compare(startIp, endIp){
	
	startIp = startIp.toLowerCase(); 
	endIp = endIp.toLowerCase(); 
	if((true === isValidIpv6Address(startIp) && true === isValidIpv6Address(endIp))){
	   var sc1 = startIp.split(":");
	   var sc2 = endIp.split(":");
	    if(sc1.length<8)
		{
			var rep = "::";
			for(var k=0;k<8-sc1.length;k++)
			{
			rep = rep+":";
			}
			startIp.replace("::", rep);
			sc1 = startIp.split(":");
		}
		if(sc2.length<8)
		{
			var rep = "::";
			for(var k=0;k<8-sc2.length;k++)
			{
			rep = rep+":";
			}
			endIp.replace("::", rep);
			sc2 = endIp.split(":");
		}
	   for(var i=0;i<sc1.length;i++){
	        if(sc1[i] == sc2[i]){
	             continue;
	        }
			if(sc1[i]=="")
			{
			return true;
			}
			if(sc2[i]=="")
			{
			return false;
			}

			var slength = 4-sc1[i].length;
			if(slength>0)
			{
				for(var n=0;n<slength;n++)
				{
					sc1[i] = "0" + sc1[i];
				}
			}

			slength = 4-sc2[i].length;
			if(slength>0)
			{
				for(var n=0;n<slength;n++)
				{
					sc2[i] = "0" + sc2[i];
				}
			}

			for(var j=0;j<sc1[i].length;j++)
			{
				var result = sc1[i][j].charCodeAt(0)-sc2[i][j].charCodeAt(0);
				if(result >0)
				{
				return false
				}
				else if(result<0)
				{
				return true;
				}
			}
		} 
		return true;
	}
}

function checkIpRange(startIp, endIp)
{
    if(startIp != endIp)
	{
	     if(('' === startIp) || ('' === endIp))
	     {
	         return COMMON_ERROR;
	     }
	     else if((true === isValidIpAddress(startIp) && true === isValidIpAddress(endIp))){
		     if(ipAddress2DecNum(startIp) > ipAddress2DecNum(endIp))
	         {
	             return ORDER_ERROR;
	         }
  	     } 
	}
	
    if(('' !== startIp) && ('' !== endIp))
    {
        if ((true === isValidIpAddress(startIp) && true === isValidIpAddress(endIp)) || (true === isValidIpv6Address(startIp) && true === isValidIpv6Address(endIp)))
        {
            return RANGE_OK;
        }
    }
	
    if('' !== startIp)
    {
        if (false === isValidIpAddress(startIp) && false === isValidIpv6Address(startIp))
        {
            return COMMON_ERROR;
        }
    }

    if('' !== endIp)
    {
        if (false === isValidIpAddress(endIp) && false === isValidIpv6Address(endIp))
        {
            return COMMON_ERROR;
        }
    }

    return RANGE_OK;
}

function checkSameSubnet(direction, startIp, endIp)
{
    if ("WAN" == direction)
    {
        if (isSameSubnetAddrs(startIp, dhcpLanIPAddress, dhcpLanNetmask))
        {
            return false;
        }
        if (isSameSubnetAddrs(endIp, dhcpLanIPAddress, dhcpLanNetmask))
        {
            return false;
        }
    }
    else if("LAN" == direction)
    {
        if ('' !== startIp)
        {
            if((ipAddress2DecNum(startIp)<= ipAddress2DecNum(dhcpLanIPAddress))
                && (ipAddress2DecNum(endIp) >= ipAddress2DecNum(dhcpLanIPAddress)))
            {
               return false;
            }

            if ((isHostIpAddress(startIp,dhcpLanNetmask) === false)
                || (isHostIpAddress(endIp,dhcpLanNetmask) === false))
            {
                return false;
            }

            if ((!isSameSubnetAddrs(startIp, dhcpLanIPAddress, dhcpLanNetmask))
                || (!isSameSubnetAddrs(endIp, dhcpLanIPAddress, dhcpLanNetmask)))
            {
                return false;
            }
        }
    }

    return true;
}

function checkAclRuleIsEmpty(acl) {
    if (acl.startip === '' && acl.endip === '') {
        return true;
    }
    return false;
}

function checkSameAclRule(acls) {
    for (var i = 0, len = acls.length; i < len - 1; i++) {
        for (var j = i + 1; j < len; j++) {
            if (checkAclRuleIsEmpty(acls[i]) || checkAclRuleIsEmpty(acls[j])) {
                continue;
            }
            // Check whether there is a repeat acl rule.
            if (acls[i].service === acls[j].service && acls[i].startip === acls[j].startip && acls[i].endip === acls[j].endip) {
                return true;
            }
        }
    }
    return false;
}
function postData() 
{
    var submitObject = {};
    var AclRuleArray = [];
    var isError = false;
    
    // push all rules into post data
    $('.acl_content_list').each( function(i)
    {
        // if current rule is editing, then use current input as post data, otherwise use orig data from sdk
        if (i == currIndex)
        {
            var rowService = $('#service_type_input_display').text();
            var rowDirection = $('#access_dir_input_display').text();
            var rowIpRange = $('#ip_address_input').val();
            var rowAction = $('#packet_action_display').text();
            var rowStatus = $('#status_input').val();

            var rowStartIp = '';
            var rowEndIp = '';
            var split = null;

            if (true === isNeedSpit(rowIpRange))
            {
                split = getSplitStr(rowIpRange);
                if( (split.length > 2) || ('' === filterBlank(split[1])) || ('' === filterBlank(split[0])) )
                {
                    showInfoDialog(acl_ipfilter_gErrStr102);
                    isError = true;
                    return;
                }

                rowStartIp = filterBlank(split[0]);
                rowEndIp   = filterBlank(split[1]);
            }
            else
            {
                rowStartIp = filterBlank(rowIpRange);
                rowEndIp   = rowStartIp;
            }

            // check ip range
            switch( checkIpRange(rowStartIp, rowEndIp) ) 
            {
                case RANGE_OK:
                    break;
                case COMMON_ERROR:
                    showInfoDialog(acl_ipfilter_gErrStr102);
                    isError = true;
                    return;
                case ORDER_ERROR:
                    showInfoDialog(dhcp_hint_end_ip_greater_start_ip);
                    isError = true;
                    return;
                default:
                    isError = true;
                    return;
            }

	    if (false === ipv6compare(rowStartIp, rowEndIp))
	    {
	         showInfoDialog(dhcp_hint_end_ip_greater_start_ip);
                isError = true;
                return;
	     }
	     
            // check same subnet
            if (true === isValidIpAddress(rowStartIp) && false === checkSameSubnet(getRealDirection(rowDirection), rowStartIp, rowEndIp))
            {
                showInfoDialog(acl_ipfilter_gErrStr102);
                isError = true;
                return;
            }

            var aclRule = 
            {
                service: rowService,
                direction: getRealDirection(rowDirection),
                startip: rowStartIp,
                endip: rowEndIp,
                action: getRealAction(rowAction),
                status: getRealStatusEn(rowStatus)
            };
        }
        else
        {
            var aclRule = 
            {
                service: PostInfo[i].service,
                direction: PostInfo[i].direction,
                startip: PostInfo[i].startip,
                endip: PostInfo[i].endip,
                action: PostInfo[i].action,
                status: PostInfo[i].status
            };
        }

        AclRuleArray.push(aclRule);
    });

    if (isError) {
        return;
    }
    if (checkSameAclRule(AclRuleArray)) {
        showInfoDialog(IDS_security_lanfilter_repetition);
        return;
    }
    submitObject = 
    {
        acls: 
        {
            acl: AclRuleArray
        }
    };
    var submitData = object2xml('request', submitObject);

    // send post data to sdk, only one rule will be modified once time
    saveAjaxData('api/security/acls', submitData, function($xml) 
    {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) 
        {
            showInfoDialog(common_success);
        } 
        else 
        {
            showInfoDialog(common_failed);
        }
        aclinitPage();
    });
}

$(document).ready(function()
{
    aclinitPage();

    // submit button click event
	$('#acl_submit_btn').click(function()
    {
        showConfirmDialog(firewall_hint_submit_list_item, postData);
    });

    // edit button click event
    $('.button_edit_list').live('click', function() 
    {
        // show the setting area
        $('#formEditTable').show();
        $(this).removeClass('clr_blue').addClass('clr_gray');

        // fill in data of current index
        currIndex = $('.button_edit_list').index(this);
        var editAcl = $(this).parent().siblings();
        var editService = editAcl.eq(1);
        var editDirection = editAcl.eq(2);
        var editIpRange = editAcl.eq(3);
        var editAction = editAcl.eq(4);
        var editStatus = editAcl.eq(5);
        var space_ptn = /&nbsp;/ig;

        $('#service_type_input_display').text(editService.html());
        $('#access_dir_input_display').text(editDirection.html());
        $('#ip_address_input').val(editIpRange.html().replace(space_ptn, ""));
        $('#packet_action_display').text(editAction.html());
        if (acl_AclEnable == editStatus.html())
        {
            $('#status_input option[value="Enable"]').attr("selected", true);
        }
        else
        {
            $('#status_input option[value="Disable"]').attr("selected", true);
        }
    });
});

