#!/bin/sh

root_path=`pwd`
output="$root_path/output_img"
mount_path="$root_path/MOBILE_CONNECT"
common_path="WebApp/common"
file_list_common="version css html js language lib res autorun factory favicon.ico"
file_list_e5="small"
file_list_hilink=""
is_mount_iso=0
need_gz_ui=0

function mount_iso_for_hilink()
{
    if  [ ! -e $root_path/MOBILE_CONNECT.iso ]
    then
        echo "error: $root_path/MOBILE_CONNECT.iso not exist "
        exit 1 
    fi

    grep "$mount_path" /proc/mounts
    if [ $? -eq 0 ]
    then
        is_mount_iso=1
        rm -f $output/MobileBrServ.zip
        rm -f $output/HiLink.app.zip
        rm -f $output/linux_mbb_install.zip
    else
        rm -rf $mount_path 
        mkdir -p $mount_path
        sudo mount -o rw,loop $root_path/MOBILE_CONNECT.iso $mount_path 
        if [ $? -eq 0 ]
        then
            is_mount_iso=1
        else
            echo "error: cannot mount $root_path/MOBILE_CONNECT.iso"
            exit 1
        fi
    fi

}


function clean_output()
{
    sudo rm -rf $output/HiLink.app
    sudo rm -rf $output/linux_mbb_install
    sudo rm -rf $output/MobileBrServ
    rm -rf $output
}

function clean_iso_tmp_file()
{
    rm $output/HiLink.app.zip
    rm $output/linux_mbb_install.zip
    rm $output/MobileBrServ.zip
    sudo rm -rf $output/HiLink.app
    sudo rm -rf $output/linux_mbb_install
    sudo rm -rf $output/MobileBrServ
    sudo umount $mount_path
    rm -rf $mount_path 
}

function copy_res()
{
    local tmp_dir_src=$root_path/$1/$common_path
    local tmp_dir_des=$output/$2/webroot/$common_path
    local i=""
    local product="" 

    local prefix_e5=""
    local prefix_e5_len=2
    local prefix_ec5=""
    local prefix_ec5_len=3

    prefix_e5=`echo $2 | cut -b 1-$prefix_e5_len | tr [:upper:] [:lower:]`
    prefix_ec5=`echo $2 | cut -b 1-$prefix_ec5_len | tr [:upper:] [:lower:]`

    if [ x"$prefix_e5" = x"e5" -o x"$prefix_ec5" = x"ec5" ]
    then
        product="e5"
    else
        product="hilink"
    fi

    if [ -e $output/$2 ]
    then
        rm -rf $output/$2
    fi

    mkdir -p $tmp_dir_des
    mkdir -p $tmp_dir_des/tools

    if [ -e $output/$2/webroot/data ]
    then
        rm -rf $output/$2/webroot/data
    fi
    ln -s /data $output/$2/webroot/data

    cp -rf $root_path/$1/upnp $output/$2/webroot
    cp -rf  $tmp_dir_src/config_$2 $tmp_dir_des/config 
    cp -rf  $tmp_dir_src/tools/yuicompressor-2.4.6.jar $tmp_dir_des/tools/yuicompressor-2.4.6.jar

    for i in $file_list_common 
    do
        cp -rf $tmp_dir_src/$i $tmp_dir_des/$i
    done

    if [ x"$product" = x"e5" ]
    then
        for i in $file_list_e5
        do
            cp -rf $tmp_dir_src/$i $tmp_dir_des/$i
        done
	if [ -d $tmp_dir_src/usermanual_$2  ]
	then
	    cp -rf $tmp_dir_src/usermanual_$2 $tmp_dir_des/usermanual
	fi

    else
        if [ $is_mount_iso -eq 0 ]
        then
            mount_iso_for_hilink
            is_mount_iso=1
        fi

        if [ ! -e MobileBrServ.zip ]
        then
            sudo cp -rf $mount_path/MobileBrServ/ $output/
            local tmp_p=`pwd`
            cd $output
            7z a MobileBrServ.zip ./MobileBrServ/
            cd $tmp_p
        fi

        if [ ! -e HiLink.app.zip ]
        then
            sudo cp -rf $mount_path/HiLink.app/ $output/
            local tmp_p=`pwd`
            cd $output
            7z a HiLink.app.zip ./HiLink.app/
            cd $tmp_p
        fi

        if [ ! -e linux_mbb_install.zip ]
        then
            sudo cp -rf $mount_path/linux_mbb_install/ $output/
            local tmp_p=`pwd`
            cd $output
            7z a linux_mbb_install.zip ./linux_mbb_install/
            cd $tmp_p
        fi

        rm -rf $tmp_dir_des/autorun/*
        cp $output/MobileBrServ.zip $tmp_dir_des/autorun/MobileBrServ.zip 
        cp $output/HiLink.app.zip $tmp_dir_des/autorun/HiLink.app.zip 
        cp $output/linux_mbb_install.zip $tmp_dir_des/autorun/linux_mbb_install.zip 

        cp $mount_path/* $tmp_dir_des/autorun/

	if [ -d $tmp_dir_src/usermanual_$2  ]
	then
	    cp -rf $tmp_dir_src/usermanual_$2 $tmp_dir_des/usermanual
	elif [ -d $tmp_dir_src/usermanual_hilink ]
	then
	    cp -rf $tmp_dir_src/usermanual_hilink $tmp_dir_des/usermanual
	fi

    fi


    echo -------------------

    cp $tmp_dir_des/version/version.xml $tmp_dir_des/config
    rm -rf $tmp_dir_des/version 
    rm $tmp_dir_des/language/*.xls

    java -jar $output/$2/webroot/WebApp/common/tools/yuicompressor-2.4.6.jar -o  \
            $output/$2/webroot/WebApp/common/lib/jquery.qtip.js \
            $output/$2/webroot/WebApp/common/lib/jquery.qtip.js

    java -jar $output/$2/webroot/WebApp/common/tools/yuicompressor-2.4.6.jar -o \
            $output/$2/webroot/WebApp/common/lib/jquery.form.js \
            $output/$2/webroot/WebApp/common/lib/jquery.form.js

}

function find_product_and_makeimg()
{
    local tmp_dir=$root_path/$1/$common_path
    local tmp_len=`expr length "config_"`
    local i=""
    local tmp_pwd=""

    echo $tmp_len
    let "tmp_len+=1"
    local tmp=`ls -d $tmp_dir/config_* | awk -F'/' '{print $NF}'|cut -b $tmp_len-`
    echo $tmp
    for i in $tmp
    do
        echo $i
        if [ -n "$2" -a x"$i" != x"$2" ]
        then
            continue
        fi

        if [ -e $i ]
        then
            rm -rf $i
        fi
        copy_res $1 "$i"
        tmp_pwd=`pwd`
        cd $output/$i
        if [ $need_gz_ui -eq 1 ]
        then
            $root_path/gzip_webui.sh webroot >&2
        fi
        7z a WebUI.zip webroot
        $root_path/mkyaffs2image webroot WebUI.img &>/dev/null
       # rm webroot -rf
        cd $tmp_pwd 

    done

    echo ""
}



TEMP=`getopt -o p:z --long product-name:zip -- "$@"`


if [ $? != 0 ]  
then 
    echo "Terminating..." >&2  
    exit 1  
fi

eval set -- "$TEMP"

product_name=""
webui_dir=""

while true ; do
    case "$1" in
        -p|--product-name) 
            product_name=$2 ;
            shift 2 ;;
        -z|--zip) 
            need_gz_ui=1 ;
            shift ;;
        --) shift ; break ;;
        *) echo "Internal error~" ; exit 1 ;;
    esac
done


for arg 
do 
    webui_dir=$arg
    find $webui_dir -name .svn |xargs rm -rf  
    clean_output
    find_product_and_makeimg $webui_dir $product_name
    break
done

if [ x"$webui_dir" = x"" ]
then
#    echo "usage: $0 -p [productname] webuifolder"
    echo "usage: $0  webuifolder"
    echo "forexample: $0 webroot"
    exit -1
elif [ "$is_mount_iso" -eq 1 ] 
then
    clean_iso_tmp_file
fi


exit 0

case "$product_name" in
    "e5") echo "product is e5"; shift 2 ;;
    "hilink") echo "product is Hilnk"; shift 2 ;;
    *)  echo "product is '$2'" ; shift 2 ;;
esac 
