#!/bin/sh

export USER_ROOT=/home/z00169309

export UI_HOME=$USER_ROOT/websdk_UI

export WEBSDK_ROOT=$USER_ROOT/ci-stick

export SO_HOME=$USER_ROOT/stack_so

AUTORUN_ROOT=$USER_ROOT/autorun

cd $WEBSDK_ROOT

rm -rf $WEBSDK_ROOT/tar_data_update/*

./TAR_DATA_UPDATE.sh

cd tar_data_update

tar -xzvf Hilink_TAR.tar.gz

cp ../mkyaffs2image ./

mv app/webroot/ webroot

cp $AUTORUN_ROOT/MOBILE_CONNECT.iso ./

7z x MOBILE_CONNECT.iso -o./MOBILE_CONNECT/

#./mkyaffs2image MOBILE_CONNECT MOBILE_CONNECT.img

mv ./MOBILE_CONNECT/MobileBrServ ./MobileBrServ
mv ./MOBILE_CONNECT/HiLink.app ./HiLink.app
mv ./MOBILE_CONNECT/linux_mbb_install ./linux_mbb_install

7z a MobileBrServ.zip ./MobileBrServ/
7z a HiLink.app.zip ./HiLink.app/
7z a linux_mbb_install.zip ./linux_mbb_install/

rm -rf ./webroot/WebApp/common/autorun/*

cp MobileBrServ.zip ./webroot/WebApp/common/autorun/
cp HiLink.app.zip ./webroot/WebApp/common/autorun/
cp linux_mbb_install.zip ./webroot/WebApp/common/autorun/

cp ./MOBILE_CONNECT/* ./webroot/WebApp/common/autorun/

../gzip_webui.sh ./webroot >&2

7z a WebUI.zip ./webroot

./mkyaffs2image app APP_HiLink.img

./mkyaffs2image webroot WebUI.img

chmod 777 APP_HiLink.img

chmod 777 WebUI.img

chmod 777 WebUI.zip

chmod 777 Hilink_TAR.tar.gz

mkdir img

mv APP_HiLink.img img

mv WebUI.img img

mv WebUI.zip img

mv Hilink_TAR.tar.gz img

cp -rf ./img ./APP_img_bak
