#!/bin/sh

TMPDIR="./webroot"
rIPFILE="webui.zip"
gall=0
gCss=0
gJs=0
gHtml=0

function compress()
{
    if [ -f $1.gz ]
    then
        echo "warning: $PWD/$1.gz has been exist! overwrite it"
    fi
    gzip -f $1
    let "gall+=1"
}

function foreachd()
{
    for file in *
        do
        if [ -d "$file" ] 
        then
            local tmp_dir=`pwd`
            cd $file
            foreachd 
            cd $tmp_dir 
        elif [ -f "$file" ]
        then 
            f=`echo "$file" | awk -F "." '{print $NF}'`
            if [ "$f" = "css" ]
            then
                let "gCss+=1"
                compress $file
            elif [ "$f" = "js" ]
            then
                let "gJs+=1"
                compress $file
            elif [ "$f" = "html" ]
            then
                let "gHtml+=1"
                compress $file
            fi

#		if [ "$f" = "html" -o "$f" = "css" -o "$f" = "js" ]
            #gzip -c $file> ${file}.gz
        fi
          
        done

}

function echo_statitics()
{
    echo ""
    echo "--------------------$1---------------------"
    ((cssCnt_$1=`find $TMPDIR -name "*.css" | wc -l`)) 
    ((jsCnt_$1=`find $TMPDIR -name "*.js"| wc -l`))
    ((htmlCnt_$1=`find $TMPDIR -name "*.html"| wc -l `))
    ((cssZipCnt_$1=`find $TMPDIR -name "*.css.gz" | wc -l`)) 
    ((jsZipCnt_$1=`find $TMPDIR -name "*.js.gz"| wc -l`))
    ((htmlZipCnt_$1=`find $TMPDIR -name "*.html.gz"| wc -l `))
    eval echo "css: \${cssCnt_$1} "
    eval echo "js: \${jsCnt_$1}"
    eval echo "html: \${htmlCnt_$1}"
    eval echo "css.gz: \${cssZipCnt_$1}"
    eval echo "js.gz: \${jsZipCnt_$1}"
    eval echo "html.gz: \${htmlZipCnt_$1}"
    echo "-----------------------------------------------"
    echo ""

}


if [ $# -gt 0 ]
then
    TMPDIR=$1
fi

if [ ! -d "$TMPDIR" ]; then
    echo "error ! $TMPDIR is not a dir , exit"
fi


echo_statitics "before"

cd $TMPDIR

foreachd 

cd ..

echo_statitics "after"

if [ "$cssCnt_before" -ne "$gCss" ];then
    echo "css file compressed error, the following css files have compressed error:"
    find $TMPDIR -name "*.css"
    exit -1
else
    echo "$gCss css files have been compressed ok"
fi

if [ "$jsCnt_before" -ne "$gJs" ];then
    echo "js file compressed error, the following js files have compressed error:"
    find $TMPDIR -name "*.js"
    exit -1
else
    echo "$gJs js files have been compressed ok"
fi

if [ "$htmlCnt_before" -ne "$gHtml" ];then
    echo "html file compressed error, the following html files have compressed error:"
    find $TMPDIR -name "*.html"
    exit -1
else
    echo "$gHtml html files have been compressed ok"
fi

echo "ALL: $gall files(cs+js+html) have been compressed ok"
echo ""


echo "-------------------all is ok--------------------"
echo ""

