#ifndef LLT_TEST_H
#define LLT_TEST_H

#include <cppunit/Portability.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestRunner.h>
#include <cppunit/Message.h>
#include <cppunit/Exception.h>
//#include <unistd.h>
//#include <getopt.h>
#include <stdio.h>
#include <string>
using namespace std;

CPPUNIT_NS_BEGIN

/*parse command paramter*/
static void Parse_Command_Param(int *args, char **argv);

/*init LLT framework:set execute flag according to command-line parm*/	
void CPPUNIT_API InitLLTTest(int *args,char ** argv);

/* Get test case name from its full name string
/* A test case full name is like "TestSuiteName::TestCaseName"
/* This method get only the test case name "TestCaseName" 
*/
string getTestcaseNameFromStr( string str);

/* Set file name of the xml file of tests list
*/
void setOutputFileName( char * filename );

/* Get file name of the xml file of tests list
*/
char* getOutputFileName( );


bool setOutputResultFileName( char * filename);

/*Get out put file name of the xml file of test result*/
char* getOutputResultFileName();

/* Init the output xml file of tests list
*/
bool outputXmlFile_Init( ofstream & fp_list );

/* Out put the information of the testcases in tests, 
/* with the ofstream fp_list
*/
void fprint_TestCase_Info( Test * tests, ofstream & fp_list);

/* The interface: out put the information of testcases Registried into XML file
*/
void outputXML_TestCase_Info( );


/*-----------------------------LLTXmlOutputter-------------------------------
* Brief output the tese result in a different format into a xml file.
* 
* A LLTXmlOutPutter is a XmlOutputter which rewrites the method write() in XmlOutputter
* See XmlOutputter.
*/
class CPPUNIT_API LLTXmlOutputter: public XmlOutputter
{
public: 
	/*! Constructs a LLTXmlOutputter object.
   */
	LLTXmlOutputter(TestResultCollector *result,
                OStream &stream,
                std::string encoding = std::string("ISO-8859-1") ):XmlOutputter(result,stream,encoding)
	{
		layerCount = 0;
	} 

	// Destructor.
	virtual ~LLTXmlOutputter();
	
/* rewrite write mothed of the XmlOutputter*/
   virtual void write();

private:
	// count the layer of testsuite,used to control the output format
	int layerCount; 

	/* output test result of m_alltests into xml file 
	*/
	void fprint_TestResult( Test * m_alltests);


	/*check if a testcase named testName is in tests runned this time
	* if testName is in tests,return true,
	* else return false.
	*/
	bool isInTests( std::string testName, const TestResultCollector::Tests &tests );

	/*check if a testcase named testName is in failed tests runned this time
    * if testName is in failuress,return true,
    * else return false.
	*/
	bool isInFailures( std::string testName, const TestResultCollector::TestFailures &failures );

	/* the testcase named testName is in failed tests runned this time
	*  return the index of this testcase in deque failures
	*/
	int getFailureNumOfFailedTest( std::string testName, const TestResultCollector::TestFailures &failures );

	/* get the total number of testcases runned in testsuite m_suite
	*/
	int getTestRunTotalOfSuite( Test * m_suite , const TestResultCollector::Tests &tests );

	
	/* get the total number of testcases failed in testsuite m_suite
    */
	int getTestFailureTotalOfSuite( Test * m_suite , const TestResultCollector::TestFailures &failures );


};


/*-----------------------------LLTRunner-------------------------------
* \brief Generic test runner.
* Execute Test.
*
* A LLTRunner is a TestRunner which rewrites the run() method.
*
*If there is a a parameter in the command line:
* --LLT_list_test
* just output the tests information into a xml file.
* If there is a parameter in the command line: --LLT_filter_list=[testsuite.testcase:]
* demands to run specified tests
* the new run() method can just run the specified tests,
* rather than the run() in the main().
*
* See TestRunner.
*/
class CPPUNIT_API LLTRunner:public TestRunner
{
public:
	/*! \brief Constructs a LLTRunner object.
	*/
	LLTRunner();
	
	/// Destructor.
	virtual ~LLTRunner();
	
	/* \brief Runs a test using the specified controller.
	*
	* If there is a a parameter in the command line:
	* --LLT_list_test
	* just output the tests information into a xml file.
	*
	* Else, If there is a parameter in the command line:
	* --LLT_filter_list=[testsuite1.testcase1:testsuite2.testcase2:]
	* just run the rests in [testsuite1.testcase1:testsuite2.testcase2:],
	*
	* Else, call TestRunner::run(controller,testPath).
	*/
	virtual void run(TestResult &controller,
                    const std::string &testPath = "");
private:
	/* Same to the strtok(char* string_org,const char* demial) in Microsoft.
	* Because two different strtok() are needed in run() and transformTestCaseFormat(),
	* so write another strtok() with the same function but different name
	*/
	char*  strtok_LLT(char* string_org,const char* demial);

	/* Transform the format of testcase name.
	*
	* The original testcase name is in format
	* "testsuite1.testcase1"  or "testsuite1.*".
	* After transformed,the testcase name is in format:
	* "testsuite1::testcase1"  or "testsuite1"
	*/
	char* transformTestCaseNameFormat( char *testPath);
};

CPPUNIT_NS_END
	
#endif  /*LLT_TEST_H*/


