#ifndef _KK_CPP_LIB_H_
#define _KK_CPP_LIB_H_

#include "KKLib.h"

#ifdef _WIN32
    typedef unsigned __int64 NCS_U_LONG_LONG;
#else
    typedef unsigned long long NCS_U_LONG_LONG;
#endif

#if __GNUC__ == 2
/*ǿתcppԱָ뵽cָ*/
template<class Dest, class Src>
Dest ForceCast(Src src)
{
		if ((sizeof(Src) == sizeof(NCS_U_LONG_LONG))
        && (sizeof(Dest) == sizeof(unsigned long)))
    {
        union
        {
            NCS_U_LONG_LONG d;
            Src s;
        } convertor;

        convertor.s = src;        
        return (Dest)convertor.d;
    }
    else
    {    
        union
        {
            Dest d;
            Src s;
        } convertor;

        convertor.s = src;
        return convertor.d;
    }
}

/*ǿתcָָ뵽cppԱָ*/
template<class Dest, class Src>
Dest B2MForceCast(Src src)
{
    if ((sizeof(Src) == sizeof(unsigned long))
        && (sizeof(Dest) == sizeof(NCS_U_LONG_LONG)))
    {
        union
        {
            Dest d;
            NCS_U_LONG_LONG s;
        } convertor;

        convertor.s = (NCS_U_LONG_LONG)src;
        return convertor.d;
    }
    else
    {    
        union
        {
            Dest d;
            Src s;
        } convertor;

        convertor.s = src;
        return convertor.d;
    }
}

#else //#if __GNUC__ == 2

/*ǿתcppԱָ뵽cָ*/
template<class Dest, class Src>
Dest ForceCast(Src src)
{
    void *ppSrc = (void *)&src;     
    void *pSrc = *((void **)ppSrc);      
    return (Dest)pSrc;
}

/*ǿתcָָ뵽cppԱָ*/
template<class Dest, class Src>
Dest B2MForceCast(Src src)
{
    Dest *pDest = (Dest *)&src;         
    return (Dest)(*pDest);
}

#endif //#if __GNUC__ == 2

/*CPPԱ׮ֱΪSTUB_TYPE_USER׮*/
template<class TF1, class TF2>
int KKInstallCPPUserStubTmp(TF1 pf1, TF2 pf2)
{
    void *p1 = ForceCast<void *>(pf1);
    void *p2 = ForceCast<void *>(pf2); 
    return KKInstallUserStub(p1, p2);
}

/*CPPԱж׮*/
template<class TF>
int KKUninstallCPPStubTmp(TF pf)
{
    void *p = ForceCast<void *>(pf);
    return KKUninstallStub(p);
}

/*ͨ׮CPPԱַҲȡԭָ*/
template<class R, class TF>
R KKGetOriginalCPPOldFuncTmp(TF pf)
{
    void *p = ForceCast<void *>(pf);
    void *pRet =  KKGetOriginalOldFunc(p);
    return B2MForceCast<R>(pRet);
}

template<class R, class TF, TF pFunc>
class CKKGetCPPDataTmp
{
public:
    static R *GetData()
    {
        static R rData;
        return &rData;
    }
};

template<class R, class TF, TF pFunc>
class CKKRetCPPDataTmp0
{
public:
    R RetData(void)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class TF, TF pFunc>
class CKKRetCPPDataTmp1
{
public:
    R RetData(P1 p1)
    {
        p1;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class TF, TF pFunc>
class CKKRetCPPDataTmp2
{
public:
    R RetData(P1 p1, P2 p2)
    {
        p1; p2;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class TF, TF pFunc>
class CKKRetCPPDataTmp3
{
public:
    R RetData(P1 p1, P2 p2, P3 p3)
    {
        p1; p2; p3;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class P4, class TF, TF pFunc>
class CKKRetCPPDataTmp4
{
public:
    R RetData(P1 p1, P2 p2, P3 p3, P4  p4)
    {
        p1; p2; p3; p4;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class P4, class P5, class TF, TF pFunc>
class CKKRetCPPDataTmp5
{
public:
    R RetData(P1 p1, P2 p2, P3 p3, P4  p4, P5 p5)
    {
        p1; p2; p3; p4; p5;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class P4, class P5, class P6, class TF, TF pFunc>
class CKKRetCPPDataTmp6
{
public:
    R RetData(P1 p1, P2 p2, P3 p3, P4  p4, P5 p5, P6 p6)
    {
        p1; p2; p3; p4; p5; p6;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class TF, TF pFunc>
class CKKRetCPPDataTmp7
{
public:
    R RetData(P1 p1, P2 p2, P3 p3, P4  p4, P5 p5, P6 p6, P7 p7)
    {
        p1; p2; p3; p4; p5; p6; p7;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class R, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class P8, class TF, TF pFunc>
class CKKRetCPPDataTmp8
{
public:
    R RetData(P1 p1, P2 p2, P3 p3, P4  p4, P5 p5, P6 p6, P7 p7, P8 p8)
    {
        p1; p2; p3; p4; p5; p6; p7; p8;
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        return *pData;
    }
};

template<class TF, TF pFunc, class R>
class CKKSetCPPDataStubTmp
{
public:
    template<class T>
    static int SetCPPDataStub(R (T::* pfOld)(void), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp0<R, TF, pFunc>::RetData);
    }

    template<class T, class P1>
    static int SetCPPDataStub(R (T::* pfOld)(P1), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp1<R, P1, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp2<R, P1, P2, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp3<R, P1, P2, P3, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3, class P4>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3, P4), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp4<R, P1, P2, P3, P4, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3, class P4, class P5>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3, P4, P5), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp5<R, P1, P2, P3, P4, P5, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3, class P4, class P5, class P6>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3, P4, P5, P6), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp6<R, P1, P2, P3, P4, P5, P6, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3, class P4, class P5, class P6, class P7>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3, P4, P5, P6, P7), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp7<R, P1, P2, P3, P4, P5, P6, P7, TF, pFunc>::RetData);
    }

    template<class T, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class P8>
    static int SetCPPDataStub(R (T::* pfOld)(P1, P2, P3, P4, P5, P6, P7, P8), R rData)
    {
        R *pData = CKKGetCPPDataTmp<R, TF, pFunc>::GetData();
        *pData = rData;
        return KKInstallCPPUserStubTmp(pfOld,
            &CKKRetCPPDataTmp8<R, P1, P2, P3, P4, P5, P6, P7, P8, TF, pFunc>::RetData);
    }
};

/**/
template<class TObj>
int KKAssistFuncTmp(TObj &rObj)
{
    return 1;
}

/*0*/
template<class TObj, class P1>
int KKAssistFuncTmp(TObj &rObj, P1 p1)
{
    rObj; p1;
    return 1;
}

/*1*/
template<class TObj, class P1>
int KKAssistFuncTmp(TObj &rObj, P1 &p1)
{
    rObj; p1;
    return 1;
}

/*00*/
template<class TObj, class P1, class P2>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2)
{
    rObj; p1; p2;
    return 1;
}

/*01*/
template<class TObj, class P1, class P2>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2)
{
    rObj; p1; p2;
    return 1;
}

/*10*/
template<class TObj, class P1, class P2>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2)
{
    rObj; p1; p2;
    return 1;
}

/*11*/
template<class TObj, class P1, class P2>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2)
{
    rObj; p1; p2;
    return 1;
}

/*000*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*001*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*010*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*011*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*100*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*101*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*110*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*111*/
template<class TObj, class P1, class P2, class P3>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3)
{
    rObj; p1; p2; p3;
    return 1;
}

/*0000*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0001*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0010*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0011*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0100*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0101*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0110*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*0111*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1000*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1001*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1010*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1011*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1100*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1101*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1110*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*1111*/
template<class TObj, class P1, class P2, class P3, class P4>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4)
{
    rObj; p1; p2; p3; p4;
    return 1;
}

/*00000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*00111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*01111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*10111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*11111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5)
{
    rObj; p1; p2; p3; p4; p5;
    return 1;
}

/*000000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*000111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*001111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 &p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*010111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*011111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*100111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*101111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 p2, P3 &p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*110111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111001*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111010*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111011*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111100*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111101*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111110*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5, P6 p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*111111*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6>
int KKAssistFuncTmp(TObj &rObj, P1 &p1, P2 &p2, P3 &p3, P4 &p4, P5 &p5, P6 &p6)
{
    rObj; p1; p2; p3; p4; p5; p6;
    return 1;
}

/*6ûӡ*/
/*0000000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6, class P7>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6, P7 p7)
{
    rObj; p1; p2; p3; p4; p5; p6; p7;
    return 1;
}

/*00000000*/
template<class TObj, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class P8>
int KKAssistFuncTmp(TObj &rObj, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6, P7 p7, P8 p8)
{
    rObj; p1; p2; p3; p4; p5; p6; p7; p8;
    return 1;
}

template <class T, class R>
static void *KKGetAssistFuncTmp(R (T::* pf)(void))
{
    return (int (*)(T &))&KKAssistFuncTmp;
}

template <class T, class R, class P1>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1))
{
    return (int (*)(T &, P1))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2))
{
    return (int (*)(T &, P1, P2))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3))
{
    return (int (*)(T &, P1, P2, P3))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3, class P4>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3, P4))
{
    return (int (*)(T &, P1, P2, P3, P4))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3, class P4, class P5>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3, P4, P5))
{
    return (int (*)(T &, P1, P2, P3, P4, P5))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3, class P4, class P5, class P6>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3, P4, P5, P6))
{
    return (int (*)(T &, P1, P2, P3, P4, P5, P6))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3, class P4, class P5, class P6, class P7>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3, P4, P5, P6, P7))
{
    return (int (*)(T &, P1, P2, P3, P4, P5, P6, P7))&KKAssistFuncTmp;
}

template<class T, class R, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class P8>
static void *KKGetAssistFuncTmp(R (T::* pf)(P1, P2, P3, P4, P5, P6, P7, P8))
{
    return (int (*)(T &, P1, P2, P3, P4, P5, P6, P7, P8))&KKAssistFuncTmp;
}



//CPPԱ׮ֱΪSTUB_TYPE_USER׮
//pf1: ׮Աַ
//pf2: û׮ԱַΪա
//ִзֵ1ɹ0ʧܡ
#define KKSetCPPUserStub(pf1, pf2) \
        KKInstallCPPUserStubTmp(&pf1, &pf2)

//CPPԱж׮
//pf: ׮Աַ
//ִзֵ1ɹ0ʧܡ
#define KKUnsetCPPStub(pf) \
        KKUninstallCPPStubTmp(&pf)

//ͨ׮CPPԱַҲȡԭָС
//tType: ȡԭԱָк󣬴ת͡
//    磺Աָͣ int (CSample::* )(int, int)
//pf: ׮Աַ
//ִзֵԭָУNULLΪʧܡ
#define KKGetCPPOldFunc(tType, pf) \
        KKGetOriginalCPPOldFuncTmp<tType>(&pf)

//CPPԱ׮ֱΪSTUB_TYPE_DATA׮
//ﲻƺֵ͡
//tFType: Աָͣ 磺int (CSample::* )(int, int)
//pf: ׮Աַ
//tRType: ֵͣԱֵһ¡
//nData: õĺֵ
//ִзֵ1ɹ0ʧܡ
#define KKSetCPPDataStub(tFType, pf, tRType, nData) \
        CKKSetCPPDataStubTmp<tFType, &pf, tRType>::SetCPPDataStub(&pf, nData)

//CPPԱ׮ֱΪSTUB_TYPE_DATA׮
//ﲻƺֵ͡
//tFType: Աָͣ 磺int (CSample::* )(int, int)
//pf: ׮Աַ磺&CSample::GetData
//pfVir: ⺯ʵʵַͨKKGetVFAddrȡ
//tRType: ֵͣԱֵһ¡
//nData: õĺֵ
//ִзֵ1ɹ0ʧܡ
#define KKSetVirCPPDataStub(tFType, pf, pfVir, tRType, nData) \
        CKKSetCPPDataStubTmp<tFType, &pf, tRType>::SetCPPDataStub(B2MForceCast<pfunc>(pfVir), nData)

/*
  ȡ⺯ַ
  pVirFunc: 麯
  pObject: 麯Ӧһָ롣
  szFuncName: 麯ƣ򣩡
  cType: 'C' - const  'V' - volatile  'N' - normal
  ִзֵ: 麯ʵַNULLΪʧܡ
*/
template<class TVFPtrType, class TObjType>
void *KKGetVFAddr(TVFPtrType pVirFunc, TObjType *pObject, char *szFuncName, char cType)
{
    void *pAssistFunc = KKGetAssistFuncTmp(pVirFunc);    
    return KKGetVirFuncAddr(*(void**)&pVirFunc, (void*)pObject, pAssistFunc, szFuncName, cType);
}

/*
  ȡ⺯ַ
  pVirFunc: 麯
  pObject: 麯Ӧһָ롣
  szFuncName: 麯ƣ򣩡
  cType: 'C' - const  'V' - volatile  'N' - normal
  ִзֵ: 麯ʵַNULLΪʧܡ
*/
template<class TVFPtrType, class TObjType>
void *KKGetVFAddr(TVFPtrType pVirFunc, TObjType *pObject, void *pAssistFunc, char *szFuncName, char cType)
{    
    return KKGetVirFuncAddrSpec(*(void**)&pVirFunc, (void*)pObject, pAssistFunc, szFuncName, cType);
}

/*
  ȡ⺯ַڳvxworksʹgcc2.9.x汾֮ĳ
  pVirFunc: 麯
  pObject: 麯Ӧһָ롣
  ִзֵ: 麯ʵַNULLΪʧܡ
*/
template<class TVFPtrType, class TObjType>
void *KKGetVFAddr(TVFPtrType pVirFunc, TObjType *pObject)
{
    void * p = ForceCast<void *>(pVirFunc);
    return KKGetVirFuncAddrEx(p, (void *)pObject);
}


#endif
