#ifndef _KK_ASSERT_H_
#define _KK_ASSERT_H_

/*ʽϢ*/
#define HLLT_FMT_EXPECT_INFO(ExprText, _Actual, _Expected) \
    (void)HLLT_TC_TRACE("%s(%d) : error :Value of: " \
        ExprText "\r\nActual: " #_Actual "\r\nExpected: " #_Expected "\r\n", \
        __FILE__, __LINE__); 

/*жϣʽ*/
#define HLLT_EXPECT_BOOL(Expr, ExprText, Actual, Expected, Action) \
    do \
    { \
        if (Expr); \
        else \
        { \
            KKSetResult(TC_FAIL); \
            HLLT_FMT_EXPECT_INFO(ExprText, Actual, Expected); \
            Action \
        } \
    } while(0) \

/*׷û*/
#define HLLT_FMT_USER_INFO(UserInfo) \
    { \
        (void)HLLT_TC_TRACE("User Info: "); \
        (void)HLLT_TC_TRACE(UserInfo); \
        (void)HLLT_TC_TRACE("\r\n"); \
    }

/*ʽȽϳϢunuse*/
#define HLLT_FMT_COMP_INFO(Expr, Actual, Expected) \
    "(" #Expected ")" #Expr "(" #Actual ")"

/*ʽжϣʽunuse*/
#define HLLT_EXPECT_EXPRESSION(Expr, Action) \
    HLLT_EXPECT_BOOL(Expr, #Expr, false, true, Action)

/*Ʊʽunuse*/
#define HLLT_BINARY_EXPR(Expected, Actual, Expr) ((Expected) Expr (Actual))

/************************************************************************/
/* ûӿ                                                             */
/************************************************************************/
/*Boolean assertions.*/
/*ڴtrueʧЧ˳*/
#define HLLT_EXPECT_T(Condition) \
    HLLT_EXPECT_BOOL(Condition, #Condition, false, true, {})

/*ڴtrueû׷ϢʧЧ˳*/
#define HLLT_EXPECT_T_I(Condition, UserInfo) \
    HLLT_EXPECT_BOOL(Condition, #Condition, false, true, \
        HLLT_FMT_USER_INFO(UserInfo))

/*ڴfalseʧЧ˳*/
#define HLLT_EXPECT_F(Condition) \
    HLLT_EXPECT_BOOL(!(Condition), #Condition, true, false, {})

/*ڴfalseû׷ϢʧЧ˳*/
#define HLLT_EXPECT_F_I(Condition, UserInfo) \
    HLLT_EXPECT_BOOL(!(Condition), #Condition, true, false, \
        HLLT_FMT_USER_INFO(UserInfo))

/*ڴtrueʧЧ˳*/
#define HLLT_ASSERT_T(Condition) \
    HLLT_EXPECT_BOOL(Condition, #Condition, false, true, {return;})

/*ڴtrueû׷ϢʧЧ˳*/
#define HLLT_ASSERT_T_I(Condition, UserInfo) \
    HLLT_EXPECT_BOOL(Condition, #Condition, false, true, \
        {HLLT_FMT_USER_INFO(UserInfo); return;})

/*ڴfalseʧЧ˳*/
#define HLLT_ASSERT_F(Condition) \
    HLLT_EXPECT_BOOL(!(Condition), #Condition, true, false, {return;})

/*ڴfalseû׷ϢʧЧ˳*/
#define HLLT_ASSERT_F_I(Condition, UserInfo) \
    HLLT_EXPECT_BOOL(!(Condition), #Condition, true, false, \
        {HLLT_FMT_USER_INFO(UserInfo); return;})

/* * HLLT_{ASSERT|EXPECT}_EQ(Expected, Actual): Tests that Expected == Actual
   * HLLT_{ASSERT|EXPECT}_NE(Expected, Actual): Tests that Expected != Actual
   * HLLT_{ASSERT|EXPECT}_LT(v1, v2):           Tests that v1 < v2
   * HLLT_{ASSERT|EXPECT}_LE(v1, v2):           Tests that v1 <= v2
   * HLLT_{ASSERT|EXPECT}_GT(v1, v2):           Tests that v1 > v2
   * HLLT_{ASSERT|EXPECT}_GE(v1, v2):           Tests that v1 >= v2
*/

/*ҪıȽϣ磺charintunsigned intlongunsiged longͣ
**ڸ磺floatdoubleΪ⣬ݲṩûзװ
**ҲʹHLLT_EXPECT_TȽConditionķʽ*/

/*ڴȣʧЧ˳ݲӡActualʵֵûƵ͡*/
#define HLLT_EXPECT_EQ(Expected, Actual) \
    HLLT_EXPECT_T((Expected) == (Actual))

/*ڴȣû׷ϢʧЧ˳
  ݲӡActualʵֵûƵ͡*/
#define HLLT_EXPECT_EQ_I(Expected, Actual, UserInfo) \
    HLLT_EXPECT_T_I(((Expected) == (Actual)), UserInfo)

/*ڴȣʧЧ˳ݲӡActualʵֵûƵ͡*/
#define HLLT_ASSERT_EQ(Expected, Actual) \
    HLLT_ASSERT_T(((Expected) == (Actual)))

/*ڴȣû׷ϢʧЧ˳
  ݲӡActualʵֵûƵ͡*/
#define HLLT_ASSERT_EQ_I(Expected, Actual, UserInfo) \
    HLLT_ASSERT_T_I(((Expected) == (Actual)), UserInfo)

/*ڴȣʧЧ˳ݲӡActualʵֵûƵ͡*/
#define HLLT_EXPECT_NE(Expected, Actual) \
    HLLT_EXPECT_T(((Expected) != (Actual)))

/*ڴȣû׷ϢʧЧ˳
  ݲӡActualʵֵûƵ͡*/
#define HLLT_EXPECT_NE_I(Expected, Actual, UserInfo) \
    HLLT_EXPECT_T_I(((Expected) != (Actual)), UserInfo)

/*ڴȣʧЧ˳ݲӡActualʵֵûƵ͡*/
#define HLLT_ASSERT_NE(Expected, Actual) \
    HLLT_ASSERT_T(((Expected) != (Actual)))

/*ڴȣû׷ϢʧЧ˳
  ݲӡActualʵֵûƵ͡*/
#define HLLT_ASSERT_NE_I(Expected, Actual, UserInfo) \
    HLLT_ASSERT_T_I(((Expected) != (Actual)), UserInfo)

/*ڴV1 < V2ʧЧ˳*/
#define HLLT_EXPECT_LT(V1, V2) \
    HLLT_EXPECT_T(((V1) < (V2)))

/*ڴV1 < V2û׷ϢʧЧ˳*/
#define HLLT_EXPECT_LT_I(V1, V2, UserInfo) \
    HLLT_EXPECT_T_I(((V1) < (V2)), UserInfo)

/*ڴV1 < V2ʧЧ˳*/
#define HLLT_ASSERT_LT(V1, V2) \
    HLLT_ASSERT_T(((V1) < (V2)))

/*ڴV1 < V2û׷ϢʧЧ˳*/
#define HLLT_ASSERT_LT_I(V1, V2, UserInfo) \
    HLLT_ASSERT_T_I(((V1) < (V2)), UserInfo)

/*ڴV1 <= V2ʧЧ˳*/
#define HLLT_EXPECT_LE(V1, V2) \
    HLLT_EXPECT_T(((V1) <= (V2)))

/*ڴV1 <= V2û׷ϢʧЧ˳*/
#define HLLT_EXPECT_LE_I(V1, V2, UserInfo) \
    HLLT_EXPECT_T_I(((V1) <= (V2)), UserInfo)

/*ڴV1 <= V2ʧЧ˳*/
#define HLLT_ASSERT_LE(V1, V2) \
    HLLT_ASSERT_T(((V1) <= (V2)))

/*ڴV1 <= V2û׷ϢʧЧ˳*/
#define HLLT_ASSERT_LE_I(V1, V2, UserInfo) \
    HLLT_ASSERT_T_I(((V1) <= (V2)), UserInfo)

/*ڴV1 > V2ʧЧ˳*/
#define HLLT_EXPECT_GT(V1, V2) \
    HLLT_EXPECT_T(((V1) > (V2)))

/*ڴV1 > V2û׷ϢʧЧ˳*/
#define HLLT_EXPECT_GT_I(V1, V2, UserInfo) \
    HLLT_EXPECT_T_I(((V1) > (V2)), UserInfo)

/*ڴV1 > V2ʧЧ˳*/
#define HLLT_ASSERT_GT(V1, V2) \
    HLLT_ASSERT_T(((V1) > (V2)))

/*ڴV1 > V2û׷ϢʧЧ˳*/
#define HLLT_ASSERT_GT_I(V1, V2, UserInfo) \
    HLLT_ASSERT_T_I(((V1) > (V2)), UserInfo)

/*ڴV1 >= V2ʧЧ˳*/
#define HLLT_EXPECT_GE(V1, V2) \
HLLT_EXPECT_T(((V1) >= (V2)))

/*ڴV1 >= V2û׷ϢʧЧ˳*/
#define HLLT_EXPECT_GE_I(V1, V2, UserInfo) \
HLLT_EXPECT_T_I(((V1) >= (V2)), UserInfo)

/*ڴV1 >= V2ʧЧ˳*/
#define HLLT_ASSERT_GE(V1, V2) \
HLLT_ASSERT_T(((V1) >= (V2)))

/*ڴV1 >= V2û׷ϢʧЧ˳*/
#define HLLT_ASSERT_GE_I(V1, V2, UserInfo) \
    HLLT_ASSERT_T_I(((V1) >= (V2)), UserInfo)

#endif
