# Copyright (C) 2011 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#
# This file is the build configuration for a full Android
# build for manta hardware. This cleanly combines a set of
# device-specific aspects (drivers) with a device-agnostic
# product configuration (apps). Except for a few implementation
# details, it only fundamentally contains two inherit-product
# lines, full and manta, hence its name.
#
DEVICE_LOCAL_PATH:= device/huawei-mbb/p711

ifdef TARGET_BUILD_MODEL
    include $(DEVICE_LOCAL_PATH)/$(TARGET_BUILD_MODEL)/product.min
    include $(DEVICE_LOCAL_PATH)/$(TARGET_BUILD_MODEL)/product_module.mk

    ifdef TARGET_BUILD_MODEL_TYPE
       include $(DEVICE_LOCAL_PATH)/$(TARGET_BUILD_MODEL)/$(TARGET_BUILD_MODEL_TYPE)/product_flags.min
       include $(DEVICE_LOCAL_PATH)/$(TARGET_BUILD_MODEL)/$(TARGET_BUILD_MODEL_TYPE)/product_module.mk
    endif
endif
#include $(DEVICE_LOCAL_PATH)/3rdComponent/Android.mk

APP_DEFINE += $(FEATURE_HUAWEI_DEFINE)

SYSTEM_MODULES += linker libstlport libc++ libc libdl libm adb adbd libcrypto libssl libnl_2 libsafe_iop \
                  iptables ip6tables siproxd init init.rc init.goldfish.sh huawei_process_start libdsi_netctrl \
				  logcat logwrapper run-as sdcard libacc libatwrapper libctest libdiskconfig libnetutils \
				  libsysutils libthread_db libz libwpa_client libwifiwpa_client crasher inithwtest.rc

PRODUCT_MODULES += ecall btools

APP_MODULES += mlogserver

ifneq ($(findstring FEATURE_HUAWEI_MBB_WIFIAP, $(APP_DEFINE)),)
    APP_MODULES += libwl
    ifneq ($(findstring FEATURE_HUAWEI_MBB_WIFIAPWPS, $(APP_DEFINE)),)
        APP_MODULES += libwlwpscli
    endif
    ifneq ($(findstring FEATURE_HUAWEI_MBB_BCM43, $(APP_DEFINE)),)
        APP_MODULES += libpktwpscli
    endif
endif

ifneq ($(findstring FEATURE_HUAWEI_MBB_RTL81, $(APP_DEFINE)),)
    APP_MODULES += iwpriv
endif

PRODUCT_NAME :=p711
PRODUCT_DEVICE :=p711
PRODUCT_BRAND :=Android
PRODUCT_MODEL :=p711
PRODUCT_MANUFACTURER :=HUAWEI DEIVCE 
PRODUCT_RESTRICT_VENDOR_FILES :=false
PRODUCT_PACKAGES := $(SYSTEM_MODULES) $(PRODUCT_MODULES) $(APP_MODULES)


#$(call inherit-product, $(SRC_TARGET_DIR)/product/embedded.mk)

