#!/bin/sh

#first define platform name
dir=`echo $0 | grep "^/"`
if [ -n "${dir}" ]
then
    CUR_DIR=`dirname $0`
else
    scriptpath=`pwd`/$0
    CUR_DIR=`dirname ${scriptpath}`
fi

#BEGIN DTS2014053103241 y00216577 20140605 modified
MACHINE_NAME=msm9630

BUSYBOX_ROOT=${CUR_DIR}/ramdisk/busybox-1.21.1
HUAWEIDLOAD_ROOT=${CUR_DIR}/huawei-dload
BUILD_TEMP_DIR=${1}
BUILD_OUTPUT_DIR=${2}

print_usage(){
    echo "Usage: ./dload_build.sh build_temp_dir build_output_dir"
}

if [ -z "${BUILD_TEMP_DIR}" -o ! -d "${BUILD_TEMP_DIR}" ]
then
    echo "build_temp_dir not exist"
    print_usage
    exit 1
fi

if [ -z "${BUILD_OUTPUT_DIR}" -o ! -d "${BUILD_OUTPUT_DIR}" ]
then
    echo "build_output_dir not exist"
    print_usage
    exit 1
fi

OUTPUT_TEMP=${BUILD_TEMP_DIR}/ramdisk

rm -rf ${OUTPUT_TEMP}
mkdir -p ${OUTPUT_TEMP}

cp -rf ${CUR_DIR}/ramdisk/files/* ${OUTPUT_TEMP}
chmod -R 777 ${OUTPUT_TEMP}
ln -s /usr/bin/usb/compositions/empty ${OUTPUT_TEMP}/usr/bin/usb/boot_hsic_composition
ln -s /usr/bin/usb/compositions/empty ${OUTPUT_TEMP}/usr/bin/usb/boot_hsusb_composition
ln -s /sbin/init ${OUTPUT_TEMP}/init

echo "-------------mkdir completed!!!!-------------"

#build busybox
chmod -R 777 ${BUSYBOX_ROOT}
make -C ${BUSYBOX_ROOT} && make -C ${BUSYBOX_ROOT} install
if [ $? != 0 ]
then
    exit 1
fi
cp -R ${BUSYBOX_ROOT}/_install/* ${OUTPUT_TEMP}/

#build huaweidload
rm -rf ${HUAWEIDLOAD_ROOT}/obj/* ${HUAWEIDLOAD_ROOT}/out/*
chmod -R 777 ${HUAWEIDLOAD_ROOT}
make -C ${HUAWEIDLOAD_ROOT}
if [ $? != 0 ]
then
    exit 1
fi
cp ${CUR_DIR}/huawei-dload/out/huaweidload ${OUTPUT_TEMP}/bin/
if [ $? != 0 ]
then
    exit 1
fi

	
OLD_PATH=${PWD}
cd ${OUTPUT_TEMP}
find  ./  -name  '*.svn'  -type  d  -print  -exec  rm  -rf  {} \;
find . | cpio -o -Hnewc |gzip -9 > ../initrd.img.gz
cd ${OLD_PATH}
#BEGIN DTS2013042703330 QIUJIAN 00208481 2013-04-27 ADDED	
cp ${OUTPUT_TEMP}/../initrd.img.gz ${BUILD_OUTPUT_DIR}
#END DTS2013042703330 QIUJIAN 00208481 2013-04-27 ADDED
#END DTS2014053103241 y00216577 20140605 modified

echo "-------------ramdisk img archive completed-------------"
