/******************************************************************************

    Copyright(C)2013,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : TrrcErrLogInterface.h
  Description     : TrrcErrLogInterface.h header file
  History         :
     1.xubo 00183216       2013-10-25     Draft Enact
     2.
******************************************************************************/

#ifndef __TRRCERRLOGINTERFACE_H__
#define __TRRCERRLOGINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include "omerrorlog.h"
#pragma pack(4)

/*****************************************************************************
  2 macro
*****************************************************************************/
#include  "vos.h"
#include "omerrorlog.h"
/*****************************************************************************
  3 Massage Declare
*****************************************************************************/
/* TDSϱǿ3 */
#define TRRC_APP_MAX_NCELL_NUM                     (3)

/* RRC errorʱRRC¼ */
#define TRRC_ERRLOG_CODE_MAX_NUM                   (4)

/* RRC errorʱģϢ¼ */
#define TRRC_APP_INFO_NUM                          (16)

/*****************************************************************************
  4 Enum
*****************************************************************************/

/*****************************************************************************
 ö    : RRC_APP_ERROR_CODE_ENUM
 Э  :
 ASN.1 :
 ö˵  : RRC
*****************************************************************************/
enum TRRC_APP_ERROR_CODE_ENUM
{
    TRRC_APP_RB_PROTOCOL_CHECK_ERR            = 0,   /* RBʧ--Protocolʧ */
    TRRC_APP_RB_TRANSACTION_CHECK_ERR,               /* RBʧ--Transaction IDʧ */
    TRRC_APP_RB_INTEGRITY_CHECK_ERR,                 /* RBʧ--Integrityʧ */

    TRRC_APP_RBREC_PROTOCOL_CHECK_ERR         = 10,  /* RBʧ--Protocolʧ */
    TRRC_APP_RBREC_TRANSACTION_CHECK_ERR,            /* RBʧ--Transaction IDʧ */
    TRRC_APP_RBREC_INTEGRITY_CHECK_ERR,              /* RBʧ--Integrityʧ */

    TRRC_APP_CELLUPDATECNF_PROTOCOL_CHECK_ERR     =20,  /* Сʧ--Protocolʧ */
    TRRC_APP_CELLUPDATECNF_TRANSACTION_CHECK_ERR,       /* Сʧ--Transaction IDʧ */
    TRRC_APP_CELLUPDATECNF_INTEGRITY_CHECK_ERR,         /* Сʧ--Integrityʧ */

    TRRC_APP_EST_T300_ERR                         =30,  /* N300ʱ¼ */
    TRRC_APP_EST_CS_ACC_PROBABILITY_ERR,                /* CSACȼжʧ */
    TRRC_APP_EST_PS_ACC_PROBABILITY_ERR,                /* PSACȼжʧ */

    TRRC_APP_EST_AREA_LOST_ERR                    =40,  /* RRC */
    TRRC_APP_ASN_RLST_ERR,                              /* ASN */
    TRRC_APP_AM_INTEGRITY_CHECK_ERR,                    /* AMԼʧ */
    TRRC_APP_UM_INTEGRITY_CHECK_ERR,                    /* UMԼʧ */

    TRRC_APP_MEAS_CTRL_PROTOCOL_CHECK_ERR         =50,  /* ʧ--Protocolʧ */
    TRRC_APP_MEAS_CTRL_TRANSACTION_CHECK_ERR,           /* ʧ--Transaction IDʧ */

    TRRC_APP_ERR_CODE_BUTT
};
typedef VOS_UINT8 TRRC_APP_ERROR_CODE_ENUM_UINT8;

/*****************************************************************************
 ö    : TRRC_APP_FTM_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ģʽϱͣϱºϱ
*****************************************************************************/
enum TRRC_APP_FTM_TYPE_ENUM
 {
    TRRC_APP_FTM_PERIOD_INFO,     /* ϱĹģʽϢĿǰIdle״̬ϱΪDRXڣConnected״̬Ϊ1 */
    TRRC_APP_FTM_CHANGE_INFO,     /* ºϱ͵ĹģʽϢϱ */
    TRRC_APP_FTM_INFO_BUIT
 };
 typedef VOS_UINT32 TRRC_APP_FTM_TYPE_ENUM_UINT32;

 /*********************************************************
 ö    : TRRC_APP_FTM_CHANGE_INFO_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ϱģʽͶ
**********************************************************/
 enum TRRC_APP_FTM_CHANGE_INFO_TYPE_ENUM
 {
     TRRC_APP_FTM_CHANGE_CELL_INFO,      /* RRCפСϢ仯ϱлѡɺϱ */
     TRRC_APP_FTM_CHANGE_STATE_INFO,     /* RRC״̬Ϣ仯ϱ */

     TRRC_APP_FTM_CHANGE_BUTT
 };
  typedef VOS_UINT32 TRRC_APP_FTM_CHANGE_INFO_TYPE_ENUM_UINT32;

 /*****************************************************************************
  ö    : TRRC_APP_PROTOCOL_STATE_ENUM
  Э  :
  ASN.1 :
  ö˵  : TRRCЭ״̬
 *****************************************************************************/
 enum TRRC_APP_PROTOCOL_STATE_ENUM
 {
     TRRC_APP_PROTOCOL_STATE_IDLE                           = 0,                /* IDLE̬ */
     TRRC_APP_PROTOCOL_STATE_CELL_PCH                          ,                /* CELL_PCH̬ */
     TRRC_APP_PROTOCOL_STATE_URA_PCH                           ,                /* URA_PCH̬ */
     TRRC_APP_PROTOCOL_STATE_CELL_FACH                         ,                /* CELL_FACH̬ */
     TRRC_APP_PROTOCOL_STATE_CELL_DCH                          ,                /* CELL_DCH̬ */

     TRRC_APP_PROTOCOL_STATE_BUTT
 };
 typedef VOS_UINT8 TRRC_APP_PROTOCOL_STATE_ENUM_UINT8;

 /*****************************************************************************
  ö     :TRRC_APP_GRR_BANDINDICATOR_ENUM
  Э  :
  ASN.1   :
  ö˵ : 2GСƵָʾ
 *****************************************************************************/
 enum TRRC_APP_GRR_BANDINDICATOR_ENUM
 {
     TRRC_APP_GRR_BANDINDICATOR_DCS1800       = 0,
     TRRC_APP_GRR_BANDINDICATOR_PCS1900       ,

     TRRC_APP_GRR_BANDINDICATOR_BUTT
 };
 typedef VOS_UINT16    TRRC_APP_GRR_BANDINDICATOR_ENUM_UINT16;

  /*****************************************************************************
  ö     :TRRC_APP_RRC_STATE_ENUM
  Э  :
  ASN.1   :
  ö˵ : RRC״̬ڲ״̬Э״̬
 *****************************************************************************/
 enum TRRC_APP_RRC_STATE_ENUM
 {
    TRRC_APP_NUL,   // 0x00  /* TTRRC_APP_CHANGE FOR ע: ǰͶʧ*/
    TRRC_APP_SEL,   // 0x01
    TRRC_APP_IDL,   // 0x02
    TRRC_APP_RES,   // 0x03
    TRRC_APP_ACC,   // 0x04
    TRRC_APP_FCH,   // 0x05
    TRRC_APP_DCH,   // 0x06
    TRRC_APP_PCH,   // 0x07
    TRRC_APP_WCA,   // 0x08
    TRRC_APP_REL,   // 0x09
    TRRC_APP_CNF,   // 0x0A
    TRRC_APP_LIM,   // 0x0b
    TRRC_APP_SNW,   // 0x0c
    TRRC_APP_INACTIVE,//0x0d PDM100 200909 for dual mode
    TRRC_APP_PREDEF,  //PDM100 200909 for SIB16
    TRRC_APP_PEND,    //PDM100 200909 for inter-RAT res and CCO
    TRRC_APP_RATHO,   //PDM100 200909 for inter-RAT HO
    TRRC_APP_WAIT,
    TRRC_APP_POWEROFF
 };
typedef VOS_UINT8 TRRC_APP_RRC_STATE_ENUM_UINT8;
/*****************************************************************************
 ö    : TRRC_FLOW_CTRL_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ̿ö
             ޸öʱҪע⣬ʧȡֵ = ȡֵ+1
 : LRRC_FLOW_CTRL_TYPE_G2L_RESEL_FAIL = LRRC_FLOW_CTRL_TYPE_G2L_START_RESEL + 1
*****************************************************************************/
enum TRRC_APP_FLOW_CTRL_TYPE_ENUM
{
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL            = 0,     /* TDS̱߽ */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_IDL_SYS_UPDATA,     /* TDSIDL̬ϵͳϢ² */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_PCH_SYS_UPDATA,     /* TDSPCH̬ϵͳϢ² */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_ENTER_PCH,          /* TDS̴״̬DCH/FACH->PCH̬ת */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_ENTER_FCH,          /* TDS̴״̬IDL->FCH̬ת */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_ENTER_DCH,          /* TDS̴״̬IDL->DCH̬ת */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_RES_ENTER_FCH,             /* TDSѡFCH״̬ */
    /* TL RESEL PHASE2 begin */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NAS_SUSPEND,               /* TDSNAS */
    /* TL RESEL PHASE2 end */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_NORMAL_END,                /* TDS̱߽ */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_START_RESEL,               /* G->Tʼѡ */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_RESEL_FAIL,                /* G->Tѡʧ */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_STOP_RESEL,                /* G->Tֹͣѡ */

    TRRC_APP_FLOW_CTRL_TYPE_T2G_START_RESEL,               /* T->Gʼѡ */
    TRRC_APP_FLOW_CTRL_TYPE_T2G_RESEL_FAIL,                /* T->Gѡʧ */

    TRRC_APP_FLOW_CTRL_TYPE_G2T_MEAS,                      /* G->T  */
    /* TL RESEL BEGIN */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_START_RESEL,               /* L->Tʼѡ */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_RESEL_FAIL,                /* L->Tѡʧ */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_STOP_RESEL,                /* L->Tֹͣѡ */

    TRRC_APP_FLOW_CTRL_TYPE_L2T_IDLE_MEAS,                 /* L->T IDLE */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_CONN_MEAS,                 /* L->T CONN */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_RELALL,                    /* L->T RELALL */

    TRRC_APP_FLOW_CTRL_TYPE_T2L_START_RESEL,               /* T->Lʼѡ */
    TRRC_APP_FLOW_CTRL_TYPE_T2L_RESEL_FAIL,                /* T->Lѡʧ */

	/* TOER_HO BEGIN */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_START_CCO,                 /* G->TʼCCO */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_CCO_FAIL,                  /* G->T CCOʧ */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_STOP_CCO,                  /* G->TֹͣCCO */

    TRRC_APP_FLOW_CTRL_TYPE_T2G_START_CCO,                 /* T->GʼCCO */
    TRRC_APP_FLOW_CTRL_TYPE_T2G_CCO_FAIL,                  /* T->G CCOʧ */

    TRRC_APP_FLOW_CTRL_TYPE_T2L_START_HO,                  /* T->Lʼл */
    TRRC_APP_FLOW_CTRL_TYPE_T2L_HO_FAIL,                   /* T->Lлʧ */

    TRRC_APP_FLOW_CTRL_TYPE_L2T_START_HO,                  /* L->TʼHO */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_HO_FAIL,                   /* L->T HOʧ */
    TRRC_APP_FLOW_CTRL_TYPE_L2T_STOP_HO,                   /* L->TֹͣHO */

    TRRC_APP_FLOW_CTRL_TYPE_T2G_START_HO,                  /* T->Gʼл */
    TRRC_APP_FLOW_CTRL_TYPE_T2G_HO_FAIL,                   /* T->Gлʧ */

    TRRC_APP_FLOW_CTRL_TYPE_G2T_START_HO,                  /* G->TʼHO */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_HO_FAIL,                   /* G->T HOʧ */
    TRRC_APP_FLOW_CTRL_TYPE_G2T_STOP_HO,                   /* G->TֹͣHO */
    /* TOER_HO END */

    /* y00159566 gutl syscfg begin */
    TRRC_APP_FLOW_CTRL_TYPE_T2T_SYSCFG_SUSPEND,            /* TDSҹ */
    /* y00159566 gutl syscfg end */
    /* TL RESEL PHASE2 begin */
    #if 0
    TRRC_APP_FLOW_CTRL_TYPE_T2L_MEAS,                      /* T->L  */
    #endif
    /* TL RESEL PHASE2 end */
    /* TL RESEL end */
    /* TL Redir begin */
    TRRC_APP_FLOW_CTRL_TYPE_T2L_REDIR,                     /* T->Lض */
    /* TL Redir end */
    LRRC_APP_FLOW_CTRL_TYPE_L2T_REDIR_FAIL,                /* L->Wضʧ */

    TRRC_APP_FLOW_CTRL_TYPE_L2T_STOP_REDIR,                /* L->Tضֹͣ */

    /*׼FRbegin*/
    TRRC_APP_FLOW_CTRL_TYPE_T2G_REDIR,                     /* T->Gض */

    TRRC_APP_FLOW_CTRL_TYPE_G2T_REDIR_FAIL,                /* G->Tضʧ */

    TRRC_APP_FLOW_CTRL_TYPE_G2T_STOP_REDIR,                /* G->Tضֹͣ */
    /*׼FRend*/

    TRRC_APP_FLOW_CTRL_TYPE_BUTT
};
typedef VOS_UINT16 TRRC_APP_FLOW_CTRL_TYPE_ENUM_UINT16;
/*****************************************************************************
 ö    : TRRC_APP_EST_SIGNALLING_TYPE
 Э  :
 ASN.1 :
 ö˵  : ·
*****************************************************************************/

enum  TRRC_APP_EST_SIGNALLING_TYPE
{
  TRRC_APP_NO_SIGNALLING_CONNECTION = 0,
  TRRC_APP_SIGNALLING_CONNECTION_ESTABLISHING,
  TRRC_APP_SIGNALLING_CONNECTION_ESTABLISHED
};

typedef VOS_UINT32 TRRC_APP_EST_SIGNALLING_TYPE_UINT32;
/*****************************************************************************
 ö    : TRRC_APP_EST_CAUSE_ENUM
 Э  :
 ASN.1 :
 ö˵  : RRMM_EST_REQ_STRUϢеenEstCause25.331Э鶨屣һ
*****************************************************************************/
enum TRRC_APP_EST_CAUSE_ENUM
{
    TRRC_APP_EST_CAUSE_ORIGIN_CONVERSAT_CALL             = 0,
    TRRC_APP_EST_CAUSE_ORIGIN_STREAM_CALL                = 1,
    TRRC_APP_EST_CAUSE_ORIGIN_INTERACT_CALL              = 2,
    TRRC_APP_EST_CAUSE_ORIGIN_BACKGROUND_CALL            = 3,
    TRRC_APP_EST_CAUSE_ORIGIN_SUBSCRIB_TRAFFIC_CALL      = 4,
    TRRC_APP_EST_CAUSE_TERMINAT_CONVERSAT_CALL           = 5,
    TRRC_APP_EST_CAUSE_TERMINAT_STREAM_CALL              = 6,
    TRRC_APP_EST_CAUSE_TERMINAT_INTERACT_CALL            = 7,
    TRRC_APP_EST_CAUSE_TERMINAT_BACKGROUND_CALL          = 8,
    TRRC_APP_EST_CAUSE_EMERGENCY_CALL                    = 9,
    TRRC_APP_EST_CAUSE_INTER_RAT_CELL_RESELECT           = 10,
    TRRC_APP_EST_CAUSE_INTER_RAT_CELL_CHANGE_ORDER       = 11,
    TRRC_APP_EST_CAUSE_REGISTRATION                      = 12,
    TRRC_APP_EST_CAUSE_DETACH                            = 13,
    TRRC_APP_EST_CAUSE_ORIGIN_HIGH_PRIORITY_SIGNAL       = 14,
    TRRC_APP_EST_CAUSE_ORIGIN_LOW_PRIORITY_SIGNAL        = 15,
    TRRC_APP_EST_CAUSE_CALL_RE_ESTABLISH                 = 16,
    TRRC_APP_EST_CAUSE_TERMINAT_HIGH_PRIORITY_SIGNAL     = 17,
    TRRC_APP_EST_CAUSE_TERMINAT_LOW_PRIORITY_SIGNAL      = 18,
    TRRC_APP_EST_CAUSE_TERMINAT_CAUSE_UNKNOWN            = 19,
    TRRC_APP_EST_CAUSE_BUTT
};
typedef VOS_UINT32 TRRC_APP_EST_CAUSE_ENUM_UINT32;
/*****************************************************************************
   5 STRUCT
*****************************************************************************/

/*****************************************************************************
                               ģʽ ϱݽṹ
*****************************************************************************/

/*****************************************************************************
 ṹ    : TRRC_APP_CHANGE_CELL_INFO_STRU
 ṹ˵  : 仯ϱĹģʽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                usUlFreq;          /* Ƶ㵥λ:100Khz */
    VOS_UINT16                                usDlFreq;          /* Ƶ㵥λ:100Khz */
    VOS_UINT32                                ulCellId;          /* TD-SCDMAСIDָRRCСID */
    VOS_UINT16                                usPagingCycle;     /* Ѱ128,256,512,1024λms*/
    VOS_UINT16                                usReserved;
}TRRC_APP_CHANGE_CELL_INFO_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_TDS_NCELL_INFO_STRU
 ṹ˵  : TD-SCDMAͬƵƵСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                         usFrequency;      /* TD-SCDMAСƵ λ:100Khz */
    VOS_UINT16                         usCellId;         /* TD-SCDMAССID */
    VOS_UINT8                          ucRscp;           /* TD-SCDMAСRscpչʣʵֵ=ucRscp - 116λdbm */
    VOS_UINT8                          aucReserved[3];
}TRRC_APP_TDS_NCELL_INFO_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_TDS_NCELL_STRU
 ṹ˵  : TD-SCDMAͬƵƵСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                      ulNCellNumber;
    TRRC_APP_TDS_NCELL_INFO_STRU    stCellMeasInfo[TRRC_APP_MAX_NCELL_NUM];
}TRRC_APP_TDS_NCELL_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_LTE_NCELL_INFO_STRU
 ṹ˵  : TD-SCDMAϵͳLTEСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                          usArfcn;
    VOS_UINT16                          usCellId;   /* СID */
    VOS_INT16                           sRsrp;      /* RSRP */
    VOS_INT16                           sRsrq;      /* RSRQ */
}TRRC_APP_LTE_NCELL_INFO_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_LTE_NCELL_STRU
 ṹ˵  : TD-SCDMAϵͳLTEСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                      ulNCellNumber;
    TRRC_APP_LTE_NCELL_INFO_STRU    stCellMeasInfo[TRRC_APP_MAX_NCELL_NUM];
}TRRC_APP_LTE_NCELL_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_GERAN_NCELL_INFO_STRU
 ṹ˵  : TD-SCDMAϵͳGSMСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    TRRC_APP_GRR_BANDINDICATOR_ENUM_UINT16                  enBandInd;          /* T->GʱϢеƵָʾһ */
    VOS_INT16                                               sRssi;              /* sRssi ȡֵΧ[-110 * 8,-48 * 8],λ:dbm,1/8 */
    VOS_UINT8                                               ucNcc;              /*  ƶͨѶGSMʶ: ɫ(NCC) */
    VOS_UINT8                                               ucBcc;              /*  ƶͨѶGSMʶ: վɫ(BCC) */
}TRRC_APP_GERAN_NCELL_INFO_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_GERAN_NCELL_STRU
 ṹ˵  : TD-SCDMAϵͳGSMСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                        ulNCellNumber;
    TRRC_APP_GERAN_NCELL_INFO_STRU    stCellMeasInfo[TRRC_APP_MAX_NCELL_NUM];
}TRRC_APP_GERAN_NCELL_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_NCELL_INFO_STRU
 ṹ˵  : СͬƵƵԼϵͳ
*****************************************************************************/
typedef struct
{
    TRRC_APP_TDS_NCELL_STRU               stIntraFreqInfo;/* ͬƵϢ*/
    TRRC_APP_TDS_NCELL_STRU               stInterFreqInfo;/* ƵϢ*/
    TRRC_APP_LTE_NCELL_STRU               stLTENcellInfo; /* LTEϵͳ*/
    TRRC_APP_GERAN_NCELL_STRU             stGeranNcellInfo; /* GERANϵͳ */
}TRRC_APP_NCELL_INFO_STRU;

/****************************************************************************
 ṹ    : TRRC_APP_FTM_CHANGE_INFO_STRU
 ṹ˵  : 仯ϱĹģʽṹ
*****************************************************************************/
typedef struct
{
    TRRC_APP_FTM_CHANGE_INFO_TYPE_ENUM_UINT32     ulFtmChangeInfoType;

    union
    {
        TRRC_APP_CHANGE_CELL_INFO_STRU            stCellInfo;
        TRRC_APP_PROTOCOL_STATE_ENUM_UINT8        enTrrcProtocolState;
    }uchangeInfo;
}TRRC_APP_FTM_CHANGE_INFO_STRU;
/*****************************************************************************
 ṹ    : APP_RRC_SINR_INFO_STRU
 ṹ˵  : SINRṹ
*****************************************************************************/
typedef struct
{
	VOS_UINT16                                     usModuFormat;
	VOS_UINT16                                     usTbiOut;
}TRRC_APP_CQI_INFO_STRU;
/*****************************************************************************
 ṹ    : APP_RRC_SINR_INFO_STRU
 ṹ˵  : SINRṹ
*****************************************************************************/
typedef struct
{
    VOS_INT16                              sSinrDB;
    VOS_UINT16                             usRev;
}TRRC_APP_DPCH_SINR_INFO_STRU;
/*****************************************************************************
 ṹ    : TDS_ERRLOG_UL_POWER_STRU
 ṹ˵  : UEз书
*****************************************************************************/
typedef struct
{
	VOS_INT16 sDpchPwr;
	VOS_INT16 sEpuchPwr;
}TDS_APP_ERRLOG_UL_POWER_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ϱĹģʽṹ
*****************************************************************************/
typedef struct
{
    VOS_INT16                           sCellRSCP;
    VOS_UINT16                          usReserved;
    TDS_APP_ERRLOG_UL_POWER_STRU        stUeTxPower;
    TRRC_APP_DPCH_SINR_INFO_STRU        stSINR;             /* SINR  RS_SNR */
    TRRC_APP_CQI_INFO_STRU              stCQI;              /* CQI */
    TRRC_APP_NCELL_INFO_STRU            stNcellInfo;        /*Ϣ*/
}TRRC_APP_FTM_PERIOD_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_INFO_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/
typedef struct
{
    TRRC_APP_FTM_TYPE_ENUM_UINT32             enRrcAppFtmType;

    union
    {
        TRRC_APP_FTM_PERIOD_INFO_STRU         stPeriodInfo;  /* ģʽ£ϱݣ Idle״̬ϱĿǰΪDRXڣConnected״̬Ϊ1 */
        TRRC_APP_FTM_CHANGE_INFO_STRU         stChangInfo;   /* ģʽ£ϱ */
    }u;
}TRRC_APP_FTM_INFO_STRU;
/*****************************************************************************
 ṹ    : TRRC_OM_FTM_REPROT_CONTENT_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/
typedef struct
{
    /* ģID */
    OM_ERR_LOG_MOUDLE_ID_ENUM_UINT32    ulMsgModuleID;

    /* 00, 01 ,10/11:  */
    VOS_UINT16                          usModemId;

    VOS_UINT16                          usProjectID;
    VOS_UINT32                          ulLength;

    TRRC_APP_FTM_INFO_STRU               stTrrcFtmInfo;

}TRRC_OM_FTM_REPROT_CONTENT_STRU;

/*****************************************************************************
 ṹ    : TRRC_OM_FTM_REPROT_IND_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/
/* ģʽϱ  -> OM*/
typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                          ulMsgName;
    VOS_UINT32                          ulMsgType;
    VOS_UINT32                          ulMsgSN;
    VOS_UINT32                          ulRptlen;      /* ģʽϱݳ,ulRptlenΪ0,aucContentݳҲΪ0 */
    TRRC_OM_FTM_REPROT_CONTENT_STRU     stTrrcFtmContent;
}TRRC_OM_FTM_REPROT_IND_STRU;

/*****************************************************************************
                               ERROR LOG ϱݽṹ
*****************************************************************************/

/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ERROR LOG ݽṹ
 ulNextIndexһulNextIndex = 1aenRrcAppErrorCode[0]
 µĴ
 ulNextIndex = 0aenRrcAppErrorCode[0] = TRRC_APP_ERR_CODE_BUTTûб
*****************************************************************************/
typedef struct
{
    VOS_INT32                        ulNextIndex;
    TRRC_APP_ERROR_CODE_ENUM_UINT8   aenRrcAppErrorCode[TRRC_ERRLOG_CODE_MAX_NUM];
}TRRC_APP_ERROR_CODE_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_RECIVE_MSG_STRU
 ṹ˵  : RRC ϢϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                   ulSendPid;    /* Pid */
    VOS_UINT32                   ulMsgName;    /* ϢID */
}TRRC_APP_RECIVE_MSG_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_RECIVE_MSG_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ERRORӡϢṹ
  ulNextIndexһյϢulNextIndex = 1astReciveMsgInfo[0]
 µյϢID
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulNextIndex;
    TRRC_APP_RECIVE_MSG_STRU            astReciveMsgInfo[TRRC_APP_INFO_NUM];
} TRRC_APP_RECIVE_MSG_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_STATE_INFO_STRU
 ṹ˵  : ERROR LOG RRC״̬ϢЭ״̬ڲ״̬ϵͳ
*****************************************************************************/
typedef struct
{
    TRRC_APP_PROTOCOL_STATE_ENUM_UINT8          enTrrcProtocolState;   /* RRCЭ״̬ */
    TRRC_APP_RRC_STATE_ENUM_UINT8               enRrcState;            /* RRC״̬ڲ״̬Э״̬ */
    TRRC_APP_FLOW_CTRL_TYPE_ENUM_UINT16         enErrcFlowCtrlType;    /* TD-SCDMAϵͳʱϵͳ̱ʶ */
}TRRC_APP_STATE_INFO_STRU;
/*****************************************************************************
 ṹ    : TRRC_APP_EST_INFO_STRU
 ṹ˵  : ERROR LOG RRC״̬Ϣ
 enEstSignallingType[0]:CS;enEstSignallingType[1]:ps
*****************************************************************************/
typedef struct
{
    TRRC_APP_EST_SIGNALLING_TYPE_UINT32        enEstSignallingType[2];
    TRRC_APP_EST_CAUSE_ENUM_UINT32             enEstCause;
}TRRC_APP_EST_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    TRRC_APP_RECIVE_MSG_INFO_STRU     stRrAppReciveMsgInfo;
    TRRC_APP_STATE_INFO_STRU          stRrcAppStateInfo;
    TRRC_APP_EST_INFO_STRU            stRrcAppEstInfo;

}TRRC_APP_ERR_LOG_RRC_INFO_STRU;

/*****************************************************************************
 ṹ    : TRRC_APP_ERR_LOG_INFO_STRU
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    TRRC_APP_ERROR_CODE_INFO_STRU    stErrorCodeInfo;
    TRRC_APP_ERR_LOG_RRC_INFO_STRU   stErrorLogInfo;
}TRRC_APP_ERR_LOG_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    /* ģID */
    OM_ERR_LOG_MOUDLE_ID_ENUM_UINT32    ulMsgModuleID;

    /* 00, 01 ,10/11:  */
    VOS_UINT16                          usModemId;

    /*  sub sys,modeule,sub module   ݲʹ   */
    VOS_UINT16                          usALMID;

    /* ERR LOGϱ,
    Warning0x04ʾ
    Minor0x03Ҫ
    Major0x02Ҫ
    Critical0x01    */
    VOS_UINT16                          usALMLevel;

    /* ÿERR LOG:
    &澯
    ͨţ0x00
    ҵ0x01
    0x02
    豸ϣ0x03
    ϣ0x04    */
    VOS_UINT16                          usALMType;

    VOS_UINT32                          usAlmLowSlice;/*ʱ*/
    VOS_UINT32                          usAlmHighSlice;

    VOS_UINT32                          ulAlmLength;
    TRRC_APP_ERR_LOG_INFO_STRU          stAlmInfo;
}TRRC_OM_ERR_LOG_INFO_STRU;

/*****************************************************************************
 ṹ    : OM_ERR_LOG_REPORT_CNF_STRU
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                          ulMsgName;
    VOS_UINT32                          ulMsgType;
    VOS_UINT32                          ulMsgSN;
    VOS_UINT32                          ulRptlen;      /* ݳ,ulRptlenΪ0,aucContentݳҲΪ0 */
    TRRC_OM_ERR_LOG_INFO_STRU           stAppFtmInfo;
} TRRC_OM_ERR_LOG_REPORT_CNF_STRU;

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/






#if (VOS_OS_VER == VOS_WIN32)
#pragma pack()
#else
#pragma pack(0)
#endif




#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of TrrcErrLogInterface.h */


