/******************************************************************************

    Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : TPsTPhyInterface.h
  Description     : TPsTPhyInterface.h header file
  History           :
     1.XiaoJun 58160      2012-9-4  Draft
     2.
******************************************************************************/

#ifndef __TPSTPHYINTERFACE_H__
#define __TPSTPHYINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#ifndef LPS_RTT
#include "vos.h"
#include "LPSCommon.h"
#else
#define PS_MSG_ID_TDS_PS_BASE   0x1355
#define VOS_MSG_HEADER
#endif

/*#include "pccdef.h" */

/*#include "asn.h" */

/*#pragma pack(4) */
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 macro
*****************************************************************************/

#if 0
typedef unsigned char		u8;
typedef unsigned short		u16;
typedef unsigned int		u32;
typedef signed   short		s16;
#endif

#define hiPDSCHidentities          1   
#define hiPUSCHidentities          1   
#define hiRM                       256 
#define maxAC                      16  
#define maxAdditionalMeas          4   
#define maxASC                     8   
#define maxASCmap                  7   
#define maxASCpersist              6   
#define maxCCTrCH                  1   
#define maxCellMeas                32  
#define maxCellMeas_1              31  
#define maxCNdomains               2   
#define maxCPCHsets                1   
#define maxDPCH_DLchan             8   
#define maxDPDCH_UL                6   
#define maxDRACclasses             1   
#define maxFACHPCH                 8   
#define maxFreq                    8   
#define maxFreqBandsFDD            1   
#define maxFreqBandsTDD            4   
#define maxFreqBandsGSM            1   
#define maxHProcesses              8   
#define maxHSSCCHs                 4   
#define maxInterSysMessages        4   
#define maxLoCHperRLC              2   
#define maxMAC_d_PDUsizes          8   
#define maxMeasEvent               8   
#define maxMeasIntervals           3   
#define maxMeasParEvent            2   
#define maxNumCDMA2000Freqs        1   
#define maxNumGSMFreqRanges        1   
#define maxNumFDDFreqs             1   
#define maxNumTDDFreqs             8   
#define maxNoOfMeas                16  
#define maxOtherRAT                1   
#define maxOtherRAT_16             1   
#define maxPage1                   8   
#define maxPCPCH_APsig             1   
#define maxPCPCH_APsubCh           1   
#define maxPCPCH_CDsig             1   
#define maxPCPCH_CDsubCh           1   
#define maxPCPCH_SF                1   
#define maxPCPCHs                  1   
#define maxPDCPAlgoType            8   
#define maxPDSCH                   1   
#define maxPDSCH_TFCIgroups        1   
#define maxPRACH                   16  
#define maxPRACH_FPACH             8   
#define maxPredefConfig            16  
#define maxPUSCH                   1   
#define maxRABsetup                16  
#define maxQueueIDs                8   
#define maxRAT                     1   
#define maxRB                      10  
#define maxRBallRABs               27  
#define maxRBMuxOptions            4   
#define maxRBperRAB                3   
#define maxReportedGSMCells        8   
#define maxRL                      1   
#define maxRL_1                    1   
#define maxROHC_PacketSizes_r4     16  
#define maxROHC_Profile_r4         16  
#define maxSat                     16  
#define maxSCCPCH                  16  
#define maxSIB                     32  
#define maxSIB_FACH                8   
#define maxSIBperMsg               16  
#define maxSRBsetup                8   
#define maxSystemCapability        1   
#define maxTDD128Carrier           6   
#define maxTF                      24  
#define maxTF_CPCH                 1   
#define MAX_SIB16_INSTANCE         16 

/* lidui add for ASN MEASUREMENT CONTROL begin */
#define maxNumEUTRAFreqs           8    
#define maxEUTRACellPerFreq        16   
#define maxGANSSSat                64   
#define maxMeasCSGRange            4    
#define maxSIrequest               4    
#define maxCellMeasOnSecULFreq     32   
#define maxMeasEventOnSecULFreq    8    
#define maxMeasOccasionPattern     5    
#define maxCommonHRNTI             4    
#define maxEDCHs                   32   
#define maxERUCCH                  256  
#define maxERNTIgroup              32   
#define maxERNTIperGroup           2    
#define maxDedicatedCSGFreq        4    
#define maxPrio                    8    
#define maxNumGSMCellGroup         16   
#define maxHNBNameSize             48   
#define maxGANSS                   8    
#define maxSgnType                 8    
#define maxReportedEUTRAFreqs      4    
#define maxReportedEUTRACellPerFreq 4   
/* lidui add for ASN MEASUREMENT CONTROL end */

#ifndef TEST_RRC_ARM_TTCN
#define maxTFC                     128   
#else
#define maxTFC                     32
#endif

#define maxTFCsub                  60  
#define maxTFCI_2_Combs            1   
#define maxTGPS                    1   
#define maxTrCH                    6   
#define maxTrCHpreconf             6   
#define maxTS                      6   
#define maxTS_1                    5   
#define maxTS_LCR                  6   
#define maxTS_LCR_1                5   
#define maxURA                     8   
#define MAX_DPCH_DATA_LEN			1500

/* add for mbms 20071226*/
#define MAX_TDM_NUM                6

/* add for hsupa 20080612*/
#define maxMacDFlow                8
#define maxBeta                    8
#define maxEagch                   4
#define maxEhich                   4
#define maxPrach                   2
#define maxE_DCHMACdFlow           8
#define maxNumEagch                4
#define maxNumEhich                4
#define maxRlcPduSize              32

/* lidui add for ASN DECODE begin */
#define ulbitMask_1                0x00000001
#define ulbitMask_2                0x00000003
#define ulbitMask_3                0x00000007
#define ulbitMask_4                0x0000000f
#define ulbitMask_5                0x0000001f
#define ulbitMask_6                0x0000003f
#define ulbitMask_7                0x0000007f
#define ulbitMask_8                0x000000ff
#define ulbitMask_9                0x000001ff
#define ulbitMask_10               0x000003ff
#define ulbitMask_11               0x000007ff
#define ulbitMask_12               0x00000fff
#define ulbitMask_13               0x00001fff
#define ulbitMask_14               0x00003fff
#define ulbitMask_15               0x00007fff
#define ulbitMask_16               0x0000ffff
#define ulbitMask_17               0x0001ffff
#define ulbitMask_20               0x000fffff
#define ulbitMask_22               0x003fffff
#define ulbitMask_24               0x00ffffff
#define ulbitMask_30               0x3fffffff
#define ulbitMask_32               0xffffffff
/* lidui add for ASN DECODE end */


/* define constance for DHI work mode*/
#define  DHI_NORMAL
#define  DHI_TEST
#define  DHI_INVALID

#ifdef SDL
#define  MAX_DHI_DATA_LEN  304
#else
#define  MAX_DHI_DATA_LEN  704
/*#define  MAX_DHI_DATA_LEN_SCCPCH 1408*/
#endif

#define  MAX_HS_PDU_LEN    1800
#define  maxIntraCellNum   32
#define  maxIscpNum        32
/* xrm modify begin */
#if 0
#define maxMeasFreq 3
#endif
#define maxMeasFreq 9
/* xrm modify end */
#define maxIscpMeasFreq 3
#define maxMeasNum 64
#define maxFreqBand 12
#define maxPoint 36
#define maxCellNum 64

/*add for dm*/
#define maxBsicNum   8
#define maxGsmCellNum            32

#define MAX_TMSI_LEN                    4
#define MAX_PTMSI_LEN                   4

/*moved from hl1_mac.het  ylm 20100805*/
#define  MAX_DHI_LEN                     2100


#define MAX_PDCP_HEADER_LEN             3

#define MAX_FRAME_NUM                   8192 /* sub frame*/

#define TPDC_DATA_REQ_QUE_SIZE           512

#define TDS_MAX_BAR_CELLID			8
#define TDS_MAX_FREQ                    (24) /*һͬƵ+8Ƶ*/
#define TDS_MAX_DETECT_CELL_PER_FREQ    (6)/*һƵdetectС*/
/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
enum
{
      /*TPS-->TPhy Request  Begin*/
        OP_L1_NULL_REQ                  = (PS_MSG_ID_TDS_PS_BASE + 0x0000),  /*PS_MSG_ID_TDS_PS_BASE = 0x1355(4949)*/

        OP_L1_CELL_MEAS_REQ,
        OP_L1_HW_PARA_INIT_REQ,
        OP_L1_ICS_MEAS_REQ,
        OP_L1_FREQ_ADJUST_REQ,
        OP_L1_MIDAMBLE_READ_REQ,
        OP_L1_FREQ_FINE_REQ,
        OP_L1_PHASE_DETECT_REQ,
        OP_L1_PCCPCH_READ_REQ,
        OP_L1_PICH_READ_REQ,
        OP_L1_IDL_MEAS_REQ,    /*10*/
        OP_L1_PRACH_SEND_REQ,
        OP_L1_SCCPCH_READ_REQ,
        OP_L1_DPCH_CONFIG_REQ,
        OP_L1_DPCH_SEND_REQ,
        OP_L1_VCD_REQ,

        OP_L1_DCH_MEAS_REQ,
        OP_L1_HO_SYNC_SEND_REQ,
        OP_L1_PWR_SWEEP_REQ,
        OP_L1_CELL_SEARCH_REQ,
        OP_L1_HL1_SFN_REQ,        /*20*/
        OP_L1_LOOP_TEST_REQ,
        OP_L1_IDL_TASK_REQ,
        OP_L1_HSPDSCH_CONFIG_REQ,
        //OP_L1_IDL_TASK_REQ,

        // add for mbms 20071227
        OP_L1_MCCH_READ_REQ,
        OP_L1_MTCH_READ_REQ,
        OP_L1_MBMS_STOP_REQ,

        OP_L1_EPUCH_CONFIG_REQ,
        OP_L1_EPUCH_SEND_REQ,
        // 20090928  PDM100 UMAC
        OP_L1_BSIC_REQ,
        OP_L1_STOP_BSIC_REQ,       /*30*/
        OP_L1_PRE_SYNC_REQ,
        OP_L1_GAP_INFO_REQ,
        OP_L1_IRAT_MEAS_REQ,
        OP_L1_IRAT_INACTIVE_REQ,
        OP_RABMCOM_DATA_REQ,

        /* TDSģDCH̬£ʹôԭｫGLƵ֪ͨTDSPG/LƵΪ0ʾͷš */
        ID_TMAC_TPHY_IRAT_MEAS_REQ,

        /* ͷԭ */
        ID_TMAC_TPHY_REL_REQ,      /*37*/
        ID_L2_HPA_STATE_CHANGE_REQ,
        ID_TRRC_TPHY_SET_WORK_MODE_REQ,
        OP_L1_IDL_PCH_REQ,/*modify by l00213440 for IDL_TASK_REQ*/
        /* MTC NOTCH add begin */
        ID_TRRC_TPHY_NOTCH_REQ,
        /* MTC NOTCH add end */


        /* DTS2013011700904 T2G frame for Bsic begin */
        ID_TMAC_TPHY_BSIC_FRAME_REQ,
        /* DTS2013011700904 T2G frame for Bsic end */

        /*DTS2014021900886 BEGIN */
        ID_TPHY_STOP_CELL_SELECT_REQ,
        /*DTS2014021900886 BEGIN */

        ID_TMAC_TPHY_REQ_BUTT,    /*butten*/

        /*---------------------------------TPS-->TPhy Request  End---------------------------------*/


        /*-------------------------------TPhy-->TPS  Cnf & Ind Begin-------------------------------*/

        //OP_L1_VB_SYNC                   = (PS_MSG_ID_TDS_PS_BASE + 0x0032),
        /* DTS2013122807355 modify by k00228722 begin */
        /* OP_L1_VB_SYNC,*/
        OP_L1_VB_SYNC                   = (PS_MSG_ID_TDS_PS_BASE + 0x0050),
        /* DTS2013122807355 modify by k00228722 end */
        OP_L1_CELL_MEAS_CNF,
        OP_L1_ICS_MEAS_CNF,
        OP_L1_FREQ_ADJUST_CNF,
        OP_L1_MIDAMBLE_READ_CNF,
        OP_L1_FREQ_FINE_CNF,
        OP_L1_PHASE_DETECT_CNF,
        OP_L1_PCCPCH_READ_CNF,
        OP_L1_PICH_READ_IND,
        OP_L1_IDL_MEAS_IND,
        OP_L1_FPACH_READ_CNF,    /*10*/
        OP_L1_SCCPCH_READ_IND,
        OP_L1_DPCH_READ_IND,
        OP_L1_DPCH_SYNC_IND,

        /* OP_L1_DCH_MEAS_REQĻظ */
        ID_L1_DCH_MEAS_CNF,
        OP_L1_DCH_MEAS_IND,
        OP_L1_PWR_SWEEP_CNF,
        OP_L1_CELL_SEARCH_CNF,
        OP_L1_DSP_CNF,
        OP_L1_FCH_MEAS_IND,
        OP_L1_HSPDSCH_READ_IND, /*20*/

        //20100406
        OP_L1_ZSP_ABNORMAL_IND,
        //OP_L1_HSUPA_INFO_IND
        OP_L1_HSUPA_INFO_IND,
        OP_L1_HARQ_IND,

        //20090928 PDM100 UMAC
        /* OP_L1_BSIC_REQĻظ */
        ID_L1_BSIC_CNF,
        OP_L1_BSIC_IND,
        OP_L1_STOP_BSIC_CNF,
        //gongjian 20101123  D_PS_PDM100_UMAC_V0.6.3_003
        OP_L1_PRE_SYNC_CNF,
        OP_L1_IRAT_MEAS_IND,
        OP_L1_IRAT_INACTIVE_CNF,
        OP_L1_GAP_END_IND,  /*30*/

        OP_HL1_SCHEDULE_IND,
        OP_HL1_END,

        OP_RABMCOM_DATA_IND,
        OP_RABMCOM_SUSPEND_IND,
        OP_RABMCOM_RESUME_IND ,

        /* OP_L1_IRAT_MEAS_REQĻظ */
        ID_L1_IRAT_MEAS_CNF,

        /* ID_TMAC_TPHY_IRAT_MEAS_REQĻظ */
        ID_TMAC_TPHY_IRAT_MEAS_CNF,

        /* ͷԭ */
        ID_TMAC_TPHY_REL_CNF,

        /* ϱLoadDspز*/
        ID_L1_DYNA_LOAD_DSP_IND ,/*39*/
        ID_L2_HPA_STATE_CHANGE_CNF,
        ID_TRRC_TPHY_SET_WORK_MODE_CNF,
        OP_L1_IDL_PCH_IND,/*modify by l00213440 for IDL_TASK_REQ*/
        ID_TRRC_TPHY_ERRLOG_IND,//by wxm errlog

        /*DTS2014021900886 BEGIN */
        ID_TPHY_STOP_CELL_SELECT_CNF,
        /*DTS2014021900886 BEGIN */

        ID_TRRC_TPHY_BUTT

      /*TPhy-->TPS  Cnf & Ind End*/

    };
typedef VOS_UINT32    TPS_TPHY_MSG_ID_ENUM_UINT32;

/* xrm add begin */
/*****************************************************************************
 ö    : TDS_REL_CAUSE_ENUM
 ṹ˵  : ʶͷŵԭ
 ͷԭֵ
*****************************************************************************/
enum TDS_REL_CAUSE_ENUM
{
    TDS_REL_CAUSE_TDS_MEAS = 0x01,
    TDS_REL_CAUSE_GSM_MEAS = 0x02,
    TDS_REL_CAUSE_LTE_MEAS = 0x04,
    TDS_REL_CAUSE_WCDMA_MEAS = 0x08,
    TDS_REL_CAUSE_BUTT
};
typedef VOS_UINT16 TDS_REL_CAUSE_ENUM_UINT16;

/*****************************************************************************
 ö    : TDS_RESULT_ENUM
 ṹ˵  : ʶ

*****************************************************************************/
enum TDS_RESULT_ENUM
{
    TDS_RESULT_SUCC,
    TDS_RESULT_FAIL,
    TDS_RESULT_BUTT
};
typedef VOS_UINT16 TDS_RESULT_ENUM_UINT16;

/*****************************************************************************
   5 STRUCT
*****************************************************************************/
/*DTS2014021900886 BEGIN */
/*****************************************************************************
 ṹ    : TRRC_TPHY_STOP_CELL_SELECT_CAUSE_ENUM
 Э  :
 ASN.1 :
 ṹ˵  : ֹͣСԭ
*****************************************************************************/
enum TRRC_TPHY_STOP_CELL_SELECT_CAUSE_ENUM
{
    TRRC_TPHY_STOP_CELL_SELECT_RESEARCH_STOP,   /*ҪС*/

    TRRC_TPHY_STOP_CELL_SELECT_BUIT
};
typedef VOS_UINT16 TRRC_TPHY_STOP_CELL_SELECT_CAUSE_ENUM_UINT16;
/*****************************************************************************
 ṹ    : TRRC_TPHY_STOP_CELL_SELECT_RLST_ENUM
 Э  :
 ASN.1 :
 ṹ˵  : ֹͣСԭ
*****************************************************************************/
enum TRRC_TPHY_STOP_CELL_SELECT_RLST_ENUM
{
    TRRC_TPHY_STOP_CELL_SELECT_CNF_SUCC,   /*ֹͣɹ*/
    TRRC_TPHY_STOP_CELL_SELECT_CNF_FAIL,
    TRRC_TPHY_STOP_CELL_SELECT_CNF_BUIT
};
typedef VOS_UINT16 TRRC_TPHY_STOP_CELL_SELECT_RLST_ENUM_UINT16;

/*****************************************************************************
 ṹ    : TRRC_TPHY_STOP_CELL_SELECT_REQ
 Э  :
 ASN.1 :
 ṹ˵  : ֹ֪ͨͣǰС
*****************************************************************************/

typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                                        enMsgId;
    VOS_UINT16                                        usOpId;
    TRRC_TPHY_STOP_CELL_SELECT_CAUSE_ENUM_UINT16      enStopCause;    /*ֹͣԭ */

}TRRC_TPHY_STOP_CELL_SELECT_REQ;
/*****************************************************************************
 ṹ    : TRRC_TPHY_STOP_CELL_SELECT_CNF
 Э  :
 ASN.1 :
 ṹ˵  : ظֹͣ
*****************************************************************************/

typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                                        enMsgId;
    VOS_UINT16                                        usOpId;
    TRRC_TPHY_STOP_CELL_SELECT_RLST_ENUM_UINT16       enStopRlst;    /*ֹͣ*/

}TRRC_TPHY_STOP_CELL_SELECT_CNF;

/*DTS2014021900886 END */


typedef struct
{
    VOS_UINT16          usFreq;
    VOS_UINT8           ucRssiLvl;
    VOS_UINT8           ucCellNum;
    VOS_UINT8           aucCellid[TDS_MAX_DETECT_CELL_PER_FREQ];
    VOS_UINT8           aucRscpLvl[TDS_MAX_DETECT_CELL_PER_FREQ];
    VOS_UINT8           aucIscpLvl[TDS_MAX_DETECT_CELL_PER_FREQ];
}T_DETECT_CELL_STRU;
typedef struct
{
    VOS_UINT16          usFreqNum;
    VOS_UINT16          usRsv;
    T_DETECT_CELL_STRU  astDetectCell[TDS_MAX_FREQ];
}T_DETECT_CELL_LIST_STRU;
//-----------------------------------------------------------------------------
typedef struct T_SemistaticTfInformation_DHI_Tag
{
  VOS_UINT16      channelCodingType;
  VOS_UINT16      rateMatchingAttribute;
  VOS_UINT16      crcSize;
  VOS_UINT16      reserved;              // for align

}T_SemistaticTfInformation_DHI;

typedef struct T_TransportFormat_DHI_Tag
{
  VOS_UINT16      tti;
  VOS_UINT16      tbNum;
  VOS_UINT16     tbSize;
  VOS_UINT16      reserved;
}T_TransportFormat_DHI;

typedef struct  T_PlmnReduce_Tag
{
  VOS_UINT16       mcc;//Mobile Colour Code (octet 1, octet 2 bits 1 to 4)
  VOS_UINT16       mnc;  //Mobile Network Code (octet 3, octet 2bits 5 to 8);
}T_PlmnRedcue;

typedef struct T_TmsiAndLaiReduce_Tag
{
  VOS_UINT16                            tmsi[MAX_TMSI_LEN];
  T_PlmnRedcue            plmnIdentity;//???? where definated???
  VOS_UINT16                            reserved;
  VOS_UINT16                            lac;//BIT STRING (SIZE (16))
}T_TmsiAndLaiReduce;

typedef struct T_PTmsiAndRaiReduce_Tag
{
  VOS_UINT16                             pTmsi[MAX_PTMSI_LEN];
  T_PlmnRedcue             plmnIdentity;//??????
  VOS_UINT16                             lac;//BIT STRING (SIZE (16))
  VOS_UINT16                             rac;
}T_PTmsiAndRaiReduce;

typedef struct T_InitialUeIdentity_Tag
{
  VOS_UINT16                             ueIdType; // 1st bit:imeisv; 2st bit: imei;3rd bit: imsi;4th bit:tmsi 5th bit:p_tmsi:
  VOS_UINT16                             imsiLen;
  VOS_UINT16                             imsi[15];  // 15 digits content .not include odd/even digit
  T_TmsiAndLaiReduce    tmsiAndLai;
  T_PTmsiAndRaiReduce pTmsiAndRai;
  VOS_UINT16                             imeiLen;
  VOS_UINT16                             reserved;
  VOS_UINT16                             imei[15];//// 15 digit content .
  VOS_UINT16                             rrcMode;
  VOS_UINT16                             uRnti[2];
  VOS_UINT16  reserved2;/*modify by l00213440 for 4 byte*/
}T_InitialUeIdentity;

#if defined(TEST_DHI_ARM_TTCN)||defined(TEST_MAC_ARM_TTCN)
typedef struct T_RRC_RbInformationSetupList_Temp_Tag
{
  VOS_UINT8                             rbIdentity;
  VOS_UINT8                             rbStarted;  // 0x00: not created; 0x01: created; 0x02: will deleted
  //T_RRC_RbCtrlParam
  VOS_UINT8                             configCause;
  VOS_UINT8                             rlcModeDw;
  VOS_UINT8                             segmentationIndication;  //T_TmDwParas 0: not segmentation  1:need segmentation
  VOS_UINT8                             dlRlcLiSize;             //T_UmParas
  VOS_UINT8                             pdcpPduHeader;  // T_PdcpInfo 0:present; 1:absent
  VOS_UINT8                             pdcpPresent;//
  VOS_UINT16                            amDlRlcPduSize;
}T_RRC_RbInformationSetupList_Temp;

typedef struct T_RRC_RabInfo_Temp_Tag
{
  VOS_UINT8                             rbNum;
  VOS_UINT8                             rabIdentity;
  T_RRC_RbInformationSetupList_Temp   rbInformationSetupList[maxRBperRAB];
}T_RRC_RabInfo_Temp;//10.3.4

typedef struct T_RRC_EstablishedRabs_Temp_Tag
{
  VOS_UINT8                             rabNum;
  VOS_UINT8                             srbNum;
  T_RRC_RabInfo_Temp                  rabInfo[maxRABsetup];
  T_RRC_RbInformationSetupList_Temp              srbInformationSetup[maxSRBsetup];
}T_RRC_EstablishedRabs_Temp;//13.4.5

typedef struct T_EdchMacdFlow_Temp_Tag{
  VOS_UINT8          macdFlowId;
  VOS_UINT8          macdFlowMulti;
}T_EdchMacdFlow_Temp;

typedef struct T_MacdFlowInfo_Temp_Tag
{
  VOS_UINT8                      machsQueueId;
  VOS_UINT8                      macdPduSizeNum;
  VOS_UINT16                     macdPduSize[maxMAC_d_PDUsizes];
}T_MacdFlowInfo_Temp;

typedef struct T_AgchInfo_Temp_Tag
{
  VOS_UINT8          rdiInd;
}T_AgchInfo_Temp;

typedef struct T_UlLogicalChannelMapping_Temp_Tag
{
  VOS_UINT8                      transportChType;//dch:0;rach:1;e-dch:2
  VOS_UINT8                      transportChId;
  VOS_UINT8                      ddi;
  VOS_UINT8                      scheduleInd;
  VOS_UINT8                      logicalChId;
  VOS_UINT8                      numRlcPduSize;
  VOS_UINT8                      logicalChPriority;
  VOS_UINT16                     rlcPduSizeList[maxRlcPduSize];
  VOS_UINT32                     rlcSizeList;//bitmap
}T_UlLogicalChannelMapping_Temp;

typedef struct T_DlLogicalChannelMapping_Temp_Tag
{
  VOS_UINT8                      logicalChId;
  VOS_UINT8                      transportChType;//dch:0;fach:1;hsdsch:3//20070129; dch_hsdsch:0x30//20070308
  VOS_UINT16                     transportChId;  //higher 8 bit: dsch lower 8 bit:dch
                                          //if dch_and_dsch is present
                                          //20070129 equal to MAC-d-FlowIdentity if transportChType is hsdsch
                                          //20070308 high 8 bits is MAC-d-FlowIdentity,low 8 bits is dch id if
                                          //transportChType is dch_hsdsch
}T_DlLogicalChannelMapping_Temp;


typedef struct T_RbMappingOption_Temp_Tag
{
  VOS_UINT8                        loChNum;//20080904 for uplink
  VOS_UINT8                        loChNumDl;//20080904 for downlink
  T_UlLogicalChannelMapping_Temp ulLoChMappings[maxLoCHperRLC];
  T_DlLogicalChannelMapping_Temp dlLoChMappings[maxLoCHperRLC];
}T_RbMappingOption_Temp;

typedef struct T_RbInformationSetup_Temp_Tag
{
  VOS_UINT8                      rbIdentity;
  VOS_UINT8                      serviceType;//signalling:0x00;ps data:0x01;cs data subA:0x02;
                                      //cs data subB:0x03;cs data subC:0x04
  VOS_UINT8                      ulRlcMode;//TM:0;UM:1;AM:2
  VOS_UINT8                      ulTmSegmentation;//may not segmentation:0;may segmentation:1
  VOS_UINT8                      rbMuxNum;
  VOS_UINT8                      reserved;
  T_RbMappingOption_Temp  rbMappingInfo[maxRBMuxOptions];
}T_RbInformationSetup_Temp;

typedef struct T_UlTransChInfo_Temp_Tag
{
  VOS_UINT8                         trchNum;//for one CCTrCH
  VOS_UINT8                         reserved;
  VOS_UINT8                         transportChType[maxTrCH];
  VOS_UINT8                         transportChId[maxTrCH];
  T_SemistaticTfInformation_DHI  semistaticTfInformation[maxTrCH];
  VOS_UINT16                        allowedTfcNum;
  VOS_UINT8                         gainFactorBetaD[maxTFC];//0..15
  VOS_UINT8                         referenceTfcId[maxTFC];//0..3
  T_TransportFormat_DHI          allowedTfcList[maxTFC][maxTrCH];//maxTFC=1024
  VOS_UINT16                        allowedTfcValue[maxTFC];//for tfci
  VOS_UINT16                        minimumTfcNum;
  VOS_UINT16                        minimumTfcValue[maxTFC];
}T_UlTransChInfo_Temp;

typedef struct T_UlCctrchInfo_Temp_Tag
{
  T_UlTransChInfo_Temp         transChInfo;
}T_UlCctrchInfo_Temp;


typedef struct T_DlTransChInfo_Temp_Tag
{
  VOS_UINT8                         trchNum;//for one CCTrCH
  VOS_UINT8                         transportChType[maxTrCH];
  VOS_UINT8                         transportChId[maxTrCH];
  VOS_UINT8                         blerQualityValue[maxTrCH];
  T_SemistaticTfInformation_DHI  semistaticTfInformation[maxTrCH];
  VOS_UINT16                        tfcNum;
  T_TransportFormat_DHI          tfcList[maxTFC][maxTrCH];//maxTFC=1024
}T_DlTransChInfo_Temp;

typedef struct T_DlCctrchInfo_Temp_Tag
{
  T_DlTransChInfo_Temp         transChInfo;
}T_DlCctrchInfo_Temp;

typedef struct T_CctrchInfo_Temp_Tag
{
  VOS_UINT8                           ulCctrchNum;
  VOS_UINT8                           dlCctrchNum;
  T_UlCctrchInfo_Temp          ulCctrchInfo[maxCCTrCH];
  T_DlCctrchInfo_Temp          dlCctrchInfo[maxCCTrCH];
}T_CctrchInfo_Temp;


typedef struct T_CMAC_DCH_CONFIG_REQ_TEMP_Tag
{
  VOS_UINT32                     uRnti;
  VOS_UINT16                     cRnti;
  VOS_UINT8                      rdiInd;
  VOS_UINT8                      rbNum;
  VOS_UINT8                      tsnLength;
  VOS_UINT8                      queueIdsNum;
  VOS_UINT8                      eDchMacdFlowNum;
  VOS_UINT8                      reserved;
  T_EdchMacdFlow_Temp          eDchMacdFlow[maxMacDFlow];
  T_MacdFlowInfo_Temp        macdFlowInfo[maxQueueIDs];
  T_RbInformationSetup_Temp    rbInfoSetupList[maxRB];
  T_CctrchInfo_Temp            cctrchInfo;
}T_CMAC_DCH_CONFIG_REQ_TEMP;

#endif


//-----------------------------------------------------------------------------
typedef struct T_ResourceDesc_Tag
{
  VOS_UINT8   timeslotNumber;
  VOS_UINT8   midambleAllocationMode;
  VOS_UINT8   midambleShift;
  VOS_UINT8   midambleConfiguration;
} T_ResourceDesc;

typedef struct T_BcInfo_Tag
{
  VOS_UINT16  modulateMode;
  VOS_UINT16  midambleAllocMode;
  VOS_UINT16  midambleShift;
  VOS_UINT16  midambleConfiguration;
  VOS_UINT16  cellId;
  VOS_UINT16  channelCode[2];
  VOS_UINT16  sf[2];
  VOS_UINT16  reserved;
}T_BcInfo;

typedef struct T_CcInfo_Tag
{
  VOS_UINT16 trchNum;
  VOS_UINT16 ruSf1[maxTS_1];
  VOS_UINT16 ruSf2[maxTS_1];
  VOS_UINT16 tsNum;
  VOS_UINT16 serviceType[maxTrCH];
  VOS_UINT16 puncturingLimit;
  VOS_UINT16 modulateMode[maxTS_1];
  VOS_UINT16 dynamicSF;
  VOS_UINT16 interSecondMode;
  VOS_UINT16 allowedTfcNum;
  VOS_UINT16 tfciCode[maxTS_1];
  VOS_UINT16 ssTpcSymbols[maxTS_1];
  VOS_UINT16 reserved;
  VOS_UINT16 tfNum[maxTrCH];
  VOS_UINT16 allowedTfci[maxTFC];
  T_TransportFormat_DHI tfList[maxTrCH][maxTF];
  VOS_UINT16 ctfc[maxTFC];
  T_SemistaticTfInformation_DHI semistaticTfInformation[maxTrCH];
  VOS_UINT16 ruNum[maxTS_1];
  VOS_UINT16 minimumTfcNum;
  VOS_UINT16 minimumTfci[maxTFC];
  VOS_UINT16 additionalSsTpcSymbols[maxTS_1];
  VOS_UINT16 referenceTfcId;
  VOS_UINT16 gainFactor;
  VOS_UINT16 reserved1;
}T_CcInfo;

typedef struct T_CdInfo_Tag
{
  VOS_UINT16  ccTrchId;
  VOS_UINT16  trchNum;
  VOS_UINT16  puncturingLimit;
  VOS_UINT16  tsNum;
  VOS_UINT16  tfcNum;
  VOS_UINT16  secondInterleavingMode;
  VOS_UINT16  dwDpchOffset;
  VOS_UINT16  serviceType[maxTrCH];
  VOS_UINT16  tfciCoding[maxTS_1];
  VOS_UINT16  modulation[maxTS_1];
  VOS_UINT16  ssTpcSymbols[maxTS_1];
  VOS_UINT16  sf[maxTS_1];
  VOS_UINT16  allowedRuNum[maxTS_1];
  VOS_UINT16  ctfc[maxTFC];
  VOS_UINT16  tfNum[maxTrCH];
  T_TransportFormat_DHI  tfList[maxTrCH][maxTF];
  VOS_UINT16  additionalSsTpcSymbols[maxTS_1];
  VOS_UINT16  reserved;
  T_SemistaticTfInformation_DHI  semistaticTfInformation[maxTrCH];
}T_CdInfo;

typedef struct T_CellDescDhi_Tag
{
  VOS_UINT16  frequency;
  VOS_UINT16  cellId;
}T_CellDescDhi;

typedef struct T_DriverInfo_Tag
{
  VOS_UINT16 tsId;
  VOS_UINT16 freq;
}T_DriverInfo;

typedef struct T_DwCrl_Tag
{
  VOS_UINT16  rxTsNum;
  VOS_UINT16  blerQualityValue[maxTrCH];
  VOS_UINT16  rxRepetitionPeriod;
  VOS_UINT16  rxRepetitionLen;
  VOS_UINT16  dlcctrchOffset;
  VOS_UINT16  targetSir;
  VOS_UINT16  scellPathLoss;  //for align to TCN360_V1.10.0  gongjian  20100914
}T_DwCrl;

typedef struct T_EpuchCcInfo_Tag
{
  VOS_UINT16  qpskOr16Qam;
  VOS_UINT16  rsn;
  VOS_UINT16  tbsizeIndex;
  VOS_UINT16  prri;
  VOS_UINT16  crri;
  VOS_UINT16  trri;
  VOS_UINT16  nEucchNumInd;
  VOS_UINT16  tbSize;
}T_EpuchCcInfo;

typedef struct T_FreqBand_Tag
{
  VOS_UINT16   startPoint;
  VOS_UINT16   endPoint;
}T_FreqBand;

/*begin: modify by l00213440 for HPA*/
typedef struct T_HeaderInfo_Tag
{
  VOS_UINT32   primitiveFlag;  /*HPAΪu32ᵽṹ忪ʼλ*/
  VOS_UINT16   subFrameNum;
  VOS_UINT16   workMode;
  VOS_UINT16   stateFlag;
  VOS_UINT16   spareLen;       /*20041124 acording DHI v1.1.2 2004-11-15*/
  VOS_UINT16   length;
  VOS_UINT16   reserved;       /*һu16ֶνж*/
} T_HeaderInfo;
/*end: modify by l00213440 for HPA*/

typedef struct T_JdInfo_Tag
{
   VOS_UINT16  tsId;
   VOS_UINT16  freq;
   VOS_UINT16  physicalType;
   VOS_UINT16  codeNum;
   VOS_UINT16  code[16];
   VOS_UINT16  sf;
   VOS_UINT16  midambleConfiguration;
   VOS_UINT16  midambleShift;
   VOS_UINT16  midambleAllocationMode;
   VOS_UINT16  modulationMode;
   VOS_UINT16  cellId;
}T_JdInfo;

typedef struct T_HsscchInfoDhi_Tag
{
  T_JdInfo hsScchInfo;
  VOS_UINT16 blerTarget;
  VOS_UINT16 hssichTimeslotNumber;
  T_BcInfo hsSichBcInfo;
  VOS_UINT16 nackAckPowerOffset;
  VOS_UINT16 powerLevelHssich;
  VOS_UINT16 tpcStepSize;
  VOS_UINT16 reserved;
}T_HsscchInfoDhi;

typedef struct T_HsdpaInfo_Tag
{
  VOS_UINT16  uarfcnCarrier;
  VOS_UINT16  harqNumberOfProcesses;
  VOS_UINT16  harqMemorySize[maxHProcesses];
  VOS_UINT16  midambleAllocationMode;
  VOS_UINT16  midambleShift;
  VOS_UINT16  midambleConfiguration;
  VOS_UINT16  flushSoftBuffer;
  VOS_UINT16  reserved;
  VOS_UINT16  hsscchNum;
  T_HsscchInfoDhi  hsscchInfo[maxHSSCCHs];
}T_HsdpaInfo;

typedef struct T_HsMeasInfo_Tag
{
  VOS_UINT16  hsSichRtbs;
  VOS_UINT16  hsSichRmf;
  VOS_UINT16  hsSichTxPower;
  VOS_UINT16  hsPdschRscp;
  VOS_UINT16  hsPdschSir;
  VOS_UINT16  hsScchSsStep;
  VOS_UINT16  hsScchTpcStep;
  VOS_UINT16  hsScchRscp;
  VOS_UINT16  hsScchSir;
  VOS_UINT16  hsScchSirTarget;
  VOS_UINT16  hsScchMSI;
  VOS_UINT16  hsScchMissNum;
}T_HsMeasInfo;


typedef struct T_HsUpaPc_Tag
{
  VOS_UINT16  prxBaseDes;
  VOS_UINT16  beaconPlEst;
  VOS_UINT16  tpcStepSize;
  VOS_UINT16  pebasePowerControlGap;
  VOS_UINT16  upSyncStepSize;
  VOS_UINT16  upSyncFrequency;
}T_HsUpaPc;


typedef struct T_MbsfnInfoDhi_Tag
{
  VOS_UINT16  rxTsNum;
  VOS_UINT16  reserved;
  T_DriverInfo  rxDriverInfo[6];
  VOS_UINT16  mbsfnCellParaId[6];
}T_MbsfnInfoDhi;

typedef struct T_NonSchedulePhysicalInfo_Tag{
  VOS_UINT16  numEucch;
  VOS_UINT16  freq;
  VOS_UINT16  timeslotResourceRelatedInfo;
  VOS_UINT16  codeResourceInfo;
  VOS_UINT16  sfnNum;
  VOS_UINT16  repetitionPeriod;
  VOS_UINT16  repetitionLength;
  VOS_UINT16  frameOffset;
  T_DriverInfo  eHichRxDriverInfo;
  T_JdInfo  eHichJdInfo;
  VOS_UINT16  signatureSequenceGroupIndex;
  VOS_UINT16  reserved;
}T_NonSchedulePhysicalInfo;

typedef struct T_RachCcInfo_Tag
{
  VOS_UINT16  crcSize;
  VOS_UINT16  channelCodingType;
  VOS_UINT16  tbNum;
  VOS_UINT16  tbSize;
  VOS_UINT16  tti;
  VOS_UINT16  reserved;
}T_RachCcInfo;

typedef struct T_ReselectPara_Tag
{
  VOS_INT16  sOfIntra;//20090115
  VOS_INT16  sOfInter;//20090115
  VOS_UINT16  epout;
  VOS_UINT16  qhyst;
  VOS_INT16  Qrxlevmin[maxCellNum];//20090115
  VOS_INT16  maxTxPower[maxCellNum];
  VOS_INT16  qOffset1Sn[maxCellNum-1];
  VOS_UINT16  Nreselect;
  VOS_UINT16  Nerror;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_ReselectPara;

//add for align to TCN360_V1.10.0  gongjian  20100914
typedef struct T_ReselectParaHcs_Tag
{
  VOS_UINT16  useOfHcs;//not use:0
  VOS_INT16  sOfSearchHCS;//20070321
  VOS_UINT16  tCRMax;
  VOS_UINT16  hcsPrio[maxCellNum];
  VOS_UINT16  qOfHCS[maxCellNum];
  VOS_UINT16  penaltyTime[maxCellNum];//not used :0
  VOS_UINT16  temporaryOffset1[maxCellNum];
  VOS_UINT16  reserved;
}T_ReselectParaHcs;

typedef struct T_SchedulePhysicalInfo_Tag{
  VOS_UINT16  rdiFlag;
  VOS_UINT16  eAgchBlerTarget;
  VOS_UINT16  tpcStepSize;
  VOS_UINT16  numEagch;
  T_DriverInfo  eAgchRxDriverInfo[maxNumEagch];
  T_JdInfo  eAgchJdInfo[maxNumEagch];
  VOS_UINT16  numEhich;
  VOS_UINT16  reserved;
  VOS_UINT16  ei[maxNumEhich];
  T_JdInfo  eHichJdInfo[maxNumEhich];
}T_SchedulePhysicalInfo;

typedef struct T_SyncUlInfo_Tag
{
  VOS_UINT16  syncUlFreq;
  VOS_UINT16  reserved;
  VOS_UINT16  syncUlCodeNum;
  VOS_UINT16  pathLoss;
  VOS_UINT16  syncUlCode[8];
  VOS_UINT16  timingAdvance;
  VOS_UINT16  powerLevel;
  VOS_UINT16  wt;
  VOS_UINT16  upPchPositionInfo;
}T_SyncUlInfo;

typedef struct T_TbDataDesc_Tag
{
  VOS_UINT16    tbNum;
  VOS_UINT16    tbSize;
}T_TbDataDesc;

typedef struct T_TsChMeas_Tag
{
  VOS_UINT16 rscp;
  VOS_UINT16 iscp;
  VOS_UINT16 sir;
  VOS_UINT16 ci;
}T_TsChMeas;

typedef struct T_TdmInfoDhi_Tag
{
  VOS_UINT16    tdmRep;
  VOS_UINT16    tdmOffset;
  VOS_UINT16    tdmLength;
  VOS_UINT16    n;
}T_TdmInfoDhi;

typedef struct T_UpCrl_Tag
{
  VOS_UINT16  txTsNum;
  VOS_UINT16  txRepetitionPeriod;
  VOS_UINT16  txRepetitionLen;
  VOS_UINT16  ulcctrchOffset;
  VOS_UINT16  maxAllowedUlTxPower;
  VOS_UINT16  powerLevel;
  VOS_UINT16  tpcStepSize;
  VOS_UINT16  ssStepSize;
  VOS_UINT16  ssFrequency;
  VOS_UINT16  ulDpchOffset;
}T_UpCrl;

typedef struct T_EpuchControlInfo_Tag
{
  VOS_UINT16  eRnti;
  VOS_UINT16  harqInfo;
  VOS_UINT16  nEhich;
  VOS_UINT16  tRucch;
  VOS_UINT16  numTs;
  VOS_UINT16  tsId[maxTS_1];
  T_BcInfo  epuchBcInfo[maxTS_1];
  VOS_UINT16  nonSchedNehich;
  VOS_UINT16  reserved1;
}T_EpuchControlInfo;

typedef struct T_L1_NULL_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT32           sleepTime;
}T_L1_NULL_REQ;

typedef struct T_L1_PWR_SWEEP_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  sweepId;
  VOS_UINT16  syncStatus;
  VOS_UINT16  freqBandNum;
  VOS_UINT16  reserved;
  T_FreqBand  freqBand[maxFreqBand];
}T_L1_PWR_SWEEP_REQ;

typedef struct T_L1_PWR_SWEEP_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  sweepId;
  VOS_UINT16  freqPointNum;
  VOS_UINT16  freq [maxPoint];
  VOS_UINT16  dwptsRssi[maxPoint];
  VOS_UINT16  carrierRssi[maxPoint];
}T_L1_PWR_SWEEP_CNF;

typedef struct T_L1_CELL_SEARCH_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  cellSearchId;
  VOS_UINT16  syncStatus;
  VOS_UINT16  freq;
  VOS_UINT16  syncId;
  VOS_UINT16  midambleId;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
  VOS_UINT32  ulBarNum;          // С
  VOS_UINT16  ausBarCellId[TDS_MAX_BAR_CELLID];   // Сб
}T_L1_CELL_SEARCH_REQ;

typedef struct T_L1_CELL_SEARCH_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  cellSearchId;
  VOS_UINT16  successFlag;
  T_CellDescDhi  cellDesc;
  VOS_UINT16  blockTailFramNum;
  VOS_UINT16  activeSyncNum;
  VOS_UINT16  syncId[maxIntraCellNum];
  VOS_UINT16  rscp[maxIntraCellNum];
  VOS_UINT16  rssi;
  VOS_UINT16  dwptsRssi;
  T_TsChMeas  dwptsMeas;
  T_TsChMeas  pccpchMeas;
}T_L1_CELL_SEARCH_CNF;

typedef struct T_L1_ICS_MEAS_REQ_Tag
{
  T_HeaderInfo     header;
  VOS_UINT16  icsMeasId;
  VOS_UINT16  intraCellNum;
  VOS_UINT16  frequency;
  VOS_UINT16  cellId[maxIntraCellNum];
}T_L1_ICS_MEAS_REQ;

typedef struct T_L1_ICS_MEAS_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  icsMeasId;
  VOS_UINT16  intraCellNum;
  VOS_UINT16  rscp[maxIntraCellNum];
  VOS_UINT16  rssi[maxIntraCellNum];
}T_L1_ICS_MEAS_CNF;

typedef struct T_L1_PCCPCH_READ_REQ_Tag
{
  T_HeaderInfo  header;
  T_JdInfo  pccpchInfo;
  VOS_UINT16  pccpchBlkNum;
  VOS_UINT16  pchParaValid;
  VOS_UINT16  pagingPeriod;
  VOS_UINT16  pchSfn;
  T_JdInfo  pchInfo;
  T_CdInfo  pchCdInfo;
  VOS_UINT32  firstCellSearchFlag;
}T_L1_PCCPCH_READ_REQ;

typedef struct T_L1_PCCPCH_READ_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  crcFlag;
  VOS_UINT8   systemInfo[32];
  VOS_UINT16  rscp;
  VOS_UINT16  rssi;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_PCCPCH_READ_CNF;

/*begin: modify by l00213440 for IDL_TASK_REQ*/
#if 1
typedef struct T_L1_IDL_TASK_REQ_Tag
{
  T_HeaderInfo               header;
  VOS_UINT16  taskType;
  VOS_UINT16  pichSubFrameNum;//20090414 add for reduce 2 phase.
  T_JdInfo  pichInfo;
  VOS_UINT16  q;
  VOS_UINT16  lpi;
  VOS_UINT16  pagingPeriod;
  VOS_UINT16  pchSfn;
  T_JdInfo  pchInfo;
  T_CdInfo  pchCdInfo;
  VOS_UINT16  measId;
  VOS_UINT16  cellNum;
  T_CellDescDhi cell[maxCellNum];
  VOS_UINT16  iscp[maxCellNum];
  T_ReselectPara  zspReselectPara;
  T_InitialUeIdentity  ueIdentity;//add for reduce 2 phase.20090414
  VOS_UINT16  sleepFlag;
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  gsmCell[maxGsmCellNum];
  T_ReselectParaHcs zspReselectParaHcs;  // for align to TCN360_V1.10.0 gongjian 20100914
}T_L1_IDL_TASK_REQ;

#endif


#if 1
typedef struct T_L1_IDL_PCH_REQ_Tag
{
  T_HeaderInfo               header;
  VOS_UINT16  pichSubFrameNum;//20090414 add for reduce 2 phase.
  T_JdInfo  pichInfo;
  VOS_UINT16  q;
  VOS_UINT16  lpi;
  VOS_UINT16  pagingPeriod;
  VOS_UINT16  pchSfn;
  T_JdInfo  pchInfo;
  T_CdInfo  pchCdInfo;
}T_L1_IDL_PCH_REQ;

typedef struct T_L1_IDL_PCH_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  pchPresent;
}T_L1_IDL_PCH_IND;

typedef struct T_L1_IDL_MEAS_REQ_Tag
{
  T_HeaderInfo        header;
  VOS_UINT16  measId;
  VOS_UINT16  cellNum;
  T_CellDescDhi cell[maxCellNum];
  VOS_UINT16  iscp[maxCellNum];
}T_L1_IDL_MEAS_REQ;

typedef struct T_L1_IDL_MEAS_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  measId;
  VOS_UINT16  cellNum;
  VOS_UINT16  rscp[maxCellNum];
  VOS_INT16  validS[maxCellNum];
  VOS_INT16  cellR[maxCellNum];
  VOS_UINT16  rssi[maxCellNum];
  VOS_UINT16  sir[maxCellNum];
  VOS_UINT16  pccpchCi[maxCellNum];
  VOS_UINT16  iscp[maxCellNum][7];
  VOS_UINT16  frequency;//for reduce energe 20081210
  VOS_UINT16  cellId;
  T_DETECT_CELL_LIST_STRU    stDetectCellList;
}T_L1_IDL_MEAS_IND;

typedef struct H_T_L1_IDL_PCH_IND_Tag
{
	VOS_MSG_HEADER
	VOS_UINT32				ulMsgName;
	T_L1_IDL_PCH_IND		L1_IDL_PCH_IND;
} H_T_L1_IDL_PCH_IND;

#endif
/*end: modify by l00213440 for IDL_TASK_REQ*/

typedef struct T_L1_PICH_READ_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16            pchPresent;
  VOS_UINT8            pichData[88];
}T_L1_PICH_READ_IND;

typedef struct T_L1_PRACH_SEND_REQ_Tag
{
  T_HeaderInfo        header;
  VOS_UINT16                 prachId;
  VOS_UINT16                 prachType;
  T_JdInfo  fpachInfo;
  T_DriverInfo  rachDriverInfo;
  T_SyncUlInfo  syncUlCtrlInfo;
  VOS_UINT16  prachNum;
  VOS_UINT16  powerDelta;
  VOS_UINT16  maxAllowedUlTxPower;
  VOS_UINT16  modulateMode;
  VOS_UINT16  midambleAllocMode;
  VOS_UINT16  midambleShift;
  VOS_UINT16  midambleConfiguration;
  VOS_UINT16  cellId;
  VOS_UINT16  channelCode[4];
  VOS_UINT16  sf[4];
  T_RachCcInfo  rachCcInfo;
  VOS_UINT8  data[MAX_DHI_DATA_LEN];
  #ifdef TEST_DHI_ARM_TTCN
  VOS_UINT8    ctFlag[maxTrCH];//CTڱʶĿǰδʹãչҪ
  VOS_UINT8    rrc_nextState;//Ҫȷʹóұ
//DHIӿڣڷʱȷL1_SCCPCH_READ_REQ,ṹSCCPCHЯ
 // T_RRC_EstablishedRabs_Temp           *p_adpEstablishedRabs;
  VOS_UINT16   reserved;
  //T_CMAC_DCH_CONFIG_REQ_TEMP           *p_adpDchPara;
  #endif
}T_L1_PRACH_SEND_REQ;

typedef struct T_L1_FPACH_READ_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16           prachId;
  VOS_UINT16           crcFlag;
  VOS_UINT16           phInfoMess[4];
  VOS_UINT16           fpachRxPwr;
  VOS_UINT16           prachTxPwr;
  VOS_UINT16           prachTimeAdvance;
  VOS_UINT16           subSfn;
}T_L1_FPACH_READ_CNF;

typedef struct T_McchConfigInfo_Tag
{
  VOS_UINT16   accessInfoPeriod;
  VOS_UINT16   repetitionPeriod;
  VOS_UINT16   modificationperiod;
  VOS_UINT16  reserved;
}T_McchConfigInfo;

typedef struct T_L1_SCCPCH_READ_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  sccpchId;
  VOS_UINT16  reserved1;
  T_JdInfo  sccpchJdInfo;
  T_CdInfo  sccpchCdInfo;
  VOS_UINT16  sccpchRepPeriod;
  VOS_UINT16  sccpchRepLen;
  VOS_UINT16  sccpchOffset;
  VOS_UINT16  fachOccFlag;
  VOS_UINT16  crntiModMrep;
  VOS_UINT16  mrep;
  VOS_UINT16  reserved2;
  VOS_UINT16  measId;
  VOS_UINT16  measReportPeriod;
  VOS_UINT16  cellNum;
  T_CellDescDhi cell[maxCellNum];
  VOS_UINT16  iscp[maxCellNum];
  VOS_UINT16  reserved3;
  VOS_UINT16  mcchId;
  T_McchConfigInfo mcchConfiguratinoInfo;
  #ifdef TEST_DHI_ARM_TTCN
  //T_CMAC_DCH_CONFIG_REQ_TEMP                    *p_adpDchPara;
 // T_RRC_EstablishedRabs_Temp                         *p_adpEstablishedRabs;
  #endif
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  gsmCell[maxGsmCellNum];
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_SCCPCH_READ_REQ;

typedef struct T_L1_SCCPCH_READ_IND_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  trchNum;
  VOS_UINT16  sccpchId;
  VOS_UINT16  crcFlag[maxTrCH];
  T_TbDataDesc  tbDataDesc[maxTrCH];
  VOS_UINT8  data[MAX_DHI_DATA_LEN];
  T_CellDescDhi cellDesc;
  VOS_UINT16  mcchId;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_SCCPCH_READ_IND;

typedef struct T_L1_FCH_MEAS_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  measId;
  VOS_UINT16  cellNum;
  VOS_UINT16  rscp[maxCellNum];
  VOS_UINT16  rssi[maxCellNum];
  VOS_UINT16  sir[maxCellNum];
  VOS_UINT16  pccpchCi[maxCellNum];
  VOS_UINT16  iscp[maxCellNum][7];
  VOS_UINT16  tadv;
  VOS_UINT16  sfn;
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  rssiGsm[maxGsmCellNum];
  VOS_UINT16  agc[maxGsmCellNum];
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
  T_DETECT_CELL_LIST_STRU    stDetectCellList;
}T_L1_FCH_MEAS_IND;

typedef struct T_L1_DPCH_CONFIG_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  masterFreq;
  VOS_UINT16  tstdIndicator;
  VOS_UINT16  syncDiff;
  VOS_UINT16  syncNeeded;
  VOS_UINT16  n313;
  VOS_UINT16  n312;
  VOS_UINT16  n315;
  VOS_UINT16  specialBurstScheduling;
  T_DwCrl  dpchDownControl;
  T_DriverInfo  rxDriverInfo[maxTS_1];
  T_JdInfo  jdInfo[maxTS_1];
  T_CdInfo  dpchCdInfo;
  T_UpCrl  dpchUpControl;
  T_DriverInfo  txDriverInfo[maxTS_1];
  T_BcInfo  bcInfo[maxTS_1];
  T_CcInfo  dpchCcInfo;
  VOS_UINT16  pccpchTxPower;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_DPCH_CONFIG_REQ;

typedef struct T_L1_DPCH_SYNC_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16            syncFlag;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_DPCH_SYNC_IND;

typedef struct T_L1_DPCH_READ_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  trchNum;
  VOS_UINT16  dataTypeIndication;
  T_TbDataDesc  tbDataDesc[maxTrCH];
  VOS_UINT32  crcFlag[maxTrCH];
  //VOS_UINT8  data[MAX_DHI_DATA_LEN];
  VOS_UINT8  data[MAX_DPCH_DATA_LEN];/*1500*/
}T_L1_DPCH_READ_IND;

typedef struct T_L1_DPCH_SEND_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  trchNum;
  VOS_UINT16  dataTypeIndication;
  T_TbDataDesc  tbDataDesc[maxTrCH];
  VOS_UINT8  data[MAX_DHI_DATA_LEN << 1];
  #ifdef TEST_DHI_ARM_TTCN
  //T_RRC_EstablishedRabs_Temp          adpEstablishedRabs;
  VOS_UINT8    ctFlag[maxTrCH];//ct exit flag
 #endif
}T_L1_DPCH_SEND_REQ;

typedef struct T_L1_HO_SYNC_SEND_REQ_Tag
{
  T_HeaderInfo    header;
  VOS_UINT16   hoId;
  VOS_UINT16   reserved;
  VOS_UINT16   masterFreq;
  VOS_UINT16   syncDiff;
  T_JdInfo  fpachInfo;
  T_SyncUlInfo  syncUlCtrlInfo;
}T_L1_HO_SYNC_SEND_REQ;

typedef struct T_L1_DCH_MEAS_REQ_Tag
{
  T_HeaderInfo    header;
  VOS_UINT16  measId;
  VOS_UINT16  reportPeriod;
  /*DETECT CELL MODIFIY BEGIN*/
  VOS_UINT16  usDetectFlag;                                                            /*DetectС*/
  VOS_UINT16  usReserved;
  /*DETECT CELL MODIFIY END*/
  VOS_UINT16  cellNum;
  VOS_UINT16  intraCellNum;
  T_CellDescDhi cell[maxCellNum];
  VOS_UINT16  iscp[maxCellNum];
  VOS_UINT16  intraCell[maxIntraCellNum];
  VOS_UINT16  internalMeasFlag;
  VOS_UINT16  measTrchNum;
  VOS_UINT16  totalCrc[maxTrCH];
  VOS_UINT16  badCrc[maxTrCH];
  VOS_UINT16  pendingAfterTrigger[maxTrCH];

  VOS_UINT16  measListNoChange;  // for align to TCN360_V1.10.0
  //20090928 PDM100 UMAC

  /* xrm add begin */
  VOS_UINT16  usLteMeasFreqNum;                                                        /* LTEƵ */
  VOS_UINT16  usIdleIntervalK;                                                         /* ȡֵΧ[2,3] */
  VOS_UINT16  usIdleIntervalOffset;                                                    /* ȡֵΧ[0,7] */
  VOS_UINT16  usReserveds;
  /* xrm add end */

  VOS_UINT16  gsmCellNum;
  VOS_UINT16  gsmCell[maxGsmCellNum];
}T_L1_DCH_MEAS_REQ;

/* xrm add begin */
typedef struct T_L1_DCH_MEAS_CNF_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            measId;
  VOS_UINT16            usReserved;
}T_L1_DCH_MEAS_CNF;
/* xrm add end */

typedef struct T_L1_DCH_MEAS_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  measId;
  VOS_UINT16  measFlag;
  VOS_UINT16  reserved;
  VOS_UINT16  cellNum;
  VOS_UINT16  rscpLevel[maxCellNum];    //20100303 update DHI interface gongjian
  VOS_UINT16  rssi[maxCellNum];
  VOS_UINT16  iscp[maxCellNum][7];
  VOS_UINT16  syncDiff[maxCellNum];
  VOS_UINT16  event5aFlag;
  VOS_UINT16  measTrchNum;
  VOS_UINT16  dlTransChBler[maxTrCH];
  VOS_UINT16  dlTsSir [7];
  VOS_UINT16  dlTsRscp[7];
  VOS_UINT16  dlTsRssi[7];
  VOS_UINT16  dlTsIscp[7];
  VOS_UINT16  dlTsCi[7];
  VOS_UINT16  ulTsTxPower[7];
  VOS_UINT16  tadv;
  VOS_UINT16  sfn;
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  rssiGsm[maxGsmCellNum];
  VOS_UINT16  agc[maxGsmCellNum];
  VOS_UINT16  reserved2;/*modify by l00213440 for 4 byte*/
  T_DETECT_CELL_LIST_STRU    stDetectCellList;
}T_L1_DCH_MEAS_IND;

typedef struct T_L1_VCD_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16           vcdCode;
}T_L1_VCD_REQ;

typedef struct T_L1_LOOP_TEST_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16           cause;
  VOS_UINT16           reserved;/*modify by l00213440 for 4 byte*/
  #ifdef  TEST_DHI_ARM_TTCN
  VOS_UINT8        rbNum;//ػRB
  VOS_UINT8        loopRbId[32];//ػRB ID
  VOS_UINT8        loopTestRlc[32];//rlcػʶ
  VOS_UINT8        loopTestpdcp[32];//PDCPػʶ
  VOS_UINT8        pdcpPresent[32];
  #endif
}T_L1_LOOP_TEST_REQ;

typedef struct T_L1_HSPDSCH_CONFIG_REQ_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  newHrnti;
  VOS_UINT16  multiCarrierNumber;
  T_HsdpaInfo  hsdpaInfo[maxTDD128Carrier];
  VOS_UINT16  physicalLayerCategory;
  VOS_UINT16  powerControlGap;
  VOS_UINT16  pathlossCompensationSwitch;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_HSPDSCH_CONFIG_REQ;

typedef struct T_L1_HSPDSCH_READ_IND_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16           uarfcnCarrier;
  VOS_UINT16           crcFlag;
  VOS_UINT16           tbSize;
  VOS_UINT8            data[MAX_HS_PDU_LEN];
  VOS_UINT16           reserved;/*modify by l00213440 for 4 byte*/
}T_L1_HSPDSCH_READ_IND;

typedef struct T_L1_EPUCH_CONFIG_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  startFlag;
  VOS_UINT16  maxWaitTime;
  T_HsUpaPc  epuchPowerControl;
  T_EpuchControlInfo  epuchControl;
  T_NonSchedulePhysicalInfo  nonSchedulePhysicalInfo;
  T_SchedulePhysicalInfo  schedulePhysicalInfo;
}T_L1_EPUCH_CONFIG_REQ;

typedef struct T_L1_EPUCH_SEND_REQ_Tag
{
  T_HeaderInfo   header;
  T_EpuchCcInfo  epuchCcInfo;
  VOS_UINT16  referenceBetaE;
  VOS_UINT16  harqId;
  VOS_UINT16  pathLoss;
  VOS_UINT16  peBase;
  VOS_UINT16  headerSize;
  VOS_UINT8    macHeader[6];
  VOS_UINT16  dataSize;
  VOS_UINT8   data[1394];
  VOS_UINT8   siInfo[3];
  VOS_UINT8  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_EPUCH_SEND_REQ;

typedef struct T_L1_HSUPA_INFO_IND_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  harqIndPresent;//0bit:agch;1bit:scedule hich;2bit:non scedule hich
  VOS_UINT16  prri;
  VOS_UINT16  crri;
  VOS_UINT16  trri;
  VOS_UINT16  rdi;
  VOS_UINT16  nEucchNumInd;
  VOS_UINT16  scheduleHarqId;
  VOS_UINT16  scheduleAckOrNack;
  VOS_UINT16  nonScheduleHarqId;
  VOS_UINT16  nonScheduleAckOrNack;
  VOS_UINT16  peBase;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
  #ifdef TEST_DHI_ARM_TTCN
  VOS_UINT16  agchTimes;
  #endif
}T_L1_HSUPA_INFO_IND;

typedef struct T_L1_MCCH_READ_REQ_Tag
{
  T_HeaderInfo      header;
  VOS_UINT16  mcchId;
  VOS_UINT16  trchNum;
  VOS_UINT16  sccpchId;
  VOS_UINT16  rxTsNumber;
  VOS_UINT16  trchType[maxTrCH];
  T_DriverInfo  mbmsDriverInfo[maxTS_1];
  T_JdInfo  rxmbmsInfo[maxTS_1];
  T_CdInfo  mbmsCdInfo;
  T_McchConfigInfo mcchConfigInfo;
}T_L1_MCCH_READ_REQ;

typedef struct T_L1_MTCH_READ_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16  sccpchPowerOffset;
  VOS_UINT16  rxTsNumber;
  VOS_UINT16  sccpchId;
  VOS_UINT16  tdmNum;
  T_JdInfo  rxMtchInfo[maxTS_1];
  T_CdInfo  mtchCdInfo;
  T_TdmInfoDhi  tdmInfo[MAX_TDM_NUM];
  T_MbsfnInfoDhi mbsfnInfo[MAX_TDM_NUM];
}T_L1_MTCH_READ_REQ;

typedef struct T_L1_MBMS_STOP_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16             stopId;
  VOS_UINT16             mcchId;
}T_L1_MBMS_STOP_REQ;

typedef struct T_L1_CELL_MEAS_REQ_Tag
{
  T_HeaderInfo     header;
  VOS_UINT16  cellMeasId;
  VOS_UINT16  cellNum;
  T_CellDescDhi cell[maxCellNum];
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  gsmCell[maxGsmCellNum];
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_CELL_MEAS_REQ;

typedef struct T_L1_CELL_MEAS_CNF_Tag
{
  T_HeaderInfo  header;
  VOS_UINT16  cellMeasId;
  VOS_UINT16  cellNum;
  VOS_UINT16  rscp[maxCellNum];
  VOS_UINT16  rssi[maxCellNum];
  //20090928 PDM100 UMAC
  VOS_UINT16  gsmCellNum;
  VOS_UINT16  rssiGsm[maxGsmCellNum];
  VOS_UINT16  agc[maxGsmCellNum];
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_CELL_MEAS_CNF;
//20100406
typedef struct  T_L1_ZSP_ABNORMAL_IND_Tag
{
  T_HeaderInfo  header;
}T_L1_ZSP_ABNORMAL_IND;

typedef struct T_L1_BSIC_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            decodeId;
  VOS_UINT16            gsmCellNum;
  VOS_UINT16            gsmCell[maxBsicNum];
  VOS_UINT16            bsicType[maxBsicNum];
  VOS_UINT16            tdSfn [maxBsicNum];
  VOS_UINT16            tdChipOffset [maxBsicNum];
  VOS_UINT32            gsmSfn[maxBsicNum];
}T_L1_BSIC_REQ;

/* xrm add begin */
typedef struct T_L1_BSIC_CNF_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            decodeId;
  VOS_UINT16            usReserved;
}T_L1_BSIC_CNF;
/* xrm add end */

typedef struct T_L1_BSIC_IND_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            decodeId;
  VOS_UINT16            gsmCellNum;
  VOS_UINT16            gsmCell[maxBsicNum];
  VOS_UINT16            syncStatus[maxBsicNum];
  VOS_UINT16            bsic[maxBsicNum];
  VOS_UINT16            tdSfn[maxBsicNum];
  VOS_UINT16            tdChipOffset[maxBsicNum];
  VOS_UINT32            gsmSfn[maxBsicNum];
}T_L1_BSIC_IND;

typedef struct T_L1_STOP_BSIC_REQ_Tag
{
  T_HeaderInfo   header;
}T_L1_STOP_BSIC_REQ;

typedef struct T_L1_STOP_BSIC_CNF_Tag
{
  T_HeaderInfo   header;
}T_L1_STOP_BSIC_CNF;

typedef struct T_L1_PRE_SYNC_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            frequency;
  VOS_UINT16            cellId;
  // gongjian 20101123  D_PS_PDM100_UMAC_V0.6.3_003
  VOS_UINT16            switchTriBusFlag;
  VOS_UINT16  reserved;/*modify by l00213440 for 4 byte*/
}T_L1_PRE_SYNC_REQ;

 // gongjian 20101123  D_PS_PDM100_UMAC_V0.6.3_003
typedef struct T_L1_PRE_SYNC_CNF_Tag
{
  T_HeaderInfo   header;
}T_L1_PRE_SYNC_CNF;

typedef struct T_L1_GAP_INFO_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            lastGap;
  VOS_UINT16            offSet;
  VOS_UINT32            duration;
}T_L1_GAP_INFO_REQ;

/* xrm add begin */
/*****************************************************************************
 ö    : L1_RAT_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ϵͳ
*****************************************************************************/
enum L1_RAT_TYPE_ENUM
{
    RAT_TYPE_LTE                              = 0,                              /* LTE */
    RAT_TYPE_GSM                                 ,                              /* GSM */
    RAT_TYPE_UTRA                                ,                              /* UTRA */
    RAT_TYPE_BUTT
};
typedef VOS_UINT16 L1_RAT_TYPE_ENUM_UINT16;

/*****************************************************************************
 ö    : L1_RAT_STATUS_ENUM
 Э  :
 ASN.1 :
 ö˵  : G(L)->TDSЭ״̬
*****************************************************************************/
enum L1_RAT_STATUS_ENUM
{
    RAT_STATUS_IDLE                           = 0,
    RAT_STATUS_CONNECTED                         ,
    RAT_STATUS_BUTT
};
typedef VOS_UINT16 L1_RAT_STATUS_ENUM_UINT16;

/* xrm add end */

typedef struct T_L1_IRAT_MEAS_REQ_Tag
{
  T_HeaderInfo   header;
  /* xrm add begin */
  L1_RAT_TYPE_ENUM_UINT16            enRatType;                                 /* ǰģ */
  L1_RAT_STATUS_ENUM_UINT16          enRatStatus;                               /* ǰģ״̬ */
  /* xrm add end */
  VOS_UINT16            lastGap;
  VOS_UINT16            offSet;
  VOS_UINT32            duration;
  VOS_UINT16            frameSync;
  VOS_UINT16            measId;
  /* TLŻ:ӿҪָȼ */
  VOS_UINT16            cellNum;
  VOS_UINT16            reserved;      //20100303 update DHI interface gongjian
  T_CellDescDhi  cell[maxCellNum];
}T_L1_IRAT_MEAS_REQ;

/* xrm add begin */
typedef struct T_L1_IRAT_MEAS_CNF_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            measId;
  VOS_UINT16            reserved;
}T_L1_IRAT_MEAS_CNF;

typedef struct T_RssiMeasRslt_Tag
{
  VOS_UINT16            usArfcn;
  VOS_INT16            sRssi;
}T_RssiMeasRslt;

/* xrm add end */

typedef struct T_L1_IRAT_MEAS_IND_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            measId;
  VOS_UINT16            cellNum;
  T_CellDescDhi  cell[maxCellNum];
  VOS_UINT16            rscp[maxCellNum];
  /* xrm add begin */
  T_RssiMeasRslt stRssiMeasRslt[maxMeasFreq];
  /* xrm add end */
  T_DETECT_CELL_LIST_STRU    stDetectCellList;
}T_L1_IRAT_MEAS_IND;

typedef struct T_L1_IRAT_INACTIVE_REQ_Tag
{
  T_HeaderInfo   header;
  /* TLŻ:ö */
  /* xrm add begin */
  /* 0 вһgap ڼжϵ񣨽פGSM ģTD ͵TD Ԥ
     1 ǰѾȡñصκβ
     2 ֻڿGSM ģҪرZSP 
     0x1000 : TDSģʱʹôԭֵ֪ͨTPHYͷŴģ
  */
  /* xrm add end */
  VOS_UINT16            cause;
  VOS_UINT16            usResvd;
}T_L1_IRAT_INACTIVE_REQ;

typedef struct T_L1_IRAT_INACTIVE_CNF_Tag
{
  T_HeaderInfo   header;
  /* DTS2012120601859 begin */
  VOS_INT16      sTaValue;
  VOS_UINT16     usResvd;
  /* DTS2012120601859 end */
}T_L1_IRAT_INACTIVE_CNF;

typedef struct T_L1_GAP_END_IND_Tag
{
  T_HeaderInfo   header;
}T_L1_GAP_END_IND;

#ifdef TEST_MAC_ARM_TTCN
typedef struct T_HL1_SCHEDULE_IND_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16            curSfn;
}T_HL1_SCHEDULE_IND;
#endif

typedef struct T_L1_VCD_PLAY_REQ_Tag
{
  T_HeaderInfo   header;
  VOS_UINT16             controlType;
  VOS_UINT16             toneId;
  VOS_UINT16             playTimes;
  VOS_UINT16             callState;
}T_L1_VCD_PLAY_REQ;


#ifdef TEST_DHI_ARM_TTCN
typedef struct T_L1_VB_SYNC_Tag
{
  T_HeaderInfo   header;
}T_L1_VB_SYNC;
#endif





/*****************************************************************************
 ṹ    : TMAC_TPHY_REL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MAC͸phyͷphyյղͬͷӦ
  T2G/L ϵͳлʱ֪ͨTPHYRAT̬ǰ·ԭЯԭֵĬΪ0x06ͷGLϢ
*****************************************************************************/
typedef struct TMAC_TPHY_REL_REQ_Tag
{
  T_HeaderInfo                  header;
  VOS_UINT16                           usRelCause;
  VOS_UINT16                           usReserved;
} TMAC_TPHY_REL_REQ_STRU;
/* DTS2013011700904 T2G frame for Bsic begin */
/*****************************************************************************
 ṹ    : TMAC_TPHY_BSIC_FRAME_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct TMAC_TPHY_BSIC_FRAME_IND_Tag
{
  T_HeaderInfo                         header;
} TMAC_TPHY_BSIC_FRAME_IND_STRU;

/* DTS2013011700904 T2G frame for Bsic end */

/*****************************************************************************
 ṹ    : TMAC_TPHY_REL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TMAC_TPHY_REL_REQ_STRU ظϢ
*****************************************************************************/
typedef struct TMAC_TPHY_REL_CNF_Tag
{
  T_HeaderInfo                  header;
  TDS_RESULT_ENUM_UINT16        usRslt;//0 succ, 1 fail
  VOS_UINT16                           usReserved;
} TMAC_TPHY_REL_CNF_STRU;


/*****************************************************************************
 ṹ    : TMAC_TPHY_IRAT_MEAS_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TDSģDCH̬£ʹôԭｫGLƵ֪ͨTDSPG/LƵΪ0ʾͷš
*****************************************************************************/
typedef struct TMAC_TPHY_IRAT_MEAS_REQ_Tag
{
  T_HeaderInfo       header;
  VOS_UINT16                usOpId;
  VOS_UINT16                reserved;
  VOS_UINT16                usLteMeasFreqNum;
  VOS_UINT16                usGsmMeasFreqNum;
} TMAC_TPHY_IRAT_MEAS_REQ_STRU;

/*****************************************************************************
 ṹ    : TMAC_TPHY_IRAT_MEAS_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TMAC_TPHY_IRAT_MEAS_REQ_STRUĻظṹ
*****************************************************************************/
typedef struct TMAC_TPHY_IRAT_MEAS_CNF_Tag
{
  T_HeaderInfo       header;
  VOS_UINT16                usOpId;
  VOS_UINT16                reserved;
} TMAC_TPHY_IRAT_MEAS_CNF_STRU;
/* xrm add end */


//the structure are moved from hl1_mac.het -----begin  20100805  ylm
//-----------------------------------------------------------------------------
//
typedef struct T_DhiReqHead_Tag
{
  VOS_UINT16    scheduleFn;
  VOS_UINT16    sendFn;
} T_DhiReqHead;

//-----------------------------------------------------------------------------
typedef union T_DhiReqMsg_Tag
{
  T_L1_NULL_REQ           L1_NULL_REQ;
  T_L1_CELL_MEAS_REQ      L1_CELL_MEAS_REQ;
  T_L1_PCCPCH_READ_REQ    L1_PCCPCH_READ_REQ;
  T_L1_IDL_MEAS_REQ       L1_IDL_MEAS_REQ;
  T_L1_IDL_PCH_REQ        L1_IDL_PCH_REQ;/*modify by l00213440 for IDL_TASK_REQ*/
  T_L1_PRACH_SEND_REQ     L1_PRACH_SEND_REQ;
  T_L1_SCCPCH_READ_REQ    L1_SCCPCH_READ_REQ;
  T_L1_DPCH_CONFIG_REQ    L1_DPCH_CONFIG_REQ;
  T_L1_DPCH_SEND_REQ      L1_DPCH_SEND_REQ;
  T_L1_EPUCH_CONFIG_REQ   L1_EPUCH_CONFIG_REQ;
  T_L1_EPUCH_SEND_REQ     L1_EPUCH_SEND_REQ;
  T_L1_DCH_MEAS_REQ       L1_DCH_MEAS_REQ;
  T_L1_HO_SYNC_SEND_REQ   L1_HO_SYNC_SEND_REQ;
  T_L1_PWR_SWEEP_REQ      L1_PWR_SWEEP_REQ;
  T_L1_CELL_SEARCH_REQ    L1_CELL_SEARCH_REQ;
  T_L1_LOOP_TEST_REQ      L1_LOOP_TEST_REQ;
  T_L1_IDL_TASK_REQ       L1_IDL_TASK_REQ;
  T_L1_MCCH_READ_REQ      L1_MCCH_READ_REQ;
  T_L1_MTCH_READ_REQ      L1_MTCH_READ_REQ;
  T_L1_MBMS_STOP_REQ      L1_MBMS_STOP_REQ;
  T_L1_HSPDSCH_CONFIG_REQ L1_HSPDSCH_CONFIG_REQ;

  //20090928 PDM100 UMAC
  T_L1_BSIC_REQ           L1_BSIC_REQ;
  T_L1_STOP_BSIC_REQ      L1_STOP_BSIC_REQ;
  T_L1_PRE_SYNC_REQ       L1_PRE_SYNC_REQ;
  T_L1_GAP_INFO_REQ       L1_GAP_INFO_REQ;
  T_L1_IRAT_MEAS_REQ      L1_IRAT_MEAS_REQ;
  T_L1_IRAT_INACTIVE_REQ  L1_IRAT_INACTIVE_REQ;

  /* TRRC CHANGE FOR RESEL begin */
  TMAC_TPHY_IRAT_MEAS_REQ_STRU TMAC_TPHY_IRAT_MEAS_REQ;
  TMAC_TPHY_REL_REQ_STRU TMAC_TPHY_REL_REQ;
  /* TRRC CHANGE FOR RESEL end */

  /* DTS2013011700904 T2G frame for Bsic begin */
  TMAC_TPHY_BSIC_FRAME_IND_STRU TMAC_TPHY_BSIC_FRAME_IND;
  /* DTS2013011700904 T2G frame for Bsic begin */

  #ifdef TEST_DHI_ARM_TTCN
  T_L1_VB_SYNC            L1_VB_SYNC;
  #endif
} T_DhiReqMsg;

//-----------------------------------------------------------------------------
// for MAC
typedef struct H_T_DhiReqMsg_Tag
{
  T_DhiReqHead  signalHeader;
  VOS_UINT32            msgSelect;//x00124992 Hardware
//VOS_UINT8            reserved;
//  VOS_UINT16           reserved1;
  T_DhiReqMsg   reqMsg;
} H_T_DhiReqMsg;

/*begin: modify by l00213440 for HPA*/
typedef struct
{
    VOS_MSG_HEADER
    T_DhiReqMsg   reqMsg;
} TDS_L2_HPA_MSG_STRU;

typedef struct
{
	VOS_MSG_HEADER
	VOS_UINT32              ulMsgId;
	VOS_UINT32              ulDspLoadFlag;//1-ICS,2-ACC,3-DCH,4-IDL,5-IRAT
} TL2_TPHY_STATE_CHANGE_REQ_STRU;

typedef struct
{
	VOS_MSG_HEADER
	VOS_UINT32                           ulMsgId;
	VOS_UINT32                           ulRslt;         /*״̬Ǩƽ*/
}TL2_TPHY_STATE_CHANGE_CNF_STRU;
#if 0
typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32             ulMsgId;
    VOS_UINT16             usOpId;
    VOS_UINT16             usWorkModeType;
}TRRC_TPHY_SET_WORK_MODE_REQ_STRU;

typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgId;
    VOS_UINT16              usOpId;
    VOS_UINT16              usWorkModeCfgRslt;
}TRRC_TPHY_SET_WORK_MODE_CNF_STRU;
#endif

typedef enum TRRC_TPHY_WORK_MODE_CFG_RESULT
{
    TRRC_TPHY_WORK_MODE_CFG_SUCC = 0,
    TRRC_TPHY_WORK_MODE_CFG_FAIL,           
}TRRC_TPHY_WORK_MODE_CFG_RESULT_ENUM;


/*end: modify by l00213440 for HPA*/

// for DSP
typedef struct H_T_MCU_CMD_Tag
{
  T_DhiReqHead  signalHeader;
//  VOS_UINT8            msgSelect;
//  VOS_UINT8            reserved;
//  VOS_UINT16           reserved2;
  VOS_UINT32         msgSelect;
  VOS_UINT16           reqMsg[MAX_DHI_LEN];
} H_T_MCU_CMD;
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------//-----------------------------------------------------------------------------

typedef struct H_T_L1_CELL_MEAS_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_CELL_MEAS_CNF  L1_CELL_MEAS_CNF;
} H_T_L1_CELL_MEAS_CNF;

//-----------------------------------------------------------------------------

typedef struct H_T_L1_PCCPCH_READ_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_PCCPCH_READ_CNF    L1_PCCPCH_READ_CNF;
} H_T_L1_PCCPCH_READ_CNF;

typedef struct H_T_L1_IDL_MEAS_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_IDL_MEAS_IND  L1_IDL_MEAS_IND;
} H_T_L1_IDL_MEAS_IND;

//-----------------------------------------------------------------------------
typedef struct H_T_L1_FPACH_READ_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_FPACH_READ_CNF     L1_FPACH_READ_CNF;
} H_T_L1_FPACH_READ_CNF;

//-----------------------------------------------------------------------------
//20100803  ylm
/*typedef struct H_T_L1_PICH_READ_IND_Tag
{
  T_MsgHeader             signalHeader;
  T_L1_PICH_READ_IND      L1_PICH_READ_IND;
} H_T_L1_PICH_READ_IND;*/
//-----------------------------------------------------------------------------
typedef struct H_T_L1_SCCPCH_READ_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_SCCPCH_READ_IND    L1_SCCPCH_READ_IND;
} H_T_L1_SCCPCH_READ_IND;
//-----------------------------------------------------------------------------
typedef struct H_T_L1_HSUPA_INFO_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_HSUPA_INFO_IND   L1_HSUPA_INFO_IND;
} H_T_L1_HSUPA_INFO_IND;

//-----------------------------------------------------------------------------
typedef struct H_T_L1_DPCH_READ_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_DPCH_READ_IND      L1_DPCH_READ_IND;
} H_T_L1_DPCH_READ_IND;
//-----------------------------------------------------------------------------

typedef struct H_T_L1_DPCH_SYNC_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_DPCH_SYNC_IND      L1_DPCH_SYNC_IND;
} H_T_L1_DPCH_SYNC_IND;

//-----------------------------------------------------------------------------

typedef struct H_T_L1_DCH_MEAS_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_DCH_MEAS_IND       L1_DCH_MEAS_IND;
} H_T_L1_DCH_MEAS_IND;

//-----------------------------------------------------------------------------

typedef struct H_T_L1_PWR_SWEEP_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_PWR_SWEEP_CNF      L1_PWR_SWEEP_CNF;
} H_T_L1_PWR_SWEEP_CNF;
//-----------------------------------------------------------------------------

typedef struct H_T_L1_CELL_SEARCH_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_CELL_SEARCH_CNF    L1_CELL_SEARCH_CNF;
} H_T_L1_CELL_SEARCH_CNF;
//-----------------------------------------------------------------------------
//20060305
typedef struct H_T_L1_FCH_MEAS_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_FCH_MEAS_IND       L1_FCH_MEAS_IND;
} H_T_L1_FCH_MEAS_IND;

//-----------------------------------------------------------------------------
//20070129
typedef struct H_T_L1_HSPDSCH_READ_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_HSPDSCH_READ_IND   L1_HSPDSCH_READ_IND;
} H_T_L1_HSPDSCH_READ_IND;

typedef struct H_T_HL1_SCHEDULE_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
} H_T_HL1_SCHEDULE_IND;


//20090928 PDM100 UMAC
#ifdef STACK_TD_EDGE_DM
typedef struct H_T_L1_BSIC_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_BSIC_IND           L1_BSIC_IND;
} H_T_L1_BSIC_IND;

typedef struct H_T_L1_STOP_BSIC_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_STOP_BSIC_CNF      L1_STOP_BSIC_CNF;
} H_T_L1_STOP_BSIC_CNF;

typedef struct H_T_L1_IRAT_MEAS_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_IRAT_MEAS_IND      L1_IRAT_MEAS_IND;
} H_T_L1_IRAT_MEAS_IND;

typedef struct H_T_L1_IRAT_INACTIVE_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_IRAT_INACTIVE_CNF  L1_IRAT_INACTIVE_CNF;
} H_T_L1_IRAT_INACTIVE_CNF;

typedef struct H_T_L1_GAP_END_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_GAP_END_IND        L1_GAP_END_IND;
} H_T_L1_GAP_END_IND;

//add struct for sending VB_SYNC,luodaijian 20101022
typedef struct T_VB_SYNC_PARA_Tag
{
  VOS_UINT16 scheduleFn;
  VOS_UINT8  optype;
}T_VB_SYNC_PARA;

// gongjian 20101123  D_PS_PDM100_UMAC_V0.6.3_003
typedef struct H_T_L1_PRE_SYNC_CNF_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_PRE_SYNC_CNF       L1_PRE_SYNC_CNF;
} H_T_L1_PRE_SYNC_CNF;

/* LT RESEL BEGIN */
typedef struct H_T_L1_IRAT_MEAS_CNF_Tag
{
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    T_L1_IRAT_MEAS_CNF       L1_IRAT_MEAS_CNF;
} H_T_L1_IRAT_MEAS_CNF;


typedef struct H_T_TMAC_TPHY_IRAT_MEAS_CNF_Tag
{
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    TMAC_TPHY_IRAT_MEAS_CNF_STRU       L1_TMAC_TPHY_IRAT_MEAS_CNF;
} H_T_TMAC_TPHY_IRAT_MEAS_CNF;
/* LT RESEL END */

typedef struct H_T_TMAC_TPHY_REL_CNF_Tag
{
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    TMAC_TPHY_REL_CNF_STRU       TMAC_TPHY_REL_CNF;
} H_T_TMAC_TPHY_REL_CNF;


#endif
//the structure are moved from hl1_mac.het -----end  20100805  ylm

typedef struct H_T_L1_ZSP_ABNORMAL_IND_Tag
{
  /* 20111102 l38432 MsgBlock_TDS Rel begin */
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    // T_MsgHeader            signalHeader;
    /* 20111102 l38432 MsgBlock_TDS Rel end */
  T_L1_ZSP_ABNORMAL_IND   L1_ZSP_ABNORMAL_IND;
} H_T_L1_ZSP_ABNORMAL_IND;

/* Ӷ̬LoadDspϱ */
/*****************************************************************************
 ö    : TDS_DHI_STATE_ENUM
 ṹ˵  : ʶDHIӦ״̬
 MAC_L1 State: 0--NULL   1--SEL   2--IDL 3--ACC 4-- FCH  5--DCH   6--SLP 7-- IRAT
*****************************************************************************/
enum TDS_DHI_STATE_ENUM
{
    TDS_DHI_STATE_NULL,
    TDS_DHI_STATE_SEL,
    TDS_DHI_STATE_IDL,
    TDS_DHI_STATE_ACC,
    TDS_DHI_STATE_FCH,
    TDS_DHI_STATE_DCH,
    TDS_DHI_STATE_SLP,
    TDS_DHI_STATE_IRAT,
    TDS_DHI_STATE_BUTT
};
typedef VOS_UINT8 TDS_DHI_STATE_ENUM_UINT8;

/*****************************************************************************
 ö    : TDS_LOAD_DSP_STATE_ENUM
 ṹ˵  : ʶDHIӦ״̬
 DSP  Dynamic load module:1-ICS  2-ACC  3-DCH 4-IDL 5-IRAT
*****************************************************************************/
enum TDS_LOAD_DSP_STATE_ENUM
{
    TDS_LOAD_DSP_STATE_NULL,
    TDS_LOAD_DSP_STATE_ICS,
    TDS_LOAD_DSP_STATE_ACC,
    TDS_LOAD_DSP_STATE_DCH,
    TDS_LOAD_DSP_STATE_IDL,
    TDS_LOAD_DSP_STATE_IRAT,
    TDS_LOAD_DSP_STATE_BUTT
};
typedef VOS_UINT8 TDS_LOAD_DSP_STATE_ENUM_UINT8;


/*****************************************************************************
 ö    : T_L1_DYNA_LOAD_DSP_IND_Tag
 ṹ˵  : ϱ̬LoadDspĸ
*****************************************************************************/
typedef struct T_L1_DYNA_LOAD_DSP_IND_Tag
{
    TDS_DHI_STATE_ENUM_UINT8      enDhiState;
    TDS_DHI_STATE_ENUM_UINT8      enNextDhiState;
    TDS_LOAD_DSP_STATE_ENUM_UINT8 enLoadDspModule;
    VOS_UINT8                     ucRcv;
}T_L1_DYNA_LOAD_DSP_IND;

/*****************************************************************************
 ö    : H_T_L1_DYNA_LOAD_DSP_IND_Tag
 ṹ˵  :
*****************************************************************************/
typedef struct H_T_L1_DYNA_LOAD_DSP_IND_Tag
{
    VOS_MSG_HEADER
    VOS_UINT32                    ulMsgName;

    T_L1_DYNA_LOAD_DSP_IND        stDynamicLoadDspInd;
} H_T_L1_DYNA_LOAD_DSP_IND;

/* lidui modify for HO_CCO BBIT begin */
typedef struct H_T_L1_DCH_MEAS_CNF_Tag
{
    VOS_MSG_HEADER
    VOS_UINT32              ulMsgName;

    T_L1_DCH_MEAS_CNF       stL1DchMeasCnf;
} H_T_L1_DCH_MEAS_CNF;
/* lidui modify for HO_CCO BBIT end */

#define TRRC_TPHY_WORK_MODE_TYPE_ENUM_UINT16 VOS_UINT16 


/* add for Set Work Mode Begin*/
enum TRRC_TPHY_WORK_MODE_ENUM
{
    TRRC_TPHY_WORK_MODE_TYPE_ACTIVE                = 0,     /* TDS ģ*/
    TRRC_TPHY_WORK_MODE_TYPE_INACTIVE              = 1,     /* TDS ڴģ*/
    TRRC_TPHY_WORK_MODE_TYPE_BUTT
};

typedef struct
{
    VOS_MSG_HEADER                                               /*_H2ASN_Skip*/
    VOS_UINT32                                enMsgId;           /*_H2ASN_Skip*/
    VOS_UINT16                                usOpId;
    TRRC_TPHY_WORK_MODE_TYPE_ENUM_UINT16      enWorkModeType;    /* ָʾTDSģʽ */
}TRRC_TPHY_SET_WORK_MODE_REQ_STRU;
enum TRRC_TPHY_RESULT_ENUM
{
    TRRC_TPHY_RESULT_SUCC                 = 0,                /* ɹ */
    TRRC_TPHY_RESULT_FAIL ,                                   /* ʧ */
    TRRC_TPHY_RESULT_FAIL_MASTER_TO_MASTER ,               /*ʧԭģģ  */
    TRRC_TPHY_RESULT_FAIL_TWO_MASTER,                      /* ʧԭTLΪģ */
    TRRC_TPHY_RESULT_BUTT
};
typedef VOS_UINT16    TRRC_TPHY_RESULT_ENUM_UINT16;
#if 1
typedef struct
{
    VOS_MSG_HEADER                                              /*_H2ASN_Skip*/
    VOS_UINT32                                enMsgId;          /*_H2ASN_Skip*/
    VOS_UINT16                                usOpId;
    TRRC_TPHY_RESULT_ENUM_UINT16              enWorkModeCfgRslt;
}TRRC_TPHY_SET_WORK_MODE_CNF_STRU;
#endif
/* add for Set Work Mode End*/

/* MTC NOTCH add begin */
/*****************************************************************************
 ö    : TRRC_TPHY_NOTCH_STATE_ENUM
 Э  :
 ASN.1 :
 ö˵  :  ֪ͨNOTCHָͨʾ
*****************************************************************************/

enum TRRC_TPHY_NOTCH_STATE_ENUM
{
    TRRC_TPHY_NOTCH_OPEN_FLAG_FALSE          = 0,    /*  */
    TRRC_TPHY_NOTCH_OPEN_FLAG_TRUE           = 1,    /*  */
    TRRC_TPHY_NOTCH_OPEN_FLAG_BUTT
};
typedef VOS_UINT16  TRRC_TPHY_NOTCH_STATE_ENUM_UINT16;

/*****************************************************************************
 ṹ    : TRRC_TPHY_NOTCH_BYPASS_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRC͸MTC NOTCH BYPASS Ϣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    VOS_UINT32                              enMsgId;        /*_H2ASN_Skip*/
    VOS_UINT16                              usOpId;         /* ʶ */
    TRRC_TPHY_NOTCH_STATE_ENUM_UINT16       enStartFlag;    /* ʶ */
}TRRC_TPHY_NOTCH_REQ_STRU;

/* MTC NOTCH add end */


/* BEGIN: Added by w00180842, 2013/9/22   PN:ERRLOG*/
typedef struct 
{
	VOS_UINT16 usModuFormat;//Ʒʽ0 --QPSK    1--16QAM
	VOS_UINT16 usTbiOut;//TB,ӦTBSIZEС25321-970 9.2.3.3.1-9.2.3.3.6*/
}TDS_ERRLOG_CQI_INFO_STRU;

typedef struct
{
	VOS_INT16 sSinrDB;//DPCH  sir
	VOS_UINT16 usRev;
}TDS_ERRLOG_SINR_INFO_STRU;

typedef struct
{
	VOS_INT16 sDpchPwr;
	VOS_INT16 sEpuchPwr;
}TDS_ERRLOG_UL_POWER_STRU;

typedef struct
{
    T_HeaderInfo  header;
    VOS_UINT16                                usOpId;
    VOS_UINT16                                usRev;
    TDS_ERRLOG_CQI_INFO_STRU                  stCqiInfo;
    TDS_ERRLOG_SINR_INFO_STRU                 stSinrInfo;
    TDS_ERRLOG_UL_POWER_STRU                  stUlPwrInfo;
}T_TRRC_TPHY_ERRLOG_INFO_IND_STRU;
typedef struct
{
    VOS_MSG_HEADER                                              /*_H2ASN_Skip*/
    VOS_UINT32                                enMsgId;          /*_H2ASN_Skip*/
    T_TRRC_TPHY_ERRLOG_INFO_IND_STRU          stErrLogInfo;
}TRRC_TPHY_ERRLOG_INFO_IND_STRU;

/* END:   Added by w00180842, 2013/9/22 */




//#if (VOS_OS_VER == VOS_WIN32)
//#pragma pack()
//#else
//#pragma pack(1)
//#endif
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif




#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of TPsTPhyInterface.h */
