/******************************************************************************

   Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : MmcLmmInterface.h
  Description     :
  History         :
     1.    leili  00132387, hanlufeng 41410       2011-1-31   Draft Enact

******************************************************************************/
#ifndef __MMCLMMINTERFACE_H__
#define __MMCLMMINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  #pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include "LPSCommon.h"
#include "ComInterface.h"

#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 Macro
*****************************************************************************/
    /* ЧPLMN*/
#define MMC_LMM_MAX_EQUPLMN_NUM         (16)

    /* ָPLMNϱĹPLMN */
#define MMC_LMM_MAX_SRCH_PLMN_NUM       (16)

    /* PLMNϱPLMN */
#define MMC_LMM_MAX_BG_SRCH_PLMN_NUM    (16)

    /* GU PLMNʱĽֹLAI */
#define MMC_LMM_MAX_FORB_ROAM_LAI_NUM   (16)

    /* PLMN */
#define MMC_LMM_MAX_HIGH_PLMN_NUM       (48)

    /* PLMN */
#define MMC_LMM_MAX_LOW_PLMN_NUM        (48)
#define MMC_LMM_PLMN_ID_LEN             (3)

#define NAS_MAX_SIZE_PTMSI              (4)

#define NAS_MAX_SIZE_MS_IDENTITY        (9)


#define NAS_MAX_SIZE_PTMSI_SIGNATURE    (3)

#define NAS_UMTS_CK_LENGTH              (16)
#define NAS_UMTS_IK_LENGTH              (16)
#define MMC_LMM_MAX_PLMN_NUM            (64)

#define MMC_LMM_MAX_RAT_NUM             (3)

#define MMC_LMM_MAX_FORB_ROAM_TAI_NUM   (64)
/* s00193151 add for DTS2014021904103 2014-02-19 begin */
#define MMC_LMM_MAX_FORB_RPOS_TAI_NUM   (64)
/* s00193151 add for DTS2014021904103 2014-02-19 end */

#define MMC_LMM_MAX_OPER_LONG_NAME_LEN       (40)
#define MMC_LMM_MAX_OPER_SHORT_NAME_LEN      (36)

/* Modified by z00161729 for svlte support ncell search, 2013-12-16, begin */
#define  MMC_LMM_LTE_ARFCN_MAX_NUM      (8)                 /* LTEƵб */
/* Modified by z00161729 for svlte support ncell search, 2013-12-16, end */

/*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
#define  MMC_LMM_LTE_CELL_ID_MAX_NUM      (8)               /* LTEСIDб */
/*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/

/* x00253310 modify for DTS2014052103463 2014-5-28 begin */
#define LMM_MMC_EMERGENCY_NUM_MAX_LEN            (46)
#define LMM_MMC_EMERGENCY_NUM_LIST_MAX_RECORDS   (16)
/* x00253310 modify for DTS2014052103463 2014-5-28 end */

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
enum    MMC_LMM_MSG_ID_ENUM
{
    /* MMCLMMϢԭ */
    ID_MMC_LMM_START_REQ                = (PS_MSG_ID_MMC_TO_LMM_BASE+0x01),     /* _H2ASN_MsgChoice MMC_LMM_START_REQ_STRU */
    ID_MMC_LMM_STOP_REQ                 = (PS_MSG_ID_MMC_TO_LMM_BASE+0x02),     /* _H2ASN_MsgChoice MMC_LMM_STOP_REQ_STRU */
    ID_MMC_LMM_PLMN_SRCH_REQ            = (PS_MSG_ID_MMC_TO_LMM_BASE+0x03),     /* _H2ASN_MsgChoice MMC_LMM_PLMN_SRCH_REQ_STRU */
    ID_MMC_LMM_STOP_PLMN_SRCH_REQ       = (PS_MSG_ID_MMC_TO_LMM_BASE+0x04),     /* _H2ASN_MsgChoice MMC_LMM_STOP_PLMN_SRCH_REQ_STRU */
    ID_MMC_LMM_EPLMN_NOTIFY_REQ         = (PS_MSG_ID_MMC_TO_LMM_BASE+0x05),     /* _H2ASN_MsgChoice MMC_LMM_EPLMN_NOTIFY_REQ_STRU */
    ID_MMC_LMM_CELL_SELECTION_CTRL_REQ  = (PS_MSG_ID_MMC_TO_LMM_BASE+0x06),     /* _H2ASN_MsgChoice MMC_LMM_CELL_SELECTION_CTRL_REQ_STRU */
    ID_MMC_LMM_ACTION_RESULT_REQ        = (PS_MSG_ID_MMC_TO_LMM_BASE+0x07),     /* _H2ASN_MsgChoice MMC_LMM_ACTION_RESULT_REQ_STRU */
    ID_MMC_LMM_REL_REQ                  = (PS_MSG_ID_MMC_TO_LMM_BASE+0x08),     /* _H2ASN_MsgChoice MMC_LMM_REL_REQ_STRU */
    ID_MMC_LMM_SUSPEND_REQ              = (PS_MSG_ID_MMC_TO_LMM_BASE+0x09),     /* _H2ASN_MsgChoice MMC_LMM_SUSPEND_REQ_STRU */
    ID_MMC_LMM_CSFB_REQ                 = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0A),     /* _H2ASN_MsgChoice MMC_LMM_CSFB_REQ_STRU */
    ID_MMC_LMM_SYS_CFG_REQ              = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0B),     /* _H2ASN_MsgChoice MMC_LMM_SYS_CFG_REQ_STRU */
    ID_MMC_LMM_USIM_STATUS_REQ          = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0C),     /* _H2ASN_MsgChoice MMC_LMM_USIM_STATUS_REQ_STRU */
    ID_MMC_LMM_ATTACH_REQ               = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0D),     /* _H2ASN_MsgChoice MMC_LMM_ATTACH_REQ_STRU */
    ID_MMC_LMM_DETACH_REQ               = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0E),     /* _H2ASN_MsgChoice MMC_LMM_DETACH_REQ_STRU */
    ID_MMC_LMM_RESUME_NOTIFY            = (PS_MSG_ID_MMC_TO_LMM_BASE+0x0F),     /* _H2ASN_MsgChoice MMC_LMM_RESUME_NOTIFY_STRU */
    ID_MMC_LMM_SUSPEND_RSP              = (PS_MSG_ID_MMC_TO_LMM_BASE+0x10),     /* _H2ASN_MsgChoice MMC_LMM_SUSPEND_RSP_STRU*/
    ID_MMC_LMM_DISABLE_LTE_NOTIFY       = (PS_MSG_ID_MMC_TO_LMM_BASE+0x11),     /* _H2ASN_MsgChoice MMC_LMM_DISABLE_LTE_NOTIFY_STRU*/
    ID_MMC_LMM_ENABLE_LTE_NOTIFY        = (PS_MSG_ID_MMC_TO_LMM_BASE+0x12),     /* _H2ASN_MsgChoice MMC_LMM_ENABLE_LTE_NOTIFY_STRU*/
    ID_MMC_LMM_USER_PLMN_END_NOTIFY     = (PS_MSG_ID_MMC_TO_LMM_BASE+0x13),     /* _H2ASN_MsgChoice MMC_LMM_USER_PLMN_END_NOTIFY_STRU*/
    ID_MMC_LMM_UE_OOC_STATUS_NOTIFY     = (PS_MSG_ID_MMC_TO_LMM_BASE+0x14),     /* _H2ASN_MsgChoice MMC_LMM_UE_OOC_STATUS_NOTIFY_STRU*/
    ID_MMC_LMM_WCDMA_SYS_INFO_IND       = (PS_MSG_ID_MMC_TO_LMM_BASE+0x15),     /* _H2ASN_MsgChoice MMC_LMM_WCDMA_SYS_INFO_IND_STRU*/
    ID_MMC_LMM_GSM_SYS_INFO_IND         = (PS_MSG_ID_MMC_TO_LMM_BASE+0x16),     /* _H2ASN_MsgChoice MMC_LMM_GSM_SYS_INFO_IND_STRU*/
    ID_MMC_LMM_BG_PLMN_SEARCH_REQ       = (PS_MSG_ID_MMC_TO_LMM_BASE+0x17),     /* _H2ASN_MsgChoice MMC_LMM_BG_PLMN_SEARCH_REQ_STRU*/
    ID_MMC_LMM_STOP_BG_PLMN_SEARCH_REQ  = (PS_MSG_ID_MMC_TO_LMM_BASE+0x18),     /* _H2ASN_MsgChoice MMC_LMM_STOP_BG_PLMN_SEARCH_REQ_STRU*/
    ID_MMC_LMM_UTRAN_MODE_REQ           = (PS_MSG_ID_MMC_TO_LMM_BASE+0x19),     /* _H2ASN_MsgChoice MMC_LMM_UTRAN_MODE_REQ_STRU */

    ID_MMC_LMM_SUSPEND_REL_REQ          = (PS_MSG_ID_MMC_TO_LMM_BASE+0x1A),     /* _H2ASN_MsgChoice MMC_LMM_SUSPEND_REL_REQ_STRU */
    /* Added by w00176964 for DTS2012121906946, 2012-12-20, begin */
    ID_MMC_LMM_LTE_SYS_INFO_IND         = (PS_MSG_ID_MMC_TO_LMM_BASE+0x1B),     /* _H2ASN_MsgChoice MMC_LMM_LTE_SYS_INFO_IND_STRU */
    /* Added by w00176964 for DTS2012121906946, 2012-12-20, end */
    /*ID_SM_ESM_PDP_CONTEXT_INFO_IND                 ,*/       /* _H2ASN_MsgChoice SM_ESM_PDP_CONTEXT_INFO_IND_STRU */

    /*Added by l00253982 for mmc to lmm modem infomation start*/
    ID_MMC_LMM_OTHER_MODEM_INFO_NOTIFY  = (PS_MSG_ID_MMC_TO_LMM_BASE+0x1C),     /* _H2ASN_MsgChoice MMC_LMM_OTHER_MODEM_INFO_NOTIFY_STRU*/
    /*Added by l00253982 for mmc to lmm modem infomation end*/

    /* Added by l00132387 for IMS-3, 2013-12-13, begin */
    ID_MMC_LMM_IMS_VOICE_CAP_CHANGE_NOTIFY = (PS_MSG_ID_MMC_TO_LMM_BASE+0x1D),     /* _H2ASN_MsgChoice MMC_LMM_IMS_VOICE_CAP_CHANGE_NOTIFY_STRU*/
    /* Added by l00132387 for IMS-3, 2013-12-13, end */

    /* LMM͸MMCϢԭ*/
    ID_LMM_MMC_START_CNF                = (PS_MSG_ID_LMM_TO_MMC_BASE+0x01),     /* _H2ASN_MsgChoice LMM_MMC_START_CNF_STRU */
    ID_LMM_MMC_STOP_CNF                 = (PS_MSG_ID_LMM_TO_MMC_BASE+0x02),     /* _H2ASN_MsgChoice LMM_MMC_STOP_CNF_STRU */
    ID_LMM_MMC_PLMN_SRCH_CNF            = (PS_MSG_ID_LMM_TO_MMC_BASE+0x03),     /* _H2ASN_MsgChoice LMM_MMC_PLMN_SRCH_CNF_STRU */
    ID_LMM_MMC_STOP_PLMN_SRCH_CNF       = (PS_MSG_ID_LMM_TO_MMC_BASE+0x04),     /* _H2ASN_MsgChoice LMM_MMC_STOP_PLMN_SRCH_CNF_STRU */
    ID_LMM_MMC_AREA_LOST_IND            = (PS_MSG_ID_LMM_TO_MMC_BASE+0x05),     /* _H2ASN_MsgChoice LMM_MMC_AREA_LOST_IND_STRU */
    ID_LMM_MMC_SYS_INFO_IND             = (PS_MSG_ID_LMM_TO_MMC_BASE+0x06),     /* _H2ASN_MsgChoice LMM_MMC_SYS_INFO_IND_STRU */
    ID_LMM_MMC_EMM_INFO_IND             = (PS_MSG_ID_LMM_TO_MMC_BASE+0x07),     /* _H2ASN_MsgChoice LMM_MMC_EMM_INFO_IND_STRU */
    ID_LMM_MMC_ERR_IND                  = (PS_MSG_ID_LMM_TO_MMC_BASE+0x08),     /* _H2ASN_MsgChoice LMM_MMC_ERR_IND_STRU */
    ID_LMM_MMC_EPS_SERVICE_IND          = (PS_MSG_ID_LMM_TO_MMC_BASE+0x09),     /* _H2ASN_MsgChoice LMM_MMC_EPS_SERVICE_IND_STRU */
    ID_LMM_MMC_SUSPEND_IND              = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0A),     /* _H2ASN_MsgChoice LMM_MMC_SUSPEND_IND_STRU */
    ID_LMM_MMC_SUSPEND_CNF              = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0B),     /* _H2ASN_MsgChoice LMM_MMC_SUSPEND_CNF_STRU */
    ID_LMM_MMC_RESUME_IND               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0C),     /* _H2ASN_MsgChoice LMM_MMC_RESUME_IND_STRU */
    ID_LMM_MMC_STATUS_IND               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0D),     /* _H2ASN_MsgChoice LMM_MMC_STATUS_IND_STRU */
    ID_LMM_MMC_SYS_CFG_CNF              = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0E),     /* _H2ASN_MsgChoice LMM_MMC_SYS_CFG_CNF_STRU */
    ID_LMM_MMC_USIM_STATUS_CNF          = (PS_MSG_ID_LMM_TO_MMC_BASE+0x0F),     /* _H2ASN_MsgChoice LMM_MMC_USIM_STATUS_CNF_STRU */
    ID_LMM_MMC_ATTACH_CNF               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x10),     /* _H2ASN_MsgChoice LMM_MMC_ATTACH_CNF_STRU */
    ID_LMM_MMC_ATTACH_IND               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x11),     /* _H2ASN_MsgChoice LMM_MMC_ATTACH_IND_STRU */
    ID_LMM_MMC_DETACH_CNF               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x12),     /* _H2ASN_MsgChoice LMM_MMC_DETACH_CNF_STRU */
    ID_LMM_MMC_DETACH_IND               = (PS_MSG_ID_LMM_TO_MMC_BASE+0x13),     /* _H2ASN_MsgChoice LMM_MMC_DETACH_IND_STRU */
    ID_LMM_MMC_TAU_RESULT_IND           = (PS_MSG_ID_LMM_TO_MMC_BASE+0x14),     /* _H2ASN_MsgChoice LMM_MMC_TAU_RESULT_IND_STRU */
    ID_LMM_MMC_SERVICE_RESULT_IND       = (PS_MSG_ID_LMM_TO_MMC_BASE+0x15),     /* _H2ASN_MsgChoice LMM_MMC_SERVICE_RESULT_IND_STRU */
    ID_LMM_MMC_TIN_TYPE_IND             = (PS_MSG_ID_LMM_TO_MMC_BASE+0x16),     /* _H2ASN_MsgChoice LMM_MMC_TIN_TYPE_IND_STRU */
    ID_LMM_MMC_SERVICE_STATUS_IND       = (PS_MSG_ID_LMM_TO_MMC_BASE+0X17),     /* _H2ASN_MsgChoice LMM_MMC_SERVICE_STATUS_IND_STRU */
    ID_LMM_MMC_REGISTER_STATUS_IND      = (PS_MSG_ID_LMM_TO_MMC_BASE+0X18),     /* _H2ASN_MsgChoice LMM_MMC_REGISTER_STATUS_IND_STRU */
    ID_LMM_MMC_TIMER_STATE_NOTIFY       = (PS_MSG_ID_LMM_TO_MMC_BASE+0x19),     /* _H2ASN_MsgChoice LMM_MMC_TIMER_STATE_NOTIFY_STRU */
    ID_LMM_MMC_BG_PLMN_SEARCH_CNF       = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1A),     /* _H2ASN_MsgChoice LMM_MMC_BG_PLMN_SEARCH_CNF_STRU*/
    ID_LMM_MMC_STOP_BG_PLMN_SEARCH_CNF  = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1B),     /* _H2ASN_MsgChoice LMM_MMC_STOP_BG_PLMN_SEARCH_CNF_STRU*/
    ID_LMM_MMC_NOT_CAMP_ON_IND          = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1C),     /* _H2ASN_MsgChoice LMM_MMC_NOT_CAMP_ON_IND_STRU*/
    /* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, begin */
    ID_LMM_MMC_UTRAN_MODE_CNF           = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1D),     /* _H2ASN_MsgChoice LMM_MMC_UTRAN_MODE_CNF_STRU*/
    /* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, end */
    ID_LMM_MMC_SUSPEND_REL_CNF          = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1E),     /* _H2ASN_MsgChoice LMM_MMC_SUSPEND_REL_CNF_STRU*/
    /*ID_ESM_SM_EPS_BEARER_INFO_IND                   ,    */   /* _H2ASN_MsgChoice ESM_SM_EPS_BEARER_INFO_IND_STRU */
/* lihong00150010 ims begin */
    ID_LMM_MMC_EMC_PDP_STATUS_NOTIFY    = (PS_MSG_ID_LMM_TO_MMC_BASE+0x1F),     /* _H2ASN_MsgChoice LMM_MMC_EMC_PDP_STATUS_NOTIFY_STRU*/
/* lihong00150010 ims end */
    /* ADD BY H00234341 FOR DTS2013070302684 20130617 */
    ID_LMM_MMC_SUSPEND_INFO_CHANGE_NOTIFY  = (PS_MSG_ID_LMM_TO_MMC_BASE+0x20),      /* _H2ASN_MsgChoice LMM_MMC_SUSPEND_INFO_CHANGE_NOTIFY_STRU */
    /* x00253310 modify for DTS2014052103463 2014-5-28 begin */
    ID_LMM_MMC_INFO_CHANGE_NOTIFY        = (PS_MSG_ID_LMM_TO_MMC_BASE+0x21),    /* _H2ASN_MsgChoice LMM_MMC_INFO_CHANGE_NOTIFY_STRU*/
    /* x00253310 modify for DTS2014052103463 2014-5-28 end */
    ID_MMC_LMM_MSG_ID_ENUM_BUTT
};
typedef VOS_UINT32 MMC_LMM_MSG_ID_ENUM_UINT32;

/*****************************************************************************
ö  : MMC_LMM_CELL_SEL_TYPE_ENUM_UINT32
Эʽ:
ASN.1:
ö˵:Сԭö
*****************************************************************************/
enum MMC_LMM_CELL_SEL_TYPE_ENUM
{
    MMC_LMM_RESEL_SUITABLE              = 0,

    MMC_LMM_CELL_SEL_BUTT
};
typedef VOS_UINT32  MMC_LMM_CELL_SEL_TYPE_ENUM_UINT32;


/*****************************************************************************
 ö    : MMC_LMM_DISABLE_LTE_REASON_ENUM
 ö˵  : Disable Lteԭöٶ
*****************************************************************************/
enum MMC_LMM_DISABLE_LTE_REASON_ENUM
{
    MMC_LMM_DISABLE_LTE_REASON_PS_DETACH                            =0,
    MMC_LMM_DISABLE_LTE_REASON_PS_USIM_INVALID                      =1,
    MMC_LMM_DISABLE_LTE_REASON_LTE_ROAMING_NOT_ALLOWED              =2,
    /* Modified by w00176964 for VoLTE_PhaseIII Ŀ, 2013-12-18, begin */
    MMC_LMM_DISABLE_LTE_REASON_LTE_VOICE_NOT_AVAILABLE              =3,
    /* Modified by w00176964 for VoLTE_PhaseIII Ŀ, 2013-12-18, end */
    MMC_LMM_DISABLE_LTE_REASON_EMERGENCY_CALL                       =4,
    /* Added by s00217060 for DTS2012102902559, 2012-11-22, begin */
    MMC_LMM_DISABLE_LTE_REASON_SIM_CARD_SWITCH_ON                   =5,
    /* Added by s00217060 for DTS2012102902559, 2012-11-22, end */
    /* Added by l00208543 for RatBlackListAccordSinType, 2013-11-01,begin */
    MMC_LMM_DISABLE_LTE_REASON_IMSI_IN_FORBIDDEN_LIST               =6,
    /* Added by l00208543 for RatBlackListAccordSinType, 2013-11-01,begin */
    MMC_LMM_DISABLE_LTE_REASON_BUTT
};
typedef VOS_UINT32  MMC_LMM_DISABLE_LTE_REASON_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_TRANSCEIVER_TYPE_ENUM
 Эʽ:
 ASN.1:
 ö˵:ȡֵ
*****************************************************************************/
enum MMC_LMM_TRANSCEIVER_TYPE_ENUM
{
    MMC_LMM_TRANSCEIVER_TYPE_SINGLE     = 0,                                    /* ģ */
    MMC_LMM_TRANSCEIVER_TYPE_DUAL          ,                                    /* ģ˫,LG ,LW */
    MMC_LMM_TRANSCEIVER_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_TRANSCEIVER_TYPE_ENUM_UINT32;


/*****************************************************************************
 ö: MMC_LMM_RESULT_ID_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum    MMC_LMM_RESULT_ID_ENUM
{
    MMC_LMM_SUCC                        = 0x00000000,
    MMC_LMM_FAIL                        ,
    MMC_LMM_ERR_ID_BUTT
};
typedef VOS_UINT32 MMC_LMM_RESULT_ID_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_PLMN_SRCH_TYPE_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum MMC_LMM_PLMN_SRCH_TYPE_ENUM
{
    MMC_LMM_PLMN_SRCH_SPEC              = 0,                /* ָPLMN */
    MMC_LMM_PLMN_SRCH_LIST              = 1,                /* PLMNб   */
    MMC_LMM_PLMN_SRCH_ANY               = 2,                /* any cell  */
    MMC_LMM_PLMN_SRCH_USER_SPEC         = 3,                /* userָ*/
    MMC_LMM_PLMN_SRCH_FAST_SPEC         = 4,                /* ָPLMN */

    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, begin */
    MMC_LMM_PLMN_SRCH_NCELL_SPEC        = 5,               /* SVLTEԿʱmodem1 gϱLƵϢ */
    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, end */

    MMC_LMM_PLMN_SRCH_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_PLMN_SRCH_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_PLMN_SRCH_RLT_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum MMC_LMM_PLMN_SRCH_RLT_ENUM
{
    MMC_LMM_PLMN_SRCH_RLT_SPEC_SUCC     = 0,                /* ָPLMN ID ɹ */
    MMC_LMM_PLMN_SRCH_RLT_LIST_SUCC     = 1,                /* PLMN Listɹ      */
    MMC_LMM_PLMN_SRCH_RLT_SPEC_FAIL     = 2,                /* ָPLMN IDʧ    */
    MMC_LMM_PLMN_SRCH_RLT_LIST_REJ      = 3,                /* פ̬бǳ̴ */
    MMC_LMM_PLMN_SRCH_RLT_BUTT
};
typedef VOS_UINT32  MMC_LMM_PLMN_SRCH_RLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_BG_SRCH_RLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : BG
*****************************************************************************/
enum MMC_LMM_BG_SRCH_RLT_ENUM
{
    MMC_LMM_BG_SRCH_RLT_SUCCESS            = 0,                /* ָPLMNɹ */
    MMC_LMM_BG_SRCH_RLT_FAIL               = 1,                /* ʵʷʧ */
    MMC_LMM_BG_SRCH_RLT_ABORT              = 2,                /* ûзΪǰ״ֹ̬ */
    MMC_LMM_BG_SRCH_RLT_BUTT
};
typedef VOS_UINT32  MMC_LMM_BG_SRCH_RLT_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_CELL_STATUS_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum MMC_LMM_CELL_STATUS_ENUM
{
    MMC_LMM_CELL_STATUS_NORMAL          = 0,               /* פ    */
    MMC_LMM_CELL_STATUS_ANYCELL         = 1,               /* AnyCellפ */
    MMC_LMM_CELL_STATUS_BUTT
};
typedef VOS_UINT32 MMC_LMM_CELL_STATUS_ENUM_UINT32;


/*****************************************************************************
 ö: MMC_LMM_ACTION_TYPE_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum MMC_LMM_ACTION_TYPE_ENUM
{
    MMC_LMM_ACTION_ATTACH              = 0x00000000,
    MMC_LMM_ACTION_RAU                  ,
    MMC_LMM_ACTION_LAU                  ,
    MMC_LMM_ACTION_PS_SERVICE_REQ       ,

    MMC_LMM_ACTION_MT_DETACH            ,
    MMC_LMM_ACTION_LOCAL_DETACH         ,
    MMC_LMM_ACTION_MO_DETACH            ,

    MMC_LMM_ACTION_CM_REQ               ,
    MMC_LMM_ACTION_MM_ABORT             ,
    MMC_LMM_ACTION_PERIODC_RAU          ,
    MMC_LMM_ACTION_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_ACTION_TYPE_ENUM_UINT32;


/*****************************************************************************
 ö: NAS_LMM_CN_CAUSE_ENUM
 ö˵:24301 9.9.3.9 EMM cause
*****************************************************************************/
enum    NAS_LMM_CN_CAUSE_ENUM
{
    NAS_EMM_CAUSE_IMSI_UNKNOWN_IN_HSS                                                                  = 0x00000002,    /* IMSI unknown in HSS          */
    NAS_EMM_CAUSE_ILLEGAL_UE                                                                                          = 0x00000003,    /* Illegal UE          */
    NAS_EMM_CAUSE_IMSI_UNKNOWN_IN_VLR                                   = 0x00000004, /*IMSI unknown in VLR*/
    NAS_EMM_CAUSE_IMEI_NOT_ACCEPTED                                     = 0x00000005, /*IMEI not accepted*/
    NAS_EMM_CAUSE_ILLEGAL_ME                                                                                          = 0x00000006,    /* Illegal ME              */
    NAS_EMM_CAUSE_EPS_SERV_NOT_ALLOW                                                                  = 0x00000007,    /* EPS services not allowed                */
    NAS_EMM_CAUSE_EPS_SERV_AND_NON_EPS_SERV_NOT_ALLOW                    = 0x00000008,    /* EPS services and non-EPSservices not allowed                     */
    NAS_EMM_CAUSE_MS_ID_CANNOT_BE_DERIVED_BY_NW                                       = 0x00000009,    /* MS identity cannot be derived by the network             */
    NAS_EMM_CAUSE_EPS_IMPLICITLY_DETACHED                                                          = 0x0000000a,    /* Implicitly detached  */
    NAS_EMM_CAUSE_PLMN_NOT_ALLOW                                                                             = 0x0000000b,    /* PLMN not allowed                         */
    NAS_EMM_CAUSE_TA_NOT_ALLOW                                                                                   = 0x0000000c,    /* Tracking  area not allowed                */
    NAS_EMM_CAUSE_ROAM_NOT_ALLOW                                                                            = 0x0000000d,     /* Roaming not allowed in this tracking area                      */
    NAS_EMM_CAUSE_EPS_SERV_NOT_ALLOW_IN_PLMN                                              = 0x0000000e,    /* EPS services not allowed in this PLMN   */
    NAS_EMM_CAUSE_NO_SUITABL_CELL                                                                             = 0x0000000f,     /* No Suitable Cells In Location Area       */
    NAS_EMM_CAUSE_MSC_TEMPORARILY_NOT_REACHABLE                                                              = 0x00000010,    /* MSC temporarily not reachable     */
    NAS_EMM_CAUSE_NETWORKFAILURE                                                                             = 0x00000011,    /* Network failure     */
    NAS_EMM_CAUSE_CS_DOMAIN_NOT_AVAILABLE                                                        = 0x00000012,    /* CS domain not available       */
    NAS_EMM_CAUSE_ESM_FAILURE                                                                                       = 0x00000013,    /* ESM failure       */
    NAS_EMM_CAUSE_CONGESTION                                                                                        = 0x00000016,    /* Congestion     */
    NAS_EMM_CAUSE_NOT_AUTHORIZED_FOR_THIS_CSG                                             = 0x00000019,    /*  Not authorized for this CSG        */
    /* leili 00132387 begin for r10 */
    NAS_EMM_CAUSE_REQUESTED_SER_OPTION_NOT_AUTHORIZED_IN_PLMN                           = 0x00000023, /*Requested service option not authorized in this PLMN*/
    /* leili 00132387 end for r10 */
    NAS_EMM_CAUSE_CS_DOMAIN_TEMP_NOT_AVAILABLE                                          = 0x00000027,    /*  CS domain temporarily not available       */
    NAS_EMM_CAUSE_NO_EPS_BEARER_CONTEXT_ACTIVATED                                = 0x00000028,    /*  No EPS bearer context activated        */
    NAS_EMM_CAUSE_SEMANTICALLY_INCORRECT_MSG                                              = 0x0000005f,    /* Semantically incorrect message    */
    NAS_EMM_CAUSE_INVALID_MANDATORY_INFORMATION                                         = 0x00000060,    /* Invalid mandatory information    */
    NAS_EMM_CAUSE_MSG_TYPE_NON_EXIST_OR_IMPLEMENT                                  = 0x00000061,    /* Message type non-existent or not implemented    */
    NAS_EMM_CAUSE_INFO_ELEMENT_NON_EXIST_OR_NOT_IMPLEMENT              = 0x00000063,    /*  Information element non-existent or not implemented    */
    NAS_EMM_CAUSE_MSG_NOT_COMPATIBLE_WITH_PROTOCOL_STATE              = 0x00000065,    /*Message not compatible with protocol state    */
    NAS_EMM_CAUSE_BUTT
};

typedef VOS_UINT8 NAS_LMM_CN_CAUSE_ENUM_UINT8;


/*****************************************************************************
 ö: MMC_LMM_DOMAIN_ENUM
 Эʽ:
 ASN.1:
 ö˵:   ATTACH, RAU, DETACH ͽ   : 24301  9.9.3.10 / 24008  10.5.5.1
*****************************************************************************/
enum MMC_LMM_DOMAIN_ENUM
{
    MMC_LMM_PS_ONLY                     = 0x00000000,                           /*ǰRAU/AttachΪPS only  */
    MMC_LMM_IMSI_ONLY,                                                          /*ǰ ΪCS only  */
    MMC_LMM_COMBINED_PS_IMSI ,                                                  /*ǰ Ϊϴ  */

    MMC_LMM_DOMAIN_BUTT
};
typedef VOS_UINT32 MMC_LMM_DOMAIN_ENUM_UINT32;



/*****************************************************************************
 ṹ:
 Э:
 ASN.1 :
 ṹ˵:   CN_ACCEPT, CN_REJECTӦĽ
*****************************************************************************/
enum MMC_LMM_RSLT_TYPE_ENUM
{
    MMC_LMM_RSLT_TYPE_SUCCESS                     = 0,
    MMC_LMM_RSLT_TYPE_FAILURE,                                                  /*ʧܾܰӦ*/
    MMC_LMM_RSLT_TYPE_CN_REJ,
    MMC_LMM_RSLT_TYPE_AUTH_REJ,                                                 /* Ȩ */
    MMC_LMM_RSLT_TYPE_ACCESS_BARRED,
    MMC_LMM_RSLT_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_RSLT_TYPE_ENUM_UINT32;


/*****************************************************************************
 ṹ:MMC_LMM_SYS_CHNG_TYPE_ENUM
 Э:
 ASN.1 :
 ṹ˵:LMM֪ͨMMCķ
*****************************************************************************/
enum    MMC_LMM_SYS_CHNG_DIR_ENUM
{

    MMC_LMM_SYS_CHNG_DIR_L2W            = 0x00000000,
    MMC_LMM_SYS_CHNG_DIR_L2G,
    MMC_LMM_SYS_CHNG_DIR_G2L,
    MMC_LMM_SYS_CHNG_DIR_W2L,

    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    MMC_LMM_SYS_CHNG_DIR_L2C,
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/

    MMC_LMM_SYS_CHNG_DIR_BUTT
};
typedef VOS_UINT32 MMC_LMM_SYS_CHNG_DIR_ENUM_UINT32;


/*****************************************************************************
 ṹ:MMC_LMM_SYS_CHNG_TYPE_ENUM
 Э:
 ASN.1 :
 ṹ˵:ϵͳ
*****************************************************************************/
enum MMC_LMM_SYS_CHNG_TYPE_ENUM
{
    MMC_LMM_SUS_TYPE_RSL                = 0x00000000,                           /* ѡ */
    MMC_LMM_SUS_TYPE_HO ,                                                       /* HandOver */
    MMC_LMM_SUS_TYPE_CCO ,                                                      /* Cell Change Order */
    MMC_LMM_SUS_TYPE_REDIR ,                                                    /* ض */
    MMC_LMM_SUS_TYPE_CCO_REVERSE ,      /* G->LCCOʧܣGʱLMMMMCָʾ͵Ĺ */

    MMC_LMM_SUS_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_SYS_CHNG_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : LMM_MMC_CONN_STATE_ENUM
 Э  :
 ASN.1 :
 ö˵  : LMMö
*****************************************************************************/
enum MMC_LMM_CONN_STATE_ENUM
{
    MMC_LMM_CONN_IDLE                   = 0x00000000,       /* Ӵ */
    MMC_LMM_CONN_ESTING ,                                   /*  */
    MMC_LMM_CONNECTED_SIG ,                                 /* ֻ */
    MMC_LMM_CONNECTED_DATA,                                 /*  */

    MMC_LMM_CONN_BUTT
};
typedef VOS_UINT32 MMC_LMM_CONN_STATE_ENUM_UINT32;



/*****************************************************************************
 ö    : MMC_LMM_STATUS_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  :״̬
*****************************************************************************/
enum MMC_LMM_STATUS_TYPE_ENUM
{

    MMC_LMM_STATUS_TYPE_CONN_STATE      = 0x00000000,                           /* ָʾ״̬ */
    MMC_LMM_STATUS_TYPE_T3412_EXP,                                              /* T3412ʱ */
    MMC_LMM_STATUS_TYPE_T3423_EXP,                                              /* T3423ʱ */
    MMC_LMM_STATUS_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_STATUS_TYPE_ENUM_UINT32;

/* ƵţȡֵΧ140ֱӦ 36.101  5.5  band ȡֵ */
typedef VOS_UINT32 MMC_LMM_LTE_BAND_UINT32;

/*****************************************************************************
 ö    : SMS_LMM_REG_STATE_ENUM
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum MMC_LMM_USIM_STATUS_ENUM
{
    MMC_LMM_USIM_VALID                  = 0x00000000,                           /* Ч */
    MMC_LMM_USIM_INVALID,                                                       /* ޿Ч */

    MMC_LMM_USIM_STATUS_BUTT
};
typedef VOS_UINT32 MMC_LMM_USIM_STATUS_ENUM_UINT32;


/*****************************************************************************
 ö: NAS_GUMM_INFO_TYPE_ENUM_UINT32
 Э:
 ASN.1 :
 ö˵:MMCLTEģϢGUģĲGULõĲ
*****************************************************************************/
enum NAS_GUMM_INFO_TYPE_ENUM
{
    NAS_GUMM_PTMSI                      = 0x00000000,
    NAS_GUMM_PTMSI_SIGNATURE,
    NAS_GUMM_LAI,
    NAS_GUMM_RAI,
    NAS_GUMM_UMTS_SECU_PARA,
    NAS_GUMM_TMSI_STATUS,

    NAS_GUMM_INFO_TYPE_BUTT
};
typedef VOS_UINT32 NAS_GUMM_INFO_TYPE_ENUM_UINT32;

/****************************************************************************
 ö: NAS_LMM_INFO_TYPE_ENUM_UINT32
 Э:
 ASN.1 :
 ö˵:   LTEģṩGUģϢö
*****************************************************************************/
enum NAS_LMM_INFO_TYPE_ENUM
{
    NAS_LMM_GUTI                        = 0x00000000,
    NAS_LMM_RPLMN,
    NAS_LMM_FORB_TAI_ROAM_LIST,
/* s00193151 add for DTS2014021904103 2014-02-19 begin */
    NAS_LMM_FORB_TAI_RPOS_LIST,
/* s00193151 add for DTS2014021904103 2014-02-19 end */

    NAS_LMM_CS_DOMAIN_UNAVAILABLE_PLMN_LIST,

    NAS_LMM_INFO_TYPE_BUTT
};
typedef VOS_UINT32 NAS_LMM_INFO_TYPE_ENUM_UINT32;


/****************************************************************************
 ö: MMC_LMM_EPS_UPDATE_STATUS_ENUM
 Э:
 ASN.1 :
 ö˵:   LTEEUֵö
*****************************************************************************/
enum MMC_LMM_EPS_UPDATE_STATUS_ENUM
{
    MMC_LMM_EPS_UPDATE_STATUS_UPDATED               = 0x00,             /* UPDATED */
    MMC_LMM_EPS_UPDATE_STATUS_NOT_UPDATED           = 0x01,             /* NOT UPDATED */
    MMC_LMM_EPS_UPDATE_STATUS_ROAMING_NOT_ALLOWED   = 0x02,             /* ROAMING NOT ALLOWED */

    MMC_LMM_EPS_UPDATE_STATUS_BUTT
};
typedef VOS_UINT8  MMC_LMM_EPS_UPDATE_STATUS_ENUM_UINT8;

/****************************************************************************
 ö: MMC_LMM_TAI_IN_LIST_FLAG_ENUM
 Э:
 ASN.1 :
 ö˵: TAIǷTAI LISTбʶö
*****************************************************************************/
enum MMC_LMM_TAI_IN_LIST_FLAG_ENUM
{
    MMC_LMM_TAI_IN_TAI_LIST             = 0x00,                         /* TAI IN TAI LIST */
    MMC_LMM_TAI_NOT_IN_TAI_LIST         = 0x01,                         /* TAI NOT IN TAI LIST */

    MMC_LMM_TAI_IN_LIST_FLAG_BUTT
};
typedef VOS_UINT8 MMC_LMM_TAI_IN_LIST_FLAG_ENUM_UINT8;



/*****************************************************************************
 ö: MMC_LMM_TMSI_STATUS_TYPE_ENUM_UINT32
 Э:
 ASN.1 :
 ö˵:GUṩLTEģϢö
*****************************************************************************/
enum MMC_LMM_TMSI_STATUS_TYPE_ENUM
{
    MMC_LMM_TMSI_STATUS_VALID           = 0x00000000,
    MMC_LMM_TMSI_STATUS_INVALID        ,

    MMC_LMM_TMSI_STATUS_BUTT
};
typedef VOS_UINT32 MMC_LMM_TMSI_STATUS_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_INFO_TYPE_ENUM_UINT32
 Э:
 ASN.1 :
 ö˵:MMCģṩGULTEģϢö
*****************************************************************************/
enum MMC_LMM_INFO_TYPE_ENUM
{
    MMC_LMM_TIN_TYPE                    = 0x00000000,                           /* Tin */
    MMC_LMM_EPLMN                       ,                                       /* ЧPlmn */
    MMC_LMM_FPLMN                       ,                                       /* ֹPlmn */
    MMC_LMM_FPLMN_FOR_GPRS              ,                                       /* ֹPlmn for gprs */
    MMC_LMM_EHPLMN                      ,
    MMC_LMM_HPLMN                       ,

    MMC_LMM_INFO_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_INFO_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö: MMC_LMM_TIN_TYPE_ENUM
 Э:
 ASN.1 :
 ö˵:  Tin
*****************************************************************************/
enum MMC_LMM_TIN_TYPE_ENUM
{
    MMC_LMM_TIN_P_TMSI                  = 0x00000000,
    MMC_LMM_TIN_GUTI                    ,
    MMC_LMM_TIN_RAT_RELATED_TMSI        ,
    MMC_LMM_TIN_INVALID                 ,

    MMC_LMM_TIN_BUTT
};
typedef VOS_UINT32 MMC_LMM_TIN_TYPE_ENUM_UINT32;



/*****************************************************************************
 ö: MMC_LMM_RADIO_CAP_UPD_NEED_TYPE_ENUM
 Э:
 ASN.1 :
 ö˵:
*****************************************************************************/
enum MMC_LMM_RADIO_CAP_UPD_NEED_TYPE_ENUM
{
    MMC_LMM_RADIO_CAP_UPD_NO_NEED    = 0x00000000,
    MMC_LMM_RADIO_CAP_UPD_NEED ,

    MMC_LMM_RADIO_CAP_UPD_BUTT
};
typedef VOS_UINT32 MMC_LMM_RADIO_CAP_UPD_NEED_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_PLMN_CTRL_ENUM
 Э  :
 ASN.1 :
 ö˵  : PLMNǷֹʶ
*****************************************************************************/
enum MMC_LMM_PLMN_CTRL_ENUM
{
    MMC_LMM_PLMN_ALLOW_REG              = 0,                                    /* ע */
    MMC_LMM_PLMN_NOT_ALLOW_REG          ,                                        /*ע */
    MMC_LMM_PLMN_CTRL_BUTT
};
typedef VOS_UINT32 MMC_LMM_PLMN_CTRL_ENUM_UINT32;
/*****************************************************************************
 ö    : MMC_LMM_ATT__REQ_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UEATTACH TYPE
*****************************************************************************/
enum MMC_LMM_ATT_REQ_TYPE_ENUM
{
    MMC_LMM_ATT_REQ_TYPE_CS_ONLY                      = 0,
    MMC_LMM_ATT_REQ_TYPE_PS_ONLY                      = 1,
    MMC_LMM_ATT_REQ_TYPE_CS_PS                        = 2,
    MMC_LMM_ATT_REQ_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_ATT_REQ_TYPE_ENUM_UINT32;

/*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
/*****************************************************************************
 ö    : MMC_LMM_ATT_REASON_ENUM
 Э  :
 ASN.1 :
 ö˵  : ATTACHԭ
*****************************************************************************/
enum MMC_LMM_ATT_REASON_ENUM
{
    MMC_LMM_ATT_REASON_INITIAL,
    MMC_LMM_ATT_REASON_HANDOVER,
    MMC_LMM_ATT_REASON_BUTT
};
typedef VOS_UINT32 MMC_LMM_ATT_REASON_ENUM_UINT32;
/*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/


/*****************************************************************************
 ö    : MMC_LMM_ATTACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UEATTACH TYPE
*****************************************************************************/
enum MMC_LMM_ATTACH_TYPE_ENUM
{
    MMC_LMM_ATT_TYPE_EPS_ONLY                     = 1,
    MMC_LMM_ATT_TYPE_COMBINED_EPS_IMSI            = 2,
    MMC_LMM_ATT_TYPE_EPS_EMERGENCY                = 6,
    MMC_LMM_ATT_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_ATTACH_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_ATTACH_CN_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : ӦATTACH
*****************************************************************************/
enum MMC_LMM_ATTACH_CN_RSLT_ENUM
{
    MMC_LMM_ATT_CN_RSLT_EPS_ONLY                     = 1,
    MMC_LMM_ATT_CN_RSLT_COMBINED_EPS_IMSI            = 2,
    MMC_LMM_ATT_CN_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_ATTACH_CN_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_ATTACH_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : ATTACHĽ
*****************************************************************************/
enum MMC_LMM_ATTACH_RSLT_ENUM
{

    MMC_LMM_ATT_RSLT_SUCCESS                     = 0x00000000,
    MMC_LMM_ATT_RSLT_FAILURE,                                                   /*ATTACHδָԭʧ */
    MMC_LMM_ATT_RSLT_ACCESS_BAR,                                                /* 뱻 Barred */
    MMC_LMM_ATT_RSLT_TIMER_EXP,                                                 /* Ӧ */
    MMC_LMM_ATT_RSLT_CN_REJ,                                                    /* ȷܾ */
    MMC_LMM_ATT_RSLT_AUTH_REJ,                                                  /* Ȩ */
    MMC_LMM_ATT_RSLT_PS_ATT_NOT_ALLOW,                                          /* psעǲע*/
    MMC_LMM_ATT_RSLT_FORBID_PLMN,                                               /* PLMN*/
    MMC_LMM_ATT_RSLT_FORBID_PLMN_FOR_GPRS,                                      /* PLMN FOR GRPS*/
    MMC_LMM_ATT_RSLT_FORBID_TA_FOR_ROAMING,                                     /* TA FOR ROAM*/
    MMC_LMM_ATT_RSLT_FORBID_TA_FOR_RPOS,                                        /* TA FOR RPOS*/
    MMC_LMM_ATT_RSLT_ESM_FAILURE,
    MMC_LMM_ATT_RSLT_MO_DETACH_FAILURE,
    MMC_LMM_ATT_RSLT_MT_DETACH_FAILURE,
    MMC_LMM_ATT_RSLT_T3402_RUNNING,
    MMC_LMM_ATT_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_ATTACH_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_MO_DETACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UEDETACH TYPE
*****************************************************************************/
enum MMC_LMM_MO_DETACH_TYPE_ENUM
{
    MMC_LMM_MO_DET_PS_ONLY                        = 1,
    MMC_LMM_MO_DET_CS_ONLY                        = 2,
    MMC_LMM_MO_DET_CS_PS                          = 3,
    MMC_LMM_MO_DETACH_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_MO_DETACH_TYPE_ENUM_UINT32;

/*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
/*****************************************************************************
 ö    : MMC_LMM_DETACH_RESEAON_ENUM
 Э  :
 ASN.1 :
 ö˵  : DETACHԭ
*****************************************************************************/
enum MMC_LMM_DETACH_RESEAON_ENUM
{
    MMC_LMM_DETACH_RESEAON_NULL,                  /*ԭ*/
    MMC_LMM_DETACH_RESEAON_NON_3GPP_ATTACH,       /*non-3GPP뼼նעᣬLTEҪȥע*/
    MMC_LMM_DETACH_RESEAON_BUTT
};
typedef VOS_UINT32 MMC_LMM_DETACH_RESEAON_ENUM_UINT32;
/*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/


/*****************************************************************************
 ö    : MMC_LMM_MT_DETACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ഥDETACH TYPE
*****************************************************************************/
enum MMC_LMM_MT_DETACH_TYPE_ENUM
{
    MMC_LMM_MT_DET_REATTACH_REQUIRED                = 1,
    MMC_LMM_MT_DET_REATTACH_NOT_REQUIRED            = 2,
    MMC_LMM_MT_DET_IMSI                             = 3,

    MMC_LMM_MT_DETACH_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_MT_DETACH_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_DETACH_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : DETACHĽ
*****************************************************************************/
enum MMC_LMM_DETACH_RSLT_ENUM
{
    MMC_LMM_DETACH_RSLT_SUCCESS         = 0,
    MMC_LMM_DETACH_RSLT_ACCESS_BARED    ,
    MMC_LMM_DETACH_RSLT_FAILURE         ,
    MMC_LMM_DETACH_RSLT_AUTH_REJ        ,

    MMC_LMM_DETACH_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_DETACH_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_DETACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ഥDETACH򱾵DETACH
*****************************************************************************/
enum MMC_LMM_DETACH_TYPE_ENUM
{
    MMC_LMM_DETACH_LOCAL                            = 1,
    MMC_LMM_DETACH_MT                               = 2,

    MMC_LMM_DETACH_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_DETACH_TYPE_ENUM_UINT32;


/*****************************************************************************
 ö    : MMC_LMM_TAU_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UETAU
*****************************************************************************/
enum MMC_LMM_TAU_TYPE_ENUM
{
    MMC_LMM_TA_UPDATING                     = 0,
    MMC_LMM_COMBINED_TA_LA_UPDATING         = 1,
    MMC_LMM_COMBINED_TA_LA_WITH_IMSI        = 2,
    MMC_LMM_PS_PERIODIC_UPDATING            = 3,
    MMC_LMM_CS_PS_PERIODIC_UPDATING         = 4,
    MMC_LMM_TAU_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_TAU_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_TAU_CN_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : ӦTAU
*****************************************************************************/
enum MMC_LMM_TAU_CN_RSLT_ENUM
{
    MMC_LMM_TA_UPDATED                     = 0,
    MMC_LMM_COMBINED_TA_LA_UPDATED         = 1,
    MMC_LMM_TA_UPDATED_ISR_ACTIVATED       = 4,
    MMC_LMM_COMBINED_TA_LA_UPDATED_ISR_ACTIVATED              = 5,
    MMC_LMM_TAU_CN_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_TAU_CN_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_TAU_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : TAUĽ
*****************************************************************************/
enum MMC_LMM_TAU_RSLT_ENUM
{

    MMC_LMM_TAU_RSLT_SUCCESS                     = 0,
    MMC_LMM_TAU_RSLT_FAILURE,                           /*δָԭʧ*/
    MMC_LMM_TAU_RSLT_ACCESS_BARED,                      /*TAU뱻bar*/
    MMC_LMM_TAU_RSLT_TIMER_EXP,                         /*TAUʱʱ*/
    MMC_LMM_TAU_RSLT_CN_REJ,                            /*TAUܾ*/
    MMC_LMM_TAU_RSLT_AUTH_REJ,                          /*Ȩܾ*/
    MMC_LMM_TAU_RSLT_FORBID_PLMN,                       /* PLMN*/
    MMC_LMM_TAU_RSLT_FORBID_PLMN_FOR_GPRS,              /* PLMN FOR GRPS*/
    MMC_LMM_TAU_RSLT_FORBID_TA_FOR_ROAMING,             /* TA FOR ROAM*/
    MMC_LMM_TAU_RSLT_FORBID_TA_FOR_RPOS,                /* TA FOR RPOS*/
    MMC_LMM_TAU_RSLT_MO_DETACH_FAILURE,
    MMC_LMM_TAU_RSLT_MT_DETACH_FAILURE,
    MMC_LMM_TAU_RSLT_T3402_RUNNING,
    MMC_LMM_TAU_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_TAU_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_SERVICE_RSLT_ENUM
 Э  :
 ASN.1 :
 ö˵  : SERVICEĽ
*****************************************************************************/
enum MMC_LMM_SERVICE_RSLT_ENUM
{

    MMC_LMM_SERVICE_RSLT_FAILURE        = 0,                                    /*ܾʧ*/
    MMC_LMM_SERVICE_RSLT_ACCESS_BARED   ,                                       /*뱻bar*/
    MMC_LMM_SERVICE_RSLT_CN_REJ         ,                                       /*ܾ*/
    MMC_LMM_SERVICE_RSLT_AUTH_REJ       ,                                       /*Ȩܾ*/

    MMC_LMM_SERVICE_RSLT_BUTT
};
typedef VOS_UINT32 MMC_LMM_SERVICE_RSLT_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_SERVICE_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UEEXTENDED SERVICEͣʱ
*****************************************************************************/
enum MMC_LMM_SERVICE_TYPE_ENUM
{
    MMC_LMM_SERVICE_MO_CSFB_1XCSFB              = 0,
    MMC_LMM_SERVICR_MT_CSFB_1XCSFB,
    MMC_LMM_SERVICR_MO_CSFB_1XCSFB_EMERGENCY,
    MMC_LMM_SERVICE_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_SERVICE_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_SERVICE_STATUS_ENUM
 Э  :
 ASN.1 :
 ö˵  : LMMϱservice status
*****************************************************************************/
enum MMC_LMM_SERVICE_STATUS_ENUM
{
    MMC_LMM_SERVICE_STATUS_NO_SERVICE           = 0,
    MMC_LMM_SERVICE_STATUS_LIMIT_SERVICE,
    MMC_LMM_SERVICE_STATUS_NORMAL_SERVICE,
    MMC_LMM_SERVICE_STATUS_LIMIT_SERVICE_REGION,
    MMC_LMM_SERVICE_STATUS_DEEP_SLEEP,
    MMC_LMM_SERVICE_STATUS_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_SERVICE_STATUS_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_SYS_MODE_ENUM
 Э  :
 ASN.1 :
 ö˵  : LMMϱsys mode
*****************************************************************************/
enum MMC_LMM_SYS_MODE_ENUM
{
    MMC_LMM_SERVICE_MODE_NO_SERVICE             = 0,
    MMC_LMM_SERVICE_MODE_GSM,
    MMC_LMM_SERVICE_MODE_CDMA,
    MMC_LMM_SERVICE_MODE_WCDMA,
    MMC_LMM_SERVICE_MODE_TDSCDMA,
    MMC_LMM_SERVICE_MODE_WIMAX,
    MMC_LMM_SERVICE_MODE_LTE,
    MMC_LMM_SERVICE_MODE_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_SYS_MODE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_REGISTER_STATUS_ENUM
 Э  :
 ASN.1 :
 ö˵  : LMMϱregister status
*****************************************************************************/
enum MMC_LMM_REGISTER_STATUS_ENUM
{
    MMC_LMM_REGISTER_STATUS_NOT_REG_NOT_SRCHING = 0,
    MMC_LMM_REGISTER_STATUS_REG_HPLMN,
    MMC_LMM_REGISTER_STATUS_NOT_REG_SRCHING,
    MMC_LMM_REGISTER_STATUS_REG_DENINED,
    MMC_LMM_REGISTER_STATUS_UNKNOWN,
    MMC_LMM_REGISTER_STATUS_REG_ROAMING,
    MMC_LMM_REGISTER_STATUS_BUTT
};
typedef VOS_UINT32 MMC_LMM_REGISTER_STATUS_ENUM_UINT32;


/*****************************************************************************
 ö    : MMC_LMM_L_LOCAL_DETACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : DETACH
*****************************************************************************/
enum MMC_LMM_L_LOCAL_DETACH_TYPE_ENUM
{
    MMC_LMM_L_LOCAL_DETACH_IMSI_PAGING          = 0,
    MMC_LMM_L_LOCAL_DETACH_OTHERS               = 1,

    MMC_LMM_L_LOCAL_DETACH_TYPE_BUTT
};
typedef VOS_UINT32 MMC_LMM_L_LOCAL_DETACH_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_GPRS_UPDATE_STATUS_ENUM
 Э  :
 ASN.1 :
 ö˵  : GPRS update statusö
*****************************************************************************/
enum MMC_LMM_GPRS_UPDATE_STATUS_ENUM
{
    MMC_LMM_GPRS_UPDATE_STATUS_UPDATED,
    MMC_LMM_GPRS_UPDATE_STATUS_NOT_UPDATED,
    MMC_LMM_GPRS_UPDATE_STATUS_PLMN_NOT_ALLOWED,
    MMC_LMM_GPRS_UPDATE_STATUS_ROUTING_AREA_NOT_ALLOWED,
    MMC_LMM_GPRS_UPDATE_STATUS_BUTT
};
typedef VOS_UINT8 MMC_LMM_GPRS_UPDATE_STATUS_ENUM_UINT8;

/*****************************************************************************
 ö    : MMC_LMM_CS_UPDATE_STATUS_ENUM
 Э  :
 ASN.1 :
 ö˵  : MM update statusö
*****************************************************************************/
enum MMC_LMM_CS_UPDATE_STATUS_ENUM
{
    MMC_LMM_CS_UPDATE_STATUS_UPDATED,
    MMC_LMM_CS_UPDATE_STATUS_NOT_UPDATED,
    MMC_LMM_CS_UPDATE_STATUS_PLMN_NOT_ALLOWED,
    MMC_LMM_CS_UPDATE_STATUS_LOCATION_AREA_NOT_ALLOWED,
    MMC_LMM_CS_UPDATE_STATUS_UPDATING_DISABLED,
    MMC_LMM_CS_UPDATE_STATUS_BUTT
};
typedef VOS_UINT8 MMC_LMM_CS_UPDATE_STATUS_ENUM_UINT8;


/*****************************************************************************
 ö    : MMC_LMM_GU_LOCAL_DETACH_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : UEdetach type
*****************************************************************************/
enum MMC_LMM_GU_LOCAL_DETACH_TYPE_ENUM
{
    MMC_LMM_GU_LOCAL_DET_IMSI_PAGING,
    MMC_LMM_GU_LOCAL_DET_OTHERS,
    MMC_LMM_GU_LOCAL_DET_BUTT
};
typedef VOS_UINT32 MMC_LMM_GU_LOCAL_DETACH_TYPE_ENUM_UINT32;



enum LMM_MMC_TIMER_STATE_ENUM
{
    LMM_MMC_TIMER_STOP         = 0,
    LMM_MMC_TIMER_START,
    LMM_MMC_TIMER_EXP,

    LMM_MMC_TIMER_BUTT
};
typedef VOS_UINT32 LMM_MMC_TIMER_STATE_ENUM_UINT32;

/*****************************************************************************
 ö    : MMC_LMM_RAT_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : 뼼öٶ
*****************************************************************************/
enum MMC_LMM_RAT_TYPE_ENUM
{
    MMC_LMM_RAT_GSM                     = 0,
    MMC_LMM_RAT_WCDMA_FDD               = 1,
    MMC_LMM_RAT_LTE                     = 2,
    MMC_LMM_RAT_TYPE_BUTT
};
typedef VOS_UINT8  MMC_LMM_RAT_TYPE_ENUM_UINT8;

/*****************************************************************************
 ö    : MMC_LMM_RAT_LIST_SEARCH_RSLT_ENUM
 ṹ˵  : LMM_MMC_PLMN_SRCH_CNF_STRUϢеLIST
*****************************************************************************/
enum MMC_LMM_RAT_LIST_SEARCH_RSLT_ENUM
{
    MMC_LMM_RAT_LIST_SEARCH_NOT_START      = 0,                /* LISTδ        */
    MMC_LMM_RAT_LIST_SEARCH_PARTIAL_CMPL   = 1,                /* LIST, */
    MMC_LMM_RAT_LIST_SEARCH_CMPL           = 2,                /* LIST          */
    MMC_LMM_RAT_LIST_SEARCH_BUTT
};
typedef VOS_UINT8  MMC_LMM_RAT_LIST_SEARCH_RSLT_ENUM_UINT8;


/*****************************************************************************
 ö: MMC_LMM_PLMN_SRCH_RLT_ENUM
 Эʽ:
 ASN.1:
 ö˵:
*****************************************************************************/
enum MMC_LMM_COVERAGE_TYPE_ENUM
{
    MMC_LMM_COVERAGE_TYPE_NONE     = 0,                /* 縲 */
    MMC_LMM_COVERAGE_TYPE_LOW      = 1,                 /* 縲   */
    MMC_LMM_COVERAGE_TYPE_HIGH     = 2,                /* и縲 */
    MMC_LMM_COVERAGE_TYPE_BUTT
};
typedef VOS_UINT32  MMC_LMM_COVERAGE_TYPE_ENUM_UINT32;



/*****************************************************************************
 ö    : NASUTRANCTRL_UTRAN_MODE_ENUM
 ṹ˵  : MSǰUTRANģʽ:WCDMA/TD-SCAMA
 1.       : 2012727
          : w00176964
   ޸   : ½
*****************************************************************************/
enum MMC_LMM_UTRAN_MODE_ENUM
{
    MMC_LMM_UTRAN_MODE_FDD          = 0,     /* ǰģʽΪWCDMA */
    MMC_LMM_UTRAN_MODE_TDD          = 1,     /* ǰģʽΪTDSCDMA */
    MMC_LMM_UTRAN_MODE_BUTT
};
typedef VOS_UINT8  MMC_LMM_UTRAN_MODE_ENUM_UINT8;



/* Added by l00132387 for IMS-3, 2013-12-13, begin */

/*****************************************************************************
 ö    : MMC_LMM_IMS_VOICE_CAP_CHANGE_ENUM_UINT8
 ṹ˵  : IMS VOICE CAPǷı
 1.       : 20131213
          : l00132387
   ޸   : ½
*****************************************************************************/
enum MMC_LMM_IMS_VOICE_CAP_ENUM
{
    MMC_LMM_IMS_VOICE_CAP_UNAVAILABLE             = 0,
    MMC_LMM_IMS_VOICE_CAP_AVAILABLE                 = 1,

    MMC_LMM_IMS_VOICE_CAP_CHANGE_BUTT
};
typedef VOS_UINT8  MMC_LMM_IMS_VOICE_CAP_ENUM_UINT8;

/* Added by l00132387 for IMS-3, 2013-12-13, end */

/* x00253310 modify for DTS2014052103463 2014-5-28 begin */
/*****************************************************************************
 ö    : LMM_MMC_NW_IMS_VOICE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ֵ֧IMS VOICEö
*****************************************************************************/
enum LMM_MMC_NW_IMS_VOICE_ENUM
{
    LMM_MMC_NW_IMS_VOICE_NOT_SUPPORTED   = 0,
    LMM_MMC_NW_IMS_VOICE_SUPPORTED        = 1,

    LMM_MMC_NW_IMS_VOICE_BUTT
};
typedef VOS_UINT32 LMM_MMC_NW_IMS_VOICE_ENUM_UINT32;

/*****************************************************************************
 ö    : LMM_MMC_NW_EMC_BS_ENUM
 Э  :
 ASN.1 :
 ö˵  : ֵ֧EMC BEARER SERVICEEö
*****************************************************************************/
enum LMM_MMC_NW_EMC_BS_ENUM
{
    LMM_MMC_NW_EMC_BS_NOT_SUPPORTED      = 0,
    LMM_MMC_NW_EMC_BS_SUPPORTED           = 1,

    LMM_MMC_NW_EMC_BS_BUTT
};
typedef VOS_UINT32 LMM_MMC_NW_EMC_BS_ENUM_UINT32;

/*****************************************************************************
 ö    : LMM_MMC_LTE_CS_CAPBILITY_ENUM
 Э  :
 ASN.1 :
 ö˵  : LTECS
*****************************************************************************/
enum LMM_MMC_LTE_CS_CAPBILITY_ENUM
{
    LMM_MMC_LTE_CS_CAPBILITY_NO_ADDITION_INFO  = 0,  /* NO_ADDITION_INFOʾCS֧ȫ */
    LMM_MMC_LTE_CS_CAPBILITY_CSFB_NOT_PREFER   = 1,
    LMM_MMC_LTE_CS_CAPBILITY_SMS_ONLY          = 2,
    /* leixiantiao 00258641 DTS2014061300419 begin */
    LMM_MMC_LTE_CS_CAPBILITY_NOT_ATTACHED      = 3,
    /* leixiantiao 00258641 DTS2014061300419 end */
    LMM_MMC_LTE_CS_CAPBILITY_BUTT
};
typedef VOS_UINT32 LMM_MMC_LTE_CS_CAPBILITY_ENUM_UINT32;
/* x00253310 modify for DTS2014052103463 2014-5-28 end */

/* Added by s00217060 for DTS2014080700822, 2014-08-14, Begin */
/*****************************************************************************
 ṹ: MMC_LMM_ACCESS_TYPE_ENUM
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
enum MMC_LMM_ACCESS_TYPE_ENUM
{
    MMC_LMM_ACCESS_TYPE_EUTRAN_TDD      = 0,
    MMC_LMM_ACCESS_TYPE_EUTRAN_FDD         ,
    MMC_LMM_ACCESS_TYPE_BUTT
};
typedef VOS_UINT8  MMC_LMM_ACCESS_TYPE_ENUM_UINT8;
/* Added by s00217060 for DTS2014080700822, 2014-08-14, End */


/*****************************************************************************
  5 STRUCT
*****************************************************************************/

/*****************************************************************************
ṹ    :MMC_LMM_PLMN_ID_STRU
Э  :
ASN.1 :
ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucPlmnId[MMC_LMM_PLMN_ID_LEN];
    VOS_UINT8                           ucRsv;
}MMC_LMM_PLMN_ID_STRU;

/*****************************************************************************
ṹ    :MMC_LMM_PLMN_ID_WITH_RAT_STRU
Э  :
ASN.1 :
ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucPlmnId[MMC_LMM_PLMN_ID_LEN];
    MMC_LMM_RAT_TYPE_ENUM_UINT8         enPlmnRat;
}MMC_LMM_PLMN_ID_WITH_RAT_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_EPLMN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ЧPLMNݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulPlmnNum;                              /* Ч PLMN    */
    MMC_LMM_PLMN_ID_STRU                astEplmnList[MMC_LMM_MAX_EQUPLMN_NUM];
}MMC_LMM_EPLMN_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_SUIT_PLMN_ID_LIST_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_SUIT_PLMN_ID_LIST_STRUݽṹ
*****************************************************************************/
typedef struct
{
    /* ǰСϵͳϢаĹ plmn idĸ */
    VOS_UINT32                          ulSuitPlmnNum;

    /* СϵͳϢа plmn idĸ   */
    MMC_LMM_PLMN_ID_STRU                astSuitPlmnList[MMC_LMM_MAX_SRCH_PLMN_NUM];
} MMC_LMM_SUIT_PLMN_ID_LIST_STRU;


/*****************************************************************************
 ṹ    : MMC_LMM_LOW_PLMN_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_LOW_PLMN_INFO_STRUݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_PLMN_ID_STRU                stPlmnId;                               /* PLMN ID    */
    VOS_INT32                           lRscp;                                  /* RSCPֵ */
}MMC_LMM_LOW_PLMN_INFO_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_LOW_PLMN_WITH_RAT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_LOW_PLMN_WITH_RAT_STRUݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_PLMN_ID_WITH_RAT_STRU       stPlmnIdWithRat;                        /* PLMN ID    */
    VOS_INT32                           lRscp;                                  /* RSCPֵ */
}MMC_LMM_LOW_PLMN_WITH_RAT_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_PLMN_ID_LIST_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_PLMN_ID_LIST_STRUݽṹ
*****************************************************************************/
typedef struct
{
    /* PLMNĸ */
    VOS_UINT32                          ulHighPlmnNum;

    /* PLMNб   */
    MMC_LMM_PLMN_ID_WITH_RAT_STRU       astHighPlmnWithRatList[MMC_LMM_MAX_HIGH_PLMN_NUM];


    /* PLMNĸ */
    VOS_UINT32                          ulLowPlmnNum;

    /* PLMNб   */
    MMC_LMM_LOW_PLMN_WITH_RAT_STRU      astLowPlmnWithRatList[MMC_LMM_MAX_LOW_PLMN_NUM];
}MMC_LMM_PLMN_ID_LIST_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_LIST_SEARCH_RAT_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_LIST_SEARCH_RAT_INFO_STRUݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_RAT_TYPE_ENUM_UINT8              enRat;                            /* Ľ뼼 */
    MMC_LMM_RAT_LIST_SEARCH_RSLT_ENUM_UINT8  enListSearchRlt;                  /* 뼼LISTɽ */
    VOS_UINT8                                aucReserve[2];
}MMC_LMM_LIST_SEARCH_RAT_INFO_STRU;

/*****************************************************************************
ṹ    :MMC_LMM_LAC_STRU
ʹ˵    :TACϢ  24.301  9.9.3.26
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucLac;
    VOS_UINT8                           ucLacCnt;
    VOS_UINT8                           aucRsv[2];
}MMC_LMM_LAC_STRU;

/*****************************************************************************
ṹ    :NAS_LMM_TAC_STRU
ʹ˵    :TACϢ  24.301  9.9.3.26
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucTac;
    VOS_UINT8                           ucTacCnt;
    VOS_UINT8                           aucRsv[2];
}NAS_LMM_TAC_STRU;

/*****************************************************************************
 ṹ: NAS_LMM_SYS_INFO_STRU
 Э:
 ASN.1 :
 ṹ˵:LTEģСϵͳϢ
*****************************************************************************/
typedef struct
{
    MMC_LMM_SUIT_PLMN_ID_LIST_STRU      stSpecPlmnIdList;                       /* ǰСĹб */
    NAS_LMM_TAC_STRU                    stTac;                                  /* TrackingAreaCode */
    VOS_UINT32                          ulCellId;                               /* Cell Identity */
    MMC_LMM_CELL_STATUS_ENUM_UINT32     enCellStatusInd;                        /* С״ָ̬ʾ */

    /* Added by w00167002 for V7R1 phase II , 2011-07-28, begin */
    LTE_BAND_STRU                       stLteBand;                              /* LģǰפƵϢ */
    /* Added by w00167002 for V7R1 phase II , 2011-07-28, end */

    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    VOS_UINT16                          usArfcn;                                /* פƵϢ */
    /* Modify by leixiantiao 00258641 begin */
    VOS_UINT8                           ucBandWidth;                            /* Ϣ */
    /* Modified by s00217060 for DTS2014080700822, 2014-08-14, Begin */
    MMC_LMM_ACCESS_TYPE_ENUM_UINT8      enAccessType;                           /* :TDD/FDD */
    /* Modified by s00217060 for DTS2014080700822, 2014-08-14, End */
    /* Modify by leixiantiao 00258641 end */
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/
}MMC_LMM_SYS_INFO_STRU;


/*****************************************************************************
 ṹ    : MMC_LMM_LAI_STRU
 ṹ˵  : LAϢݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_PLMN_ID_STRU                stPlmnId;
    MMC_LMM_LAC_STRU                    stLac;
}MMC_LMM_LAI_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_RAI_STRU
 ṹ˵  : RAIϢݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_LAI_STRU                    stLai;
    VOS_UINT8                           ucRac;
    VOS_UINT8                           aucReserve[3];
}MMC_LMM_RAI_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_MS_IDNETITY_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucMsIdentity[NAS_MAX_SIZE_MS_IDENTITY];
    VOS_UINT8                           aucRsv[3];
} MMC_LMM_MS_IDNETITY_STRU;


/*****************************************************************************
 ṹ: NAS_GUMM_PTMSI_STRU
 Э:
 ASN.1 :
 ṹ˵:  24.008 10.5.1.4
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucPtmsi[NAS_MAX_SIZE_PTMSI];
} NAS_GUMM_PTMSI_STRU;


/*****************************************************************************
 ṹ: NAS_GUMM_PTMSI_SIGNATURE_STRU
 Э:
 ASN.1 :
 ṹ˵:24.008 10.5.5.8
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucPtmsiSign[NAS_MAX_SIZE_PTMSI_SIGNATURE];
    VOS_UINT8                           ucRsv;
} NAS_GUMM_PTMSI_SIGNATURE_STRU;

/*****************************************************************************
 ṹ: NAS_GUMM_SECU_CONTEXT_STRU
 Э:
 ASN.1 :
 ṹ˵:ҪLMMĸRATLTE任
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucKSI;
    VOS_UINT8                           aucRsv[3];
    VOS_UINT8                           aucCK[NAS_UMTS_CK_LENGTH];
    VOS_UINT8                           aucIK[NAS_UMTS_IK_LENGTH];

} NAS_GUMM_UMTS_CONTEXT_STRU;

/****************************************************************************
ṹ    : NAS_LMM_GUTI_HEAD_STRU
ṹ˵    : 24.301 9.9.3.10  EPS mobile identity
****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucLenth;
    VOS_UINT8                           ucOeToi;
    VOS_UINT8                           aucRsv[2];
}NAS_LMM_GUTI_HEAD_STRU;



/****************************************************************************
ṹ    :NAS_LMM_MME_GROUPID_STRU
ʹ˵    :NAS_LMM_MME_GROUPID_STRUز
Э DIGITֽ/λĹϵ:
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucGroupId;
    VOS_UINT8                           ucGroupIdCnt;
    VOS_UINT8                           aucRsv[2];
}NAS_LMM_MME_GROUPID_STRU;

/****************************************************************************
ṹ    :NAS_LMM_MME_CODE_STRU
ʹ˵    :NAS_LMM_MME_CODE_STRUز
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucMmeCode;
    VOS_UINT8                           aucRsv[3];
}NAS_LMM_MME_CODE_STRU;

/****************************************************************************
ṹ    :NAS_LMM_MTMSI_STRU
ʹ˵    :NAS_LMM_MTMSI_STRUز
Э DIGITֽ/λĹϵ:
*************************************************************/
typedef struct
{
    VOS_UINT8                           ucMTmsi;
    VOS_UINT8                           ucMTmsiCnt1;
    VOS_UINT8                           ucMTmsiCnt2;
    VOS_UINT8                           ucMTmsiCnt3;
}NAS_LMM_MTMSI_STRU;

/*****************************************************************************
ṹ    :NAS_MM_GUTI_STRU
ʹ˵    :NAS_MM_GUTI_STRUز
*****************************************************************************/
typedef struct
{
    NAS_LMM_GUTI_HEAD_STRU               stGutiHead;
    MMC_LMM_PLMN_ID_STRU                 stPlmnId;
    NAS_LMM_MME_GROUPID_STRU             stMmeGroupId;
    NAS_LMM_MME_CODE_STRU                stMmeCode;
    NAS_LMM_MTMSI_STRU                   stMTmsi;
}NAS_LMM_GUTI_STRU;

/*****************************************************************************
ṹ    :NAS_MM_PLMN_LIST_STRU
ʹ˵    :10.5.13/3GPP TS 24.008 PLMN List information element
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulPlmnNum;
    MMC_LMM_PLMN_ID_STRU                astPlmnId[MMC_LMM_MAX_PLMN_NUM];
}MMC_LMM_PLMN_LIST_STRU;

/*****************************************************************************
 ṹ    : NAS_LMM_TAI_STRU
 ṹ˵  : TAϢݽṹ
*****************************************************************************/
typedef struct
{
    MMC_LMM_PLMN_ID_STRU                 stPlmnId;
    NAS_LMM_TAC_STRU                     stTac;
}NAS_LMM_TAI_STRU;


/*****************************************************************************
 ṹ    : NAS_LMM_TAI_LIST_STRU
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_UINT32                           ulTaNum;
    NAS_LMM_TAI_STRU                     astTa[MMC_LMM_MAX_FORB_ROAM_TAI_NUM];
}NAS_LMM_TAI_LIST_STRU;


/*****************************************************************************
 ṹ: MMC_LMM_START_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_TRANSCEIVER_TYPE_ENUM_UINT32 ulTransceiverType;
    MMC_LMM_USIM_STATUS_ENUM_UINT32      ulUsimState;
    RRMM_RAT_PRIO_ENUM_UINT8             aucRatPrioList[RRMM_RAT_TYPE_BUTT];     /* ģȼ */
    /* Modified by w00176964 for  V7R1C50_GUTL_PhaseII, 2012-8-30, begin */
    MMC_LMM_UTRAN_MODE_ENUM_UINT8       enUtranMode;                            /* ǰUTRANĹģʽ:0---FDD 1---TDD */
    /* Modified by w00176964 for  V7R1C50_GUTL_PhaseII, 2012-8-30, end */
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    VOS_UINT8                           aucRsv[2];
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/
} MMC_LMM_START_REQ_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_START_CNF_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ִн */
    MMC_LMM_RESULT_ID_ENUM_UINT32          ulRst;
} LMM_MMC_START_CNF_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_STOP_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:MMC_LMM_STOP_REQ_STRUṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
}MMC_LMM_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
}LMM_MMC_STOP_CNF_STRU;


/*****************************************************************************
 ṹ    : MMC_LMM_ATTACH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_ATTACH_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_ATT_REQ_TYPE_ENUM_UINT32    ulAttachType;
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    MMC_LMM_ATT_REASON_ENUM_UINT32      ulAttachReason;
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/
}MMC_LMM_ATTACH_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_ATTACH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_ATTACH_CNF_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_ATTACH_RSLT_ENUM_UINT32     ulAttachRslt;       /* ATTACH */
    MMC_LMM_ATT_REQ_TYPE_ENUM_UINT32    ulReqType;          /* ûATTACH */

}LMM_MMC_ATTACH_CNF_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_ATTACH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_ATTACH_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;


    VOS_UINT32                          bitOpCnRslt     : 1;
    VOS_UINT32                          bitOpCnCause    : 1;
    VOS_UINT32                          bitOpAtmpCnt    : 1;
    VOS_UINT32                          bitOpEplmn      : 1;
    VOS_UINT32                          bitOpLai        : 1;

    VOS_UINT32                          bitOpMsIdentity : 1;
    VOS_UINT32                          bitSpare        : 26;

    MMC_LMM_ATTACH_RSLT_ENUM_UINT32     ulAttachRslt;
    MMC_LMM_ATTACH_TYPE_ENUM_UINT32     ulReqType;
    MMC_LMM_ATTACH_CN_RSLT_ENUM_UINT32  ulCnRslt;

    /* ·ԭֵ*/
    NAS_LMM_CN_CAUSE_ENUM_UINT8         ucCnCause;
    VOS_UINT8                           aucRsv[3];

    /* ATTACHԴ */
    VOS_UINT32                          ulAttemptCount;

    /*ЧPLMN LIST, CNϢеEPLMN */
    MMC_LMM_EPLMN_STRU                  stEplmnList;
    MMC_LMM_LAI_STRU                    stLai;
    MMC_LMM_MS_IDNETITY_STRU            stMsIdentity;

}LMM_MMC_ATTACH_IND_STRU;


/*****************************************************************************
 ṹ: MMC_LMM_DETACH_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:MMC_LMM_DETACH_REQ_STRUṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_MO_DETACH_TYPE_ENUM_UINT32  ulDetachType;
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    MMC_LMM_DETACH_RESEAON_ENUM_UINT32  ulDetachReason;
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/
}MMC_LMM_DETACH_REQ_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_DETACH_CNF_STRU
 Э:
 ASN.1 :
 ṹ˵:LMM_MMC_DETACH_CNF_STRUṹ,ATTACHյMMC͵DETACH REQϢ
 LMM ͨϢӦٷLMM_MMC_ATTACH_CNFLMM_MMC_ATTACH_INDϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /*UEDETACHӦ*/
    MMC_LMM_DETACH_RSLT_ENUM_UINT32     ulDetachRslt;

    /*UEDETACH*/
    MMC_LMM_MO_DETACH_TYPE_ENUM_UINT32  ulReqType;

}LMM_MMC_DETACH_CNF_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_DETACH_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:LMM_MMC_DETACH_IND_STRUṹ,ATTACHյCN͵MT DETACHϢ
 LMM ͨϢӦٷLMM_MMC_ATTACH_CNFLMM_MMC_ATTACH_INDϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpCnReqType  : 1;
    VOS_UINT32                          bitOpCnCause    : 1;
    VOS_UINT32                          bitOpLocDetType : 1;
    VOS_UINT32                          bitSpare        : 29;

    /*DETACHӦ:ഥDETACH򱾵DETACH*/
    MMC_LMM_DETACH_TYPE_ENUM_UINT32     ulDetachType;

    /* DETACH */
    MMC_LMM_L_LOCAL_DETACH_TYPE_ENUM_UINT32 ulLocDetType;
    /*ഥDETACH*/
    MMC_LMM_MT_DETACH_TYPE_ENUM_UINT32  ulCnReqType;/*ӿĵ˵*/

    /* ·ԭֵ*/
    NAS_LMM_CN_CAUSE_ENUM_UINT8         ucCnCause;
    VOS_UINT8                           aucRsv[3];


}LMM_MMC_DETACH_IND_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_CELL_SELECTION_CTRL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_CELL_SELECTION_CTRL_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_CELL_SEL_TYPE_ENUM_UINT32   ulSelecType;

} MMC_LMM_CELL_SELECTION_CTRL_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_TAU_RESULT_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_TAU_RESULT_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpCnCause    : 1;
    VOS_UINT32                          bitOpAtmpCnt    : 1;
    VOS_UINT32                          bitOpEplmn      : 1;
    VOS_UINT32                          bitOpLai        : 1;
    VOS_UINT32                          bitOpMsIdentity : 1;
    VOS_UINT32                          bitOpCnRst      : 1;
    VOS_UINT32                          bitOpEpsUpdateStuts : 1;
    VOS_UINT32                          bitOpTaiInListFlag  : 1;
    VOS_UINT32                          bitSpare        : 24;


    /* TAUӦ*/
    MMC_LMM_TAU_RSLT_ENUM_UINT32        ulTauRst;

    /* TAUҵʱ*/
    MMC_LMM_TAU_TYPE_ENUM_UINT32        ulReqType;

    /*ӦTAU*/
    MMC_LMM_TAU_CN_RSLT_ENUM_UINT32     ulCnRst;

    /* ·ԭֵ*/
    NAS_LMM_CN_CAUSE_ENUM_UINT8         ucCnCause;
    VOS_UINT8                           aucRsv1[3];

    /* TAUʧܴ */
    VOS_UINT32                          ulAttemptCount;

    /*ĵЧPLMN LIST */
    MMC_LMM_EPLMN_STRU                  stEplmnList;
    MMC_LMM_LAI_STRU                    stLai;

    MMC_LMM_MS_IDNETITY_STRU            stMsIdentity;

    /* EPS UPDATE STATUS */
    MMC_LMM_EPS_UPDATE_STATUS_ENUM_UINT8 enEmmUpStat;

    /* ʶTAIǷTAI LIST */
    MMC_LMM_TAI_IN_LIST_FLAG_ENUM_UINT8 enTaiInListFlag;

    VOS_UINT8                           aucReserved[2];
} LMM_MMC_TAU_RESULT_IND_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_SERVICE_RESULT_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_SERVICE_RESULT_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpReqType    : 1;
    VOS_UINT32                          bitOpCnCause    : 1;
    VOS_UINT32                          bitSpare        : 30;


    /* SERVICEӦ:ܾ*/
    MMC_LMM_SERVICE_RSLT_ENUM_UINT32    ulServiceRst;

    /* ʱʹãCSFBʱʹ*/
    MMC_LMM_SERVICE_TYPE_ENUM_UINT32    ulReqType;

    /* ·ԭֵ*/
    NAS_LMM_CN_CAUSE_ENUM_UINT8         ucCnCause;
    VOS_UINT8                           aucRsv1[3];

} LMM_MMC_SERVICE_RESULT_IND_STRU;

/* Modified by z00161729 for svlte support ncell search, 2013-12-16, begin */
/*******************************************************************************
 ṹ    : MMC_LMM_NCELL_INFO_STRU
 ṹ˵  : GSMLTEƵб

 1.       : 20131216
          : z00161729
   ޸   : ɽṹ

*******************************************************************************/
typedef struct
{
    VOS_UINT8                           ucLteArfcnNum;                          /* 0ʾLTEƵ㲻 */
    VOS_UINT8                           aucRsv[3];                              /* λ */
    VOS_UINT16                          ausLteArfcnList[MMC_LMM_LTE_ARFCN_MAX_NUM];
    MMC_LMM_EPLMN_STRU                  stEplmnList;                            /* صЧplmnϢ*/

    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    VOS_UINT8                           ucLteCellIdNum;                         /* 0ʾLTEСID */
    VOS_UINT8                           aucRsv1[3];                              /* λ */
    VOS_UINT16                          ausLteCellIdList[MMC_LMM_LTE_CELL_ID_MAX_NUM];
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 end*/
}MMC_LMM_NCELL_INFO_STRU;
/* Modified by z00161729 for svlte support ncell search, 2013-12-16, end */

/*****************************************************************************
 ṹ    : MMC_LMM_PLMN_SRCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_PLMN_SRCH_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpSpecPlmn: 1;
    VOS_UINT32                          bitOpEqlPlmn : 1;

    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, begin */
    VOS_UINT32                          bitOpNcellInfo : 1;
    VOS_UINT32                          bitSpare     : 29;
    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, end */

    /*  */
    MMC_LMM_PLMN_SRCH_TYPE_ENUM_UINT32  enSrchType;

    /* ָPLMN ID */
    MMC_LMM_PLMN_ID_STRU                stSpecPlmnId;

    /* ЧPLMN LIST */
    MMC_LMM_EPLMN_STRU                  stEplmnList;                            /* ǰפЧplmn */

    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, begin */
    MMC_LMM_NCELL_INFO_STRU             stNcellInfo;
    /* Modified by z00161729 for svlte support ncell search, 2013-12-16, end */
}MMC_LMM_PLMN_SRCH_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_PLMN_SRCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_PLMN_SRCH_CNF_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /*  */
    MMC_LMM_PLMN_SRCH_RLT_ENUM_UINT32   enRlst;

    /* ǰ뼼µ縲 */
    MMC_LMM_COVERAGE_TYPE_ENUM_UINT32   enCoverageType;
    /* ָPLMNɹʱ,ѵPLMN ID,enRsltΪָɹʱЧ */
    MMC_LMM_SUIT_PLMN_ID_LIST_STRU      stSpecPlmnIdList;

    /* ¼Lģ±ѾĽ뼼бʱЧ */
    MMC_LMM_LIST_SEARCH_RAT_INFO_STRU   astSearchRatInfo[MMC_LMM_MAX_RAT_NUM];

    /* LIST PLMNʱ,spec plmnʧʱЧ */
    MMC_LMM_PLMN_ID_LIST_STRU           stPlmnIdList;
} LMM_MMC_PLMN_SRCH_CNF_STRU;


/*****************************************************************************
ṹ    : MMC_LMM_STOP_PLMN_SRCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} MMC_LMM_STOP_PLMN_SRCH_REQ_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_STOP_PLMN_SRCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_STOP_PLMN_SRCH_CNF_STRU ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_STOP_PLMN_SRCH_CNF_STRU;


/*****************************************************************************
 ṹ    : MMC_LMM_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_BG_PLMN_SEARCH_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ָPLMN ID뼼 */
    MMC_LMM_PLMN_ID_WITH_RAT_STRU       stSpecPlmnWithRat;

    /* ֹעĸ,LTEʱЧ */
    VOS_UINT32                          ulForbRoamLaiNum;

    /* ֹLAIϢ,LTEʱЧ */
    MMC_LMM_LAI_STRU                    astForbRoamLaiList[MMC_LMM_MAX_FORB_ROAM_LAI_NUM];

}MMC_LMM_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_BG_PLMN_SEARCH_CNF_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /*  */
    MMC_LMM_BG_SRCH_RLT_ENUM_UINT32     enRlst;

    /* spec plmnʧʱЧ */
    VOS_UINT32                          ulPlmnNum;
    MMC_LMM_PLMN_ID_WITH_RAT_STRU       astPlmnIdWithRatList[MMC_LMM_MAX_BG_SRCH_PLMN_NUM];

} LMM_MMC_BG_PLMN_SEARCH_CNF_STRU;


/*****************************************************************************
ṹ    : MMC_LMM_STOP_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  :MMC_LMM_STOP_BG_PLMN_SEARCH_REQ_STRU
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} MMC_LMM_STOP_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_STOP_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_STOP_BG_PLMN_SEARCH_CNF_STRU ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_STOP_BG_PLMN_SEARCH_CNF_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_NOT_CAMP_ON_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_NOT_CAMP_ON_IND_STRU ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_NOT_CAMP_ON_IND_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_EPLMN_NOTIFY_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
        MMCֻԭMMC_LMM_EPLMN_NOTIFY_REQ֪ͨLMM
        1յLMMϵͳϢ
        2LMMEPLMN
        3ϵͳ任УGUĿϵͳΪLTEʱ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* EPLMNĸ,RPLMN */
    VOS_UINT32                          ulEplmnNum;

    /* EPLMN LISTܸµĳ:
       עɹʱ: а·EPLMN LIST͸
                        עɹRPLMNΪaEplmnListһЧPLMNID
       עʧʱ: 1) ɾEPLMNббֻǰפ磬ulEplmnNumΪ1
                       2) ǰעPLMN EPLMNLIST
                       ұ԰ղŵRPLMN
                       ղŵRPLMN */
    MMC_LMM_PLMN_ID_STRU                astEplmnList[MMC_LMM_MAX_EQUPLMN_NUM];

} MMC_LMM_EPLMN_NOTIFY_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_AREA_LOST_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_AREA_LOST_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /*ϱPLMN IDб*/
    MMC_LMM_PLMN_ID_LIST_STRU           stPlmnIdList;
} LMM_MMC_AREA_LOST_IND_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_SYS_INFO_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ǰСϵͳϢ: PLMN_LIST, TAC, CELLID, С״̬ */
    MMC_LMM_SYS_INFO_STRU               stLteSysInfo;

} LMM_MMC_SYS_INFO_IND_STRU;

/*****************************************************************************
 ṹ: MMC_EMM_INFO_UT_LTZ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_UINT8                             ucYear;
    VOS_UINT8                             ucMonth;
    VOS_UINT8                             ucDay;
    VOS_UINT8                             ucHour;
    VOS_UINT8                             ucMinute;
    VOS_UINT8                             ucSecond;
    VOS_INT8                              cTimeZone;
    VOS_UINT8                             aucRsv[1];
} MMC_EMM_INFO_UT_LTZ_STRU;

/*****************************************************************************
 ṹ: MMC_EMM_INFO_DST_ENUM
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
enum MMC_EMM_INFO_DST_ENUM
{
    MMC_EMM_INFO_DST_NO_ADJUST                         = 0,
    MMC_EMM_INFO_DST_1_HOUR_ADJUST                        ,
    MMC_EMM_INFO_DST_2_HOUR_ADJUST                        ,
    MMC_EMM_INFO_DST_BUTT
};
typedef VOS_UINT8  MMC_EMM_INFO_DST_UINT8;

/*****************************************************************************
 ṹ: MMC_EMM_INFO_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_UINT32                            bitOpLocTimeZone           :1; /* 1: VALID; 0: INVALID*/
    VOS_UINT32                            bitOpUniTimeLocTimeZone    :1; /* 1: VALID; 0: INVALID*/
    VOS_UINT32                            bitOpDaylightTime          :1; /* 1: VALID; 0: INVALID*/
    VOS_UINT32                            bitOpLongName              :1;
    VOS_UINT32                            bitOpShortName             :1;
    VOS_UINT32                            bitReserved                :27;

    VOS_INT8                              cLocTimeZone;
    MMC_EMM_INFO_UT_LTZ_STRU              stTimeZoneAndTime;
    MMC_EMM_INFO_DST_UINT8                enDaylightSavingTime;
    VOS_UINT8                             aucOperatorNameLong[MMC_LMM_MAX_OPER_LONG_NAME_LEN];
    VOS_UINT8                             aucOperatorNameShort[MMC_LMM_MAX_OPER_SHORT_NAME_LEN];

    VOS_UINT8                             aucRsv[2];
} MMC_EMM_INFO_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_EMM_INFO_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* LTE EMM Informationݽṹ */
    MMC_EMM_INFO_STRU                   stLteEmmInfo;

} LMM_MMC_EMM_INFO_IND_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_ACTION_RESULT_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_ACTION_RESULT_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpReqDomain          : 1;
    VOS_UINT32                          bitOpRstDomain          : 1;
    VOS_UINT32                          bitOpMtDetachType       : 1;
    VOS_UINT32                          bitOpLocalDetachType    : 1;
    VOS_UINT32                          bitOpMoDetachType       : 1;
    VOS_UINT32                          bitOpCnCause            : 1;
    VOS_UINT32                          bitOpGprsUpdateStatus   : 1;
    VOS_UINT32                          bitOpRaiChangFlg        : 1;
    VOS_UINT32                          bitOpAtmpCnt            : 1;
    VOS_UINT32                          bitOpCsUpdateStatus     : 1;
    VOS_UINT32                          bitOpLaiChangFlg        : 1;
    VOS_UINT32                          bitSpare                : 21;


    /* */
    MMC_LMM_ACTION_TYPE_ENUM_UINT32     enActionType;

    /* CN_ACCEPT, CN_REJECTӦĽ */
    MMC_LMM_RSLT_TYPE_ENUM_UINT32       ulActRst;


    /* ҵʱ:ATTACH, RAU, DETACHʱЧ */
    MMC_LMM_DOMAIN_ENUM_UINT32          ulReqDomain;

    /* ͣATTACH, TAU, DETACHʱЧӦĽ */
    MMC_LMM_DOMAIN_ENUM_UINT32          ulRstDomain;

    /*   MT DETACHʱЧ */
    MMC_LMM_MT_DETACH_TYPE_ENUM_UINT32  ulMtDetachType;


    /* local detachͣdetachʱЧ */
    MMC_LMM_GU_LOCAL_DETACH_TYPE_ENUM_UINT32   ulLocalDetachType;

    /* UEdetach */
    MMC_LMM_MO_DETACH_TYPE_ENUM_UINT32  ulMoDetachType;


    /* ·ԭ */
    NAS_LMM_CN_CAUSE_ENUM_UINT8         ucCnCause;

    /* GPRS update status */
    MMC_LMM_GPRS_UPDATE_STATUS_ENUM_UINT8 ucGprsUpdateStatus;

    /* RAI Ƿı */
    VOS_UINT8                           ucRaiChangFlg;

    /* MM update status */
    MMC_LMM_CS_UPDATE_STATUS_ENUM_UINT8    ucCsUpdateStatus;

    /* LAI Ƿı */
    VOS_UINT8                           ucLaiChangFlg;

    VOS_UINT8                           aucRsv[3];

    /* ATTACHRAUʧܳԴ */
    VOS_UINT32                          ulAttemptCount;

} MMC_LMM_ACTION_RESULT_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_ERR_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_ERR_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];

} LMM_MMC_ERR_IND_STRU;



/*****************************************************************************
 ṹ    : MMC_LMM_REL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_REL_REQ_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
}MMC_LMM_REL_REQ_STRU;


/*****************************************************************************
 ṹ    : LMM_MMC_SERVICE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LMM_MMC_SERVICE_IND_STRUݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_EPS_SERVICE_IND_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_SUSPEND_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:LMM->MMC
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_SYS_CHNG_DIR_ENUM_UINT32    ulSysChngDir;                           /* ϵͳ */
    MMC_LMM_SYS_CHNG_TYPE_ENUM_UINT32   ulSysChngType;                          /* ϵͳ */

} LMM_MMC_SUSPEND_IND_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_DEACT_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
} MMC_LMM_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_RESUME_NOTIFY_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
} MMC_LMM_RESUME_NOTIFY_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_SUSPEND_RSP_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ִн*/
    MMC_LMM_RESULT_ID_ENUM_UINT32          ulRst;

} MMC_LMM_SUSPEND_RSP_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_SUSPEND_CNF_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;               /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ִн*/
    MMC_LMM_RESULT_ID_ENUM_UINT32          ulRst;

} LMM_MMC_SUSPEND_CNF_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_RESUME_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_RESUME_IND_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_STATUS_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpConnState  : 1;
    VOS_UINT32                          bitSpare        : 31;

    /* ״̬ */
    MMC_LMM_STATUS_TYPE_ENUM_UINT32     ulStatusType;
    MMC_LMM_CONN_STATE_ENUM_UINT32      ulConnState;

} LMM_MMC_STATUS_IND_STRU;



/*****************************************************************************
 ṹ: MMC_LMM_SYS_CFG_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ȻATȻͬʱRATBAND˴bitopȻͬʱ1 */
    VOS_UINT32                          bitOpRat:1;
    VOS_UINT32                          bitOpBand:1;
    VOS_UINT32                          bitSpare:30;

    NAS_RRC_USER_SET_FREQ_BAND_STRU     stBand;                                 /* Ƶ */
    RRMM_RAT_PRIO_ENUM_UINT8            aucRatPrioList[RRMM_RAT_TYPE_BUTT];     /* ģȼ */

    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
    VOS_UINT8                           aucReserved[3];                         /* ֽڶ */
    /*Modify by sunbing 49683 for CL multimode 2014-01-09 begin*/
} MMC_LMM_SYS_CFG_REQ_STRU;



/*****************************************************************************
 ṹ    :  MMC_LMM_SYS_CFG_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_RESULT_ID_ENUM_UINT32          ulRst;
}LMM_MMC_SYS_CFG_CNF_STRU;


/*****************************************************************************
 ṹ: MMC_LMM_USIM_STATUS_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_USIM_STATUS_ENUM_UINT32     ulUsimState;

} MMC_LMM_USIM_STATUS_REQ_STRU;


/*****************************************************************************
 ṹ: LMM_MMC_USIM_STATUS_CNF_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];

} LMM_MMC_USIM_STATUS_CNF_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_TIN_TYPE_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
    MMC_LMM_TIN_TYPE_ENUM_UINT32        ulTinType;
} LMM_MMC_TIN_TYPE_IND_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_SERVICE_STATUS_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:  ״̬ϱϢṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT32                          bitOpPsStatus   : 1;
    VOS_UINT32                          bitOpCsStatus   : 1;
    VOS_UINT32                          bitSpare        : 30;

    MMC_LMM_SERVICE_STATUS_ENUM_UINT32  ulServiceStatus;    /* PS״̬ */
    MMC_LMM_SERVICE_STATUS_ENUM_UINT32  ulCsServiceStatus;  /* CS״̬ */
    MMC_LMM_SYS_MODE_ENUM_UINT32        ulSysMode;
} LMM_MMC_SERVICE_STATUS_IND_STRU;

/*****************************************************************************
 ṹ: LMM_MMC_REGISTER_STATUS_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:  ע״̬ϱϢṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;


    VOS_UINT32                          bitOpRegisterStatus :1;
    VOS_UINT32                          bitOpLocationInfo   :1;
    VOS_UINT32                          bitSpare            :30;
    MMC_LMM_REGISTER_STATUS_ENUM_UINT32 ulRegisterStatus;
    NAS_LMM_TAC_STRU                    stTac;
    VOS_UINT32                          ulCellId;           /* Cell Identity */
} LMM_MMC_REGISTER_STATUS_IND_STRU;

/*****************************************************************************
 ṹ: MMC_LMM_USER_PLMN_END_NOTIFY_STRU
 Э:
 ASN.1 :
 ṹ˵:  ע״̬ϱϢṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} MMC_LMM_USER_PLMN_END_NOTIFY_STRU;

#if (FEATURE_ON == MBB_T3402_TIMER_CTL)
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
    VOS_UINT32                          bitOpT3412  :1;
    VOS_UINT32                          bitOpT3423  :1;
    VOS_UINT32                          bitOpT3402  :1;
    VOS_UINT32                          bitOpRsv    : 29;

    LMM_MMC_TIMER_STATE_ENUM_UINT32     enT3412State;
    LMM_MMC_TIMER_STATE_ENUM_UINT32     enT3423State;
    LMM_MMC_TIMER_STATE_ENUM_UINT32     enT3402State;   
}LMM_MMC_TIMER_STATE_NOTIFY_STRU;
#else
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
    VOS_UINT32                          bitOpT3412  :1;
    VOS_UINT32                          bitOpT3423  :1;
    VOS_UINT32                          bitOpRsv    : 30;

    LMM_MMC_TIMER_STATE_ENUM_UINT32     enT3412State;
    LMM_MMC_TIMER_STATE_ENUM_UINT32     enT3423State;
}LMM_MMC_TIMER_STATE_NOTIFY_STRU;
#endif /*MBB_T3402_TIMER_CTL*/

/*****************************************************************************
 ṹ: MMC_LMM_UE_OOC_STATUS_NOTIFY_STRU
 Э:
 ASN.1 :
 ṹ˵:  MMCͨϢ֪ͨLMM
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;
}MMC_LMM_UE_OOC_STATUS_NOTIFY_STRU;

/*****************************************************************************
 ṹ: NAS_GUMM_INFO_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    union
    {
        NAS_GUMM_PTMSI_STRU             stPtmsi;
        NAS_GUMM_PTMSI_SIGNATURE_STRU   stPtmsiSignature;
        NAS_GUMM_UMTS_CONTEXT_STRU      stSecuContext;
        MMC_LMM_LAI_STRU                stLai;
        MMC_LMM_RAI_STRU                stRAI;
        MMC_LMM_TMSI_STATUS_TYPE_ENUM_UINT32             ulTmsiStatus;
    }u;

} NAS_GUMM_INFO_STRU;


/****************************************************************************
 ṹ: NAS_LMM_INFO_STRU
 Э:
 ASN.1 :
 ṹ˵:
 *****************************************************************************/
typedef struct
{
    union
    {
        NAS_LMM_GUTI_STRU               stGuti;
        MMC_LMM_PLMN_ID_STRU            stPlmn;
        NAS_LMM_TAI_LIST_STRU           stForbRoamTaiList;
/* s00193151 add for DTS2014021904103 2014-02-19 */
        NAS_LMM_TAI_LIST_STRU           stForbRposTaiList;
/* s00193151 add for DTS2014021904103 2014-02-19 */
        MMC_LMM_PLMN_LIST_STRU          stCsDomainUnAvailPlmnList;
    }u;

} NAS_LMM_INFO_STRU;




/*****************************************************************************
 ṹ: MMC_LMM_PUB_INFO_STRU
 ????:
 ASN.1??:
 ????:
*****************************************************************************/
typedef struct
{
    union
    {
        MMC_LMM_TIN_TYPE_ENUM_UINT32    ulTinType;
        MMC_LMM_EPLMN_STRU              stEplmnList;
        MMC_LMM_PLMN_ID_STRU            stHplmn;
        MMC_LMM_PLMN_LIST_STRU          stForbiddenPlmnList;
        MMC_LMM_PLMN_LIST_STRU          stForbiddenPlmnListForGPRS;
        MMC_LMM_PLMN_LIST_STRU          stEHplmnList;
    }u;

} MMC_LMM_PUB_INFO_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_DISABLE_LTE_NOTIFY_STRU
 ṹ˵  : ֪ͨL disable LTE
  1.       : 2011117
           : z00161729
    ޸   : ½
 *****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32                ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                                ulOpId;
    MMC_LMM_DISABLE_LTE_REASON_ENUM_UINT32    enDisableLteReason;
} MMC_LMM_DISABLE_LTE_NOTIFY_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_ENABLE_LTE_NOTIFY_STRU
 ṹ˵  : ֪ͨL enable LTE
  1.       : 2011117
           : z00161729
    ޸   : ½
 *****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32                ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                                ulOpId;
} MMC_LMM_ENABLE_LTE_NOTIFY_STRU;
/*****************************************************************************
 ṹ    : MMC_LMM_SUSPEND_REL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MMC_LMM_SUSPEND_REL_REQ_STRU ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} MMC_LMM_SUSPEND_REL_REQ_STRU;

/* Modified by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, begin */
/*****************************************************************************
 ṹ    : MMC_LMM_UTRAN_MODE_REQ_STRU
 ṹ˵  : UTRANĹģʽϢ
 1.       : 2012714
          : w00176964
   ޸   : ½

  2.       : 201288
           : w00167002
    ޸   : ӿ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                         /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;           /*_H2ASN_Skip*/
    MMC_LMM_UTRAN_MODE_ENUM_UINT8       enUtranMode;       /* UTRANĹģʽ*/
    VOS_UINT8                           aucRsv[3];
} MMC_LMM_UTRAN_MODE_REQ_STRU;

/*****************************************************************************
 ṹ    : MMC_UTRAN_MODE_CNF_STRU
 ṹ˵  : UTRANĹģʽظϢ
 1.       : 201288
          : w00167002
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
}LMM_MMC_UTRAN_MODE_CNF_STRU;

/* Modified by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, end */
/*****************************************************************************
 ṹ    : LMM_MMC_SUSPEND_REL_CNF_STRU
 ṹ˵  :
 1.       : 20121121
          : w00209181
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    VOS_UINT8                           aucRsv[4];
} LMM_MMC_SUSPEND_REL_CNF_STRU;



/* ADD BY H00234341 FOR DTS2013070302684 20130617 BEGIN */
/*****************************************************************************
 ö    : LMM_MMC_RAT_CHANGE_CAUSE_ENUM
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum LMM_MMC_SUSPEND_INFO_CHANGE_TYPE_ENUM
{
    LMM_MMC_SUSPEND_RAT_INFO_CHANGE   = 0,     /* CSFBضRATı*/
    LMM_MMC_SUSPEND_INFO_CHANGE_BUTT
};
typedef VOS_UINT32  LMM_MMC_SUSPEND_INFO_CHANGE_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : LMM_MMC_RAT_CHANGE_CAUSE_ENUM
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum LMM_MMC_RAT_CHANGE_TYPE_ENUM
{
    LMM_MMC_RAT_CHANGE_G2W   = 0,
    LMM_MMC_RAT_CHANGE_W2G   = 1,
    LMM_MMC_RAT_CHANGE_TYPE_BUTT
};
typedef VOS_UINT32  LMM_MMC_RAT_CHANGE_TYPE_ENUM_UINT32;


/*****************************************************************************
 ṹ   : LMM_MMC_RAT_CHANGE_IND_STRU
 Э   :
 ASN.1  :
 ṹ˵   : LMM_MMC_RAT_CHANGE_IND_STRU֪ͨLMMײĽ뼼仯
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;


    LMM_MMC_SUSPEND_INFO_CHANGE_TYPE_ENUM_UINT32  ulInfoType;/*Ϣ : CSFB_REDIR_RAT_CHANGE;*/
    LMM_MMC_RAT_CHANGE_TYPE_ENUM_UINT32 ulRatChangeType;/* ö٣ֵU2G, G2U*/
    VOS_UINT8                           aucRsv[4];      /* Ԥ */
}LMM_MMC_SUSPEND_INFO_CHANGE_NOTIFY_STRU;
/* ADD BY H00234341 FOR DTS2013070302684 20130617 END */

/*****************************************************************************
 ṹ    : MMC_LMM_WCDMA_SYS_INFO_IND_STRU
 ṹ˵  : ֪ͨL WCDMAϵͳϢ
  1.       : 2012615
           : n00181501
    ޸   : ½
 *****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32                ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                                bitOpRac   :1;
    VOS_UINT32                                bitSpare   :31;

    MMC_LMM_PLMN_ID_STRU                      stPlmnId;
    VOS_UINT32                                ulCellId;
    VOS_UINT16                                usLac;
    VOS_UINT8                                 ucRac;
    VOS_UINT8                                 ucRsv1;
} MMC_LMM_WCDMA_SYS_INFO_IND_STRU;

/*****************************************************************************
 ṹ    : MMC_LMM_GSM_SYS_INFO_IND_STRU
 ṹ˵  : ֪ͨL GSMϵͳϢ
  1.       : 2012615
           : n00181501
    ޸   : ½
 *****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32                ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                                bitOpRac   :1;
    VOS_UINT32                                bitSpare   :31;

    MMC_LMM_PLMN_ID_STRU                      stPlmnId;
    VOS_UINT32                                ulCellId;
    VOS_UINT16                                usLac;
    VOS_UINT8                                 ucRac;
    VOS_UINT8                                 ucRsv1;
} MMC_LMM_GSM_SYS_INFO_IND_STRU;

/* lihong00150010 ims begin */
/*****************************************************************************
 ṹ    : LMM_MMC_EMC_PDP_STATUS_NOTIFY_STRU
 ṹ˵  : ֪ͨMMCص״̬
  1.       : 20131203
           : lihong00150010
    ޸   : ½
 *****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32                ulMsgId;            /*_H2ASN_Skip*/

    VOS_UINT8                                 ucIsEmcPdpActive;   /* VOS_TRUE:ʾؼVOS_FALSE:ʾδ */
    VOS_UINT8                                 aucRsv[3];
} LMM_MMC_EMC_PDP_STATUS_NOTIFY_STRU;
/* lihong00150010 ims end */

/* Added by w00176964 for DTS2012121906946, 2012-12-20, begin */
/*****************************************************************************
 ṹ: MMC_LMM_LTE_SYS_INFO_IND_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    /* ǰСϵͳϢ: PLMN_LIST, TAC, CELLID, С״̬ */
    MMC_LMM_SYS_INFO_STRU               stLteSysInfo;

} MMC_LMM_LTE_SYS_INFO_IND_STRU;
/* Added by w00176964 for DTS2012121906946, 2012-12-20, end */

/*Added by l00253982 for send modem info from mmc to lmm start*/
/*****************************************************************************
 ṹ: MMC_LMM_OTHER_MODEM_INFO_NOTIFY_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    MMC_LMM_MSG_ID_ENUM_UINT32  ulMsgId;
    VOS_UINT32                  bitOpCurrCampPlmnId:1;
    VOS_UINT32                  bitSpare:31;
    MMC_LMM_PLMN_ID_STRU        stCurrCampPlmnId;
}MMC_LMM_OTHER_MODEM_INFO_NOTIFY_STRU;
/*Added by l00253982 for send modem info from mmc to lmm end*/

/* Added by l00132387 for IMS-3, 2013-12-13, begin */
/*****************************************************************************
 ṹ: MMC_LMM_IMS_VOICE_CAP_NOTIFY_REQ_STRU
 Э:
 ASN.1 :
 ṹ˵:
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                          /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                          ulOpId;

    MMC_LMM_IMS_VOICE_CAP_ENUM_UINT8    enImsVoiceCap;
    VOS_UINT8                           aucRsv[3];
} MMC_LMM_IMS_VOICE_CAP_CHANGE_NOTIFY_STRU;

/* Added by l00132387 for IMS-3, 2013-12-13, end */

/* x00253310 modify for DTS2014052103463 2014-5-28 begin */
/*****************************************************************************
 ṹ    : LMM_MMC_EMERGENCY_NUM_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucCategory;
    VOS_UINT8                           ucEmcNumLen;    /*볤ȣaucEmcNumЧ*/
    VOS_UINT8                           aucEmcNum[LMM_MMC_EMERGENCY_NUM_MAX_LEN];
} LMM_MMC_EMERGENCY_NUM_STRU;

/*****************************************************************************
 ṹ    : LMM_MMC_INFO_CHANGE_NOTIFY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                              /*_H2ASN_Skip*/
    MMC_LMM_MSG_ID_ENUM_UINT32              ulMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                              ulOpId;
    /* leixiantiao 00258641 DTS2014061300419 begin */
    /*VOS_UINT32                              bitOpEmcNumList : 1;
    VOS_UINT32                              bitOpImsVoPS    : 1;
    VOS_UINT32                              bitOpEmcBS      : 1;
    VOS_UINT32                              bitOpLteCsCap   : 1;
    VOS_UINT32                              bitSpare        : 29;*/
    /* leixiantiao 00258641 DTS2014061300419 end */

    VOS_UINT8                               ucEmergencyNumAmount;
    VOS_UINT8                               aucReserved[3];
    LMM_MMC_EMERGENCY_NUM_STRU              astEmergencyNumList[LMM_MMC_EMERGENCY_NUM_LIST_MAX_RECORDS];

    LMM_MMC_NW_IMS_VOICE_ENUM_UINT32        enNwImsVoPS;
    LMM_MMC_NW_EMC_BS_ENUM_UINT32           enNwEmcBS;
    LMM_MMC_LTE_CS_CAPBILITY_ENUM_UINT32    enLteCsCap ;
} LMM_MMC_INFO_CHANGE_NOTIFY_STRU;
/* x00253310 modify for DTS2014052103463 2014-5-28 end */


/*****************************************************************************
 : Nas_GetGuInfo
 Э:
 ASN.1 :
 ˵:
*****************************************************************************/
extern MMC_LMM_RESULT_ID_ENUM_UINT32  Nas_GetGuInfo
(
    NAS_GUMM_INFO_TYPE_ENUM_UINT32  ulInfoType,
    NAS_GUMM_INFO_STRU *            pstGuInfo
);



/*****************************************************************************
 : Nas_GetLteInfo
 Э:
 ASN.1 :
 ˵:
*****************************************************************************/

extern MMC_LMM_RESULT_ID_ENUM_UINT32  Nas_GetLteInfo
(
    NAS_LMM_INFO_TYPE_ENUM_UINT32  ulInfoType,
    NAS_LMM_INFO_STRU             *pstLmmInfo
);

/*****************************************************************************
 : Nas_GetPubInfo
 Э:
 ASN.1 :
 ˵:
*****************************************************************************/
extern MMC_LMM_RESULT_ID_ENUM_UINT32 Nas_GetPubInfo
(
    MMC_LMM_INFO_TYPE_ENUM_UINT32    ulInfoType,
    MMC_LMM_PUB_INFO_STRU           *pPubInfo
);


/*****************************************************************************
 : Nas_PlmnIdIsForbid
 ˵:
*****************************************************************************/
MMC_LMM_PLMN_CTRL_ENUM_UINT32  Nas_PlmnIdIsForbid
(
    MMC_LMM_PLMN_ID_STRU     *pstPlmn
);


/*****************************************************************************
 : NAS_MM_PidInit
 ˵: LMM PIDʼMM FIDʼʱ
*****************************************************************************/
VOS_UINT32  NAS_MM_PidInit (    enum VOS_INIT_PHASE_DEFINE ip );

/*****************************************************************************
 : NAS_MM_PidMsgEntry
 ˵: LMMϢںMM FIDʼʱ
*****************************************************************************/
extern void        NAS_MM_PidMsgEntry( MsgBlock *pMsg);

/*****************************************************************************
 : LTE_MsgHook
 ˵: LTEϢȡ
*****************************************************************************/
extern VOS_UINT32 LTE_MsgHook( VOS_VOID *pMsg );

/*****************************************************************************
 : Nas_GetEutraUeCap
 Э:
 ASN.1 :
 ˵:
*****************************************************************************/
extern MMC_LMM_RESULT_ID_ENUM_UINT32  Nas_GetEutraUeCap
(
    MMC_LMM_PLMN_ID_STRU stPlmnId,
    VOS_UINT16 *pusEUeCapDataLen,
    VOS_UINT8 *pucEUeCapData
);

typedef struct
{
    MMC_LMM_MSG_ID_ENUM_UINT32          ulMsgId;            /*_H2ASN_MsgChoice_Export MMC_LMM_MSG_ID_ENUM_UINT32*/
    VOS_UINT8                           aucMsg[4];
    /***************************************************************************
        _H2ASN_MsgChoice_When_Comment          MMC_LMM_MSG_ID_ENUM_UINT32
    ****************************************************************************/
}MMC_LMM_INTERFACE_MSG_DATA;
/*_H2ASN_Length UINT32*/


typedef struct
{
    VOS_MSG_HEADER
    MMC_LMM_INTERFACE_MSG_DATA           stMsgData;
} MmcLmmInterface_MSG;







/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/

/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/




/*****************************************************************************
  9 OTHERS
*****************************************************************************/










#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif



#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of MmcLmmInterface.h */

















