/******************************************************************************

    Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : LrrcErrLogInterface.h
  Description     : LrrcErrLogInterface.h header file
  History         :
     1.HANLUFENG 41410       2013-8-27     Draft Enact
     2.
******************************************************************************/

#ifndef __LRRCERRLOGINTERFACE_H__
#define __LRRCERRLOGINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include  "vos.h"


#include "omerrorlog.h"
#include "AppRrcInterface.h"


#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif


/*****************************************************************************
  2 macro
*****************************************************************************/

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/
/* LTE֧CA£ֵ֧ƵV9R1Ϊ1V7R2K3V3Ϊ2Э涨ֵΪ5 */
#define LRRC_APP_MAX_NUM 5

/* RRC errorʱRRCĽϢ¼ԭͽ */
#define RRC_APP_MAX_RRC_EST_INFO_NUM              (5)

/* Эֵ:3 */
#define RRC_APP_MAX_NUM_OF_MCC                    (3)

/* RRC errorʱӡϢ¼ */
#define RRC_APP_ERROR_PRINT_INFO_NUM              (4)

/* RRC errorʱģϢ¼ */
#define RRC_APP_RECEIVE_MSG_INFO_NUM              (16)

/* RRC errorʱRRC¼ */
#define RRC_APP_CODE_NUM                          (4)

/* LTE֧MIMOʱͬʱֵ֧ */
#define NUM_OF_CODEWORD                           (2)

/*****************************************************************************
  4 Enum
*****************************************************************************/
 enum RRC_APP_FTM_TYPE_ENUM
 {
    RRC_APP_FTM_PERIOD_INFO,     /* ϱĹģʽϢĿǰIdle״̬ϱΪDRXڣConnected״̬Ϊ1 */
    RRC_APP_FTM_CHANGE_INFO,     /* ºϱ͵ĹģʽϢ */
    RRC_APP_FTM_INFO_BUTT
 };
 typedef VOS_UINT32 RRC_APP_FTM_TYPE_ENUM_UINT32;

/*****************************************************************************
 ö    : RRC_APP_PAGING_CYCLE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ѰڣRFXXXXʾ֡λΪ10ms,RF32320msʾΪXXXms
*****************************************************************************/
enum RRC_APP_PAGING_CYCLE_ENUM
{
    RRC_APP_RF32                                     = 0,
    RRC_APP_RF64                                     = 1,
    RRC_APP_RF128                                    = 2,
    RRC_APP_RF256                                    = 3
};
typedef VOS_UINT32 RRC_APP_PAGING_CYCLE_ENUM_UINT32;
/*****************************************************************************
 ö    : RRC_APP_TRANSM_MODE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ģʽֱͣʾTMX_TRANSM_MODE
*****************************************************************************/
enum RRC_APP_TRANSM_MODE_ENUM
{
    RRC_APP_TM1_TRANSM_MODE                          = 0,
    RRC_APP_TM2_TRANSM_MODE                          = 1,
    RRC_APP_TM3_TRANSM_MODE                          = 2,
    RRC_APP_TM4_TRANSM_MODE                          = 3,
    RRC_APP_TM5_TRANSM_MODE                          = 4,
    RRC_APP_TM6_TRANSM_MODE                          = 5,
    RRC_APP_TM7_TRANSM_MODE                          = 6,
    RRC_APP_TM8_TRANSM_MODE                          = 7,
    RRC_APP_TM9_TRANSM_MODE                          = 8,
    RRC_APP_TRANSM_MODE_BUTT
};
typedef VOS_UINT32 RRC_APP_TRANSM_MODE_ENUM_UINT32;
/*****************************************************************************
 ö    : RRC_APP_PROTOCOL_STATE_IND
 Э  :
 ASN.1 :
 ö˵  : RRCЭ״̬
*****************************************************************************/
enum RRC_APP_PROTOCOL_STATE_IND_ENUM
{
    RRC_APP_PROTOCOL_IDLE                   = 0 ,
    RRC_APP_PROTOCOL_CONNECTED,
    RRC_APP_PROTOCOL_STATE_BUTT
};
typedef VOS_UINT8 RRC_APP_PROTOCOL_STATE_IND_ENUM_UINT8;

/*****************************************************************************
 ö    : RRC_APP_ERROR_CODE_ENUM
 Э  :
 ASN.1 :
 ö˵  : RRC
*****************************************************************************/
enum RRC_APP_ERROR_CODE_ENUM
{
    RRC_APP_RB_MEAS_CHECK_ERR               = 0, /* ʧ--measConfigʧ */
    RRC_APP_RB_MOCTRL_CHECK_ERR             = 1, /* ʧ--MobilCtrlInfo лϢʧ */
    RRC_APP_RB_RADIOSRC_CHECK_ERR           = 2, /* ʧ--RadioRsrcConfigDedic Ϣʧ */
    RRC_APP_RB_TTIBUNDING_CHECK_ERR         = 3, /* ʧ--TTIBundling ʧ */
    RRC_APP_RB_SECU_CHECK_ERR               = 4, /* ʧ--SecurCfgHo лаȫʧ */
    RRC_APP_RB_CFGDSP_ERR                   = 5, /* ʧ--DSPDSPʧ */
    RRC_APP_RB_CFGL2_ERR                    = 6, /* ʧ--L2,L2ʧ */
    RRC_APP_RB_CFGDSP_TIMEROUT_ERR          = 7, /* ʧ--DSPʱʱ */
    RRC_APP_RB_CFGL2_TIMEROUT_ERR           = 8, /* ʧ--L2ʱʱ */

    RRC_APP_EST_MT_T302_ERR                     = 18, /* RRCӽʧ--MT CallT302ʱ */

    RRC_APP_EST_MO_T302_ERR                     = 22, /* RRCӽʧ--Mo DataT302ʱ */
    RRC_APP_EST_MO_T303_ERR                     = 23, /* RRCӽʧ--Mo DataT303ʱ */
    RRC_APP_EST_MO_ACC_PROBABILITY_ERR          = 24, /* RRCӽʧ--Mo DataACCȼ */
    RRC_APP_EST_MO_RHPLMN_PROBABILITY_ERR       = 25, /* RRCӽʧ--Mo DataRplmnHplmn */
    RRC_APP_EST_MO_ACC_RHPLMN_PROBABILITY_ERR   = 26, /* RRCӽʧ--Mo DataAcBarringForMoDataжϱBar */

    RRC_APP_EST_MS_T302_ERR                     = 28, /* RRCӽʧ--Mo SignallingT302ʱ */
    RRC_APP_EST_MS_T305_ERR                     = 29, /* RRCӽʧ--Mo SignallingT305ʱ */
    RRC_APP_EST_MS_ACC_PROBABILITY_ERR          = 30, /* RRCӽʧ--Mo SignallingACCȼ */
    RRC_APP_EST_MS_RHPLMN_PROBABILITY_ERR       = 31, /* RRCӽʧ--Mo SignallingRplmnHplmn */
    RRC_APP_EST_MS_ACC_RHPLMN_PROBABILITY_ERR   = 32, /* Mo SignallingAcBarringForMoDataжϱBar */

    RRC_APP_EST_AREA_LOST_ERR                   = 34, /* ǰѾֱӸNASʧ */

    RRC_APP_REEST_T311_TIMEROUT_ERR             = 49, /* ؽʧ--ؽСT311ʱʱ */
    RRC_APP_REEST_T301_TIMEROUT_ERR             = 50, /* ؽʧ--ͽReqϢ󣬵ȴؽӦϢT301ʱ */
    RRC_APP_REEST_SRB0CFGDSP_ERR                = 51, /* ؽʧ--DSPDSPʧ */
    RRC_APP_REEST_SRB0CFGL2_ERR                 = 52, /* ؽʧ--L2L2ʧ */
    RRC_APP_REEST_MACCFG_CHECK_ERR              = 53, /* ؽʧ--ϢMasCfgʧ */
    RRC_APP_REEST_PHYDEDIC_CHECK_ERR            = 54, /* ؽʧ--ϢPhyCfgDedicʧ */
    RRC_APP_REEST_TTIBUND_CHECK_ERR             = 55, /* ؽʧ--ttiBundlingʧ */
    RRC_APP_REEST_SRB_CHECK_ERR                 = 56, /* ؽʧ--SRBʧܳʱ */
    RRC_APP_REEST_SPS_CHECK_ERR                 = 57, /* ؽʧ--SPSʧ */
    RRC_APP_REEST_SRB1CFGDSP_ERR                = 58, /* ؽʧ--DSPDSPʧ */
    RRC_APP_REEST_SRB1CFGL2_ERR                 = 59, /* ؽʧ--L2L2ʧ */
    RRC_APP_REEST_SECU_ERR                      = 60, /* ؽʧ--ȫʧ */

    RRC_APP_ERR_CODE_BUTT
};
typedef VOS_UINT16 RRC_APP_ERROR_CODE_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_LNAS_EST_CAUSE_ENUM
 Э  :
 ASN.1 :
 ö˵  : RRMM_EST_REQ_STRUϢеenEstCause
              emergency, highPriorityAccess, mt-Access, mo-Signalling, mo-Data,delayTolerantAccess-v1020 ,
*****************************************************************************/
enum LRRC_APP_LNAS_EST_CAUSE_ENUM
{
    LRRC_APP_LNAS_EST_CAUSE_EMERGENCY_CALL          = 0,
    LRRC_APP_LNAS_EST_CAUSE_HIGH_PRIORITY_ACCESS,
    LRRC_APP_LNAS_EST_CAUSE_MT_ACCESS,
    LRRC_APP_LNAS_EST_CAUSE_MO_SIGNALLING,
    LRRC_APP_LNAS_EST_CAUSE_MO_DATA,
    LRRC_APP_LNAS_EST_CAUSE_BUTT
};
typedef VOS_UINT8 LRRC_APP_LNAS_EST_CAUSE_ENUM_UINT8;

/*****************************************************************************
 ö    : LRRC_LNAS_EST_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : ӽö
*****************************************************************************/
enum LRRC_APP_LNAS_EST_RESULT_ENUM
{
    LRRC_APP_EST_SUCCESS                         = 0,       /* ӽɹ */
    LRRC_APP_EST_PRESENT                         = 1,       /* Ѿ */
    LRRC_APP_EST_ESTING                          = 2,       /* ڽ */
    LRRC_APP_EST_DELING                          = 3,       /* ͷ */
    LRRC_APP_EST_ACCESS_BARRED_MO_CALL           = 4,       /* access barred when MO Call */
    LRRC_APP_EST_ACCESS_BARRED_MO_SIGNAL         = 5,       /* access barred When MO SIGNAL */
    LRRC_APP_EST_ACCESS_BARRED_EMERGENCY_CALL    = 6,       /* access barred When Emergency Call */
    LRRC_APP_EST_ACCESS_BARRED_ALL               = 7,       /* access barred When Rrc Con Rej */
    LRRC_APP_EST_EST_CONN_FAIL                   = 8,       /* RR connection establish failure  */
    LRRC_APP_EST_RJ_INTER_RAT                    = 9,       /* RR connection Reject: ָʾϵͳ */
    LRRC_APP_EST_IMMEDIATE_ASSIGN_REJECT         = 10,      /* Ḷ̌RAյָɾܾϢ
                                                                ûյָϢµĽʧ */
    LRRC_APP_EST_RANDOM_ACCESS_REJECT            = 11,      /* Ḷ̌RAûյָɣ
                                                                Ҳûյָɾܾʧ */
    LRRC_APP_EST_CELL_SEARCHING                  = 12,      /* RRCĿǰܴNASյԭֵ
                                                                ֱյRRC_MM_SYS_INFO_INDٷ*/
    LRRC_APP_EST_RESULT_BUTT
};
typedef VOS_UINT8 LRRC_APP_LNAS_EST_RESULT_ENUM_UINT8;

/*****************************************************************************
 ö    : LRRC_FLOW_CTRL_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ̿ö
             ޸öʱҪע⣬ʧȡֵ = ȡֵ+1
 : LRRC_FLOW_CTRL_TYPE_G2L_RESEL_FAIL = LRRC_FLOW_CTRL_TYPE_G2L_START_RESEL + 1
*****************************************************************************/
enum LRRC_APP_FLOW_CTRL_TYPE_ENUM
{
    LRRC_APP_FLOW_CTRL_TYPE_L2L_NORMAL            = 0,     /* LTE */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_START_RESEL,               /* G->Lʼѡ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_RESEL_FAIL,                /* G->Lѡʧ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_STOP_RESEL,                /* G->Lֹͣѡ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_START_REDIR,               /* G->Lʼض */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_REDIR_FAIL,                /* G->Lضʧ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_STOP_REDIR,                /* G->Lֹͣض */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_START_CCO,                 /* G->LʼCCO */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_CCO_FAIL,                  /* G->L CCOʧ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_STOP_CCO,                  /* G->LֹͣCCO */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_START_HO,                  /* G->LʼHO */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_HO_FAIL,                   /* G->L HOʧ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_STOP_HO,                   /* G->LֹͣHO */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_START_RESEL,               /* W->Lʼѡ */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_RESEL_FAIL,                /* W->Lѡʧ */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_STOP_RESEL,                /* W->Lֹͣѡ */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_START_REDIR,               /* W->Lʼض */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_REDIR_FAIL,                /* W->Lضʧ */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_STOP_REDIR,                /* W->Lֹͣض */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_START_HO,                  /* W->LʼHO */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_HO_FAIL,                   /* W->L HOʧ */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_STOP_HO,                   /* W->LֹͣHO */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_START_PLMN,                /* W->LʼPLMN */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_DONE_PLMN,                 /* W->L PLMN */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_STOP_PLMN,                 /* W->LֹͣPLMN */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_START_RESEL,               /* L->Gʼѡ */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_RESEL_FAIL,                /* L->Gѡʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_START_REDIR,               /* L->Gض */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_REDIR_FAIL,                /* L->Gضʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_START_CCO,                 /* L->GʼCCO */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_CCO_FAIL,                  /* L->G CCOʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_START_HO,                  /* L->Gʼл */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_HO_FAIL,                   /* L->Gлʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_START_RESEL,               /* L->Wʼѡ */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_RESEL_FAIL,                /* L->Wѡʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_START_REDIR,               /* L->Wض */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_REDIR_FAIL,                /* L->Wضʧ */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_START_HO,                  /* L->Wʼл */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_HO_FAIL,                   /* L->Wлʧ */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_IDLE_MEAS,                 /* G->L IDLE */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_IDLE_MEAS,                 /* W->L IDLE */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_CONN_MEAS,                 /* G->L CONN */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_CONN_MEAS,                 /* W->L CONN */
    LRRC_APP_FLOW_CTRL_TYPE_W2L_RELALL,                    /* W->L RELALL */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_START_CELL_SRCH,           /* L->W  */
    LRRC_APP_FLOW_CTRL_TYPE_L2W_STOP_CELL_SRCH,            /* L->W ֹͣ */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_START_CELL_SRCH,           /* L->G  */
    LRRC_APP_FLOW_CTRL_TYPE_L2G_STOP_CELL_SRCH,            /* L->G ֹͣ */
    LRRC_APP_FLOW_CTRL_TYPE_T2L_RELALL,                    /* T->L RELALL */
    LRRC_APP_FLOW_CTRL_TYPE_G2L_RELALL,                    /* G->L RELALL */
    LRRC_APP_FLOW_CTRL_TYPE_L2T_START_REDIR,               /* L->Tض */
    LRRC_APP_FLOW_CTRL_TYPE_L2T_START_HO,                  /* L->Tʼл */
    LRRC_APP_FLOW_CTRL_TYPE_L2T_START_RESEL,               /* L->Tʼѡ */
    LRRC_APP_FLOW_CTRL_TYPE_T2L_IDLE_MEAS,                 /* T->L IDLE */
    LRRC_APP_FLOW_CTRL_TYPE_T2L_CONN_MEAS,                 /* G->L CONN */

    LRRC_APP_FLOW_CTRL_TYPE_BUTT
};
typedef VOS_UINT8 LRRC_APP_FLOW_CTRL_TYPE_ENUM_UINT8;

/*****************************************************************************
 ö    : RRC_APP_BOOL_ENUM
 Э  :
 ASN.1 :
 ö˵  : PSͳһöٶ
*****************************************************************************/
enum RRC_APP_BOOL_ENUM
{
    RRC_APP_PS_FALSE                            = 0,
    RRC_APP_PS_TRUE                             = 1,
    RRC_APP_PS_BOOL_BUTT
};
typedef VOS_UINT8   RRC_APP_BOOL_ENUM_UINT8;

/*****************************************************************************
 ö    : RRC_UE_CATEGORY_ENUM_UINT8
 Э  :
 ASN.1 :
 ö˵  : UE Categoryμ36306Э
*****************************************************************************/
enum RRC_APP_CATEGORY_ENUM
{
    RRC_APP_UE_CATEGORY_1                   = 0,
    RRC_APP_UE_CATEGORY_2                   = 1,
    RRC_APP_UE_CATEGORY_3                   = 2,
    RRC_APP_UE_CATEGORY_4                   = 3,
    RRC_APP_UE_CATEGORY_5                   = 4,
    RRC_APP_UE_CATEGORY_6                   = 5,
    RRC_APP_UE_CATEGORY_7                   = 6,
    RRC_APP_UE_CATEGORY_BUTT
};
typedef VOS_UINT8 RRC_APP_CATEGORY_ENUM_UINT8;
/*****************************************************************************
 ö    : RRC_CONN_REEST_IND_ENUM_UINT8
 Э  :
 ASN.1 :
 ö˵  : RRCؽԭ
*****************************************************************************/
enum RRC_APP_CONN_REEST_IND_ENUM
{
    RRC_APP_CONN_REEST_FOR_RBCFG_ERROR      = 0,                                    /* 0:RBʧܵµRRCؽ */
    RRC_APP_CONN_REEST_FOR_HANDOVER_ERROR   = 1,                                    /* 1:лʧܵµRRCؽ */
    RRC_APP_CONN_REEST_FOR_OTHER_ERROR      = 2,                                    /* 2:·ʧܻ֤ʧܵµRRCؽ */
    RRC_APP_CONN_REEST_FOR_BUTT
};
typedef VOS_UINT8 RRC_APP_CONN_REEST_IND_ENUM_UINT8;

/*********************************************************
 ö    : RRC_APP_FTM_CHANGE_INFO_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ϱģʽͶ
**********************************************************/
enum RRC_APP_FTM_CHANGE_INFO_TYPE_ENUM
{
    RRC_APP_FTM_CHANGE_CELL_INFO,  /* RRCפСϢ仯ϱлѡɺϱ */
    RRC_APP_FTM_CHANGE_STATE_INFO, /* RRC״̬Ϣ仯ϱ */
    RRC_APP_FTM_CHANGE_BUTT
};

typedef VOS_UINT32 RRC_APP_FTM_CHANGE_INFO_TYPE_ENUM_UINT32;
/*********************************************************
 ö    : LRRC_LPHY_LTE_BAND_WIDTH_ENUM
 Э  :
 ASN.1 :
 ö˵  : LTEWIDTH_3MǱʾд3Mʾ3M
**********************************************************/
enum LRRC_APP_BAND_WIDTH_ENUM
{
    LRRC_APP_LTE_BAND_WIDTH_1D4M = 0,
    LRRC_APP_LTE_BAND_WIDTH_3M,
    LRRC_APP_LTE_BAND_WIDTH_5M,
    LRRC_APP_LTE_BAND_WIDTH_10M,
    LRRC_APP_LTE_BAND_WIDTH_15M,
    LRRC_APP_LTE_BAND_WIDTH_20M,
    LRRC_APP_LTE_BAND_WIDTH_BUTT
};
typedef VOS_UINT16 LRRC_APP_BAND_WIDTH_ENUM_UINT16;

/*****************************************************************************
   5 STRUCT
*****************************************************************************/
/*****************************************************************************
                  ģʽϱṹ嶨
*****************************************************************************/
/*********************************************************************
* ASN ı :MCC
*********************************************************************/
typedef struct
{
    VOS_UINT8                           ucCnt;    /*(0, 3)*/
    VOS_UINT8                           aucItem[RRC_APP_MAX_NUM_OF_MCC];
}RRC_APP_MCC_STRU;

/*********************************************************************
* ASN ı :PLMN-Identity
*********************************************************************/
typedef struct
{
    RRC_APP_MCC_STRU                         Mcc;                          /* optional */
    RRC_APP_MCC_STRU                         Mnc;
}LRRC_APP_PLMN_ID_STRU;
/*****************************************************************************
 ṹ    :APP_RRC_Txpwr
 ṹ˵  :RRCϱAPPз书
*****************************************************************************/
typedef struct
{
    VOS_INT16                        sPuschTxPwr;
    VOS_INT16                        sPucchTxPwr;
    VOS_INT16                        sSrsTxpwr;
    VOS_UINT16                       usReserved;
}RRC_APP_Txpwr_INFO_STRU;
/*****************************************************************************
 ṹ    :RRC_APP_PUSCH_BLER_STRU
 ṹ˵  :RRCϱAPPPUSCHʽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32             ulAckCnt;    /* յACK */
    VOS_UINT32             ulNackCnt;   /* յNACK */
}RRC_APP_PUSCH_BLER_STRU;

/*****************************************************************************
 ṹ    :RRC_APP_PDSCH_BLER_STRU
 ṹ˵  :RRCϱAPPPDSCHʽṹҪʾʼʺۼʣҪʾ
*****************************************************************************/
typedef struct
{
    VOS_UINT16              ausCWInitTotal[NUM_OF_CODEWORD]; /* ʼʣյ֡ȷ */
    VOS_UINT16              ausCWInitError[NUM_OF_CODEWORD]; /* ʼʣյĴ֡ */
    VOS_UINT16              ausCWReTotal[NUM_OF_CODEWORD];   /* ʣյ֡ȷ */
    VOS_UINT16              ausCWReError[NUM_OF_CODEWORD];   /* ʣյĴ֡ */
}RRC_APP_PDSCH_BLER_STRU;

/*****************************************************************************
 ṹ    :RRC_APP_PDCCH_BLER_STRU
 ṹ˵  :RRCϱAPPȨ
*****************************************************************************/
typedef struct
{
    VOS_UINT32              ulDlGrantCnt; /* Ȩ */
    VOS_UINT32              ulUlGrantCnt; /* Ȩ */
}RRC_APP_PDCCH_BLER_STRU;

/*****************************************************************************
 ṹ    :APP_RRC_BLER_INFO_STRU
 ṹ˵  :RRCϱAPPʽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_PUSCH_BLER_STRU         stPuschBlerCnt; /* PUSCH BLER */
    RRC_APP_PDSCH_BLER_STRU         stPdschBlerCnt; /* PDSCH BLER */
    RRC_APP_PDCCH_BLER_STRU         stPdcchBlerCnt; /* PDCCH Ȩ */
}RRC_APP_BLER_INFO_STRU;

/*****************************************************************************
 ṹ    :RRC_APP_PERIOD_CELL_INFO_STRU
 ṹ˵  :RRCϱAPPפСϢ
*****************************************************************************/
typedef struct
{
    VOS_INT16                           sRsrp;              /* RSRPֵΧ(-141,-44)λdbm*/
    VOS_INT16                           sRsrq;              /* RSRQֵΧ(-40, -6) */
    VOS_INT16                           sRssi;              /* RSSIֵλdbm */
    VOS_UINT16                          usRI;               /* RIֵ */
    VOS_UINT16                          ausCQI[2];          /* CQIֻ֣һʱһֵЧ */
    VOS_INT32                           lSINR;              /* SINRСοź */
    RRC_APP_Txpwr_INFO_STRU             stTxPwr;            /* LTEŵ͹ */
    RRC_APP_BLER_INFO_STRU              stBler;             /* LTE */
}RRC_APP_PERIOD_CELL_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_FREQ_PARA_STRU
ṹ˵  : RRCϱϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              usUlFreq;          /* Ƶ λ:100Khz */
    VOS_UINT16                              usDlFreq;          /* Ƶ λ:100Khz */
    LRRC_APP_BAND_WIDTH_ENUM_UINT16         enDlBandwidth;     /* д */
    VOS_UINT8                               usBand;            /* Ƶָʾ */
    VOS_UINT8                               aucResv[1];
} RRC_APP_FREQ_PARA_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_CHANGE_CELL_INFO_STRU
 ṹ˵  : 仯ϱĹģʽṹ--פСϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                ulValidNum;                      /* LTE֧CA£ЧƵ */
    RRC_APP_FREQ_PARA_STRU                    astFreqInfo[LRRC_APP_MAX_NUM];   /* LTE֧CA£ƵϢ */
    VOS_UINT16                                astPhyCellId[LRRC_APP_MAX_NUM];  /* LTE֧CA£СIDϢ */
    VOS_UINT8                                 ucSbuFrmAssignmentType;          /* TDDģʽЧLTE֡ȣ0xFFΪЧֵ */
    VOS_UINT8                                 ucSpecialSubFrmPatterns;         /* TDDģʽЧLTE֡ȣ0xFFΪЧֵ */
    RRC_APP_PAGING_CYCLE_ENUM_UINT32          enPagingCycle;                   /* Ѱ */
    RRC_APP_TRANSM_MODE_ENUM_UINT32           enTranMode;                      /* LTEģʽ */
}RRC_APP_CHANGE_CELL_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_CHANGE_INFO_STRU
 ṹ˵  : 仯ϱĹģʽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_FTM_CHANGE_INFO_TYPE_ENUM_UINT32  ulFtmChangeInfoType;

    union
    {
        RRC_APP_CHANGE_CELL_INFO_STRU             stCellInfo;  /* 仯ϱĹģʽṹ--פСϢ */
        RRC_APP_PROTOCOL_STATE_IND_ENUM_UINT8     enState;     /* 仯ϱĹģʽṹ--״̬ϢЭ״̬ڲ״̬ */
    }u;
}RRC_APP_FTM_CHANGE_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO_STRU
 ṹ˵  : ϱĹģʽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                 ulValidNum;
    RRC_APP_PERIOD_CELL_INFO_STRU              astCellInfo[LRRC_APP_MAX_NUM]; /* RRCϱAPPפСϢ */
}RRC_APP_FTM_PERIOD_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_INFO_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_FTM_TYPE_ENUM_UINT32             enRrcAppFtmType; /* ģʽ£ϱϢ--ϱͱϱ */

    union
    {
        RRC_APP_FTM_PERIOD_INFO_STRU         stPeriodInfo;    /* ģʽ£ϱݣ Idle״̬ϱĿǰΪDRXڣConnected״̬Ϊ1*/
        RRC_APP_FTM_CHANGE_INFO_STRU         stChangeInfo;    /* ģʽ£ϱ */
    }u;
}RRC_APP_FTM_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_INFO_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/
typedef struct
{
    /* ģID */
    OM_ERR_LOG_MOUDLE_ID_ENUM_UINT32    ulMsgModuleID;

    /* 00, 01 ,10/11:  */
    VOS_UINT16                          usModemId;

    VOS_UINT16                          usProjectID;
    VOS_UINT32                          ulLength;

    RRC_APP_FTM_INFO_STRU               stLrrcFtmInfo;

}LRRC_OM_FTM_REPROT_CONTENT_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_INFO_STRU
 ṹ˵  : ģʽϱݽṹ
*****************************************************************************/

/* ģʽϱ  -> OM*/
typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                          ulMsgName;
    VOS_UINT32                          ulMsgType;
    VOS_UINT32                          ulMsgSN;
    VOS_UINT32                          ulRptlen;      /* ģʽϱݳ,ulRptlenΪ0,aucContentݳҲΪ0 */
    LRRC_OM_FTM_REPROT_CONTENT_STRU     stLrrcFtmContent;
}LRRC_OM_FTM_REPROT_IND_STRU;

/*****************************************************************************
                   ERROR LOGϱṹ嶨
*****************************************************************************/

/*****************************************************************************
 ṹ    : RRC_APP_ACC_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RRCϢ洢
*****************************************************************************/
typedef struct
{
    VOS_UINT8                              ucAsRelBitmap;      /* UE汾1֧֣0֧֣ӵ͵λֱָʾRel8,Rel9,.... */
    VOS_UINT8                              aucReserved[3];
    VOS_UINT32                             ulFeatureGroupInds; /* μ36.331 B.1  Feature group indicators ½ڣλȡֵ */
}RRC_APP_ACC_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_RRC_EST_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RRCϢ洢
*****************************************************************************/
typedef struct
{
    LRRC_APP_LNAS_EST_CAUSE_ENUM_UINT8     enEstCause;             /* ԭ */
    LRRC_APP_LNAS_EST_RESULT_ENUM_UINT8    enResult;               /*  */
    VOS_UINT16                             usReserved;
}RRC_APP_RRC_EST_LIST_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_EST_INFO_STRU
 ṹ˵  : ERR LOG ӽݽṹ,
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucEstCnt; /* ǰ洢ĽϢ */
    VOS_UINT8                               aucRseverd[3];
    RRC_APP_RRC_EST_LIST_INFO_STRU          astEstInfoList[RRC_APP_MAX_RRC_EST_INFO_NUM];   /*  */
}RRC_APP_RRC_EST_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_EST_INFO_STRU
 ṹ˵  : ERR LOG ӽݽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_RRC_EST_INFO_STRU               stEstInfo;   /* RRCϢṹ */
    RRC_APP_ACC_INFO_STRU                   stAccInfo;   /* RRCʱUEṹ */
}RRC_APP_EST_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_SYNC_INFO_STRU
 ṹ˵  : ERR LOG ͬϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulInSyncCnt;   /* LRRCյLPHYͬ */
    VOS_UINT32          ulOutSyncCnt;  /* LRRCյLPHYʧ */
}RRC_APP_SYNC_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_REEST_INFO_STRU
 ṹ˵  : ERR LOG ؽݽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_CONN_REEST_IND_ENUM_UINT8   enReestConnCause;   /* һؽԭ */
    VOS_UINT8                           aucReserved[3];
    RRC_APP_SYNC_INFO_STRU              stSyncInfo;         /* ͬϢ */
}RRC_APP_REEST_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_ERR_LOG_PRINT_STRU
 ṹ˵  : ERROR LOG RRC ӡϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                   ulFileIdx; /* ļͳһţʹ */
    VOS_UINT32                   ulLineNo;  /* к */
    VOS_INT32                    lPara1;    /* 1 */
    VOS_INT32                    lPara2;    /* 2 */
    VOS_INT32                    lPara3;    /* 3 */
    VOS_INT32                    lPara4;    /* 4 */
}RRC_APP_ERROR_PRINT_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_RECIVE_MSG_STRU
 ṹ˵  : RRC ϢϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                   ulSendPid;    /* Pid */
    VOS_UINT32                   ulMsgName;    /* ϢID */
}RRC_APP_RECIVE_MSG_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_ERROR_PRINT_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ӡϢṹ
 ulNextIndexһĴӡulNextIndex = 1astErrLogPrint[0]
 µĴӡ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                     ulNextIndex;
    RRC_APP_ERROR_PRINT_STRU       astErrLogPrint[RRC_APP_ERROR_PRINT_INFO_NUM];
} RRC_APP_ERROR_PRINT_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_RECIVE_MSG_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʱģյϢ
  ulNextIndexһյϢulNextIndex = 1astReciveMsgInfo[0]
 µյϢID
*****************************************************************************/
typedef struct
{
    VOS_UINT32                         ulNextIndex;
    RRC_APP_RECIVE_MSG_STRU            astReciveMsgInfo[RRC_APP_RECEIVE_MSG_INFO_NUM];
} RRC_APP_RECIVE_MSG_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_STATE_INFO_STRU
 ṹ˵  : ERROR LOG RRC״̬Ϣ
*****************************************************************************/
typedef struct
{
    RRC_APP_PROTOCOL_STATE_IND_ENUM_UINT8       enState;            /* RRCЭ״̬ */  
    VOS_UINT8                                   ucErrcTopMsState;   /* RRC״̬ڲ״̬ */
    VOS_UINT8                                   ucErrcTopSsState;   /* RRC״̬ڲ״̬ */
    LRRC_APP_FLOW_CTRL_TYPE_ENUM_UINT8          enErrcFlowCtrlType; /* LTEϵͳʱϵͳ̱ʶ */
}RRC_APP_STATE_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_ERROR_PRINT_INFO_STRU    stRrcAppErrorPrintInfo; /* RRCӡϢ */
    RRC_APP_RECIVE_MSG_INFO_STRU     stRrcAppReciveMsgInfo;  /* ʱRRCյϢ */
    RRC_APP_STATE_INFO_STRU          stRrcAppStateInfo;      /* ʱRRC״̬ϢЭ״̬ڲ״̬ */
    RRC_APP_EST_INFO_STRU            stRrcAppEstInfo;        /* ʱRRCӽ¼Ϣ */
    RRC_APP_REEST_INFO_STRU          stRrcAppReestInfo;      /* ʱRRCӽ¼Ϣ */
}RRC_APP_ERR_LOG_RRC_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_CODE_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RRC뱣ṹ
  ulNextIndexһulNextIndex = 1aenRrcAppErrorCode[0]µյϢID;
                                          ulNextIndex = 0aenRrcAppErrorCode[0] = RRC_APP_ERR_CODE_BUTT;RRCûб
*****************************************************************************/
typedef struct
{
    VOS_UINT32                         ulNextIndex;
    RRC_APP_ERROR_CODE_ENUM_UINT16     aenRrcAppErrorCode[RRC_APP_CODE_NUM];
} RRC_APP_CODE_INFO_STRU;

/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    RRC_APP_CODE_INFO_STRU           stCodeInfo;           /* ϱṹÿģ鵥 */
    RRC_APP_ERR_LOG_RRC_INFO_STRU    stErrorLogInfo;       /* λϢϱṹ */
}RRC_APP_ERR_LOG_INFO_STRU;
/*****************************************************************************
 ṹ    : RRC_APP_FTM_PERIOD_INFO
 ṹ˵  : ն˽ERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    /* ģID */
    OM_ERR_LOG_MOUDLE_ID_ENUM_UINT32    ulMsgModuleID;

    /* 00, 01 ,10/11:  */
    VOS_UINT16                          usModemId;

    /*  sub sys,modeule,sub module   ݲʹ   */
    VOS_UINT16                          usALMID;

    /* ERR LOGϱ,
    Warning0x04ʾ
    Minor0x03Ҫ
    Major0x02Ҫ
    Critical0x01    */
    VOS_UINT16                          usALMLevel;

    /* ÿERR LOG:
    &澯
    ͨţ0x00
    ҵ0x01
    0x02
    豸ϣ0x03
    ϣ0x04    */
    VOS_UINT16                          usALMType;

    VOS_UINT32                          usAlmLowSlice;/*ʱ*/
    VOS_UINT32                          usAlmHighSlice;

    VOS_UINT32                          ulAlmLength;
    RRC_APP_ERR_LOG_INFO_STRU           stAlmInfo;
}LRRC_OM_ERR_LOG_INFO_STRU;

/*****************************************************************************
 ṹ    : OM_ERR_LOG_REPORT_CNF_STRU
 ṹ˵  : Balongƽ̨ڲERROR LOG ݽṹ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    VOS_UINT32                          ulMsgName;
    VOS_UINT32                          ulMsgType;
    VOS_UINT32                          ulMsgSN;
    VOS_UINT32                          ulRptlen;      /* ݳ,ulRptlenΪ0,aucContentݳҲΪ0 */
    LRRC_OM_ERR_LOG_INFO_STRU           stErrLogInfo;
} LRRC_OM_ERR_LOG_REPORT_CNF_STRU;

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/






#if (VOS_OS_VER == VOS_WIN32)
#pragma pack()
#else
#pragma pack(0)
#endif




#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of LrrcErrLogInterface.h */


