/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : LRrcWRrcInterface.h
  Description     : LTE RRCWRRC֮ӿļ
  History         :
      1.liutao 38432       2010-12-30   Draft Enact
      2.lidui 143774       2011-09-22 DTS2011091702682:ֱø.hļɵ.dllļϢʧ

******************************************************************************/

#ifndef __LRRCWRRCINTERFACE_H__
#define __LRRCWRRCINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include  "vos.h"
#include  "LPSCommon.h"
#include  "LRrcGuRrcCommInterface.h"


/*****************************************************************************
  #pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 Macro
*****************************************************************************/

#define LRRC_WRRC_MSG_HDR                (PS_MSG_ID_LRRC_TO_WRRC_BASE)
#define WRRC_LRRC_MSG_HDR                (PS_MSG_ID_WRRC_TO_LRRC_BASE)

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
/*****************************************************************************
 ö    :
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum LRRC_WRRC_MSG_TYPE_ENUM
{
    /* W -> L Cell Resel */
    ID_WRRC_LRRC_CELL_RESEL_REQ             = (WRRC_LRRC_MSG_HDR + 0x00),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_RESEL_REQ_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_CELL_RESEL_CNF             = (LRRC_WRRC_MSG_HDR + 0x00),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_RESEL_CNF_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CELL_RESEL_STOP_REQ        = (WRRC_LRRC_MSG_HDR + 0x01),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_RESEL_STOP_REQ_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_CELL_RESEL_STOP_CNF        = (LRRC_WRRC_MSG_HDR + 0x01),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_RESEL_STOP_CNF_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L Redirect */
    ID_WRRC_LRRC_REDIRECTED_REQ             = (WRRC_LRRC_MSG_HDR + 0x02),       /* _H2ASN_MsgChoice WRRC_LRRC_REDIRECTED_REQ_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_REDIRECTED_CNF             = (LRRC_WRRC_MSG_HDR + 0x02),       /* _H2ASN_MsgChoice LRRC_WRRC_REDIRECTED_CNF_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_REDIRECTED_STOP_REQ        = (WRRC_LRRC_MSG_HDR + 0x03),       /* _H2ASN_MsgChoice WRRC_LRRC_REDIRECTED_STOP_REQ_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_REDIRECTED_STOP_CNF        = (LRRC_WRRC_MSG_HDR + 0x03),       /* _H2ASN_MsgChoice LRRC_WRRC_REDIRECTED_STOP_CNF_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L HO */
    ID_WRRC_LRRC_HANDOVER_REQ               = (WRRC_LRRC_MSG_HDR + 0x04),       /* _H2ASN_MsgChoice WRRC_LRRC_HANDOVER_REQ_STRU */          /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_HANDOVER_CNF               = (LRRC_WRRC_MSG_HDR + 0x04),       /* _H2ASN_MsgChoice LRRC_WRRC_HANDOVER_CNF_STRU */          /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_HANDOVER_STOP_REQ          = (WRRC_LRRC_MSG_HDR + 0x05),       /* _H2ASN_MsgChoice WRRC_LRRC_HANDOVER_STOP_REQ_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_HANDOVER_STOP_CNF          = (LRRC_WRRC_MSG_HDR + 0x05),       /* _H2ASN_MsgChoice LRRC_WRRC_HANDOVER_STOP_CNF_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L ͹ */
    ID_WRRC_LRRC_SET_DSP_POWER_REQ          = (WRRC_LRRC_MSG_HDR + 0x06),       /* _H2ASN_MsgChoice WRRC_LRRC_SET_DSP_POWER_REQ_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_SET_DSP_POWER_CNF          = (LRRC_WRRC_MSG_HDR + 0x06),       /* _H2ASN_MsgChoice LRRC_WRRC_SET_DSP_POWER_CNF_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L Get Ue Capability Info */
    ID_WRRC_LRRC_GETUECAPINFO_REQ           = (WRRC_LRRC_MSG_HDR + 0x07),       /* _H2ASN_MsgChoice WRRC_LRRC_GETUECAPINFO_REQ_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_GETUECAPINFO_CNF           = (LRRC_WRRC_MSG_HDR + 0x07),       /* _H2ASN_MsgChoice LRRC_WRRC_GETUECAPINFO_CNF_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L PLMN SEARCH */
    ID_WRRC_LRRC_PLMN_SEARCH_REQ            = (WRRC_LRRC_MSG_HDR + 0x08),       /* _H2ASN_MsgChoice WRRC_LRRC_PLMN_SEARCH_REQ_STRU */       /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_PLMN_SEARCH_CNF            = (LRRC_WRRC_MSG_HDR + 0x08),       /* _H2ASN_MsgChoice LRRC_WRRC_PLMN_SEARCH_CNF_STRU */       /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_PLMN_SEARCH_STOP_REQ       = (WRRC_LRRC_MSG_HDR + 0x09),       /* _H2ASN_MsgChoice WRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU */  /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_PLMN_SEARCH_STOP_CNF       = (LRRC_WRRC_MSG_HDR + 0x09),       /* _H2ASN_MsgChoice LRRC_WRRC_PLMN_SEARCH_STOP_CNF_STRU */  /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* W -> L Idle Meas */
    ID_WRRC_LRRC_IDLE_MEASURE_REQ           = (WRRC_LRRC_MSG_HDR + 0x0a),       /* _H2ASN_MsgChoice WRRC_LRRC_IDLE_MEASURE_REQ_STRU */      /* SendPid:WUEPS_PID_WCOM; RcvPid:PS_PID_ERMM */
    ID_LRRC_WRRC_IDLE_MEASURE_CNF           = (LRRC_WRRC_MSG_HDR + 0x0a),       /* _H2ASN_MsgChoice LRRC_WRRC_IDLE_MEASURE_CNF_STRU */      /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */
    ID_LRRC_WRRC_IDLE_MEASURE_IND           = (LRRC_WRRC_MSG_HDR + 0x0b),       /* _H2ASN_MsgChoice LRRC_WRRC_IDLE_MEASURE_IND_STRU */      /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */

    /* W -> L Conn Meas */
    ID_WRRC_LRRC_CONNECTED_MEASURE_REQ      = (WRRC_LRRC_MSG_HDR + 0x0b),       /* _H2ASN_MsgChoice WRRC_LRRC_CONNECTED_MEASURE_REQ_STRU */ /* SendPid:WUEPS_PID_WCOM; RcvPid:PS_PID_ERMM */
    ID_LRRC_WRRC_CONNECTED_MEASURE_CNF      = (LRRC_WRRC_MSG_HDR + 0x0c),       /* _H2ASN_MsgChoice LRRC_WRRC_CONNECTED_MEASURE_CNF_STRU */ /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */
    ID_LRRC_WRRC_CONNECTED_MEASURE_IND      = (LRRC_WRRC_MSG_HDR + 0x0d),       /* _H2ASN_MsgChoice LRRC_WRRC_CONNECTED_MEASURE_IND_STRU */ /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */

    /* W -> L RelAll */
    ID_WRRC_LRRC_RELALL_REQ                 = (WRRC_LRRC_MSG_HDR + 0x0c),       /* _H2ASN_MsgChoice WRRC_LRRC_RELALL_REQ_STRU */            /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_RELALL_CNF                 = (LRRC_WRRC_MSG_HDR + 0x0e),       /* _H2ASN_MsgChoice LRRC_WRRC_RELALL_CNF_STRU */            /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* L -> W Cell Resel*/
    ID_LRRC_WRRC_CELL_RESEL_REQ             = (LRRC_WRRC_MSG_HDR + 0x0f),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_RESEL_REQ_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CELL_RESEL_CNF             = (WRRC_LRRC_MSG_HDR + 0x0d),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_RESEL_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_CELL_RESEL_STOP_REQ        = (LRRC_WRRC_MSG_HDR + 0x10),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_RESEL_STOP_REQ_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CELL_RESEL_STOP_CNF        = (WRRC_LRRC_MSG_HDR + 0x0e),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_RESEL_STOP_CNF_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> W Redirect */
    ID_LRRC_WRRC_REDIRECTED_REQ             = (LRRC_WRRC_MSG_HDR + 0x11),       /* _H2ASN_MsgChoice LRRC_WRRC_REDIRECTED_REQ_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_REDIRECTED_CNF             = (WRRC_LRRC_MSG_HDR + 0x0f),       /* _H2ASN_MsgChoice WRRC_LRRC_REDIRECTED_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_REDIRECTED_STOP_REQ        = (LRRC_WRRC_MSG_HDR + 0x12),       /* _H2ASN_MsgChoice LRRC_WRRC_REDIRECTED_STOP_REQ_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_REDIRECTED_STOP_CNF        = (WRRC_LRRC_MSG_HDR + 0x10),       /* _H2ASN_MsgChoice WRRC_LRRC_REDIRECTED_STOP_CNF_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> W HO */
    ID_LRRC_WRRC_HANDOVER_REQ               = (LRRC_WRRC_MSG_HDR + 0x13),       /* _H2ASN_MsgChoice LRRC_WRRC_HANDOVER_REQ_STRU */          /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_HANDOVER_CNF               = (WRRC_LRRC_MSG_HDR + 0x11),       /* _H2ASN_MsgChoice WRRC_LRRC_HANDOVER_CNF_STRU */          /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_HANDOVER_STOP_REQ          = (LRRC_WRRC_MSG_HDR + 0x14),       /* _H2ASN_MsgChoice LRRC_WRRC_HANDOVER_STOP_REQ_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_HANDOVER_STOP_CNF          = (WRRC_LRRC_MSG_HDR + 0x12),       /* _H2ASN_MsgChoice WRRC_LRRC_HANDOVER_STOP_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L -> W ͹ */
    ID_LRRC_WRRC_SET_DSP_POWER_REQ          = (LRRC_WRRC_MSG_HDR + 0x15),       /* _H2ASN_MsgChoice LRRC_WRRC_SET_DSP_POWER_REQ_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_SET_DSP_POWER_CNF          = (WRRC_LRRC_MSG_HDR + 0x13),       /* _H2ASN_MsgChoice WRRC_LRRC_SET_DSP_POWER_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> W Get Ue Capability Info */
    ID_LRRC_WRRC_GETUECAPINFO_REQ           = (LRRC_WRRC_MSG_HDR + 0x16),       /* _H2ASN_MsgChoice LRRC_WRRC_GETUECAPINFO_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_GETUECAPINFO_CNF           = (WRRC_LRRC_MSG_HDR + 0x14),       /* _H2ASN_MsgChoice WRRC_LRRC_GETUECAPINFO_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
   /* L -> W Idle Meas */
    ID_LRRC_WRRC_IDLE_MEASURE_REQ          = (LRRC_WRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice LRRC_WRRC_IDLE_MEASURE_REQ_STRU */     /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_IDLE_MEASURE_CNF          = (WRRC_LRRC_MSG_HDR + 0x15),       /* _H2ASN_MsgChoice WRRC_LRRC_IDLE_MEASURE_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_WRRC_LRRC_IDLE_MEASURE_IND          = (WRRC_LRRC_MSG_HDR + 0x16),       /* _H2ASN_MsgChoice WRRC_LRRC_IDLE_MEASURE_IND_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> W Conn Meas */
    ID_LRRC_WRRC_CONNECTED_MEASURE_REQ     = (LRRC_WRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice LRRC_WRRC_CONNECTED_MEASURE_REQ_STRU */    /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CONNECTED_MEASURE_CNF     = (WRRC_LRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice WRRC_LRRC_CONNECTED_MEASURE_CNF_STRU */    /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_WRRC_LRRC_CONNECTED_MEASURE_IND     = (WRRC_LRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice WRRC_LRRC_CONNECTED_MEASURE_IND_STRU */    /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> W RelAll */
    ID_LRRC_WRRC_RELALL_REQ                = (LRRC_WRRC_MSG_HDR + 0x1b),       /* _H2ASN_MsgChoice LRRC_WRRC_RELALL_REQ_STRU */           /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_RELALL_CNF                = (WRRC_LRRC_MSG_HDR + 0x1c),       /* _H2ASN_MsgChoice WRRC_LRRC_RELALL_CNF_STRU */           /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#else
    /* L -> GU Idle Meas */
    ID_LRRC_GURRC_IDLE_MEASURE_REQ          = (LRRC_WRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice LRRC_GURRC_IDLE_MEASURE_REQ_STRU */     /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_IDLE_MEASURE_CNF          = (WRRC_LRRC_MSG_HDR + 0x15),       /* _H2ASN_MsgChoice GURRC_LRRC_IDLE_MEASURE_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_GURRC_LRRC_IDLE_MEASURE_IND          = (WRRC_LRRC_MSG_HDR + 0x16),       /* _H2ASN_MsgChoice GURRC_LRRC_IDLE_MEASURE_IND_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> GU Conn Meas */
    ID_LRRC_GURRC_CONNECTED_MEASURE_REQ     = (LRRC_WRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice LRRC_GURRC_CONNECTED_MEASURE_REQ_STRU */    /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_CONNECTED_MEASURE_CNF     = (WRRC_LRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice GURRC_LRRC_CONNECTED_MEASURE_CNF_STRU */    /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_GURRC_LRRC_CONNECTED_MEASURE_IND     = (WRRC_LRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice GURRC_LRRC_CONNECTED_MEASURE_IND_STRU */    /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> GU  Gsm Cell Bsic Verify  */
    ID_LRRC_GURRC_BSIC_VERIFIED_REQ         = (LRRC_WRRC_MSG_HDR + 0x19),       /* _H2ASN_MsgChoice LRRC_GURRC_BSIC_VERIFIED_REQ_STRU */        /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_BSIC_VERIFIED_CNF         = (WRRC_LRRC_MSG_HDR + 0x19),       /* _H2ASN_MsgChoice GURRC_LRRC_BSIC_VERIFIED_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_GURRC_LRRC_BSIC_VERIFIED_IND         = (WRRC_LRRC_MSG_HDR + 0x1a),       /* _H2ASN_MsgChoice GURRC_LRRC_BSIC_VERIFIED_IND_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> W DSP  */
    ID_LRRC_WRRC_LOAD_DSP_REQ               = (LRRC_WRRC_MSG_HDR + 0x1a),       /* _H2ASN_MsgChoice LRRC_WRRC_LOAD_DSP_REQ_STRU */          /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_LOAD_DSP_CNF               = (WRRC_LRRC_MSG_HDR + 0x1b),       /* _H2ASN_MsgChoice WRRC_LRRC_LOAD_DSP_CNF_STRU */          /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L -> GU RelAll */
    ID_LRRC_GURRC_RELALL_REQ                = (LRRC_WRRC_MSG_HDR + 0x1b),       /* _H2ASN_MsgChoice LRRC_GURRC_RELALL_REQ_STRU */           /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_RELALL_CNF                = (WRRC_LRRC_MSG_HDR + 0x1c),       /* _H2ASN_MsgChoice GURRC_LRRC_RELALL_CNF_STRU */           /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#endif
    /* L -> W cell srch. LؽʱUTRAС */
    ID_LRRC_WRRC_CELL_SRCH_REQ              = (LRRC_WRRC_MSG_HDR + 0x1c),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_SRCH_REQ_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CELL_SRCH_CNF              = (WRRC_LRRC_MSG_HDR + 0x1d),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_SRCH_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_CELL_SRCH_STOP_REQ         = (LRRC_WRRC_MSG_HDR + 0x1d),       /* _H2ASN_MsgChoice LRRC_WRRC_CELL_SRCH_STOP_REQ_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_CELL_SRCH_STOP_CNF         = (WRRC_LRRC_MSG_HDR + 0x1e),       /* _H2ASN_MsgChoice WRRC_LRRC_CELL_SRCH_STOP_CNF_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
   /* L -> W BackGroud Search */
    ID_LRRC_WRRC_BG_PLMN_SEARCH_REQ        = (LRRC_WRRC_MSG_HDR + 0x1e),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_PLMN_SEARCH_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_BG_PLMN_SEARCH_CNF        = (WRRC_LRRC_MSG_HDR + 0x1f),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_PLMN_SEARCH_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_WRRC_LRRC_BG_PLMN_SEARCH_IND        = (WRRC_LRRC_MSG_HDR + 0x20),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_PLMN_SEARCH_IND_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_BG_SEARCH_STOP_REQ        = (LRRC_WRRC_MSG_HDR + 0x1f),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_STOP_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_BG_SEARCH_STOP_CNF        = (WRRC_LRRC_MSG_HDR + 0x21),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_STOP_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_BG_SEARCH_SUSPEND_REQ     = (LRRC_WRRC_MSG_HDR + 0x20),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_SUSPEND_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_BG_SEARCH_SUSPEND_CNF     = (WRRC_LRRC_MSG_HDR + 0x22),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_WRRC_BG_SEARCH_RESUME_REQ      = (LRRC_WRRC_MSG_HDR + 0x21),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_RESUME_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_BG_SEARCH_RESUME_CNF      = (WRRC_LRRC_MSG_HDR + 0x23),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_RESUME_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#else
    /* L -> GU BackGroud Search */
    ID_LRRC_GURRC_BG_PLMN_SEARCH_REQ        = (LRRC_WRRC_MSG_HDR + 0x1e),       /* _H2ASN_MsgChoice LRRC_GURRC_BG_PLMN_SEARCH_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_BG_PLMN_SEARCH_CNF        = (WRRC_LRRC_MSG_HDR + 0x1f),       /* _H2ASN_MsgChoice GURRC_LRRC_BG_PLMN_SEARCH_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_GURRC_LRRC_BG_PLMN_SEARCH_IND        = (WRRC_LRRC_MSG_HDR + 0x20),       /* _H2ASN_MsgChoice GURRC_LRRC_BG_PLMN_SEARCH_IND_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_GURRC_BG_SEARCH_STOP_REQ        = (LRRC_WRRC_MSG_HDR + 0x1f),       /* _H2ASN_MsgChoice LRRC_GURRC_BG_SEARCH_STOP_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_BG_SEARCH_STOP_CNF        = (WRRC_LRRC_MSG_HDR + 0x21),       /* _H2ASN_MsgChoice GURRC_LRRC_BG_SEARCH_STOP_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_GURRC_BG_SEARCH_SUSPEND_REQ     = (LRRC_WRRC_MSG_HDR + 0x20),       /* _H2ASN_MsgChoice LRRC_GURRC_BG_SEARCH_SUSPEND_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_BG_SEARCH_SUSPEND_CNF     = (WRRC_LRRC_MSG_HDR + 0x22),       /* _H2ASN_MsgChoice GURRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_GURRC_BG_SEARCH_RESUME_REQ      = (LRRC_WRRC_MSG_HDR + 0x21),       /* _H2ASN_MsgChoice LRRC_GURRC_BG_SEARCH_RESUME_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_GURRC_LRRC_BG_SEARCH_RESUME_CNF      = (WRRC_LRRC_MSG_HDR + 0x23),       /* _H2ASN_MsgChoice GURRC_LRRC_BG_SEARCH_RESUME_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#endif
    /* W-> L BackGroud Search */
    ID_WRRC_LRRC_BG_PLMN_SEARCH_REQ         = (WRRC_LRRC_MSG_HDR + 0x24),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_PLMN_SEARCH_REQ_STRU */
    ID_LRRC_WRRC_BG_PLMN_SEARCH_CNF         = (LRRC_WRRC_MSG_HDR + 0x22),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_PLMN_SEARCH_CNF_STRU */
    ID_LRRC_WRRC_BG_PLMN_SEARCH_IND         = (LRRC_WRRC_MSG_HDR + 0x23),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_PLMN_SEARCH_IND_STRU */
    ID_WRRC_LRRC_BG_SEARCH_STOP_REQ         = (WRRC_LRRC_MSG_HDR + 0x25),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_STOP_REQ_STRU */
    ID_LRRC_WRRC_BG_SEARCH_STOP_CNF         = (LRRC_WRRC_MSG_HDR + 0x24),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_STOP_CNF_STRU */
    ID_WRRC_LRRC_BG_SEARCH_SUSPEND_REQ      = (WRRC_LRRC_MSG_HDR + 0x26),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_SUSPEND_REQ_STRU */
    ID_LRRC_WRRC_BG_SEARCH_SUSPEND_CNF      = (LRRC_WRRC_MSG_HDR + 0x25),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_SUSPEND_CNF_STRU */
    ID_WRRC_LRRC_BG_SEARCH_RESUME_REQ       = (WRRC_LRRC_MSG_HDR + 0x27),       /* _H2ASN_MsgChoice WRRC_LRRC_BG_SEARCH_RESUME_REQ_STRU */
    ID_LRRC_WRRC_BG_SEARCH_RESUME_CNF       = (LRRC_WRRC_MSG_HDR + 0x26),       /* _H2ASN_MsgChoice LRRC_WRRC_BG_SEARCH_RESUME_CNF_STRU */

    /* L -> W ANR */
    ID_LRRC_WRRC_GET_W_CGI_REQ              = (LRRC_WRRC_MSG_HDR + 0x27),       /* _H2ASN_MsgChoice LRRC_WRRC_GET_W_CGI_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_GET_W_CGI_CNF              = (WRRC_LRRC_MSG_HDR + 0x28),       /* _H2ASN_MsgChoice WRRC_LRRC_GET_W_CGI_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_WRRC_LRRC_GET_W_CGI_IND              = (WRRC_LRRC_MSG_HDR + 0x29),       /* _H2ASN_MsgChoice WRRC_LRRC_GET_W_CGI_IND_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
   /* L -> W ANR STOP */
    ID_LRRC_WRRC_GET_CGI_STOP_REQ          = (LRRC_WRRC_MSG_HDR + 0x29),       /* _H2ASN_MsgChoice LRRC_WRRC_GET_CGI_STOP_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
#else
    /* L -> G ANR */
    ID_LRRC_WRRC_GET_G_CGI_REQ              = (LRRC_WRRC_MSG_HDR + 0x28),       /* _H2ASN_MsgChoice LRRC_WRRC_GET_G_CGI_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_WRRC_LRRC_GET_G_CGI_CNF              = (WRRC_LRRC_MSG_HDR + 0x30),       /* _H2ASN_MsgChoice WRRC_LRRC_GET_G_CGI_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_WRRC_LRRC_GET_G_CGI_IND              = (WRRC_LRRC_MSG_HDR + 0x31),       /* _H2ASN_MsgChoice WRRC_LRRC_GET_G_CGI_IND_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L -> GU ANR STOP */
    ID_LRRC_GURRC_GET_CGI_STOP_REQ          = (LRRC_WRRC_MSG_HDR + 0x29),       /* _H2ASN_MsgChoice LRRC_GURRC_GET_CGI_STOP_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
#endif
    /* L פ֪ͨ WAS */
    ID_LRRC_WRRC_CAMP_PLMN_INFO_NTF        = (LRRC_WRRC_MSG_HDR + 0x30),       /* _H2ASN_MsgChoice LRRC_WRRC_CAMP_PLMN_INFO_NTF_STRU */

    /* L ֪ͨ WAS */
    ID_LRRC_WRRC_AREA_LOST_NTF             = (LRRC_WRRC_MSG_HDR + 0x31),       /* _H2ASN_MsgChoice LRRC_WRRC_AREA_LOST_NTF_STRU */
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    ID_WRRC_LRRC_GET_CGI_STOP_CNF          = (WRRC_LRRC_MSG_HDR + 0x32),       /* _H2ASN_MsgChoice WRRC_LRRC_GET_CGI_STOP_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#else
    ID_GURRC_LRRC_GET_CGI_STOP_CNF          = (WRRC_LRRC_MSG_HDR + 0x32),       /* _H2ASN_MsgChoice GURRC_LRRC_GET_CGI_STOP_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
#endif
    ID_LRRC_WRRC_MSG_TYPE_BUTT
};

typedef VOS_UINT32 LRRC_WRRC_MSG_TYPE_ENUM_UINT32;


/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
 ṹ    : WRRC_LRRC_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usCellId;
    LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                  enMeasBand;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}WRRC_LRRC_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч*/
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfoList;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}LRRC_WRRC_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_CELL_RESEL_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_ARFCN_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRRCض̬Ϣ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usBlackListNum;
    VOS_UINT16                                              ausBlackListCellId[LRRC_GURRC_BLACK_LIST_CELL_MAX_NUM];
}WRRC_LRRC_ARFCN_INFO_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_REDIRECTED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    VOS_UINT8                                               aucReserve1[2];

    /* W->LضϢ */
    VOS_UINT16                                              usArfcnNum;
    WRRC_LRRC_ARFCN_INFO_STRU                               astRedirInfo[LRRC_GURRC_LTE_ARFCN_MAX_NUM];


    /* ͷʱָRRC CON REJ Яʱʣʱλ: */
    VOS_UINT16                                              usPunishTimerValue;

    /* REDIR INFO ָʾʱ λ:,Ŀǰ̶10000ms
       ڴʱָСֱӽСҪȵ˶ʱʱSUITABELEС
    ***************************************************************************/
    VOS_UINT16                                              usSearchTimer;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;   /* ̶ΪSUITABLE */

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_TYPE_ENUM_UINT8                        enRedirType;
    VOS_UINT8                                               aucReserved2[1];
    /* CMCC-END */

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}WRRC_LRRC_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_REDIRECTED_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}LRRC_WRRC_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_HANDOVER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    /* W֪ͨLǰ */
    VOS_UINT8                                               aucMcc[3];
    VOS_UINT8                                               aucReserved[1];

    VOS_UINT32                                              ulHoDataLen;
    /* ΪRRC CONN RECFG */
    VOS_UINT8                                               aucHoData[4];
}WRRC_LRRC_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_HANDOVER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  LRRCWRRCָʾл̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}LRRC_WRRC_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  WRRCָʾLRRCDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}WRRC_LRRC_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCEDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}LRRC_WRRC_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GETUECAPINFO_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  WRRCָʾLRRCṩUEϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    /* gaojishan-SYSCFG-SAVENV-Begin */
    VOS_UINT8                                               aucMcc[3];
    VOS_UINT8                                               aucReserved[1];
    /* gaojishan-SYSCFG-SAVENV-End */
}WRRC_LRRC_GETUECAPINFO_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_GETUECAPINFO_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCUEȡ
 For EUTRA: the encoding of UE capabilities is defined in IE UE-EUTRA-Capability.
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT16                                              usDataLen;
    VOS_UINT8                                               aucEutranCapInfoData[LRRC_WRRC_UE_CAP_EUTRAN_MAX_LEN];
}LRRC_WRRC_GETUECAPINFO_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCPLMN SEARCH
                 UTRAN UE̬³̣
                 LRRCҪжϸСǷSUITABLE׼
                 ָPLMNһǲפ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[2];
    VOS_UINT16                                              usArfcnNum;
    WRRC_LRRC_ARFCN_INFO_STRU                               astArfcnInfo[LRRC_GURRC_LTE_ARFCN_MAX_NUM];
}WRRC_LRRC_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  LRRCWRRC PLMN SEARCH 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_WRRC_PLMN_SEARCH_RESULT_ENUM_UINT16                enPLmnSearchRslt;
    VOS_UINT8                                               aucReserved[2];

    /* usPLmnSearchResult =  LRRC_WRRC_PLMN_SEARCH_SUCC дԭ
       LTE CELLЯPLMN LISTУRPLMNдRPLMNѡ
       һPLMN Ϣ*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stSuitablePlmnId;

    /* usPLmnSearchResult =  LRRC_WRRC_PLMN_SEARCH_FAIL Яٴι
           еPLMN ϢԸߵ򴫵ݸWRRC׼ͬ
          PLMN LIST */
    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}LRRC_WRRC_PLMN_SEARCH_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :WRRCָʾLRRCֹͣPLMN SEARCH
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_PLMN_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCֹͣPLMN SEARCH 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_PLMN_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stIdleEutranArfcnInfoList;
}WRRC_LRRC_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCWRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_WRRC_IDLE_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stIdleMeasRslt;
}LRRC_WRRC_IDLE_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;

    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_WRRC_STATE_TYPE_ENUM_UINT16                        enWRrcStateType;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stConnEutranArfcnInfoList;
}WRRC_LRRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_WRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stConnMeasRslt;
}LRRC_WRRC_CONNECTED_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_RELALL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  WRRCָʾLRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_RELALL_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_RELALL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_RELALL_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCWRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usPrimaryCode;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    /* gaojishan-DTS2013030502126 */
    PS_BOOL_ENUM_UINT8                                      enLteReestInd;
    VOS_UINT8                                               aucReserved[1];

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}LRRC_WRRC_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱ
    stPlmnIdInfo Ч,ΪСPLMN IDs Ϣ*/
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfoList;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}WRRC_LRRC_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_CELL_RESEL_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GURRC_REDIR_CELL_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  : ضЯСϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usPrimaryCode;
    VOS_UINT16                                              usSysInfoLen;
    VOS_UINT8                                               aucData[LRRC_WRRC_UTRAN_BCCH_CONTAINER_MAX_BYTE_LEN];
}LRRC_GURRC_REDIR_CELL_INFO_STRU;

/*****************************************************************************
 ṹ    : LRRC_GURRC_REDIR_CELL_INFO_LIST_STRU
 Э  :
 ASN.1   :
 ṹ˵  : ضЯСϢб
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulCellNum;
    LRRC_GURRC_REDIR_CELL_INFO_STRU                         astCellInfo[LRRC_WRRC_REDIR_CELL_MAX_MUN];
}LRRC_GURRC_REDIR_CELL_INFO_LIST_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_REDIRECTED_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCWRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    VOS_UINT8                                               aucReserved[3];

    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enRedirCellInfoPresent; /* ضСϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;      /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_REDIR_CELL_INFO_LIST_STRU                    stRedirCellInfoList;    /* СϢ */
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;             /* רȼϢ */

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU                  stRedirEutraInfo;
    /* CMCC-END */
}LRRC_WRRC_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_REDIRECTED_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}WRRC_LRRC_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :  LRRC_WRRC_HANDOVER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU                  stRedirEutraInfo;
    /* CMCC-END */

    /* CSFB ־,1:ʾCSFB, 0: ʾCSFB */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enCsfbInd;

    /* L֪ͨWǰפĹ */
    VOS_UINT8                                               aucMcc[3];
    VOS_UINT8                                               aucReserved[2];

    VOS_UINT16                                              usHoDatalen;
    VOS_UINT8                                               aucHoData[4];       /*  HANDOVER TO UTRAN COMMAND */
}LRRC_WRRC_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_HANDOVER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  WRRCLRRCָʾл̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}WRRC_LRRC_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}LRRC_WRRC_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCEDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}WRRC_LRRC_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_GETUECAPINFO_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCṩUEϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    /* gaojishan-SYSCFG-SAVENV-Begin */
    VOS_UINT8                                               aucMcc[3];
    VOS_UINT8                                               aucReserved[1];
    /* gaojishan-SYSCFG-SAVENV-End */
}LRRC_WRRC_GETUECAPINFO_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GETUECAPINFO_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCUEȡ
 For UTRA: the octet string contains the INTER RAT HANDOVER INFO message defined in TS 25.331 [19].
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT16                                              usDataLen;
    VOS_UINT8                                               aucUtranCapInfoData[LRRC_WRRC_UE_CAP_UTRAN_MAX_LEN];
}WRRC_LRRC_GETUECAPINFO_CNF_STRU;
#if (FEATURE_ON != FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ     :LRRC_GURRC_GERAN_CELL_INFO_LIST_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GERANϵͳϢб
*****************************************************************************/
typedef struct
{
   VOS_UINT16                                               usArfcnNum;

   /****************************************************************************
   ƵϢиȼƵIDLE̬Чֶ̬Ϊ
   usArfcnNum =  usHighPriNumʾֻиȼƵ㣬
   astGeranCellInfo˳Ϊ:ȼϢ -> ȼϢ -> ȼϢ
   ±ΪGSMСCELL ID
   ****************************************************************************/
   VOS_UINT16                                               usHighPrioNum;
   VOS_UINT16                                               usMgsmNum;          /* GSM̬ЧIDLEֶ̬α */
   VOS_UINT8                                                aucReserved[2];
   LRRC_GURRC_GERAN_CELL_STRU                               astGeranCellInfo[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}LRRC_GURRC_GERAN_CELL_INFO_LIST_STRU;
#endif
/*****************************************************************************
 ṹ     :LRRC_GURRC_UTRAN_CELL_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANϵͳϢ
*****************************************************************************/
typedef struct
{
   LRRC_GURRC_VALID_FLAG_ENUM_UINT8                         enDetectedCellMeasInd; /* ǷҪDetectedС */
   VOS_UINT8                                                aucReserved[3];

   VOS_UINT16                                               usArfcn;

   /* usCellIdNum = 0ʱʾƵϢϢ */
   VOS_UINT16                                               usCellIdNum;
   VOS_UINT16                                               ausUtranCellIdInfo[LRRC_GURRC_MAX_UTRAN_CELL_PER_FREQ_NUM];
}LRRC_GURRC_UTRAN_CELL_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANϵͳϢб
*****************************************************************************/
typedef struct
{
   VOS_UINT16                                               usArfcnNum;

   /****************************************************************************
   ƵϢиȼƵΪIDLE̬Ч, ̬¸ֶΪ
   usArfcnNum =  usHighPriNumʾֻиȼƵ㣬
   astUtranCellInfo˳Ϊ:ȼϢ -> ȼϢ -> ȼϢ
   ****************************************************************************/
   VOS_UINT16                                               usHighPrioNum;
   /* begin: for modify TDD max Meas Num  */
   LRRC_GURRC_UTRAN_CELL_INFO_STRU                          astUtranCellInfo[LRRC_TRRC_PHY_MAX_SUPPORT_CARRIER_NUM];
   /* end: for modify TDD max Meas Num  */
}LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU;
#if (FEATURE_ON != FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ     :LRRC_GURRC_IRAT_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GERAN\UTRANϵͳϢ
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_GERAN_CELL_INFO_LIST_STRU                    stGeranCellInfoList;
    LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU                    stUtranCellInfoList;
}LRRC_GURRC_IRAT_INFO_STRU;

/*****************************************************************************
 ṹ    : LRRC_GURRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGURRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_IRAT_INFO_STRU                               stIdleInterRatInfo;
}LRRC_GURRC_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GURRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}GURRC_LRRC_IDLE_MEASURE_CNF_STRU;
#else
/*****************************************************************************
 ṹ    : LRRC_WRRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU                    stUtranCellInfoList;
}LRRC_WRRC_IDLE_MEASURE_REQ_STRU;
/*****************************************************************************
 ṹ    : WRRC_LRRC_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : WRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}WRRC_LRRC_IDLE_MEASURE_CNF_STRU;
#endif
#if (FEATURE_ON != FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    : GURRC_LRRC_GERAN_CELL_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GERAN CELL 
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;          /* L->WʱϢеƵָʾһ */

    /* sRssi ȡֵΧ[-110 * 8,-48 * 8],λ:dbm,1/8 */
    VOS_INT16                                               sRssi;
    VOS_UINT8                                               aucReserved[2];
}GURRC_LRRC_GERAN_CELL_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_GERAN_MEAS_RESULT_IND_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GERAN CELL б
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcnNum;
    VOS_UINT8                                               aucReserved[2];

    GURRC_LRRC_GERAN_CELL_MEAS_RESULT_STRU                  astGeranCellResult[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}GURRC_LRRC_GERAN_MEAS_RESULT_IND_STRU;
#endif
/*****************************************************************************
 ṹ    : GURRC_LRRC_UTRAN_CELL_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GERAN CELL 
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usPrimaryCode;
    VOS_UINT8                                               aucReserved[2];
    VOS_INT16                                               sRscp;              /* 1/8 */
    VOS_INT16                                               sEcN0;              /* 1/8 */
}GURRC_LRRC_UTRAN_CELL_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_UTRAN_SIGNLE_FREQ_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  : UTRAN Ƶ 
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    VOS_INT16                                               sRssi;              /* 1/8 */
    VOS_UINT8                                               aucReserved[2];
    VOS_UINT16                                              usCellNum;
    GURRC_LRRC_UTRAN_CELL_MEAS_RESULT_STRU                  astUtranCellInfo[LRRC_GURRC_MAX_UTRAN_CELL_PER_FREQ_NUM];
}GURRC_LRRC_UTRAN_SIGNLE_FREQ_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU
 Э  :
 ASN.1   :
 ṹ˵  : UTRAN CELL б
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcnNum;
    VOS_UINT8                                               aucReserved[2];
    /* begin: for modify TDD max Meas Num  */
    GURRC_LRRC_UTRAN_SIGNLE_FREQ_MEAS_RESULT_STRU           astUtranResult[LRRC_TRRC_PHY_MAX_SUPPORT_CARRIER_NUM];
    /* end: for modify TDD max Meas Num  */
}GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    : WRRC_LRRC_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU                   stUtranMeasResult;
}WRRC_LRRC_IDLE_MEASURE_IND_STRU;
#else
/*****************************************************************************
 ṹ     :GURRC_LRRC_IRAT_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GERAN\UTRANϵͳϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_IRAT_TYPE_ENUM_UINT16                   enChoice;

    union
    {
        GURRC_LRRC_GERAN_MEAS_RESULT_IND_STRU               stGeranMeasResult;
        GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU               stUtranMeasResult;
    }u;
}GURRC_LRRC_IRAT_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_IRAT_MEAS_RESULT_STRU                        stIdleIRatMeasResult;
}GURRC_LRRC_IDLE_MEASURE_IND_STRU;
#endif

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    : LRRC_WRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU                    stUtranCellInfoList;
}LRRC_WRRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}WRRC_LRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU                   stUtranMeasResult;
}WRRC_LRRC_CONNECTED_MEASURE_IND_STRU;
#else
/*****************************************************************************
 ṹ    : WRRC_LRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_IRAT_INFO_STRU                               stConnInterRatInfo;
}LRRC_GURRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : GURRC_LRRC_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}GURRC_LRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : GRRLRRC_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾCONNECTED 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_IRAT_MEAS_RESULT_STRU                        stConnIRatMeasResult;
}GURRC_LRRC_CONNECTED_MEASURE_IND_STRU;
#endif
#if (FEATURE_ON != FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    :    LRRC_GURRC_BSIC_VERIFIED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCBSIC
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT16                                              usGeranInfoNum;
    LRRC_GURRC_VERIFY_TIME_INDEX_ENUM_UINT16                enVerifyTimeIndex;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_GERAN_CELL_STRU                              astGeranInfo[LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM];
}LRRC_GURRC_BSIC_VERIFIED_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BSIC_VERIFIED_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  WRRCָʾLRRCBSIC
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
}GURRC_LRRC_BSIC_VERIFIED_CNF_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BSIC_VERIFIED_RESULT_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCBSIC֤
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_GERAN_CELL_INFO_STRU                         stGeranCellInfo;
    VOS_UINT32                                              usTimeAlignment;
    VOS_INT32                                               lFNOffset;
}GURRC_LRRC_BSIC_VERIFIED_RESULT_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BSIC_VERIFIED_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCBSIC֤
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT16                                              usArfcnNum;
    GURRC_LRRC_BSIC_VERIFIED_RESULT_STRU                    astGeranBsicVerifedResult[LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM];
}GURRC_LRRC_BSIC_VERIFIED_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_LOAD_DSP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_LOAD_DSP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_LOAD_DSP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_LOAD_DSP_RESULT_ENUM_UINT32                  enRslt;
}WRRC_LRRC_LOAD_DSP_CNF_STRU;
#endif

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    :    LRRC_WRRC_RELALL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_RELALL_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_RELALL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_RELALL_CNF_STRU;
#else
/*****************************************************************************
 ṹ    :    LRRC_GURRC_RELALL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_RELALL_REASON_ENUM_UINT8                     enRelReason;
    VOS_UINT8                                               aucReserved[3];
}LRRC_GURRC_RELALL_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_RELALL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GURRC_LRRC_RELALL_CNF_STRU;
#endif
/*****************************************************************************
 ṹ    : LRRC_WRRC_CELL_SRCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCָʾСЯСб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[1];
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT16                                              usArfcnNum;
    LRRC_GURRC_UTRAN_CELL_INFO_STRU                         astUtranCellInfo[LRRC_GURRC_UTRAN_PHY_MAX_SUPPORT_CARRIER_NUM];
}LRRC_WRRC_CELL_SRCH_REQ_STRU;

/*****************************************************************************
 ṹ    : WRRC_LRRC_CELL_SRCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    /* ҵָפģʽUTRAСʱʹLRRC_GURRC_CELL_RESEL_SUCC
       ûҵָפģʽUTRAСʱʹLRRC_GURRC_CELL_RESEL_UNSPECIFIC */
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* ָפģʽפUTRAСϢ */
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usPrimaryCode;

    /* stSuitablePlmnIdstPlmnIdListϢֻפģʽΪsuitableʱ壬
       פģʽΪany cellʱʱԲ */

    /* enRslt = LRRC_GURRC_CELL_RESEL_SUCC дԭ
       UTRA CELLЯPLMN LISTУRPLMNдRPLMNѡ
       һPLMN Ϣ*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stSuitablePlmnId;

    /* enRslt = LRRC_GURRC_CELL_RESEL_UNSPECIFIC Яڴ˹
       еPLMN ϢԸߵ򴫵ݸLRRC׼ͬ
       PLMN LIST  */
    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}WRRC_LRRC_CELL_SRCH_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CELL_SRCH_STOP_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾWRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_CELL_SRCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_CELL_SRCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_CELL_SRCH_STOP_CNF_STRU;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    :   LRRC_WRRC_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾW RRCִб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32              enMsgId;                        /*_H2ASN_Skip*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                stPlmnId;
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8           enSearchType;                   /* LRRC֪ͨGUѻPLMN LIST */
    VOS_UINT8                                   aucReserved[1];

    VOS_UINT16                                  usForbLaNum;                    /* ֹעĸ */
    LRRC_GURRC_FORB_LA_STRU                     astForbLaList[LRRC_GURRC_MAX_FORBLA_NUM];
                                                                                /* ֹעб */
}LRRC_WRRC_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCִбõȷ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT8                                               aucReserved[2];
}WRRC_LRRC_BG_PLMN_SEARCH_CNF_STRU;


/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_PLMN_SEARCH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCִбĽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;       /* LRRC֪ͨGUѻPLMN LIST */
    VOS_UINT8                                               aucReserved[1];

    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}WRRC_LRRC_BG_PLMN_SEARCH_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_BG_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_BG_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_SEARCH_SUSPEND_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾWRRC𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_BG_SEARCH_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCѹ𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_SEARCH_RESUME_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾWRRCָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_BG_SEARCH_RESUME_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_RESUME_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCѻָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_BG_SEARCH_RESUME_CNF_STRU;
#else
/*****************************************************************************
 ṹ    :   LRRC_GURRC_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾGU RRCִб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32              enMsgId;                        /*_H2ASN_Skip*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                stPlmnId;
    LRRC_GURRC_SEARCH_RAT_ENUM_UINT8            enSearchRat;                    /* ָʾWG */
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8           enSearchType;                   /* LRRC֪ͨGUѻPLMN LIST */

    VOS_UINT16                                  usForbLaNum;                    /* ֹעĸ */
    LRRC_GURRC_FORB_LA_STRU                     astForbLaList[LRRC_GURRC_MAX_FORBLA_NUM];
                                                                                /* ֹעб */
}LRRC_GURRC_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BG_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCִбõȷ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT8                                               aucReserved[2];
}GURRC_LRRC_BG_PLMN_SEARCH_CNF_STRU;


/*****************************************************************************
 ṹ    :    GURRC_LRRC_BG_PLMN_SEARCH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCִбĽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    LRRC_GURRC_SEARCH_RAT_ENUM_UINT8                        enSearchRat;        /* ָʾWG */
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;       /* LRRC֪ͨGUѻPLMN LIST */

    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}GURRC_LRRC_BG_PLMN_SEARCH_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_BG_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGURRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GURRC_BG_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BG_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GURRC_LRRC_BG_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_BG_SEARCH_SUSPEND_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾGURRC𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GURRC_BG_SEARCH_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCѹ𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GURRC_LRRC_BG_SEARCH_SUSPEND_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_BG_SEARCH_RESUME_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾGURRCָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GURRC_BG_SEARCH_RESUME_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_BG_SEARCH_RESUME_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCѻָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GURRC_LRRC_BG_SEARCH_RESUME_CNF_STRU;
#endif
/*****************************************************************************
 ṹ    :   WRRC_LRRC_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  WRRCָʾLRRCִб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32              enMsgId;                        /*_H2ASN_Skip*/

    LRRC_GURRC_PLMN_ID_INFO_STRU                stPlmnId;

    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8           enSearchType;                   /* ѻPLMN LIST */

    VOS_UINT8                                   aucRsv1[3];
}WRRC_LRRC_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCִбȷ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT8                                               aucRsv1[2];
}LRRC_WRRC_BG_PLMN_SEARCH_CNF_STRU;


/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_PLMN_SEARCH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCִбĽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;       /* ѻPLMN LIST */
    VOS_UINT8                                               aucRsv1[1];

    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}LRRC_WRRC_BG_PLMN_SEARCH_IND_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCָʾLRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_BG_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_SEARCH_REL_STOP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                         enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}LRRC_WRRC_BG_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_SUSPEND_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCָʾLRRC𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_BG_SEARCH_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_BG_SEARCH_SUSPEND_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCѹ𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_BG_SEARCH_SUSPEND_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_BG_SEARCH_RESUME_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WRRCָʾLRRCָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                         enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}WRRC_LRRC_BG_SEARCH_RESUME_REQ_STRU;

/*****************************************************************************
 ṹ    :   LRRC_WRRC_BG_SEARCH_RESUME_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾWRRCѻָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                         enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}LRRC_WRRC_BG_SEARCH_RESUME_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_GET_W_CGI_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCȡӦСCGIϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usPrimaryCode;
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_GET_W_CGI_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_CGI_INFO_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  UTRAN CGIϢ
*****************************************************************************/
typedef struct
{
    VOS_INT16                                               sRscp;              /* 1/8 */
    VOS_INT16                                               sEcN0;              /* 1/8 */
    LRRC_GURRC_CELL_GLOBAL_ID_STRU                          stCellGlobalId;
    VOS_UINT16                                              usPlmnCnt;
    VOS_UINT8                                               aucReserved1[2];
    LRRC_GURRC_PLMN_ID_INFO_STRU                            astPlmnIdList[LRRC_WRRC_MAX_NUM_OF_PLMN_ID_LIST_2];

    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enLacPresent;
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enRacPresent;
    VOS_UINT16                                              usLocAreaCode;
    VOS_UINT8                                               ucRoutingAreaCode;
    VOS_UINT8                                               aucReserved[3];
}LRRC_WRRC_CGI_INFO_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GET_W_CGI_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCӦСCGIϢȡý
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;
}WRRC_LRRC_GET_W_CGI_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GET_W_CGI_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCӦСCGIϢȡ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;

    LRRC_WRRC_CGI_INFO_MEAS_RESULT_STRU                     stCgiInfo;
}WRRC_LRRC_GET_W_CGI_IND_STRU;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ    :    LRRC_WRRC_GET_CGI_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾWRRCֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_WRRC_GET_CGI_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GET_CGI_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}WRRC_LRRC_GET_CGI_STOP_CNF_STRU;
#else
/*****************************************************************************
 ṹ    :    LRRC_WRRC_GET_G_CGI_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCȡӦGSMСCGIϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GERAN_CELL_INFO_STRU                         stGeranCellInfo;
}LRRC_WRRC_GET_G_CGI_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_GLOBAL_ID_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GERAN CELL GLOBAL IDϢ
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stPlmnId;
    VOS_UINT16                                              usLocAreaCode;
    VOS_UINT16                                              usCellId;
}LRRC_WRRC_G_CELL_GLOBAL_ID_STRU;

/*****************************************************************************
 ṹ    :    LRRC_WRRC_G_CGI_INFO_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GERAN CGIϢ
*****************************************************************************/
typedef struct
{
    LRRC_WRRC_G_CELL_GLOBAL_ID_STRU                         stGsmCellGlobalId;
    VOS_INT16                                               sRssi;/* RSSIֵ ,ȡֵΧ[-110*8,-20*8], λ:dBm 1/8 */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enRacPresent;
    VOS_UINT8                                               ucRoutingAreaCode;
}LRRC_WRRC_G_CGI_INFO_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    :  WRRC_LRRC_GET_G_CGI_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  WRRCָʾLRRCӦGSMСCGIϢȡý
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;
}WRRC_LRRC_GET_G_CGI_CNF_STRU;

/*****************************************************************************
 ṹ    :    WRRC_LRRC_GET_G_CGI_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   WRRCָʾLRRCӦGSMСCGIϢȡ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;

    LRRC_WRRC_G_CGI_INFO_MEAS_RESULT_STRU                   stGsmCgiInfo;
}WRRC_LRRC_GET_G_CGI_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_GET_CGI_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGURRCֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GURRC_GET_CGI_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GURRC_LRRC_GET_CGI_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GURRCָʾLRRCֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GURRC_LRRC_GET_CGI_STOP_CNF_STRU;
#endif

/*****************************************************************************
 ṹ    : LRRC_WRRC_MSG_DATA
 Э  :
 ASN.1 :
 ṹ˵  : LRRC_WRRC_MSG_DATAݽṹASNļ
*****************************************************************************/
typedef struct
{
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_MsgChoice_Export LRRC_WRRC_MSG_TYPE_ENUM_UINT32 */
    VOS_UINT8                                               aucMsg[4];
    /***************************************************************************
        _H2ASN_MsgChoice_When_Comment          LRRC_WRRC_MSG_TYPE_ENUM_UINT32
    ****************************************************************************/
}LRRC_WRRC_MSG_DATA;

/*_H2ASN_Length UINT32*/

/*****************************************************************************
 ṹ    : LRRCWRRCInterface_MSG
 Э  :
 ASN.1 :
 ṹ˵  : LRRCWRRCInterface_MSGݽṹ,ASNļ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    LRRC_WRRC_MSG_DATA                                      stMsgData;
}LRrcWRrcInterface_MSG;

/*****************************************************************************
 ṹ    : LRRC_WRRC_CAMP_PLMN_INFO_NFT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾWRRCǰפ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32        enMsgId;                /*_H2ASN_Skip*/
    LRRC_GURRC_PLMN_ID_INFO_STRU          stPlmnIdInfo;
}LRRC_WRRC_CAMP_PLMN_INFO_NTF_STRU;

/*****************************************************************************
 ṹ    : LRRC_WRRC_AREA_LOST_NFT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾWRRCǰLRRC
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                           /*_H2ASN_Skip*/
    LRRC_WRRC_MSG_TYPE_ENUM_UINT32        enMsgId;           /*_H2ASN_Skip*/
    VOS_UINT8                             aucResrved[4];
}LRRC_WRRC_AREA_LOST_NTF_STRU;

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/





#if (VOS_OS_VER != VOS_WIN32)
 #pragma pack()
#else
 #pragma pack(pop)
#endif

#ifdef __cplusplus
 #if __cplusplus
}
 #endif
#endif

#endif /* end of LRRC_WRRCInterface.h */

