/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : LRrcTRrcInterface.h
  Description     : LTE RRCTDS RRC֮ӿļ
  History         :
      1.x49630       2011-9-14   Draft Enact

******************************************************************************/

#ifndef __LRRCTRRCINTERFACE_H__
#define __LRRCTRRCINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include  "vos.h"
#include  "LPSCommon.h"
#include  "LRrcGuRrcCommInterface.h"
#include  "LRrcWRrcInterface.h"

/*****************************************************************************
  #pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 Macro
*****************************************************************************/

#define LRRC_TRRC_MSG_HDR                (PS_MSG_ID_LRRC_TO_TRRC_BASE)
#define TRRC_LRRC_MSG_HDR                (PS_MSG_ID_TRRC_TO_LRRC_BASE)

/* UTRAN TDD UE 󳤶*/
/* gaojishan-DTS2012101801814 */
#define LRRC_TRRC_UE_CAP_UTRAN_MAX_LEN                      256


/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
/*****************************************************************************
 ö    :
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum LRRC_TRRC_MSG_TYPE_ENUM
{
    /* T -> L Cell Resel */
    ID_TRRC_LRRC_CELL_RESEL_REQ             = (TRRC_LRRC_MSG_HDR + 0x00),       /* _H2ASN_MsgChoice TRRC_LRRC_CELL_RESEL_REQ_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_CELL_RESEL_CNF             = (LRRC_TRRC_MSG_HDR + 0x00),       /* _H2ASN_MsgChoice LRRC_TRRC_CELL_RESEL_CNF_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_CELL_RESEL_STOP_REQ        = (TRRC_LRRC_MSG_HDR + 0x01),       /* _H2ASN_MsgChoice TRRC_LRRC_CELL_RESEL_STOP_REQ_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_CELL_RESEL_STOP_CNF        = (LRRC_TRRC_MSG_HDR + 0x01),       /* _H2ASN_MsgChoice LRRC_TRRC_CELL_RESEL_STOP_CNF_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L Redirect */
    ID_TRRC_LRRC_REDIRECTED_REQ             = (TRRC_LRRC_MSG_HDR + 0x02),       /* _H2ASN_MsgChoice TRRC_LRRC_REDIRECTED_REQ_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_REDIRECTED_CNF             = (LRRC_TRRC_MSG_HDR + 0x02),       /* _H2ASN_MsgChoice LRRC_TRRC_REDIRECTED_CNF_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_REDIRECTED_STOP_REQ        = (TRRC_LRRC_MSG_HDR + 0x03),       /* _H2ASN_MsgChoice TRRC_LRRC_REDIRECTED_STOP_REQ_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_REDIRECTED_STOP_CNF        = (LRRC_TRRC_MSG_HDR + 0x03),       /* _H2ASN_MsgChoice LRRC_TRRC_REDIRECTED_STOP_CNF_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L HO */
    ID_TRRC_LRRC_HANDOVER_REQ               = (TRRC_LRRC_MSG_HDR + 0x04),       /* _H2ASN_MsgChoice TRRC_LRRC_HANDOVER_REQ_STRU */          /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_HANDOVER_CNF               = (LRRC_TRRC_MSG_HDR + 0x04),       /* _H2ASN_MsgChoice LRRC_TRRC_HANDOVER_CNF_STRU */          /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_HANDOVER_STOP_REQ          = (TRRC_LRRC_MSG_HDR + 0x05),       /* _H2ASN_MsgChoice TRRC_LRRC_HANDOVER_STOP_REQ_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_HANDOVER_STOP_CNF          = (LRRC_TRRC_MSG_HDR + 0x05),       /* _H2ASN_MsgChoice LRRC_TRRC_HANDOVER_STOP_CNF_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L ͹ */
    ID_TRRC_LRRC_SET_DSP_POWER_REQ          = (TRRC_LRRC_MSG_HDR + 0x06),       /* _H2ASN_MsgChoice TRRC_LRRC_SET_DSP_POWER_REQ_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_SET_DSP_POWER_CNF          = (LRRC_TRRC_MSG_HDR + 0x06),       /* _H2ASN_MsgChoice LRRC_TRRC_SET_DSP_POWER_CNF_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L Get Ue Capability Info */
    ID_TRRC_LRRC_GETUECAPINFO_REQ           = (TRRC_LRRC_MSG_HDR + 0x07),       /* _H2ASN_MsgChoice TRRC_LRRC_GETUECAPINFO_REQ_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_GETUECAPINFO_CNF           = (LRRC_TRRC_MSG_HDR + 0x07),       /* _H2ASN_MsgChoice LRRC_TRRC_GETUECAPINFO_CNF_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L PLMN SEARCH */
    ID_TRRC_LRRC_PLMN_SEARCH_REQ            = (TRRC_LRRC_MSG_HDR + 0x08),       /* _H2ASN_MsgChoice TRRC_LRRC_PLMN_SEARCH_REQ_STRU */       /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_PLMN_SEARCH_CNF            = (LRRC_TRRC_MSG_HDR + 0x08),       /* _H2ASN_MsgChoice LRRC_TRRC_PLMN_SEARCH_CNF_STRU */       /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_PLMN_SEARCH_STOP_REQ       = (TRRC_LRRC_MSG_HDR + 0x09),       /* _H2ASN_MsgChoice TRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU */  /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_PLMN_SEARCH_STOP_CNF       = (LRRC_TRRC_MSG_HDR + 0x09),       /* _H2ASN_MsgChoice LRRC_TRRC_PLMN_SEARCH_STOP_CNF_STRU */  /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* T -> L Idle Meas */
    ID_TRRC_LRRC_IDLE_MEASURE_REQ           = (TRRC_LRRC_MSG_HDR + 0x0a),       /* _H2ASN_MsgChoice TRRC_LRRC_IDLE_MEASURE_REQ_STRU */      /* SendPid:WUEPS_PID_WCOM; RcvPid:PS_PID_ERMM */
    ID_LRRC_TRRC_IDLE_MEASURE_CNF           = (LRRC_TRRC_MSG_HDR + 0x0a),       /* _H2ASN_MsgChoice LRRC_TRRC_IDLE_MEASURE_CNF_STRU */      /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */
    ID_LRRC_TRRC_IDLE_MEASURE_IND           = (LRRC_TRRC_MSG_HDR + 0x0b),       /* _H2ASN_MsgChoice LRRC_TRRC_IDLE_MEASURE_IND_STRU */      /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */

    /* T -> L Conn Meas */
    ID_TRRC_LRRC_CONNECTED_MEASURE_REQ      = (TRRC_LRRC_MSG_HDR + 0x0b),       /* _H2ASN_MsgChoice TRRC_LRRC_CONNECTED_MEASURE_REQ_STRU */ /* SendPid:WUEPS_PID_WCOM; RcvPid:PS_PID_ERMM */
    ID_LRRC_TRRC_CONNECTED_MEASURE_CNF      = (LRRC_TRRC_MSG_HDR + 0x0c),       /* _H2ASN_MsgChoice LRRC_TRRC_CONNECTED_MEASURE_CNF_STRU */ /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */
    ID_LRRC_TRRC_CONNECTED_MEASURE_IND      = (LRRC_TRRC_MSG_HDR + 0x0d),       /* _H2ASN_MsgChoice LRRC_TRRC_CONNECTED_MEASURE_IND_STRU */ /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WCOM */

    /* T -> L RelAll */
    ID_TRRC_LRRC_RELALL_REQ                 = (TRRC_LRRC_MSG_HDR + 0x0c),       /* _H2ASN_MsgChoice TRRC_LRRC_RELALL_REQ_STRU */            /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_RELALL_CNF                 = (LRRC_TRRC_MSG_HDR + 0x0e),       /* _H2ASN_MsgChoice LRRC_TRRC_RELALL_CNF_STRU */            /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */

    /* L -> T Cell Resel*/
    ID_LRRC_TRRC_CELL_RESEL_REQ             = (LRRC_TRRC_MSG_HDR + 0x0f),       /* _H2ASN_MsgChoice LRRC_TRRC_CELL_RESEL_REQ_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_CELL_RESEL_CNF             = (TRRC_LRRC_MSG_HDR + 0x0d),       /* _H2ASN_MsgChoice TRRC_LRRC_CELL_RESEL_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_CELL_RESEL_STOP_REQ        = (LRRC_TRRC_MSG_HDR + 0x10),       /* _H2ASN_MsgChoice LRRC_TRRC_CELL_RESEL_STOP_REQ_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_CELL_RESEL_STOP_CNF        = (TRRC_LRRC_MSG_HDR + 0x0e),       /* _H2ASN_MsgChoice TRRC_LRRC_CELL_RESEL_STOP_CNF_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> T Redirect */
    ID_LRRC_TRRC_REDIRECTED_REQ             = (LRRC_TRRC_MSG_HDR + 0x11),       /* _H2ASN_MsgChoice LRRC_TRRC_REDIRECTED_REQ_STRU */        /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_REDIRECTED_CNF             = (TRRC_LRRC_MSG_HDR + 0x0f),       /* _H2ASN_MsgChoice TRRC_LRRC_REDIRECTED_CNF_STRU */        /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_REDIRECTED_STOP_REQ        = (LRRC_TRRC_MSG_HDR + 0x12),       /* _H2ASN_MsgChoice LRRC_TRRC_REDIRECTED_STOP_REQ_STRU */   /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_REDIRECTED_STOP_CNF        = (TRRC_LRRC_MSG_HDR + 0x10),       /* _H2ASN_MsgChoice TRRC_LRRC_REDIRECTED_STOP_CNF_STRU */   /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> T HO */
    ID_LRRC_TRRC_HANDOVER_REQ               = (LRRC_TRRC_MSG_HDR + 0x13),       /* _H2ASN_MsgChoice LRRC_TRRC_HANDOVER_REQ_STRU */          /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_HANDOVER_CNF               = (TRRC_LRRC_MSG_HDR + 0x11),       /* _H2ASN_MsgChoice TRRC_LRRC_HANDOVER_CNF_STRU */          /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */
    ID_LRRC_TRRC_HANDOVER_STOP_REQ          = (LRRC_TRRC_MSG_HDR + 0x14),       /* _H2ASN_MsgChoice LRRC_TRRC_HANDOVER_STOP_REQ_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_HANDOVER_STOP_CNF          = (TRRC_LRRC_MSG_HDR + 0x12),       /* _H2ASN_MsgChoice TRRC_LRRC_HANDOVER_STOP_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L -> T ͹ */
    ID_LRRC_TRRC_SET_DSP_POWER_REQ          = (LRRC_TRRC_MSG_HDR + 0x15),       /* _H2ASN_MsgChoice LRRC_TRRC_SET_DSP_POWER_REQ_STRU */     /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_SET_DSP_POWER_CNF          = (TRRC_LRRC_MSG_HDR + 0x13),       /* _H2ASN_MsgChoice TRRC_LRRC_SET_DSP_POWER_CNF_STRU */     /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L-> T Get Ue Capability Info */
    ID_LRRC_TRRC_GETUECAPINFO_REQ           = (LRRC_TRRC_MSG_HDR + 0x16),       /* _H2ASN_MsgChoice LRRC_TRRC_GETUECAPINFO_REQ_STRU */      /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_GETUECAPINFO_CNF           = (TRRC_LRRC_MSG_HDR + 0x14),       /* _H2ASN_MsgChoice TRRC_LRRC_GETUECAPINFO_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    /* L -> T Idle Meas */
    ID_LRRC_TRRC_IDLE_MEASURE_REQ           = (LRRC_TRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice LRRC_TRRC_IDLE_MEASURE_REQ_STRU */      /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_IDLE_MEASURE_CNF           = (TRRC_LRRC_MSG_HDR + 0x15),       /* _H2ASN_MsgChoice TRRC_LRRC_IDLE_MEASURE_CNF_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_TRRC_LRRC_IDLE_MEASURE_IND           = (TRRC_LRRC_MSG_HDR + 0x16),       /* _H2ASN_MsgChoice TRRC_LRRC_IDLE_MEASURE_IND_STRU */      /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> T Conn Meas */
    ID_LRRC_TRRC_CONNECTED_MEASURE_REQ      = (LRRC_TRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice LRRC_TRRC_CONNECTED_MEASURE_REQ_STRU */ /* SendPid:PS_PID_ERMM; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_CONNECTED_MEASURE_CNF      = (TRRC_LRRC_MSG_HDR + 0x17),       /* _H2ASN_MsgChoice TRRC_LRRC_CONNECTED_MEASURE_CNF_STRU */ /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */
    ID_TRRC_LRRC_CONNECTED_MEASURE_IND      = (TRRC_LRRC_MSG_HDR + 0x18),       /* _H2ASN_MsgChoice TRRC_LRRC_CONNECTED_MEASURE_IND_STRU */ /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERMM */

    /* L -> T RelAll */
    ID_LRRC_TRRC_RELALL_REQ                = (LRRC_TRRC_MSG_HDR + 0x19),        /* _H2ASN_MsgChoice LRRC_TRRC_RELALL_REQ_STRU */             /* SendPid:PS_PID_ERRC; RcvPid:WUEPS_PID_WRR */
    ID_TRRC_LRRC_RELALL_CNF                = (TRRC_LRRC_MSG_HDR + 0x19),        /* _H2ASN_MsgChoice TRRC_LRRC_RELALL_CNF_STRU */             /* SendPid:WUEPS_PID_WRR; RcvPid:PS_PID_ERRC */

    ID_LRRC_TRRC_MSG_TYPE_BUTT
};

typedef VOS_UINT32 LRRC_TRRC_MSG_TYPE_ENUM_UINT32;

/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
 ṹ    : TRRC_LRRC_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usCellId;
    LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                  enMeasBand;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}TRRC_LRRC_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч*/
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfoList;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}LRRC_TRRC_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_CELL_RESEL_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_REDIRECTED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    VOS_UINT8                                               aucReserve1[2];

    /* T->LضϢ */
    VOS_UINT16                                              usArfcnNum;
    WRRC_LRRC_ARFCN_INFO_STRU                               astRedirInfo[LRRC_GURRC_LTE_ARFCN_MAX_NUM];


    /* ͷʱָRRC CON REJ Яʱʣʱλ: */
    VOS_UINT16                                              usPunishTimerValue;

    /* REDIR INFO ָʾʱ λ:,Ŀǰ̶10000ms
       ڴʱָСֱӽСҪȵ˶ʱʱSUITABELEС
    ***************************************************************************/
    VOS_UINT16                                              usSearchTimer;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;   /* ̶ΪSUITABLE */
    VOS_UINT8                                               aucReserve2[2];

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}TRRC_LRRC_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_REDIRECTED_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}LRRC_TRRC_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_HANDOVER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    /* L֪ͨTǰפĹ */
    VOS_UINT8                                               aucMcc[3];
    VOS_UINT8                                               aucReserved[1];

    VOS_UINT32                                              ulHoDataLen;
    /* ΪRRC CONN RECFG */
    VOS_UINT8                                               aucHoData[4];
}TRRC_LRRC_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_HANDOVER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  LRRCTRRCָʾл̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}LRRC_TRRC_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  TRRCָʾLRRCDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}TRRC_LRRC_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCEDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}LRRC_TRRC_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_GETUECAPINFO_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  TRRCָʾLRRCṩUEϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usMcc;
    VOS_UINT8                                               aucReserved[2];
}TRRC_LRRC_GETUECAPINFO_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_GETUECAPINFO_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCUEȡ
 For EUTRA: the encoding of UE capabilities is defined in IE UE-EUTRA-Capability.
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT16                                              usDataLen;
    VOS_UINT8                                               aucEutranCapInfoData[LRRC_WRRC_UE_CAP_EUTRAN_MAX_LEN];
}LRRC_TRRC_GETUECAPINFO_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCPLMN SEARCH
                 UTRAN UE̬³̣
                 LRRCҪжϸСǷSUITABLE׼
                 ָPLMNһǲפ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[2];
    VOS_UINT16                                              usArfcnNum;
    WRRC_LRRC_ARFCN_INFO_STRU                               astArfcnInfo[LRRC_GURRC_LTE_ARFCN_MAX_NUM];
}TRRC_LRRC_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  LRRCTRRC PLMN SEARCH 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_WRRC_PLMN_SEARCH_RESULT_ENUM_UINT16                enPLmnSearchRslt;
    VOS_UINT8                                               aucReserved[2];

    /* usPLmnSearchResult =  LRRC_WRRC_PLMN_SEARCH_SUCC дԭ
       LTE CELLЯPLMN LISTУRPLMNдRPLMNѡ
       һPLMN Ϣ*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stSuitablePlmnId;

    /* usPLmnSearchResult =  LRRC_WRRC_PLMN_SEARCH_FAIL Яٴι
           еPLMN ϢԸߵ򴫵ݸWRRC׼ͬ
          PLMN LIST */
    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}LRRC_TRRC_PLMN_SEARCH_CNF_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :TRRCָʾLRRCֹͣPLMN SEARCH
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_PLMN_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_PLMN_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCֹͣPLMN SEARCH 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_PLMN_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stIdleEutranArfcnInfoList;
}TRRC_LRRC_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCTRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_TRRC_IDLE_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stMeasRslt;
}LRRC_TRRC_IDLE_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;

    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_WRRC_STATE_TYPE_ENUM_UINT16                        enTRrcStateType;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stConnEutranArfcnInfoList;
}TRRC_LRRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_TRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾCONNECTED 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stMeasRslt;
}LRRC_TRRC_CONNECTED_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_RELALL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  TRRCָʾLRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_RELALL_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_RELALL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾTRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_RELALL_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCTRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usPrimaryCode;

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT8                                               aucReserved[2];

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;
}LRRC_TRRC_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱ
    stPlmnIdInfo Ч,ΪСPLMN IDs Ϣ*/
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfoList;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}TRRC_LRRC_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾTRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_CELL_RESEL_STOP_CNF_STRU;

/* v7r2 code begin */

/*****************************************************************************
 ṹ    : LRRC_GURRC_REDIR_CELL_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  : ضЯСϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usPrimaryCode;
    VOS_UINT16                                              usArfcn;
    VOS_UINT8                                               aucReserved[2];
    VOS_UINT16                                              usSysInfoLen;
    VOS_UINT8                                               aucData[LRRC_WRRC_UTRAN_BCCH_CONTAINER_MAX_BYTE_LEN];
}LRRC_TRRC_REDIR_CELL_INFO_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_REDIR_INFO_LIST_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCضϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcnNum;
    VOS_UINT16                                              usCellInfoNum;
    VOS_UINT16                                              ausArfcn[LRRC_TRRC_REDIR_FREQ_MAX_MUN];
    LRRC_TRRC_REDIR_CELL_INFO_STRU                          astCellInfo[LRRC_WRRC_REDIR_CELL_MAX_MUN];
}LRRC_TRRC_REDIR_INFO_LIST_STRU;
/* v7r2 code end */

/*****************************************************************************
 ṹ    : LRRC_TRRC_REDIRECTED_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCTRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    /* v7r2 code begin */
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT8                                               aucReserved[2];

    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;      /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_TRRC_REDIR_INFO_LIST_STRU                          stRedirInfoList;    /* СϢ */
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;             /* רȼϢ */
    #if 0
    VOS_UINT16                                              usArfcn;
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    VOS_UINT8                                               aucReserved[3];

    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enRedirCellInfoPresent; /* ضСϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;      /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_REDIR_CELL_INFO_LIST_STRU                    stRedirCellInfoList;    /* СϢ */
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stDPriInfo;             /* רȼϢ */
    #endif
    /* v7r2 code end */
}LRRC_TRRC_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_REDIRECTED_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}TRRC_LRRC_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾTRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :  LRRC_TRRC_HANDOVER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾTRRCHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/

    /* CSFB ־,1:ʾCSFB, 0: ʾCSFB */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enCsfbInd;
    VOS_UINT8                                               aucReserved[1];

    VOS_UINT16                                              usHoDatalen;
    VOS_UINT8                                               aucHoData[4];       /*  HANDOVER TO UTRAN COMMAND */
}LRRC_TRRC_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_HANDOVER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  TRRCLRRCָʾл̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}TRRC_LRRC_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾTRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾTRRCDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}LRRC_TRRC_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCEDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}TRRC_LRRC_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_GETUECAPINFO_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾTRRCṩUEϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usMcc;
    VOS_UINT8                                               aucReserved[2];
}LRRC_TRRC_GETUECAPINFO_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_GETUECAPINFO_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCUEȡ
 For UTRA: the octet string contains the INTER RAT HANDOVER INFO message defined in TS 25.331 [19].
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT16                                              usDataLen;
    VOS_UINT8                                               aucUtranCapInfoData[LRRC_TRRC_UE_CAP_UTRAN_MAX_LEN];
}TRRC_LRRC_GETUECAPINFO_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_TRRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU                    stUtranCellInfoList;
}LRRC_TRRC_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : TRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}TRRC_LRRC_IDLE_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU                   stUtranMeasResult;
}TRRC_LRRC_IDLE_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TRRCLRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    LRRC_GURRC_UTRAN_CELL_INFO_LIST_STRU                    stUtranCellInfoList;
}LRRC_TRRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}TRRC_LRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : TRRC_LRRC_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCTRRCָʾCONNECTED 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;
    VOS_UINT8                                               aucReserved[2];
    GURRC_LRRC_UTRAN_MEAS_RESULT_IND_STRU                   stUtranMeasResult;
}TRRC_LRRC_CONNECTED_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_TRRC_RELALL_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾTRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_TRRC_RELALL_REQ_STRU;

/*****************************************************************************
 ṹ    :    TRRC_LRRC_RELALL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   TRRCָʾLRRCִRelAll
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}TRRC_LRRC_RELALL_CNF_STRU;


/*****************************************************************************
 ṹ    : LRRC_TRRC_MSG_DATA
 Э  :
 ASN.1 :
 ṹ˵  : LRRC_TRRC_MSG_DATAݽṹASNļ
*****************************************************************************/
typedef struct
{
    LRRC_TRRC_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_MsgChoice_Export LRRC_TRRC_MSG_TYPE_ENUM_UINT32 */
    VOS_UINT8                                               aucMsg[4];
    /***************************************************************************
        _H2ASN_MsgChoice_When_Comment          LRRC_TRRC_MSG_TYPE_ENUM_UINT32
    ****************************************************************************/
}LRRC_TRRC_MSG_DATA;

/*_H2ASN_Length UINT32*/

/*****************************************************************************
 ṹ    : LRRC_TRRCInterface_MSG
 Э  :
 ASN.1 :
 ṹ˵  : LRRC_TRRCInterface_MSGݽṹ,ASNļ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    LRRC_TRRC_MSG_DATA                                      stMsgData;
}LRrcTRrcInterface_MSG;

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/





#if (VOS_OS_VER != VOS_WIN32)
 #pragma pack()
#else
 #pragma pack(pop)
#endif

#ifdef __cplusplus
 #if __cplusplus
}
 #endif
#endif

#endif /* end of LRRC_TRRCInterface.h */


