/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : LRrcGuRrcCommInterface.h
  Description     : LTE&GU RRCģ鹫Ϣͷļ
  History         :
      1.liutao 38432       2010-12-30   Draft Enact
	  2.wangyue 151278     2011-12-22 DTS2011121902767:L2Gѡӿ޸ģֵ
******************************************************************************/

#ifndef __LRRC_GURRCCOMMINTERFACE_H__
#define __LRRC_GURRCCOMMINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include  "vos.h"

/*****************************************************************************
  #pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif


/*****************************************************************************
  2 Macro
*****************************************************************************/
/* 3GPP ЭϹ涨EUTRANƵ */
#define LRRC_GURRC_LTE_ARFCN_MAX_NUM                        8

/* UEֵ֧EUTRANƵĿ */
/* Begin: add inter meas ferq num */
/* UEֵ֧EUTRANƵĿ */
#define LRRC_GURRC_LTE_PHY_MAX_SUPPORT_CARRIER_NUM          6
/* End: add inter meas ferq num */

/* EUTRAN Ƶ֧СĿ */
#define LRRC_GURRC_MAX_LTE_CELL_PER_FREQ_NUM                32

/* EUTRAN Ƶֵ֧ĺСĿ*/
#define LRRC_GURRC_BLACK_LIST_CELL_MAX_NUM                  16

/* 3GPP ЭϹ涨UTRANƵ */
#define LRRC_GURRC_UTRAN_ARFCN_MAX_NUM                      16

/* UEֵ֧UTRANƵĿ */
#define LRRC_GURRC_UTRAN_PHY_MAX_SUPPORT_CARRIER_NUM        3

/* begin: for modify TDD max Meas Num  */
/* UEֵ֧UTRANƵĿ */
#define LRRC_TRRC_PHY_MAX_SUPPORT_CARRIER_NUM               9
/* end: for modify TDD max Meas Num  */

/* UTRAN Ƶ֧СĿ */
#define LRRC_GURRC_MAX_UTRAN_CELL_PER_FREQ_NUM              32

/* 3GPP ЭϹ涨GERANƵ */
#define LRRC_GURRC_GERAN_ARFCN_MAX_NUM                      32

/* LUE ֧BSIC VERFIED С*/
#define LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM              8

/* EUTRAN ֵ֧ GERAN ϵͳϢ*/
#define LRRC_GURRC_GERAN_SYS_MAX_NUM                        10

/* EUTRAN ֵ֧ GERAN ϵͳϢ󳤶 */
#define LRRC_GURRC_GERAN_SYS_MAX_LEN                        24

/* PLMN ʱPLMN  */
#define LRRC_GURRC_MAX_HIGH_PLMN_NUM                        16

/* PLMN ʱPLMN  */
#define LRRC_GURRC_MAX_LOW_PLMN_NUM                         16

/* EUTRANеСPLMN */
#define LRRC_GURRC_PLMN_ID_MAX_NUM                          6

/* UTRAN UE 󳤶*/
/* gaojishan-DTS2012101801814 */
#define LRRC_WRRC_UE_CAP_UTRAN_MAX_LEN                      256

/* EUTRAN UE 󳤶*/
/* gaojishan-DTS2012101801814 */
#define LRRC_WRRC_UE_CAP_EUTRAN_MAX_LEN                     256

/* GERAN CS UE 󳤶*/
#define LRRC_GRR_UE_CAP_GEREN_CS_MAX_LEN                    128

/* GERAN PS UE 󳤶*/
#define LRRC_GRR_UE_CAP_GEREN_PS_MAX_LEN                    128

/* LضʱUTRAN CELL  */
#define LRRC_WRRC_REDIR_CELL_MAX_MUN                        16
/* v7r2 code begin */
/* LضʱUTRAN FREQ  */
#define LRRC_TRRC_REDIR_FREQ_MAX_MUN                        6
/* v7r2 code end */

/* LضʱUTRAN CELL ϵͳϢ󳤶 */
#define LRRC_WRRC_UTRAN_BCCH_CONTAINER_MAX_BYTE_LEN         256


/* L CellReselCCOGʱĿGСûвֵӿõЧֵ */
#define LRRC_GRR_INVALID_CELL_RXLEV_VALUE                   0x00FF

#define LRRC_WRRC_MAX_NUM_OF_PLMN_ID_LIST_2                 5

#define LRRC_GURRC_MAX_FORBLA_NUM                           (16)

/* bgs begin */
/* FORBID TA  */
#define LRRC_GURRC_MAX_FORBTA_NUM                           (64)
/* bgs end */

/* EUTRAN רȼ */
#define LRRC_GURRC_EUTRAN_DEDICATED_PRI_MAX_NUM             (64)

/* UTRAN רȼ */
#define LRRC_GURRC_UTRAN_DEDICATED_PRI_MAX_NUM              (64)

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/

/*****************************************************************************
 ö    : LRRC_GURRC_MEAS_BAND_WIDTH_ENUM
 Э  :
 ASN.1 :
 ö˵  : ö()
*****************************************************************************/
enum LRRC_GURRC_MEAS_BAND_WIDTH_ENUM
{
    LRRC_GURRC_MEAS_BAND_WIDTH_6RB                          = 0,                /* Ϊ6RB   */
    LRRC_GURRC_MEAS_BAND_WIDTH_15RB                            ,                /* Ϊ15RB  */
    LRRC_GURRC_MEAS_BAND_WIDTH_25RB                            ,                /* Ϊ25RB  */
    LRRC_GURRC_MEAS_BAND_WIDTH_50RB                            ,                /* Ϊ50RB  */
    LRRC_GURRC_MEAS_BAND_WIDTH_75RB                            ,                /* Ϊ75RB  */
    LRRC_GURRC_MEAS_BAND_WIDTH_100RB                           ,                /* Ϊ100RB */

    LRRC_GURRC_MEAS_BAND_WIDTH_BUTT
};
typedef VOS_UINT16 LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16;

/*****************************************************************************
 ö     :LRRC_GRR_BANDINDICATOR_ENUM
 Э  :
 ASN.1   :
 ö˵ : 2GСƵָʾ
*****************************************************************************/
enum LRRC_GRR_BANDINDICATOR_ENUM
{
    LRRC_GRR_BANDINDICATOR_DCS1800                          = 0,
    LRRC_GRR_BANDINDICATOR_PCS1900                             ,

    LRRC_GRR_BANDINDICATOR_BUTT
};
typedef VOS_UINT16    LRRC_GRR_BANDINDICATOR_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM
 Э  :
 ASN.1   :
 ö˵  : Сפʽ
*****************************************************************************/
enum LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM
{
    LRRC_GURRC_CELL_CAMPEDON_SUITABLE                       = 0,                /* СפڷʽΪsuitable   */
    LRRC_GURRC_CELL_CAMPEDON_ANY_CELL                          ,                /* СפڷʽΪacceptable */

    LRRC_GURRC_CELL_CAMPEDON_TYPE_BUTT
};

typedef VOS_UINT8 LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ö    : LRRC_GRR_RELALL_REASON_ENUM_UINT8
 Э  :
 ASN.1   :
 ö˵  : LRRCͷԭ
*****************************************************************************/
enum LRRC_GRR_RELALL_REASON_ENUM
{
    LRRC_GRR_REL_REASON_OTHER                             = 0,
    LRRC_GRR_REL_REASON_TO_GSM                               ,                  /* LTEͷŵԭΪLTEлCCOGSM */

    LRRC_GRR_REL_REASON_BUTT
};
typedef VOS_UINT8 LRRC_GRR_RELALL_REASON_ENUM_UINT8;
#else
/*****************************************************************************
 ö    : LRRC_GURRC_RELALL_REASON_ENUM
 Э  :
 ASN.1   :
 ö˵  : LRRCͷԭ
*****************************************************************************/
enum LRRC_GURRC_RELALL_REASON_ENUM
{
    LRRC_GURRC_REL_REASON_OTHER                             = 0,
    LRRC_GURRC_REL_REASON_TO_GSM                               ,                  /* LTEͷŵԭΪLTEлCCOGSM */

    LRRC_GURRC_REL_REASON_BUTT
};
typedef VOS_UINT8 LRRC_GURRC_RELALL_REASON_ENUM_UINT8;
#endif

/*****************************************************************************
 ö     :LRRC_GURRC_VALID_FLAG_ENUM
 Э  :
 ASN.1   :
 ö˵ : ͨǷڱ־
*****************************************************************************/
enum LRRC_GURRC_VALID_FLAG_ENUM
{
    LRRC_GURRC_FLAG_INVALID                                 = 0,
    LRRC_GURRC_FLAG_VALID                                      ,

    LRRC_GURRC_FLAG_BUTT
};
typedef VOS_UINT8    LRRC_GURRC_VALID_FLAG_ENUM_UINT8;

/*****************************************************************************
 ö    : LRRC_GURRC_CELL_RESEL_RESULT_ENUM
 Э  :
	 44060-8.4.2
	 Access is denied in the new cell (i.e., the mobile station receives an
	 IMMEDIATE ASSIGNMENT REJECT, a PACKET ASSIGNMENT REJECT or, in a UTRAN
	 cell, an RRC CONNECTION REJECT message or fails to establish an RRC
	 connection in an E-UTRAN cell as specified in 3GPP TS 36.331).
	 Cause: "Immediate Assign Reject or Packet Access Reject on target cell";
 ASN.1 :
 ö˵  : GULTE֮CELL RESEL
*****************************************************************************/
enum LRRC_GURRC_CELL_RESEL_RESULT_ENUM
{
    LRRC_GURRC_CELL_RESEL_SUCC                              = 0,
    LRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL                         ,                /* ϵͳϢʧ */
    LRRC_GURRC_CELL_RESEL_CELL_BARRED                          ,                /* CELL BARRED */
    LRRC_GURRC_CELL_RESEL_CELL_FORBID                          ,                /* CELL  FORBID*/
    LRRC_GURRC_CELL_RESEL_NOT_EPLMNS                           ,                /* CELLЯPLMNϢûRPLMNEPLMNS */
    LRRC_GURRC_CELL_RESEL_ACCESS                               ,                /* CELL ACCESS  */
    LRRC_GURRC_CELL_RESEL_UNSPECIFIC                           ,                /* δĴ */
    LRRC_GURRC_CELL_RESEL_CONNECTION_REJECT                    ,                /* ָɱܻӱܣԭֵֻCCO */

    LRRC_GURRC_CELL_RESEL_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32;

/* CCOʧԭͬ CEL RESEL  */
typedef VOS_UINT32 LRRC_GURRC_CCO_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_HANDOVER_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮HANDOVER 
*****************************************************************************/
enum LRRC_GURRC_HANDOVER_RESULT_ENUM
{
    LRRC_GURRC_HANDOVER_RESULT_SUCC                         = 0,
    LRRC_GURRC_HANDOVER_RESULT_CONF_UNACCEPTABLE               ,                /* лò֧ */
    LRRC_GURRC_HANDOVER_RESULT_PHY_CHANNEL_FAIL                ,                /* physical channel failure  */
    LRRC_GURRC_HANDOVER_RESULT_IRAT_PROTOCOL_ERR               ,                /* inter-RAT protocol error */
    LRRC_GURRC_HANDOVER_RESULT_UNSPECIFIC,

    LRRC_GURRC_HANDOVER_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_CELL_RESEL_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮REDIRECTED
*****************************************************************************/
enum LRRC_GURRC_REDIRECTED_RESULT_ENUM
{
    LRRC_GURRC_REDIRECTED_SUCC                              = 0,
    LRRC_GURRC_REDIRECTED_FAIL                                 ,

    LRRC_GURRC_REDIRECTED_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GRR_SYS_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : CCOУָʾǷGERANϵͳϢ
*****************************************************************************/
enum LRRC_GRR_SYS_TYPE_ENUM
{
    LRRC_GRR_SYS_TYPE_NOT_EXIST                             = 0,
    LRRC_GRR_SYS_TYPE_SI                                       ,
    LRRC_GRR_SYS_TYPE_PSI                                      ,

    LRRC_GRR_SYS_TYPE_BUTT
};

typedef VOS_UINT8   LRRC_GRR_SYS_TYPE_ENUM_UINT8;

/*****************************************************************************
 ö    : LRRC_GURRC_SET_DSP_POWER_CMD_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮DSPʡģʽ
*****************************************************************************/
enum LRRC_GURRC_SET_DSP_POWER_CMD_ENUM
{
    LRRC_GURRC_SET_DSP_POWER_OPEN                           = 0,
    LRRC_GURRC_SET_DSP_POWER_CLOSE                             ,

    LRRC_GURRC_SET_DSP_POWER_TYPE_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮DSPʡģʽ
*****************************************************************************/
enum LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM
{
    LRRC_GURRC_SET_DSP_POWER_SUCC                           = 0,
    LRRC_GURRC_SET_DSP_POWER_FAIL                              ,

    LRRC_GURRC_SET_DSP_POWER_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_WRRC_PLMN_SEARCH_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : LTE PLMN
*****************************************************************************/
enum LRRC_WRRC_PLMN_SEARCH_RESULT_ENUM
{
    LRRC_WRRC_PLMN_SEARCH_SUCC                              = 0,
    LRRC_WRRC_PLMN_SEARCH_FAIL                                 ,

    LRRC_WRRC_PLMN_SEARCH_RESULT_BUTT
};

typedef VOS_UINT16 LRRC_WRRC_PLMN_SEARCH_RESULT_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_GURRC_MEAS_CMD_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮MEAS 
*****************************************************************************/
enum LRRC_GURRC_MEAS_CMD_ENUM
{
    LRRC_GURRC_MEAS_CMD_RELEASE                             = 0,
    LRRC_GURRC_MEAS_CMD_SETUP                                  ,

    LRRC_GURRC_MEAS_CMD_BUTT
};

typedef VOS_UINT16 LRRC_GURRC_MEAS_CMD_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_GURRC_MEAS_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮MEAS CMD 
*****************************************************************************/
enum LRRC_GURRC_MEAS_RESULT_ENUM
{
    LRRC_GURRC_MEAS_RESULT_SUCC                             = 0,
    LRRC_GURRC_MEAS_RESULT_FAIL                                ,

    LRRC_GURRC_MEAS_RESULT_BUTT
};

typedef VOS_UINT32  LRRC_GURRC_MEAS_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_GET_UECAP_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮UE CAPȡ
*****************************************************************************/
enum LRRC_GURRC_GET_UECAP_RESULT_ENUM
{
    LRRC_GURRC_GET_UECAP_SUCC                               = 0,
    LRRC_GURRC_GET_UECAP_FAIL                                  ,

    LRRC_GURRC_GET_UECAP_RESULT_BUTT
};

typedef VOS_UINT16 LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_GURRC_MEAS_IRAT_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮IRAT
*****************************************************************************/
enum LRRC_GURRC_MEAS_IRAT_TYPE_ENUM
{
    LRRC_GURRC_MEAS_IRAT_TYPE_GERAN                         = 0,
    LRRC_GURRC_MEAS_IRAT_TYPE_UTRAN                            ,

    LRRC_GURRC_MEAS_IRAT_TYPE_BUTT
};

typedef VOS_UINT16 LRRC_GURRC_MEAS_IRAT_TYPE_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_WRRC_STATE_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : WRRCǰ״̬̬ͣ
                            CELL_PCH/URA_PCH: WRRCָʾERRC IDLE̬
                            CELL_FACH/CELL_DCH: WRRCָʾERRC ̬
*****************************************************************************/
enum LRRC_WRRC_STATE_TYPE_ENUM
{
    LRRC_WRRC_STATE_TYPE_CELL_PCH                           = 0,
    LRRC_WRRC_STATE_TYPE_URA_PCH                               ,
    LRRC_WRRC_STATE_TYPE_CELL_FACH                             ,
    LRRC_WRRC_STATE_TYPE_CELL_DCH                              ,

    LRRC_WRRC_STATE_TYPE_BUTT
};

typedef VOS_UINT16 LRRC_WRRC_STATE_TYPE_ENUM_UINT16;

/*****************************************************************************
 ö    : LRRC_GURRC_VERIFY_TIME_INDEX_ENUM
 Э  :
 ASN.1 :
 ö˵  : LRRC֪ͨGURRCGSM BSICʼȷϺȷϵʱ

 ̬ȡֵ:

    index  Number of carriers  Tidentify,gsm  Treconfirm,gsm  Gap configuration
            other than GSM         (ms)            (ms)
   -----------------------------------------------------------------------------
     0            0               2160           1920
     1            1               5280           5040
     2            2               5280           5040            40ms (ID 0)
     3            3               19440          13320
     4            4               31680          29280
     5            5               31680          29280
   -----------------------------------------------------------------------------
     6            0               5280           5040
     7            1               21760          17280           80ms (ID 1)
     8            2               31680          29280

̬ȡֵ:

    index  DRX cycle length  Tidentify,gsm
                 (s)              (ms)
   ------------------------------------------
     0           0.32             360
     1           0.64             360
     2           1.28             180
     3           2.56             180

*****************************************************************************/
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
enum LRRC_GRR_VERIFY_TIME_INDEX_ENUM
{
    LRRC_GRR_VERIFY_TIME_INDEX_0                          = 0,
    LRRC_GRR_VERIFY_TIME_INDEX_1                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_2                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_3                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_4                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_5                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_6                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_7                             ,
    LRRC_GRR_VERIFY_TIME_INDEX_8                             ,

    LRRC_GRR_VERIFY_TIME_INDEX_BUTT
};

typedef VOS_UINT16 LRRC_GRR_VERIFY_TIME_INDEX_ENUM_UINT16;
#else
enum LRRC_GURRC_VERIFY_TIME_INDEX_ENUM
{
    LRRC_GURRC_VERIFY_TIME_INDEX_0                          = 0,
    LRRC_GURRC_VERIFY_TIME_INDEX_1                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_2                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_3                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_4                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_5                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_6                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_7                             ,
    LRRC_GURRC_VERIFY_TIME_INDEX_8                             ,

    LRRC_GURRC_VERIFY_TIME_INDEX_BUTT
};

typedef VOS_UINT16 LRRC_GURRC_VERIFY_TIME_INDEX_ENUM_UINT16;
#endif
/*****************************************************************************
 ö    : LRRC_GURRC_LOAD_DSP_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : LTEWDSP
*****************************************************************************/
enum LRRC_GURRC_LOAD_DSP_RESULT_ENUM
{
    LRRC_GURRC_LOAD_DSP_RESULT_SUCC                         = 0,
    LRRC_GURRC_LOAD_DSP_RESULT_FAIL                            ,

    LRRC_GURRC_LOAD_DSP_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_LOAD_DSP_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_GET_CGI_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮CGIȡ
*****************************************************************************/
enum LRRC_GURRC_GET_CGI_RESULT_ENUM
{
    LRRC_GURRC_GET_CGI_RESULT_SUCC                          = 0,
    LRRC_GURRC_GET_CGI_RESULT_FAIL                             ,

    LRRC_GURRC_GET_CGI_RESULT_BUTT
};

typedef VOS_UINT32 LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32;

/*****************************************************************************
 ö    : LRRC_GURRC_BG_SEARCH_RESULT_ENUM
 Э  :
 ASN.1 :
 ö˵  : GULTE֮BG
*****************************************************************************/
enum LRRC_GURRC_BG_SEARCH_RESULT_ENUM
{
    LRRC_GURRC_BG_SEARCH_RESULT_SUCC                        = 0,
    LRRC_GURRC_BG_SEARCH_RESULT_FAIL                           ,
    LRRC_GURRC_BG_SEARCH_RESULT_ABNORMAL                       ,

    LRRC_GURRC_BG_SEARCH_RESULT_BUTT
};

typedef VOS_UINT16 LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16;

/*****************************************************************************
 ṹ    : LRRC_GURRC_SEARCH_TYPE_ENUM
 Э  :
 ASN.1 :
 ṹ˵  : ָʾͣBGPLMN LIST
*****************************************************************************/
enum LRRC_GURRC_SEARCH_TYPE_ENUM
{
    LRRC_GURRC_SEARCH_TYPE_BG                 = 0,                                    /* ֪ͨ */
    LRRC_GURRC_SEARCH_TYPE_PLMN_LIST             ,                                    /* ֪ͨPLMN LIST  */
    LRRC_GURRC_SEARCH_TYPE_BG_HIGH_RAT           ,
    LRRC_GURRC_SEARCH_TYPE_BUTT
};
typedef VOS_UINT8 LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8;

#if (FEATURE_ON != FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ö    : LRRC_GURRC_SEARCH_RAT_ENUM
 Э  :
 ASN.1 :
 ö˵  : ָʾRAT
*****************************************************************************/
enum LRRC_GURRC_SEARCH_RAT_ENUM
{
    LRRC_GURRC_SEARCH_WCDMA                               = 0,
    LRRC_GURRC_SEARCH_GSM                                    ,

    LRRC_GURRC_SEARCH_RAT_BUTT
};

typedef VOS_UINT8 LRRC_GURRC_SEARCH_RAT_ENUM_UINT8;
#endif

/* CMCC-BEGIN */
/*****************************************************************************
 ö    : LRRC_GURRC_REDIR_TYPE_ENUM
 Э  :
 ASN.1 :
 ö˵  : ضͣƵġUEִе
*****************************************************************************/
enum LRRC_GURRC_REDIR_TYPE_ENUM
{
    LRRC_GURRC_REDIR_TYPE_UE_AUTO                         = 0,
    LRRC_GURRC_REDIR_TYPE_NET_CTL                            ,
    LRRC_GURRC_REDIR_TYPE_BUTT
};

typedef VOS_UINT8 LRRC_GURRC_REDIR_TYPE_ENUM_UINT8;
/* CMCC-END */


/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
 ṹ    :LRRC_GRR_BSIC_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  :CELL BAIC InfoЭ36331 6.3.4
            usNcc(GSM Network Colour Code)  Χ:(0..7), 8 ʾЧֵ
            usBcc(GSM Base Station Colour Code)  Χ:(0..7) , 8 ʾЧֵ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usNcc;
    VOS_UINT16                                              usBcc;
}LRRC_GRR_BSIC_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_LTE_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LTEȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved[1];
}LRRC_GURRC_LTE_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_LTE_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LTEרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    LRRC_GURRC_LTE_PRI_INFO_STRU                            astLteDPriInfo[LRRC_GURRC_EUTRAN_DEDICATED_PRI_MAX_NUM];
}LRRC_GURRC_LTE_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_UTRAN_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved[1];
}LRRC_GURRC_UTRAN_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_UTRAN_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    LRRC_GURRC_UTRAN_PRI_INFO_STRU                          astUtranDPriInfo[LRRC_GURRC_UTRAN_DEDICATED_PRI_MAX_NUM];
}LRRC_GURRC_UTRAN_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_GERAN_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved[3];
}LRRC_GURRC_GERAN_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_GERAN_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    LRRC_GURRC_GERAN_PRI_INFO_STRU                          astGeranDPriInfo[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}LRRC_GURRC_GERAN_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :רȼϢݽṹ
*****************************************************************************/
typedef struct
{
    /**************************************************************************
     bitLteDPriInfoPresent: ʾstLteDPriInfoǷЧ1ʾЧ0ʾЧ
     bitUtranDPriInfoPresent: ʾstUtranDPriInfoǷЧ1ʾЧ0ʾЧ
     bitGeranDPriInfoPresent: ʾstGeranDPriInfoǷЧ1ʾЧ0ʾЧ
     bitDPriTimerPresent: ʾulTimerValueǷЧ1ʾЧ0ʾЧ
    **************************************************************************/

    VOS_UINT32                                              bitLteDPriInfoPresent  : 1;
    VOS_UINT32                                              bitUtranDPriInfoPresent: 1;
    VOS_UINT32                                              bitGeranDPriInfoPresent: 1;
    VOS_UINT32                                              bitDPriTimerPresent    : 1;  /* bitΪ0ʱʾʱ */
    VOS_UINT32                                              bitSpare               : 28;

    /* EUTRAN ƵȼϢ */
    LRRC_GURRC_LTE_DEDICATED_PRI_INFO_STRU                  stLteDPriInfo;

    /* URTAN ƵȼϢ */
    LRRC_GURRC_UTRAN_DEDICATED_PRI_INFO_STRU                stUtranDPriInfo;

    /* GSM ƵȼϢ */
    LRRC_GURRC_GERAN_DEDICATED_PRI_INFO_STRU                stGeranDPriInfo;

    /* T3230,T322 ,T320ʱʵʣʱλ,
            T3230,T322 ,T320ʱڣʾ޴ */
    VOS_UINT32                                              ulTimerValue;
}LRRC_GURRC_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_PLMN_ID_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :PLMNϢ
    MCC, Mobile country code (aucPlmnId[0], aucPlmnId[1] bits 1 to 4)
    MNC, Mobile network code (aucPlmnId[2], aucPlmnId[1] bits 5 to 8).

    The coding of this field is the responsibility of each administration but BCD
    coding shall be used. The MNC shall consist of 2 or 3 digits. For PCS 1900 for NA,
    Federal regulation mandates that a 3-digit MNC shall be used. However a network
    operator may decide to use only two digits in the MNC over the radio interface.
    In this case, bits 5 to 8 of octet 4 shall be coded as "1111". Mobile equipment
    shall accept MNC coded in such a way.

    ---------------------------------------------------------------------------
                 ||(BIT8)|(BIT7)|(BIT6)|(BIT5)|(BIT4)|(BIT3)|(BIT2)|(BIT1)
    ---------------------------------------------------------------------------
    aucPlmnId[0] ||    MCC digit 2            |           MCC digit 1
    ---------------------------------------------------------------------------
    aucPlmnId[1] ||    MNC digit 3            |           MCC digit 3
    ---------------------------------------------------------------------------
    aucPlmnId[2] ||    MNC digit 2            |           MNC digit 1
    ---------------------------------------------------------------------------

*****************************************************************************/
typedef struct
{
    VOS_UINT8                                               aucPlmnId[3];
    VOS_UINT8                                               aucReserved[1];
}LRRC_GURRC_PLMN_ID_INFO_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_PLMN_ID_INFO_LIST_STRU
 Э  :
 ASN.1   :
 ṹ˵  :ϵͳϢЯPLMNϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulPlmnIdNum;
    LRRC_GURRC_PLMN_ID_INFO_STRU                            astPlmnIdInfo[LRRC_GURRC_PLMN_ID_MAX_NUM];
}LRRC_GURRC_PLMN_ID_INFO_LIST_STRU;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
 ṹ     :LRRC_GRR_GERAN_CELL_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GСϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;
    LRRC_GRR_BSIC_INFO_STRU                                 stBsic;
}LRRC_GRR_GERAN_CELL_INFO_STRU;
#else
/*****************************************************************************
 ṹ     :LRRC_GURRC_GERAN_CELL_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GСϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;
    LRRC_GRR_BSIC_INFO_STRU                                 stBsic;
}LRRC_GURRC_GERAN_CELL_INFO_STRU;
#endif
/*****************************************************************************
 ṹ    : LRRC_GRR_SAVE_GERAN_CELL_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRR̬²GERAN CELL Ϣ
*****************************************************************************/
typedef struct
{
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    LRRC_GRR_GERAN_CELL_INFO_STRU                           stGeranCellInfo;
#else
    LRRC_GURRC_GERAN_CELL_INFO_STRU                         stGeranCellInfo;
#endif
    /* GĿСƽֵ,ʽ޷ȡΪԼЧֵHOʱʹá*/
    VOS_INT16                                               sGeranCellRxlev;

    VOS_UINT8                                               aucReserved[1];

    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enFNOffsetTAPresent; /* GСʱϢ, 0: ʾڣ1 ʾ*/
    VOS_INT32                                               lFNOffset;
    VOS_UINT32                                              ulTimeAlignmt;
}LRRC_GRR_SAVE_GERAN_CELL_INFO_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_SAVE_GERAN_CELL_INFO_LIST_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRR̬²GERAN CELL ϢбֻЯѾ֤
             ɹGСϢ
*****************************************************************************/
typedef struct
{
    /* GSMС */
    VOS_UINT32                                              ulGsmCellNum;
    LRRC_GRR_SAVE_GERAN_CELL_INFO_STRU                      astRrcSaveCellInfoForGas[LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM];
}LRRC_GRR_SAVE_GERAN_CELL_INFO_LIST_STRU;

/*****************************************************************************
 ṹ     :GURRC_LRRC_EUTRAN_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :EUTRAN ƵϢ
*****************************************************************************/
typedef struct
{
   VOS_UINT16                                               usArfcn;
   LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                   enMeasband;         /*  տڲЯ,дĬֵ 0 */

   VOS_UINT8                                                aucReserved[3];

   /* տϢЯÿƵӦĺϢ*/
   VOS_UINT8                                                ucBlackListCnt;
   VOS_UINT16                                               ausBlackCellidList[LRRC_GURRC_BLACK_LIST_CELL_MAX_NUM];
}GURRC_LRRC_EUTRAN_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_LRRC_EUTRAN_INFO_LIST_STRU
 Э  :
 ASN.1   :
 ṹ˵  :EUTRAN ƵϢб
*****************************************************************************/
typedef struct
{
   /* ҪƵ */
   VOS_UINT16                                               usArfcnNum;

   /****************************************************************************
   ƵϢиȼƵusArfcnNum =  usHighPriNum
   ʾֻиȼƵ㣬ǰ״̬ȼ
   astEutranInfo˳Ϊ:ȼϢ -> ȼϢ -> ȼϢ
   ****************************************************************************/
   VOS_UINT16                                               usHighPriNum;
   GURRC_LRRC_EUTRAN_INFO_STRU                              astEutranInfo[LRRC_GURRC_LTE_PHY_MAX_SUPPORT_CARRIER_NUM];
}GURRC_LRRC_EUTRAN_INFO_LIST_STRU;

/*****************************************************************************
 ṹ    : LRRC_GURRC_EUTRAN_CELL_MEAS_RESULT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : С
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usCellId;
    VOS_INT16                                               sRsrp;              /* RSRPֵ,ȡֵΧ[-141*8,-44*8] λ:dBm 1/8  */
    VOS_INT16                                               sRsrq;              /* RSRQֵ ,ȡֵΧ[-40*4-6*4] λ:dB  1/8  */
    VOS_INT16                                               sRssi;              /* RSSIֵ ,ȡֵΧ[-110*8,-20*8], λ:dBm 1/8  */
}LRRC_GURRC_EUTRAN_CELL_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    : LRRC_GURRC_SINGLE_EUTRAN_FREQ_MEAS_RESULT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTE ƵС
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usArfcnCellNum;
    LRRC_GURRC_EUTRAN_CELL_MEAS_RESULT_STRU                 astInterFreqMeasResult[LRRC_GURRC_MAX_LTE_CELL_PER_FREQ_NUM];
}LRRC_GURRC_SINGLE_EUTRAN_FREQ_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  :EUTRAN Ϣ
*****************************************************************************/
typedef struct
{
   /* ѾݵƵ */
   VOS_UINT16                                               usArfcnNum;
   VOS_UINT8                                                aucReserved[2];

   LRRC_GURRC_SINGLE_EUTRAN_FREQ_MEAS_RESULT_STRU           astEutranMeasResultInfo[LRRC_GURRC_LTE_PHY_MAX_SUPPORT_CARRIER_NUM];
}LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_CELL_GLOBAL_ID_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  UTRAN/EUTRAN CELL GLOBAL IDϢ
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stPlmnId;
    VOS_UINT32                                              ulCellId;
}LRRC_GURRC_CELL_GLOBAL_ID_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_FORB_LA_STRU
 Э  :
 ASN.1   :
 ṹ˵  :

*****************************************************************************/
typedef struct
{
    LRRC_GURRC_PLMN_ID_INFO_STRU                 PlmnId;                        /* PlMNʶ       */
    VOS_UINT32                                   ulForbLac;                     /* ֹעϢ */
}LRRC_GURRC_FORB_LA_STRU;

/*****************************************************************************
 ṹ     :LRRC_GURRC_UTRAN_CELL_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GERANϵͳϢ
*****************************************************************************/
typedef struct
{
   VOS_UINT16                                               usArfcn;
   LRRC_GRR_BANDINDICATOR_ENUM_UINT16                       enBandInd;
}LRRC_GURRC_GERAN_CELL_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_LOW_PLMN_ID_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  ȼplmnݽṹplmnϢRSRPֵ
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stLowPlmnId;
    VOS_INT32                                               lRsrp;
}LRRC_GURRC_LOW_PLMN_ID_INFO_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GURRC_PLMN_ID_LIST_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  suitable Plmn ʧܣLRRCWRRC PLMN SEARCH 
*****************************************************************************/
typedef struct
{
    /* PLMNĸ */
    VOS_UINT32                                              ulHighPlmnNum;
    LRRC_GURRC_PLMN_ID_INFO_STRU                            astHighPlmnList[LRRC_GURRC_MAX_HIGH_PLMN_NUM];

    /* PLMNĸ */
    VOS_UINT32                                              ulLowPlmnNum;
    LRRC_GURRC_LOW_PLMN_ID_INFO_STRU                        astLowPlmnList[LRRC_GURRC_MAX_LOW_PLMN_NUM];
}LRRC_GURRC_PLMN_ID_LIST_STRU;

/* CMCC-BEGIN */
/*****************************************************************************
 ṹ    : LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTEرʷƵбϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    VOS_UINT16                                              ausArfcn[LRRC_GURRC_LTE_PHY_MAX_SUPPORT_CARRIER_NUM];
}LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU;
/* CMCC-END */

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/










#if (VOS_OS_VER != VOS_WIN32)
 #pragma pack()
#else
 #pragma pack(pop)
#endif

#ifdef __cplusplus
 #if __cplusplus
}
 #endif
#endif

#endif /* end of LRRC_GURRCCommInterface.h */
