/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : LRrcGrrInterface.h
  Description     : LTE RRCGRR֮ӿļ
  History         :
      1.liutao 38432       2010-12-30   Draft Enact
      2.lidui 143774       2011-09-22 DTS2011091702682:ֱø.hļɵ.dllļϢʧ
	  3.wangyue 151278     2011-12-22 DTS2011121902767:L2Gѡӿ޸ģֵ
******************************************************************************/

#ifndef __LRRC_GRRINTERFACE_H__
#define __LRRC_GRRINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include  "vos.h"
#include  "LPSCommon.h"
#include  "LRrcGuRrcCommInterface.h"

/*****************************************************************************
  #pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 Macro
*****************************************************************************/

#define LRRC_GRR_MSG_HDR                (PS_MSG_ID_LRRC_TO_GRR_BASE)
#define GRR_LRRC_MSG_HDR                (PS_MSG_ID_GRR_TO_LRRC_BASE)

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
/*****************************************************************************
 ö    :
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum LRRC_GRR_MSG_TYPE_ENUM
{
    /* G -> L Cell Resel */
    ID_GRR_LRRC_CELL_RESEL_REQ                 = (GRR_LRRC_MSG_HDR + 0x00),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_RESEL_REQ_STRU */
    ID_LRRC_GRR_CELL_RESEL_CNF                 = (LRRC_GRR_MSG_HDR + 0x00),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_RESEL_CNF_STRU */
    ID_GRR_LRRC_CELL_RESEL_STOP_REQ            = (GRR_LRRC_MSG_HDR + 0x01),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_RESEL_STOP_REQ_STRU */
    ID_LRRC_GRR_CELL_RESEL_STOP_CNF            = (LRRC_GRR_MSG_HDR + 0x01),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_RESEL_STOP_CNF_STRU */

    /* G -> L Redirect */
    ID_GRR_LRRC_REDIRECTED_REQ                 = (GRR_LRRC_MSG_HDR + 0x02),     /* _H2ASN_MsgChoice GRR_LRRC_REDIRECTED_REQ_STRU */
    ID_LRRC_GRR_REDIRECTED_CNF                 = (LRRC_GRR_MSG_HDR + 0x02),     /* _H2ASN_MsgChoice LRRC_GRR_REDIRECTED_CNF_STRU */
    ID_GRR_LRRC_REDIRECTED_STOP_REQ            = (GRR_LRRC_MSG_HDR + 0x03),     /* _H2ASN_MsgChoice GRR_LRRC_REDIRECTED_STOP_REQ_STRU */
    ID_LRRC_GRR_REDIRECTED_STOP_CNF            = (LRRC_GRR_MSG_HDR + 0x03),     /* _H2ASN_MsgChoice LRRC_GRR_REDIRECTED_STOP_CNF_STRU */

    /* G -> L CCO */
    ID_GRR_LRRC_CELL_CHANGE_ORDER_REQ          = (GRR_LRRC_MSG_HDR + 0x04),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_CHANGE_ORDER_REQ_STRU */
    ID_LRRC_GRR_CELL_CHANGE_ORDER_CNF          = (LRRC_GRR_MSG_HDR + 0x04),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_CHANGE_ORDER_CNF_STRU */
    ID_GRR_LRRC_CELL_CHANGE_ORDER_STOP_REQ     = (GRR_LRRC_MSG_HDR + 0x05),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_CHANGE_ORDER_STOP_REQ_STRU */
    ID_LRRC_GRR_CELL_CHANGE_ORDER_STOP_CNF     = (LRRC_GRR_MSG_HDR + 0x05),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_CHANGE_ORDER_STOP_CNF_STRU */

    /* G-> L HO */
    ID_GRR_LRRC_HANDOVER_REQ                   = (GRR_LRRC_MSG_HDR + 0x06),     /* _H2ASN_MsgChoice GRR_LRRC_HANDOVER_REQ_STRU */
    ID_LRRC_GRR_HANDOVER_CNF                   = (LRRC_GRR_MSG_HDR + 0x06),     /* _H2ASN_MsgChoice LRRC_GRR_HANDOVER_CNF_STRU */
    ID_GRR_LRRC_HANDOVER_STOP_REQ              = (GRR_LRRC_MSG_HDR + 0x07),     /* _H2ASN_MsgChoice GRR_LRRC_HANDOVER_STOP_REQ_STRU */
    ID_LRRC_GRR_HANDOVER_STOP_CNF              = (LRRC_GRR_MSG_HDR + 0x07),     /* _H2ASN_MsgChoice LRRC_GRR_HANDOVER_STOP_CNF_STRU */

    /* G-> L ͹ */
    ID_GRR_LRRC_SET_DSP_POWER_REQ              = (GRR_LRRC_MSG_HDR + 0x08),     /* _H2ASN_MsgChoice GRR_LRRC_SET_DSP_POWER_REQ_STRU */
    ID_LRRC_GRR_SET_DSP_POWER_CNF              = (LRRC_GRR_MSG_HDR + 0x08),     /* _H2ASN_MsgChoice LRRC_GRR_SET_DSP_POWER_CNF_STRU */

    /* G-> L Idle Meas */
    ID_GRR_LRRC_IDLE_MEASURE_REQ               = (GRR_LRRC_MSG_HDR + 0x09),     /* _H2ASN_MsgChoice GRR_LRRC_IDLE_MEASURE_REQ_STRU */
    ID_LRRC_GRR_IDLE_MEASURE_CNF               = (LRRC_GRR_MSG_HDR + 0x09),     /* _H2ASN_MsgChoice LRRC_GRR_IDLE_MEASURE_CNF_STRU */
    ID_LRRC_GRR_IDLE_MEASURE_IND               = (LRRC_GRR_MSG_HDR + 0x0a),     /* _H2ASN_MsgChoice LRRC_GRR_IDLE_MEASURE_IND_STRU */

    /* G-> L conn Meas */
    ID_GRR_LRRC_CONNECTED_MEASURE_REQ          = (GRR_LRRC_MSG_HDR + 0x0a),     /* _H2ASN_MsgChoice GRR_LRRC_CONNECTED_MEASURE_REQ_STRU */
    ID_LRRC_GRR_CONNECTED_MEASURE_CNF          = (LRRC_GRR_MSG_HDR + 0x0b),     /* _H2ASN_MsgChoice LRRC_GRR_CONNECTED_MEASURE_CNF_STRU */
    ID_LRRC_GRR_CONNECTED_MEASURE_IND          = (LRRC_GRR_MSG_HDR + 0x0c),     /* _H2ASN_MsgChoice LRRC_GRR_CONNECTED_MEASURE_IND_STRU */

    /* L -> G Cell Resel*/
    ID_LRRC_GRR_CELL_RESEL_REQ                 = (LRRC_GRR_MSG_HDR + 0x0d),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_RESEL_REQ_STRU */
    ID_GRR_LRRC_CELL_RESEL_CNF                 = (GRR_LRRC_MSG_HDR + 0x0b),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_RESEL_CNF_STRU */
    ID_LRRC_GRR_CELL_RESEL_STOP_REQ            = (LRRC_GRR_MSG_HDR + 0x0e),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_RESEL_STOP_REQ_STRU */
    ID_GRR_LRRC_CELL_RESEL_STOP_CNF            = (GRR_LRRC_MSG_HDR + 0x0c),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_RESEL_STOP_CNF_STRU */

    /* L-> G Redirect */
    ID_LRRC_GRR_REDIRECTED_REQ                 = (LRRC_GRR_MSG_HDR + 0x0f),     /* _H2ASN_MsgChoice LRRC_GRR_REDIRECTED_REQ_STRU */
    ID_GRR_LRRC_REDIRECTED_CNF                 = (GRR_LRRC_MSG_HDR + 0x0d),     /* _H2ASN_MsgChoice GRR_LRRC_REDIRECTED_CNF_STRU */
    ID_LRRC_GRR_REDIRECTED_STOP_REQ            = (LRRC_GRR_MSG_HDR + 0x10),     /* _H2ASN_MsgChoice LRRC_GRR_REDIRECTED_STOP_REQ_STRU */
    ID_GRR_LRRC_REDIRECTED_STOP_CNF            = (GRR_LRRC_MSG_HDR + 0x0e),     /* _H2ASN_MsgChoice GRR_LRRC_REDIRECTED_STOP_CNF_STRU */

    /* L-> G CCO */
    ID_LRRC_GRR_CELL_CHANGE_ORDER_REQ          = (LRRC_GRR_MSG_HDR + 0x11),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_CHANGE_ORDER_REQ_STRU */
    ID_GRR_LRRC_CELL_CHANGE_ORDER_CNF          = (GRR_LRRC_MSG_HDR + 0x0f),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_CHANGE_ORDER_CNF_STRU */
    ID_LRRC_GRR_CELL_CHANGE_ORDER_STOP_REQ     = (LRRC_GRR_MSG_HDR + 0x12),     /* _H2ASN_MsgChoice LRRC_GRR_CELL_CHANGE_ORDER_STOP_REQ_STRU */
    ID_GRR_LRRC_CELL_CHANGE_ORDER_STOP_CNF     = (GRR_LRRC_MSG_HDR + 0x10),     /* _H2ASN_MsgChoice GRR_LRRC_CELL_CHANGE_ORDER_STOP_CNF_STRU */

    /* L-> G HO */
    ID_LRRC_GRR_HANDOVER_REQ                   = (LRRC_GRR_MSG_HDR + 0x13),     /* _H2ASN_MsgChoice LRRC_GRR_HANDOVER_REQ_STRU */
    ID_GRR_LRRC_HANDOVER_CNF                   = (GRR_LRRC_MSG_HDR + 0x11),     /* _H2ASN_MsgChoice GRR_LRRC_HANDOVER_CNF_STRU */
    ID_LRRC_GRR_HANDOVER_STOP_REQ              = (LRRC_GRR_MSG_HDR + 0x14),     /* _H2ASN_MsgChoice LRRC_GRR_HANDOVER_STOP_REQ_STRU */
    ID_GRR_LRRC_HANDOVER_STOP_CNF              = (GRR_LRRC_MSG_HDR + 0x12),     /* _H2ASN_MsgChoice GRR_LRRC_HANDOVER_STOP_CNF_STRU */

    /* G-> L ͹ */
    ID_LRRC_GRR_SET_DSP_POWER_REQ              = (LRRC_GRR_MSG_HDR + 0x15),     /* _H2ASN_MsgChoice LRRC_GRR_SET_DSP_POWER_REQ_STRU */
    ID_GRR_LRRC_SET_DSP_POWER_CNF              = (GRR_LRRC_MSG_HDR + 0x13),     /* _H2ASN_MsgChoice GRR_LRRC_SET_DSP_POWER_CNF_STRU */

    /* L-> G Get Ue Capability Info */
    ID_LRRC_GRR_GETUECAPINFO_REQ               = (LRRC_GRR_MSG_HDR + 0x16),     /* _H2ASN_MsgChoice LRRC_GRR_GETUECAPINFO_REQ_STRU */
    ID_GRR_LRRC_GETUECAPINFO_CNF               = (GRR_LRRC_MSG_HDR + 0x14),     /* _H2ASN_MsgChoice GRR_LRRC_GETUECAPINFO_CNF_STRU */

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
    /* L -> G Idle Meas */
    ID_LRRC_GRR_IDLE_MEASURE_REQ               = (LRRC_GRR_MSG_HDR + 0x17),     /* _H2ASN_MsgChoice LRRC_GRR_IDLE_MEASURE_REQ_STRU */
    ID_GRR_LRRC_IDLE_MEASURE_CNF               = (GRR_LRRC_MSG_HDR + 0x15),     /* _H2ASN_MsgChoice GRR_LRRC_IDLE_MEASURE_CNF_STRU */
    ID_GRR_LRRC_IDLE_MEASURE_IND               = (GRR_LRRC_MSG_HDR + 0x16),     /* _H2ASN_MsgChoice GRR_LRRC_IDLE_MEASURE_IND_STRU */

    /* L -> G Conn Meas */
    ID_LRRC_GRR_CONNECTED_MEASURE_REQ          = (LRRC_GRR_MSG_HDR + 0x18),     /* _H2ASN_MsgChoice LRRC_GRR_CONNECTED_MEASURE_REQ_STRU */
    ID_GRR_LRRC_CONNECTED_MEASURE_CNF          = (GRR_LRRC_MSG_HDR + 0x17),     /* _H2ASN_MsgChoice GRR_LRRC_CONNECTED_MEASURE_CNF_STRU */
    ID_GRR_LRRC_CONNECTED_MEASURE_IND          = (GRR_LRRC_MSG_HDR + 0x18),     /* _H2ASN_MsgChoice GRR_LRRC_CONNECTED_MEASURE_IND_STRU */

    /* L -> GU  Gsm Cell Bsic Verify  */
    ID_LRRC_GRR_BSIC_VERIFIED_REQ              = (LRRC_GRR_MSG_HDR + 0x19),     /* _H2ASN_MsgChoice LRRC_GRR_BSIC_VERIFIED_REQ_STRU */
    ID_GRR_LRRC_BSIC_VERIFIED_CNF              = (GRR_LRRC_MSG_HDR + 0x19),     /* _H2ASN_MsgChoice GRR_LRRC_BSIC_VERIFIED_CNF_STRU */
    ID_GRR_LRRC_BSIC_VERIFIED_IND              = (GRR_LRRC_MSG_HDR + 0x1a),     /* _H2ASN_MsgChoice GRR_LRRC_BSIC_VERIFIED_IND_STRU */

    /* L -> G RelAll */
    ID_LRRC_GRR_RELALL_REQ                     = (LRRC_GRR_MSG_HDR + 0x1a),     /* _H2ASN_MsgChoice LRRC_GRR_RELALL_REQ_STRU */
    ID_GRR_LRRC_RELALL_CNF                     = (GRR_LRRC_MSG_HDR + 0x1b),     /* _H2ASN_MsgChoice GRR_LRRC_RELALL_CNF_STRU */
    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */
#endif
    /* L -> G cell srch. LؽʱGС */
    ID_LRRC_GRR_CELL_SRCH_REQ                  = (LRRC_GRR_MSG_HDR + 0x1c),       /* _H2ASN_MsgChoice LRRC_GRR_CELL_SRCH_REQ_STRU */
    ID_GRR_LRRC_CELL_SRCH_CNF                  = (GRR_LRRC_MSG_HDR + 0x1d),       /* _H2ASN_MsgChoice GRR_LRRC_CELL_SRCH_CNF_STRU */
    ID_LRRC_GRR_CELL_SRCH_STOP_REQ             = (LRRC_GRR_MSG_HDR + 0x1d),       /* _H2ASN_MsgChoice LRRC_GRR_CELL_SRCH_STOP_REQ_STRU */
    ID_GRR_LRRC_CELL_SRCH_STOP_CNF             = (GRR_LRRC_MSG_HDR + 0x1e),       /* _H2ASN_MsgChoice GRR_LRRC_CELL_SRCH_STOP_CNF_STRU */

    /* GTL汾УL->GģIDѾʹ
	LRRC_GRR_MSG_HDR + [ 0x17 - 0x1b] GRR_LRRC_MSG_HDR + [ 0x15 - 0x1c ]
    ˴Щ IDֵ */

    /* G-> L BackGroud Search */
    ID_GRR_LRRC_BG_PLMN_SEARCH_REQ         = (GRR_LRRC_MSG_HDR + 0x1f),         /* _H2ASN_MsgChoice GRR_LRRC_BG_PLMN_SEARCH_REQ_STRU */
    ID_LRRC_GRR_BG_PLMN_SEARCH_CNF         = (LRRC_GRR_MSG_HDR + 0x1e),         /* _H2ASN_MsgChoice LRRC_GRR_BG_PLMN_SEARCH_CNF_STRU */
    ID_LRRC_GRR_BG_PLMN_SEARCH_IND         = (LRRC_GRR_MSG_HDR + 0x1f),         /* _H2ASN_MsgChoice LRRC_GRR_BG_PLMN_SEARCH_IND_STRU */
    ID_GRR_LRRC_BG_SEARCH_STOP_REQ         = (GRR_LRRC_MSG_HDR + 0x20),         /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_STOP_REQ_STRU */
    ID_LRRC_GRR_BG_SEARCH_STOP_CNF         = (LRRC_GRR_MSG_HDR + 0x20),         /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_STOP_CNF_STRU */
    ID_GRR_LRRC_BG_SEARCH_SUSPEND_REQ      = (GRR_LRRC_MSG_HDR + 0x21),         /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_SUSPEND_REQ_STRU */
    ID_LRRC_GRR_BG_SEARCH_SUSPEND_CNF      = (LRRC_GRR_MSG_HDR + 0x21),         /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_SUSPEND_CNF_STRU */
    ID_LRRC_GRR_BG_SEARCH_RESUME_CNF       = (LRRC_GRR_MSG_HDR + 0x22),         /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_RESUME_CNF_STRU */
    ID_GRR_LRRC_BG_SEARCH_RESUME_REQ       = (GRR_LRRC_MSG_HDR + 0x22),         /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_RESUME_REQ_STRU */
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
    /* L -> G BackGroud Search */
    ID_LRRC_GRR_BG_PLMN_SEARCH_REQ             = (LRRC_GRR_MSG_HDR + 0x23),     /* _H2ASN_MsgChoice LRRC_GRR_BG_PLMN_SEARCH_REQ_STRU */
    ID_GRR_LRRC_BG_PLMN_SEARCH_CNF             = (GRR_LRRC_MSG_HDR + 0x23),     /* _H2ASN_MsgChoice GRR_LRRC_BG_PLMN_SEARCH_CNF_STRU */
    ID_GRR_LRRC_BG_PLMN_SEARCH_IND             = (GRR_LRRC_MSG_HDR + 0x24),     /* _H2ASN_MsgChoice GRR_LRRC_BG_PLMN_SEARCH_IND_STRU */
    ID_LRRC_GRR_BG_SEARCH_STOP_REQ             = (LRRC_GRR_MSG_HDR + 0x24),     /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_STOP_REQ_STRU */
    ID_GRR_LRRC_BG_SEARCH_STOP_CNF             = (GRR_LRRC_MSG_HDR + 0x25),     /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_STOP_CNF_STRU */
    ID_LRRC_GRR_BG_SEARCH_SUSPEND_REQ          = (LRRC_GRR_MSG_HDR + 0x25),     /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_SUSPEND_REQ_STRU */
    ID_GRR_LRRC_BG_SEARCH_SUSPEND_CNF          = (GRR_LRRC_MSG_HDR + 0x26),     /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_SUSPEND_CNF_STRU */
    ID_LRRC_GRR_BG_SEARCH_RESUME_REQ           = (LRRC_GRR_MSG_HDR + 0x26),     /* _H2ASN_MsgChoice LRRC_GRR_BG_SEARCH_RESUME_REQ_STRU */
    ID_GRR_LRRC_BG_SEARCH_RESUME_CNF           = (GRR_LRRC_MSG_HDR + 0x27),     /* _H2ASN_MsgChoice GRR_LRRC_BG_SEARCH_RESUME_CNF_STRU */
    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */

    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
    /* L -> G ANR */
    ID_LRRC_GRR_GET_CGI_REQ                    = (LRRC_GRR_MSG_HDR + 0x27),     /* _H2ASN_MsgChoice LRRC_GRR_GET_CGI_REQ_STRU */
    ID_GRR_LRRC_GET_CGI_CNF                    = (GRR_LRRC_MSG_HDR + 0x28),     /* _H2ASN_MsgChoice GRR_LRRC_GET_CGI_CNF_STRU */
    ID_GRR_LRRC_GET_CGI_IND                    = (GRR_LRRC_MSG_HDR + 0x29),     /* _H2ASN_MsgChoice GRR_LRRC_GET_CGI_IND_STRU */
    ID_LRRC_GRR_GET_CGI_STOP_REQ               = (LRRC_GRR_MSG_HDR + 0x28),     /* _H2ASN_MsgChoice LRRC_GRR_GET_CGI_STOP_REQ_STRU */
    ID_GRR_LRRC_GET_CGI_STOP_CNF               = (GRR_LRRC_MSG_HDR + 0x2a),     /* _H2ASN_MsgChoice GRR_LRRC_GET_CGI_STOP_CNF_STRU */
    /* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */
#endif

    ID_LRRC_GRR_MSG_TYPE_BUTT

};
typedef VOS_UINT32  LRRC_GRR_MSG_TYPE_ENUM_UINT32;

/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usCellId;
    /* տڲڸʱдĬֵ0 */
    LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                  enMeasBand;

    /* ѡɹͷʱusPunishTimerValueUEܴLѡGС
       λ:룬ĿǰĬΪ5000 */
    VOS_UINT16                                              usPunishTimerValue;

    /* GָʾפLTE СͣG֧CSֻѡSUITABLEС */
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT8                                               aucReserved[2];

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stLrrcGurrcDPriInfo;
}GRR_LRRC_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч
     ΪСPLMN IDs */
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfo;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}LRRC_GRR_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GRRָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_CELL_RESEL_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_REDIRECTED_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSMϵͳضλϢ
*****************************************************************************/
typedef struct
{

    VOS_UINT16                                              usArfcn;
    VOS_UINT8                                               aucReserved[3];
    VOS_UINT8                                               ucTargetCellPresent;
    VOS_UINT16                                              usCellId;

    /* տڲڸʱдĬֵ0 */
    LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                  enMeasBand;

    /* LTE ϵͳеĺϢ */
    VOS_UINT16                                              usBlackListCellNum;
    VOS_UINT16                                              ausBlackListCellId[LRRC_GURRC_BLACK_LIST_CELL_MAX_NUM];
}GRR_LRRC_REDIRECTED_INFO_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_REDIRECTED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT32                                              ulRedirInfoNum;
    GRR_LRRC_REDIRECTED_INFO_STRU                           astGrrRedirInfo[LRRC_GURRC_LTE_ARFCN_MAX_NUM];

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_TYPE_ENUM_UINT8                        enRedirType;
    VOS_UINT8                                               aucReserved[3];
    /* CMCC-END */

    /* REDIR INFO ָʾʱ λ:,Ŀǰ̶10000ms
    ڴʱ,LRRCָֻʾƵڽʱ󣬿 */
    VOS_UINT16                                              usSearchTimer;
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stLrrcGurrcDPriInfo;
}GRR_LRRC_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_REDIRECTED_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}LRRC_GRR_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GRRָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_CELL_CHANGE_ORDER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GRRָʾLRRCCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usArfcn;
    VOS_UINT16                                              usCellId;

    /* տڲڸʱдĬֵ0 */
    LRRC_GURRC_MEAS_BAND_WIDTH_ENUM_UINT16                  enMeasBand;
    VOS_UINT8                                               aucReserved[1];

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stLrrcGurrcDPriInfo;
}GRR_LRRC_CELL_CHANGE_ORDER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_CHANGE_ORDER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CCO_RESULT_ENUM_UINT32                       enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч
     ΪСPLMN IDs */
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfo;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}LRRC_GRR_CELL_CHANGE_ORDER_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_CELL_CHANGE_ORDER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GRRָʾLRRCֹͣCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_CELL_CHANGE_ORDER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_CHANGE_ORDER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRֹͣCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_CELL_CHANGE_ORDER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_HANDOVER_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾл
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/

    /* Ϊ RRC CONN RECFG Ϣ */
    VOS_UINT32                                              ulHoDataLen;
    VOS_UINT8                                               aucHoData[4];
}GRR_LRRC_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_HANDOVER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾл̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}LRRC_GRR_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :GRRָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GRRָʾLRRCDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}GRR_LRRC_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRREDSPʡ̽
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}LRRC_GRR_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_IDLE_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stIdleEutranArfcnInfoList;
}GRR_LRRC_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_IDLE_MEASURE_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : LRRCGRRָʾIDLE
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    VOS_UINT8                                               aucReserved[2];

    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_GRR_IDLE_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_IDLE_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾIDLE 
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    VOS_UINT8                                               aucReserved[2];

    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stIdleMeasResult;
}LRRC_GRR_IDLE_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CONNECTED_MEASURE_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;
    GURRC_LRRC_EUTRAN_INFO_LIST_STRU                        stConnEutranArfcnInfoList;
}GRR_LRRC_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_CONNECTED_MEASURE_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾCONNECTED
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    VOS_UINT8                                               aucReserved[2];

    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;
}LRRC_GRR_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_CONNECTED_MEASURE_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾCONNECTED 
*****************************************************************************/
typedef struct
{
   VOS_MSG_HEADER                                                               /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpid;
    VOS_UINT8                                               aucReserved[2];

    LRRC_GURRC_MEAS_EUTRAN_RESULT_STRU                      stConnMeasResult;
}LRRC_GRR_CONNECTED_MEASURE_IND_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_CELL_RESEL_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    LRRC_GRR_GERAN_CELL_INFO_STRU                           stGeranCellInfo;
#else
    LRRC_GURRC_GERAN_CELL_INFO_STRU                         stGeranCellInfo;
#endif
    /* GСƽֵ,ʽ޷ȡΪԼЧֵ*/
    VOS_INT16                                               sGeranCellRxlev;
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;

    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stLrrcGurrcDPriInfo;
}LRRC_GRR_CELL_RESEL_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_RESEL_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч
        ΪСPLMN ID  */
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfo;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}GRR_LRRC_CELL_RESEL_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_RESEL_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_CELL_RESEL_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_CELL_RESEL_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_CELL_RESEL_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_SYSINFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTEϵͳЯضCCOлϢеϵͳϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulSysInfoLen;
    VOS_UINT8                                               aucSysInfoData[LRRC_GURRC_GERAN_SYS_MAX_LEN];
}LRRC_GRR_SYSINFO_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_REDIRECTED_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTEϵͳЯضϢеϵͳϢ
                  Э6.2.2
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              bitulBsicInfoPresent : 1;
    VOS_UINT32                                              bitulSysInfoPresent  : 1;
    VOS_UINT32                                              bitSpare             : 30;

    VOS_UINT16                                              usArfCn;
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;
    LRRC_GRR_BSIC_INFO_STRU                                 stBsic;

    VOS_UINT32                                              ulSysInfoNum;
    LRRC_GRR_SYSINFO_STRU                                   astRedirSysInfo[LRRC_GURRC_GERAN_SYS_MAX_NUM];
}LRRC_GRR_REDIRECTED_INFO_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_REDIRECTED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTE ϵͳЯضб
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    LRRC_GRR_REDIRECTED_INFO_STRU                           astLrrcGrrRedirInfo[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}LRRC_GRR_REDIRECTED_INFO_LIST_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_REDIRECTED_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/

    LRRC_GRR_REDIRECTED_INFO_LIST_STRU                      stRedirGeranInfo;

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU                  stRedirEutraInfo;
    /* CMCC-END */

    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT8                                               aucReserved[2];


    /* רȼϢ, 0: ʾڣ1 ʾ*/
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enDPriInfoPresent;
    LRRC_GURRC_DEDICATED_PRI_INFO_STRU                      stLrrcGurrcDPriInfo;
}LRRC_GRR_REDIRECTED_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_REDIRECTED_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GRRLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_REDIRECTED_RESULT_ENUM_UINT32                enRslt;
}GRR_LRRC_REDIRECTED_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_REDIRECTED_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_REDIRECTED_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_REDIRECTED_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_REDIRECTED_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_CELL_CHANGE_ORDER_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾض
                  LTE CCO GSMǴ̬IDLEר̬ϢЧ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GRR_SAVE_GERAN_CELL_INFO_STRU                      stGeranSaveCellInfo;

    /* CMCC-BEGIN */
    LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU                  stRedirEutraInfo;
    /* CMCC-END */

    /* CSFB ־,1:ʾCSFB, 0: ʾCSFB */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enCsfbInd;

    /* enNCOPresent = 1: ʾNCO, 0: ʾNCO */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enNCOPresent;
    VOS_UINT8                                               ucNetworkControlOrder;

    /* enSysInfoChoice = 1: ʾЯϵͳϢ, 0: ʾЯ */
    LRRC_GRR_SYS_TYPE_ENUM_UINT8                            enSysInfoChoice;

    VOS_UINT32                                              ulSysInfoNum;
    LRRC_GRR_SYSINFO_STRU                                   astCcoSysInfo[LRRC_GURRC_GERAN_SYS_MAX_NUM];
}LRRC_GRR_CELL_CHANGE_ORDER_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_CHANGE_ORDER_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GRRLRRCָʾض
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_CCO_RESULT_ENUM_UINT32                       enRslt;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_NOT_EPLMNSʱstPlmnIdInfo Ч
     ΪСPLMN IDs */
    LRRC_GURRC_PLMN_ID_INFO_LIST_STRU                       stPlmnIdInfo;

    /* usResult ԭֵΪLRRC_GURRC_CELL_RESEL_SIB_RCV_FAIL,
       LRRC_GURRC_CELL_RESEL_CELL_BARRED, LRRC_GURRC_CELL_RESEL_ACCESSʱ
       ulTimerVauleЧ,λ :*/
    VOS_UINT32                                              ulTimerValue;
}GRR_LRRC_CELL_CHANGE_ORDER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_CHANGE_ORDER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_CELL_CHANGE_ORDER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_CELL_CHANGE_ORDER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣCCO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_CELL_CHANGE_ORDER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_HANDOVER_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾHO, Э6.2.2
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/

    /* v7r2 lld begin */
    /*#ifdef V7R2*/
    /* Add by zhuochao for SRVCC 20131025 begin */
    /* ĿGSMСƵָʾ */
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;

    /* ͬлʱЯLTAλΪ1TSȡֵЧΧ[0~20512]TS */
    VOS_UINT16                                              usTaValue;
    /* Add by zhuochao for SRVCC 20131025 end */
    /*#endif*/
    /* v7r2 lld end */

    /* CSFB ־,1:ʾCSFB, 0: ʾCSFB */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enCsfbInd;

    /* ucSysInfoChoice =0, ʾЯϵͳϢ */
    LRRC_GRR_SYS_TYPE_ENUM_UINT8                            enSysInfoChoice;

    VOS_UINT16                                              usSysInfoNum;
    LRRC_GRR_SYSINFO_STRU                                   astHoSysInfo[LRRC_GURRC_GERAN_SYS_MAX_NUM];

    /* ̬²CELL Ϣ */
    LRRC_GRR_SAVE_GERAN_CELL_INFO_LIST_STRU                 stGeranCellInfoList;

    VOS_UINT8                                               aucPlmnId[3];
    VOS_UINT8                                               aucReserved[1];

    LRRC_GURRC_REDIR_SAVED_EUTRA_INFO_STRU                  stRedirEutraInfo;

    VOS_UINT32                                              ulHoDatalen;

    /* PS HANDOVER COMMAND HANDOVER COMMAND  */
    VOS_UINT8                                               aucHoData[4];
}LRRC_GRR_HANDOVER_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_HANDOVER_CNF_STRU
 Э  :
 ASN.1   :
 ṹ˵  : GRRLRRCָʾHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_HANDOVER_RESULT_ENUM_UINT32                  enRslt;
}GRR_LRRC_HANDOVER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_HANDOVER_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_HANDOVER_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_HANDOVER_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣHO
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_HANDOVER_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_SET_DSP_POWER_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾGRRDSPʡģʽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_CMD_ENUM_UINT32                enSetLDspPowerCmd;
}LRRC_GRR_SET_DSP_POWER_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_SET_DSP_POWER_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCEDSP
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_SET_DSP_POWER_RESULT_ENUM_UINT32             enRslt;
}GRR_LRRC_SET_DSP_POWER_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_GETUECAPINFO_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾGRR ṩUEϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucPlmnId[3];
    VOS_UINT8                                               aucReserved[1];
}LRRC_GRR_GETUECAPINFO_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_GETUECAPINFO_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCUEȡ,GERAN UE CAPдԭ

For GERAN CS: the octet string contains the concatenated string of the Mobile Station Classmark 2
and Mobile Station Classmark 3. The first 5 octets correspond to Mobile Station Classmark 2
and the following octets correspond to Mobile Station Classmark 3. The Mobile Station Classmark 2
is formatted as 'TLV' and is coded in the same way as the Mobile Station Classmark 2 information
element in TS 24.008 [49]. The first octet is the Mobile station classmark 2 IEI and its value shall
be set to 33H. The second octet is the Length of mobile station classmark 2 and its value shall be
set to 3. The octet 3 contains the first octet of the value part of the Mobile Station Classmark 2
information element, the octet 4 contains the second octet of the value part of the Mobile Station
Classmark 2 information element and so on. For each of these octets, the first/ leftmost/ most significant
bit of the octet contains b8 of the corresponding octet of the Mobile Station Classmark 2. The Mobile
Station Classmark 3 is formatted as 'V' and is coded in the same way as the value part in the Mobile
station classmark 3 information element in TS 24.008 [49]. The sixth octet of this octet string contains
octet 1 of the value part of Mobile station classmark 3, the seventh of octet of this octet string contains
octet 2 of the value part of Mobile station classmark 3 and so on. Note.


For GERAN PS: the encoding of UE capabilities is formatted as 'V' and is coded in the same way as the
value part in the MS Radio Access Capability information element in TS 24.008 [49].
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_UECAP_RESULT_ENUM_UINT16                 enRslt;
    VOS_UINT8                                               aucReserved[2];
    VOS_UINT16                                              usGeranCsDataLen;
    VOS_UINT16                                              usGeranPsDataLen;
    VOS_UINT8                                               aucGeranCsInfoData[LRRC_GRR_UE_CAP_GEREN_CS_MAX_LEN];
    VOS_UINT8                                               aucGeranPsInfoData[LRRC_GRR_UE_CAP_GEREN_PS_MAX_LEN];
}GRR_LRRC_GETUECAPINFO_CNF_STRU;
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/*****************************************************************************
     : LRRC_GRR_GERAN_CELL_STRU
 ṹ˵  : lteGSMСṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
   VOS_UINT16                                               usArfcn;
   LRRC_GRR_BANDINDICATOR_ENUM_UINT16                       enBandInd;
}LRRC_GRR_GERAN_CELL_STRU;

/*****************************************************************************
     : LRRC_GRR_GERAN_CELL_INFO_LIST_STRU
 ṹ˵  : lteGSMСбṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcnNum;

    /****************************************************************************
    ƵϢиȼƵIDLE̬Чֶ̬Ϊ
    usArfcnNum =  usHighPriNumʾֻиȼƵ㣬
    astGeranCellInfo˳Ϊ:ȼϢ -> ȼϢ -> ȼϢ
    ±ΪGSMСCELL ID
    ****************************************************************************/
    VOS_UINT16                                              usHighPrioNum;
    VOS_UINT16                                              usMgsmNum;          /* GSM̬ЧIDLEֶ̬α */
    VOS_UINT8                                               aucReserved[2];
    LRRC_GRR_GERAN_CELL_STRU                                astGeranCellInfo[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}LRRC_GRR_GERAN_CELL_INFO_LIST_STRU;

/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
/*****************************************************************************
     : LRRC_GRR_IDLE_MEASURE_REQ_STRU
 ṹ˵  : Lte idle̬²gsm
 ޸ʷ  :
  1.     : 2014217
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;          /* ָsetuprelease */
    LRRC_GRR_GERAN_CELL_INFO_LIST_STRU                      stGsmCellInfoList;  /* GSMСб */
}LRRC_GRR_IDLE_MEASURE_REQ_STRU;

/*****************************************************************************
     : GRR_LRRC_IDLE_MEASURE_CNF_STRU
 ṹ˵  : LRRC_GRR_IDLE_MEASURE_REQĻظԭ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;             /* orֹͣ */
}GRR_LRRC_IDLE_MEASURE_CNF_STRU;

/*****************************************************************************
     : GRR_LRRC_GERAN_CELL_MEAS_RESULT_STRU
 ṹ˵  : gģСϱṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;            /* Ƶ */
    LRRC_GRR_BANDINDICATOR_ENUM_UINT16                      enBandInd;          /* Ƶָʾ */
    VOS_INT16                                               sRssi;              /* sRssi ȡֵΧ[-110 * 8,-48 * 8],λ:dbm,1/8 */
    VOS_UINT8                                               aucReserved[2];     /* λ */
}GRR_LRRC_GERAN_CELL_MEAS_RESULT_STRU;

/*****************************************************************************
     : GRR_LRRC_GERAN_MEAS_RESULT_STRU
 ṹ˵  : gģϱṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcnNum;         /* Ƶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    GRR_LRRC_GERAN_CELL_MEAS_RESULT_STRU                    astGeranCellResult[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}GRR_LRRC_GERAN_MEAS_RESULT_IND_STRU;

/*****************************************************************************
     : GRR_LRRC_IDLE_MEASURE_IND_STRU
 ṹ˵  : Gģϱlte idleϢṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    GRR_LRRC_GERAN_MEAS_RESULT_IND_STRU                     stGsmMeasResult;    /* ϱ */
}GRR_LRRC_IDLE_MEASURE_IND_STRU;

/*****************************************************************************
     : LRRC_GRR_CONNECTED_MEASURE_REQ_STRU
 ṹ˵  : lte̬²GSMϢṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    LRRC_GURRC_MEAS_CMD_ENUM_UINT16                         enMeasCmd;          /* ָsetuprelease */
    LRRC_GRR_GERAN_CELL_INFO_LIST_STRU                      stGsmCellInfoList;  /* GSMСб */
}LRRC_GRR_CONNECTED_MEASURE_REQ_STRU;

/*****************************************************************************
     : GRR_LRRC_CONNECTED_MEASURE_CNF_STRU
 ṹ˵  : LRRC_GRR_CONNECTED_MEASURE_REQϢظ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    LRRC_GURRC_MEAS_RESULT_ENUM_UINT32                      enRslt;             /* orֹͣ */
}GRR_LRRC_CONNECTED_MEASURE_CNF_STRU;

/*****************************************************************************
     : GRR_LRRC_CONNECTED_MEASURE_IND_STRU
 ṹ˵  : Gģϱlte connectedϢṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    GRR_LRRC_GERAN_MEAS_RESULT_IND_STRU                     stGsmMeasResult;    /* ϱ */
}GRR_LRRC_CONNECTED_MEASURE_IND_STRU;

/*****************************************************************************
     : LRRC_GRR_BSIC_VERIFIED_REQ_STRU
 ṹ˵  : ltegģbsic֤Ϣṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT16                                              usArfcnNum;         /* bsic֤GSMС */
    LRRC_GRR_VERIFY_TIME_INDEX_ENUM_UINT16                  enVerifyTimeIndex;  /* GSM BSICʼȷϺȷϵʱ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
    LRRC_GRR_GERAN_CELL_STRU                                astGeranInfo[LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM];   /* gsmСб */
}LRRC_GRR_BSIC_VERIFIED_REQ_STRU;

/*****************************************************************************
     : GRR_LRRC_BSIC_VERIFIED_CNF_STRU
 ṹ˵  :
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
}GRR_LRRC_BSIC_VERIFIED_CNF_STRU;

/*****************************************************************************
     : GRR_LRRC_BSIC_VERIFIED_RESULT_STRU
 ṹ˵  : GģСbsic֤
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    LRRC_GRR_GERAN_CELL_INFO_STRU                           stGeranCellInfo;
    VOS_UINT32                                              usTimeAlignment;
    VOS_INT32                                               lFNOffset;
}GRR_LRRC_BSIC_VERIFIED_RESULT_STRU;

/*****************************************************************************
     : GRR_LRRC_BSIC_VERIFIED_IND_STRU
 ṹ˵  : Gģϱlte bsic֤Ϣṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT16                                              usOpId;             /* ʶ */
    VOS_UINT16                                              usArfcnNum;         /* Ƶ */
    GRR_LRRC_BSIC_VERIFIED_RESULT_STRU                      astGeranBsicVerifedResult[LRRC_GURRC_GERAN_CELL_FOR_BSIC_MAX_NUM]; /* Ƶbsic֤б */
}GRR_LRRC_BSIC_VERIFIED_IND_STRU;

/*****************************************************************************
     : LRRC_GRR_RELALL_REQ_STRU
 ṹ˵  : ltegģͷϢṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GRR_RELALL_REASON_ENUM_UINT8                       enRelReason;        /* LRRCͷԭ */
    VOS_UINT8                                               aucReserved[3];
}LRRC_GRR_RELALL_REQ_STRU;

/*****************************************************************************
     : GRR_LRRC_RELALL_CNF_STRU
 ṹ˵  : LRRC_GRR_RELALL_REQĻظϢṹ
 ޸ʷ  :
  1.     : 2014218
         : s00184266
    ޸ : ɽṹ

*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_RELALL_CNF_STRU;
/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */
#endif

/*****************************************************************************
 ṹ    : LRRC_GRR_CELL_SRCH_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRָʾС, ЯGСϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[1];
    LRRC_GURRC_CELL_CAMPEDON_TYPE_ENUM_UINT8                enCellCampedType;
    VOS_UINT16                                              usArfcnNum;
    LRRC_GURRC_GERAN_CELL_STRU                              astGeranCellInfo[LRRC_GURRC_GERAN_ARFCN_MAX_NUM];
}LRRC_GRR_CELL_SRCH_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_SRCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRLRRCָʾС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/

    /* ҵָפģʽGСʱʹLRRC_GURRC_CELL_RESEL_SUCC
       ûҵָפģʽGСʱʹLRRC_GURRC_CELL_RESEL_UNSPECIFIC */
    LRRC_GURRC_CELL_RESEL_RESULT_ENUM_UINT32                enRslt;

    /* ָפģʽפGСϢ, BSICϢGṩ enRsltΪɹ
       LBSICϢǷЧѡֱʹ */
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
    LRRC_GRR_GERAN_CELL_INFO_STRU                           stGeranCellInfo;
#else
    LRRC_GURRC_GERAN_CELL_INFO_STRU                         stGeranCellInfo;
#endif
    /* GСƽֵ,ʽ޷ȡΪԼЧֵ*/
    VOS_INT16                                               sGeranCellRxlev;
    VOS_UINT8                                               aucReserved[2];

    /* stSuitablePlmnIdstPlmnIdListϢֻפģʽΪsuitableʱ壬
       פģʽΪany cellʱʱԲ */

    /* enRslt = LRRC_GURRC_CELL_RESEL_SUCC дG CELLЯPLMN*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stSuitablePlmnId;

    /* enRslt = LRRC_GURRC_CELL_RESEL_UNSPECIFIC Яڴ˹
       еPLMN ϢԸߵ򴫵ݸLRRC׼ͬ
       PLMN LIST  */
    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}GRR_LRRC_CELL_SRCH_CNF_STRU;

/*****************************************************************************
 ṹ    : LRRC_GRR_CELL_SRCH_STOP_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾGRRֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_CELL_SRCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    : GRR_LRRC_CELL_SRCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRָʾLRRCֹͣС
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_CELL_SRCH_STOP_CNF_STRU;
#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
/*****************************************************************************
 ṹ    :   LRRC_GRR_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾGRRִб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stPlmnId;
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;       /* LRRC֪ͨGUѻPLMN LIST */
    VOS_UINT8                                               aucReserved[1];     /* λ */

    VOS_UINT16                                              usForbLaNum;        /* ֹעĸ */
    LRRC_GURRC_FORB_LA_STRU                                 astForbLaList[LRRC_GURRC_MAX_FORBLA_NUM];/* ֹעб */
}LRRC_GRR_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCִбõȷ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;             /* orֹͣ */
    VOS_UINT8                                               aucReserved[2];     /* λ */
}GRR_LRRC_BG_PLMN_SEARCH_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_PLMN_SEARCH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCִбĽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;             /* ʽɹʧܽ */
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;       /* LRRC֪ͨGUѻPLMN LIST */
    VOS_UINT8                                               aucReserved[1];     /* λ */
    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;       /* б */
}GRR_LRRC_BG_PLMN_SEARCH_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];     /* λ */
}LRRC_GRR_BG_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];     /* λ */
}GRR_LRRC_BG_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_SEARCH_SUSPEND_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾGRR𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_BG_SEARCH_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_SUSPEND_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCѹ𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_BG_SEARCH_SUSPEND_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_SEARCH_RESUME_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LRRCָʾGRRָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_BG_SEARCH_RESUME_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_RESUME_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCѻָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_BG_SEARCH_RESUME_CNF_STRU;
/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */
#endif
/*****************************************************************************
 ṹ    :   GRR_LRRC_BG_PLMN_SEARCH_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GRRָʾLRRCִб
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32               enMsgId;                        /*_H2ASN_Skip*/

    LRRC_GURRC_PLMN_ID_INFO_STRU                stPlmnId;

    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8           enSearchType;                   /* ѻPLMN LIST */

    VOS_UINT8                                   aucRsv1[3];
}GRR_LRRC_BG_PLMN_SEARCH_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_PLMN_SEARCH_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCִбȷ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                          enMsgId;             /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                enRslt;
    VOS_UINT8                                              aucRsv1[2];
}LRRC_GRR_BG_PLMN_SEARCH_CNF_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_PLMN_SEARCH_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRִбĽ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;             /*_H2ASN_Skip*/
    LRRC_GURRC_BG_SEARCH_RESULT_ENUM_UINT16                 enRslt;
    LRRC_GURRC_SEARCH_TYPE_ENUM_UINT8                       enSearchType;        /* ѻPLMN LIST */
    VOS_UINT8                                               aucRsv1[1];

    LRRC_GURRC_PLMN_ID_LIST_STRU                            stPlmnIdList;
}LRRC_GRR_BG_PLMN_SEARCH_IND_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_STOP_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRָʾLRRCֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                          enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}GRR_LRRC_BG_SEARCH_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_SEARCH_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRֹͣ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                          enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}LRRC_GRR_BG_SEARCH_STOP_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_SUSPEND_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRָʾLRRC𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_BG_SEARCH_SUSPEND_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_BG_SEARCH_SUSPEND_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRѹ𱳾
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_BG_SEARCH_SUSPEND_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_BG_SEARCH_RESUME_REQ_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GRRָʾLRRCָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                          enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];
}GRR_LRRC_BG_SEARCH_RESUME_REQ_STRU;

/*****************************************************************************
 ṹ    :   LRRC_GRR_BG_SEARCH_RESUME_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   LRRCָʾGRRѻָ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                          enMsgId;             /*_H2ASN_Skip*/
    VOS_UINT8                                              aucReserved[4];

}LRRC_GRR_BG_SEARCH_RESUME_CNF_STRU;

#if (FEATURE_ON == FEATURE_GU_DSP_SPLIT)
/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, begin */
/*****************************************************************************
 ṹ    :    LRRC_GRR_GET_CGI_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  LRRCָʾWRRCȡӦGSMСCGIϢ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GRR_GERAN_CELL_INFO_STRU                           stGeranCellInfo;
}LRRC_GRR_GET_CGI_REQ_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CELL_GLOBAL_ID_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GERAN CELL GLOBAL IDϢ
*****************************************************************************/
typedef struct
{
    LRRC_GURRC_PLMN_ID_INFO_STRU                            stPlmnId;
    VOS_UINT16                                              usLocAreaCode;
    VOS_UINT16                                              usCellId;
}LRRC_GRR_CELL_GLOBAL_ID_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_CGI_INFO_MEAS_RESULT_STRU
 Э  :
 ASN.1   :
 ṹ˵  :  GERAN CGIϢ
*****************************************************************************/
typedef struct
{
    LRRC_GRR_CELL_GLOBAL_ID_STRU                            stGsmCellGlobalId;
    VOS_INT16                                               sRssi;/* RSSIֵ ,ȡֵΧ[-110*8,-20*8], λ:dBm 1/8 */
    LRRC_GURRC_VALID_FLAG_ENUM_UINT8                        enRacPresent;
    VOS_UINT8                                               ucRoutingAreaCode;
}LRRC_GRR_CGI_INFO_MEAS_RESULT_STRU;

/*****************************************************************************
 ṹ    :  GRR_LRRC_GET_CGI_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  GRRָʾLRRCӦGSMСCGIϢȡý
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;
}GRR_LRRC_GET_CGI_CNF_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_GET_CGI_IND_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCӦGSMСCGIϢȡ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    LRRC_GURRC_GET_CGI_RESULT_ENUM_UINT32                   enRslt;

    LRRC_GRR_CGI_INFO_MEAS_RESULT_STRU                      stGsmCgiInfo;
}GRR_LRRC_GET_CGI_IND_STRU;

/*****************************************************************************
 ṹ    :    LRRC_GRR_GET_CGI_STOP_REQ_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LRRCָʾGRRֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}LRRC_GRR_GET_CGI_STOP_REQ_STRU;

/*****************************************************************************
 ṹ    :    GRR_LRRC_GET_CGI_STOP_CNF_STRU
 Э  :
 ASN.1 :
 ṹ˵  :   GRRָʾLRRCֹͣANR
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER                                                              /*_H2ASN_Skip*/
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgId;            /*_H2ASN_Skip*/
    VOS_UINT8                                               aucReserved[4];
}GRR_LRRC_GET_CGI_STOP_CNF_STRU;
/* Added by s00184266 for multi-mode evolution phase II, 2014-4-16, end */
#endif
/*****************************************************************************
 ṹ    : LRRC_GRR_MSG_DATA
 Э  :
 ASN.1 :
 ṹ˵  : LRRC_GRR_MSG_DATAݽṹASNļ
*****************************************************************************/
typedef struct
{
    LRRC_GRR_MSG_TYPE_ENUM_UINT32                           enMsgID;            /*_H2ASN_MsgChoice_Export LRRC_GRR_MSG_TYPE_ENUM_UINT32 */
    VOS_UINT8                                               aucMsg[4];
    /***************************************************************************
        _H2ASN_MsgChoice_When_Comment          LRRC_GRR_MSG_TYPE_ENUM_UINT32
    ****************************************************************************/
}LRRC_GRR_MSG_DATA;

/*_H2ASN_Length UINT32*/

/*****************************************************************************
 ṹ    : LRRCGRRInterface_MSG
 Э  :
 ASN.1 :
 ṹ˵  : LRRCGRRInterface_MSGݽṹ,ASNļ
*****************************************************************************/
typedef struct
{
    VOS_MSG_HEADER
    LRRC_GRR_MSG_DATA                                       stMsgData;
}LRrcGrrInterface_MSG;


/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/



#if (VOS_OS_VER != VOS_WIN32)
 #pragma pack()
#else
 #pragma pack(pop)
#endif

#ifdef __cplusplus
 #if __cplusplus
}
 #endif
#endif

#endif /* end of LRRC_GRRInterface.h */
