/******************************************************************************


        @(#)Copyright(C)2013,Hisilicon Co. LTD.

 ******************************************************************************
    File name   : ImsaImsApi.h
    Description : IMSAIMSЭջӿͷļ
    History     :
      1.sunbing 00049683    2013-07-15  Draft Enact
      2.sunbing 00049683    2013-10-10  API

******************************************************************************/

#ifndef __IMSAIMSAPI_H__
#define __IMSAIMSAPI_H__

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/


/*****************************************************************************
  1.1 Cplusplus Announce
*****************************************************************************/
#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
#pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 macro
*****************************************************************************/


/*****************************************************************************
  3 Massage Declare
*****************************************************************************/



/*****************************************************************************
  4 Enum
*****************************************************************************/
enum IMSA_VOICE_CODEC_ENUM
{
    IMSA_VOICE_CODEC_AMR_NB = 0,
    IMSA_VOICE_CODEC_EFR,
    IMSA_VOICE_CODEC_FR,
    IMSA_VOICE_CODEC_HR,
    IMSA_VOICE_CODEC_AMR_NB2,
    IMSA_VOICE_CODEC_AMR_WB,
    IMSA_VOICE_CODEC_G711,
    IMSA_VOICE_CODEC_BUTT
};
typedef unsigned short IMSA_VOICE_CODEC_ENUM_UINT16;

enum IMSA_CODEC_AMR_TYPE_TX_ENUM
{
    IMSA_CODEC_AMR_TYPE_TX_SPEECH_GOOD   = 0,
    IMSA_CODEC_AMR_TYPE_TX_SID_FIRST,
    IMSA_CODEC_AMR_TYPE_TX_SID_UPDATE,
    IMSA_CODEC_AMR_TYPE_TX_NO_DATA,
    IMSA_CODEC_AMR_TYPE_TX_SPEECH_DEGRADED,
    IMSA_CODEC_AMR_TYPE_TX_SPEECH_BAD,
    IMSA_CODEC_AMR_TYPE_TX_SID_BAD,
    IMSA_CODEC_AMR_TYPE_TX_ONSET,
    IMSA_CODEC_AMR_TYPE_TX_BUTT
};
typedef unsigned short IMSA_CODEC_AMR_TYPE_TX_ENUM_UINT16;

/* TIMER */
enum IMSA_TIMER_PRECISION_ENUM
{
    IMSA_TIMER_PRECISION_0   = 0,
    IMSA_TIMER_PRECISION_5   = 5,
    IMSA_TIMER_PRECISION_10   = 10,
    IMSA_TIMER_PRECISION_20   = 20,
    IMSA_TIMER_PRECISION_30   = 30,
    IMSA_TIMER_PRECISION_40   = 40,
    IMSA_TIMER_PRECISION_50   = 50,
    IMSA_TIMER_PRECISION_60   = 60,
    IMSA_TIMER_PRECISION_70   = 70,
    IMSA_TIMER_PRECISION_80   = 80,
    IMSA_TIMER_PRECISION_90   = 90,
    IMSA_TIMER_PRECISION_100   = 100,
    IMSA_TIMER_NO_PRECISION,
    IMSA_TIMER_PRECISION_BUTT
};
typedef unsigned int IMSA_TIMER_PRECISION_ENUM_UINT32;


typedef enum
{
    IMSA_IMS_TIMER_NAME_XXX = 500,
    IMSA_IMS_TIMER_NAME_BUTT
}IMSA_IMS_TIMER_NAME_ENUM;

typedef void (*TIMER_FUNC)(unsigned int ulParam, unsigned int ulTimerName);

typedef struct
{
    unsigned int                     ulLen;          /*ʱʱλmillisecond*/
    unsigned int                     ulTimerName;    /*ʱʶʱIMSA_IMS_TIMER_NAME_ENUMöֵ*/
    unsigned int                     ulParam;        /*ʱӲ*/
    unsigned char                    ucMode;         /*ʱģʽ0ζʱ,1ѭʱʱԶ*/
    unsigned char                    ucRever[3];
    IMSA_TIMER_PRECISION_ENUM_UINT32 enPrecision;    /*ʱȣʾ̵Ķʱٷֱ*/
    TIMER_FUNC                       TimeOutRoutine; /*صʱʱãصĲΪulTimerNameulTimerName*/
}IMSA_TIMER_PARA_STRU;


typedef struct
{
    IMSA_VOICE_CODEC_ENUM_UINT16  enCodecType;   /*ǰ֡codec,0ʾAMR,5ʾWB AMR,6ʾG711*/
    unsigned short                usDtxEnable;   /*֡ıDTXǷã0ʾ1ʾ*/
    unsigned short                usRateMode;    /*֡ıʣֵΪ08AMRAMR_WBʱЧ*/
    unsigned short                usErrorFlag;   /*֡Ƿlost packet,0ʾ1ʾ*/
    unsigned short                usFrameType;   /* б֡FrameType */
    unsigned short                usQualityIdx;  /* Quality indification */
    unsigned short                usSN;          /* к */
    unsigned short                usReserve;
    unsigned long                 ulTS;          /* ʱ */
    /* x00253310 add 20140227 begin */
    unsigned long                 ulSsrc;        /* synchronization source */
    /* x00253310 add 20140227 end */
}IMSA_RX_VOICE_PARA_STRU;


typedef struct
{
    IMSA_CODEC_AMR_TYPE_TX_ENUM_UINT16  usStatus;
    unsigned short                      usFrameType;  /* б֡FrameType */
}IMSA_TX_VOICE_PARA_STRU;



/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/
/**
 * \brief ˼ṩAPIIMSЭջ绰HIFIʽıʱã
 *        ڸAPIУIMSA֪ͨHIFI룬codec
 * @param[in]   enCodeType     codec
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_StartVoiceDsp
(
    IMSA_VOICE_CODEC_ENUM_UINT16    enCodecType,
    unsigned long                   ulPacketTime
);

/**
 * \brief ˼ṩAPIIMSЭջڹҶе绰
 *        ڸAPIУIMSA֪ͨHIFI,ֹͣ
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_StopVoiceDsp(void);

/**
 * \brief ˼ṩAPIIMSЭջյݺã
 *        ݷ͸HIFIHIFIյ
 * @param[in]   pstVoicePara   Ϣŵַݿռɵͷ
 * @param[in]   pusData        ݴŵַռСΪ160byteݿռɵͷ
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_Send2HifiRxVoiceData(const IMSA_RX_VOICE_PARA_STRU *pstVoicePara,
                                                        const unsigned short *pusData);
/**
 * \brief IMSЭջṩ˼API
 *        HIFI󣬷IMSAIMSAյøAPIݷIMSЭջ
 * @param[in]   pstVoicePara   Ϣŵַݿռɵ(˼)ͷ
 * @param[in]   pusData        ݴŵַռСΪ160byteݿռɵ(˼)ͷ
 * @retval 
 */
extern void IMSA_Send2ImsTxVoiceData(const IMSA_TX_VOICE_PARA_STRU *pstVoicePara,
                                              const unsigned short *pusData);

/**
 * \brief ˼ṩAPIIMSЭջIMSAϢʱ
 *
 * @param[in]   pstOutputEvent    ¼ŵַݿռɵͷţΪIMSA_IMS_OUTPUT_EVENT_STRU
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_Send2ImsaMsg(void *pstOutputEvent);

/**
 * \brief ˼ṩAPIIMSЭջʱ
 *
 * @param[in]    pstTimerPara ʱŵַݿռɵͷ
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_ImsStartTimer(const IMSA_TIMER_PARA_STRU  *pstTimerPara);


/**
 * \brief ˼ṩAPIIMSЭջֹͣʱ
 *
 * @param[in]    ulTimerName ʱ
 * @retval 0ɹ1ʧ
 */
extern unsigned int IMSA_ImsStopTimer(unsigned int  ulTimerName);

/**
 * \brief IMSЭջṩ˼APIIMSЭջĳʼ
 * @retval 0ʧܣ1ɹ
 */
extern unsigned int IMSA_ImsInit(void);


/**
 * \brief IMSЭջṩ˼APIڸIMSЭջ¼
 *
 * @param[in]    pstInputEvent INPUT¼ָ ΪIMSA_IMS_INPUT_EVENT_STRU
 * @retval 0ʧܣ1ɹ
 */
extern unsigned int IMSA_WriteImsEvent(void *pstInputEvent);

/**
 * \brief IMSЭջṩ˼APIIMSЭջṩSrvccתCSĺб
 *
 * @param[in]    pstSrvccCallList ΪIMSA_IMS_SRVCC_CALL_LIST_STRUڴɺ˼
 * @retval 0ʧܣ1ɹ
 */
extern unsigned int IMSA_ImsWriteSrvccCallList(void *pstSrvccCallList);

/*****************************************************************************
  9 OTHERS
*****************************************************************************/


#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif




#ifdef __cplusplus
    #if __cplusplus
            }
    #endif
#endif

#endif /* end of ImsaImsApi.h */




