/******************************************************************************

                  Ȩ (C), 2001-2011, Ϊ޹˾

 ******************************************************************************
       : TtfMemoryMap.h
       : 
         : s00164817
     : 20111223
  ޸   :
     : MemoryMap.h ͷļ
  б   :
  ޸ʷ   :
  1.       : 20111223
           : s00164817
    ޸   : ļ

******************************************************************************/

#ifndef __TTFMEMORYMAP_H__
#define __TTFMEMORYMAP_H__


/*****************************************************************************
  1 ͷļ
*****************************************************************************/
#include "product_config.h"
#include "MemoryMap.h"


#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif




/*****************************************************************************
  2 궨
*****************************************************************************/
/* 32 ֽڶ */
#define TTF_GET_32BYTE_ALIGN_VALUE(ulAddr)   (((unsigned long)(ulAddr) + 0x1F) & (~0x1F))

    /*********Uncache mem(20M) deploy begin*********/
    /*->startAddr|-------------------------------|   */
    /*           |HDLC_DEF_INPUT_PARA_LINK_BUF   |   */
    /*           |-----------------------------  |   */
    /*           |      HDLC_DEF_RPT_BUF         |   */
    /*           |-----------------------------  |   */
    /*           |     HDLC_DEF_OUTPUT_BUF       |   */
    /*           |-----------------------------  |   */
    /*           |HDLC_FRM_INPUT_PARA_LINK_BUF   |   */
    /*           |-----------------------------  |   */
    /*           |    HDLC_FRM_RPT_BUF_ADDR      |   */
    /*           |-----------------------------  |   */
    /*           |HDLC_FRM_OUTPUT_PARA_LINK_BUF  |   */
    /*           |-----------------------------  |   */
    /*           |         PAD (0-31B)           |   */
    /*           |-----------------------------  |   */
    /*           |UL CIPHER PARA NODE(35k)       |   */
    /*           |-------------------------------|   */
    /*           |UL CIPHER SRC SEG DATA (51k)   |   */
    /*           |-------------------------------|   */
    /*           |UL CIPHER DST SEG DATA (51k)   |   */
    /*           |-------------------------------|   */
    /*           |   UL CIPHER KEY (1k)          |   */
    /*           |-------------------------------|   */
    /*           |DL CIPHER PARA NODE(11k)       |   */
    /*           |-------------------------------|   */
    /*           |DL CIPHER MAC SEG DATA(155k)   |   */
    /*           |-------------------------------|   */
    /*           |DL CIPHER RLC SEG DATA(155k)   |   */
    /*           |-------------------------------|   */
    /*           |   DL CIPHER KEY (1k)          |   */
    /*           |-------------------------------|   */
    /*           |TTF_LL_CIPHER_PARA_NODE(1k)    |   */
    /*           |-------------------------------|   */
    /*           |TTF_LL_CIPHER_KEY(16B)         |   */
    /*           |-------------------------------|   */
    /*           |TTF_LL_CIPHER_ARRAY(1560B)     |   */
    /*           |-------------------------------|   */
    /*           |I1_TTF_LL_CIPHER_PARA_NODE(1k) |   */
    /*           |-------------------------------|   */
    /*           |I1_TTF_LL_CIPHER_KEY(16B)      |   */
    /*           |-------------------------------|   */
    /*           |I1_TTF_LL_CIPHER_ARRAY(1560B)  |   */
    /*           |-------------------------------|   */
    /*           |         PAD (0-31B)           |   */
    /*           |-----------------------------  |   */
    /*           |                               |   */
    /*           |     TTF_BBPMASTER_MEM         |   */
    /*           |                               |   */
    /*           |-----------------------------  |   */
    /*           |                               |   */
    /*           |     TTF_ACORE_POOL_MEM        |   */
    /*           |                               |   */
    /*           |-----------------------------  |   */
    /*           |         PAD (0-31B)           |   */
    /*           |-----------------------------  |   */
    /*           |                               |   */
    /*           |     TTF_CCORE_POOL_MEM        |   */
    /*           |                               |   */
    /*           |-----------------------------  |   */


/* TTFڴСͻַ */

/* ڵڴ */

/* HDLC 豸ʹʼַ */
#define TTF_HDLC_MASTER_START_ADDR(BaseAddr) \
            (TTF_MEMCTRL_GetTypeAddr((TTF_GET_32BYTE_ALIGN_VALUE(BaseAddr)), TTF_MEMCTRL_HDLC_MASTER_ADDR_TYPE))

/* CICOM 豸ʹʼַ*/
#define TTF_UL_CIPHER_PARA_NODE_ADDR(BaseAddr) \
            (TTF_MEMCTRL_GetTypeAddr((TTF_GET_32BYTE_ALIGN_VALUE(BaseAddr)), TTF_MEMCTRL_CIPHER_MASTER_ADDR_TYPE))

/* BBP Masterʹڴַ */
#define TTF_BBP_MASTER_START_ADDR(BaseAddr) \
            (TTF_MEMCTRL_GetTypeAddr((TTF_GET_32BYTE_ALIGN_VALUE(BaseAddr)), TTF_MEMCTRL_BBP_MASTER_ADDR_TYPE))

/* A CPU cacheڴַ */
#define TTF_ACORE_POOL_MEM_START_ADDR(BaseAddr) \
            (TTF_MEMCTRL_GetTypeAddr((TTF_GET_32BYTE_ALIGN_VALUE(BaseAddr)), TTF_MEMCTRL_ACORE_POOL_ADDR_TYPE))

/* C CPU cacheڴַ */
#define TTF_CCORE_POOL_MEM_START_ADDR(BaseAddr) \
            (TTF_MEMCTRL_GetTypeAddr((TTF_GET_32BYTE_ALIGN_VALUE(BaseAddr)), TTF_MEMCTRL_CCORE_POOL_ADDR_TYPE))


/* ----------------HDLCŻڴ START---------------- */

/* HDLC Master豸ʹڴַ */
#if 0
/* HDLC 豸ʹʼַ */
#define TTF_HDLC_MASTER_START_ADDR(BaseAddr)                TTF_GET_8BYTE_ALIGN_VALUE(BaseAddr)
#endif

/* װڵ */
#define TTF_HDLC_DEF_INPUT_PARA_LINK_MAX_NUM        (20)

/* װڴСͻַ
   HDLC_DEF_INPUT_PARA_LINK_MAX_NUM * sizeof(HDLC_PARA_LINK_NODE_STRU) */
#define TTF_HDLC_DEF_INPUT_PARA_LINK_BUF_LEN        (TTF_HDLC_DEF_INPUT_PARA_LINK_MAX_NUM * 12)

/* װܳ */
#define TTF_HDLC_DEF_INPUT_PARA_LINK_MAX_SIZE       (13*1024)


/* һνװIP/PPP֡ = һνװ볤/СIP(20B) */
#define TTF_HDLC_DEF_OUTPUT_MAX_NUM                 (TTF_HDLC_DEF_INPUT_PARA_LINK_MAX_SIZE/20)

/* װϢϱ */
#define TTF_HDLC_DEF_RPT_MAX_NUM                    (TTF_HDLC_DEF_OUTPUT_MAX_NUM)

/* װϢϱռڴСͻַ
   һνװIP/PPP֡*sizeof(HDLC_FRM_RPT_NODE) */
#define TTF_HDLC_DEF_RPT_BUF_LEN                    (TTF_HDLC_DEF_RPT_MAX_NUM*8)

/* ((TTF_HDLC_DEF_INPUT_PARA_LINK_MAX_SIZE / 6 + 1) * 8)
 * 6ΪռռСЧ֡
 * 8Ϊֽڶ
 * +1 ΪСȡ
*/

#define TTF_HDLC_DEF_OUTPUT_DATA_BUF_LEN            (18 * 1024)

    /* HDLC MASTER豸ʹõڴܳȣṹHDLC_DEF_BUFF_INFO_STRU仯ʱ
        úӦӦ仯 */
#define TTF_HDLC_MASTER_DEF_BUF_LEN                 (TTF_HDLC_DEF_INPUT_PARA_LINK_BUF_LEN + \
                                                        TTF_HDLC_DEF_RPT_BUF_LEN + \
                                                        TTF_HDLC_DEF_OUTPUT_DATA_BUF_LEN)

/* װڵ */
#define TTF_HDLC_FRM_INPUT_PARA_LINK_MAX_NUM        (20)

/* װܳ */
#define TTF_HDLC_FRM_INPUT_PARA_LINK_MAX_SIZE       (15*1024)

/* װڴС = TTF_HDLC_FRM_INPUT_PARA_LINK_MAX_NUM * sizeof(HDLC_PARA_LINK_NODE_STRU) */
#define TTF_HDLC_FRM_INPUT_PARA_LINK_BUF_LEN        (TTF_HDLC_FRM_INPUT_PARA_LINK_MAX_NUM * 12)

/* װϢ */
#define TTF_HDLC_FRM_RPT_MAX_NUM                    (TTF_HDLC_FRM_INPUT_PARA_LINK_MAX_NUM)

/* װϢϱռڴСͻַ
   TTF_HDLC_FRM_RPT_MAX_NUM * sizeof(HDLC_DEF_RPT_NODE) */
#define TTF_HDLC_FRM_RPT_BUF_LEN                    (TTF_HDLC_FRM_RPT_MAX_NUM * 8)

/* װڵ */
#define TTF_HDLC_FRM_OUTPUT_PARA_LINK_MAX_NUM       (40)

/* װڴСͻַ
   TTF_HDLC_FRM_OUTPUT_PARA_LINK_MAX_NUM * sizeof(HDLC_PARA_LINK_NODE_STRU) */
#define TTF_HDLC_FRM_OUTPUT_PARA_LINK_BUF_LEN       (TTF_HDLC_FRM_OUTPUT_PARA_LINK_MAX_NUM * 12)

/* HDLC MASTER豸ʹõڴܳȣṹHDLC_FRM_BUFF_INFO_STRU仯ʱ
    úӦӦ仯 */
#define TTF_HDLC_MASTER_FRM_BUF_LEN                 (TTF_HDLC_FRM_INPUT_PARA_LINK_BUF_LEN + \
                                                        TTF_HDLC_FRM_RPT_BUF_LEN + \
                                                        TTF_HDLC_FRM_OUTPUT_PARA_LINK_BUF_LEN)

#if (FEATURE_ON == FEATURE_PPP)
/* HDLC MASTER豸ʹõڴܳ */
#define TTF_HDLC_MASTER_LINK_TOTAL_LEN              (TTF_GET_32BYTE_ALIGN_VALUE((TTF_HDLC_MASTER_DEF_BUF_LEN + \
                                                        TTF_HDLC_MASTER_FRM_BUF_LEN)))
#else
#define TTF_HDLC_MASTER_LINK_TOTAL_LEN              (0)
#endif

/* ----------------HDLCŻڴ END---------------- */

#if 0
/* HDLC Master豸ʹڴβַ */
#define TTF_HDLC_MASTER_END_ADDR(BaseAddr)\
           (TTF_HDLC_MASTER_START_ADDR(BaseAddr) + TTF_HDLC_MASTER_LINK_LEN)

/* ----------------HDLCŻڴ END---------------- */
/* CICOM 豸ʹʼַ*/
#if (FEATURE_ON == FEATURE_PPP) && defined(FEATURE_HDLC_MASTER)
#define TTF_UL_CIPHER_PARA_NODE_ADDR(BaseAddr)  TTF_GET_32BYTE_ALIGN_VALUE(TTF_HDLC_MASTER_END_ADDR(BaseAddr))/* òҪ8ֽڶ */
#else
#define TTF_UL_CIPHER_PARA_NODE_ADDR(BaseAddr) TTF_GET_8BYTE_ALIGN_VALUE(BaseAddr) /* òҪ8ֽڶ */
#endif
#endif

/* ----------------CICOM豸ڴ START---------------- */

/*1096(WTTF_MAX_PDU_NUM_PER_UL_LOCH) * 32Byte(RLC_PDU_SEG_CIPHER_PARA_STRU)  35KByte*/
#define TTF_UL_CIPHER_PARA_NODE_LEN         (35*1024)

#define TTF_UL_CIPHER_SRC_SEG_DATA_ADDR(BaseAddr)\
           (TTF_UL_CIPHER_PARA_NODE_ADDR(BaseAddr) + TTF_UL_CIPHER_PARA_NODE_LEN)

#define TTF_UL_CIPHER_SRC_SEG_DATA_LEN      (51*1024)

#define TTF_UL_CIPHER_DST_SEG_DATA_ADDR(BaseAddr)\
            (TTF_UL_CIPHER_SRC_SEG_DATA_ADDR(BaseAddr) + TTF_UL_CIPHER_SRC_SEG_DATA_LEN)

#define TTF_UL_CIPHER_DST_SEG_DATA_LEN      (51*1024)

#define TTF_UL_CIPHER_KEY_ADDR(BaseAddr)\
            (TTF_UL_CIPHER_DST_SEG_DATA_ADDR(BaseAddr) + TTF_UL_CIPHER_DST_SEG_DATA_LEN)

/* мԿʹڴ泤Ⱥͻַ
   3(RLC_CPH_CFG_NUM) * 16Byte(WUE_CIPHER_KEY_LEN) = 48Byte ȡΪ1K */
#define TTF_UL_CIPHER_KEY_LEN               (1*1024)

#define TTF_DL_CIPHER_PARA_NODE_ADDR(BaseAddr)\
           (TTF_UL_CIPHER_KEY_ADDR(BaseAddr) + TTF_UL_CIPHER_KEY_LEN)

/* нܲڵʹڴ泤Ⱥͻַ
    350(WTTF_MAX_PDU_NUM_PER_DL_LOCH) * 32Byte(RLC_PDU_SEG_CIPHER_PARA_STRU)  11KByte */
#define TTF_DL_CIPHER_PARA_NODE_LEN         (11*1024)

/* Modified Mem Reduce End */
#define TTF_DL_CIPHER_MAC_SEG_DATA_ADDR(BaseAddr)\
           (TTF_DL_CIPHER_PARA_NODE_ADDR(BaseAddr) + TTF_DL_CIPHER_PARA_NODE_LEN)

/* MAC-ehs SDUֶʹڴ泤Ⱥͻַ */
/*13200(WTTF_MAC_EHS_SDU_SEG_DATA_NUM) * 12Byte(SEG_DATA_STRUС)  155KByte */
#define TTF_DL_CIPHER_MAC_SEG_DATA_LEN      (155*1024)

#define TTF_DL_CIPHER_SEG_DATA_ADDR(BaseAddr)\
           (TTF_DL_CIPHER_MAC_SEG_DATA_ADDR(BaseAddr) + TTF_DL_CIPHER_MAC_SEG_DATA_LEN)

#define TTF_DL_RLC_CIPHER_SEG_DATA_LEN      (155*1024)

#define TTF_DL_CIPHER_KEY_ADDR(BaseAddr)\
           (TTF_DL_CIPHER_SEG_DATA_ADDR(BaseAddr) + TTF_DL_RLC_CIPHER_SEG_DATA_LEN)

/* нԿʹڴ泤Ⱥͻַ
   3(RLC_CPH_CFG_NUM) * 16Byte(WUE_CIPHER_KEY_LEN) = 48Byte ȡΪ1K */
#define TTF_DL_CIPHER_KEY_LEN               (1*1024)

#define TTF_UL_CIPHER_PDU_NODE_TOTAL_LEN    \
    (TTF_UL_CIPHER_PARA_NODE_LEN + TTF_UL_CIPHER_SRC_SEG_DATA_LEN + TTF_UL_CIPHER_DST_SEG_DATA_LEN)

#define TTF_DL_CIPHER_PDU_NODE_TOTAL_LEN    \
    (TTF_DL_CIPHER_PARA_NODE_LEN + TTF_DL_CIPHER_MAC_SEG_DATA_LEN + TTF_DL_RLC_CIPHER_SEG_DATA_LEN)

/* Wģ MASTER豸ʹõڴܳ */
#define TTF_CIPHER_MASTER_LINK_LEN          (TTF_UL_CIPHER_PDU_NODE_TOTAL_LEN + TTF_UL_CIPHER_KEY_LEN + \
                                             TTF_DL_CIPHER_PDU_NODE_TOTAL_LEN + TTF_DL_CIPHER_KEY_LEN)

/* Gģӽʹõڴ */
#define TTF_LL_CIPHER_PARA_NODE_ADDR(BaseAddr) \
           (TTF_UL_CIPHER_PARA_NODE_ADDR(BaseAddr) + TTF_CIPHER_MASTER_LINK_LEN)

/*1(ÿֻһLLC PDUĿǰȶΪLLC PDUһTTF MEM) * 32Byte(sizeof(LLC_PDU_SEG_CIPHER_PARA_STRU)) = 32Byte*/
#define TTF_LL_CIPHER_PARA_NODE_LEN     (1*1024)

/* CKڴʼַ */
#define TTF_LL_CIPHER_KEY_ADDR(BaseAddr)\
           (TTF_LL_CIPHER_PARA_NODE_ADDR(BaseAddr) + TTF_LL_CIPHER_PARA_NODE_LEN)

/* ԿΪ1飬Ϊ16ֽ */
#define TTF_CIPHER_KEY_LEN              (1*16)

/* żļӽеڴ */
#define TTF_LL_CIPHER_ARRAY_ADDR(BaseAddr)\
           (TTF_LL_CIPHER_KEY_ADDR(BaseAddr) + TTF_CIPHER_KEY_LEN)

/* ӽΪ1560Bytes*/
#define TTF_CIPHER_KEY_ARRAY_LEN        (1560)

/* Modem1GSMӽʹõڴ */
#define I1_TTF_LL_CIPHER_PARA_NODE_ADDR(BaseAddr) \
            (TTF_LL_CIPHER_ARRAY_ADDR(BaseAddr) + TTF_CIPHER_KEY_ARRAY_LEN)

/* CKڴʼַ */
#define I1_TTF_LL_CIPHER_KEY_ADDR(BaseAddr)\
            (I1_TTF_LL_CIPHER_PARA_NODE_ADDR(BaseAddr) + TTF_LL_CIPHER_PARA_NODE_LEN)

/* żļӽеڴ */
#define I1_TTF_LL_CIPHER_ARRAY_ADDR(BaseAddr)\
            (I1_TTF_LL_CIPHER_KEY_ADDR(BaseAddr) + TTF_CIPHER_KEY_LEN)

/* Modem0GģLLC MASTER豸ʹõڴܳ */
#define I0_TTF_LL_CIPHER_MASTER_LINK_LEN   \
            (TTF_LL_CIPHER_PARA_NODE_LEN + TTF_CIPHER_KEY_LEN + TTF_CIPHER_KEY_ARRAY_LEN)

/* Modem1GģLLC MASTER豸ʹõڴܳ */
#define I1_TTF_LL_CIPHER_MASTER_LINK_LEN   \
            (TTF_LL_CIPHER_PARA_NODE_LEN + TTF_CIPHER_KEY_LEN + TTF_CIPHER_KEY_ARRAY_LEN)

/* GģLLC MASTER豸ʹõڴܳ */
#define TTF_LL_CIPHER_MASTER_LINK_LEN   \
            (I0_TTF_LL_CIPHER_MASTER_LINK_LEN + I1_TTF_LL_CIPHER_MASTER_LINK_LEN )

/*
    TTFMem.cеg_ulTtfActiveMemTotalLen¼˸ƽ̨ECS_TTF_SIZEʵʹõܴС
    ޸ļܲڴڴشСʱʹCOMM_CODE_GU/ConfigĿ¼Ӧƽ̨FeatureXXX.hļ
    COMM_CODE_GU\Balong_GU_Inc\win32Ŀ¼µļȻUṬg_ulTtfActiveMemTotalLen
    ȷg_ulTtfActiveMemTotalLenMemoryMap.hеֵECS_TTF_SIZE
*/
#define TTF_PARA_MEM_TOTAL_LEN    \
            (TTF_GET_32BYTE_ALIGN_VALUE(TTF_CIPHER_MASTER_LINK_LEN + TTF_LL_CIPHER_MASTER_LINK_LEN))


#if 0
/* CIPHER Master豸ʹڴβַ */
#define TTF_CIPHER_MASTER_END_ADDR(BaseAddr)\
           (I1_TTF_LL_CIPHER_ARRAY_ADDR(BaseAddr) + TTF_CIPHER_KEY_ARRAY_LEN)
#endif

/* ----------------CICOM豸ڴ END---------------- */


/* ----------------BBPMASTERڴ START---------------- */
#if 0
/* ----------------BBPMASTERڴ START---------------- */
/* BBP Masterʹڴַ */
#define TTF_BBP_MASTER_START_ADDR(BaseAddr)                 (TTF_GET_32BYTE_ALIGN_VALUE(TTF_CIPHER_MASTER_END_ADDR(BaseAddr)))
#endif
#if (FEATURE_ON == FEATURE_BBP_MASTER)
/* BBPMASTER DATA BUFF LENTH (WTTFPHY_MAC_HSDPA_TB_DATA_SIZEһ) */
#define TTF_BBPMST_BUFF_TOTAL_LEN             (5408)
#else
#define TTF_BBPMST_BUFF_TOTAL_LEN             (0)
#endif

#if 0
/* HDLC Master豸ʹڴβַ */
#define TTF_BBP_MASTER_END_ADDR(BaseAddr)\
           (TTF_CIPHER_MASTER_END_ADDR(BaseAddr) + TTF_BBPMST_BUFF_LEN)
#endif
/* ----------------BBPMASTERڴ END---------------- */


/* ----------------A CPU cacheڴ START---------------- */
/* ڴؿ */
#if ( FEATURE_ON == FEATURE_LTE )
/* LTEڴܳ:   WithWifi      12,854,528 ֽ
                        WithOutWifi   12,620,608 ֽ */
/* ==================================================== */
/* IMM MEM ڴؿ */
#define IMM_MEM_CTRL_MEM_CNT                (2103)

/*******************************************************************************
const IMM_MEM_CLUSTER_CFG_INFO_STRU   g_astImmMemSharePoolClusterTableInfo[] =
{
        {864,                           1427},
#if(FEATURE_WIFI == FEATURE_ON )
        {1952,                          1887}
#else
        {1888,                          1887}
#endif
};

ڴܳ: WithWifi      4,826,240ֽ
              WithOutWifi   4,707,520ֽ
*******************************************************************************/
/* IMM MEM ڴλڴС */
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_0           (864)
#if(FEATURE_WIFI == FEATURE_ON)
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1           (1952)
#else
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1           (1888)
#endif

/* IMM MEM ڴλڴ */
#define IMM_MEM_SHARE_POOL_CNT_CLUSTER_0            (1427)
#define IMM_MEM_SHARE_POOL_CNT_CLUSTER_1            (1887)

/* IMM MEM ڴܿ */
#define IMM_MEM_SHARE_POOL_MEM_CNT                  (IMM_MEM_SHARE_POOL_CNT_CLUSTER_0 + IMM_MEM_SHARE_POOL_CNT_CLUSTER_1)

/* IMM MEM ڴܴС */
#define IMM_MEM_SHARE_POOL_TOTAL_LEN                ((IMM_MEM_SHARE_POOL_SIZE_CLUSTER_0 * IMM_MEM_SHARE_POOL_CNT_CLUSTER_0) + \
                                                     (IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1 * IMM_MEM_SHARE_POOL_CNT_CLUSTER_1))

/* TTF MEM ڴؿ */
#define TTF_MEM_CTRL_MEM_CNT                        (IMM_MEM_SHARE_POOL_MEM_CNT)

#else

/* LTEڴܳ:   WithWifi      9,789,888 ֽ
                        WithOutWifi   9,656,448 ֽ */
/* IMM MEM ڴؿ */
#define IMM_MEM_CTRL_MEM_CNT                        (533)

/*******************************************************************************
const IMM_MEM_CLUSTER_CFG_INFO_STRU    g_astImmMemSharePoolClusterTableInfo[] =
{
        {864,                           1427},
#if(FEATURE_WIFI == FEATURE_ON )
        {1952,                          1887}
#else
        {1888,                          1887}
#endif
};


ڴܳ: WithWifi      4,826,240ֽ
              WithOutWifi   4,707,520ֽ
*******************************************************************************/
/* IMM MEM ڴλڴС */
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_0           (864)
#if(FEATURE_WIFI == FEATURE_ON)
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1           (1952)
#else
#define IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1           (1888)
#endif

/* IMM MEM ڴλڴ */
#define IMM_MEM_SHARE_POOL_CNT_CLUSTER_0            (1510)
#define IMM_MEM_SHARE_POOL_CNT_CLUSTER_1            (1440)

/* IMM MEM ڴܿ */
#define IMM_MEM_SHARE_POOL_MEM_CNT                  (IMM_MEM_SHARE_POOL_CNT_CLUSTER_0 + IMM_MEM_SHARE_POOL_CNT_CLUSTER_1)

/* IMM MEM ڴܴС */
#define IMM_MEM_SHARE_POOL_TOTAL_LEN                ((IMM_MEM_SHARE_POOL_SIZE_CLUSTER_0 * IMM_MEM_SHARE_POOL_CNT_CLUSTER_0) + \
                                                     (IMM_MEM_SHARE_POOL_SIZE_CLUSTER_1 * IMM_MEM_SHARE_POOL_CNT_CLUSTER_1))

/* TTF MEM ڴؿ */
#define TTF_MEM_CTRL_MEM_CNT                        (IMM_MEM_SHARE_POOL_MEM_CNT)
#endif




#if 0
#if (FEATURE_ON == FEATURE_BBP_MASTER)
/* A CPU cacheڴַ */
#define TTF_ACORE_POOL_MEM_START_ADDR(BaseAddr) (TTF_GET_32BYTE_ALIGN_VALUE(TTF_BBP_MASTER_END_ADDR(BaseAddr)))
#else
/* A CPU cacheڴַ */
#define TTF_ACORE_POOL_MEM_START_ADDR(BaseAddr) (TTF_GET_32BYTE_ALIGN_VALUE(TTF_CIPHER_MASTER_END_ADDR(BaseAddr)))
#endif
#endif
/* IMM MEM ڴͷܿ*/
#define IMM_MEM_CTRL_MEM_TOTAL_CNT              (IMM_MEM_SHARE_POOL_MEM_CNT + IMM_MEM_CTRL_MEM_CNT)

/* A CPU IMMڴػַ */
#define IMM_MEM_POOL_BASE_ADDR(BaseAddr)        ((TTF_ACORE_POOL_MEM_START_ADDR(BaseAddr)))

/* A CPU ڴʼַ */
#define IMM_SHARE_MEM_POOL_ADDR(BaseAddr)       (IMM_MEM_POOL_BASE_ADDR(BaseAddr))

#if (FEATURE_ON == FEATURE_SKB_EXP)   /* V3R3汾 */
/* A CPU ڴܴС */
#define TTF_ACORE_POOL_MEM_TOTAL_LEN            (TTF_GET_32BYTE_ALIGN_VALUE(IMM_MEM_SHARE_POOL_TOTAL_LEN))
#else
#define TTF_ACORE_POOL_MEM_TOTAL_LEN            (0)
#endif


#if 0
/* A CPU cacheڴβַ */
#define TTF_ACORE_POOL_MEM_END_ADDR(BaseAddr)   (TTF_ACORE_POOL_MEM_START_ADDR(BaseAddr) + TTF_ACORE_POOL_MEM_TOTAL_LEN)

/* C CPU cacheڴַ */
#define TTF_CCORE_POOL_MEM_START_ADDR(BaseAddr) (TTF_GET_32BYTE_ALIGN_VALUE(TTF_ACORE_POOL_MEM_END_ADDR(BaseAddr)))
#endif



/* ûںڴͷŹڴ */
#define TTF_MEM_FREE_AREA_SIZE                  (16*1024)
#define TTF_MEM_FREE_QUE_LEN                    (4000)

#define IMM_MEM_FREE_AREA_SIZE                  (16*1024)
#define IMM_MEM_FREE_QUE_LEN                    (4000)

#if 0
/* TTF_GET_32BYTE_ALIGN_VALUEܵڴַƫ31ֽڣûмڳ
   ڼCڴػǰΣֱTTF_HDLC_DEF_INPUT_PARA_LINK_BUF_ADDR
   TTF_ACORE_POOL_MEM_START_ADDRTTF_CCORE_POOL_MEM_START_ADDR */
#define TTF_MEM_32BYTE_ALIGN_PADDING_LEN       (3*32)
#endif

/* ----------------A CPU cacheڴ END---------------- */


/* ----------------C CPU cacheڴ START--------------- */

/* C CPU TTF MEMڴػַ */
#define TTF_MEM_POOL_BASE_ADDR(BaseAddr)        (TTF_CCORE_POOL_MEM_START_ADDR(BaseAddr))

#define TTF_CCORE_POOL_MEM_TOTAL_LEN            (12035808) /* C-CPU ڴܳȣ32ֽڶ */

/* ----------------C CPU cacheڴ END---------------- */


/*****************************************************************************
  3 öٶ
*****************************************************************************/
enum TTF_MEMCTRL_ADDR_TYPE_ENUM
{
    TTF_MEMCTRL_HDLC_MASTER_ADDR_TYPE   = 0,
    TTF_MEMCTRL_CIPHER_MASTER_ADDR_TYPE,
    TTF_MEMCTRL_BBP_MASTER_ADDR_TYPE,
    TTF_MEMCTRL_ACORE_POOL_ADDR_TYPE,
    TTF_MEMCTRL_CCORE_POOL_ADDR_TYPE,
    TTF_MEMCTRL_ADDR_TYPE_BUTT
};
typedef unsigned long TTF_MEMCTRL_ADDR_TYPE_ENUM_UINT32;

/*****************************************************************************
  8 UNION
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/



/*****************************************************************************
  10 
*****************************************************************************/
extern unsigned long   TTF_MEMCTRL_ACORE_AddrInit(void);
extern unsigned long   TTF_MEMCTRL_CCORE_AddrInit(void);
extern unsigned long   TTF_MEMCTRL_GetOffsetBaseLen(unsigned long  ulType);
extern unsigned long   TTF_MEMCTRL_GetTypeAddr(unsigned long ulAddr, unsigned long  ulType);


#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of TtfMemoryMap.h */

