/******************************************************************************
  Copyright   : 2005-2010, Huawei Tech. Co., Ltd.
  File name   : PppInterface.h
  Author      : g45205
  Version     : V100R001
  Date        : 2008-03-03
  Description : ͷļ---
  History     :
  1. Date:2008-03-03
     Author: g45205
     Modification:Create
******************************************************************************/

#ifndef __PPP_INTERFACE_H__
#define __PPP_INTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/******************************************************************************
  1 ͷļ
******************************************************************************/
#include "vos.h"
#include "product_config.h"
#include "PsTypeDef.h"
#if (VOS_WIN32 == VOS_OS_VER) || (OSA_CPU_ACPU == VOS_OSA_CPU)
#include "ImmInterface.h"
#include "AdsDeviceInterface.h"
#endif
/******************************************************************************
  2 궨
******************************************************************************/
/*ϵͳҪPPP IDĿ */
#define PPP_MAX_ID_NUM                      (1)

/*RABID*/
#define PPP_INVALID_RABID                   (0xFF)

/*PPPID*/
#define PPP_INVLAID_PPP_ID                  (0)


/*fanzhibin f49086 add it begin*/
#define AUTHLEN                             (100)    /* Size of authname/authkey(porting from BSD, not alter) */
#define PASSWORDLEN                         (100)    /* Size of authname/authkey(define by fanzhibin) */
#define CHAPCHALLENGELEN                    (48)     /* Maximum chap challenge(porting from BSD, not alter) */
#define MD5DIGESTSIZE                       (16)     /* MD5 (Message-Digest) hash size */
/*fanzhibin f49086 add it end*/

#define PPP_PAP_REQ_BUF_MAX_LEN             (PASSWORDLEN + AUTHLEN)

/* code(1B)+id(1B)+length(2B)+challenge_size(1B)+challenge+name */
#define PPP_CHAP_CHALLENGE_BUF_MAX_LEN      (1 + 1 + 2 + 1 + CHAPCHALLENGELEN + AUTHLEN)

/* code(1B)+id(1B)+length(2B)+response_size(1B)+response+name */
#define PPP_CHAP_RESPONSE_BUF_MAX_LEN       (1 + 1 + 2 + 1 + PASSWORDLEN + AUTHLEN)

#define PPP_AUTH_FRAME_BUF_MAX_LEN          (256)
#define PPP_IPCP_FRAME_BUF_MAX_LEN          (256)

/*ַʽIPַȣ"."16ַ*/
#define PPP_IPV4_ADDR_STR_MAX_LEN           (16)

#ifndef IPV4_ADDR_LEN
#define   IPV4_ADDR_LEN                     (4)       /*IPV4ַ*/
#endif

#ifndef IPV6_ADDR_LEN
#define   IPV6_ADDR_LEN                     (16)      /*IPV6ַ*/
#endif

/******************************************************************************
  3 öٶ
******************************************************************************/
enum PPP_AT_CTRL_OPER_TYPE_ENUM
{
    PPP_AT_CTRL_REL_PPP_REQ = 0,              /* ͷIPPPP· */
    PPP_AT_CTRL_REL_PPP_RAW_REQ = 1,          /* ͷPPPPPP· */
    PPP_AT_CTRL_HDLC_DISABLE = 2,             /* HDLCӲģȥʹܲ */
    PPP_AT_CTRL_CONFIG_INFO_IND = 3,          /* PDPϢ */

    PPP_AT_CTRL_BUTT
};
typedef VOS_UINT32  PPP_AT_CTRL_OPER_TYPE_ENUM_UINT32;

/******************************************************************************
  4 ȫֱ
******************************************************************************/


/******************************************************************************
  5 Ϣͷ
******************************************************************************/


/******************************************************************************
  6 Ϣ
******************************************************************************/


/******************************************************************************
  7 STRUCT
******************************************************************************/
#pragma pack(4)

typedef VOS_UINT16 PPP_ID;

/* Ȩ */
enum PPP_AUTH_TYPE_ENUM
{
    PPP_NO_AUTH_TYPE                     = 0,
    PPP_PAP_AUTH_TYPE                    = 1,
    PPP_CHAP_AUTH_TYPE                   = 2,
    PPP_MS_CHAPV2_AUTH_TYPE              = 3,
    PPP_AUTH_TYPE_BUTT
};
typedef VOS_UINT8 PPP_AUTH_TYPE_ENUM_UINT8;

typedef struct
{
    VOS_UINT16  usPapReqLen;                    /*request: 24.008Ҫ[3,253]ֽ*/
    VOS_UINT8   aucReserve[2];                  /* 뱣 */
    VOS_UINT8  *pPapReq;                        /*request*/
} PPP_AUTH_PAP_CONTENT_STRU;

typedef struct
{
    VOS_UINT16  usChapChallengeLen;             /*challenge: 24.008Ҫ[3,253]ֽ*/
    VOS_UINT16  usChapResponseLen;              /*response: 24.008Ҫ[3,253]ֽ*/
    VOS_UINT8  *pChapChallenge;                 /*challenge*/
    VOS_UINT8  *pChapResponse;                  /*response*/
} PPP_AUTH_CHAP_CONTENT_STRU;

typedef struct
{
    PPP_AUTH_TYPE_ENUM_UINT8  ucAuthType;
    VOS_UINT8                 aucReserve[3];

    union
    {
        PPP_AUTH_PAP_CONTENT_STRU  PapContent;
        PPP_AUTH_CHAP_CONTENT_STRU ChapContent;
    } AuthContent;
} PPP_REQ_AUTH_CONFIG_INFO_STRU;

typedef struct
{
    VOS_UINT16  usIpcpLen;                      /*Ipcp֡*/
    VOS_UINT8   aucReserve[2];                  /* 뱣 */
    VOS_UINT8  *pIpcp;                          /*Ipcp֡*/
} PPP_REQ_IPCP_CONFIG_INFO_STRU;

typedef struct
{
    PPP_REQ_AUTH_CONFIG_INFO_STRU stAuth;
    PPP_REQ_IPCP_CONFIG_INFO_STRU stIPCP;
} PPP_REQ_CONFIG_INFO_STRU;

typedef struct
{
    VOS_UINT16  usAuthLen;                      /*Ȩ֡*/
    VOS_UINT16  usIpcpLen;                      /*Ipcp֡*/
    VOS_UINT8  *pAuth;                          /*Ȩ֡*/
    VOS_UINT8  *pIpcp;                          /*Ipcp֡*/
    VOS_UINT8   aucIpAddr[PPP_IPV4_ADDR_STR_MAX_LEN]; /*Ipַ*/
} PPP_IND_CONFIG_INFO_STRU;


/* PPPAT͵Ϣ */
#define AT_PPP_RELEASE_IND_MSG          0x00    /* ͷPDPӵ */
#define AT_PPP_MODEM_MSC_IND_MSG        0x01    /* AT͹ܽźָʾ(͸ܽźţ
                                                         ޷ģATԼϢ,ģPPPAT͸Ϣ.) */
#define AT_PPP_PROTOCOL_REL_IND_MSG     0x02    /* PPP·ͷŵָʾ */

typedef struct
{
    MSG_HEADER_STRU                     MsgHeader;
    VOS_UINT8                           ucIndex;
    VOS_UINT8                           ucReserve[3];
}AT_PPP_RELEASE_IND_MSG_STRU;


typedef struct
{
    MSG_HEADER_STRU                     MsgHeader;
    /* Modified by f00179208 for V3R3 PPP RPOJECT 2013-05-25, Begin */
    VOS_UINT8                           ucIndex;
    /* Modified by f00179208 for V3R3 PPP RPOJECT 2013-05-25, End */
    VOS_UINT8                           ucDlci;
    VOS_UINT8                           aucMscInd[2];  /* ܽź */
}AT_PPP_MODEM_MSC_IND_MSG_STRU;


typedef struct
{
    MSG_HEADER_STRU                     MsgHeader;
    VOS_UINT16                          usPppId;
    VOS_UINT8                           ucReserve[2];
}AT_PPP_PROTOCOL_REL_IND_MSG_STRU;


typedef VOS_VOID (*PPP_PULL_MSG_EVENT_CALLBACK)(VOS_UINT32 ulMsgCnt);

#if ((VOS_OS_VER == VOS_WIN32) || (VOS_OS_VER == VOS_NUCLEUS))
#pragma pack()
#else
#pragma pack(0)
#endif

/******************************************************************************
  8 UNION
******************************************************************************/


/******************************************************************************
  9 OTHERS
******************************************************************************/


/******************************************************************************
  10 
******************************************************************************/
/* PPPṩATĽӿ */
extern VOS_UINT32 Ppp_CreatePppReq ( PPP_ID *pusPppId);
extern VOS_UINT32 Ppp_CreateRawDataPppReq ( PPP_ID *pusPppId);
extern VOS_UINT32 Ppp_ReleasePppReq ( PPP_ID usPppId);
extern VOS_UINT32 Ppp_ReleaseRawDataPppReq ( PPP_ID usPppId);
extern VOS_UINT32 PPP_RcvAtCtrlOperEvent(VOS_UINT16 usPppId, PPP_AT_CTRL_OPER_TYPE_ENUM_UINT32 ulCtrlOperType);
extern VOS_VOID   PPP_UpdateWinsConfig(VOS_UINT8 ucWins);

#if (VOS_WIN32 == VOS_OS_VER) || (OSA_CPU_ACPU == VOS_OSA_CPU)
/* IPʽṩݽսӿ */
extern VOS_UINT32 PPP_PullPacketEvent(VOS_UINT16 usPppId, IMM_ZC_STRU *pstImmZc);

/* IPʽṩݽսӿ */
extern VOS_UINT32 PPP_PushPacketEvent(VOS_UINT8 ucRabId, IMM_ZC_STRU *pstImmZc, ADS_PKT_TYPE_ENUM_UINT8 enPktType);

/* PPPʽṩݽսӿ */
extern VOS_UINT32 PPP_PullRawDataEvent(VOS_UINT16 usPppId, IMM_ZC_STRU *pstImmZc);

/* PPPʽṩݽսӿ */
extern VOS_UINT32 PPP_PushRawDataEvent(VOS_UINT8 ucRabId, IMM_ZC_STRU *pstImmZc, ADS_PKT_TYPE_ENUM_UINT8 enPktType);
#endif


#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* PppInterface.h */

