/******************************************************************************

                  Ȩ (C), 2001-2011, Ϊ޹˾

 ******************************************************************************
       : GUCommInterface.h
       : 
         : s00184266
     : 20111018
  ޸   :
     : GASWASTDSͷļ GASWASά
  б   :
  ޸ʷ   :
  1.       : 20111018
           : s00184266
    ޸   : ļ

******************************************************************************/

#ifndef __GUCOMMINTERFACE_H__
#define __GUCOMMINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 ͷļ                            
*****************************************************************************/
#include "PsTypeDef.h"

#pragma pack(4)

/*****************************************************************************
  2 궨 
*****************************************************************************/
/* 3GPP ЭϹ涨EUTRANƵ */
#define GURRC_LTE_ARFCN_MAX_NUM                             (8)
    
/* 3GPP ЭϹ涨UTRANƵ */
#define GURRC_UTRAN_ARFCN_MAX_NUM                           (16)
    
/* 3GPP ЭϹ涨GERANƵ */
#define GURRC_GERAN_ARFCN_MAX_NUM                           (32)

#define RRC_MAX_INTER_GSM_CELL_NUM                          (64)                /* UTRANGSM */

#define RRC_MAX_INTER_GSM_MESSAGE_MAXLEN                    (512)               /* лʱGSMϢ󳤶 */
#define RRC_MAX_INTER_GSM_MESSAGE_NUM                       (4)                 /* лʱGSMϢĿ */
#define GSM_CARRIER_MAXNUM                                  (8)                 /* TRRC/WRRCGSMСֵ */

#define GSM_CLASSMARK2_MAX_LEN                              (4)                 /* R6ЭClassmark2󳤶,TRRCWRRIEI */
#define GSM_CLASSMARK3_MAX_LEN                              (32)                /* R8ЭClassmark3󳤶,TRRCWRRIEI */

/* EUTRAN רȼ */
#define GURRC_EUTRAN_DEDICATED_PRI_MAX_NUM                  (64)

/* UTRAN רȼ */
#define GURRC_UTRAN_DEDICATED_PRI_MAX_NUM                   (64)

/*****************************************************************************
  3 öٶ 
*****************************************************************************/
/*****************************************************************************
 ö     :RRC_GRR_BANDINDICATOR_ENUM
 Э  :
 ASN.1   :
 ö˵ : 2GСƵָʾ
*****************************************************************************/
enum RRC_GRR_BANDINDICATOR_ENUM
{
    RRC_GRR_BANDINDICATOR_DCS1800       = 0,
    RRC_GRR_BANDINDICATOR_PCS1900       ,

    RRC_GRR_BANDINDICATOR_BUTT
};
typedef VOS_UINT16    RRC_GRR_BANDINDICATOR_ENUM_UINT16;

/*****************************************************************************
 ö     :GURRC_VALID_FLAG_ENUM
 Э  :
 ASN.1   :
 ö˵ : ͨǷڱ־
*****************************************************************************/
enum GURRC_VALID_FLAG_ENUM
{
    GURRC_FLAG_INVALID                  = 0,
    GURRC_FLAG_VALID                    ,

    GURRC_FLAG_BUTT
};
typedef VOS_UINT8    GURRC_VALID_FLAG_ENUM_UINT8;

/*****************************************************************************
 ö     :RRC_GSM_GERAN_SYS_INFO_ENUM
 Э  :
 ASN.1   :
 ö˵ : GSMСϵͳϢö
*****************************************************************************/
typedef enum
{
    GERAN_SYS_INFO_TYPE_SI              = 0,
    GERAN_SYS_INFO_TYPE_PSI             = 1,
    GERAN_SYS_INFO_TYPE_BUTT
}RRC_GSM_GERAN_SYS_INFO_ENUM;
typedef VOS_UINT8 RRC_GSM_GERAN_SYS_INFO_ENUM_UINT8;

/*****************************************************************************
 ö     :RRC_GSM_BAND_INDICATOR_ENUM
 Э  :
 ASN.1   :
 ö˵ : GSMСƵָʾö
*****************************************************************************/
typedef enum
{
    EN_DSC_1800_USED                    = 0,
    EN_PDS_1900_USED
}RRC_GSM_BAND_INDICATOR_ENUM;
typedef VOS_UINT32  RRC_GSM_BAND_INDICATOR_ENUM_UINT32;

/*****************************************************************************
 ö     :RRC_SINGAL_INFO_ENUM
 Э  :
 ASN.1   :
 ö˵ : ϵͳʱЯ
*****************************************************************************/
typedef enum
{
    EN_NO_SIG_INF0                              = 0,                            /*  */
    EN_SIG_CS,                                                                  /* ֻCS */
    EN_SIG_PS,                                                                  /* ֻPS */
    EN_SIG_CSANDPS                                                              /* ͬʱCSPS */
}RRC_SINGAL_INFO_ENUM;
typedef VOS_UINT32  RRC_SINGAL_INFO_ENUM_UINT32;

/*****************************************************************************
 ö     :RRC_SINGAL_INFO_ENUM
 Э  :
 ASN.1   :
 ö˵ : ϵͳʱָʾGSMǷ񼤻˼
*****************************************************************************/
enum RRC_CIPHER_ACTIVE_ENUM
{
    EN_RRC_CIPHER_INACTIVE              = 0,
    EN_RRC_CIPHER_ACTIVE                = 1,
    EN_RRC_CIPHER_ACTIVE_BUTT
};
typedef VOS_UINT32  RRC_CIPHER_ACTIVE_ENUM_UINT32;

/*****************************************************************************
  4 ȫֱ
*****************************************************************************/


/*****************************************************************************
  5 Ϣͷ
*****************************************************************************/


/*****************************************************************************
  6 Ϣ
*****************************************************************************/


/*****************************************************************************
  7 STRUCT
*****************************************************************************/
/*****************************************************************************
 ṹ     :GURRC_LTE_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LTEȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved[1];
}GURRC_LTE_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_LTE_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :LTEרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    GURRC_LTE_PRI_INFO_STRU                                 astLteDPriInfo[GURRC_EUTRAN_DEDICATED_PRI_MAX_NUM];
}GURRC_LTE_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_UTRAN_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved[1];
}GURRC_UTRAN_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_UTRAN_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :UTRANרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    GURRC_UTRAN_PRI_INFO_STRU                               astUtranDPriInfo[GURRC_UTRAN_DEDICATED_PRI_MAX_NUM];
}GURRC_UTRAN_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_GERAN_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                              usArfcn;
    RRC_GRR_BANDINDICATOR_ENUM_UINT16                       enBandInd;

    /* ȡֵΧ0~9,0ʾȼͣ9ʾȼߣ1~8ӦЭϵ0~7 */
    VOS_UINT8                                               ucCellReselectionPriority;
    VOS_UINT8                                               aucReserved2[3];
}GURRC_GERAN_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_GERAN_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :2GרȼϢݽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                                              ulArfcnNum;
    GURRC_GERAN_PRI_INFO_STRU                               astGeranDPriInfo[GURRC_GERAN_ARFCN_MAX_NUM];
}GURRC_GERAN_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :GURRC_DEDICATED_PRI_INFO_STRU
 Э  :
 ASN.1   :
 ṹ˵  :רȼϢݽṹ
*****************************************************************************/
typedef struct
{
    /**************************************************************************
     bitLteDPriInfoPresent: ʾstLteDPriInfoǷЧ1ʾЧ0ʾЧ
     bitUtranDPriInfoPresent: ʾstUtranDPriInfoǷЧ1ʾЧ0ʾЧ
     bitGeranDPriInfoPresent: ʾstGeranDPriInfoǷЧ1ʾЧ0ʾЧ
     bitDPriTimerPresent: ʾulTimerValueǷЧ1ʾЧ0ʾЧ
    **************************************************************************/

    VOS_UINT32                                              bitLteDPriInfoPresent  : 1;
    VOS_UINT32                                              bitUtranDPriInfoPresent: 1;
    VOS_UINT32                                              bitGeranDPriInfoPresent: 1;
    VOS_UINT32                                              bitDPriTimerPresent    : 1;
    VOS_UINT32                                              bitSpare               : 28;

    /* EUTRAN ƵȼϢ */
    GURRC_LTE_DEDICATED_PRI_INFO_STRU                       stLteDPriInfo;

    /* URTAN ƵȼϢ */
    GURRC_UTRAN_DEDICATED_PRI_INFO_STRU                     stUtranDPriInfo;

    /* GSM ƵȼϢ */
    GURRC_GERAN_DEDICATED_PRI_INFO_STRU                     stGeranDPriInfo;

    /* T3230,T322 ,T320ʱʵʣʱλ,
            T3230,T322 ,T320ʱڣʾ޴ */
    VOS_UINT32                                              ulTimerValue;
}GURRC_DEDICATED_PRI_INFO_STRU;

/*****************************************************************************
 ṹ     :RRC_SAVE_CELL_INFO_FOR_GAS_ST
 Э  :
 ASN.1   :
 ṹ˵  :GSMСϢṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulNCC;
    VOS_UINT32                          ulBCC;
    VOS_UINT32                          ulBcchArcfn;
    VOS_UINT32                          ulFreqBandInd;
    VOS_UINT32                          ulFlag;                                 /* ñָʾlFNOffsetulTimeAlignmtǷݣ0:ʾ 1: ʾ*/
    VOS_INT32                           lFNOffset;
    VOS_UINT32                          ulTimeAlignmt;

    VOS_INT16                           sRxlev;                                 /* GСźŵƽλdBm,ûв⵽źŵƽʱֵΪRRWRR_INVALID_RXLEV */
    VOS_UINT8                           aucReserve1[2];                         /* 4ֽڶ룬 */

}RRC_SAVE_CELL_INFO_FOR_GAS_ST;

/*****************************************************************************
 ṹ     :RRC_SAVEINFO_FOR_GAS_ST
 Э  :
 ASN.1   :
 ṹ˵  :ϵͳ״̬±GSMСṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulGsmCellNum;                           /* GSMС */
    RRC_SAVE_CELL_INFO_FOR_GAS_ST       RrcSaveCellInfoForGas[GSM_CARRIER_MAXNUM];
}RRC_SAVEINFO_FOR_GAS_ST;

/*****************************************************************************
 ṹ     :RRC_GSM_MESSAGE_ST
 Э  :
 ASN.1   :
 ṹ˵  :лGSMСЯGSMСϢṹ
*****************************************************************************/
typedef struct
{
     VOS_UINT16                         usBitLength;                            /* տϢGSMϢĳ*/
     VOS_UINT8                          aucReserve[2];                         /* 4ֽڶ룬 */
     VOS_UINT8                          aucData[RRC_MAX_INTER_GSM_MESSAGE_MAXLEN];/* տϢGSMϢ */
}RRC_GSM_MESSAGE_ST;

/*****************************************************************************
 ṹ     :RRC_HANDOVER_GSM_GPRS_INFO_ST
 Э  :
 ASN.1   :
 ṹ˵  :лGSMСGPRSϢṹ
*****************************************************************************/
typedef struct
{
    RRC_SAVEINFO_FOR_GAS_ST             stRrcSaveInfoForGas;
    RRC_GSM_BAND_INDICATOR_ENUM_UINT32  enBandIndictor;
    VOS_UINT16                          usMessageNUM;                           /* տϢGSMϢĸ */
    VOS_UINT8                           aucReserve1[2];                         /* 4ֽڶ룬 */
    RRC_GSM_MESSAGE_ST                  stGsmGprsMsg[RRC_MAX_INTER_GSM_MESSAGE_NUM];    
}RRC_HANDOVER_GSM_GPRS_INFO_ST;

/*****************************************************************************
  8 UNION
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/


/*****************************************************************************
  10 
*****************************************************************************/








#if ((VOS_OS_VER == VOS_WIN32) || (VOS_OS_VER == VOS_NUCLEUS))
#pragma pack()
#else
#pragma pack(0)
#endif




#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of GUCommInterface.h */
