/******************************************************************************


        @(#)Copyright(C)2013,Hisilicon Co. LTD.

 ******************************************************************************
    File name   : ImsaNvInterface.h
    Description : Imsa NV ͷļ
    History     :
      1.sunbing 00049683    2013-06-27  Draft Enact


******************************************************************************/

#ifndef __IMSANVINTERFACE_H__
#define __IMSANVINTERFACE_H__

/*****************************************************************************
  1 Include Headfile
*****************************************************************************/

#include    "vos.h"

/*****************************************************************************
  1.1 Cplusplus Announce
*****************************************************************************/
#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif

/*****************************************************************************
#pragma pack(*)    ֽڶ뷽ʽ
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

/*****************************************************************************
  2 macro
*****************************************************************************/
#define IMSA_PASSWORD_LEN               (129)
#define IMSA_IMPI_LEN                   (129)
#define IMSA_IMPU_LEN                   (129)
#define IMSA_HOME_NET_DOMAIN_NAME_LEN   (129)

#define IMSA_IMS_MAX_REDIAL_CAUSE_NUM   (16)
#if 0
/* wangchen 00209181 begin for ims 2013-12-23 */
#define IMS_PARM_STRING_SIZE            (129)
/* wangchen 00209181 end for ims 2013-12-23 */
#endif

/* x00253310 add for P-CSCF 2014-03-24 begin */
#define IMSA_NV_IPV4_ADDR_LEN           (4)
#define IMSA_NV_IPV6_ADDR_LEN           (16)
/* x00253310 add for P-CSCF 2014-03-24 end */


/*****************************************************************************
  3 Massage Declare
*****************************************************************************/



/*****************************************************************************
  4 Enum
*****************************************************************************/
/* x00253310 add for P-CSCF 2014-03-24 begin */
enum IMSA_PCSCF_DISCOVERY_POLICY_ENUM
{
    IMSA_PCSCF_DISCOVERY_POLICY_PCO           = 0,      /**< PCOʽȡP-CSCF */
    IMSA_PCSCF_DISCOVERY_POLICY_NV            = 1,      /**< NVP-CSCF */
    IMSA_PCSCF_DISCOVERY_POLICY_BUTT
};
typedef VOS_UINT8 IMSA_PCSCF_DISCOVERY_POLICY_ENUM_UINT8;
/* x00253310 add for P-CSCF 2014-03-24 end */


/*****************************************************************************
  5 STRUCT
*****************************************************************************/

typedef struct
{
    VOS_UINT8                           ucGsmImsSupportFlag;    /**< GSM IMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucUtranImsSupportFlag; /**< UNTRAN IMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucLteImsSupportFlag;    /**< LTE IMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucGsmEmsSupportFlag;    /**< GSM EMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucUtranEmsSupportFlag; /**< UNTRAN EMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucLteEmsSupportFlag;    /**< LTE EMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucReserved1;
    VOS_UINT8                           ucReserved2;

}IMSA_NV_IMS_RAT_SUPPORT_STRU;

typedef struct
{
    VOS_UINT16                          usImsMinPort;           /* IMS˿ںŷΧ */
    VOS_UINT16                          usImsMaxPort;           /* IMS˿ںŷΧ */
#if 0
    VOS_UINT32                          ulSip;
    VOS_UINT32                          ulAudio;                /**< audio rtp port */
    VOS_UINT32                          ulAudioPoolSize;        /**< audio rtp pool size */
    VOS_UINT32                          ulVideo;                /**< video rtp port */
    VOS_UINT32                          ulVideoPoolSize;        /**< video rtp pool size */
    VOS_UINT32                          ulProtectedSip;         /**< protected sip port */
    VOS_UINT32                          ulProtectedSipPoolSize; /**< protected sip pool size */
#endif
}IMSA_NV_SIP_PORT_CONFIG_STRU;

typedef struct
{
    VOS_UINT8                           ucIsCallRedialSupportFlg;   /* Ƿ֧IMSزܣVOS_TRUE:֧֣VOS_FALSE:֧*/
    VOS_UINT8                           ucRedialCauseNum;           /* زԭֵ */
    VOS_UINT8                           aucReserved1[2];
    VOS_UINT32                          ulCallRedialMaxTime;        /* IMSزܴʱزʱλ */
    VOS_UINT32                          ulCallRedialInterval;       /* IMSزܴʱزλ */
    VOS_UINT32                          ulCallRedialMaxNum;         /* IMSزܴʱز  */
    VOS_UINT16                          ausRedialCauseList[IMSA_IMS_MAX_REDIAL_CAUSE_NUM];       /* زԭֵб */
}IMSA_NV_IMS_REDIAL_CFG_STRU;

/* m00277840 CMCC requirement phase I begin */
typedef struct
{
    VOS_UINT8                           ucCMCCCustomDeregFlag;    /**< йƶ, ʱȥעʹ*/
    VOS_UINT8                           ucCMCCCustomTcallFlag;    /**< йƶ, Tcall SilentRedialʹ*/
    VOS_UINT8                           ucCMCCCustomTqosFlag;     /**< йƶ, Tqos SilentRedialʹ*/
    VOS_UINT8                           aucReserved[1];

    VOS_UINT32                          ulTcallTimerLen;            /**< йƶ, Tcall timerʱʱ, λΪms*/
    VOS_UINT32                          ulTqosTimerLen;             /**< йƶ, Tqos timerʱʱ, λΪms*/
} IMSA_NV_CMCC_CUSTOM_REQ_STRU;
/* m00277840 CMCC requirement phase I end */

/* wangchen 00209181 begin 2013-10-11 for ims */
typedef struct
{
    VOS_UINT8                           ucNoCardEmcCallSupportFlag;/**< ޿ʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucUeRelMediaPdpFLag;    /**< UEͷýرʶ */
    VOS_UINT8                           ucImsLocDeregSigPdpRelFlag;/**< IMSͨͷź󱾵IMSȥעʶ */
    /* x00253310 modify for DTS2014061103804 20140614 begin */
    VOS_UINT8                           ucRetryTimes;              /**< IMSעʧٳע0ΪĬֵΪ޴ */
    /* x00253310 modify for DTS2014061103804 20140614 end */
    VOS_UINT32                          ulMaxTime;              /**< max timeλΪs */
    VOS_UINT32                          ulBaseTime;             /**< base timeλΪs */
    VOS_UINT32                          ulRegFailRetryIntervel; /**< עʧԼλΪs0ʾǹ̶ */
    /* x00253310 begin 2014-11-11 for DTS2014111101333 */
    VOS_UINT32                          ulRegTimerLen;
    /* x00253310 end 2014-11-11 for DTS2014111101333 */
    IMSA_NV_IMS_REDIAL_CFG_STRU         stImsRedialCfg;         /**< IMSز */
    /* m00277840 CMCC requirement phase I begin */
    IMSA_NV_CMCC_CUSTOM_REQ_STRU        stCMCCCustomReq;        /**< йƶ */
    /* m00277840 CMCC requirement phase I end  */
}IMSA_NV_IMSA_CONFIG_STRU;

typedef struct
{
    VOS_UINT8                           ucVoiceCallOnImsSupportFlag;        /**< IMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucVideoCallOnImsSupportFlag;        /**< IMSƵʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSmsOnImsSupportFlag;              /**< IMSʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSrvccOnImsSupportFlag;            /**< IMS Srvccʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSrvccMidCallOnImsSupportFlag;     /**< IMS SrvccMidCallʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSrvccAlertingOnImsSupportFlag;    /**< IMS SrvccAlertingʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSrvccPreAlertingOnImsSupportFlag; /**< IMS SrvccPreAlertingʹ,VOS_TRUE :֧֣VOS_FALSE :֧ */
    VOS_UINT8                           ucSrvccTiFlag;                      /**< IMS SrvccPreAlerting,VOS_TRUE :0 R10汾,VOS_FALSE R11֮汾 */
}IMS_NV_IMS_CAP_STRU;

/* wangchen 00209181 end 2013-10-11 for ims */

/* wangchen 00209181 begin 2013-11-13 for ims */
typedef struct
{
    VOS_UINT8                           ucUserInfoFlag;   /**< 0:USIMIMPIIMPU,DOMAIN   1:NVȡIMPIIMPU,DOMAIN */
    VOS_UINT8                           ucAuthType;                         /**< IMS Ȩʽ  0:AKA  1:DIGIST 2:AKA_IPSEC */
    VOS_UINT8                           aucReserved[2];
    VOS_INT8                            acImpi[IMSA_IMPI_LEN]; /**< Ĭ49ֽ */
    VOS_INT8                            acTImpu[IMSA_IMPU_LEN]; /**< Ĭ53ֽ */
    VOS_INT8                            acHomeNetDomainName[IMSA_HOME_NET_DOMAIN_NAME_LEN]; /**< Ĭ33ֽ */
    VOS_INT8                            aucPassWord[IMSA_PASSWORD_LEN];     /**< ȨʽΪDIGISTʱ: */
}IMSA_NV_IMS_CONFIG_STRU;
/* wangchen 00209181 end 2013-11-13 for ims */

/* x00253310 add for P-CSCF 2014-03-24 begin */
typedef struct
{
    VOS_UINT32                          bitOpPrimPcscfAddr  : 1;
    VOS_UINT32                          bitOpSecPcscfAddr   : 1; /**< bitOpSecPcscfAddrΪ1bitOpPrimPcscfAddrҲΪ1*/
    VOS_UINT32                          bitOpSpare          : 30;

    VOS_UINT8                           aucPrimPcscfAddr[IMSA_NV_IPV4_ADDR_LEN];
    VOS_UINT8                           aucSecPcscfAddr[IMSA_NV_IPV4_ADDR_LEN];
} IMSA_NV_PDP_IPV4_PCSCF_STRU;

typedef struct
{
    VOS_UINT32                          bitOpPrimPcscfAddr  : 1;
    VOS_UINT32                          bitOpSecPcscfAddr   : 1; /**< bitOpSecPcscfAddrΪ1bitOpPrimPcscfAddrҲΪ1*/
    VOS_UINT32                          bitOpSpare          : 30;

    VOS_UINT8                           aucPrimPcscfAddr[IMSA_NV_IPV6_ADDR_LEN];
    VOS_UINT8                           aucSecPcscfAddr[IMSA_NV_IPV6_ADDR_LEN];
} IMSA_NV_PDP_IPV6_PCSCF_STRU;


typedef struct
{
    IMSA_PCSCF_DISCOVERY_POLICY_ENUM_UINT8  enPcscfDiscoverPolicy;  /**< P-CSCFȡ */
    VOS_UINT8                               aucReserved[3];
    IMSA_NV_PDP_IPV4_PCSCF_STRU             stIpv4Pcscf;            /**< IPv4 P-CSCFϢ */
    IMSA_NV_PDP_IPV6_PCSCF_STRU             stIpv6Pcscf;            /**< IPv6 P-CSCFϢ */
}IMSA_NV_PCSCF_DISCOVERY_POLICY_STRU;
/* x00253310 add for P-CSCF 2014-03-24 end */

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/

/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/





/*****************************************************************************
  9 OTHERS
*****************************************************************************/


#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif




#ifdef __cplusplus
    #if __cplusplus
            }
    #endif
#endif

#endif /* end of ImsaNvInterface.h */




