/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : WasNvInterface.h
  Description     : WasNvInterface.h header file
  History         :

******************************************************************************/

#ifndef __WASNVINTERFACE_H__
#define __WASNVINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

#include "PsTypeDef.h"

/*****************************************************************************
  2 Macro
*****************************************************************************/
#define WAS_MAX_NETWORKPARA_SIZE                (144)                           /*  NET WorkParaļȺ궨 */
#define WAS_HISTORY_PLMN_MAX_NUM                (16)                            /* 洢NVеPLMNϢ */
#define WAS_OPERATOR_FREQS_MAX_NUM              (24)
#define NV_ITEM_MEAS_THRESHOLD_SIZE             (40)
#define WAS_MAPWEIGHT_MAX_NUM                   (16)
#define WAS_HISTORY_PLMN_ID_BYTES               (3)
#define WAS_HISTORY_FREQS_MAX_NUM               (6)                             /* 洢NVеPLMNӦƵ */
#define WAS_UE_ACCESS_CAPA_NUM                  (20)
#define NVIM_MAX_MCC_SIZE                       (3)
#define NVIM_MAX_MNC_SIZE                       (3)
#define NVIM_MAX_RPLMN_FDD_FREQ_NUM             (8)
#define NV_ITEM_RPLMN_INFO_SIZE                 (56)
#define NV_ITEM_NETWORKPARA_SIZE                (144)
#define NV_Item_WAS_RadioAccess_Capa_SIZE       (20)
#define NV_Item_WAS_RadioAccess_Capa_New_SIZE   (48)                            /* WASNVNV_Item_WAS_RadioAccess_Capa_New */
#define NV_Item_WCDMA_PLMN_FREQ_PAIR_List_SIZE  (260)
#define NV_Item_WCDMA_OPERATOR_FREQ_List_SIZE   (56)
#define NV_ITEM_BG_THRESHOLD_SIZE               (8)
#define NV_ITEM_PDCP_LOSSLESS_SIZE              (2)
#define NV_ITEM_DYN_FREQUENCY_SIZE              (2)
#define NV_ITEM_INIT_FREQUENCY_SIZE             (2)
#define NV_ITEM_PLMN_SEARCH_THRESHOLD_SIZE      (4)
#define NV_ITEM_PLMN_SEARCH_FLOW_SIZE           (8)
#define NV_ITEM_ALL_BAND_SEARCH_PARA_SIZE       (8)
#define NV_ITEM_BROKEN_CELL_PARA_SIZE           (4)
#define NV_ITEM_WAS_ERRORLOG_ITEM_NUM           (4)
#define NV_ITEM_WCDMA_IND_FRED_SIZE             (2)
#define NV_ITEM_FREQBANDS_LIST_SIZE             (52)
#define WAS_NV_MEAS_THRESHOLD_HALF_THRHLD_SIZE  (NV_ITEM_MEAS_THRESHOLD_SIZE/2)
#define WAS_NV_MEAS_THRESHOLD_RESERVE_SIZE      (WAS_NV_MEAS_THRESHOLD_HALF_THRHLD_SIZE-4)
#define WAS_NV_PTL_VER_R3                       (0)                             /* WAS_PTL_VER_R3 */
#define WAS_NV_PTL_VER_R4                       (1)                             /* WAS_PTL_VER_R4 */
#define WAS_NV_PTL_VER_R5                       (2)                             /* WAS_PTL_VER_R5 */
#define WAS_NV_PTL_VER_R6                       (3)                             /* WAS_PTL_VER_R6 */
#define WAS_NV_PTL_VER_R7                       (4)                             /* WAS_PTL_VER_R7 */
#define WAS_NV_PTL_VER_R8                       (5)                             /* WAS_PTL_VER_R8 */
#define WAS_NV_PTL_VER_R9                       (6)                             /* WAS_PTL_VER_R9 */

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/


/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
*                                                                            *
*                           Ϣṹ                                 *
*                                                                            *
******************************************************************************/

/*****************************************************************************
 ṹ    : WAS_NVIM_NETPARA_STRU
 ṹ˵  : NET PARAϢṹ                       ID:8246 en_NV_Item_NetWorkPara
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               aucFileContent[WAS_MAX_NETWORKPARA_SIZE];   /* File */
}WAS_NVIM_NETPARA_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_MEAS_THRESHOLD_STRU
 ṹ˵  : NVIMжMeasThreshold        ID:8263 en_NV_Item_Meas_Threshold
*****************************************************************************/
typedef struct
{
    VOS_INT16                               sMeasRptRscpThreshold;              /* 1a/1c¼RSCP    */
    VOS_INT16                               sMeasRptEcn0Threshold;              /* 1a/1c¼ECN0    */
    VOS_INT16                               sCellSrchRscpThreshold;             /* СRSCP         */
    VOS_INT16                               sCellSrchEcn0Threshold;             /* СECN0         */
    VOS_INT16                               asReserve[WAS_NV_MEAS_THRESHOLD_RESERVE_SIZE];     /* ֶ */
}WAS_NVIM_MEAS_THRESHOLD_STRU;

typedef struct
{
    VOS_UINT8                               aucPlmnId[WAS_HISTORY_PLMN_ID_BYTES];
    VOS_UINT8                               ucFreqCnt;
    VOS_UINT16                              ausFreq[WAS_HISTORY_FREQS_MAX_NUM];
}WAS_NVIM_PLMN_FREQ_PAIR_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_PLMN_FREQ_PAIR_LIST_STRU
 ṹ˵  : NVжȡʷPLMNͶӦƵ ID:8284 en_NV_Item_WCDMA_PLMN_FREQ_PAIR_List
*****************************************************************************/
typedef struct
{
    VOS_UINT32                              ulPlmnCnt;
    WAS_NVIM_PLMN_FREQ_PAIR_STRU            astNvPlmnFreqPair[WAS_HISTORY_PLMN_MAX_NUM];
}WAS_NVIM_PLMN_FREQ_PAIR_LIST_STRU;

typedef struct
{
    VOS_UINT8    ucMcc[NVIM_MAX_MCC_SIZE];
    VOS_UINT8    ucMnc[NVIM_MAX_MNC_SIZE];
}NVIM_PLMN_ID_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_PLMN_FREQ_PAIR_LIST_STRU
 ṹ˵  : NVжȡʷPLMNͶӦƵ ID:8314 en_NV_Item_Opr_Freq_List
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8                      enOperatorFreqListValidFlg;              /* ƵбǷЧ־ */
    NVIM_PLMN_ID_STRU                       stPlmnId;                                /* Plmn ID */
    VOS_UINT8                               ucFreqNum;                               /* plmnƵ */
    VOS_UINT16                              ausFreqInfo[WAS_OPERATOR_FREQS_MAX_NUM]; /* plmnƵϢ */
}WAS_NVIM_OPERATOR_FREQ_LIST_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_BG_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : NVIMжıThreshold      ID:8316 en_NV_Item_BG_Threshold
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucStatus;                           /*ѡ,0:,1,Ĭֵ:1*/
    VOS_INT8                                cWCDMA_RSSI_Threshold;              /*Range:[-125,0]*/ /*WCDMA RSSI,Ĭֵ:-95*/
    VOS_INT8                                cWCDMA_Cpich_EcNo_Threshold;        /*Range:[-25,0]*/  /*WCDMA Cpich_EcNo,Ĭֵ:-11*/
    VOS_INT8                                cWCDMA_Cpich_Rscp_Threshold;        /*Range:[-125,0]*/ /*WCDMA Cpich_Rscp,Ĭֵ:-100*/
    VOS_INT8                                cGSM_RSSI_Threshold;                /*Range:[-125,0]*/ /*GSM RSSI,Ĭֵ:-95*/
    VOS_UINT8                               ucBgGsmMeasSqualOffset;             /* ȼRATʱGSMSqual offset */
    VOS_UINT8                               ucBgGsmMeasSrxlevOffset;            /* ȼRATʱGSMSrxlev offset */
    PS_BOOL_ENUM_UINT8                      enBgModifyDrxThresholdFlg;          /* ޸BGDRXޱ */
}WAS_NVIM_BG_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : WAS_BROKEN_CELL_STRU
 ṹ˵  : Broken CellĲ              ID:8341 en_NV_Item_WAS_BROKEN_CELL_PARA
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              usNfail;                            /* NfailRRC_CONN_REQط,СBarб */
    VOS_UINT16                              usTBarFailLen;                      /* Сֹбʱ䣬λ: */
} WAS_BROKEN_CELL_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_UE_FEATURE_CTRL
 ṹ˵  : 洢NVIMV3Ϣ         ID:8472 en_NV_Item_Was_UeFeature_Ctrl
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucIntegAlg;                         /* ĬֵΪ6,֧UIA1&UIA2 */
    VOS_UINT8                               ucCipherAlg;                        /* ĬֵΪ7,֧UEA1&UEA2 */
    VOS_UINT8                               ucWasFeatrue;                       /* ĬֵΪ0,bitλοƸƶ˫DRXǷ֧*/
	PS_BOOL_ENUM_UINT8                      enEPchCbsSupport;                   /* Ƿ֧Epch½Cbs */
}WAS_NVIM_UE_FEATURE_CTRL;

/*****************************************************************************
 ṹ    : WAS_WEAK_SIGNAL_ENERGY_THRESHOLD_STRU
 ṹ˵  : Errorlogźŵ                   ID:8499 en_NV_Item_WAS_Errorlog_Energy_Threshold
*****************************************************************************/
typedef struct
{
    VOS_INT16                               sRscpThreshold;
    VOS_INT16                               sECN0Threshold;
}WAS_WEAK_SIGNAL_ENERGY_THRESHOLD_STRU;

/*****************************************************************************
 ö    : WAS_TX_RX_FREQ_SEPARAT_ENUM_UINT8
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum WAS_TX_RX_FREQ_SEPARAT_ENUM
{
    WAS_TX_RX_FREQ_SEPARAT_DEFAULT_TX_RX_SEPARATION = 0,
    WAS_TX_RX_FREQ_SEPARAT_SPARE2,
    WAS_TX_RX_FREQ_SEPARAT_SPARE1,
    WAS_TX_RX_FREQ_SEPARAT_BUTT
} ;
typedef VOS_UINT8 WAS_TX_RX_FREQ_SEPARAT_ENUM_UINT8;

/*****************************************************************************
 ṹ    : WAS_RF_CAPA_STRU
 Э  : 10.3.3.33 RF capability FDD
 ASN.1 :
 ṹ˵  : RFϢ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucPowerClass;                       /* UEʼ                               */
    WAS_TX_RX_FREQ_SEPARAT_ENUM_UINT8       enTxRxFreqSeparate;                 /* Tx/Rx Ƶ                           */
    VOS_UINT8                               aucReserve1[2];                     /* 4ֽڶ룬 */
}WAS_RF_CAPA_STRU;


/*****************************************************************************
 ö    : WAS_DL_SIMUL_HS_DSCH_CFG_ENUM_UINT8
 Э  :
 ASN.1 :
 ö˵  :
*****************************************************************************/
enum  WAS_DL_SIMUL_HS_DSCH_CFG_ENUM
{
    WAS_DL_SIMUL_HS_DSCH_CFG_KBPS32 = 0,
    WAS_DL_SIMUL_HS_DSCH_CFG_KBPS64,
    WAS_DL_SIMUL_HS_DSCH_CFG_KBPS128,
    WAS_DL_SIMUL_HS_DSCH_CFG_KBPS384,
    WAS_DL_SIMUL_HS_DSCH_CFG_BUTT
};
typedef VOS_UINT8 WAS_DL_SIMUL_HS_DSCH_CFG_ENUM_UINT8;

/*****************************************************************************
 ö    : WAS_PTL_VER_TYPE_ENUM_UINT8
 Э  : 10.2.39    RRC CONNECTION REQUEST
 ASN.1 : AccessStratumReleaseIndicator
 ö˵  : Э汾
             Absence of the IE implies R3.
             The IE also indicates the release of the RRC transfer syntax
             supported by the UE 13 spare values are needed
*****************************************************************************/
enum WAS_PTL_VER_TYPE_ENUM
{
    WAS_PTL_VER_ENUM_R3                 = WAS_NV_PTL_VER_R3,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R3 = 0 */
    WAS_PTL_VER_ENUM_R4                 = WAS_NV_PTL_VER_R4,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R4 = 1 */
    WAS_PTL_VER_ENUM_R5                 = WAS_NV_PTL_VER_R5,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R5 = 2 */
    WAS_PTL_VER_ENUM_R6                 = WAS_NV_PTL_VER_R6,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R6 = 3 */
    WAS_PTL_VER_ENUM_R7                 = WAS_NV_PTL_VER_R7,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R7 = 4 */
    WAS_PTL_VER_ENUM_R8                 = WAS_NV_PTL_VER_R8,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R8 = 5 */
    WAS_PTL_VER_ENUM_R9                 = WAS_NV_PTL_VER_R9,                    /* _H2ASN_Replace  WAS_NV_PTL_VER_R9 = 6 */
    WAS_PTL_VER_ENUM_BUTT
};
typedef VOS_UINT8 WAS_PTL_VER_TYPE_ENUM_UINT8;

/*****************************************************************************
 ṹ    : WAS_NVIM_UE_CAPA_STRU
 ṹ˵  : 洢NVIMеUEϢ               ID:9008 en_NV_Item_WAS_RadioAccess_Capa_New
*****************************************************************************/
typedef struct
{
    VOS_UINT32                              ulHspaStatus;                       /* 0ʾδ,ôDPAUPA֧;1ʾ */

    WAS_RF_CAPA_STRU                        stRfCapa;                           /* RF Ϣ                                  */

    PS_BOOL_ENUM_UINT8                      enSupportPwrBoosting;               /* 16QAMأǷ֧E-DPCCH Power Boosting*/
    PS_BOOL_ENUM_UINT8                      enSf4Support;                       /* Ƿ֧ul dpcch ʹ slotFormat4 */

    WAS_DL_SIMUL_HS_DSCH_CFG_ENUM_UINT8     enDlSimulHsDschCfg;                 /* ENUMERATED  OPTIONAL                         */
    WAS_PTL_VER_TYPE_ENUM_UINT8             enAsRelIndicator;                   /* Access Stratum Release Indicator             */

    PS_BOOL_ENUM_UINT8                      enHSDSCHSupport;                    /* Ƿ֧enHSDSCHSupportı־                */
    VOS_UINT8                               ucHSDSCHPhyCategory;                /* ֧HS-DSCHͱ־                  */

    PS_BOOL_ENUM_UINT8                      enMacEhsSupport;
    VOS_UINT8                               ucHSDSCHPhyCategoryExt;
    PS_BOOL_ENUM_UINT8                      enMultiCellSupport;                 /* Ƿ֧ Multi cell support,֧MultiCell,Ex2 */
    VOS_UINT8                               ucHSDSCHPhyCategoryExt2;            /* HS-DSCH physical layer category extension 2 */

    PS_BOOL_ENUM_UINT8                      enCellSpecTxDiversityForDc;         /*  This IE is optionally present if Dual-Cell HSDPA is supported. Otherwise it is not needed.
                                                                                    The IE is not needed in the INTER RAT HANDOVER INFO message. Otherwise, it is optional*/
    PS_BOOL_ENUM_UINT8                      enEFDPCHSupport;                    /* Ƿ֧E-FDPCHı־,FDPCH֧ʱNVЧ */
    PS_BOOL_ENUM_UINT8                      enEDCHSupport;                      /* Ƿ֧EDCHı־                           */
    VOS_UINT8                               ucEDCHPhyCategory;                  /* ֧UPAĵȼ                                */
    PS_BOOL_ENUM_UINT8                      enSuppUl16QAM;                      /* Ƿ֧16QAM֧ʱucEDCHPhyCategoryExtЧ */
    VOS_UINT8                               ucEDCHPhyCategoryExt;               /* еز֧16QAMʱд7 */
    PS_BOOL_ENUM_UINT8                      enSuppEDpdchInterpolationFormula;   /* 16QAMأǷ֧E-DPDCH power interpolation formula */
    PS_BOOL_ENUM_UINT8                      enSuppHsdpaInFach;                  /* ֧CELL_FACHHS-DSCHĽ */
    PS_BOOL_ENUM_UINT8                      enSuppHsdpaInPch;                   /* ֧CELL_PCHURA_PCHHS-DSCHĽ */

    PS_BOOL_ENUM_UINT8                      enMacIsSupport;                     /* Ƿ֧MAC_I/MAC_Is */

    PS_BOOL_ENUM_UINT8                      enFDPCHSupport;                     /* Ƿ֧FDPCHı־                          */

    PS_BOOL_ENUM_UINT8                      enHsscchLessSupport;                /* Ƿ֧ hsscchlessHsdschOperation           */
    PS_BOOL_ENUM_UINT8                      enUlDpcchDtxSupport;                /* Ƿ֧ discontinuousDpcchTransmission      */

    PS_BOOL_ENUM_UINT8                      enAdjFreqMeasWithoutCmprMode;       /* Ƿ֧ Adjacent Frequency measurements without compressed mode */

    PS_BOOL_ENUM_UINT8                      enMimoSingleStreamStrict;           /* ǷֻʹõMIMO */
    PS_BOOL_ENUM_UINT8                      enMimoWithDlTxDiversity;            /* R9ԣMIMOʱпŵǷʹ÷ּ */

    /* V7r1 ˫ģNV LTE */
    PS_BOOL_ENUM_UINT8                      enSptAbsPriBasedReselInUtra;        /* ֧UTRAеȼѡĬΪ01Ϊ֧֣0Ϊ֧ */

    VOS_UINT8                               ucHSDSCHPhyCategoryExt3;            /* HS-DSCH physical layer category extension 3 */
    PS_BOOL_ENUM_UINT8                      enDcMimoSupport;                    /* Ƿ֧DC+MIMO */
    PS_BOOL_ENUM_UINT8                      enSuppCommEDCH;                     /* E-RACH */

    PS_BOOL_ENUM_UINT8                      enDcUpaSupport;                     /* Ƿ֧DC UPAı־ */
    VOS_UINT8                               ucEDCHPhyCategoryExt2;              /* EDCH  category extension 2*/
    PS_BOOL_ENUM_UINT8                      enEdpdchGainFactorFlg;              /* E-DPDCHʻʹܱ־λ */
    PS_BOOL_ENUM_UINT8                      enHo2EutranUnSupportFlg;            /* Ƿֵ֧LHO */
    PS_BOOL_ENUM_UINT8                      enEutranMeasUnSupportFlg;           /* Ƿֵ֧̬LĲ */
    VOS_UINT8                               aucReserve2[5];
}WAS_NVIM_UE_CAPA_STRU;

/*****************************************************************************
 ṹ    : WAS_PRACH_PARA_STRU
 ṹ˵  : W·ʱҪĲ        ID:9023 en_NV_Item_Wcdma_Prach_Para
*****************************************************************************/
typedef struct
{
    VOS_INT8                                cInitTxPowerExt;                    /*Range:[0,20]*/ /* ʼ书ʵڲ */
    VOS_UINT8                               ucPrbRetransMaxExt;                 /* 뷢ڲ */
    VOS_UINT8                               aucReserve[2];
    VOS_UINT32                              ulASC0Para;                         /* 㷨 */
}WAS_PRACH_PARA_STRU;

/*****************************************************************************
 ṹ    : NVIM_FASTDORM_PARA_STRU
 ṹ˵  : FASTDORMز                   ID:9027 en_NV_Item_Fastdorm_Para
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucWasMaxSCRINumInPCH;               /* WASPDRX<CNDRXڳСֵʱSCRIʹ  */
    VOS_UINT8                               ucNasRetryInterval;                 /* NASRetryʱΪλ*/
    VOS_UINT8                               ucT323Default;                      /* õT323Ϊ0ʱʹNVõĬֵ */
    VOS_UINT8                               aucReserved[1];                     /* Ԥ */
}NVIM_FASTDORM_PARA_STRU;

/*****************************************************************************
 ṹ    : WAS_CSFB_PPAC_STRU
 ṹ˵  : Ϣ                       ID:9050 en_NV_Item_CSFB_PPAC_Para
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8                      enSuppPPACFlg;                      /* PPAC־ */
    PS_BOOL_ENUM_UINT8                      enCsfbRcvAllSibFlg;                 /* CSFBǷȫϵͳϢ־ ,ĬֵΪ0־ȫ */
    PS_BOOL_ENUM_UINT8                      enCsfbSearchFailFastReturnFlg;      /* WָƵСʧܺ󣬲ٷȫƵLTE */
    VOS_UINT8                               ucFrWaitGmmProcAndTimerLen;         /* CSFB̽FRʱǷȴGMM̽Ǻ͵ȴFRʱ */
}WAS_CSFB_PPAC_STRU;

/*****************************************************************************
 ṹ    : WAS_3G_TO_2G_STRU
 ṹ˵  : 3G2GѡŻNV
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8                      enSuppDetectCellSearchFlg;          /* ֧־ */
    VOS_UINT8                               ucDetectCellSearchThreshold;        /* Ĭֵ */
    VOS_UINT8                               ucStartDetectCellSearchCnt;         /* ҪСֹͣ޵Ĵ */
    VOS_UINT8                               ucStopDetectCellSearchCnt;          /* ֹͣҪСֹͣ޵Ĵ */
}WAS_3G_TO_2G_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_REPORT_CELL_SIGN_STRU
 ṹ˵  : СźǿϱʱȺRSCP仯ֵ   ID:9067 en_NV_Item_Report_Cell_Sign
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucPeriodTimerLen;
    VOS_UINT8                               ucRscpThreshold;
    VOS_UINT8                               ucEcn0Threshold;
    VOS_UINT8                               aucReserve1[1];
}WAS_NVIM_REPORT_CELL_SIGN_STRU;

/*****************************************************************************
 ṹ    : WAS_CUSTOMIZED_PARA_STRU
 ṹ˵  : Wѡ                        ID: 9069 en_NV_Item_Was_Customized_Para
*****************************************************************************/
typedef struct
{
    /* Was_Customized_Para */
    VOS_UINT8                               ucSbmMaskSupportType;
    VOS_UINT8                               ucDchOosSearchInterRatFlg;          /* DCH´CUʱT314ʱǷϵͳ*/
    VOS_UINT8                               ucOosAllBandHistoryFreqValidFlg;    /* ָPLMNѣʷƵȫƵʱʷƵ */
    VOS_UINT8                               ucOosAllBandAddHistoryFreqCnt;      /* ȫƵָƵбʱʷƵĸ */
    VOS_UINT32                              ulDocomMcc;
    VOS_UINT32                              ulDocomMnc;
}WAS_CUSTOMIZED_PARA_STRU;

/*****************************************************************************
 ṹ    : WAS_W2L_CEll_RESEL_OFFSET_STRU
 ṹ˵  : W2Lѡ͹NVṹ                ID:9124 en_NV_Item_LOW_POWER_Cell_Resel_OffSet
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8                      enOffsetEnableFlg;                  /* offset NVʹܱ    */
    PS_BOOL_ENUM_UINT8                      enR8BasedCellReselFlg;              /* offset NVʹܱ,enW2LR8BasedCellReselFlgܿ    */
    VOS_UINT8                               aucReserve1[2];                     /* λ */
    VOS_UINT16                              usWRscpThresh;                      /*Range:[0,928]*/  /* WСRSCPޣ޲ʹѡOFFSETȡֵ */
    VOS_UINT16                              usWEcnoThresh;                      /*Range:[0,160]*/  /* WСECNOޣ޲ʹѡOFFSETȡֵ */
    VOS_UINT16                              usEutranCellRsrpOffset;             /*Range:[0,1040]*/ /* EUTRANСRSRP OFFSET */
    VOS_UINT16                              usEutranCellRsrqOffset;             /*Range:[0,160]*/  /* EUTRANСRSRQ OFFSET */
    VOS_UINT16                              usLteServRsrpOffSet;                /*Range:[0,784]*/
    VOS_UINT16                              usLteServRsrqOffSet;                /*Range:[0,256]*/
    VOS_UINT16                              usUtranRscpOffSet;                  /*Range:[0,376]*/
    VOS_UINT16                              usUtranEcn0OffSet;                  /*Range:[0,248]*/
}WAS_W2L_CEll_RESEL_OFFSET_STRU;

/*****************************************************************************
 ṹ    : NVIM_UE_POSITION_CAPABILITIES_STRU
 ṹ˵  : UEĶλṹ                       ID:9093 en_NV_Item_UE_POSITION_CAPABILITIES
*****************************************************************************/
typedef struct
{
   VOS_UINT8                                ucGpsUeAssisted;                    /* UE GPS λ: 0: ֧, 1: ֧ */
   VOS_UINT8                                ucGpsUeBased;                       /* UE GPS λ: 0: ֧, 1: ֧ */
   VOS_UINT8                                ucGpsUeStandalone;                  /* UE GPS λ: 0: ֧, 1: ֧ */
   VOS_UINT8                                ucGpsValidInPch;                    /* PCH̬µ GPS λ(W ģʹ): 0: ֧, 1: ֧ */
   VOS_UINT8                                ucLcsVaCapability;                  /* LCS VALUE ADDλ(G ģʹ): 0: ֧, 1: ֧ */
   VOS_UINT8                                ucAddPosCapability;                 /* ӵĶλ(G ģʹ): 0: ֧, 1: ֧ */

   VOS_UINT8                                aucRsv[2];                          /* λ */
}NVIM_UE_POSITION_CAPABILITIES_STRU;


/*****************************************************************************
 ṹ    : WAS_NVIM_PLMN_SEARCH_THRESHOLD_STRU
 ṹ˵  : NVжȡȫƵ      ID:8483 en_NV_Item_Plmn_Search_Threshold
*****************************************************************************/
typedef struct
{
    VOS_INT8                                cBgSearchHighQulityThreshold;       /* RSSI */
    VOS_INT8                                cOtherSearchHighQulityThreshold;    /* RSSI */
    VOS_INT8                                cLowQulityThreshold;                /* RSSI */
    VOS_UINT8                               ucInterRatMeasOffset;               /* ͣϵͳϼȥĳ */
}WAS_NVIM_PLMN_SEARCH_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_PLMN_SEARCH_FLOW_STRU
 ṹ˵  : NVжȡȫƵ     ID:8484  en_NV_Item_Plmn_Search_Flow
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucBgLowQulityFreqScrhFlag;          /* ѵƵǷҪѱ־*/
    VOS_UINT8                               ucBgMultipleFreqScrhFlag;           /* ѱƵǷҪѱ־*/
    VOS_UINT8                               ucPlmnListLowQulityFreqScrhFlag;    /* PLMNLISTƵǷҪѱ־*/
    VOS_UINT8                               ucPlmnListMultipleFreqScrhFlag;     /* PLMNLISTƵǷҪѱ־*/
    VOS_UINT8                               ucOtherLowQulityFreqScrhFlag;       /* ̵ƵǷҪѱ־*/
    VOS_UINT8                               ucOtherMultipleFreqScrhFlag;        /* ̱ƵǷҪѱ־*/
    VOS_UINT8                               aucReserve1[2];
}WAS_NVIM_PLMN_SEARCH_FLOW_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_ALL_BAND_SEARCH_PARA_STRU
 ṹ˵  : NVжȡȫƵò ID:8485 en_NV_Item_All_Band_Search_Para
*****************************************************************************/
typedef struct
{
    VOS_UINT32                              ulRawScanFftFlag;                   /* bandĴɨ㷨 */
    VOS_UINT8                               aucReserv[2];                       /* 4ֽڶ룬ֽ */
    VOS_UINT8                               ucFftFineScanFreqOffsetNum;         /* FFT㷨ϸɨʱȡƵƫƵ*/
    VOS_UINT8                               ucCellSearchFreqNum;                /* ϸɨһƵҪСƵ*/
    VOS_UINT8                               ucMultipleSrchFreqOffsetNum;        /* ƵʱȡƵƫƵ*/
    VOS_UINT8                               ucPlmnListHistoryFreqThreshold;     /* PLMNLISTʱʷƵĸ*/
    VOS_UINT8                               ucWcdmaRawScanFftStep;              /* FFT㷨ʱ*/
    VOS_UINT8                               ucWcdmaRawScanRssiStep;             /* RSSI㷨ʱ*/
}WAS_NVIM_ALL_BAND_SEARCH_PARA_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_WCDMA_IND_FREQ_STRU
 ṹ˵  : WCDMA IND FREQϢṹ                 ID:8248 en_NV_Item_Wcdma_Ind_Freq UINTṹɽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              usUserIndFreq;
}WAS_NVIM_WCDMA_IND_FREQ_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_PDCP_LOSSLESS_SWITCH_STRU
 ṹ˵  : PDCP LOSSLESS SWITCHϢṹ           ID:8324 en_NV_Item_PDCP_LossLess_Switch UINTṹɽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              usNvPdcpLossLessSwitch;    /*Range:[0,1]*/    /* PDCP Ǩƿ */
}WAS_NVIM_PDCP_LOSSLESS_SWITCH_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_OLPC_MAPWEIGHT_PARA_STRU
 ṹ˵  : WCDMA OLPC MAPWEIGHT PARAϢṹ      ID:8525 en_NV_Item_Wcdma_OLPC_MapWeight_Para UINTṹɽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              ausMapWeight[WAS_MAPWEIGHT_MAX_NUM];    /*TOT OLPC㷨*/
}WAS_NVIM_OLPC_MAPWEIGHT_PARA_STRU;

/*****************************************************************************
 ṹ    : WAS_NVIM_W_CELLSRCH_MEAS_PARA
 ṹ˵  : W_CELLSRCH_MEAS_PARAϢṹ           ID:8256 NV
*****************************************************************************/
typedef struct
{
    VOS_UINT16                              usSysInfoRcvOptimSwitch;
    VOS_UINT16                              usPIOptimSwitch;
    VOS_UINT16                              usCellSrchMeasOptimSwitch;
    VOS_UINT16                              usCellSrchPeriod;
    VOS_INT16                               sCsStartRSCPThreshold;
    VOS_INT16                               sCsStopRSCPThreshold;
    VOS_INT16                               sCsStartECN0Threshold;
    VOS_INT16                               sCsStopECN0Threshold;
    VOS_UINT16                              usMeasIntraNCellNum;
    VOS_UINT16                              usMeasFilterFactor;
}WAS_NVIM_W_CELLSRCH_MEAS_PARA;

/*****************************************************************************
 ṹ    : WAS_NVIM_UE_ACCESS_CAPA
 ṹ˵  : UE_ACCESS_CAPAϢṹ                 ID:8264 NV
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               aucWasUeAccessCapa[WAS_UE_ACCESS_CAPA_NUM];
}WAS_NVIM_UE_ACCESS_CAPA;

/*****************************************************************************
 ṹ    : NV_ITEM_BG_IRAT_LIST_STRU
 ṹ˵  : BG_IRAT_LISTϢṹ                   ID:8487 NV
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucValid;
    VOS_UINT8                               ucReserve;
    VOS_UINT16                              usBgIratListTime;                   /*Range:[6,65536]*/
}NV_ITEM_BG_IRAT_LIST_STRU;


/*****************************************************************************
 ṹ    : WAS_NVIM_T_CR_MAX_STRU
 Э  : 10.3.2.3 Cell selection and re-selection info for SIB3/4
 ASN.1 : T_CRMax
 ṹ˵  : ƶ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucTCrMax;       /* λ:10s0ʾʹã(0, 3, 6, 12, 18, 24) */
    VOS_UINT8                           ucNCr;          /* ucTCRMaxΪ0ʱЧdefault 8Integer(1..16) */
    VOS_UINT8                           ucTCrMaxHyst;   /* ucTCRMaxΪ0ʱЧλ:1s0ʾʹã(0, 10, 20, 30, 40, 50, 60, 70) */
    VOS_UINT8                           ucReserve;
}WAS_NVIM_T_CR_MAX_STRU;

/*****************************************************************************
 ṹ    : WAS_NV_OOS_RL_FAIL_PARA_STRU
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucOosTimerLen;
    PS_BOOL_ENUM_UINT8                      enT313UseDefaultValueFlg;
    VOS_UINT8                               ucReserve[2];
}WAS_NV_OOS_RL_FAIL_PARA_STRU;
/* Added by p00179010 for DTS2014042105131, 2014-02-18, begin */
/*****************************************************************************
 ṹ    : NVIM_SBM_CUSTOM_DUAL_IMSI_STRU
 ṹ˵  : ձEMOIBLEеplmnϢplmn LTEҪõ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucJapanEmMcc[3];  /* ձEMBILEMCCϢ */
    VOS_UINT8                           ucJapanEmMncCount; /* ձEMBILEMNCȣ23 */
    VOS_UINT8                           aucJapanEmMnc[3];  /* ձEMBILEMNCϢ,Ϊλλf */
    VOS_UINT8                           ucReserve;
} NVIM_JAPAN_EM_PLMN_INFO_STRU;
/*****************************************************************************
 ṹ    : NVIM_SBM_CUSTOM_DUAL_IMSI_STRU
 ṹ˵  : ˫imsiغMCCϢ
*****************************************************************************/

typedef struct
{
    VOS_UINT8                           ucSbmCustomDualImsiFlg;
    VOS_UINT8                           aucJapanMcc[3];      /* ձһMCC */
    VOS_UINT8                           aucJapanMcc1[3];     /* ձһMCC */
    VOS_UINT8                           ucJapanSbmMncCount;  /* ձMNC */
    VOS_UINT32                          aulJapanSbmMnc[5];   /* ձ5MNC,չ */
    NVIM_JAPAN_EM_PLMN_INFO_STRU        stJapanEmPlmnInfo;   /* ձEMOBILEplmnϢ */
    VOS_UINT8                           ucSbmOosTimerLen;    /* פձĶʱʱǰֻband1band11 */
    VOS_UINT8                           aucReserve[3];
} NVIM_SBM_CUSTOM_DUAL_IMSI_STRU;
/* Added by w00134354 for DTS2014112502336, 2014-11-25, begin */
/*****************************************************************************
 ṹ    : NVIM_SBM_CUSTOM_DUAL_IMSI_STRU_NEW
 ṹ˵  : ˫imsiغMCCϢ
*****************************************************************************/

typedef struct
{
    VOS_UINT8                           ucSbmCustomDualImsiFlg;/* ˫Imsiܿ */
    VOS_UINT8                           ucDualImsiCellSearchChkFlg; /* Ƿʱband  */
    VOS_UINT8                           aucReserve[2];       /* λ */
    VOS_UINT8                           ucSbmOosTimerLen;    /* פձĶʱ */
    VOS_UINT8                           aucJapanMcc[3];      /* ձһMCC */
    VOS_UINT8                           aucJapanMcc1[3];     /* ձһMCC */
    VOS_UINT8                           ucJapanSbmMncCount;  /* ձMNC */
    VOS_UINT32                          aulJapanSbmMnc[5];   /* ձ5MNC,չ */
    NVIM_JAPAN_EM_PLMN_INFO_STRU        stJapanEmPlmnInfo;   /* ձEMOBILEplmnϢ */
    VOS_UINT32                          ulSbmSupBandInJapan;         /* ձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                          ulEmSupBandInJapan;          /* EMձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                          ulOtherOperateSupBandInJapan;/* Ӫձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                          ulSupBandOutJapan;           /* ձֵ֧band,ȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                          ulLteDelWcdmaBandInJapan;    /* ձפLteʱҪεWband,ȫ1ΪҪеWband */
} NVIM_SBM_CUSTOM_DUAL_IMSI_STRU_NEW;

/*****************************************************************************
 ṹ    : NVIM_SBM_CUSTOM_DUAL_IMSI_STRU
 ṹ˵  : WAS˫imsiϢ
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8                      enNvSbmDualImsiFlg;     /* ˫imsiǷ򿪣ĬϹرգ */
    PS_BOOL_ENUM_UINT8                      enDualImsiCellSearchChkFlg; /* Ƿʱband  */
    VOS_UINT8                               ucSbmOosTimerLen;       /* פձĶʱʱǰֻband1band11 */
    VOS_UINT8                               ucJapanSbmMncCount;     /* ձMNC */
    VOS_UINT32                              aulJapanSbmMnc[5];      /* ձ5MNC,չֲ֧ */
    VOS_UINT32                              ulJapanMcc;             /* ձһMCC */
    VOS_UINT32                              ulJapanMcc1;            /* ձһMCC */
    VOS_UINT32                              ulEmMcc;                /* ձembileMCC */
    VOS_UINT32                              ulEmMnc;                /* ձembileMNC */
    VOS_UINT32                              ulSbmSupBandInJapan;    /* ձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                              ulEmSupBandInJapan;      /* EMձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                              ulOtherOperateSupBandInJapan;/* Ӫձֵ֧bandȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
    VOS_UINT32                              ulSupBandOutJapan;        /* ձֵ֧band,ȫ1Ϊֵ֧bandƣ֧UEֵ֧band */
} WAS_NV_SBM_CUSTOM_DUAL_IMSI_STRU;
/* Added by w00134354 for DTS2014112502336, 2014-11-25, end */
/* Added by p00179010 for DTS2014042105131, 2014-02-18, end */
/* Added by z00184470 for DTS2014050902978, 2014-05-19 begin */
/*****************************************************************************
 ṹ    : WAS_NV_YOIGO_CUSTOM_PARA_INFO_STRU
 ṹ˵  : YOIGOƿغPLMNϢ
*****************************************************************************/
typedef struct
{
    PS_BOOL_ENUM_UINT8            enYoigoCustomSwitchFlag;          /* YOIGOƿǷ򿪱־ĬϹر */
    VOS_UINT8                     aucReserve[3];                    /* λ */
    VOS_UINT32                    ulYoigoMcc;                       /* YOIGOMCC */
    VOS_UINT32                    ulYoigoMnc;                       /* YOIGOMNC */
}WAS_NV_YOIGO_CUSTOM_PARA_INFO_STRU;
/* Added by z00184470 for DTS2014050902978, 2014-05-19, end */



/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/

#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif





#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of WasNvInterface.h */
