/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : TtfNvInterface.h
  Description     : TtfNvInterface.h header file
  History         :

******************************************************************************/

#ifndef __TTFNVINTERFACE_H__
#define __TTFNVINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#include "vos.h"

/*****************************************************************************
  2 Macro
*****************************************************************************/

#define TTF_MEM_MAX_POOL_NUM                (5)
#define TTF_MEM_MAX_CLUSTER_NUM             (8)

#define FC_UL_RATE_MAX_LEV                  (11)
#define TTF_MEM_POOL_NV_NUM                 (TTF_MEM_MAX_POOL_NUM + 1)
#define FC_ACPU_DRV_ASSEM_NV_LEV            (4)


/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/

enum FC_MEM_THRESHOLD_LEV_ENUM
{
    FC_MEM_THRESHOLD_LEV_1              = 0,
    FC_MEM_THRESHOLD_LEV_2,
    FC_MEM_THRESHOLD_LEV_3,
    FC_MEM_THRESHOLD_LEV_4,
    FC_MEM_THRESHOLD_LEV_5,
    FC_MEM_THRESHOLD_LEV_6,
    FC_MEM_THRESHOLD_LEV_7,
    FC_MEM_THRESHOLD_LEV_8,
    FC_MEM_THRESHOLD_LEV_BUTT           = 8
};
typedef VOS_UINT32  FC_MEM_THRESHOLD_LEV_ENUM_UINT32;

enum FC_ACPU_DRV_ASSEM_LEV_ENUM
{
    FC_ACPU_DRV_ASSEM_LEV_1             = 0,
    FC_ACPU_DRV_ASSEM_LEV_2,
    FC_ACPU_DRV_ASSEM_LEV_3,
    FC_ACPU_DRV_ASSEM_LEV_4,
    FC_ACPU_DRV_ASSEM_LEV_5             = 4,
    FC_ACPU_DRV_ASSEM_LEV_BUTT          = 5
};
typedef VOS_UINT32  FC_ACPU_DRV_ASSEM_LEV_ENUM_UINT32;

/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
*                                                                            *
*                           Ϣṹ                                 *
*                                                                            *
******************************************************************************/

/*****************************************************************************
 ṹ    : TTF_MEM_POOL_CFG_NV_STRU
 ṹ˵  : TTF_MEM_POOL_CFG_NVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                      ucClusterCnt;
    VOS_UINT8                      aucReserved[1];
    VOS_UINT16                     ausBlkSize[TTF_MEM_MAX_CLUSTER_NUM];         /* ĴС */
    VOS_UINT16                     ausBlkCnt[TTF_MEM_MAX_CLUSTER_NUM];          /*  */
}TTF_MEM_POOL_CFG_NV_STRU;

/*****************************************************************************
 ṹ    : TTF_MEM_SOLUTION_CFG_NV_STRU
 ṹ˵  : TTF_MEM_SOLUTION_CFGӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucPoolCnt;
    VOS_UINT8                           ucPoolMask;                             /* ӦڴǷЧλbitʾ1- Ч 0- Ч*/
    TTF_MEM_POOL_CFG_NV_STRU            astTtfMemPoolCfgInfo[TTF_MEM_POOL_NV_NUM];
}TTF_MEM_SOLUTION_CFG_NV_STRU;

/*****************************************************************************
 ṹ    : FC_CFG_CPU_STRU
 ṹ˵  : FC_CFG_CPUṹ,CPUص޺ֵ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulCpuOverLoadVal;                       /*Range:[0,100]*//* CPU */
    VOS_UINT32                          ulCpuUnderLoadVal;                      /*Range:[0,100]*//* CPU */
    VOS_UINT32                          ulSmoothTimerLen;                       /*Range:[2,1000]*//* CPUƽλ:CPU */
    VOS_UINT32                          ulStopAttemptTimerLen;                  /* CPURӿغжʱϳʱǰλ: 룬0ʾʹ */
    VOS_UINT32                          ulUmUlRateThreshold;                    /* տޣڴޣΪCPUظߣҪ */
    VOS_UINT32                          ulUmDlRateThreshold;                    /* տޣڴޣΪCPUظߣҪ */
    VOS_UINT32                          ulRmRateThreshold;                      /* E5̬£ WIFI/USBڴޣ ڴޣΪCPUظߣҪأλbps */
} FC_CFG_CPU_STRU;

/*****************************************************************************
 ṹ    : FC_CFG_MEM_THRESHOLD_STRU
 ṹ˵  : FC_CFG_MEM_THRESHOLDṹ,MEMص޺ֵ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulSetThreshold;                         /*  λֽ */
    VOS_UINT32                          ulStopThreshold;                        /* ֹͣ λֽ */
} FC_CFG_MEM_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : FC_CFG_MEM_THRESHOLD_CST_STRU
 ṹ˵  : FC_CFG_MEM_THRESHOLD_CSTṹ,MEMص޺ֵ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulSetThreshold;                         /*Range:[0,4096]*//*  λֽ */
    VOS_UINT32                          ulStopThreshold;                        /*Range:[0,4096]*//* ֹͣ λֽ */
} FC_CFG_MEM_THRESHOLD_CST_STRU;


/*****************************************************************************
 ṹ    : FC_CFG_UM_UL_RATE_STRU
 ṹ˵  : FC_CFG_UM_UL_RATEṹ,տʵλ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucRateCnt;                              /*Range:[0,11]*//* ʵλ֧11λãȼΪFC_PRI_9ʹõλʱֻǰ9Ч */
    VOS_UINT8                           aucRsv[1];
    VOS_UINT16                          ausRate[FC_UL_RATE_MAX_LEV];            /* ƣȡֵΧ[0,65535]λbps */
} FC_CFG_UM_UL_RATE_STRU;

/*****************************************************************************
 ṹ    : FC_CFG_NV_STRU
 ṹ˵  : FC_CFG_NVӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulFcEnbaleMask;                         /* ʹܱʶ */
    FC_CFG_CPU_STRU                     stFcCfgCpuA;                            /* ACPU */
    VOS_UINT32                          ulFcCfgMemThresholdCnt;                 /*Range:[0,8]*/
    FC_CFG_MEM_THRESHOLD_STRU           stFcCfgMem[FC_MEM_THRESHOLD_LEV_BUTT];  /* Aڴ */
    FC_CFG_MEM_THRESHOLD_CST_STRU       stFcCfgCst;                             /* CSDҵ */
    FC_CFG_MEM_THRESHOLD_STRU           stFcCfgGprsMemSize;                     /* Gģڴ */
    FC_CFG_MEM_THRESHOLD_STRU           stFcCfgGprsMemCnt;                      /* Gģڴ */
    FC_CFG_CPU_STRU                     stFcCfgCpuC;                            /* CCPU */
    FC_CFG_UM_UL_RATE_STRU              stFcCfgUmUlRateForCpu;                  /* CCPUʵλ */
    FC_CFG_UM_UL_RATE_STRU              stFcCfgUmUlRateForTmp;                  /* C¶ʵλ */
} FC_CFG_NV_STRU;

/*****************************************************************************
 ṹ    : CPULOAD_CFG_STRU
 ṹ˵  : CPULOAD_CFGӦNVṹ,CPUص޺ֵ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulMonitorTimerLen;
} CPULOAD_CFG_STRU;

typedef struct
{
    VOS_UINT8                          ucHostOutTimeout;    /* PCʱ */
    VOS_UINT8                          ucEthTxMinNum;       /* UE */
    VOS_UINT8                          ucEthTxTimeout;      /* UEʱ */
    VOS_UINT8                          ucEthRxMinNum;       /* UE */
    VOS_UINT8                          ucEthRxTimeout;      /* UEʱ */
    VOS_UINT8                          ucCdsGuDlThres;
    VOS_UINT8                          aucRsv[2];
}FC_DRV_ASSEM_PARA_STRU;

typedef struct
{
    VOS_UINT32                          ulCpuLoad;
    FC_DRV_ASSEM_PARA_STRU              stDrvAssemPara;
}FC_CPU_DRV_ASSEM_PARA_STRU;

/*****************************************************************************
 ṹ    : FC_CPU_DRV_ASSEM_PARA_NV_STRU
 ṹ˵  : FC_CPU_DRV_ASSEMӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                              ucEnableMask;
    VOS_UINT8                              ucSmoothCntUpLev;
    VOS_UINT8                              ucSmoothCntDownLev;
    VOS_UINT8                              ucRsv;
    FC_CPU_DRV_ASSEM_PARA_STRU             stCpuDrvAssemPara[FC_ACPU_DRV_ASSEM_NV_LEV];
}FC_CPU_DRV_ASSEM_PARA_NV_STRU;

/*****************************************************************************
 ṹ    : WTTF_MACDL_WATERMARK_LEVEL_STRU
 ṹ˵  : WTTF_MACDL_BBMST_WATER_LEVELӦNVṹ,BBPжˮߵȼṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulWaterLevelOne;                        /* ˮ߽1 */
    VOS_UINT32                          ulWaterLevelTwo;                        /* ˮ߽2 */
    VOS_UINT32                          ulWaterLevelThree;                      /* ˮ߽3 */
    VOS_UINT32                          ulWaterLevelFour;                       /* ˮ߽4,Ԥ */
} WTTF_MACDL_WATERMARK_LEVEL_STRU;

/*****************************************************************************
 ṹ    : WTTF_MACDL_BBPMST_TB_HEAD_STRU
 ṹ˵  : WTTF_MACDL_BBMST_TB_HEADӦNVṹ,BBPжˮߵȼṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulTBHeadNum;                /* TBͷ */
    VOS_UINT32                          ulTBHeadReserved;           /* TBͷԤTBԤ3֡V9R1 30飬V3R3 15  */
} WTTF_MACDL_BBPMST_TB_HEAD_STRU;

/*****************************************************************************
 ṹ    : NF_EXT_NV_STRU
 ṹ˵  : NETFILTER_HOOK_MASKӦNVṹ,ùNVԤ5:
             ulNvValue1~ulNvValue5, ÿȡֵΧΪ0-FFFFFFFF,
             λΪ1λӦĹӺܻᱻעᵽں
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulNetfilterPara1;
    VOS_UINT32          ulNetfilterPara2;
    VOS_UINT32          ulNetfilterPara3;
    VOS_UINT32          ulNetfilterPara4;
    VOS_UINT32          ulNetfilterPara5;
}NF_EXT_NV_STRU;

/*****************************************************************************
 ṹ    : EXT_TEBS_FLAG_NV_STRU
 ṹ˵  : NV_Ext_Tebs_FlagӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulExtTebsFlag;
}EXT_TEBS_FLAG_NV_STRU;

/*****************************************************************************
 ṹ    : TCP_ACK_DELETE_FLG_NV_STRU
 ṹ˵  : NV_TCP_ACK_Delete_FlgӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulTcpAckDeleteFlg;
}TCP_ACK_DELETE_FLG_NV_STRU;

/*****************************************************************************
 ṹ    : HUAWEI_IRAN_OPEN_PAGE_I_NV_STRU
 ṹ˵  : HUAWEI_IRAN_OPEN_PAGE_I_NVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16          usHuaweiIranOpenPageI;      /*Range:[0,1]*/
}HUAWEI_IRAN_OPEN_PAGE_I_NV_STRU;

/*****************************************************************************
 ṹ    : GCF_TYPE_CONTENT_NV_STRU
 ṹ˵  : GCFTypeContentӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulGcfTypeContent;
}GCF_TYPE_CONTENT_NV_STRU;

/*****************************************************************************
 ṹ    : W_RF8960_BER_TEST_NV_STRU
 ṹ˵  : W_RF8960_BER_TestӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulRlc8960RFBerTestFlag;
}W_RF8960_BER_TEST_NV_STRU;

/*****************************************************************************
 ṹ    : LAPDM_RAND_BIT_NV_STRU
 ṹ˵  : LAPDM_RAND_BITӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16          usLapdmRandBit;         /*Range:[0,1]*/
}LAPDM_RAND_BIT_NV_STRU;

/*****************************************************************************
 ṹ    : CBS_W_DRX_SWITCH_NV_STRU
 ṹ˵  : CBS_W_DRX_SwitchӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulCbsWDrxSwitch;
}CBS_W_DRX_SWITCH_NV_STRU;

/*****************************************************************************
 ṹ    : CBS_W_WAIT_NEW_CBS_MSG_TIMER_NV_STRU
 ṹ˵  : CBS_W_WaitNewCBSMsgTimerӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulCbsWWaitNewCbsMsgTimer;
}CBS_W_WAIT_NEW_CBS_MSG_TIMER_NV_STRU;

/*****************************************************************************
 ṹ    : CBS_W_WAIT_SHED_MSG_TIMER_NV_STRU
 ṹ˵  : CBS_W_WaitShedMsgTimerӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulCbsWWaitShedMsgTimer;
}CBS_W_WAIT_SHED_MSG_TIMER_NV_STRU;

/*****************************************************************************
 ṹ    : FC_QOS_STRU
 ṹ˵  : FC_QOS_STRU ׮ʹýṹ,ĿǰѾʹãΪ˱NVṹ仯
*****************************************************************************/

typedef struct
{
    VOS_UINT32          ulULKBitRate;
    VOS_UINT32          ulDLKBitRate;
}FC_QOS_STRU;

/*****************************************************************************
 ṹ    : CPU_FLOW_CTRL_CONFIG_NV_STRU
 ṹ˵  : CPU_FLOW_CTRL_CONFIG_STRUӦNVṹѷ׮ṩ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulFuncMask;
    VOS_UINT32          ulCpuOverLoadVal;
    VOS_UINT32          ulCpuUnderLoadVal;
    FC_QOS_STRU         astQos1[2];
    FC_QOS_STRU         astQos2[2];
    FC_QOS_STRU         stUmtsEhsUlLimitForDlHighRate;
    FC_QOS_STRU         stUmtsHslULimitForDlHighRate;
    FC_QOS_STRU         stUlLimitForDlLowRate;
    VOS_UINT32          ulRItfDlkBitRate;
    VOS_UINT32          ulRItfRate;
    VOS_UINT32          ulWaitQosTimeLen;
    VOS_UINT32          ulSmoothTimerLen;
    VOS_UINT32          ulRItfSetTimerLen;
    VOS_UINT32          ulCpuFlowCtrlEnable;
    VOS_UINT32          aulRsv[2];
}CPU_FLOW_CTRL_CONFIG_NV_STRU;

/*****************************************************************************
 ṹ    : R_ITF_FLOW_CTRL_CONFIG_STRU
 ṹ˵  : R_ITF_FLOW_CTRL_CONFIG_STRUӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32              ulRateDismatchUsbEnable;
    VOS_UINT32              ulRateDismatchWifiEnable;
} R_ITF_FLOW_CTRL_CONFIG_STRU;

/*****************************************************************************
 ṹ    : TFC_POWER_FUN_ENABLE_NV_STRU
 ṹ˵  : TFC_POWER_FUN_ENABLEӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulTfcPowerFunEnable;
}TFC_POWER_FUN_ENABLE_NV_STRU;

/*****************************************************************************
ṹ    : PPP_CONFIG_MRU_TYPE_NV_STRU
ṹ˵  : PPP_CONFIG_MRU_TypeӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                           usPppConfigType;   /*Range:[296,1500]*/
}PPP_CONFIG_MRU_TYPE_NV_STRU;

/*****************************************************************************
 ṹ    : FC_CDS_DL_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : CDSжýṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulDiscardThres;         /* CDSжж */
    VOS_UINT32          ulDiscardRate;          /*  */
} FC_CDS_DL_CONFIG_STRU;

/*****************************************************************************
 ṹ    : QOS_FC_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : QOSýṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT32          ulPktCntLimit;              /* QoSذ */
    VOS_UINT32          ulTimerLen;                 /* QoSʱ */
    VOS_UINT32          ulRandomDiscardRate;        /*  */
    VOS_UINT32          ulDiscardRate;              /*  */
    VOS_UINT32          ulWarningThres;             /* ֵ뱣ĳȫΪ״̬ */
    VOS_UINT32          ulDiscardThres;             /* ֵӵȼؿʼóΪ״̬ */
    VOS_UINT32          ulRandomDiscardThres;       /* ֵӵȼؿʼóΪ״̬ */
    VOS_UINT32          ulRestoreThres;             /* ֵָӸȼؿʼ𽥻ָ */
} QOS_FC_CONFIG_STRU;

typedef struct
{
    VOS_UINT32              ulFcEnableMask;         /* ؿ */
                                                    /* bit0 QoSǷʹ */
                                                    /* bit1 ȼǷ */
                                                    /* bit2 CDSǷʹ */
                                                    /* bit3 ȼǷ񲻶 */
    QOS_FC_CONFIG_STRU      stQosFcConfig;
    FC_CDS_DL_CONFIG_STRU   stFcCdsDlConfig;
}FLOWCTRL_CDS_CONFIG_STRU;

/*****************************************************************************
ṹ    : BMC_CBS_MSG_READ_NV_STRU
ṹ˵  : BMC_CBS_MSG_READ_NV_STRUӦNVṹ
*****************************************************************************/

typedef struct
{
    VOS_UINT8               ucDisableReadAdvised;    /*Range:[0,1]*//*ϢϢΪadvisedʱӦDRXϢǷܣ PS_FALSEΪܣPS_TRUEΪ*/
    VOS_UINT8               ucDisableReadOptional;   /*Range:[0,1]*//*ϢϢΪoptionalʱӦDRXϢǷܣPS_FALSEΪܣPS_TRUEΪ*/
    VOS_UINT8               ucReserved[2];
}BMC_CBS_MSG_READ_NV_STRU;


/*****************************************************************************
ṹ    : NV_MODEM_RF_SHARE_CFG_STRU
ṹ˵  : NV_MODEM_RF_SHARE_CFGӦNVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                          usSupportFlag;      /*Range:[0,1]*//* Ƿֱ֧ */
    VOS_UINT16                          usGSMRFID;          /* GSMģʽRFIDϢ */
    VOS_UINT16                          usWCDMARFID;        /* WCDMAģʽRFIDϢ */
    VOS_UINT16                          usTDSRFID;          /* TD-SCDMAģʽRFIDϢ */
    VOS_UINT16                          usLTERFID;          /* LTEģʽRFIDϢ */
    VOS_UINT16                          usCDMARFID;         /* CMDAģʽRFIDϢ */
    VOS_UINT16                          usEVDORFID;         /* CDMA EVDOģʽRFIDϢ */
    VOS_UINT16                          usReserved;
} NV_MODEM_RF_SHARE_CFG_STRU;


/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/
















#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of TtfNvInterface.h */
