/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : PhyNvDefine.h
  Description     : PhyNvDefine.h header file
  History         :

******************************************************************************/
#include "uphy_type_define.h"
#include "ucom_nvdefine_union.h"


#ifndef __PHYNVDEFINE_H__
#define __PHYNVDEFINE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


#pragma pack(1)


/*****************************************************************************
  2 궨
*****************************************************************************/


/* xiongjiangjiang Begine */
#define UCOM_NV_EDGE_TX_TEMP_COMP_NUM           ( 16 )
#define UCOM_NV_EDGE_TX_RF_GAIN_CTRL_NUM        ( 20 )


#define UCOM_NV_G_RAMP_PWR_LEVEL_NUM        ( 7 )                               /* 10dBm,20dBmΪ3¹ */
#define UCOM_NV_G_TX_REF_CHAN_NUM_MAX       ( 32 )                              /* TXƵʲУ׼Ƶ */


#define UCOM_NV_G_TX_8PSK_PWR_CONT_NUM      ( 30 )                              /* ()8PSKҪУķ书ʵΪ30 */
#define UCOM_NV_G_TX_PWR_CONT_NUM           ( 60 )                              /* ҪУķ书ʵΪ60 */


#define UCOM_NV_G_TEMP_LEVEL_NUM            ( 16 )                              /* [¶ȵλ,5:-20~0,0~20,20~40,40~60,60~85] */
#define UCOM_NV_G_AGC_LEVEL_MAX_NUM         ( 8 )
#define UCOM_NV_G_GAIN_THRESHOLD_MAX_NUM    ( UCOM_NV_G_AGC_LEVEL_MAX_NUM - 1 )  /* UCOM_NV_G_AGC_LEVEL_MAX_NUM - 1 */
#define UCOM_G_RX_OTHER_GAIN_DCR_CHAN_NUM   ( UCOM_NV_G_AGC_LEVEL_MAX_NUM - 1 ) /* ƵλDCRУ׼ */


#define UCOM_NV_G_CHAN_GAIN_MAX_NUM         ( 8 )                               /* 浵AGCλʶӦϵ */

#define UCOM_NV_G_TX_POWER_LEVEL_NUM        ( 3 )                               /* 书ʻΪ3ȼ */
#define UCOM_NV_G_TX_CHAN_COMP_NUM          ( 32 )                              /* 8PSK TXƵʲο */
#define UCOM_NV_G_PCL_NUM                   ( 32 )                              /* ʵȼ */
#define UCOM_NV_G_TX_SLOT_MAX_NUM           ( 4 )                               /* ʵȼ */

#define UCOM_NV_G_TX_ATTEN_NUM              ( 55 )                              /* 8PSK ˥ */

#define UCOM_NV_G_RX_CHAN_COMP_NUM          ( 16 )                              /* Ƶβο */
#define UCOM_NV_G_HIGH_BAND_CHAN_COMP_NUM   ( 16 )                              /* Ƶβο */

#define UCOM_NV_G_RX_GSM850_GAIN0_DCR_NUM   ( 42 )
#define UCOM_NV_G_RX_GSM900_GAIN0_DCR_NUM   ( 65 )
#define UCOM_NV_G_RX_DCS1800_GAIN0_DCR_NUM  ( 125 )
#define UCOM_NV_G_RX_PCS1900_GAIN0_DCR_NUM  ( 100 )
#define UCOM_G_RX_GAIN0_DCR_MAX_NUM         ( 125 )

#if ( FEATURE_ON == FEATURE_VIRTUAL_BAND )
#define UCOM_NV_G_BAND_NUM                  ( 5 )                               /* GSM Narrow DcsƵ */
#else
#define UCOM_NV_G_BAND_NUM                  ( 4 )                               /* GSMĸƵ */
#endif
#define UCOM_NV_G_BAND_NUMBER               ( 4 )                               /* GSMĸƵ */
#define UCOM_NV_G_HIGH_BAND_NUM             ( 2 )                               /* Ƶΰ1800/1900Ƶ */
#define UCOM_NV_G_LOW_BAND_NUM              ( 2 )                               /* Ƶΰ850/900Ƶ */
#define UCOM_NV_G_HIGH_BAND_INDEX           ( 0 )                               /* Ƶΰ1800/1900Ƶ */
#define UCOM_NV_G_LOW_BAND_INDEX            ( 1 )                               /* Ƶΰ850/900Ƶ */
#define UCOM_NV_G_HIGH_LOW_BUTT             ( 2 )                               /* GģָߵBAND */
#define UCOM_NV_G_SUBBAND_NUM               ( 3 )                               /* ÿƵƵθ */
#define UCOM_NV_G_RAMP_COEF_NUM             ( 16 )                              /* µ */

/* xiongjiangjiang End */

#define UCOM_NV_W_BAND_SECTION_NUM                  ( 3 )                       /* W BAND SECTION */
#define UCOM_NV_WCDMA_PA_EN_LINE_NUM        ( 4 )                               /* w pa 4 line */

/* HSUPA ETFCI  */
#define UCOM_NV_HSUPA_ETFCI_TABLE_MAX_NUM   ( 6 )

#define UCOM_NV_W_TX_TEMP_COMP_NUM                  ( 16 )                      /* ÿRF Gainλ¶ȲĿ */

#define UCOM_NV_W_TX_RF_GAIN_CTRL_NUM               ( 20 )                      /* RF浵λĿ */

#define UCOM_W_MAX_RF_GAIN_CTRL_NUM             ( 20 )                          /* rf gain ctrlλ */

#define UCOM_W_MAX_RF_BIAS_NUM                  ( 16 )                          /* rf BIASλ */
#define UCOM_W_MAX_RF_BB_GAIN_NUM               ( 32 )                          /* rf BB GAINλ */

#define UCOM_NV_MAX_RF_VCO_CONFIG_NUM               ( 4 )                       /* RF VCO CONFIG */
#define UCOM_NV_W_TX_RF_BIAS_NUM                    ( 0x4 )                     /* RF TX BIAS */
#define UCOM_NV_W_TX_DPA_IQ_REDUCTION_NUM           ( 15 )                      /* DPAҵֻ */
#define UCOM_NV_W_TX_SCUPA_IQ_REDUCTION_NUM         ( 26 )                      /* SC-UPAҵֻ */
#define UCOM_NV_W_TX_DPA_MPR_NUM                    ( 15 )                      /* DPAҵĹʻ */
#define UCOM_NV_MAX_MMMBPA_CMD_NUMBER                ( 8 )                       /* Ŀ */
#define UCOM_NV_MAX_MIPI_ANT_CMD_NUMBER              ( 4 )                       /* ant switchĿ */
#define UCOM_NV_W_ANT_NUM                            ( 2 )                        /* 2 */
#define UCOM_NV_W_TX_SCUPA_MPR_NUM                   ( 26 )                      /* SC-UPAҵĹʻ */
#define UCOM_NV_W_TX_DCUPA_MPR_NUM                   ( 7 )                       /* SC-UPAҵĹʻ */
#define UCOM_NV_SAR_BACKOF_NUM                       ( 9 )                               /* SAR9ȼ */
#define UCOM_NV_W_PA_GAIN_SWITCH_COMP_BOUNDARY_NUM  ( 5 )                       /* W TX PAл㲹,ÿBAND5 */
#define UCOM_NV_APT_MAX_NUM                 ( 32 )                              /* ÿλAPT */
#define UCOM_NV_PA_GAIN_MAX_NUM             ( 3 )                               /* PAλ */
#define UCOM_WCDMA_UARFCN_NUM               ( 0x10 )                            /* ÿƵUARFCN */
#define UCOM_NV_W_TX_PA_MODE_NUM            ( 3 )                               /* PA :е */
#define UCOM_NV_W_TEMP_NUM                  ( 0x10  )                           /* ¶Ȳõ¶ȵ㣬ǰ5ֱ -20,0,20,40,606ֽڶ */
#define UCOM_NV_W_TX_PA_TEMP_NUM            ( 0x10 )                            /* TX PA¶Ȳõ¶ȵ㣬ɹ·16 */
#define UCOM_NV_W_TX_FREQ_COMP_NUM          ( 0x10 )                            /* TX PA¶Ȳõ¶ȵ㣬ɹ·16 */


#define UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM             ( 0x8 )
#define UCOM_NV_W_AGC_GAIN_NOBLK_THRESHOLD_NUM        ( UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM -1 )  /* 6361AGC GAINλл޵ĸ
                                                         ֵڵλ=(UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM - 1) */

#define UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM               ( 0x8 )                                           /* NVblockλ */
#define UCOM_NV_W_AGC_GAIN_BLK_THRESHOLD_NUM          ( UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM - 1 )    /* 6361AGC GAINλл޵ĸ
                                                                  UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM - 1 */

#define UCOM_NV_W_PA_NONLINEAR_NUM                  ( 32 )                      /* PAԲ */
#define UCOM_NV_W_TX_HDET_DPA_CM_COMP_NUM           ( 15 )                      /* DPAҵPDCM */
#define UCOM_NV_W_TX_HDET_SCUPA_CM_COMP_NUM         ( 26 )                      /* SC-UPAҵPDCM */

#define UCOM_NV_W_APT_FREQ_COMP_NUM                 ( 16 )
#define UCOM_NV_W_APT_TEMP_COMP_NUM                 ( 16 )

#define UCOM_NV_W_CHANNEL_NUM               ( 3 )                               /* NVÿBANDָеŵ */
#define UCOM_NV_W_PA_SWITCH_COMP_SLOT       ( 4 )                               /* Paлʱ϶ */
#define UCOM_NV_W_APC_ATTEN_NUM             ( 0x58 )
#define UCOM_NV_W_TX_HDET_PV_NUM            ( 0x10 )                            /* PAĹѹ */
#define UCOM_NV_W_PA_GAIN_SWITCH_COMP_CHAN_NUM      ( 4 )                       /* W TX PAл㲹4ֽƵ */
#define UCOM_NV_W_TX_APT_SCUPA_CM_COMP_NUM          ( 26 )                      /* SC-UPAҵAPTCM */

#define UCOM_NV_W_TX_APT_DPA_CM_COMP_NUM            ( 15 )                     /* DPAҵAPTCM */
#define UCOM_NV_W_TX_PA_VBIAS_NUM           ( 3 )                               /* pa vbias */


#define UCOM_NV_W_TOTAL_BAND_NUM                ( 6 )                           /* band configֵ֧WƵ */
#define UCOM_NV_W_RF_BAND_CONFIG_NUM            ( 10 )                          /* ext band configֵ֧WƵ */
#define UCOM_NV_RFABB_INIT_REG_NUM          ( 60 )                             /* ʼ60 */

/* tuner MIPIӿڳʼĴ */
#define UCOM_NV_TUNER_MIPI_COMM_INIT_REG_NUM    ( 6 )

/* AP+Sensorֳ״̬,Ŀǰ֧5״̬ */
#define UCOM_NV_TUNER_HANDLE_STATUS_NUM         ( 5 )

/* idleʱtunerֵ֧MIPI */
#define UCOM_NV_TUNER_MIPI_IDLE_CMD_MAX_NUM     ( 6 )

/* activeʱw tunerֵ֧MIPI */
#define UCOM_NV_W_TUNER_MIPI_CMD_MAX_NUM        ( 10 )
#define UCOM_NV_W_TUNER_MIPI_DATA_MAX_NUM       ( UCOM_NV_W_TUNER_MIPI_CMD_MAX_NUM )

/* activeʱ,G tunerֵ֧MIPI */
#define UCOM_NV_GSM_TUNER_MIPI_CMD_MAX_NUM      ( 6 )
#define UCOM_NV_GSM_TUNER_MIPI_DATA_MAX_NUM     ( UCOM_NV_GSM_TUNER_MIPI_CMD_MAX_NUM )

#define UCOM_G_RX_GAIN0_DCR_CHAN_NUM            ( 16 )                          /*DCR channel NUM */
/* DCXOʽϵĸ */
#define UCOM_DCXO_POLY_COEFF_NUM            ( 4 )

#define UCOM_NV_XO_TEMP_COMP_NUM            ( 32 )
#define UCOM_NV_BATT_TEMP_SENSOR_NUM        ( 8 )
/*  144¶-Ƶ:ʱ FIFOԭ */
#define UCOM_DCXO_TEMP_AFC_MAX_NUM          ( 144 )
#define UCOM_NV_PA_TEMP_SENSOR_NUM          ( 32 )

/* AFC CFIXȡ */
#define UCOM_NV_CFIX_CONVERT_AFC_NUM        ( 5 )


#define UCOM_NV_GSM_LINEAR_PA_GAIN_NUM                ( 4 )                       /* GSM PA */

#define UCOM_NV_GSM_LINEAR_PA_SWITCH_THRESHOLD_NUM    ( UCOM_NV_GSM_LINEAR_PA_GAIN_NUM - 1 )  /* GSM PA */

#define UCOM_NV_DCXO_SEARCH_AFC_OFFSET_SAMPLE_NUM       ( 5 )                   /* AFCƫü */

/*Begin DTS2013111200262 by luogen 00177041*/
#define UCOM_NV_DDR_TEMP_COMP_NUM            ( 32 )
#define UCOM_NV_WIFI_PA_TEMP_COMP_NUM            ( 32 )
/*End DTS2013111200262 by luogen 00177041*/

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/


/*****************************************************************************
 ö    :UCOM_NV_DC_SC_MODE_ENUM_UINT16
 Э  :
 ASN.1 :
 ö˵  :زģʽ
*****************************************************************************/
enum UCOM_NV_DC_SC_MODE_ENUM
{
    UCOM_NV_SC_MODE                     = 0,                                    /* زģʽ */
    UCOM_NV_DC_MODE                     = 1,                                    /* ˫زģʽ */
    UCOM_NV_DC_SC_MODE_BUTT             = 2
};
typedef PHY_UINT16 UCOM_NV_DC_SC_MODE_ENUM_UINT16;

/*****************************************************************************
 ö    : UCOM_NV_CHAN_CONNECT_ENUM_UINT16
 Э  :
 ASN.1 :
 ö˵  : A/Bͨıʶ
*****************************************************************************/
enum UCOM_NV_CHAN_CONNECT_ENUM
{
    UCOM_NV_CHAN_CONNECT_A                  = 0,                                /* Aͨ */
    UCOM_NV_CHAN_CONNECT_B                  = 1,                                   /* Bͨ */
    UCOM_NV_CHAN_CONNECT_BUTT               = 2
};
typedef PHY_UINT16 UCOM_NV_CHAN_CONNECT_ENUM_UINT16;


/*****************************************************************************
 ö    : UCOM_NV_WCDMA_SPUR_TYPE_ENUM_UINT16
 Э  :
 ASN.1 :
 ö˵  : г
*****************************************************************************/
enum UCOM_NV_WCDMA_SPUR_TYPE_ENUM
{
    UCOM_NV_WCDMA_SPUR_1920                  = 0,                               /* 19.20M */
    UCOM_NV_WCDMA_SPUR_1536                  = 1,                                  /* 15.36M */
    UCOM_NV_WCDMA_SPUR_6144                  = 2,                                  /* 61.44M */
    UCOM_NV_WCDMA_SPUR_BUTT                  = 3
};
typedef PHY_UINT16 UCOM_NV_WCDMA_SPUR_TYPE_ENUM_UINT16;

/*****************************************************************************
 ö    :UCOM_NV_XO_TYPE_UINT16
 Э  :
 ASN.1 :
 ö˵  :,0ʾ DCXO,1ʾ TCXO
*****************************************************************************/
enum UCOM_NV_XO_TYPE_ENUM
{
    UCOM_NV_XO_TYPE_DCXO                = 0,                                    /* ʾʹ DCXO */                                                           /* нDPCH */
    UCOM_NV_XO_TYPE_TCXO                = 1,                                    /* ʾʹ TCXO */                                                             /* дRACH */
    UCOM_NV_XO_TYPE_BUTT                = 2
};
typedef PHY_UINT16 UCOM_NV_XO_TYPE_ENUM_UINT16;

/*****************************************************************************
 ö    :UCOM_NV_DCXO_TEMP_CIRCUIT_ENUM_UINT16
 Э  :
 ASN.1 :
 ö˵  :DCXO¶Ȳɼ·һڲɼº͸£һڲɼºͲֳ
*****************************************************************************/
enum UCOM_NV_DCXO_TEMP_CIRCUIT_ENUM
{
    UCOM_NV_DCXO_TEMP_CIRCUIT_HIGH              = 0,                            /* µ·  */
    UCOM_NV_DCXO_TEMP_CIRCUIT_NORMAL            = 0,                            /* º͸µ·һ */                                                           /* нDPCH */
    UCOM_NV_DCXO_TEMP_CIRCUIT_LOW               = 1,                            /* µ· */                                                             /* дRACH */
    UCOM_NV_DCXO_TEMP_CIRCUIT_BUTT              = 2
};
typedef PHY_UINT16 UCOM_NV_DCXO_TEMP_CIRCUIT_ENUM_UINT16;
/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
*                                                                            *
*                           Ϣṹ                                 *
*                                                                            *
******************************************************************************/
/* xiongjiangjiang Begine */
/*****************************************************************************
 ṹ    : UCOM_NV_NV_ITEM_XO_DEFINE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    UCOM_NV_XO_TYPE_ENUM_UINT16             enXoDefine;
}UCOM_NV_NV_ITEM_XO_DEFINE_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_RFIC_TEMP_COMP_WEIGH_STRU
 Э  :
 ASN.1 :
 ṹ˵  : rf reg12 ¶NV_RFIC_TEMP_COMP_WEIGTH
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwNvRficTempCompWeigh;
}UCOM_NV_RFIC_TEMP_COMP_WEIGH_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_XO_INIT_FREQUENCY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :2.2ʾͨĳʼƵƫ¶
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwInitFrequency;                       /* ͨĳʼƵƫ */
    PHY_INT16                           shwInitTemperature;                     /* ͨĳʼ¶ */
}UCOM_NV_XO_INIT_FREQUENCY_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DYNAMIC_FREQUENCY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :2.2ʾƽ̨ϴAFCֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwDymamicFrequency;                    /* ƽ̨ϴAFCֵ */
    PHY_INT16                           shwDymamicTemperature;                  /* ƽ̨ϴAFC¶ */
}UCOM_NV_DYNAMIC_FREQUENCY_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_TX_TEMP_DEFINE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.3 3G2Gз书¶ȱ仯Χ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTxTempDefine[UCOM_NV_W_TX_PA_TEMP_NUM];
}UCOM_NV_WG_TX_TEMP_DEFINE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_TEMP_SENCOR_STRU
 Э  :
 ASN.1 :
 ṹ˵  :for UCOM_NV_PA_TEMP_SENSOR_STRU
                UCOM_NV_XO_TEMP_SENSOR_STRU
                UCOM_NV_USIM_BATT_TEMP_SENSOR_STRU
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwPaTempTemp;                          /* ¶:0.1 */
    PHY_UINT16                          uhwPaTempVol;                           /* ѹ */
}UCOM_NV_TEMP_SENCOR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_PA_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 PA¶ȼ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astPaTempSensor[UCOM_NV_PA_TEMP_SENSOR_NUM];
}UCOM_NV_PA_TEMP_SENSOR_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_XO_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 ͨĳ()µѹ-¶ȱ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astXoTempSensor[UCOM_NV_XO_TEMP_COMP_NUM];
}UCOM_NV_XO_TEMP_SENSOR_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_XO_LOW_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 ͨĵµѹ-¶ȱ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astXoLowTempSensor[UCOM_NV_XO_TEMP_COMP_NUM];
}UCOM_NV_XO_LOW_TEMP_SENSOR_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_BATT_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 ص¶ȼ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astBattTempSensor[UCOM_NV_BATT_TEMP_SENSOR_NUM];
}UCOM_NV_BATT_TEMP_SENSOR_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_PRODUCT_TYPE_FOR_LOG_DIRECTORY
 Э  :
 ASN.1 :
 ṹ˵  : ƷNVͬƷLog·һ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwProductType;                         /* Ʒ */
    PHY_UINT16                          uhwReserve;                             /*  */
}UCOM_NV_PRODUCT_TYPE_FOR_LOG_DIRECTORY;
/*Begin DTS2013111200262 by luogen 00177041 2013-11-11*/
/*****************************************************************************
 ṹ    : UCOM_NV_DDR_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 DDR¶ȼ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astDdrTempSensor[UCOM_NV_DDR_TEMP_COMP_NUM];
}UCOM_NV_DDR_TEMP_SENSOR_TABLE_STRU;
/*****************************************************************************
 ṹ    : UCOM_NV_WIFI_PA_TEMP_SENSOR_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.1 WiFi PA¶ȼ
*****************************************************************************/
typedef struct
{
    UCOM_NV_TEMP_SENCOR_STRU            astDdrTempSensor[UCOM_NV_WIFI_PA_TEMP_COMP_NUM];
}UCOM_NV_WIFI_PA_TEMP_SENSOR_TABLE_STRU;
/*End DTS2013111200262 by luogen 00177041 2013-11-11*/
/*****************************************************************************
 ṹ    : UCOM_NV_XO_LOW_TEMP_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : XO¼NV,Կ·л
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwLowTempSupport;                      /* ӲǷֵ֧¼⣬0-֧֣1-֧ */
    PHY_INT16                           shwSwitchDeltaTemp;                     /* µ·ԭе·лΪ(У׼¶+ֵ)
                                                                                   л¶ʱʹõµ·ĬΪ0
                                                                                   лΪУ׼¶(µ·)λ0.1 */
    PHY_UINT16                          uhwTempDeltaThreshold;                  /* ·У׼ֵƫޣĬΪ10λ0.1 */
    PHY_UINT16                          uhwReserve;                             /*  */
}UCOM_NV_XO_LOW_TEMP_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_XO_INIT_LOW_TEMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : У׼ʱµ·ļ¶ȣݻָ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwInitLowTemp;                         /* У׼ʱµ·ļ¶ȣλ0.1 */
    PHY_UINT16                          uhwReserve;                             /*  */
}UCOM_NV_XO_INIT_LOW_TEMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_AFC_CONVERT_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AFC/޶ӦCfix-AfcCfix-AfcϵAFC,CFIX
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwAfcUpperThr;                                         /* AFC,AFCڴֵʱѳ۳cfix,Ĭֵ14384 */
    PHY_INT16                           shwAfcLowerThr;                                         /* AFC,AFCСڴֵʱСڲ۳cfix,Ĭֵ2000 */
    PHY_INT16                           ashwCfixTable[UCOM_NV_CFIX_CONVERT_AFC_NUM];           /* Cfix-AfcӦcfix */
    PHY_INT16                           ashwCfix2AfcUpperTable[UCOM_NV_CFIX_CONVERT_AFC_NUM];  /* AFC޶ӦCfix-Afc,ʵȡ */
    PHY_INT16                           ashwCfix2AfcLowerTable[UCOM_NV_CFIX_CONVERT_AFC_NUM];  /* AFC޶ӦCfix-Afc,ʵȡ */
}UCOM_NV_DCXO_AFC_CONVERT_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_IQ_REV_CONTROL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IQӷ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRxAIRevSel;                          /* Rx A I·ӷ */
    PHY_UINT16                          uhwRxAQRevSel;                          /* Rx A Q·ӷ */
    PHY_UINT16                          uhwRxBIRevSel;                          /* Rx B I·ӷ */
    PHY_UINT16                          uhwRxBQRevSel;                          /* Rx B Q·ӷ */
    PHY_UINT16                          uhwTxIRevSel;                           /* Tx I·ӷ */
    PHY_UINT16                          uhwTxQRevSel;                           /* Tx Q·ӷ */
}UCOM_NV_WG_IQ_REV_CONTROL_STRU;


/*****************************************************************************
 ṹ    : UCOM_DCXO_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DCXOʽ 4ϵ¶ȵСֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          auwMantissaDefault[UCOM_DCXO_POLY_COEFF_NUM];  /* δa0,a1,a2,a3β */
    PHY_UINT16                          auhwExponentDefault[UCOM_DCXO_POLY_COEFF_NUM]; /* δa0,a1,a2,a3ָ */
    /* ر˵:shwTmax/shwTminʵǺ,ϵһ𲻺.Ϊ,DSPڲ
       ֻʹpstAfcContext->stDcxoPara.shwSampleTempMax/shwSampleTempMin */
    PHY_INT16                           shwTmax;                                /* ¶ֵ */
    PHY_INT16                           shwTmin;                                /* ¶Сֵ */
}UCOM_NV_DCXO_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_DCXO_AFC_VS_TEMP_VALUE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : һDCXO¶-Ƶ(ʵΪAFCֵ)
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTemp;                                /* ¶ */
    PHY_UINT16                          uhwAfc;                                 /* ¶¶ӦAFCֵ */
}UCOM_NV_DCXO_AFC_VS_TEMP_VALUE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_TEMP_READ_PERIOD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DCXOȡ¶ȵ,IDLE̬DCH̬
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwIdlePeriod;                          /* IDLE̬¶ȡ */
    PHY_UINT16                          uhwDchPeriod;                           /* IDLE̬¶ȡ */
}UCOM_NV_DCXO_TEMP_READ_PERIOD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_TEMP_COMP_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DCXOʽϵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          auwLowMantissa[UCOM_DCXO_POLY_COEFF_NUM];
    PHY_UINT16                          auhwLowExponent[UCOM_DCXO_POLY_COEFF_NUM];
    PHY_UINT32                          auwHighMantissa[UCOM_DCXO_POLY_COEFF_NUM];
    PHY_UINT16                          auhwHighExponent[UCOM_DCXO_POLY_COEFF_NUM];
}UCOM_NV_DCXO_TEMP_COMP_THRESHOLD_STRU;


/*****************************************************************************
 ṹ    : UCOM_DCXO_FREQ_VS_TEMP_ARRAY_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DCXO¶-Ƶ(ʵΪAFCֵ)
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidNum;                             /* Ч */
    PHY_INT16                           shwTmax;                                /* ¶ֵ */
    PHY_INT16                           shwTmin;                                /* ¶Сֵ */
    UCOM_NV_DCXO_AFC_VS_TEMP_VALUE_STRU astAfcTempValue[UCOM_DCXO_TEMP_AFC_MAX_NUM]; /*  */
}UCOM_NV_DCXO_FREQ_VS_TEMP_ARRAY_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_SAMPLE_UPDATE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DCXO²
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwWcdmaPeriod;                          /* W DCXOдNVڣλ֡,Ĭ30000 */
    PHY_UINT32                          uwGsmPeriod;                            /* G DCXOдNVڣλ֡,Ĭ65000 */
    PHY_UINT16                          uhwUpdateLowThr;                        /* ,Ĭ234 AFC */
    PHY_UINT16                          uhwUpdateHighThr;                       /* ,Ĭ975 AFC */
}UCOM_NV_DCXO_SAMPLE_UPDATE_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_SAR_BACKOFF_TEST_MODE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SARģʽ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwSarBackoffTestModeFlg;               /* SARģʽ */
}UCOM_NV_SAR_BACKOFF_TEST_MODE_STRU;


/*****************************************************************************
 ö    : UCOM_NV_WG_DCOFFSET_THRESHOLD_STRU
 Э  :
 ö˵  : DC offsetֱУ׼
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwDciLimit;                            /* I·ֱ,λmV */
    PHY_INT16                           shwDcqLimit;                            /* Q·ֱ,λmV */
}UCOM_NV_WG_DCOFFSET_THRESHOLD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_CTRIM_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SARģʽ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwDcxoCTrim;                           /*Range:[-1,63]*/
}UCOM_NV_DCXO_CTRIM_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_DCXO_SEARCH_AFC_OFFSET_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ashwSearchAfc2ashwSearchAfcDelta2ɵڶУ׼
             ashwSearchAfc3ashwSearchAfcDelta3ɵУ׼
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwSearchAfc2[UCOM_NV_DCXO_SEARCH_AFC_OFFSET_SAMPLE_NUM];      /* ڶAFCֵ */
    PHY_INT16                           ashwSearchAfcDelta2[UCOM_NV_DCXO_SEARCH_AFC_OFFSET_SAMPLE_NUM]; /* ڶAFCƫֵ */
    PHY_INT16                           ashwSearchAfc3[UCOM_NV_DCXO_SEARCH_AFC_OFFSET_SAMPLE_NUM];      /* AFCֵ */
    PHY_INT16                           ashwSearchAfcDelta3[UCOM_NV_DCXO_SEARCH_AFC_OFFSET_SAMPLE_NUM]; /* AFCƫֵ */
}UCOM_NV_DCXO_SEARCH_AFC_OFFSET_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_BUCK_VOLT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : BUCKѹֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwBuck1Volt;                           /* buck1ѹֵ,λmV */
    PHY_UINT16                          uhwBuck2Volt;                           /* buck2ѹֵ,λmV */
}UCOM_NV_BUCK_VOLT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_RFIC_SSI_WAIT_TIME_STRU
 Э  :
 ASN.1 :
 ṹ˵  : BUCKѹֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRficSsiWaitTime;
}UCOM_NV_RFIC_SSI_WAIT_TIME_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwNumber;
    PHY_INT16                           ashwGain[UCOM_NV_GSM_LINEAR_PA_GAIN_NUM];
}UCOM_NV_GSM_LINEAR_PA_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_LINEAR_PA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwNumber;
    PHY_INT16                           ashwGain[UCOM_NV_GSM_LINEAR_PA_GAIN_NUM];
}UCOM_NV_EDGE_LINEAR_PA_GAIN_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_PCL_PA_GAIN_INDEX_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
typedef struct
{
    PHY_UINT16                           auhwPaGainIndex[UCOM_NV_G_PCL_NUM];     /* 32ʵȼӦPA */
}UCOM_NV_GSM_TX_PCL_PA_GAIN_INDEX_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_PCL_PA_GAIN_INDEX_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
typedef struct
{
    PHY_UINT16                           auhwPaGainIndex[UCOM_NV_G_PCL_NUM];     /* 32ʵȼӦPA */
}UCOM_NV_EDGE_TX_PCL_PA_GAIN_INDEX_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_TX_REF_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidChanNum;                                /* ЧƵ */
    PHY_UINT16                          auhwTxChan[UCOM_NV_G_TX_REF_CHAN_NUM_MAX];      /* οƵб */
}UCOM_NV_TX_CAL_CHAN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RAMP_INDEX_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwRampIndex[UCOM_NV_G_PCL_NUM];
}UCOM_NV_GSM_RAMP_INDEX_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_RAMP_INDEX_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwRampIndex[UCOM_NV_G_PCL_NUM];
}UCOM_NV_EDGE_RAMP_INDEX_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RAMP_COEFF_STRU
 Э  :
 ṹ˵  : GSM/EDGE±NV
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwRampUp[UCOM_NV_G_RAMP_COEF_NUM];    /* ± */
    PHY_UINT16                          auhwRampDown[UCOM_NV_G_RAMP_COEF_NUM];  /* ± */
}UCOM_NV_GSM_RAMP_COEFF_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RAMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSMϵṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_GSM_RAMP_COEFF_STRU         astRampCoeff[UCOM_NV_G_RAMP_PWR_LEVEL_NUM];     /* [10dBm,20dBmΪ3] */
}UCOM_NV_GSM_RAMP_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_RAMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : EDGEϵṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_GSM_RAMP_COEFF_STRU         astRampCoeff[UCOM_NV_G_RAMP_PWR_LEVEL_NUM];     /* [10dBm,20dBmΪ3] */
}UCOM_NV_EDGE_RAMP_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    /* עѹͷ书ʵĶӦϵ */
    PHY_UINT16                          auhwTxPower[UCOM_NV_G_TX_PWR_CONT_NUM];         /* ҪУķ书 */
    PHY_UINT16                          auhwContVolt[UCOM_NV_G_TX_PWR_CONT_NUM];        /* ҪУķ书ʶӦĿƵѹ */
}UCOM_NV_GSM_PA_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

/* RF8PSKͬʹõѹֿ */
typedef struct
{
    PHY_UINT16                          auhwContVolt[UCOM_NV_G_TX_8PSK_PWR_CONT_NUM];   /* ҪУķ书ʶӦĿƵѹ */
    PHY_UINT16                          auhwTxPower[UCOM_NV_G_TX_8PSK_PWR_CONT_NUM];    /* ҪУķ书 */
}UCOM_NV_EDGE_PA_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwGsmMaxTxVolt;
    PHY_UINT16                          uhwGsmMaxTxPower;
}UCOM_NV_GSM_MAX_TX_VOLT_POWER;


/*****************************************************************************
 ṹ    : UCOM_NV_G_TIMING_CTRL_CTRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTimingCtrl;
}UCOM_NV_G_TIMING_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_RAMP_POINTS_CTRU
 Э  :
 ASN.1 :
 ṹ˵  : µṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRampPoints;                          /* µ */
}UCOM_NV_G_RAMP_POINTS_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_PREMOD_SYMBOL_CTRU
 Э  :
 ASN.1 :
 ṹ˵  : ԤƷŽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwPreModSymbol;                        /* ԤƷ */
}UCOM_NV_G_PREMOD_SYMBOL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_TX_BURST_OFFSET_CTRU
 Э  :
 ASN.1 :
 ṹ˵  : burset offsetṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTxBurstOffset;                       /* GSM burst offset */
}UCOM_NV_G_TX_BURST_OFFSET_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_TX_PA_LENGTH_CTRU
 Э  :
 ASN.1 :
 ṹ˵  : PAѹĳȽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTxPaLength;                          /* PAѹĳȣλΪQb */
}UCOM_NV_G_TX_PA_LENGTH_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_PA_PRECHG_VOLT_CTRU
 Э  :
 ASN.1 :
 ṹ˵  : PAѹĳȽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwPaPrechgVolt;                        /*Range:[0,1023]*//* У׼Ԥѹ */
}UCOM_NV_G_PA_PRECHG_VOLT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_G_PA_FACTORY_PRECHARGE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwInit;
    PHY_INT16                           shwDelta;
}UCOM_NV_G_PA_FACTORY_PRECHARGE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_RX_IP2_STRU
 Э  :
 ASN.1 :
 ṹ˵  :IQֱͨΪNVͨõIQͨƫ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwIReg;                                /* I·Ĵȡֵƴӷʽ = SN[0]+DATA[6:0] */
    PHY_INT16                           shwQReg;                                /* Q·Ĵȡֵƴӷʽ = SN[0]+DATA[6:0] */
}UCOM_NV_RX_IP2_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_IP2_CAL_STRU
 Э  :
 ASN.1 :
 ṹ˵  :5.2 ÿBANDڸеƵ£IQ·ĵ·
*****************************************************************************/
typedef struct
{
    UCOM_NV_RX_IP2_STRU                 astRxIp2Cal[3];
}UCOM_NV_GSM_RX_IP2_CAL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_AGC_FREQ_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :5.4 AGCͳһƵƵ㲻ͬ仯
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxAgcFreqComp[UCOM_NV_G_RX_CHAN_COMP_NUM];  /*Rang:[-64,64]*//* һƵ16Ƶ */
}UCOM_NV_GSM_RX_AGC_FREQ_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_APC_RF_ATTEN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.1 RFоƬԻźŵ˥RFоƬĴ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwEdgeTxApcRfAtten[UCOM_NV_G_TX_ATTEN_NUM];
}UCOM_NV_EDGE_TX_APC_RF_ATTEN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_APC_DBB_ATTEN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.1 DBBоƬԻźŵĲ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwEdgeTxApcDbbAtten[UCOM_NV_G_TX_ATTEN_NUM];
}UCOM_NV_EDGE_TX_APC_DBB_ATTEN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_VBIAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.3 ڲͬʵȼ£ΪPAѹ(ƫõѹ)½͵ѹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwPaVbias[UCOM_NV_G_PCL_NUM];     /* 32DA任ǰֵ */
}UCOM_NV_GSM_PA_VBIAS_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_PA_VBIAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.3 ڲͬʵȼ£ΪPAѹ(ƫõѹ)½͵ѹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwPaVbias[UCOM_NV_G_PCL_NUM];     /* 32DA任ǰֵ */
}UCOM_NV_EDGE_PA_VBIAS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_VBIAS_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.3 ڲͬʵȼ£ΪPAѹ(ƫõѹ)½PA仯ĴС
*****************************************************************************/
typedef struct
{
    PHY_INT16                           auhwPaVccVbiasComp[UCOM_NV_G_PCL_NUM];  /* 32ʲֵ */
}UCOM_NV_GSM_PA_VCC_VBIAS_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_PA_VBIAS_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :6.3 ڲͬʵȼ£ΪPAѹ(ƫõѹ)½PA仯ĴС
*****************************************************************************/
typedef struct
{
    PHY_INT16                           auhwPaVccVbiasComp[UCOM_NV_G_PCL_NUM];  /* 32ʲֵ */
}UCOM_NV_EDGE_PA_VCC_VBIAS_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GMSK(PA) TX¶ȱ仯Ĳ
*****************************************************************************/
typedef struct
{
    /* ¶ȷΧȡֵȡUCOM_NV_WG_TX_TEMP_DEFINE_STRU */
    PHY_INT16                           ashwGsmTxTempComp[UCOM_NV_G_TEMP_LEVEL_NUM];   /*Range:[-100,100]*/
}UCOM_NV_GSM_TX_TEMP_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.7 8PSK TX¶ȱ仯Ĳ
*****************************************************************************/
typedef struct
{
    /* ¶ȷΧȡֵȡUCOM_NV_WG_TX_TEMP_DEFINE_STRU */
    PHY_INT16                           ashwEdgeTxTempComp[UCOM_NV_G_TEMP_LEVEL_NUM];   /*Range:[-100,100]*/
}UCOM_NV_EDGE_TX_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_CAL_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ҪУ׼GSMƵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidCalChanNum;                     /*Range:[0,16]*/
    PHY_UINT16                          auhwGsmRxCalChan[UCOM_NV_G_RX_CHAN_COMP_NUM];
}UCOM_NV_GSM_RX_CAL_CHAN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_AGC_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :5.3 AGCÿ״ֳֵ̬ܹ8
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxAgcGain[UCOM_NV_G_CHAN_GAIN_MAX_NUM];
}UCOM_NV_GSM_RX_AGC_GAIN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_ EDGE_TX_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾÿRF GainӦ¶Ȳֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTempComp10th[UCOM_NV_EDGE_TX_TEMP_COMP_NUM];      /* ʾĳһRF Gain16¶µ¶ȲֵλΪ0.1dB */
}UCOM_NV_EDGE_TEMP_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_RF_GAIN_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾ15RF GainӦ¶Ȳֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCount;
    UCOM_NV_EDGE_TEMP_COMP_STRU         astTempComp[UCOM_NV_EDGE_TX_RF_GAIN_CTRL_NUM];      /* ʾ15RF Gain16¶µ¶Ȳֵ */
}UCOM_NV_EDGE_RF_GAIN_TEMP_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_VCC_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ڲͬʵȼ£GSMӦVCCѹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwGsmPaVcc[UCOM_NV_G_PCL_NUM];        /* 32DA任ǰֵ */
}UCOM_NV_GSM_PA_VCC_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_PA_VCC_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ڲͬʵȼ£EDGEӦVCCѹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwEdgePaVcc[UCOM_NV_G_PCL_NUM];       /* 32DA任ǰֵ */
}UCOM_NV_EDGE_PA_VCC_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_CLOSE_PA_VCC_CONTROL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : close vcc control
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwClosePaVccMipiCmdFrame;              /* رPaVccmipiָ֡ */
    PHY_UINT16                          uhwClosePaVccMipiDataFrame;             /* رPaVccMipi֡ */
}UCOM_NV_GSM_CLOSE_PA_VCC_CONTROL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_DEV_AVOID_GSM_SLOT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GPSGSMʱ϶
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwPowerThreshold;                      /* ޣڸʱģʽλΪ0.1dbm */
    PHY_UINT16                          uhwBandMask;                            /* ڱõƵ룬BIT0/1/2/3Ӧ850/900/1800/1900M */
    PHY_UINT32                          uwIoMask;                               /* ڱõĹܽ */
}UCOM_NV_DEV_AVOID_GSM_SLOT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_REDUCE_CURRENT_MIPI_STRU
 Э  :
 ASN.1 :
 ṹ˵  : (MIPI)
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwReduceCurrentEn;                     /* ʹ */
    PHY_UINT16                          uhwCurrentLimitAddr;                    /* ӦPMUַ */
    PHY_UINT16                          uhwDefaultCurrentValue;                 /* ȱʡʱĵֵ(һʱ϶) */
    PHY_UINT16                          uhwLimitCurrentValue;                   /* ʱֵ(ǵһʱ϶) */
}UCOM_NV_GSM_REDUCE_CURRENT_MIPI_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_REDUCE_CURRENT_GPIO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : (GPIO)
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwReduceCurrentEn;                     /* ʹ */
    PHY_UINT32                          uwIoMask;                               /* ʹõĹܽ */
}UCOM_NV_GSM_REDUCE_CURRENT_GPIO_STRU;



/*****************************************************************************
 ṹ    : UCOM_GSM_TX_APC_CAL_TEMP
 Э  :
 ASN.1 :
 ṹ˵  : GsmAPCУ׼¶
*****************************************************************************/
typedef struct
{
    PHY_INT16                               shwGsmTxApcCalTemp;                 /*Range:[-300,1350]*/
}UCOM_GSM_TX_APC_CAL_TEMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_EDGE_TX_APC_CAL_TEMP
 Э  :
 ASN.1 :
 ṹ˵  : EdgeAPCУ׼¶
*****************************************************************************/
typedef struct
{
    PHY_INT16                               shwEdgeTxApcCalTemp;                /*Range:[-300,1350]*/
}UCOM_EDGE_TX_APC_CAL_TEMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_START_BYPASS_THRESHOLD
 Э  :
 ASN.1 :
 ṹ˵  : GģBypass
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwGsmStartBypassThreshold;
}UCOM_NV_GSM_START_BYPASS_THRESHOLD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_POWER
 Э  :
 ASN.1 :
 ṹ˵  : ҪУķ书
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmTxPower[UCOM_NV_G_TX_PWR_CONT_NUM];  /*Range:[-400,400]*//* ҪУķ书 */
}UCOM_NV_GSM_TX_POWER_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_POWER
 Э  :
 ASN.1 :
 ṹ˵  : ҪУķ书ʶӦĿƵѹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwGsmContVolt[UCOM_NV_G_TX_PWR_CONT_NUM]; /*Range:[0,1023]*//* ҪУķ书ʶӦĿƵѹ */
}UCOM_NV_GSM_CONT_VOLT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_POWER
 Э  :
 ASN.1 :
 ṹ˵  : ͬƵķ书ʵĲֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmTxFreqComp[UCOM_NV_G_TX_CHAN_COMP_NUM];  /*Range:[-100,100]*//* [Ƶ][ͬƵķ书ʵĲֵ] λ0.1dBm*/
}UCOM_NV_GSM_TX_FREQ_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_FREQ_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : EdgeУ׼书ʵĲֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmTxFreqComp[UCOM_NV_G_TX_CHAN_COMP_NUM];  /*Range:[-100,100]*//* [Ƶ][ͬƵķ书ʵĲֵ] λ0.1dBm*/
}UCOM_NV_EDGE_TX_FREQ_COMP_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_TX_APC_DBB_ATTEN
 Э  :
 ASN.1 :
 ṹ˵  : gsm linear pa apc dbb atten
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmLinearPaTxApcDbbAtten[UCOM_NV_G_TX_ATTEN_NUM];   /*Range:[-40,10]*//* gsm linear pa apc dbb atten */
}UCOM_NV_GSM_LINEAR_PA_TX_APC_DBB_ATTEN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_RF_ATTEN
 Э  :
 ASN.1 :
 ṹ˵  : RF˥
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwGsmTxRfAtten;   /* RF˥ */
}UCOM_NV_GSM_TX_RF_ATTEN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_POWER_LEVEL
 Э  :
 ASN.1 :
 ṹ˵  : 4ƵιʵȼdBmӳ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmTxPowerLevel[UCOM_NV_G_PCL_NUM]; /* 4ƵιʵȼdBmӳ */
}UCOM_NV_GSM_TX_POWER_LEVEL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_MAX_POWER_REDUCTION
 Э  :
 ASN.1 :
 ṹ˵  : GSM书ʻ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwGsmMaxPowerReduction[UCOM_NV_G_TX_SLOT_MAX_NUM];
}UCOM_NV_GSM_MAX_POWER_REDUCTION_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_WIRELESS_MAX_POWER
 Э  :
 ASN.1 :
 ṹ˵  : GSM书
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmWirelessMaxPower[UCOM_NV_G_TX_SLOT_MAX_NUM]; /*  *//* 4ƵGMSKտڷʱĹ˥ */
}UCOM_NV_GSM_WIRELESS_MAX_POWER_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_SAR_BACK_OFF_POWER
 Э  :
 ASN.1 :
 ṹ˵  : GSM¸ʱ϶SARֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwGsmSarBackoffPower[UCOM_NV_SAR_BACKOF_NUM];
}UCOM_NV_GSM_SAR_BACK_OFF_POWER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_PA_GAIN
 Э  :
 ASN.1 :
 ṹ˵  : ͳPA
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwEdgeTxPaGain;                        /* ͳPA */
}UCOM_NV_EDGE_TX_PA_GAIN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_APC_RF_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GMSK(PA)APC RF
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwGsmLinearPaApcRfCtrl[UCOM_NV_G_TX_ATTEN_NUM];    /* apc rf ctrl */
}UCOM_NV_GSM_LINEAR_PA_APC_RF_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_APC_RF_CTRL
 Э  :
 ASN.1 :
 ṹ˵  : EDGEAPC RF
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwEdgeTxApcRfCtrl[UCOM_NV_G_TX_ATTEN_NUM];    /* apc rf ctrl */
}UCOM_NV_EDGE_TX_APC_RF_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_RF_GAIN_STATE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GMSK(PA)APC DBB˥
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwGsmLinearPaRfGainStateIndex[UCOM_NV_G_TX_ATTEN_NUM]; /* rf gain  */
}UCOM_NV_GSM_LINEAR_PA_RF_GAIN_STATE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_NONLINEAR_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GMSK(PA)APC DBB˥
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwComp[UCOM_NV_G_PCL_NUM];
}UCOM_NV_GSM_LINEAR_PA_NONLINEAR_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_LINEAR_PA_NONLINEAR_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : EDGE(PA)APC DBB˥
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwComp[UCOM_NV_G_PCL_NUM];
}UCOM_NV_EDGE_LINEAR_PA_NONLINEAR_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_TX_RF_GAIN_STATE_INDEX
 Э  :
 ASN.1 :
 ṹ˵  : EDGEAPC DBB˥
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwEdgeTxRfGainStateIndex[UCOM_NV_G_TX_ATTEN_NUM]; /* rf gain  */
}UCOM_NV_EDGE_TX_RF_GAIN_STATE_INDEX_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_RSSI_ARITHMETIC_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Gģ̶ͨ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRssiArithmeticPara;
}UCOM_NV_G_RSSI_ARITHMETIC_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_RX_PLL_ADVANCE_TIMING_STRU
 Э  :
 ASN.1 :
 ṹ˵  : rx pllǰʱ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRxPllAdvanceTiming;
}UCOM_NV_G_RX_PLL_ADVANCE_TIMING_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_AFC_FE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwAfcFeDelayFn;                        /* FEӳ֡ */
    PHY_UINT16                          uhwAfcFePowerDis;                       /*  */
    PHY_UINT16                          uhwAfcFeDchFcut0;                       /*  */
    PHY_UINT16                          uhwAfcFeDchFcut1;                       /*  */
}UCOM_NV_GSM_AFC_FE_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_G_ADJ_CHAN_INTERFERE_EN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Ƶʹܱ־
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwAdjChanInterfereEn;                  /* Ƶʹ */
}UCOM_NV_G_ADJ_CHAN_INTERFERE_EN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_LS_DCR_EN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ls dcrʹܱ־
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwLsDcrEn;                             /* ls dcrʹ */
}UCOM_NV_G_LS_DCR_EN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_SRB_STUB_FOR_GCF_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Ƶ⣬GCFʱSRBؽд׮
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwGsmSrbStubForGcfEn;                   /* Ƶ⣬GCFʱSRBؽд׮ */
}UCOM_NV_GSM_SRB_STUB_FOR_GCF_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_LINEAR_PA_ENABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LinearPAʹܱ־
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwLinearPaEnable;                      /* linear Paʹ */
}UCOM_NV_G_LINEAR_PA_ENABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_LINEAR_PA_GAIN_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PA
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          auwWord[UCOM_NV_GSM_LINEAR_PA_GAIN_NUM];
}UCOM_NV_GSM_LINEAR_PA_GAIN_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_G_APT_ENABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LinearPAʹܱ־
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwGsmAptEnable;                        /* 2G APTʹܱ־ */
}UCOM_NV_G_APT_ENABLE_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_GSM_SPUR_ACPR_OPT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM SPUR ACPRŻ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwGsmSpurAcprOpt;                      /* 2G GSM SPUR Ż */
}UCOM_NV_GSM_SPUR_ACPR_OPT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_BY_PASS_GPIO_MASK_STRU
 Э  :
 ASN.1 :
 ṹ˵  : BypassͨʱGPIOڵbitλ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwBypassGpioMask;                       /* BypassͨʱGPIOڵbitλ */
}UCOM_NV_G_BY_PASS_GPIO_MASK_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_G_PA_VCC_MIPI_CMD_FRAME_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PaVccmipiָ֡
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwOpenPaVccMipiCmdFrame;               /* PaVccmipiָ֡ */
}UCOM_NV_G_PA_VCC_MIPI_CMD_FRAME_STRU;



/*****************************************************************************
 ö    : UCOM_NV_GSM_RX_AGC_CTRL_STRU
 Э  :
 ö˵  : 5.3GAGC
*****************************************************************************/
typedef struct
{
    UCOM_NV_RX_AGC_CTRL_UNION           aunRxAgcCtrl[UCOM_NV_G_AGC_LEVEL_MAX_NUM];
}UCOM_NV_GSM_RX_AGC_CTRL_STRU;


/*****************************************************************************
 ö    : UCOM_NV_GSM_AGC_SWITCH_THRESHOLD_STRU
 Э  :
 ö˵  : AGCл
*****************************************************************************/

typedef struct
{
    PHY_INT16                           shwIncDelay;
    PHY_INT16                           ashwDec[UCOM_NV_G_GAIN_THRESHOLD_MAX_NUM];
}UCOM_NV_GSM_AGC_SWITCH_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_ACPR_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTempThreshold;                       /* ¶ޣλΪ */
    PHY_INT16                           shwPowerComp;                           /* ʲλΪ0.1dbm */
}UCOM_NV_GSM_ACPR_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_EDGE_RF_TX_BIAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwBiasHighTemp;                       /* ¶ޣλΪ */
    PHY_INT16                           shwBiasRoomTemp;                           /* ʲλΪ0.1dbm */
}UCOM_NV_EDGE_RF_TX_BIAS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_DCR_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :DCR ҪУ׼GSMƵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uhwValidDcrChanNum;
    PHY_UINT16                          auhwGsmRxCalChan[ UCOM_G_RX_GAIN0_DCR_CHAN_NUM ];
}UCOM_NV_GSM_RX_DCR_CHAN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_DC_OFFSET_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM DC Offsetֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwInitDcoci;                           /* ʼֵ,RFICֵΪ0x80ӦI·DCֵ */
    PHY_INT16                           shwInitDcocq;                           /* ʼֵ,RFICֵΪ0x80ӦQ·DCֵ */
    PHY_INT16                           shwRfDci;                               /* У׼,RFIC I·DCֵ */
    PHY_INT16                           shwRfDcq;                               /* У׼,RFIC Q·DCֵ */
    PHY_INT16                           shwRemainDcoci;                         /* У׼,I·DCֵ */
    PHY_INT16                           shwRemainDcocq;                         /* У׼,Q·DCֵ */
}UCOM_NV_GSM_DC_OFFSET_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_DC_OFFSET_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM DC Offsetֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCount;
    UCOM_NV_GSM_DC_OFFSET_STRU          astGain0DcOffset[ UCOM_G_RX_GAIN0_DCR_CHAN_NUM ];
}UCOM_NV_GSM_RX_DC_OFFSET_GAIN0_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RX_DC_OFFSET_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM DC Offsetֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_GSM_DC_OFFSET_STRU           astGain0[UCOM_G_RX_GAIN0_DCR_CHAN_NUM ];             /* ƵGain0λDCRУ׼ */
    UCOM_NV_GSM_DC_OFFSET_STRU           astOtherGain[UCOM_G_RX_OTHER_GAIN_DCR_CHAN_NUM];  /*ƵλDCRУ׼:UCOM_NV_G_AGC_LEVEL_MAX_NUM -1 */
    UCOM_NV_GSM_DC_OFFSET_STRU           astCrossBandGain0[UCOM_G_RX_GAIN0_DCR_CHAN_NUM];     /* ƵGain0λDCRУ׼ */
    UCOM_NV_GSM_DC_OFFSET_STRU           astCrossBandOtherGain[UCOM_G_RX_OTHER_GAIN_DCR_CHAN_NUM]; /*ƵλDCRУ׼:UCOM_NV_G_AGC_LEVEL_MAX_NUM -1 */
}UCOM_NV_GSM_RX_DC_OFFSET_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RF_GPIO_MASK_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF ƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwGsmAntMask;                           /* ֵʾWBANDGģBANDʶ */
    PHY_UINT32                          uwPaEnMask;                             /* RFڵͨ */
    PHY_UINT32                          uwPaBandMask;                           /* 1Ŀֵ */
    PHY_UINT32                          uwPaModeMask;                           /* 2Ŀֵ */
}UCOM_NV_GSM_RF_GPIO_MASK_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_DSDA_POWER_LIMIT_STRU
 ṹ˵  : ˫书NVṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                      uhwPowerLmtEnable;                          /* ƹʿ */
    PHY_UINT16                      auhwPowerLmtLow[UCOM_NV_G_HIGH_LOW_BUTT];   /* ƹСֵλ0.1dBm */
    PHY_UINT16                      auhwPowerLmtHigh[UCOM_NV_G_HIGH_LOW_BUTT];  /* ƹֵ̬λ0.1dBm */
    PHY_UINT16                      auhwPowerLmtMax[UCOM_NV_G_HIGH_LOW_BUTT];   /* ƹֵλ0.1dBm */
}UCOM_NV_GSM_DSDA_POWER_LIMIT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RAMP_DAC_REV_STRU
 ṹ˵  : ˫书NVṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                      uhwGsmRampDacRev;                           /* gsmdacǷ񽻲,0:,1: */
}UCOM_NV_GSM_RAMP_DAC_REV_STRU;


/*****************************************************************************
 ö    : UCOM_NV_G_ANT_TUNER_CODE_STRU
 Э  :
 ö˵  : ߵгGģĬֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxCode;                          /* ߵгTxĬֵ */
    PHY_UINT16                              uhwReserve1;
    PHY_UINT16                              uhwRxCode;                          /* ߵгRxĬֵ */
    PHY_UINT16                              uhwReserve2;
}UCOM_NV_G_ANT_TUNER_DEFULT_CODE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_ANT_SWITCH_MIPI_USID_CHANGE_STRU
 ṹ˵  : ڵּ߿USIDͬʱ޸߿USIDMIPIָ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwValidNum;					    /* ָЧ */
    PHY_UINT16                              uhwReserve;
    PHY_UINT16                              uhwCmdFrame[9];                     /* mipi */
    PHY_UINT16                              uhwDataFrame[9];                    /* mipi */
} UCOM_NV_WG_ANT_SWITCH_MIPI_USID_CHANGE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_MIPI_WR_FORMAT_STRU
 ṹ˵  : MIPIĿƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwCmdFrame;                        /* mipi */
    PHY_UINT16                              uhwDataFrame;                       /* mipiֵ */
}UCOM_NV_MIPI_WR_FORMAT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_TUNER_MIPI_IDLE_REG_STRU
 Э  :
 ṹ˵  : WG,tunerΪIDLE̬͹̬Ŀ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwValidNum;
    PHY_UINT16                              auhwCmdFrame[UCOM_NV_TUNER_MIPI_IDLE_CMD_MAX_NUM];
    PHY_UINT16                              auhwDataFrame[UCOM_NV_TUNER_MIPI_IDLE_CMD_MAX_NUM];
}UCOM_NV_TUNER_MIPI_IDLE_REG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_TUNER_MIPI_COMM_INIT_REG_STRU
 Э  :
 ṹ˵  : WG,tunerĹʼ֣һЩĴֻҪģʽһ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwValidNum;
    PHY_UINT16                              auhwCmdFrame[UCOM_NV_TUNER_MIPI_COMM_INIT_REG_NUM];
    PHY_UINT16                              auhwDataFrame[UCOM_NV_TUNER_MIPI_COMM_INIT_REG_NUM];
}UCOM_NV_TUNER_MIPI_COMM_INIT_REG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_ANT_TUNER_CTRL_INFO_STRU
 ṹ˵  : ߵгĿƽṹ,MIPItuner,Ǽݶͺţṩ6
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwAntTunerCtrl;                    /* ӲǷ֧ߵг0֧֣1֧ */
    PHY_UINT16                              uhwAntTunerCtrlMode;                /* ߵгͨMIPIƻGPIO,0ʾGPIO,1ʾMIPI */
    UCOM_NV_TUNER_MIPI_COMM_INIT_REG_STRU   stTunerCommReg;                     /* tunerĹʼ֣һЩĴֻҪģʽһ */
    UCOM_NV_TUNER_MIPI_IDLE_REG_STRU        stTunerIdleReg;                     /* tunerΪIDLE̬͹̬Ŀ */
} UCOM_NV_WG_ANT_TUNER_CTRL_INFO_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_DIV_BAND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Ƿַּ֧
*****************************************************************************/
typedef struct
{
    PHY_UINT32          uwWBand;
    PHY_UINT32          uwWbandExtRsv;
}UCOM_NV_W_RF_DIV_BAND_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_RF_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF ƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwBand;                                /* ֵʾWBANDGģBANDʶ */
    PHY_UINT16                          uhwRfChannel;                           /* RFڵͨ */
    PHY_UINT32                          uwAntSwitch;                            /* 1Ŀֵ */
    PHY_UINT32                          uwOtherSwitch;                          /* ߿ֵ */
    PHY_UINT32                          uwPaControlWord;                        /* WģPAʹ */
}UCOM_NV_RF_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_BAND_RF_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  :2.1ʾֵ֧3G2GƵΡ3Gּ֧ÿƵRF
            ͨӦϵ߿лѡDBB3GPAĿ
*****************************************************************************/
typedef struct
{
    UCOM_NV_RF_CONFIG_STRU              stRxMainRfBandCofig;                    /* 2G3GƵ */

    UCOM_NV_RF_CONFIG_STRU              stRxDvtyRfBandCofig;                    /* 2G3GƵ */

    UCOM_NV_RF_CONFIG_STRU              stTxRfBandCofig;                        /* 2G3GƵ */
}UCOM_NV_W_BAND_RF_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_RF_BAND_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  :2.1ʾֵ֧3G2GƵΡ3Gּ֧ÿƵRF
            ͨӦϵ߿лѡDBB3GPAĿ
*****************************************************************************/
typedef struct
{
    UCOM_NV_RF_CONFIG_STRU              astGsmRxRfBandConfig[UCOM_NV_G_BAND_NUMBER];        /* 2G RX Ƶ */

    UCOM_NV_RF_CONFIG_STRU              astGsmTxRfBandConfig[UCOM_NV_G_BAND_NUMBER];        /* 2G TX Ƶ */

    UCOM_NV_W_BAND_RF_CONFIG_STRU       astWcdmaRfBandConfig[UCOM_NV_W_TOTAL_BAND_NUM];     /* 3G Ƶ */
}UCOM_NV_WG_RF_BAND_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_EXT_RF_BAND_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Wչband config
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_BAND_RF_CONFIG_STRU       astWcdmaRfBandConfig[UCOM_NV_W_RF_BAND_CONFIG_NUM];     /* 3G Ƶ */
}UCOM_NV_W_RF_BAND_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_RF_INIT_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFʼ
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwRfAddr;
    PHY_UINT16          uhwRfAddrValue;
}UCOM_NV_RF_INIT_INFO_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_RF_INIT_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFʼ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwRfCount;
    UCOM_NV_RF_INIT_INFO_STRU               stConfigInfo[UCOM_NV_RFABB_INIT_REG_NUM];
}UCOM_NV_RF_INIT_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_ABB_INIT_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFʼ
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwAbbAddr;
    PHY_UINT16          uhwAbbValue;
}UCOM_NV_ABB_INIT_INFO_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_ABB_INIT_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ABBʼ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwABBCount;
    UCOM_NV_ABB_INIT_INFO_STRU              stABBConfigInfo[UCOM_NV_RFABB_INIT_REG_NUM];
}UCOM_NV_ABB_INIT_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_PHY_SW_CFG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ǰ˲ԵNVʱ
*****************************************************************************/
typedef struct
{
    UCOM_NV_PHY_SW_CFG_DRX_SYSCLK_STRU  stDrxTSysclk;
    PHY_UINT32                          uwReservedWords[7];         /* Ժչ */
} UCOM_NV_PHY_SW_CFG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_MMMB_PA_SEL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MIPINV,PAģʽ
*****************************************************************************/
typedef struct
{
    PHY_UINT32          uwWBand;
    PHY_UINT32          uwWbandExtRsv;
    PHY_UINT32          uwGeBand;
}UCOM_NV_WG_MMMB_PA_SEL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_ANT_SWITCH_CONTROL_MODE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MIPINV,߿ģʽ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwWcdmaBandMainAnt;                    /* [0]-BAND1;[1]-BAND2;Դ */
    PHY_UINT32                          uwWcdmaBandDvtyAnt;                    /* [0]-BAND1;[1]-BAND2;Դ */
    PHY_UINT32                          uwWbandExtRsv;                        /* [0]-GSM450;[1]-GSM480;... */
    PHY_UINT32                          uwWbandExtRsv2;                        /* [0]-GSM450;[1]-GSM480;... */
    PHY_UINT32                          uwGsmBandRxAnt;                        /* [0]-GSM450;[1]-GSM480;... */
    PHY_UINT32                          uwGsmBandTxAnt;                        /* [0]-GSM450;[1]-GSM480;... */
}UCOM_NV_ANT_SWITCH_CONTROL_MODE_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_DRX_RESUME_TIME_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WG DRX ˯߻ABBRFȶָʱ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwAbbPwrRsmTime;                        /* ABB AD/DAֲֵԴȶʱ,λus */
    PHY_UINT32                          uwRfPwrRsmTime;                         /* RF ģԴȶʱ,λus */
    PHY_UINT32                          uwAntSwitchPwrRsmTime;                  /* ߿صԴȶʱ,λus */
    PHY_UINT32                          uwAbbWpllRsmTime;                       /* ABB WPLLȶʱ,λus */
    PHY_UINT32                          uwAbbGpllRsmTime;                       /* ABB GPLLȶʱ ,λus*/
    PHY_UINT32                          uwBbpPllRsmTime;                        /* SOC BBP PLLȶʱ,λus */
    PHY_UINT32                          uwPaStarRsmTime;                            /* ֶ */
    PHY_UINT32                          uwSysProtectTime;                       /* ϵͳָʱ */

    PHY_UINT32                          uwTcxoRsmTime;                          /* TCXOȶʱ,λus */
    PHY_UINT32                          uwDcxoRsmTime;                          /* DCXOȶʱ,λus */
    PHY_UINT32                          uwSlowToMcpuRsmTime;                    /* SLOWMCPUϵָʱ,λus */
    PHY_UINT32                          uwWphyRsmTime;                          /* W㻽ѻָʱ,λus */
    PHY_UINT32                          uwGphyRsmTime;                          /* G㻽ѻָʱ,λus */
    PHY_UINT32                          uwTaskSwitchTime;                       /* ϵͳлʱ,λus */
    PHY_UINT32                          uwPaPwrRsmTime;                         /* PAԴȶʱ,λus */
}UCOM_NV_WG_DRX_RESUME_TIME_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_SUPPORT_RATMODE_MASK_STRU
 Э  :
 ASN.1 :
 ṹ˵  : modemֵ֧ģʽϢ
             bit0:Ƿ֧GSM;
             bit1:Ƿ֧WCDMA;
             bit2:Ƿ֧LTE;
             bit3:Ƿ֧TDS;
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwSupportRatMask;                      /* Modemֵ֧modeϢ */
}UCOM_NV_SUPPORT_RATMODE_MASK_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_PA_DEFAULT_VOLT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PAĬϵѹֵ,ѹλ:1mV
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwWcdmaPaVolt;                         /* WCDMA PAĬϵѹ */
    PHY_UINT16                          uhwGsmPaVolt;                           /* GSM PAĬϵѹ */
}UCOM_NV_PA_DEFAULT_VOLT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_ABB_PLL_STABLE_TIME_STRU
 Э  :
 ASN.1 :
 ṹ˵  : PLLȶʱ,ȶʱ䵥λ:1us
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwWcdmaPllStableTime;                  /* WCDMA PLLȶʱ */
    PHY_UINT16                          uhwGsmPllStableTime;                    /* GSM PLLȶʱ */
}UCOM_NV_WG_ABB_PLL_STABLE_TIME_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_WG_MIPI_PA_OFF_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MIPI PA OFF
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidNumber;
    UCOM_NV_MIPI_WR_FORMAT_STRU         stMipiCtrlWord[UCOM_NV_MAX_MMMBPA_CMD_NUMBER];
}UCOM_NV_WG_MIPI_PA_OFF_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_MIPI_PA_INIT_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : MIPI PA ON
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidNumber;
    UCOM_NV_MIPI_WR_FORMAT_STRU         stMipiCtrlWord[UCOM_NV_MAX_MMMBPA_CMD_NUMBER];
}UCOM_NV_WG_MIPI_PA_INIT_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_MIPI_PA_ON_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WCDMA MIPI PA ON
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidNumber;
    PHY_UINT16                          auhwMipiCmd[6];
    PHY_UINT16                          auhwMipiData[6];
}UCOM_NV_W_MIPI_PA_ON_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_G_MIPI_PA_TRIGGER_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : G MIPI PA Trigger
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidNumber;
    PHY_UINT16                          auhwMipiCmd[2];
    PHY_UINT16                          auhwMipiData[2];
}UCOM_NV_G_MIPI_PA_TRIGGER_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GUPHY_FUNC_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : v7r1c50 ͹Ŀƽṹ16λ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                  CsOnlyAntCtrl           :1;                     /* CS ONLYطּ */
    PHY_UINT16                  ScAbbCtrl               :1;                     /* SC ABB */
    PHY_UINT16                  AbbCtrl                 :1;                     /* CS ONLY abb */
    PHY_UINT16                  RficRegCtrl             :1;                     /* CS ONLY RFĴ */
    PHY_UINT16                  RficVolCtrl             :1;                     /* CS ONLY RFѹ */
    PHY_UINT16                  GudspPowerDownCtrl      :1;                     /* GU ģµ */
    PHY_UINT16                  SimpleSlotIntCtrl       :1;                     /* W ʱ϶ */
    PHY_UINT16                  LoopRfLowpowerCtrl      :1;                     /* RF͹Ŀ 1 0Ĭϲ */

    PHY_UINT16                  LoopRxAnt2Ctrl          :1;                     /* rxּ̬ 1 0Ĭϲ */
    PHY_UINT16                  PsR99RxAnt2Ctrl         :1;                     /* ps r99 rxطּ DCM*/
    PHY_UINT16                  PsRxAnt2Ctrl            :1;                     /* ps R99DPA rxطּΪ1൱ڶּ̬شȫر */
    PHY_UINT16                  PsVoltLPCtrl            :1;                     /* PS ѹ͹Դλ, 1 0򿪣Ĭϴ */
    PHY_UINT16                  PsCsAntCtrl             :1;                     /* PS CS¹طּ */
    PHY_UINT16                  reserved                :1;
    PHY_UINT16                  DpaOpenIpc              :1;                     /* dpaҵE5776860Ʒ̬IPCжϿؿƣĬϲ */
    PHY_UINT16                  GphyCsInterferennceCtrl :1;                     /* GSM CSͬƵŵܷ:1-ʾ򿪸ù,ʾر */
}UCOM_NV_GUPHY_FUNC_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_LP_RFIC_FUNC_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : v7r1c50 ͹RFICƽṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_LP_RFIC_REGTHD_STRU         stRegThd;
    UCOM_NV_LP_RFIC_REGOPT_STRU         stRegOpt;
    UCOM_NV_LP_RFIC_REGDEFAULT_STRU     stRegDefault;

    PHY_UINT16                          uhwReserved;
}UCOM_NV_LP_RFIC_FUNC_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WG_TEMPPROTECT_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTempTypeId;                          /* 0-13 */
    PHY_UINT16                          uhwCloseAnt2Flag;                       /* ±Ƿ񿪹طּ */
    PHY_INT16                           shwCloseAnt2TempThresh;                 /* ¹رշּ */
    PHY_INT16                           shwOpenAnt2TempThresh;                  /* ´򿪷ּ */
    PHY_UINT16                          uhwMaxPowLimitFlag;                     /* ±Ƿ书 */
    PHY_INT16                           shwMaxPowLimitAlarmThresh;              /* ±书, */
    PHY_INT16                           shwMaxPowLimitResumeThresh;             /* ±书,ָ */
    PHY_INT16                           shwWMaxPowLimitValue;                   /* ±W书 */
    PHY_INT16                           shwGMaxPowLimitValue;                   /* ±G书 */
}UCOM_NV_WG_TEMPPROTECT_CTRL_STRU;

/* xiongjiangjiang Edn */

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_RX_BIAS_DELTA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF RX DELTA GAIN
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxChanDelay;
}UCOM_NV_W_RF_TX_CHAN_DELAY_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_ANT_PERFORM_TEST_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwAntPerformanceTest;
}UCOM_NV_W_ANT_PERFORM_TEST_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_CQI_ANT2_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwCQICtrlFlag;
    PHY_UINT16                          uhwCQIThresh1;                          /* CQI */
    PHY_UINT16                          uhwCQIThresh2;                          /* CQI */
    PHY_UINT16                          uhwCQITime1;                            /* CQIڸ޹طּӳʱ */
    PHY_UINT16                          uhwCQITime2;                            /* CQIڵ޿ּӳʱ */
}UCOM_NV_W_CQI_ANT2_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_UL_RF_GATE0_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwUlRfGate0;
}UCOM_NV_W_UL_RF_GATE0_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_UL_RF_GATE1_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwUlRfGate1;
}UCOM_NV_W_UL_RF_GATE1_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_INIT_DELAY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwPaInitDelay;
}UCOM_NV_W_PA_INIT_DELAY_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_OFF_DELAY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwPaOffDelay;
}UCOM_NV_W_PA_OFF_DELAY_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_INIT_DELAY_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxInitDelay;
}UCOM_NV_W_TX_INIT_DELAY_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_OFF_DELAY_STRUS
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxOffDelay;
}UCOM_NV_W_TX_OFF_DELAY_STRUS;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_IDLE_ONE_DELAY_STRUS
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxIdleOnDelay;
}UCOM_NV_W_TX_IDLE_ONE_DELAY_STRUS;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_IDLE_OFF_DELAY_STRUS
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxIdleOffDelay;
}UCOM_NV_W_TX_IDLE_OFF_DELAY_STRUS;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_ABB_INIT_DELAY_STRUS
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxAbbInitDelay;
}UCOM_NV_W_TX_ABB_INIT_DELAY_STRUS;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_ABB_OFF_DELAY_STRUS
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwTxAbbOffDelay;
}UCOM_NV_W_TX_ABB_OFF_DELAY_STRUS;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_GAIN_CTRL_TIMING_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          shwTxGainOpenTime;                      /* ǰRFchip */
}UCOM_NV_W_TX_GAIN_CTRL_TIMING_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_DRX_CS_PERIOD_MEAS_CLASS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ӰСڵĲȼ
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwClass1Factor;                        /*  */
    PHY_UINT16                          uhwClass2Factor;                        /* ׼ֻбƵƵ */
    PHY_UINT16                          uhwClass3Factor;                        /* ֻС */
    PHY_UINT16                          uhwRsv;
}UCOM_NV_W_DRX_CS_PERIOD_MEAS_CLASS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_DRX_MEAS_CORR_LENTH_MEAS_CALSS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ӰسȵĲȼ
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwClass1Factor;                        /*  */
    PHY_UINT16                          uhwClass2Factor;                        /* ׼ֻбƵƵ */
    PHY_UINT16                          uhwClass3Factor;                        /* ֻС */
    PHY_UINT16                          uhwRsv;
}UCOM_NV_W_DRX_MEAS_CORR_LENTH_MEAS_CALSS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_DRX_STRONG_CELL_CTRL_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ǿϢ
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwIntraStrongCellNum;                  /* Ƶǿ */
    PHY_UINT16                          uhwIntraMeasReserveCellNum;             /* ÿαƵǿС */
    PHY_UINT16                          uhwInterStrongCellNum;                  /* Ƶǿ */
    PHY_UINT16                          uhwInterMeasReserveCellNum;             /* ÿƵǿС */
}UCOM_NV_W_DRX_STRONG_CELL_CTRL_INFO_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_DRX_CTRL_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwDrxMaxCsPeriodLenth;                 /* DRX̬С */
    PHY_UINT16                          uhwDrxMinMeasCorrLenth;                 /* DRX̬СĲس */
    PHY_UINT16                          uhwDrxMaxMeasCorrLenth;                 /* DRX̬Ĳس */
    PHY_UINT16                          uhwDrxMaxCsStep1Lenth;                  /* DRX̬Сstep1 */
    PHY_UINT16                          uhwDrxMinCsStep1Lenth;                  /* DRX̬ССstep1 */
    PHY_UINT16                          uhwRsv;
    UCOM_NV_W_DRX_CS_PERIOD_MEAS_CLASS_STRU         stDrxCsPeriodMeasClass;         /* ӰСڵĲȼ */
    UCOM_NV_W_DRX_MEAS_CORR_LENTH_MEAS_CALSS_STRU   stDrxMeasCorrLenthMeasClass;    /* ӰسȵĲȼ */
    UCOM_NV_W_DRX_STRONG_CELL_CTRL_INFO_STRU        stDrxStrongCellCtrlInfo;        /* ǿϢ */
}UCOM_NV_W_DRX_CTRL_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_CQI_CORRECT_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwCqiCorrectEnable;                     /* CQI̬ʹܿ,0 رգ1  */
    PHY_UINT32                          uwSblerHighThreshold;                   /* SBLER ߿,λ0.01 */
    PHY_UINT32                          uwSblerLowThreshold;                    /* SBLER Ϳ,λ0.01 */
    PHY_UINT32                          uwScheduleRateThreshold;                /* ʿ,λ0.01 */
}UCOM_NV_W_CQI_CORRECT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_PSCH_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwPschLen;                             /* PSCHɳ */
    PHY_UINT16                          uhwPschThd;                             /* PSCH */
}UCOM_NV_W_PSCH_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TOTOLPC_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwOpenTotolpcFlg;                  /* ǷTot Olpc㷨־Ĭֵ1 */
    PHY_UINT16                              uhwOutageProbability;               /* Totolpc㷨еĲĬֵ15*/
    PHY_UINT16                              uhwSirErrorStep;                    /* Totolpc㷨еĲĬֵ1*/
    PHY_UINT16                              uhwCorrectionFactor;                /* Totolpc㷨еĲĬֵ10*/
    PHY_UINT16                              uhwSirOutageOffset;                 /* Totolpc㷨еĲĬֵ0*/
    PHY_INT16                               shwOutageIncrementThresUp;          /*TOT OLPC㷨еĲOutageIncrementThresholdUpĬֵ26*/
    PHY_INT16                               shwOutageIncrementThresDown;        /*TOT OLPC㷨еĲOutageIncrementThresholdDownĬֵ-19*/
    PHY_INT16                               shwOutagetargetStepUp;              /*TOT OLPC㷨еĲOutagetargetStepUpĬֵ10*/
    PHY_INT16                               shwOutagetargetStepDown;            /*TOT OLPC㷨еĲOutagetargetStepDownĬֵ-10*/
    PHY_INT16                               shwReserve;                             /*λĬֵ0*/
} UCOM_NV_W_TOTOLPC_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_CPC_DRX_STRU
 Э  :
 ö˵  :CPC DRXĿʹõNVṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRfWorkMode;                          /* RF͹״̬ʱIdle̬ǽStandBy̬*/
    PHY_UINT16                          uhwCpcDrxCtrlFlag;                      /* CPC DRXعܿصı־*/
}UCOM_NV_W_CPC_DRX_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_CAL_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :IP2У׼,ּͬһṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwIp2TxRefPower;                  /* У׼ʱͨĹʣλΪ0.1dbm */
    PHY_INT16                           shwIp2Imd2Threshold;                /* У׼IMD2ޣλdb */
}UCOM_NV_W_RX_IP2_CAL_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_IQ_MISMATCH_CAL_STRU
 Э  :
 ASN.1 :
 ṹ˵  :TX IQ MISMATCHУ׼ʼʺ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTxIqMismatch2RefPower;           /* У׼ʱͨĹʣλΪ0.1dbm */
    PHY_INT16                           shwAmpCorrThreshold;                /* У׼IMD2ޣλdb */
    PHY_INT16                           shwDcCorrThreshold;                 /* У׼IMD2ޣλdb */
}UCOM_NV_W_TX_IQ_MISMATCH_CAL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RSSI_ARITHMETIC_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwRssiArithmeticPara;
}UCOM_NV_W_RSSI_ARITHMETIC_PARA_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_APT_ENABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwWBand;                      /* bitλ1֧APT */
    PHY_UINT32                          uwWBandExtRsv;                /* bitλ1֧APT */
}UCOM_NV_W_TX_PA_APT_ENABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_EEIC_EN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwEEICEn;
}UCOM_NV_W_EEIC_EN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_IPS_FLG_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwIpsFlg;
}UCOM_NV_W_IPS_FLG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_SPUR_REMOVE_ALG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : г㷨
*****************************************************************************/
typedef struct
{
    UCOM_NV_WCDMA_SPUR_TYPE_ENUM_UINT16 enSpurType;                             /* г */
    PHY_UINT16                          uhwMainRemoveEnable;                    /* ʹ */
    PHY_UINT16                          uhwDivRemoveEnable;                     /* ּʹ */
    PHY_INT16                           shwRssiThreshold;                       /* г㷨rssi */
    PHY_UINT16                          uhwFilterCoeff;                         /* ˲ */
}UCOM_NV_W_RX_SPUR_REMOVE_ALG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_M_VALUE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              auhwRfMValue[2];                    /* 0: usRfScMDaValue 1:usRfDcMDaValue */
}UCOM_NV_W_RF_M_VALUE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_LOWPOWER_STRU
 Э  :
 ASN.1 :
 ṹ˵  : W͹Լ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwAllocToUseExtraMpUnit;       /* ʹ10~19Ԫ,Χ [0,1] ,Ƽ 0 */
    PHY_UINT16                          uhwAllocToUseExtraMpUnitInCPC;  /* CPC ʹ10~15Ԫ,Χ [0,1],Ƽ 1 */
    PHY_UINT16                          uhwIntraFMSRUsing5msPerFrEn;    /* Ƶ5ms, Χ [0,1]Ƽ 1 */

    /* ر EEIC */
    PHY_UINT16                          uhwThrptUppLmtPerCrNMThd;       /* Χ0~2000,1(100Kbps),Ƽ 130 */
    PHY_UINT16                          uhwThrptUppLmtPerCrNonMimoEn;   /* Χ[0,1],Ƽ 1 */

    /* رշּ */
    PHY_UINT16                          uhwCorrCoefAccFrm;              /* Ƚͳ֡λ10֡Χ0~1024,Ƽ 10 */
    PHY_UINT32                          uwCorrCoefShutDownThd;          /* رޣΪԭֵƽŴ10000,Χ0~1000000,Ĭ 400, */
    PHY_UINT16                          uhwAntRssiShutDownThd;          /* رޣλ1dBmΧ0~100Ƽ20 Ƽ 10 */
    PHY_UINT16                          uhwCorrCoefCalEn;               /* Χ[0,1],Ƽ 1 */
    PHY_UINT16                          uhwAntRssiCmprEn;               /* Χ[0,1],Ƽ 1 */
    PHY_UINT16                          uhwAntRssiCmprAccFrm;           /* Χ0~1024, Ƽ 10 */
    PHY_UINT16                          uhwCorrCoefReCalDelayFrm;       /* Χ0~1024, Ƽ 10 */
    PHY_UINT16                          uhwAntRssiReOpenDelayFrm;       /* Χ0~1024, Ƽ 10 */

    /* Wd̬ŵʱ϶ */
    PHY_UINT16                          uhwWdCalPerSlotEn;              /* Χ [0,1],    Ƽ 1 */
    PHY_UINT16                          uhwWdCalPerSlotThd;             /* Χ0~511,   Ƽ 251 */

}UCOM_NV_W_LOWPOWER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_ENABLE_SELECT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : w pa en 4ѡ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwLineSel[UCOM_NV_WCDMA_PA_EN_LINE_NUM];
}UCOM_NV_W_PA_ENABLE_SELECT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_HSUPA_MAX_POWER_TEST_MODE_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : HSUPA书ʲģʽ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwEnableFlag;
    PHY_UINT16                          auhwMinSetEtfci[UCOM_NV_HSUPA_ETFCI_TABLE_MAX_NUM];
}UCOM_NV_W_HSUPA_MAX_POWER_TEST_MODE_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_HDET_TIMING_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʼʹõNVṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                              shwPaStableTiming;                   /* 书ʱ仯RFPAȶʱ䣬λΪchip*/
    PHY_INT16                              shwPdHkadcChanSelTiming;             /*ȨЧHKADCͨʱ̼λΪchip*/
    PHY_INT16                              shwPdStartInterval;                  /* ABBbypassΪ͵startABBʼתʱλΪchip*/
    PHY_INT16                              shwPdInterval;                       /* ιʼ֮ʱλΪchip*/
    PHY_INT16                              shwPdsampleTiming;                   /* HKADCźŴʱ䣬λΪchip*/
    PHY_INT16                              shwDcOffsetSampleNum;                /*WHKADCÿʱ϶dc offsetĴ*/
    PHY_INT16                              shwPdSampleNum;                      /*Wÿʱ϶PDĴ*/
} UCOM_NV_W_HDET_TIMING_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾÿRF GainӦ¶Ȳֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTempComp[UCOM_NV_W_TX_TEMP_COMP_NUM];       /* ʾĳһRF Gain16¶µ¶ȲֵλΪ0.1dB */
}UCOM_NV_W_TX_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_RF_GAIN_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾ15RF GainӦ¶Ȳֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCount;                                   /* Чĵλ */
    UCOM_NV_W_TX_TEMP_COMP_STRU         astTempComp[UCOM_NV_W_TX_RF_GAIN_CTRL_NUM];     /* ʾ15RF Gain16¶µ¶Ȳֵ */
}UCOM_NV_W_TX_RF_GAIN_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_VOICE_APC_SIG_ENABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwVoiceApcSigEnable;               /* ʾģʽǷ񼤻VoiceģʽAPC */
}UCOM_NV_W_VOICE_APC_SIG_ENABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_VOICE_APC_CAL_ENABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwVoiceApcCalEnable;               /* ʾУ׼ģʽǷУ׼VoiceģʽAPC */
}UCOM_NV_W_VOICE_APC_CAL_ENABLE_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_RX_AGC_GAIN_VALID_COUNT_STRU
 Э  :
 ö˵  : AGCλNVBLOCKͷBLOCK
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwAgcGainNoBlockNum;                   /* BlockģʽAGC */
    PHY_UINT16                          uhwAgcGainBlockNum;                     /* BlockģʽAGC */
}UCOM_NV_W_RX_AGC_GAIN_VALID_COUNT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_RF_GAIN_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : rf gain ctrl λ
*****************************************************************************/
typedef struct
{
    PHY_UINT32          uwValidCount;
    PHY_UINT16          auhwRfGainCtrl[UCOM_W_MAX_RF_GAIN_CTRL_NUM];
}UCOM_NV_W_TX_RF_GAIN_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_RF_BIAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : rf BIAS λ
*****************************************************************************/
typedef struct
{
    PHY_UINT32          uwValidCount;
    PHY_UINT16          auhwRfBias[UCOM_W_MAX_RF_BIAS_NUM];
}UCOM_NV_W_TX_RF_BIAS_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_BB_GAIN_VS_ATTEN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : BBÿλӦ˥ֵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwBbGainCtrl;
    PHY_INT16           shwBbAtten10th;
}UCOM_NV_W_BB_GAIN_VS_ATTEN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_BB_GAIN_TABLE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : BBĵλ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                             uwValidCount;
    UCOM_NV_W_BB_GAIN_VS_ATTEN_STRU        astBbGain[UCOM_W_MAX_RF_BB_GAIN_NUM];
}UCOM_NV_W_BB_GAIN_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_ECIOR_CTRL_STRU
 ṹ˵  : ec/iorĿƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwCqiLoadSwitchThreshold;          /* CQIлޣĬΪ15;*/
    PHY_UINT16                          uhwLoadRateThreshold1;              /* 1ĬΪ6;*/
    PHY_UINT16                          uhwLoadRateThreshold2;              /* 2ĬΪ10; */
} UCOM_NV_W_ECIOR_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_ANT_TUNER_CTRL_WORD_STRU
 ṹ˵  : פǰ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwForWardWord;                      /* פǰ */
    PHY_UINT32                              uwReverseWord;                      /* פⷴ */
} UCOM_NV_ANT_TUNER_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_ANT_TUNER_CTRL_PARA_STRU
 ṹ˵  : ߵгĿƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwCodeSearchStep;                  /* гʱ */
    PHY_UINT16                              uhwBypassMaxCode;                   /* Bypassʱ֣RF1108Ϊ0x40 */
    PHY_UINT16                              uhwBypassMinCode;                   /* BypassʱС֣RF1108Ϊ0x5F */
    PHY_UINT16                              uhwUpperCode;                       /* ߵгޣRF1108Ϊ0 */
    PHY_UINT16                              uhwLowerCode;                       /* ߵгޣRF1108Ϊ31 */
    PHY_UINT16                              auhwReserve[3];                     /* ȷָʽʹСȱ */
} UCOM_NV_W_ANT_TUNER_CODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_ANT_TUNER_CTRL_PARA_STRU
 ṹ˵  : ߵгĿƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwBandSupport;                      /* ӦbitΪ1ʾbandֶ֧̬ߵг,֧ */
    PHY_UINT32                              uwBandExten;                        /* Ժband IDܳ32 */
    PHY_UINT16                              uhwActiveTime;                      /* ߵгǰ֡ͷд򿪺WBBPÿ֡ͷǰcpu_tx_sw_active_timeãλΪchip */
    PHY_UINT16                              uhwSampleTime;                      /* ߵгƽ,ĬΪ4 */
    PHY_UINT16                              uhwDelayFrame;                      /* һֵгĵȴʱ䣬λ֡ */
    PHY_UINT16                              uhwEchoLossThreshold;               /* ߵгز,0.1dBm */
    UCOM_NV_ANT_TUNER_CTRL_WORD_STRU        stCtrlWord;                         /* פǰ */
    UCOM_NV_W_ANT_TUNER_CODE_STRU           stAntTunerCode;                     /* ߵгϢ */
} UCOM_NV_W_ANT_TUNER_CTRL_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_VCO_REG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF VCO REG
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRegAddress;
    PHY_UINT16                          uhwRegValue;
}UCOM_NV_W_RF_VCO_REG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_VCO_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF VCO CONFIG
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCounter;
    UCOM_NV_W_RF_VCO_REG_STRU           astRegConfig[UCOM_NV_MAX_RF_VCO_CONFIG_NUM];
}UCOM_NV_W_RF_VCO_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_RF_TX_BIAS_REG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF TX BIAS
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwRegAddress;
    PHY_UINT16                          uhwRegValue;
}UCOM_NV_W_RF_TX_BIAS_REG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_TX_BIAS_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF TX BIAS
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCounter;
    UCOM_NV_W_RF_TX_BIAS_REG_STRU       astBias[UCOM_NV_W_TX_RF_BIAS_NUM];
}UCOM_NV_W_RF_TX_BIAS_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_RFIC_BIAS_CFG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF TX BIAS
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwRfRxBiasAddress;                                     /* TX BIASַ */
}UCOM_NV_W_RX_RFIC_BIAS_CFG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_RX_BIAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF RX BIAS
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwNoBlockStateBias[UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM]; /* no block biasNV */
}UCOM_NV_W_RF_RX_BIAS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_RX_BIAS_DELTA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RF RX DELTA GAIN
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwNoBlockStateDeltaGain[UCOM_NV_W_ANT_NUM][UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM]; /* no block delta gainNV */
}UCOM_NV_W_RF_RX_BIAS_DELTA_GAIN_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_RX_AGC_SWITCH_VOICE_MODE_STRU
 Э  :
 ö˵  : VOICEģʽµAGCλл޵NVֻBLOCK״̬
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwNoBlockAgcThresholdInc[UCOM_NV_W_AGC_GAIN_NOBLK_THRESHOLD_NUM];           /* NoBlockʽµλ */
    PHY_INT16                           ashwNoBlockAgcThresholdDec[UCOM_NV_W_AGC_GAIN_NOBLK_THRESHOLD_NUM];           /* NoBlockʽµλ */
}UCOM_NV_W_RX_AGC_SWITCH_VOICE_MODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_MMMBPA_CMD_ADDRESS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mmmb pa Ĵַ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidNumber;
    PHY_UINT16                          auhwCmdAddress[UCOM_NV_MAX_MMMBPA_CMD_NUMBER];
}UCOM_NV_WG_MMMBPA_CMD_ADDRESS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_MIPI_ANT_CMD_ADDRESS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mipi ant Ĵַ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidNumber;
    PHY_UINT16                          auhwCmdAddress[UCOM_NV_MAX_MIPI_ANT_CMD_NUMBER];
}UCOM_NV_WG_MIPI_ANT_CMD_ADDRESS_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_HEET_HKADC_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwSeperatePaHdetChannel;           /* PA HDETͨ */
    PHY_UINT16                          uhwMmmbPaHdetChannel;               /* MMMB PA HDETͨ */
}UCOM_NV_W_HEET_HKADC_CHAN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_DPA_IQ_REDUCTION_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DPAֻ
*****************************************************************************/

typedef struct
{
    PHY_INT16                           ashwDpaIqReduction[UCOM_NV_W_TX_DPA_IQ_REDUCTION_NUM];
}UCOM_NV_W_TX_DPA_IQ_REDUCTION_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_SCUPA_IQ_REDUCTION_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SC-UPAֻ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwScUpaIqReduction[UCOM_NV_W_TX_SCUPA_IQ_REDUCTION_NUM];
}UCOM_NV_W_TX_SCUPA_IQ_REDUCTION_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_DPA_MPR_STRU_HI6361
 Э  :
 ASN.1 :
 ṹ˵  : DPAʻ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwDpaMpr[UCOM_NV_W_TX_DPA_MPR_NUM];
}UCOM_NV_W_TX_DPA_MPR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_SCUPA_MPR_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DPAʻ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwScUpaMpr[UCOM_NV_W_TX_SCUPA_MPR_NUM];
}UCOM_NV_W_TX_SCUPA_MPR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_DCUPA_MPR_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DPAʻ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwDcUpaMpr[UCOM_NV_W_TX_DCUPA_MPR_NUM];
}UCOM_NV_W_TX_DCUPA_MPR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_HKADC_SSI_WAIT_TIME_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwHkadcSsiWaitTime;
}UCOM_NV_W_HKADC_SSI_WAIT_TIME_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_DRX_LTE_EVALUATE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : LTE޲ṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwLteEvaluateServCellReportCorr;       /* LteʱСϱϵĬ6Χ030 */
    PHY_INT16                           shwLteEvaluateServCellRscpThres;        /* LteоķСRSCPֵޣλ0.125dbĬ-640Χ-1040-320 */
    PHY_UINT16                          uhwLteEvaluateServCellDeltaThres;       /* LteоķСrscp仯ֵޣλ0.125dbĬ160Χ0480 */
}UCOM_NV_W_DRX_LTE_EVALUATE_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_VOLT_LOWPOWER_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ѹ͹ĿNV
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwLowVoltDeltaPower;                   /* ѹ书ʲֵ,Ĭ2dBm,,Χ0~24dBm */
    PHY_UINT16                          uhwDataFrameThreshold;                  /* ֡,Ĭ50,λ10msOr2ms */
    PHY_UINT16                          uhwNoDataFrameThreshold;                /* ֡,Ĭ80,λ10ms */
    PHY_INT16                           shwLowRssiThreshold;                    /* ѹRSSI,Ĭ-95dBm */
    PHY_INT16                           shwHighRssiThreshold;                   /* ѹRSSI,Ĭ-85dBm */
    PHY_UINT16                          uhwTxPowerCntThreshold;                 /* ѹ书ͳƸ,Ĭ8,λ10ms */
    PHY_UINT16                          uhwHsupaRemainPowerCntThreshold;        /* ѹHSUPAʣ๦ʲͳƸ,Ĭ8,λ10ms */
    PHY_UINT16                          uhwR99RemainPowerCntThreshold;          /* ѹR99ʣ๦ʲͳƸ,Ĭ8,λ10ms */
    PHY_UINT16                          uhwForceConfigLowPowerThreshold;        /* ǿƽѹʱ,Ĭ100,λ10ms */
}UCOM_NV_VOLT_LOWPOWER_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_ANT2_OFF_EVA_THRESH_STRU
 Э  :
 ASN.1 :
 ṹ˵  : 2رյ޲ṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTimeRxNoDataDpa;                     /* 801603206401000λmsĬ160ms */
    PHY_UINT16                          uhwTimeRxNoDataR99Turbo;                /* 801603206401000λmsĬ160ms */
    PHY_UINT16                          uhwTimeRxNoDataR99Vtb;                  /* 801603206401000λmsĬ160ms */
}UCOM_NV_W_ANT2_OFF_EVA_THRESH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_RX_CAL_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ҪУ׼WCDMAƵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidCalChanNum;
    PHY_UINT16                          auhwRxCalChan[UCOM_WCDMA_UARFCN_NUM];        /* _H2ASN_Replace PHY_UINT16_ARRAY2_16 auhwRxCalChan[UCOM_WCDMA_BAND_NUM][UCOM_NV_W_UARFCN_NUM]; */ /* RXƵ䣬3ƵΣÿƵ16UARFCN */
}UCOM_NV_WCDMA_RX_CAL_CHAN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_CAL_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :3.3ҪIP2У׼Ƶ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwHighFreq;
    PHY_UINT16                          uhwMidFreq;
    PHY_UINT16                          uhwLowFreq;
}UCOM_NV_W_RX_IP2_CAL_CHAN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_CAL_AT1_STRU
 Э  :
 ASN.1 :
 ṹ˵  :RXͨÿBANDڸеƵּرպʹ£IQ·ĵ·
*****************************************************************************/
typedef struct
{
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetHDivyOn;                   /* Ƶּ */
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetHDivyOff;                  /* Ƶּر */
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetMDivyOn;                   /* Ƶּ */
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetMDivyOff;                  /* Ƶּر */
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetLDivyOn;                   /* Ƶּ */
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetLDivyOff;                  /* Ƶּر */
}UCOM_NV_W_RX_IP2_CAL_AT1_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_CAL_AT2_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ּRXͨÿBANDڸеƵ£IQ·ĵ·
*****************************************************************************/
typedef struct
{
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetH;
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetM;
    UCOM_NV_RX_IP2_STRU                 stRxIp2OffsetL;
}UCOM_NV_W_RX_IP2_CAL_AT2_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  :IP2У׼,ּͬһṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwIp2StopThreshold;                    /* ֹͣ */
    PHY_INT16                           shwIp2FailThreshold;                    /* ʧ */
}UCOM_NV_W_RX_IP2_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_IP2_CAL_ENABLE_AT2_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwRxIp2CalEnableAt2;           /* 0ʾּIP2У׼1ʾ */
}UCOM_NV_W_RX_IP2_CAL_ENABLE_AT2_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_FREQ_COMP_ANT_STRU
 Э  :
 ASN.1 :
 ṹ˵  :3.5 AGCͳһƵƵ㲻ͬ仯
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxAgcFreqComp[UCOM_WCDMA_UARFCN_NUM];
}UCOM_NV_W_RX_AGC_FREQ_COMP_ANT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_ANY_CARRIER_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC GainУ׼ֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxAgcGainNoBlock[UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM];
    PHY_INT16                           ashwRxAgcGainBlock[UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM];
}UCOM_NV_W_RX_AGC_GAIN_ANY_CARRIER_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC GainУ׼ֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_GAIN_ANY_CARRIER_STRU            astAgcGain[UCOM_NV_DC_SC_MODE_BUTT];    /* AGC Gain,ز */
}UCOM_NV_W_RX_AGC_GAIN_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC GainУ׼ֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_GAIN_STRU            astRxAgcGainAnt[UCOM_NV_W_ANT_NUM];    /* AGC Gain,ز */
}UCOM_NV_W_RX_AGC_GAIN_DANT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_PRE_ANY_CARRIER_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC Gain Predefinedֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxAgcGainPreNoBlock[UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM];
    PHY_INT16                           ashwRxAgcGainPreBlock[UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM];
}UCOM_NV_W_RX_AGC_GAIN_PRE_ANY_CARRIER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_PRE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC Gain Predefinedֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_GAIN_PRE_ANY_CARRIER_STRU
                                        astRxAgcGainPreCarrier[UCOM_NV_DC_SC_MODE_BUTT];         /* AGC Gain Preֵ,ز */
}UCOM_NV_W_RX_AGC_GAIN_PRE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_GAIN_PRE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC Gain Predefinedֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_GAIN_PRE_STRU
                                        astRxAgcGainPreAnt[UCOM_NV_W_ANT_NUM];         /* AGC Gain Preֵ,ز */
}UCOM_NV_W_RX_AGC_GAIN_PRE_DANT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_FRONT_END_GAIN_PRE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC Front End Predefinedֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwRxFrontEndGainPre[UCOM_NV_DC_SC_MODE_BUTT];   /* Front End Predefined */
}UCOM_NV_W_RX_AGC_FRONT_END_GAIN_PRE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RX_AGC_FRONT_END_GAIN_PRE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : AGC Front End Predefinedֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_FRONT_END_GAIN_PRE_STRU         astRxFrontEndGainPre[UCOM_NV_W_ANT_NUM];   /* Front End Predefined */
}UCOM_NV_W_RX_AGC_FRONT_END_GAIN_PRE_DANT_STRU;


/*****************************************************************************
 ö    : RX_AGC_GAIN_SWITCH_THRESHOLD_STRU
 Э  :
 ö˵  : AGCλл޵NVBLOCKͷBLOCK
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwNoBlockAgcThresholdInc[UCOM_NV_W_AGC_GAIN_NOBLK_THRESHOLD_NUM];           /* NoBlockʽµλ */
    PHY_INT16                           ashwNoBlockAgcThresholdDec[UCOM_NV_W_AGC_GAIN_NOBLK_THRESHOLD_NUM];           /* NoBlockʽµλ */
    PHY_INT16                           ashwBlockAgcThresholdInc[UCOM_NV_W_AGC_GAIN_BLK_THRESHOLD_NUM];             /* Blockʽµλ */
    PHY_INT16                           ashwBlockAgcThresholdDec[UCOM_NV_W_AGC_GAIN_BLK_THRESHOLD_NUM];             /* Blockʽµλ */
}UCOM_NV_W_RX_AGC_GAIN_SWITCH_THRESHOLD_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_RX_AGC_GAIN_PREDEFINED_ANYCARRIER_STRU
 Э  :
 ö˵  : AGCλл޵NVBLOCKͷBLOCK
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_GAIN_SWITCH_THRESHOLD_STRU      astRxAgcGainSwitchThreshold[UCOM_NV_DC_SC_MODE_BUTT];
}UCOM_NV_W_RX_AGC_GAIN_SWITCH_THRESHOLD_DCARR_STRU;


/*****************************************************************************
 ö    : UCOM_NV_W_RX_AGC_CTRL_STRU
 Э  :
 ö˵  : AGCֵNVBLOCKͷBLOCK
*****************************************************************************/
typedef struct
{
    UCOM_NV_RX_AGC_CTRL_UNION           unAgcCtrlNoBlock[UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM];                   /* BlockģʽAGC */
    UCOM_NV_RX_AGC_CTRL_UNION           unAgcCtrlBlock[UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM];                     /* BlockģʽAGC */
}UCOM_NV_W_RX_AGC_CTRL_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_RX_AGC_CTRL_STRU
 Э  :
 ö˵  : AGCֵNVBLOCKͷBLOCK
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_RX_AGC_CTRL_STRU  astRxAgcCtrl[UCOM_NV_DC_SC_MODE_BUTT];
}UCOM_NV_W_RX_AGC_CTRL_DCARR_STRU;



/*****************************************************************************
 ö    : UCOM_NV_W_DCOFFSET_STRU
 Э  :
 ö˵  : DC offsetĽṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwDci;                                 /* I·ֱֵ */
    PHY_INT16                           shwDcq;                                 /* Q·ֱֵ */
}UCOM_NV_W_DCOFFSET_STRU;


/*****************************************************************************
 ö    : UCOM_NV_W_DCOFFSET_ANYCARRIER_STRU
 Э  :
 ö˵  : DC offsetĽṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_DCOFFSET_STRU             astNoBlockDcOffset[UCOM_NV_W_AGC_GAIN_BLK_STEP_NUM];       /* blockģʽ¸λDC offset */
    UCOM_NV_W_DCOFFSET_STRU             astBlockDcOffset[UCOM_NV_W_AGC_GAIN_NOBLK_STEP_NUM];         /* blockģʽ¸λDC offset */
}UCOM_NV_W_DCOFFSET_ANYCARRIER_STRU;


/*****************************************************************************
 ö    : W_DCOFFSET_ANT_STRU
 Э  :
 ö˵  : DC offsetĽṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_DCOFFSET_ANYCARRIER_STRU              astAnyCarrierDcOffset[UCOM_NV_DC_SC_MODE_BUTT];   /* SC\DCزģʽµDCֵ */
}UCOM_NV_W_DCOFFSET_ANT_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_DCOFFSET_ANT_STRU
 Э  :
 ö˵  : DC offsetĽṹ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_DCOFFSET_ANT_STRU              astDcOffsetAnt[UCOM_NV_W_ANT_NUM];
}UCOM_NV_W_DCOFFSET_DANT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_FEM_CHAN_CONNECT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : A/BͨԵѡ,ǰCh0/CH1ͨѡ
*****************************************************************************/
typedef struct
{
    UCOM_NV_CHAN_CONNECT_ENUM_UINT16    enRfConnect;                            /* RF~RFIC֮:0:RF_A1:RF_B */
    UCOM_NV_CHAN_CONNECT_ENUM_UINT16    enRfAbbConnect;                         /* RFICABB֮,Ӳ,Ҫ */
    UCOM_NV_CHAN_CONNECT_ENUM_UINT16    enAbbBbpConnect;                        /* ABBBBP COM1֮:0:ABB_A1:ABB_B */
    PHY_UINT16                          uhwChanSwitch;                          /* ÿbandѡͨ01,ĿǰV9R1Ĭͨѡ0,ͨѡ1. */

}UCOM_NV_FEM_CHAN_CONNECT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_MIPI_ANT_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mipi ant Ĵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwCtrlWord[UCOM_NV_MAX_MIPI_ANT_CMD_NUMBER];
}UCOM_NV_WG_MIPI_ANT_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_CAL_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :ҪУ׼WCDMAƵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwValidCalChanNum;
    PHY_UINT16                          auhwTxCalChan[UCOM_WCDMA_UARFCN_NUM];        /* _H2ASN_Replace PHY_UINT16_ARRAY2_16 auhwRxCalChan[UCOM_WCDMA_BAND_NUM][UCOM_NV_W_UARFCN_NUM]; */ /* RXƵ䣬3ƵΣÿƵ16UARFCN */
}UCOM_NV_WCDMA_TX_CAL_CHAN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_RACH_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxWiredMaxPowerRach;                             /* ƵΣнDPCHRACHʱUE书ʣλ0.1dbm;0ΪRACH,1ΪDPCH, */
}UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_RACH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_DPCH_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxWiredMaxPowerDpch;                             /* ƵΣнDPCHRACHʱUE书ʣλ0.1dbm;0ΪRACH,1ΪDPCH, */
}UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_DPCH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwTxWiredMaxPowerTempComp[UCOM_NV_W_TEMP_NUM];    /* 书ʲ棬λ0.1dbm;3ƵΣ5Ԥȶ¶ȵ:-20,0,20,40,60,6ڶ룬ʹ */
}UCOM_NV_WCDMA_TX_WIRED_MAX_POWER_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_MIN_POWER_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxMinPower;                                      /* UEС书ʣλ0.1dbm;3ƵΣ5Ԥȶ¶ȵ:-20,0,20,40,60,6ڶ룬ʹ */
}UCOM_NV_WCDMA_TX_MIN_POWER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_MIN_POWER_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwTxMinPowerTempComp[UCOM_NV_W_TEMP_NUM];         /* С书¶Ȳ */
}UCOM_NV_WCDMA_TX_MIN_POWER_TEMP_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_VGA_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTxHdetVga;                                                   /* ʾPDǰ˥ VGAֵ*/
}UCOM_NV_W_TX_HDET_VGA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_DCOFFSET_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwTxHdetDcOffset;                                              /* ʾDCOFFSET */
}UCOM_NV_W_TX_HDET_DCOFFSET_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_POWER_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTxHdetContPower[UCOM_NV_W_TX_HDET_PV_NUM];                  /* ģʽ£Թʺ͵ѹϵĹʲԵ */
}UCOM_NV_W_TX_HDET_POWER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_HKADC_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTxHdetVolt[UCOM_NV_W_TX_HDET_PV_NUM];                       /* ģʽ£Թʺ͵ѹϵʱѹֵ */
}UCOM_NV_W_TX_HDET_HKADC_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_FREQ_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTxHdetFreqComp[UCOM_WCDMA_UARFCN_NUM];                       /* ͬƵԹӰ첻ͬƵʲֵ */
}UCOM_NV_W_TX_HDET_FREQ_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwTxHdetTempComp[UCOM_NV_W_TEMP_NUM];  /* ͬ¶ȶԹӰ첻ͬ¶Ȳֵ.ָеŵ,˳Ϊиߵ */
}UCOM_NV_W_TX_HDET_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_START_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTxHdetStart;                                                 /* TX 书ʳֵʱBBPԶʼ */
}UCOM_NV_W_TX_HDET_START_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_STOPT_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTxHdetStop;                                                  /* TX 书СڸֵʱBBPԶֹͣʼ */
}UCOM_NV_W_TX_HDET_STOPT_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRE_MAXPOWER_RACH_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxWirelessMaxPowerRach;                          /*  *//* տڷ书:_UCOM_TX_PWR_CTRL_SWITCH */
}UCOM_NV_WCDMA_TX_WIRE_MAXPOWER_RACH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRE_MAXPOWER_DPCH_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxWirelessMaxPowerDpch;                          /*  *//* տڷ书:_UCOM_TX_PWR_CTRL_SWITCH */
}UCOM_NV_WCDMA_TX_WIRE_MAXPOWER_DPCH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_WIRELESS_POWER_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwTxWirelessPowerTempComp[UCOM_NV_W_TEMP_NUM];    /* տڹ¶Ȳ */
}UCOM_NV_WCDMA_TX_WIRELESS_POWER_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_GAIN_COMP_VS_PA_CHAN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwHighFreq;                            /* жϸƵƵ */
    PHY_UINT16                          uhwLowFreq;                             /* жϵƵƵ */
}UCOM_NV_W_TX_GAIN_COMP_VS_PA_CHAN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_GAIN_COMP_VS_PA_CH_STRU
 Э  :
 ṹ˵  : W TX PAл㲹ֽ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidNum;                             /* ʾƵ㼸Ч */
    PHY_UINT16                          auhwFreqChan[UCOM_NV_W_PA_GAIN_SWITCH_COMP_CHAN_NUM];
}UCOM_NV_W_TX_GAIN_COMP_VS_PA_CH_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_GAIN_SWITCH_COMP_STRU
 Э  :
 ṹ˵  : W TX PAлʱʲֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwH2MComp;                             /* PAӸее޲,λ0.1db */
    PHY_INT16                           shwM2HComp;                             /* PAеߵ޲,λ0.1db */
    PHY_INT16                           shwM2LComp;                             /* PAе͵޲,λ0.1db */
    PHY_INT16                           shwL2MComp;                             /* PAӵее޲,λ0.1db */
}UCOM_NV_W_PA_GAIN_SWITCH_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_GAIN_SWITCH_COMP_STRU
 Э  :
 ṹ˵  : W TX 4ʱ϶PAлʱʲֵ
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_PA_GAIN_SWITCH_COMP_STRU  astSlotComp[UCOM_NV_W_PA_SWITCH_COMP_SLOT];
}UCOM_NV_W_TX_PA_GAIN_SWITCH_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_APC_TEMP_STRU
 Э  :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   shwTxApcTemp;                                       /* У׼ʱ¶ֵ:ŵ,ÿBANDĸеPAģʽУ׼ʱ¶ֵ,бʾе */
}UCOM_NV_W_TX_APC_TEMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_GAIN_SWITH_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_INT16                           shwPaGainThresH2M;                      /* PAӸ浽л */
    PHY_INT16                           shwPaGainThresM2H;                      /* PA浽л */
    PHY_INT16                           shwPaGainThresM2L;                      /* PA浽л */
    PHY_INT16                           shwPaGainThresL2M;                      /* PAӵ浽л */
}UCOM_NV_W_PA_GAIN_SWITH_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_RF_PA_GAIN_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT32                          uwRfPaCtrlHighMode;                     /* PAģʽ */
    PHY_UINT32                          uwRfPaCtrlMediumMode;                   /* PAģʽ */
    PHY_UINT32                          uwRfPaCtrlLowMode;                      /* PAģʽ */
}UCOM_NV_W_RF_PA_GAIN_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_GAIN_SWITH_TIMING_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_INT16                           shwPaGainSwitchH2M;                     /* PA浽лʱ */
    PHY_INT16                           shwPaGainSwitchM2H;                     /* PA浽лʱ */
    PHY_INT16                           shwPaGainSwitchM2L;                     /* PA浽лʱ */
    PHY_INT16                           shwPaGainSwitchL2M;                     /* PA浽лʱ */
}UCOM_NV_W_PA_GAIN_SWITH_TIMING_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_TX_IQ_MISMATCH_DCR_STRU
 Э  :
 ASN.1 :
 ṹ˵  :2.3 ÿNVĿʾIQ mismatchDC offset
            ʱ˲øDBBTXͨԤ
            ֲͨIQ mismatchͲDC
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwAmplitude;                           /* ֵУ */
    PHY_INT16                           shwPhase;                               /* λУ */
    PHY_INT16                           shwDCI;                                 /* ֱУʵ */
    PHY_INT16                           shwDCQ;                                 /* ֱУ鲿 */
}UCOM_NV_TX_IQ_MISMATCH_DCR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾRFICDBB˥£е3ֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwPaGain[UCOM_NV_W_TX_PA_MODE_NUM];           /* VOICEģʽ£ʾRFICDBB˥£е3ֵλΪ0.1dB */
}UCOM_NV_W_TX_PA_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_GAIN_VOICE_MODE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʾVOICEģʽ£RFICDBB˥£е3ֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwPaGain[UCOM_NV_W_TX_PA_MODE_NUM];           /* ʾVOICEģʽ£RFICDBB˥£е3ֵλΪ0.1dB */
}UCOM_NV_W_TX_PA_GAIN_VOICE_MODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PHASE_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :4.2 PAģʽӸл桢л桢л
                桢лʱTXPAԻIQźŲλ
                ת
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwPaH2M;
    PHY_INT16                           shwPaM2H;
    PHY_INT16                           shwPaM2L;
    PHY_INT16                           shwPaL2M;

}UCOM_NV_W_TX_PHASE_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PHASE_COMP_TIMING_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwTxPhaseCompTiming;
}UCOM_NV_W_TX_PHASE_COMP_TIMING_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_GAIN_FREQCOMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwTxGainFreqComp[UCOM_NV_W_TX_FREQ_COMP_NUM];     /* _H2ASN_Replace PHY_UINT16_ARRAY2_16 ashwHigh[W_BAND_NUM][W_UARFCN_NUM];*/ /* TXƵʲֵ */
}UCOM_NV_W_TX_GAIN_FREQCOMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_GAIN_TEMP_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :7.4 PAڸеģʽ£ƵڸߡСŵ£TX书¶ȱ仯Ĳ
*****************************************************************************/
typedef struct
{
    /* ¶ȷΧȡֵȡUCOM_NV_WG_TX_TEMP_DEFINE_STRU */
    PHY_INT16                           ashwTxGainTempComp[UCOM_NV_W_TX_PA_TEMP_NUM];
}UCOM_NV_W_TX_GAIN_TEMP_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_HSDPCCH_DELTA_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwTpcAlgo1UlPowGain;
    PHY_INT16                           shwTpcAlgo1HsDpaPowMode;
    PHY_INT16                           shwTpcAlgo2UlPowGain;
    PHY_INT16                           shwTpcAlgo2HsDpaPowMode;
}UCOM_NV_W_HSDPCCH_DELTA_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_VBIAS_TIMING_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwTxVbiasTiming;              /*ʾPA VBIASлʱ϶߽ǰ*/
}UCOM_NV_W_TX_VBIAS_TIMING_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_SAR_BACKOFF_POWER_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwWcdmaSarBackoffPower[UCOM_NV_SAR_BACKOF_NUM];
}UCOM_NV_W_SAR_BACKOFF_POWER_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_RFIC_CTRL_GAIN_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  auhwApcRficCtrlGain[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_RFIC_CTRL_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_DBB_ATTEN_GAIN_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwApcDbbAttenGain[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_DBB_ATTEN_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_GAIN_STATE_INDEX_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  auhwRfGainStateIndexGain[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_GAIN_STATE_INDEX_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_RFIC_CTRL_GAIN_VOICE_MODE_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  auhwApcRficCtrlGainVoiceMode[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_RFIC_CTRL_GAIN_VOICE_MODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_DBB_ATTEN_GAIN_MODE_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_INT16                                   ashwApcDbbAttenGainVoiceMode[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_DBB_ATTEN_GAIN_VOICE_MODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APC_STATE_INDEX_GAIN_VOICE_MODE_STRU
 Э  :
 ṹ˵  : APC table
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  auhwRfGainStateIndexGainVoiceMode[UCOM_NV_W_APC_ATTEN_NUM];

}UCOM_NV_W_APC_STATE_INDEX_GAIN_VOICE_MODE_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_APT_STRU
 Э  :
 ṹ˵  : APT书ʵĽṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwPower10th;                           /* ÿλAPT书 */

    PHY_UINT16                          uhwPaVcc;                               /* ÿλAPTѹ */
    PHY_UINT16                          uhwPaVbias;                             /* ÿλMmmbPaVbiasѹ */
    PHY_UINT16                          uhwPaVbias2;                            /* ÿλMmmbPaVbias2 */
    PHY_UINT16                          uhwPaVbias3;                            /* ÿλMmmbPaVbias3 */
}UCOM_NV_W_TX_PA_APT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_APT_TABLE_STRU
 Э  :
 ṹ˵  : APT书ʵĽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCount;

    UCOM_NV_W_TX_PA_APT_STRU            astAptTable[UCOM_NV_APT_MAX_NUM];

}UCOM_NV_W_TX_PA_APT_TABLE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_MIPI_PA_TIMING_CFG_STRU
 Э  :
 ṹ˵  : PAĿϢǰʱ϶ͷЧʱ䣬λchip
*****************************************************************************/
typedef struct
{
    PHY_UINT16              uhwPaVccActiveTime;
    PHY_UINT16              uhwPaBias1ActiveTime;
    PHY_UINT16              uhwPaBias2ActiveTime;
    PHY_UINT16              uhwPaBias3ActiveTime;
    PHY_UINT16              uhwPaBiasTrigActiveTime;
    PHY_UINT16              uhwPaBiasTrigAgainActiveTime;
}UCOM_NV_W_MIPI_APT_TIMING_CFG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_MIPI_APT_CMD_FRAME_STRU
 Э  :
 ṹ˵  : ӦAPTPA Vcc VbiasĿָ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwPaVccCmd;                                /* PA VccĿָ */
    PHY_UINT16                          uhwReseved;
    PHY_UINT16                          uhwPaBiasNum;                               /* PA VbiasĿָ */
    PHY_UINT16                          auhwPaVbiasCmd[UCOM_NV_W_TX_PA_VBIAS_NUM];  /* PA VbiasĿָ */
}UCOM_NV_W_MIPI_APT_CMD_FRAME_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_PA_APT_CFG_STRU
 Э  :
 ṹ˵  : APTPAϢ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwAptCtrlMask;                         /* ӦUCOM_NV_APT_MASK_BIT_ENUM_UINT16 */
    PHY_UINT16                          uhwAptChannelSelect;                    /* ӦUCOM_NV_APT_CHANNEL_DEFINE_ENUM_UINT16 */
}UCOM_NV_W_TX_PA_APT_CFG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_MIPI_APT_PA_TRIGGER_STRU
 Э  :
 ṹ˵  : Mipi PA triggermipiָ
*****************************************************************************/
typedef struct
{
    UCOM_NV_MIPI_WR_FORMAT_STRU         stPaTrigger;
    UCOM_NV_MIPI_WR_FORMAT_STRU         stPaTriggerAgian;
}UCOM_NV_W_MIPI_APT_PA_TRIGGER_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_ANT_TUNER_BAND_PARA_STRU
 Э  :
 ṹ˵  : ߵгBANDƽṹ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwAntTunerCode;                   /* ǰBANDߵгĬֵ */
    PHY_UINT16                              uhwReserve;
    PHY_UINT16                              uhwAntTunerStart;                  /* ǰBANDפ,BBPδṩӿڣݺPDһ */
    PHY_INT16                               shwAntTunerComp;                   /* ʲ0.1dbm */
}UCOM_NV_W_ANT_TUNER_BAND_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TUNER_MIPI_CMD_FRAME_STRU
 Э  :
 ṹ˵  : Tuner Wģ̬ʱ֧֡10, uhwNormalNumʾǰͺ
             tunerҪõķչĴuhwExtendedNumʾǰͺtuner
             ҪõչĴչõļĴ϶ģ֮
             ӦСڵ10չõļĴҪдչõļĴ
             ֻҪдַȿɡ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwNormalNum;
    PHY_UINT16                              uhwExtenedNum;
    PHY_UINT16                              auhwCmdFrame[UCOM_NV_W_TUNER_MIPI_CMD_MAX_NUM];
}UCOM_NV_W_TUNER_MIPI_CMD_FRAME_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TUNER_MIPI_DATA_FRAME_STRU
 Э  :
 ṹ˵  : tunerĬݣ֧10,ӦCmdFrame,ʽͬCmdFrame
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              auhwDataFrame[UCOM_NV_W_TUNER_MIPI_DATA_MAX_NUM];
}UCOM_NV_W_TUNER_MIPI_DATA_FRAME_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TUNER_MIPI_CMD_FRAME_STRU
 Э  :
 ṹ˵  : Tuner֧֡6,uhwNormalNumʾǰͺ
             tunerҪõķչĴuhwExtendedNumʾǰͺtuner
             ҪõչĴչõļĴ϶ģ֮
             ӦСڵ10չõļĴҪдչõļĴ
             ֻҪдַȿɡ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwNormalNum;
    PHY_UINT16                              uhwExtenedNum;
    PHY_UINT16                              auhwCmdFrame[UCOM_NV_GSM_TUNER_MIPI_CMD_MAX_NUM];
}UCOM_NV_GSM_TUNER_MIPI_CMD_FRAME_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TUNER_MIPI_DATA_FRAME_STRU
 Э  :
 ṹ˵  : tunerĬݣ֧6,ӦCmdFrame,ʽͬCmdFrame
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              auhwDataFrame[UCOM_NV_GSM_TUNER_MIPI_DATA_MAX_NUM];
}UCOM_NV_GSM_TUNER_MIPI_DATA_FRAME_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_TUNER_MIPI_DATA_GROUP_STRU
 Э  :
 ö˵  : W,֧״̬ÿ״̬֧10֣ӦCmdFrame,
             ʽͬCmdFrame
*****************************************************************************/
typedef struct
{
    UCOM_NV_W_TUNER_MIPI_DATA_FRAME_STRU         astDataFrame[UCOM_NV_TUNER_HANDLE_STATUS_NUM];
}UCOM_NV_W_TUNER_MIPI_DATA_GROUP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TUNER_MIPI_DATA_TX_STRU
 Э  :
 ṹ˵  : GģTxĬ,֧6ЧUCOM_NV_TUNER_CMD_ADDR
             uhwValidNumBandʵȡ
*****************************************************************************/
typedef struct
{
    UCOM_NV_GSM_TUNER_MIPI_DATA_FRAME_STRU         astDataFrame[UCOM_NV_TUNER_HANDLE_STATUS_NUM];
}UCOM_NV_GSM_TUNER_MIPI_DATA_TX_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TUNER_MIPI_DATA_RX_STRU
 Э  :
 ṹ˵  : GģRxĬ,֧6ЧUCOM_NV_TUNER_CMD_ADDR
             uhwValidNumBandʵȡ
*****************************************************************************/
typedef struct
{
    UCOM_NV_GSM_TUNER_MIPI_DATA_FRAME_STRU         astDataFrame[UCOM_NV_TUNER_HANDLE_STATUS_NUM];
}UCOM_NV_GSM_TUNER_MIPI_DATA_RX_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_WG_MMMBPA_GAIN_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mmmb pa Ĵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          auhwCtrlWord[UCOM_NV_MAX_MMMBPA_CMD_NUMBER];
}UCOM_NV_WG_MMMBPA_GAIN_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_SCUPA_CM_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SC-UPACMֵ
*****************************************************************************/

typedef struct
{
    PHY_INT16                           ashwScUpaPdComp[UCOM_NV_W_TX_HDET_SCUPA_CM_COMP_NUM];
}UCOM_NV_W_TX_HDET_SCUPA_CM_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_HDET_DPA_CM_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DPACMֵ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwDpaPdComp[UCOM_NV_W_TX_HDET_DPA_CM_COMP_NUM];
}UCOM_NV_W_TX_HDET_DPA_CM_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_APT_CM_SCUPA_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SC-UPAҵAPTģʽscupa
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwAptCmScupaComp[UCOM_NV_W_TX_APT_SCUPA_CM_COMP_NUM];
}UCOM_NV_W_TX_APT_CM_SCUPA_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_APT_CM_DPA_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  : SC-UPAҵAPTģʽdpa
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwAptCmDpaComp[UCOM_NV_W_TX_APT_DPA_CM_COMP_NUM];
}UCOM_NV_W_TX_APT_CM_DPA_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_APT_TEMP_COMP_STRU_HI6361
 Э  :
 ASN.1 :
 ṹ˵  : APTƵʲ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwAptTempComp[UCOM_NV_W_APT_FREQ_COMP_NUM][UCOM_NV_W_APT_TEMP_COMP_NUM];                                /* ֵʾWBANDGģBANDʶ */
}UCOM_NV_W_APT_TEMP_COMP_STRU;

/*****************************************************************************
 ö    : UCOM_NV_W_APT_COMP_STRU
 Э  :
 ö˵  : APTѹĽṹ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           ashwAptComp[UCOM_NV_APT_MAX_NUM];       /* ÿλAPT */
}UCOM_NV_W_APT_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_NONLINEAR_STRU_HI6361
 Э  :
 ASN.1 :
 ṹ˵  : PAԲ
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwPower;
    PHY_INT16                           shwNonLinearComp;
}UCOM_NV_W_PA_NONLINEAR_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_PA_NONLINEAR_COMP_STRU_HI6361
 Э  :
 ASN.1 :
 ṹ˵  : PAԲ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                          uwValidCount;
    UCOM_NV_W_PA_NONLINEAR_STRU         astNonLinear[UCOM_NV_W_PA_NONLINEAR_NUM];
}UCOM_NV_W_PA_NONLINEAR_COMP_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_LOW_VOLT_SWITCH_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_INT16                           shwStartPower;                          /* ѹ,Ĭ16dBm,Χ0~22dBm */
    PHY_INT16                           shwStopPower;                           /* ѹ,Ĭ18dBm,Χ0~22dBm */
}UCOM_NV_W_TX_LOW_VOLT_SWITCH_THRESHOLD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_MAIL_BOX_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : W
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwWcdmaMailBoxFlag;                 /* W䷽1:䷽Ч0:Ч */
    PHY_UINT16                          uhwReserved;                /* ֽ */
}UCOM_NV_W_MAIL_BOX_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_TX_LOW_VOLT_SWITCH_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  :
*****************************************************************************/

typedef struct
{
    PHY_UINT16                          uhwSlaveSampleNum;                      /* ģּģʽлĲ,ĬΪ1 */
    PHY_UINT16                          uhwDrxIntraSampleNum;                   /* DRXƵּģʽлĲ,ĬΪ1 */
    PHY_UINT16                          uhwDrxInterSampleNum;                   /* DRXƵּģʽлĲ,ĬΪ1 */
    PHY_UINT16                          uhwFachIntraSampleNum;                  /* FACHƵּģʽлĲ,ĬΪ2 */
    PHY_UINT16                          uhwFachInterSampleNum;                  /* FACHƵּģʽлĲ,ĬΪ1 */
    PHY_UINT16                          uhwDchIntraSampleNum;                   /* DCHƵּģʽлĲ,ĬΪ10 */
    PHY_UINT16                          uhwDchInterSampleNum;                   /* DCHƵּģʽлĲ,ĬΪ1 */
    PHY_INT16                           shwMain2ScndThreshold;                  /* зּޣTX_MAIN_RSCP - TX_SCND_RSCP <= ޣлּ-48(-6dB,1/8dB) */
    PHY_INT16                           shwScnd2MainThreshold;                  /* зּޣTX_MAIN_RSCP - TX_SCND_RSCP > ޣлּ-16(-2dB,1/8dB) */
    PHY_INT16                           shwMeasValidThreshold;                  /* ֵЧޣ-960(-120dB,1/8dB) */
    PHY_INT16                           uhwMeasNonEqualThreshold;               /* ֵЧޣ|TX_MAIN_RSCP - TX_SCND_RSCP| > ޣ˵,24(3dB,1/8dB) */
    PHY_UINT16                          uhwEvaTxEnable;                         /* ּʹܵıǣ1ʾʹܡ0ʾʹ */
}UCOM_NV_W_TX_DIV_MODE_EVALUATE_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_W_MAIN_ANT_ESTIMATE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : NV
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwRssiThreshold;                       /* ˫߲RSSI(λΪ0.125dbm) */
    PHY_INT16                           shwRscpThreshold;                       /* ˫߲RSCP(λΪ0.125dbm) */
    PHY_UINT16                          uhwEstimateTime;                        /* ʱ(λΪ1ms) */
}UCOM_NV_W_MAIN_ANT_ESTIMATE_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_DUAL_ANT_COMPARE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫߱Ƚ״̬NV
*****************************************************************************/
typedef struct
{
    PHY_INT16                           shwRscpThreshold[3];                    /* ׶лRSCP(λΪ0.125dbm) */
    PHY_UINT16                          uhwCompareTime[3];                      /* ׶ε˫߱Ƚʱ(λΪ1ms) */
}UCOM_NV_W_DUAL_ANT_COMPARE_PARA_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_ANT_PROTECT_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ߱״̬NV
*****************************************************************************/
typedef struct
{
    PHY_UINT16                          uhwFrozenTime;                          /* ״̬Ķʱ(λΪ1ms) */
}UCOM_NV_W_ANT_PROTECT_PARA_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_W_DUAL_ANT_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ߽
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwWcdmaAntDefaultCtrlWord;          /* ߲ʱGPIO */
    PHY_UINT32                              uwWcdmaAntSwapCtrlWord;             /* ߽ʱGPIO */
}UCOM_NV_W_DUAL_ANT_CTRL_WORD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_DUAL_ANT_MEAS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫߲ĿƲ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwMeasEnable;                       /* ʹ */
    PHY_UINT16                              uhwAlpha;                           /* alpha˲ */
    UCOM_NV_W_DUAL_ANT_CTRL_WORD_STRU       stDualAntCtrlWord;                  /* л */
    UCOM_NV_W_MAIN_ANT_ESTIMATE_PARA_STRU   stAntEstimate;                      /*  */
    UCOM_NV_W_DUAL_ANT_COMPARE_PARA_STRU    stAntCompare;                       /* ˫߱Ƚϲ */
    UCOM_NV_W_ANT_PROTECT_PARA_STRU         stAntProtect;                       /* ߱׶β */
}UCOM_NV_W_DUAL_ANT_MEAS_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_GCF_INIT_GAIN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫߲ĿƲ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwGsmRssiAgcSwitch;                /* GSM RSSIAGCʼ濪 */
    PHY_UINT16                              uhwGsmRssiAgcGain;                  /* GSM RSSI AGCʼλ */
}UCOM_NV_GSM_GCF_INIT_GAIN_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_VIRTUAL_BAND_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM Ƶʹܱ־ٽƵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                           uhwGsmVirtualBand;                     /* 0-֧Ƶη; 1-ɵƵη2-µƵη */
    PHY_UINT16                           uhwGsmFreqBound;                       /* B3LB3HƵŷֽ */
}UCOM_NV_GSM_VIRTUAL_BAND_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_CTUNE_LUT_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSMCtuneLut
*****************************************************************************/
typedef struct
{
    PHY_UINT16                           uhwGsmTxCtuneLutCtrl;
}UCOM_NV_GSM_TX_CTUNE_LUT_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_EXT_STRONG_NCELL_THRESHOLD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSMǿĵƽ
*****************************************************************************/
typedef struct
{
    PHY_INT16                            shwGsmExtStrongNcellThresh;            /* GSMǿĵƽ */
}UCOM_NV_GSM_EXT_STRONG_NCELL_THRESHOLD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_TX_CTUNE_LUT_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : WCDMACtuneLut
*****************************************************************************/
typedef struct
{
    PHY_UINT16                           uhwWcdmaTxCtuneLutCtrl;
}UCOM_NV_WCDMA_TX_CTUNE_LUT_CTRL_STRU;
/*****************************************************************************
 ṹ    : UCOM_NV_CHANNEL_WBBP_GAP_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFICNV,WBBP Gapͨò,ӦWBBPӿ˵"ͨ"
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwT1ForIdlePch;                                         /* idlepch̬T1ӳ,λchip */
    PHY_UINT16          uhwT2ForIdlePch;                                         /* idlepch̬T2ӳ,λchip */
    PHY_UINT16          uhwT3ForIdlePch;                                         /* idlepch̬T3ӳ,λchip */
    PHY_UINT16          uhwT4ForIdlePch;                                         /* idlepch̬T4ӳ,λchip */
    PHY_UINT16          uhwT1ForFach;                                            /* FACH̬T1ӳ,λchip */
    PHY_UINT16          uhwT2ForFach;                                            /* FACH̬T2ӳ,λchip */
    PHY_UINT16          uhwT3ForFach;                                            /* FACH̬T3ӳ,λchip */
    PHY_UINT16          uhwT4ForFach;                                            /* FACH̬T4ӳ,λchip */
    PHY_UINT16          uhwT1ForDch;                                             /* DCH̬T1ӳ,λchip */
    PHY_UINT16          uhwT2ForDch;                                             /* DCH̬T2ӳ,λchip */
    PHY_UINT16          uhwT3ForDch;                                             /* DCH̬T3ӳ,λchip */
    PHY_UINT16          uhwT4ForDch;                                             /* DCH̬T4ӳ,λchip */

}UCOM_NV_CHANNEL_WBBP_GAP_CONFIG_STRU;



/*****************************************************************************
 ṹ    : UCOM_NV_WCDMA_CHANNEL_SWITCH_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFICNV,ͨ
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwRfSignalSwitch;                                      /* RFźŽ */
    PHY_UINT16          uhwMipiSignalSwitch;                                    /* MIPIźŽ */
    PHY_UINT16          uhwAbbTxSignalSwitch;                                   /* ABB TXźŽ */
    PHY_UINT16          uhwAbbRxSignalSwitch;                                   /* ABB RXźŽ */
    PHY_UINT16          uhwPmuSignalSwitch;                                     /* PMUźŽ */
    PHY_UINT16          uhwAptSignalSwitch;                                     /* APTźŽ */
}UCOM_NV_CHANNEL_SWITCH_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_CHANNEL_UNBIND_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : RFICNV,ͨBAND
*****************************************************************************/
typedef struct
{
    PHY_UINT16          uhwMipiUnbindEn;                                         /* MIPIǰʹ */
    PHY_UINT16          uhwMipiCh0Select;                                        /* MIPIͨ0ѡ */
    PHY_UINT16          uhwMipiCh1Select;                                        /* MIPIͨ1ѡ */
    PHY_UINT16          uhwAfcCh0Select;                                         /* AFCͨ0ѡ */
    PHY_UINT16          uhwAfcCh1Select;                                         /* AFCͨ1ѡ */
    PHY_UINT16          uhwAptCh0Select;                                         /* APTͨ0ѡ */
    PHY_UINT16          uhwAptCh1Select;                                         /* APTͨ1ѡ */
    PHY_UINT16          uhwPmuCh0Select;                                         /* PMUͨ0ѡ */
    PHY_UINT16          uhwPmuCh1Select;                                         /* PMUͨ1ѡ */
    PHY_UINT16          uhwAbbTxCh0Select;                                       /* ABB TXͨ0ѡ,6363ʹ */
    PHY_UINT16          uhwAbbTxCh1Select;                                       /* ABB TXͨ1ѡ 6363ʹ*/

}UCOM_NV_CHANNEL_UNBIND_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_MIPI_NOTCH_ADDRESS_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mipi NOTCH Ĵַ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwNotchMipiNum;                                     /* Nothc MipiָuhwNotchControlMode=23ʱЧ */
    PHY_UINT16                              auhwNotchMipiCmd[UCOM_NV_MAX_MIPI_ANT_CMD_NUMBER];   /* Nothc MipiCmduhwNotchControlMode=23ʱЧ */
}UCOM_NV_GSM_MIPI_NOTCH_ADDRESS_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_MIPI_NOTCH_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : mipi NOTCH Ĵ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              auhwNotchMipiData[UCOM_NV_MAX_MIPI_ANT_CMD_NUMBER];     /* Nothc MipiDatauhwNotchControlMode=23ʱЧ */
}UCOM_NV_GSM_MIPI_NOTCH_CTRL_WORD_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_NOTCH_POWER_COMP_STRU
 Э  :
 ASN.1 :
 ṹ˵  :  NOTCH POWER COMP
*****************************************************************************/
typedef struct
{
    PHY_INT16                               shwNotchPowerThreshold;             /* Notch书ʴڸֵʱз书ʲ */
    PHY_INT16                               shwNotchPowerComp;                  /* Notch书ʲֵ */
}UCOM_NV_GSM_NOTCH_POWER_COMP_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_NOTCH_CHAN_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ߿˲ͨĿ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwNotchSupportFlag;                /* DCS1800 TX NOTCHֱ֧־1ʾ֧֣0ʾ֧ */
    PHY_UINT16                              uhwNotchControlMode;                /* NOTCHƷʽ:1ʾGPIOģʽ2ʾMipiʽ3ʾGPIO+MIPIϷʽ */
    PHY_UINT32                              uwNotchGpioValue;                   /* Nothc GPIOֵuhwNotchControlMode=13ʱЧ */
    PHY_UINT16                              uhwReserved;
    UCOM_NV_GSM_MIPI_NOTCH_ADDRESS_STRU     stNotchMipiCmd;                     /* NOTCHͨMIPIӿڿƵַ */
    UCOM_NV_GSM_MIPI_NOTCH_CTRL_WORD_STRU   stNotchMipiCtrlWord;                /* NOTCHͨMIPIӿڿ */
    UCOM_NV_GSM_NOTCH_POWER_COMP_STRU       stNotchPowerComp;                   /* Notch书ʲ */
}UCOM_NV_GSM_NOTCH_CHAN_CTRL_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DFSNV,̬Ƶ,ֻ޸ĺV7R2V9R1
*****************************************************************************/
typedef struct
{
    PHY_UINT32          uwDdrFreq;                                        /* DDRƵ(λKHz)  */
    PHY_UINT32          uwCcpuFreq;                                       /* CCPUƵ(λKHz) */
    PHY_UINT32          uwBusFreq;                                        /* Ƶ(λKHz) */

}UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_MODEM_DFS_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DFSNV,ֻ޸ĺV7R2V9R1
*****************************************************************************/
typedef struct
{
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stCsCfg;                                          /* ģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stDrxCfg;                                         /* ģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stFachCfg;                                        /* FACH̬Profileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stHspaCfg;                                        /* HSPAҵģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stR99PsCfg;                                       /* R99ҵģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stSlaveWorkCfg;                                   /* ģ״̬Profileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stSlaveSleepCfg;                                  /* ģ˯״̬Profileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stMinCfg;                                         /* СProfileֵ */

}UCOM_NV_W_MODEM_DFS_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_W_CS_INTRA_STEP23_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ƵС
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwCsStep23SlotNum;                 /* DRX̬ƵСstep23ʱ϶ͷʼֵΪ1 */
    PHY_UINT16                              uhwCsStep23Period;                  /* DRX̬ƵСڣʼֵΪ3072֡30.72s */
}UCOM_NV_W_CS_INTRA_STEP23_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_QPC_REGDEFAULT_STRU
 Э  :
 ASN.1 :
 ṹ˵  : QPC NV
*****************************************************************************/
typedef struct
{
    PHY_UINT16                      uhwDefaultCloseTime;                 /* ĬϹرʱ     Ĭ80(λ ֡)0QPCδʹ */
    PHY_UINT16                      uhwDefaultGuardTime;                 /* Ĭϱʱ Ĭ20(λ ֡) */
    PHY_UINT16                      uhwDefaultOpenTime;                 /* Ĭݴʱ Ĭ40(λ ֡) */

    PHY_UINT16                      uhwReserve;
}UCOM_NV_QPC_REGDEFAULT_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_G_MODEM_DFS_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : DFSNV,ֻ޸ĺV7R2V9R1
*****************************************************************************/
typedef struct
{
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stCsCfg;                                          /* ҵģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stPsCfg;                                          /* ҵģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stDrxCfg;                                         /* ģʽProfileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stTuningCfg;                                      /* tuning dch״̬Profileֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stSearchingCfg;                                   /* ģʽֵ */
    UCOM_NV_SYS_MODEM_DFS_CONFIG_STRU          stMinCfg;                                         /* СProfileֵ */

}UCOM_NV_G_MODEM_DFS_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_RF_INTERFERE_CONTROL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TDS/LTE߿,ĿǱB39B3Hĸ
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwFuncOn;                      /* 0-ʹܣ1-ʹ */
    PHY_UINT32                                  uwGpioMask;                     /* ߿ */
    PHY_UINT32                                  uwGpioRxValue;                  /* رTDS/LTE߿ */
    PHY_UINT32                                  uwGpioDefaultValue;             /* TDS/LTE߿Ĭֵ */
}UCOM_NV_GSM_RF_INTERFERE_CONTROL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PHASE_ERROR_STANDARD_MODE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : CMUʹstandardģʽgmsk phase errorʱҪôNVΪ1
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwMode;                        /* CMUʹstandardģʽgmsk phase errorʱҪôNVΪ1 */
}UCOM_NV_GSM_PHASE_ERROR_STANDARD_MODE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_ANT_SWITCH_GPIO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TX ANT SWITCHչrf band configһʹã߿ֵʱЧ
*****************************************************************************/
typedef struct
{
    PHY_UINT32                                  uwGpio;                         /* Ӧǰ߿ */
    PHY_UINT32                                  uwResvered;
}UCOM_NV_GSM_TX_ANT_SWITCH_GPIO_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_DUAL_ANT_CTR_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : GSM˫лGPIO
*****************************************************************************/
typedef struct
{
    PHY_UINT32                           uwGsmDualAntClearMask;                 /* ߿ */
    PHY_UINT32                           uwGsmDualAntPriCtrlWord;               /* ߵGPIO */
    PHY_UINT32                           uwGsmDualAntSecCtrlWord;               /* ߵGPIO */
}UCOM_NV_GSM_DUAL_ANT_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PRI_ANT_ESTIMATE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫л׶β
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwGsmAntEstimatePeriodNum;         /* ͳڸ */
    PHY_INT16                               shwGsmAntEstimatePowerCmpThreshold; /* о */
}UCOM_NV_GSM_PRI_ANT_ESTIMATE_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_DUAL_ANT_COMPARE_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫лȽϽ׶β
*****************************************************************************/
typedef struct
{
    PHY_UINT32                              uwGsmAntCompareCollectTime;         /* ɼʱ */
    PHY_UINT16                              uhwGsmAntCompareFirstPeriodNum;     /* ״̬1ͳڸ */
    PHY_UINT16                              uhwGsmAntCompareSecondPeriodNum;    /* ״̬2ͳڸ */
    PHY_UINT16                              uhwGsmAntCompareThirdPeriodNum;     /* ״̬3ͳڸ */
    PHY_INT16                               shwGsmAntCompareFirstPowerCmpThreshold;  /* ״̬1о */
    PHY_INT16                               shwGsmAntCompareSecondPowerCmpThreshold; /* ״̬2о */
    PHY_INT16                               shwGsmAntCompareThirdPowerCmpThreshold;  /* ״̬3о */
}UCOM_NV_GSM_DUAL_ANT_COMPARE_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_DUAL_ANT_PARA_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ˫л
*****************************************************************************/
typedef struct
{
    PHY_UINT16                              uhwGsmDualAntEn;                    /* ˫лʹܱ־ */
    PHY_UINT16                              uhwGsmDualAntAlphaPara;             /* ˫лƽ˲ϵ */
    UCOM_NV_GSM_PRI_ANT_ESTIMATE_PARA_STRU  stGsmPriAntEstimatePara;            /* ˫л׶β */
    UCOM_NV_GSM_DUAL_ANT_COMPARE_PARA_STRU  stGsmDualAntComparePara;            /* ˫лȽϽ׶β */
    PHY_UINT32                              uwGsmAntHandleDelayPara;            /* ˫лĳͲ */
    UCOM_NV_GSM_DUAL_ANT_CTRL_WORD_STRU     stGsmDualAntCtrlWord;               /* ˫лGPIO */
}UCOM_NV_GSM_DUAL_ANT_PARA_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_ANT_SHARE_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ʹܱ־
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwAntShareEn;                  /* 0-֧; 1-֧ */
}UCOM_NV_ANT_SHARE_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_CLOSE_ANT_MIPI_CTRL_WORD_STRU
 Э  :
 ASN.1 :
 ṹ˵  : رMipi
*****************************************************************************/
typedef struct
{
    PHY_UINT16                                  uhwCloseAntEn;                  /* رʹ */
    UCOM_NV_WG_MIPI_ANT_CMD_ADDRESS_STRU        stCloseAntMipiAddress;          /* MipiƵַ */
    UCOM_NV_WG_MIPI_ANT_CTRL_WORD_STRU          stCloseAntMipiCtrlWord;         /* Mipi */
}UCOM_NV_GSM_CLOSE_ANT_MIPI_CTRL_WORD_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_CLOSE_ANT_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ر߿ص߿úMIPI
*****************************************************************************/
typedef struct
{
    UCOM_NV_RF_CONFIG_STRU                      stGsmCloseAntRfConfig;          /* ر߿ */
    UCOM_NV_GSM_CLOSE_ANT_MIPI_CTRL_WORD_STRU   stGsmCloseAntMipiCtrlWord;      /* رMipi */
}UCOM_NV_GSM_CLOSE_ANT_CONFIG_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_VIRTUAL_BAND_ANT_CONFIG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : Ƶε߿
*****************************************************************************/
typedef struct
{
    UCOM_NV_RF_CONFIG_STRU                      stGsmVirtualBandRfConfig;       /* Ƶε߿ */
}UCOM_NV_GSM_VIRTUAL_BAND_ANT_CONFIG_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_MIPI_PA_ENABLE_CTRL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : TX PA CTRL
*****************************************************************************/
typedef struct
{
    UCOM_NV_WG_MMMBPA_CMD_ADDRESS_STRU          stGsmMipiPaEnAddress;           /* mipi pa ʹܿƵַ */
    UCOM_NV_WG_MMMBPA_GAIN_CTRL_WORD_STRU       stGsmMipiPaEnCtrlWord;          /* mipi pa ʹܿ */
}UCOM_NV_GSM_MIPI_PA_ENABLE_CTRL_STRU;


/*****************************************************************************
 ṹ    : UCOM_NV_GSM_PA_MIPI_DATA_EXTEND_STRU
 Э  :
 ṹ˵  : PAĬݣ֧8,ӦCmdFrame,ʽͬCmdFrame
*****************************************************************************/
typedef struct
{
    UCOM_NV_WG_MMMBPA_GAIN_CTRL_WORD_STRU         astMipiDataGain[3];
}UCOM_NV_GSM_PA_MIPI_DATA_EXTEND_STRU;

/*****************************************************************************
 ṹ    : UCOM_NV_GSM_TX_LPF_EN_STRU
 Э  :
 ASN.1 :
 ṹ˵  : е˲ʹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                                 uhwGsmTxLpfEn;                   /* е˲ʹ 0:ʹ,1:ʹ */
    VOS_UINT16                                 uhwRsv;                          /*  */
}UCOM_NV_GSM_TX_LPF_EN_STRU;

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/







#if ((VOS_OS_VER == VOS_WIN32) || (VOS_OS_VER == VOS_NUCLEUS))
#pragma pack()
#else
#pragma pack(0)
#endif



#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif


#endif /* end of PhyNvDefine.h */


