/******************************************************************************

  Copyright(C)2008,Hisilicon Co. LTD.

 ******************************************************************************
  File Name       : NasNvInterface.h
  Description     : NasNvInterface.h header file
  History         :

******************************************************************************/

#ifndef __NASNVINTERFACE_H__
#define __NASNVINTERFACE_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif


/*****************************************************************************
  1 Include Headfile
*****************************************************************************/
#if (VOS_OS_VER != VOS_WIN32)
#pragma pack(4)
#else
#pragma pack(push, 4)
#endif

#include "PsTypeDef.h"

/*****************************************************************************
  2 Macro
*****************************************************************************/
#define NAS_MMC_NV_ITEM_ACTIVE          (1)                                     /* NV */
#define NAS_MMC_NV_ITEM_DEACTIVE        (0)                                     /* NVδ */

/* GPRS GEA 㷨ֺ֧궨 */
#define NAS_MMC_GPRS_GEA1_SUPPORT       (0x01)                                  /* ֧GPRS GEA1㷨 */
#define NAS_MMC_GPRS_GEA1_VALUE         (0x80)                                  /* ֧GEA1ʱֵ */
#define NAS_MMC_GPRS_GEA2_VALUE         (0x40)                                  /* ֧GEA2ʱֵ */
#define NAS_MMC_GPRS_GEA3_VALUE         (0x20)                                  /* ֧GEA3ʱֵ */
#define NAS_MMC_GPRS_GEA4_VALUE         (0x10)                                  /* ֧GEA4ʱֵ */
#define NAS_MMC_GPRS_GEA5_VALUE         (0x08)                                  /* ֧GEA5ʱֵ */
#define NAS_MMC_GPRS_GEA6_VALUE         (0x04)                                  /* ֧GEA6ʱֵ */
#define NAS_MMC_GPRS_GEA7_VALUE         (0x02)                                  /* ֧GEA7ʱֵ */

#define NAS_MMC_GPRS_GEA2_SUPPORT       (0x02)                                  /* ֧GPRS GEA2㷨 */
#define NAS_MMC_GPRS_GEA3_SUPPORT       (0x04)                                  /* ֧GPRS GEA3㷨 */
#define NAS_MMC_GPRS_GEA4_SUPPORT       (0x08)                                  /* ֧GPRS GEA4㷨 */
#define NAS_MMC_GPRS_GEA5_SUPPORT       (0x10)                                  /* ֧GPRS GEA5㷨 */
#define NAS_MMC_GPRS_GEA6_SUPPORT       (0x20)                                  /* ֧GPRS GEA6㷨 */
#define NAS_MMC_GPRS_GEA7_SUPPORT       (0x40)                                  /* ֧GPRS GEA7㷨 */
#define NAS_MMC_NVIM_MAX_EPLMN_NUM      (16)                                    /* en_NV_Item_EquivalentPlmn NVеЧplmn */
#define NAS_MMC_NVIM_MAX_MCC_SIZE       (3)                                     /* plmnMcc󳤶 */
#define NAS_MMC_NVIM_MAX_MNC_SIZE       (3)                                     /* plmnMnc󳤶 */
#define NAS_MMC_LOW_BYTE_MASK           (0x0f)

/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-4, begin */
#define NAS_MMC_NVIM_MAX_USER_CFG_IMSI_PLMN_NUM                  (6)                 /* ûõֵ֧USIM/SIMĸ */
#define NAS_MMC_NVIM_MAX_USER_CFG_EHPLMN_NUM                     (6)                 /* ûõEHplmnĸ */
#define NAS_MMC_MAX_BLACK_LOCK_PLMN_WITH_RAT_NUM            (8)                 /* ֹ뼼PLMN ID */
/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-4, end */

/* Modified by s00190137 for 256 EOPLMN, 2013-11-26, begin */
/* Added by s00190137 for ACC&SPLMN, 2013-10-15 Begin */
#define NAS_MMC_NVIM_MAX_USER_OPLMN_VERSION_LEN               (8)               /* ûõOPLMN汾󳤶 */
#define NAS_MMC_NVIM_MAX_USER_OPLMN_IMSI_NUM                  (6)               /* ûõOPLMNֵ֧USIM/SIMĸ */
#define NAS_MMC_NVIM_MAX_USER_CFG_OPLMN_NUM                   (256)             /* ûõOPLMN */
#define NAS_MMC_NVIM_OPLMN_WITH_RAT_UNIT_LEN                  (5)               /* ûõĴ뼼OPLMNԪȣ6F61ļĻȵԪΪ5 */
#define NAS_MMC_NVIM_MAX_USER_CFG_OPLMN_DATA_LEN              (500)             /* ûOPLMNֽ,ǰֻ֧500*/
#define NAS_MMC_NVIM_MAX_USER_CFG_OPLMN_DATA_EXTEND_LEN       (1280)            /* չûOPLMNֽ*/
/* Added by s00190137 for ACC&SPLMN, 2013-10-15 End */
/* Modified by s00190137 for 256 EOPLMN, 2013-11-26, end */

#define NAS_NVIM_MAX_OPER_SHORT_NAME_LEN                36
#define NAS_NVIM_MAX_OPER_LONG_NAME_LEN                 40

/* Modified by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-4-5, begin */
#define NAS_NVIM_ITEM_MAX_IMSI_LEN          (9)                     /* IMSIĳ */
/* Modified by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-4-5, end */
#define NAS_MML_NVIM_PS_LOCI_SIM_FILE_LEN                    (14)                    /* USIMPSLOCIļĳ */
#define NAS_NVIM_PS_LOCI_SIM_FILE_LEN                    (14)                    /* USIMPSLOCIļĳ */

#define NAS_UTRANCTRL_MAX_NVIM_CFG_TD_MCC_LIST_NUM          (6)                 /* ģʽԶлĿù */
#define NAS_UTRANCTRL_MAX_NVIM_CFG_IMSI_PLMN_LIST_NUM       (6)                 /* ģʽԶлĿUSIM/IMSIŸ */
#define NAS_MML_MAX_DISABLED_RAT_PLMN_NUM               (8)                     /* ֹ뼼PLMN ID */

#define NAS_SIM_FORMAT_PLMN_LEN                     (3)                     /* SimʽPlmn */

#define NAS_MML_NVIM_MAX_BLACK_LOCK_PLMN_NUM                 (16)                    /* ֵ֧PLMN ID */

#define NAS_MML_NVIM_MAX_WHITE_LOCK_PLMN_NUM                 (16)                    /* ֵ֧PLMN ID */

/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, begin */
/*BEGIN DTS2013100908722   c00171433 2013-10-10 modified*/
#if(FEATURE_ON == MBB_WPG_COMMON)
#define NAS_MML_BG_SEARCH_REGARDLESS_MCC_NUMBER       (30)                  /* BGѲǹĹ */
#else
#define NAS_MML_BG_SEARCH_REGARDLESS_MCC_NUMBER         (10)                     /* BGѲǹĹ */
#endif
/*END DTS2013100908722   c00171433 2013-10-10 modified*/
#define NAS_MML_SINGLE_DOMAIN_FAIL_ACTION_MAX_LIST      (5)                     /* ԭֵб */
/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, end */

#define NV_ITEM_NET_CAPABILITY_MAX_SIZE                     (10)

#define NAS_MMC_NVIM_SUPPORTED_3GPP_RELEASE_SIZE            (2)                 /* ǰֵ֧Э汾 */

#define NAS_MMC_NVIM_MAX_IMSI_LEN                           (9)                     /* IMSIĳ */

#define NVIM_MAX_EPLMN_NUM                                  (16)
#define NVIM_MAX_MCC_SIZE                                   (3)
#define NVIM_MAX_MNC_SIZE                                   (3)

#define NVIM_MAX_FDD_FREQ_BANDS_NUM                         (12)

/* Add by z60575 for multi_ssid, 2012-9-5 end */
/*+CGMI - ȡ*/

/* Added by l00208543 for RatBlackListAccordSimType, 2013-11-01, begin */
#define NAS_NVIM_MAX_IMSI_FORBIDDEN_LIST_NUM         (16)
#define NAS_NVIM_MAX_RAT_FORBIDDEN_LIST_NUM          (8)    /* Ԥչ */
#define NAS_NVIM_MAX_SUPPORTED_FORBIDDEN_RAT_NUM     (2)

#define NAS_NVIM_FORBIDDEN_RAT_NUM_0                 (0)
#define NAS_NVIM_FORBIDDEN_RAT_NUM_1                 (1)
#define NAS_NVIM_FORBIDDEN_RAT_NUM_2                 (2)
/* Added by l00208543 for RatBlackListAccordSimType, 2013-11-01, end */


/* NVIDöٵת(PS_NV_ID_ENUM, SYS_NV_ID_ENUM, RF_NV_ID_ENUM) */
typedef VOS_UINT16  NV_ID_ENUM_U16;
#define NV_ITEM_IMEI_SIZE                      16
#define NV_ITEM_SELPLMN_MODE_SIZE              2
#define NV_ITEM_MMA_OPERATORNAME_SIZE          84
#define NV_ITEM_AT_PARA_SIZE                   100
#define NV_ITEM_HPLMN_FIRST_SEARCH_SIZE        1  /* һHPLMNʱ */
/* Modified by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-4-5, begin */
#define NVIM_ITEM_MAX_IMSI_LEN          (9)                     /* IMSIĳ */
/* Modified by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-4-5, end */

/*****************************************************************************
  3 Massage Declare
*****************************************************************************/


/*****************************************************************************
  4 Enum
*****************************************************************************/
/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, begin */
/*****************************************************************************
ö    : NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_ENUM
ṹ˵  : עᱻܣMMCĶ

1.       : 2012611
         : w00166186
  ޸   : AT&T&DCMĿ

2.       : 2014819
         : w00167002
  ޸   : DTS2014081905808:PSעܾ14ʱǰHOME PLMNϣ
               ѭƹң޸ΪACTION:ϴѡHOME
               Ч̽д

*****************************************************************************/
enum NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_ENUM
{
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_PLMN_SELECTION                    = 0,            /*  */
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_NORMAL_CAMP_ON                    = 1,            /* פ */
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_OPTIONAL_PLMN_SELECTION           = 2,            /* ѡ */
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_LIMITED_CAMP_ON                   = 3,            /* פ */
    
    /* Added by w00167002 for DTS2014081905808, 2014-8-19, begin */
    NAS_MMC_NVIM_SINGLE_DOMAIN_ROAMING_REG_FAIL_ACTION_PLMN_SELECTION            = 4,            /* עᷢHOMEϲЧ */
    /* Modified by w00167002 for DTS2014081905808, 2014-8-19, end */
    
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_BUTT
};
typedef VOS_UINT8 NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_ENUM_UINT8;

/*****************************************************************************
ö    : NAS_MMC_NVIM_REG_FAIL_CAUSE_ENUM
ṹ˵  : עʧԶԭֵ

1.       : 2012611
         : w00166186
  ޸   : AT&T&DCMĿ

*****************************************************************************/
enum NAS_MMC_NVIM_REG_FAIL_CAUSE_ENUM
{
    NAS_MMC_NVIM_REG_FAIL_CAUSE_GPRS_SERV_NOT_ALLOW_IN_PLMN = 14,
    NAS_MMC_NVIM_REG_FAIL_CAUSE_TIMER_TIMEOUT               = 301,                                 /* ȴʱʱ */
    NAS_MMC_NVIM_REG_FAIL_CAUSE_BUTT
};
typedef VOS_UINT16 NAS_MMC_NVIM_REG_FAIL_CAUSE_ENUM_UINT16;

/*****************************************************************************
ö    : NAS_MMC_NVIM_REG_DOMAIN_ENUM_UINT8
ṹ˵  : ע

1.       : 2012611
         : w00166186
  ޸   : AT&T&DCMĿ

*****************************************************************************/
enum NAS_MMC_NVIM_REG_DOMAIN_ENUM
{
    NAS_MMC_NVIM_REG_DOMAIN_CS = 1,
    NAS_MMC_NVIM_REG_DOMAIN_PS = 2,                                 /* ȴʱʱ */
    NAS_MMC_NVIM_REG_DOMAIN_BUTT
};
typedef VOS_UINT8 NAS_MMC_NVIM_REG_DOMAIN_ENUM_UINT8;
/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, end */

/* Added by w00176964 for ֧UC2NVŻ, 2013-3-11, begin */
/*****************************************************************************
 ö    : NAS_MMC_UCS2_ENUM
 ö˵  : UCS2 
 ޸ʷ  :
 1.        : 20130311
           : w00176964
   ޸    : ½
*****************************************************************************/

enum NAS_MMC_UCS2_ENUM
{
    NAS_MMC_UCS2_HAS_PREFER                                = 0,
    NAS_MMC_UCS2_NO_PREFER                                 = 1,

    NAS_MMC_UCS2_BUTT
};

typedef VOS_UINT16 NAS_MMC_UCS2_ENUM_UINT16;
/* Added by w00176964 for ֧UC2NVŻ, 2013-3-11, end */

/*****************************************************************************
 ö    : NV_MS_MODE_ENUM_UINT8
 ṹ˵  :  NVм¼ֻģʽ
  1.       : 2011818
           : z00161729
    ޸   : 
  2.       : 2012423
           : w00166186
    ޸   : DTS2012033104746,ػ״̬÷ΪANYЧ
*****************************************************************************/
enum NV_MS_MODE_ENUM
{
    NV_MS_MODE_CS_ONLY,                                                 /* ֧CS */
    NV_MS_MODE_PS_ONLY,                                                 /* ֧PS */
    NV_MS_MODE_CS_PS,                                                   /* CSPS֧ */

    /* Aded by w00166186 for DTS2012033106746, 2012-04-23, begin */
    NV_MS_MODE_ANY,                                                     /* ANY,൱ڽ֧CS */
    /* Aded by w00166186 for DTS2012033106746, 2012-04-23, end */

    NV_MS_MODE_BUTT
};
typedef VOS_UINT8 NV_MS_MODE_ENUM_UINT8;
/*****************************************************************************
  5 STRUCT
*****************************************************************************/
/*****************************************************************************
*                                                                            *
*                           Ϣṹ                                 *
*                                                                            *
******************************************************************************/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_MANUAL_SEARCH_HPLMN_FLG_STRU
 ṹ˵  : NV SrchHplmnFlg_ManualModeĽṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usManualSearchHplmnFlg; /*Range:[0,1]*/
}NAS_MMC_NVIM_MANUAL_SEARCH_HPLMN_FLG_STRU;
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_AUTO_SEARCH_HPLMN_FLG_STRU
 ṹ˵  : NV SrchHplmnFlg_ManualModeĽṹṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/

typedef struct
{
    /* <BEGIN DTS2014042105131 t00173447 2014/2/24 modified */
    VOS_UINT16 usAutoSearchHplmnFlg; /*Range:[0,3]*/
    /* <END DTS2014042105131 t00173447 2014/2/24 modified */
}NAS_MMC_NVIM_AUTO_SEARCH_HPLMN_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_AUTO_SEARCH_HPLMN_FLG_STRU
 ṹ˵  : NV SrchHplmnFlg_AutoModeĽṹṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usEHPlmnSupportFlg; /*Range:[0,1]*/
}NAS_MMC_NVIM_EHPLMN_SUPPORT_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_STK_STEERING_OF_ROAMING_SUPPORT_FLG_STRU
 ṹ˵  : en_NV_Item_Standard_STK_SteeringOfRoaming_Support_FlgĽṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usStkSteeringOfRoamingSupportFlg; /*Range:[0,1]*/
}NAS_MMC_NVIM_STK_STEERING_OF_ROAMING_SUPPORT_FLG_STRU;

/*****************************************************************************
 ṹ    : NVIM_SCAN_CTRL_STRU
 ṹ˵  : ¼en_NV_Item_Scan_Ctrl_Para (9080)NVݣʶƹǷʹ
  1.       : 20120611
           : l60609
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;                        /* en_NV_Item_Scan_Ctrl_Para NVǷ񼤻VOS_TRUE:VOS_FALSE:δ */
    VOS_UINT8                           ucReserved;                             /*  */
}NVIM_SCAN_CTRL_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_PLMN_ID_STRU
 ṹ˵  : PLMNĽṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulMcc;                                  /* MCC,3 bytes */
    VOS_UINT32                          ulMnc;                                  /* MNC,2 or 3 bytes */
}NAS_NVIM_PLMN_ID_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_PLMN_ID_STRU
 ṹ˵  : en_NV_Item_Network_Name_From_MM_InfoĽṹ

 1.       : 2013517
          : l00167671
   ޸   : ½
*****************************************************************************/
typedef struct
{
    NAS_NVIM_PLMN_ID_STRU               stOperatorPlmnId;
    VOS_UINT8                           aucOperatorNameShort[NAS_NVIM_MAX_OPER_SHORT_NAME_LEN];/* ǰפӪ̵Ķ */
    VOS_UINT8                           aucOperatorNameLong[NAS_NVIM_MAX_OPER_LONG_NAME_LEN];  /* ǰפӪ̵ĳ */
}NAS_MMC_NVIM_OPERATOR_NAME_INFO_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_OPER_LOCK_BLACKPLMN_STRU
 ṹ˵  : en_NV_Item_OPERLOCK_PLMN_INFO NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulBlackPlmnLockNum;                     /* ֺ֧ĸ,Ϊ0ʱʾֺ֧ */
    NAS_NVIM_PLMN_ID_STRU               astBlackPlmnId[NAS_MML_NVIM_MAX_BLACK_LOCK_PLMN_NUM];
}NAS_MMC_NVIM_OPER_LOCK_BLACKPLMN_STRU;
/*****************************************************************************
 ṹ    : NAS_MMC_AIS_ROAMING_CFG_STRU
 ṹ˵  : ¼en_NV_Item_AIS_ROAMING_Config NV
 1.       : 2012517
          : z40661
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucEnableFlg;                            /* Ƿ */
    VOS_UINT8                           ucHighPrioRatType;                              /* ֵ֧Ľ뼼 */
    VOS_UINT8                           aucReserve[2];
    NAS_NVIM_PLMN_ID_STRU               stHighPrioPlmnId;                       /* ֵ֧ĸȼPLMN ID ,ʹפHPLMN,PLMNIDȼҲϸ*/
    NAS_NVIM_PLMN_ID_STRU               stSimHPlmnId;                           /* SIMHPLMN ID */
}NAS_MMC_NVIM_AIS_ROAMING_CFG_STRU;
 /* Added by l00130025 for DTS2012012903053, 2012-05-15 begin */

/*****************************************************************************
 ṹ    : NAS_MML_USER_AUTO_RESEL_CFG_STRU
 ṹ˵  : ¼en_NV_Item_User_Auto_Resel_Switch NV,UserReseclǷʹ
 1.       : 2012515
          : l00130025
   ޸   : DTS2012012903053:Ts23.122 ch4.4.3.2.1 Auto user reselecton֧
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucAutoReselActiveFlg;                   /* ǷLTEα:VOS_TRUE ʾLTE VOS_FALSE ʾֹLTE */
    VOS_UINT8                           ucReserve;
}NAS_MMC_NVIM_USER_AUTO_RESEL_CFG_STRU;
/* Added by l00130025 for DTS2012012903053, 2012-05-15 end */
/* Added by l00130025 for DTS2012060400029, 2012-06-09 begin */

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_PRIO_HPLMNACT_CFG_STRU
 ṹ˵  :  en_NV_Item_PRIO_HPLMNACT_CFG NVṹ
 1.       : 201269
          : l00130025
   ޸   : DTS2012060400029:ӶHPLMNActȽ뼼ĶƣĿǰUSimHPLMNACTܶ಻֧L
*****************************************************************************/
typedef struct
{
    VOS_UINT8                            ucStatus;        /* NVЧ־, 1: Ч0Ч */
	VOS_UINT8                            ucReserved;      /* ֽڶ */
    VOS_UINT16                           usPrioHplmnAct;      /*ƵȽ뼼*/
}NAS_MMC_NVIM_PRIO_HPLMNACT_CFG_STRU;

/*****************************************************************************
 ṹ    : NAS_MML_NVIM_AVAIL_TIMER_CFG_STRU
 ṹ˵  : en_NV_Item_SEARCH_TIMER_INFO NVṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulFirstSearchTimeLen;                   /* available timerʱһεʱ */
    VOS_UINT32                          ulFirstSearchTimeCount;                 /* available timerʱһεĴ */
    VOS_UINT32                          ulDeepSearchTimeLen;                    /* available timerʱ˯ʱ */
    VOS_UINT32                          ulDeepSearchTimeCount;
}NAS_MMC_NVIM_AVAIL_TIMER_CFG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_OPER_LOCK_WHITEPLMN_STRU
 ṹ˵  : en_NV_Item_OPERLOCK_PLMN_INFO_WHITE NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulWhitePlmnLockNum;                     /* ְ֧ĸ,Ϊ0ʱʾְ֧ */
    NAS_NVIM_PLMN_ID_STRU               astWhitePlmnId[NAS_MML_NVIM_MAX_WHITE_LOCK_PLMN_NUM];
}NAS_MMC_NVIM_OPER_LOCK_WHITEPLMN_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_CPHS_SUPPORT_FLG_STRU
 ṹ˵  : en_NV_Item_SUPPORT_CPHS_FLAG NVṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usSupportFlg; /*Range:[0,1]*/
}NAS_MMC_NVIM_CPHS_SUPPORT_FLG_STRU;

/* Added by l60609 for B060 Project, 2012-2-20, Begin   */
/*****************************************************************************
 ṹ    : NAS_PREVENT_TEST_IMSI_REG_STRU
 ṹ˵  : en_NV_Item_PREVENT_TEST_IMSI_REGṹ
  1.       : 2012222
           : w00199382
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucStatus;                               /*Ƿ񼤻01 */
    VOS_UINT8                               ucActFlg;
}NAS_PREVENT_TEST_IMSI_REG_STRU;
/* Added by l60609 for B060 Project, 2012-2-20, End   */
/*****************************************************************************
*                                                                            *
*                           Ϣṹ                                 *
*                                                                            *
******************************************************************************/

/*****************************************************************************
 ṹ    : NAS_PREVENT_TEST_IMSI_REG_STRU
 ṹ˵  : en_NV_Item_PREVENT_TEST_IMSI_REGṹ
  1.       : 2012222
           : w00199382
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucHplmnSearchPowerOn;
    VOS_UINT8   ucReserve;
}NAS_MMC_NVIM_HPLMN_SEARCH_POWERON_STRU;

/* Modified by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-4-5, begin */

/*****************************************************************************
 ṹ    : NAS_PREVENT_TEST_IMSI_REG_STRU
 ṹ˵  : NAS_PREVENT_TEST_IMSI_REG_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucTinType;                              /* TIN */
    VOS_UINT8                           aucReserve[2];
    VOS_UINT8                           aucImsi[NAS_NVIM_ITEM_MAX_IMSI_LEN];        /* ϴαIMSI */
}NAS_NVIM_TIN_INFO_STRU;

/*****************************************************************************
 ṹ    : NAS_PREVENT_TEST_IMSI_REG_STRU
 ṹ˵  : NAS_PREVENT_TEST_IMSI_REG_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT32 ulAutoStart;
}NAS_MMA_NVIM_AUTO_START_STRU;


/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SINGLE_DOMAIN_FAIL_CNT_STRU
 ṹ˵  : en_NV_Item_SINGLE_DOMAIN_FAIL_SRCH_PLMN_CNT NVṹ
  1.       : 201185
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucSingleDomainFailPlmnSrchFlag;         /* DT󣬵עᱻܺҪ */
    VOS_UINT8                           ucReserved;                             /* */
}NAS_MMC_NVIM_SINGLE_DOMAIN_FAIL_CNT_STRU;

/*****************************************************************************
 ṹ    : NAS_PREVENT_TEST_IMSI_REG_STRU
 ṹ˵  : NAS_PREVENT_TEST_IMSI_REG_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT8  aucPsLocInfo[NAS_NVIM_PS_LOCI_SIM_FILE_LEN];
}NAS_NVIM_PS_LOCI_SIM_FILES_STRU;

/*****************************************************************************
 ṹ    : NAS_MML_NVIM_GPRS_GEA_ALG_CTRL_STRU
 ṹ˵  : en_NV_Item_GEA_SUPPORT_CTRL NVṹ
 1.       : 2011714
          : z00161729
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                          ucStatus;                                /* NVǷ񼤻־, 0: 1:  */
    VOS_UINT8                          ucGeaSupportCtrl;                        /* ն:GPRS GEA㷨ֿ֧ */
}NAS_MMC_NVIM_GPRS_GEA_ALG_CTRL_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_LTE_CS_SERVICE_CFG_STRU
 ṹ˵  : ¼en_NV_Item_Lte_Cs_Service_Config NVݣLTEֵ֧csҵ
  1.       : 20111028
           : z00161729
    ޸   : ½
  2.       : 20130924
           : s00217060
    ޸   : VoLTE_PhaseIIĿ޸Ľṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;    /* en_NV_Item_Lte_Cs_Service_Config NVǷ񼤻VOS_TRUE:VOS_FALSE:δ */
    VOS_UINT8                           ucLteCsServiceCfg;  /* LTEֵ֧ csҵ*/
}NAS_NVIM_LTE_CS_SERVICE_CFG_STRU;
/* Added by z00161729 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-2-14, begin */

/* Added by w00167002 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-2-25, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_HO_WAIT_SYSINFO_TIMER_CFG_STRU
 ṹ˵  : NVIMеCSFB HO̵ϵͳϢʱNVδ򲻵ϵͳϢֱע
 1.       : 2012214
          : z00161729
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;
    VOS_UINT8                           ucWaitSysinfoTimeLen;
}NAS_MMC_NVIM_HO_WAIT_SYSINFO_TIMER_CFG_STRU;
/* Added by w00167002 for V7R1C50 CSFB&PPAC&ETWS&ISR, 2012-2-25, end */



/* delete by z00234330 for DTS201300600336, 2013-10-09, begin */
/* delete by z00234330 for DTS201300600336, 2013-10-09, end */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_LTE_INTERNATIONAL_ROAM_CFG_STRU
 ṹ˵  : en_NV_Item_Lte_Internation_Roam_Config NVṹ
 1.       : 2012314
          : w00176964
   ޸   : ½
 2.       : 2012425
          : w00176964
   ޸   : DTS2012042403564:޸NVȡĽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucLteRoamAllowedFlg;
    VOS_UINT8                           aucReserve[1];
    VOS_UINT8                           aucRoamEnabledMccList[20];/* εĹб */
}NAS_MMC_NVIM_LTE_INTERNATIONAL_ROAM_CFG_STRU;

/* <BEGIN DTS2014042105131 t00173447 2014/2/24 modified */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ROAM_RPLMN_SEARCH_CFG_STRU
 ṹ˵  : en_NV_Item_Roam_Search_Rplmn_Config NVṹ
 1.       : 2014224
          : t00173447
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucRoamRplmnflg;
    VOS_UINT8                           aucReserve[3];
    VOS_UINT32                         aucRoamEnabledMccList[5];/* εĹб */
}NAS_MMC_NVIM_ROAM_SEARCH_RPLMN_CFG_STRU;
/* END DTS2014042105131 t00173447 2014/2/24 modified> */

/* Modified by w00176964 for ֧UC2NVŻ, 2013-3-11, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_CLOSE_SMS_CAPABILITY_CFG_STRU
 ṹ˵  : en_NV_Item_Close_SMS_Capability_Config NVṹ
 1.       : 2013311
          : w00176964
   ޸   : close sms capability NVṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucActFlg;
    VOS_UINT8                           aucReserved[3];
}NAS_NVIM_CLOSE_SMS_CAPABILITY_CFG_STRU;
/* Modified by w00176964 for ֧UC2NVŻ, 2013-3-11, end */

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_WCDMA_PRIORITY_GSM_STRU
 ṹ˵  : en_NV_Item_NVIM_WCDMA_PRIORITY_GSM_SUPPORT_FLG NVṹ
  1.       : 20120303
           : S62952
    ޸   : ½
  2.       : 20131213
           : z00161729
    ޸   : DTS2013121206933:Ǹȼøߵ簴syscfgý뼼ȼ9055 nv
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucWcdmaPriorityGsmFlg;                  /* H3GWG*/

    /* Modified by z00161729 for DTS2013121206933, 2013-12-13, begin */
    VOS_UINT8                           ucSortAvailalePlmnListRatPrioFlg;    /* Ƿsyscfgý뼼ȼߵбʶ1:; 0:Ǹ簴粻*/
    /* Modified by z00161729 for DTS2013121206933, 2013-12-13, end */
}NAS_MMC_NVIM_WCDMA_PRIORITY_GSM_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_PS_ONLY_CS_SERVICE_SUPPORT_FLG_STRU
 ṹ˵  : en_NV_Item_NVIM_PS_ONLY_CS_SERVICE_SUPPORT_FLG NVṹ
  1.       : 20120303
           : S62952
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucPsOnlyCsServiceSupportFlg;            /* ΪPS ONLYʱǷ֧CSźͺҵ(г)*/
    VOS_UINT8                           ucReserved;                             /* */
}NAS_NVIM_PS_ONLY_CS_SERVICE_SUPPORT_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_CC_NVIM_CCBS_SUPPORT_FLG_STRU
 ṹ˵  : en_NV_Item_NVIM_CCBS_SUPPORT_FLG NVṹ
  1.       : 20120303
           : S62952
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucCcbsSupportFlg;                       /* CCBS(æ)ҵ*/
    VOS_UINT8                           ucReserved;                             /* */
}NAS_NVIM_CCBS_SUPPORT_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_HPLMN_SEARCH_REGARDLESS_MCC_SUPPORT_STRU
 ṹ˵  : en_NV_Item_HPLMN_SEARCH_REGARDLESS_MCC_SUPPORT NVṹ
 1.       : 2012611
          : W00166186
   ޸   : AT&T&t&DCM½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;
    VOS_UINT8                           ucCustomMccNum;
    VOS_UINT8                           aucReserve[2];
    VOS_UINT32                          aulCustommMccList[10];                   /* εĹб */
}NAS_MMC_NVIM_HPLMN_SEARCH_REGARDLESS_MCC_SUPPORT_STRU;

/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, begin */

/*****************************************************************************
 ṹ    : NVIM_ACTING_HPLMN_SUPPORT_FLAG_STRU
 ṹ˵  : en_NV_Item_ACTING_PLMN_SUPPORT_FLAG NVṹ
  1.       : 20110611
           : W00166186
    ޸   : AT&T&DCM½ṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;
    VOS_UINT8                           ucReserved;
}NVIM_ACTING_HPLMN_SUPPORT_FLAG_STRU;

/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, end */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_REG_FAIL_NETWORK_FAILURE_CUSTOM_FLG_STRU
 ṹ˵  : en_NV_Item_CS_FAIL_NETWORK_FAILURE_PLMN_SEARCH_FLAG NVṹ
  1.       : 20110611
           : W00166186
    ޸   : AT&T&DCM½ṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlg;
    VOS_UINT8                           ucReserved;                             /* */
}NAS_MMC_NVIM_REG_FAIL_NETWORK_FAILURE_CUSTOM_FLG_STRU;

/* Added by w00166186 for V7R1C50 AT&T&DCM, 2012-6-11, begin */


/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SINGLE_DOMAIN_FAIL_ACTION_LIST_STRU
 ṹ˵  : עᱻܶƶṹ
 1.       : 2012611
          : W00166186
   ޸   : AT&T&t&DCM½
*****************************************************************************/
typedef struct
{
    NAS_MMC_NVIM_REG_FAIL_CAUSE_ENUM_UINT16                 enRegCause;
    NAS_MMC_NVIM_REG_DOMAIN_ENUM_UINT8                      enDomain;
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_ENUM_UINT8   enAction;
}NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_STRU;


/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SINGLE_DOMAIN_FAIL_ACTION_LIST_STRU
 ṹ˵  : עᱻܶen_NV_Item_SINGLE_DOMAIN_FAIL_ACTION_LISTṹ
 1.       : 2012611
          : W00166186
   ޸   : AT&T&t&DCM½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                                               ucActiveFlag;
    VOS_UINT8                                               ucCount;
    VOS_UINT8                                               auReserv[2];
    NAS_MMC_NVIM_SINGLE_DOMAIN_REG_FAIL_ACTION_STRU         astSingleDomainFailActionList[NAS_MML_SINGLE_DOMAIN_FAIL_ACTION_MAX_LIST];
}NAS_MMC_NVIM_SINGLE_DOMAIN_FAIL_ACTION_LIST_STRU;

/*****************************************************************************
 ṹ    : NAS_SIM_FORMAT_PLMN_ID
 ṹ˵  : Sim PLMN IDĴ洢ṹ
 1.       : 2011528
          : zhoujun 40661
   ޸   : ½
*****************************************************************************/
typedef struct {
    VOS_UINT8                           aucSimPlmn[NAS_SIM_FORMAT_PLMN_LEN];
    VOS_UINT8                           aucReserve[1];
}NAS_SIM_FORMAT_PLMN_ID;

/*****************************************************************************
 ṹ    : NAS_UTRANCTRL_NVIM_CURRENT_UTRAN_MODE_STRU
 ṹ˵  : ¼en_NV_Item_Utran_Mode NV
 1.       : 2012713
          : w00167002
   ޸   : V7R1C50_GUTL_PhaseI:¼
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucUtranMode;                            /* ǰֵ֧UTRANģʽ */
    VOS_UINT8                           ucReserve;
}NAS_UTRANCTRL_NVIM_UTRAN_MODE_STRU;

/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, begin */
/*****************************************************************************
 ṹ    : NAS_UTRANCTRL_NVIM_UTRAN_MODE_AUTO_SWITCH_STRU
 ṹ˵  : ¼en_NV_Item_Utran_Mode_Auto_Switch NV
 1.       : 201287
          : w00167002
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucUtranSwitchMode;                      /* 0UTRANģʽΪFDD 1UTRANģʽΪTDD 2:AUTO SWITCH */
    VOS_UINT8                           ucTdMccListNum;                         /* ֧TDĹҺŸ */
    VOS_UINT8                           ucImsiPlmnListNum;                      /* IMS PLMNUTRANģʽǷAUTO SWITCHʱǰIMSIPLMNڴбеĶ֧Զл̶ΪWģ */
    VOS_UINT8                           aucReserve[1];

    VOS_UINT32                          aulTdMccList[NAS_UTRANCTRL_MAX_NVIM_CFG_TD_MCC_LIST_NUM];
    NAS_SIM_FORMAT_PLMN_ID              astImsiPlmnList[NAS_UTRANCTRL_MAX_NVIM_CFG_IMSI_PLMN_LIST_NUM];
}NAS_UTRANCTRL_NVIM_UTRAN_MODE_AUTO_SWITCH_STRU;

/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-8, end */

/* Added by w00167002 for DTS2013112006986, 2013-11-18, begin */


/*****************************************************************************
 ṹ    : NAS_UTRANCTRL_NVIM_SMC_CTRL_FLAG_STRU
 ṹ˵  : en_NV_Item_UTRAN_TDD_SMC_FLAG NVṹ
 1.       : 2013725
          : w00167002
   ޸   : 3G TDDģʽǷҪSMC֤:йƶ豸
                TD²SMC̡
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucIsUtranTddCsSmcNeeded;                /* 3G TDDģʽǷҪCS SMC֤:0-Ҫ1-Ҫ */
    VOS_UINT8                           ucIsUtranTddPsSmcNeeded;                /* 3G TDDģʽǷҪPS SMC֤:0-Ҫ1-Ҫ */
    VOS_UINT8                           aucReserved[2];                         /*  */
}NAS_UTRANCTRL_NVIM_SMC_CTRL_FLAG_STRU;

/* Added by w00167002 for DTS2013112006986, 2013-11-18, end */

/* Added by s00190137 for ACC&SPLMN, 2013-10-15 Begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ACC_BAR_PLMN_SEARCH_FLG_STRU
 ṹ˵  : NAS_MMC_NVIM_ACC_BAR_PLMN_SEARCH_FLG_STRUṹƷHPLMN/RPLMN
             ֹǷPLMN en_NV_Item_ACC_BAR_PLMN_SEARCH_FLG
 1.       : 20131015
          : s00190137
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucAccBarPlmnSearchFlg;
    VOS_UINT8   aucReserve[3];
}NAS_MMC_NVIM_ACC_BAR_PLMN_SEARCH_FLG_STRU;


/* Modified by s00190137 for 256 EOPLMN, 2013-11-26, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_USER_CFG_OPLMN_INFO_STRU
 ṹ˵  : NAS_MMC_NVIM_USER_CFG_OPLMN_INFO_STRU NVIMеûõOPLMN
 1.       : 20131015
          : s00190137
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucActiveFlg;                                          /* ʹܱ־ */
    VOS_UINT8                           ucImsiCheckFlg;                                       /* ǷIMSIбİ0:Ҫ 1:Ҫ */
    VOS_UINT8                           aucVersion[NAS_MMC_NVIM_MAX_USER_OPLMN_VERSION_LEN];  /* õİ汾 */
    VOS_UINT8                           ucImsiPlmnListNum;                                    /* ƵIMSIб */
    VOS_UINT8                           ucOplmnListNum;                                       /* õOplmnĸ */
    NAS_SIM_FORMAT_PLMN_ID              astImsiPlmnList[NAS_MMC_NVIM_MAX_USER_OPLMN_IMSI_NUM];
    VOS_UINT8                           aucOPlmnList[NAS_MMC_NVIM_MAX_USER_CFG_OPLMN_DATA_LEN];/* OPLMNPDUݣEFOplmnļһ */
}NAS_MMC_NVIM_USER_CFG_OPLMN_INFO_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_USER_CFG_OPLMN_EXTEND_STRU
 ṹ˵  : NAS_MMC_NVIM_USER_CFG_OPLMN_EXTEND_STRU NVIMеûõOPLMN
 1.       : 20131126
   ޸   : NVֵ֧OPLMNչ256
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucActiveFlg;                                          /* ʹܱ־ */
    VOS_UINT8                           ucImsiCheckFlg;                                       /* ǷIMSIбİ0:Ҫ 1:Ҫ */
    VOS_UINT8                           aucVersion[NAS_MMC_NVIM_MAX_USER_OPLMN_VERSION_LEN];  /* õİ汾 */
    VOS_UINT16                          usOplmnListNum;                                       /* õOplmnĸ */
    VOS_UINT8                           ucImsiPlmnListNum;                                    /* ƵIMSIб */
    VOS_UINT8                           aucReserve[3];
    NAS_SIM_FORMAT_PLMN_ID              astImsiPlmnList[NAS_MMC_NVIM_MAX_USER_OPLMN_IMSI_NUM];
    VOS_UINT8                           aucOPlmnList[NAS_MMC_NVIM_MAX_USER_CFG_OPLMN_DATA_EXTEND_LEN];/* OPLMNPDUݣEFOplmnļһ */
}NAS_MMC_NVIM_USER_CFG_OPLMN_EXTEND_STRU;
/* Added by s00190137 for ACC&SPLMN, 2013-10-15 End */
/* Modified by s00190137 for 256 EOPLMN, 2013-11-26, end */

/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-10, begin */

/*****************************************************************************
 ṹ    : NAS_MML_USER_CFG_EHPLMN_INFO_STRU
 ṹ˵  : en_NV_Item_User_Cfg_Ehplmn NVIMеûõEhplmn List
 1.       : 201289
          : w00167002
   ޸   : V7R1C50_GUTL_PhaseII:CMCCEHPLMN
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucImsiPlmnListNum;                      /* ƵIMSIб */
    VOS_UINT8                           ucEhplmnListNum;                        /* ûõEHplmnĸ */
    VOS_UINT8                           aucReserve[2];
    NAS_SIM_FORMAT_PLMN_ID              astImsiPlmnList[NAS_MMC_NVIM_MAX_USER_CFG_IMSI_PLMN_NUM];
    NAS_SIM_FORMAT_PLMN_ID              astEhPlmnList[NAS_MMC_NVIM_MAX_USER_CFG_EHPLMN_NUM];
}NAS_MMC_NVIM_USER_CFG_EHPLMN_INFO_STRU;
/* Added by w00167002 for V7R1C50_GUTL_PhaseII, 2012-8-10, end */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_PLMN_WITH_RAT_STRU
 ṹ˵  : NAS MML PLMNͽ뼼ṹ
 1.       : 201289
          : w00176964
   ޸   : 
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulMcc;                                  /* MCC,3 bytes */
    VOS_UINT32                          ulMnc;                                  /* MNC,2 or 3 bytes */
    VOS_UINT8                           enRat;
    VOS_UINT8                           aucReserve[3];
}NAS_MMC_NVIM_PLMN_WITH_RAT_STRU;


/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_DISABLED_RAT_PLMN_INFO_STRU
 ṹ˵  : en_NV_Item_DISABLED_RAT_PLMN_INFO NVṹ
  1.       : 2012815
           : w00176964
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulDisabledRatPlmnNum;                   /* ֹֽ֧뼼PLMN,Ϊ0ʾָ֧ */
    NAS_MMC_NVIM_PLMN_WITH_RAT_STRU     astDisabledRatPlmnId[NAS_MML_MAX_DISABLED_RAT_PLMN_NUM];/* ֹ뼼PLMNRATϢ */
}NAS_MMC_NVIM_DISABLED_RAT_PLMN_INFO_STRU;
/* Added by w00176964 for  V7R1C50_GUTL_PhaseII, 2012-8-15, end */

/* Added by l00208543 for RatBlackListAccordSimType, 2013-11-01, begin */
/*****************************************************************************
 ö    : NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_FLAG_ENUM
 ṹ˵  : 
 1.    : 20131101
       : l00208543
   ޸: 
*****************************************************************************/
enum NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_FLAG_ENUM
{
    NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_INACTIVE                   = 0,           /* δ */                     
    NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_BLACK                      = 1,           /*  */                 
    NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_WHITE                      = 2,           /*  */ 
    NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_BUTT
};
typedef VOS_UINT8 NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_FLAG_ENUM_UINT8;

/*****************************************************************************
 ö    : NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_ENUM
 ṹ˵  : 
 1.    : 20131101
       : l00208543
   ޸: 
*****************************************************************************/
enum NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_ENUM
{
    NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_GERAN                   = 0,           /* GERAN */                     
    NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_UTRAN                   = 1,           /* UTRANWCDMA/TDS-CDMA */                 
    NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_EUTRAN                  = 2,           /* E-UTRAN */ 
    NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_BUTT
};
typedef VOS_UINT8 NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_ENUM_UINT8;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_STRU
 ṹ˵  : en_NV_Item_Rat_Forbidden_List_Accord_Imsi_Config NVṹ
  1.       : 20131101
           : l00208543
    ޸   : ½

    ucSwitchFlag        ͣ0
                                  1: astImsiPlmnList ڵĿýֹRATܣ
                                  2ԲastImsiPlmnList еĿýֹRAT
    ucImsiPlmnListNum   SIMĿ֧16
    ucForbidRatListNum  ֹRATĿֵ֧ 8Ŀǰ֧NVýֹLTEֹ߽LTE+UTRAN
                                                       NVֹʽΪǷǷ
    astImsiPlmnList     SIMб֧16
    aucForbidRatList    ֹRATֵ֧ 2Ŀǰ֧NVýֹLTEֹ߽LTE+UTRAN
                                                   NVֹʽΪǷǷ
                        0: GSM
                        1: UTRAN
                        2: E-UTRAN
                        ֵΪЧֵ
*****************************************************************************/
typedef struct
{
    NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_SWITCH_FLAG_ENUM_UINT8  enSwitchFlag;                                         /*ǷЧܵ  */
    VOS_UINT8                                               ucImsiListNum;                                        /*ЧSIMĿ(/)  */
    VOS_UINT8                                               ucForbidRatNum;                                       /*ֹRATĿ  */
    VOS_UINT8                                               aucReserve[1];
    NAS_SIM_FORMAT_PLMN_ID                                  astImsiList[NAS_NVIM_MAX_IMSI_FORBIDDEN_LIST_NUM];        /* SIMб (/) */
    NAS_MMC_NVIM_PLATFORM_SUPPORT_RAT_ENUM_UINT8            aenForbidRatList[NAS_NVIM_MAX_RAT_FORBIDDEN_LIST_NUM];    /*ֹĽ뼼  */
}NAS_MMC_NVIM_RAT_FORBIDDEN_LIST_STRU;
/* Added by l00208543 for RatBlackListAccordSimType, 2013-11-01, end */

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_CSFB_EMG_CALL_LAI_CHG_LAU_FIRST_CFG_STRU
 ṹ˵  : NVIMеcsfb gulaiı䣬mmȽlauȽк
 1.       : 2012814
          : z00161729
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucCsfbEmgCallLaiChgLauFirstFlg;
    VOS_UINT8                           aucRserved[1];
}NAS_MMC_NVIM_CSFB_EMG_CALL_LAI_CHG_LAU_FIRST_CFG_STRU;
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_PLMN_EXACTLY_COMPARE_FLAG_STRU
 ṹ˵  : en_NV_Item_PLMN_EXACTLY_COMPARE_FLG NVṹ
  1.       : 20120816
           : t00212959
    ޸   : DCM,½ṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucPlmnExactlyCompareFlag;
    VOS_UINT8                           aucRsv[3];                         /* */
}NAS_MMC_NVIM_PLMN_EXACTLY_COMPARE_FLAG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_HPLMN_REGISTER_CTRL_FLAG_STRU
 ṹ˵  : en_NV_Item_Hplmn_Register_Ctrl_Flg NVṹ
 1.       : 20121129
          : w00176964
   ޸   : HPLMNעᱻܺǷע
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucHplmnRegisterCtrlFlg;                 /* HPLMNעƱ */
    VOS_UINT8                           aucRsv[3];                              /*  */
}NAS_MMC_NVIM_HPLMN_REGISTER_CTRL_FLAG_STRU;
/* Added by w00176964 for DTS2012112902395, 2012-11-29, end */
/*****************************************************************************
ṹ    : NAS_NVIM_CELL_SIGN_REPORT_CFG_STRU
ṹ˵  : źϱϢ
1.      : 20121121
        : z00161729
  ޸  : ֧^cerssiṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                                               ucSignThreshold;    /* źű仯,RSSI仯ֵ
                                                                                  Ҫϱźȡֵ0ʾ㰴Ĭֵ */
    /* Modified by t00212959 for DTS2013010809978, 2013-1-9, begin */
    VOS_UINT8                                               ucMinRptTimerInterval;     /* ϱʱ   */
    /* Modified by t00212959 for DTS2013010809978, 2013-1-9, end */
} NAS_NVIM_CELL_SIGN_REPORT_CFG_STRU;
/* Modified by z00161729 for cerssi and cnmr, 2012-11-21, end */

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_H3G_CTRL_FLAG_STRU
 ṹ˵  : en_NV_Item_H3g_Ctrl_Flg NVṹ
 1.       : 2013410
          : w00176964
   ޸   : H3GƳƱ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucH3gCtrlFlg;                           /* H3GƱ */
    VOS_UINT8                           aucRsv[3];                              /*  */
}NAS_MMC_NVIM_H3G_CTRL_FLAG_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_UCS2_CUSTOMIZATION_STRU
 ṹ˵  : NAS_MMC_NVIM_UCS2_CUSTOMIZATION_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ֲ
*****************************************************************************/
typedef struct
{
    VOS_UINT16  usUcs2Customization;
}NAS_MMC_NVIM_UCS2_CUSTOMIZATION_STRU;

/*****************************************************************************
 ṹ    : SMS_TIMER_LENGTH_STRU
 ṹ˵  : Э鶨ʱʱṹ

1.        : 20121228
          : l00167671
   ޸   : ṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT16                          usTc1mLength;
    VOS_UINT16                          usTr1mLength;
    VOS_UINT16                          usTr2mLength;
    VOS_UINT16                          usTramLength;
}SMS_NVIM_TIMER_LENGTH_STRU;

/* Add by z40661 for DTS2012101809567 , 2012-09-25, end */

/*****************************************************************************
 ṹ    : NVIM_PRIVATE_CMD_STATUS_RPT_STRU
 ṹ˵  : ǷϱϢ
 1.       : 2013510
          : s00217060
   ޸   : ϱATCĿϱNVṹ嶨
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻־, 0: 1:  */
    VOS_UINT8                           ucStatusRptGeneralControl;        /* ˽Ƿ״̬ϱ 0:ϱ1:ϱ */
}NVIM_PRIVATE_CMD_STATUS_RPT_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SPECIAL_ROAM_STRU
 ṹ˵  : en_NV_Item_Special_Roam_Flag NVṹ
  1.       : 2011720
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻־, 0: 1:   */
    VOS_UINT8                           ucSpecialRoamFlg;                         /* VplmnHplmnͬʱ,ǷصHplmn,1:0: */
}NAS_MMC_NVIM_SPECIAL_ROAM_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ENHANCED_HPLMN_SRCH_FLG_STRU
 ṹ˵  : NAS_MMC_NVIM_ENHANCED_HPLMN_SRCH_FLG_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usEnhancedHplmnSrchFlg;
}NAS_MMC_NVIM_ENHANCED_HPLMN_SRCH_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_CC_NVIM_CCBS_SUPPORT_FLG_STRU
 ṹ˵  : NAS_CC_NVIM_CCBS_SUPPORT_FLG_STRUṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucCcbsSupportFlg;
    VOS_UINT8   ucReserve;
}NAS_CC_NVIM_CCBS_SUPPORT_FLG_STRU;

/* Added by l00208543 for DTS2013082902121, 2013-8-30, begin */
/*****************************************************************************
 ṹ    : NAS_CC_NVIM_TIMER_LEN_STRU
 ṹ˵  : NAS_CC_NVIM_TIMER_LEN_STRUṹen_NV_Item_CC_TimerLen
  1.       : 2013830
           : l00208543
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucT305Len;
    VOS_UINT8   ucT308Len;
    VOS_UINT8   aucReserve[2];
}NAS_CC_NVIM_TIMER_LEN_STRU;
/* Added by l00208543 for DTS2013082902121, 2013-8-30, end */

/* Added by l00208543 for DTS2013111904411, 2013-11-19, begin */
/*****************************************************************************
 ö    : NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_ENUM
 ṹ˵  : ޸ľܾԭֵշ
  1.       : 20131119
           : l00208543
    ޸   : 
*****************************************************************************/
enum NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_ENUM
{
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_INACTIVE,      /* ܲЧ */
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_CS_PS,         /* ޸CS+PSľܾԭֵ */                                         
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_CS_ONLY,       /* ޸CSľܾԭֵ */                                     
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_PS_ONLY,       /* ޸PSľܾԭֵ */
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_BUTT
};
typedef VOS_UINT8 NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_ENUM_UINT8;

/* Added by l00208543 for DTS2013111904411, 2013-11-19, end */
/* Added by l00208543 for DTS2013100904573, 2013-10-09, begin */
/*****************************************************************************
 ṹ    : NAS_NVIM_CHANGE_REG_REJECT_CAUSE_FLG_STRU
 ṹ˵  : NAS_NVIM_CHANGE_REG_REJECT_CAUSE_FLG_STRUṹen_NV_Item_ChangeRejectCause_Flg
  1.       : 20131009
           : l00208543
    ޸   : ½
  2.       : 20131119
           : l00208543
    ޸   : ޸ģλΪö٣ӵ
*****************************************************************************/
typedef struct
{
    /* Added by l00208543 for DTS2013111904411, 2013-11-19, begin */
    NAS_NVIM_CHANGE_REG_REJ_CAUSE_TYPE_ENUM_UINT8           enChangeRegRejCauCfg;
    /* Added by l00208543 for DTS2013111904411, 2013-11-19, end */
    VOS_UINT8   ucPreferredRegRejCau_HPLMN_EHPLMN;             /* HPLMN/EHPLMNʱʹõľܾԭֵ */
    VOS_UINT8   ucPreferredRegRejCau_NOT_HPLMN_EHPLMN;         /* HPLMN/EHPLMNʱʹõľܾԭֵ */
    VOS_UINT8   aucReserve[1];
}NAS_NVIM_CHANGE_REG_REJECT_CAUSE_FLG_STRU;
/* Added by l00208543 for DTS2013100904573, 2013-10-09, end */

/* Added byl00215384 for DTS2014021006453, 2014-02-18, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_IGNORE_AUTH_REJ_CFG_STRU
 ṹ˵  : en_NV_Item_Remove_Auth_Rej_CFG NVṹ

  
 1.       : 2014218
          : l00215384
   ޸   : ½
*****************************************************************************/
typedef struct
{
   VOS_UINT8                           ucIgnoreAuthRejFlg;
   VOS_UINT8                           ucMaxAuthRejNo;
   VOS_UINT8                           aucReserved[2];
}NAS_MMC_NVIM_IGNORE_AUTH_REJ_CFG_STRU;
/* Added byl00215384 for DTS2014021006453, 2014-02-18, end */

/*****************************************************************************
 ṹ    : NAS_NV_GWMAC_ADDR_STRU
 ṹ˵  : NV_GWMAC_ADDR(39026)ṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8 ucStatus;
    VOS_UINT8 ucReserved1;
    VOS_UINT8 aucE5GwMacAddr[18];
}NAS_NV_GWMAC_ADDR_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_E5_ROAMING_WHITE_LIST_SUPPORT_FLG_STRU
 ṹ˵  : E5_RoamingWhiteList_Support_Flg(39330)ṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8 aucE5_RoamingWhiteList_Support_Flg[2];
}NAS_NVIM_E5_ROAMING_WHITE_LIST_SUPPORT_FLG_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_NDIS_DIALUP_ADDRESS_STRU
 ṹ˵  : NDIS_DIALUP_ADDRESS(39330)ṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32 ulNDIS_DIALUP_ADDRESS;
}NAS_NVIM_NDIS_DIALUP_ADDRESS_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_NV_BREATH_LED_STR_STRU
 ṹ˵  : NV_BREATH_LED_STR(9051)ṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8 ucBreOnTime; /*Range:[0,7]*/
    VOS_UINT8 ucBreOffTime; /*Range:[0,7]*/
    VOS_UINT8 ucBreRiseTime; /*Range:[0,5]*/
    VOS_UINT8 ucBreFallTime; /*Range:[0,5]*/
}NAS_NVIM_NV_BREATH_LED_STR_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_NV_WIFI_Key_STRU
 ṹ˵  : NV_WIFI_Key(50012)ṹ()
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
VOS_UINT8  aucwlAuthMode[16];
VOS_UINT8  aucBasicEncryptionModes[5];
VOS_UINT8  aucWPAEncryptionModes[5];
VOS_UINT8  aucwlKeys1[27];
VOS_UINT8  aucwlKeys2[27];
VOS_UINT8  aucwlKeys3[27];
VOS_UINT8  aucwlKeys4[27];
VOS_UINT32 ulwlKeyIndex;
VOS_UINT8  aucwlWpaPsk[65];
VOS_UINT8  ucwlWpsEnbl;
VOS_UINT8  ucwlWpsCfg;
VOS_UINT8  ucReserved;
}NAS_NVIM_NV_WIFI_KEY_STRU;

/*****************************************************************************
 ṹ    : NAS_NVIM_NV_PRI_VERSION_STRU
 ṹ˵  : NV_PRI_VERSION(50023)ṹ
  1.       : 2013522
           : l00167671
    ޸   : ½
*****************************************************************************/
typedef struct
{
VOS_UINT8 aucPRIVersion[32];
VOS_UINT8 aucReserve[32];
}NAS_NVIM_NV_PRI_VERSION_STRU;

/*****************************************************************************
ṹ    : NAS_NVIM_SYSTEM_APP_CONFIG_STRU
ṹ˵  : en_NV_Item_System_APP_Config(121)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16     usSysAppConfigType;
}NAS_NVIM_SYSTEM_APP_CONFIG_STRU;

/*****************************************************************************
ṹ    : NAS_MMC_NVIM_NETWORK_CAPABILITY_STRU
ṹ˵  : en_NV_Item_NetworkCapability(8197)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8 aucNetworkCapability[NV_ITEM_NET_CAPABILITY_MAX_SIZE];
}NAS_MMC_NVIM_NETWORK_CAPABILITY_STRU;

/*****************************************************************************
ṹ    : NAS_NVIM_AUTOATTACH_STRU
ṹ˵  : en_NV_Item_Autoattach(8202)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usAutoattachFlag;
}NAS_NVIM_AUTOATTACH_STRU;

/*****************************************************************************
ṹ    : NAS_NVIM_SELPLMN_MODE_STRU
ṹ˵  : en_NV_Item_SelPlmn_Mode(8214)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16 usSelPlmnMode;
}NAS_NVIM_SELPLMN_MODE_STRU;

/*****************************************************************************
ṹ    : NAS_MMA_NVIM_ACCESS_MODE_STRU
ṹ˵  : en_NV_Item_MMA_AccessMode(8232)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   aucAccessMode[2];
}NAS_MMA_NVIM_ACCESS_MODE_STRU;

/*****************************************************************************
ṹ    : NAS_NVIM_MS_CLASS_STRU
ṹ˵  : en_NV_Item_MMA_MsClass(8233)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucMsClass;
    VOS_UINT8   ucReserved;
}NAS_NVIM_MS_CLASS_STRU;

/*****************************************************************************
ṹ    : NAS_MMA_NVIM_RF_Auto_Test_Flag_STRU
ṹ˵  : en_NV_Item_RF_Auto_Test_Flag(8262)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16  usRfAutoTestFlg;
}NAS_MMA_NVIM_RF_AUTO_TEST_FLAG_STRU;

/*****************************************************************************
ṹ    : NAS_NVIM_HPLMN_FIRST_TIMER_STRU
ṹ˵  : en_NV_Item_HPlmnFirstTimer(8276)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucHplmnTimerLen;
    VOS_UINT8   ucReserved;
}NAS_NVIM_HPLMN_FIRST_TIMER_STRU;

/*****************************************************************************
ṹ    : NAS_MMC_NVIM_SUPPORT_3GPP_RELEASE_STRU
ṹ˵  : en_NV_Item_NAS_Supported_3GPP_Release(8288)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   aucSupported3GppRelease[NAS_MMC_NVIM_SUPPORTED_3GPP_RELEASE_SIZE];
}NAS_MMC_NVIM_SUPPORT_3GPP_RELEASE_STRU;

/*****************************************************************************
ṹ    : NAS_MMC_NVIM_LAST_IMSI_STRU
ṹ˵  : en_NV_Item_Last_Imsi(8325)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucValid;
    VOS_UINT8   aucImsi[NAS_MMC_NVIM_MAX_IMSI_LEN];
}NAS_MMC_NVIM_LAST_IMSI_STRU;

/*****************************************************************************
ṹ    : NAS_MMA_NVIM_ROAMING_BROKER_STRU
ṹ˵  : en_NV_Item_Roaming_Broker(8328)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   aucRoamingBroker[2];
}NAS_MMA_NVIM_ROAMING_BROKER_STRU;

/*****************************************************************************
ṹ    : NAS_MMC_NVIM_USE_SINGLE_RPLMN_STRU
ṹ˵  : en_NV_Item_Use_Single_Rplmn_When_Area_Lost(8343)ṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT16  usUseSingleRplmnFlag;
}NAS_MMC_NVIM_USE_SINGLE_RPLMN_STRU;

/* en_NV_Item_EquivalentPlmn 8215 */
/*****************************************************************************
ṹ    : NVIM_PLMN_VALUE_STRU
ṹ˵  : en_NV_Item_EquivalentPlmn(8215)ṹ#
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8    ucMcc[NVIM_MAX_MCC_SIZE];
    VOS_UINT8    ucMnc[NVIM_MAX_MNC_SIZE];
}NVIM_PLMN_VALUE_STRU;

/*****************************************************************************
ṹ    : NVIM_EQUIVALENT_PLMN_LIST_STRU
ṹ˵  : en_NV_Item_EquivalentPlmn(8215)ṹ#
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8             ucCount;
    NVIM_PLMN_VALUE_STRU  struPlmnList[NVIM_MAX_EPLMN_NUM];
    VOS_UINT8             aucReserve[3];   /*NVصĽṹ壬4ֽڷʽ£ֶն*/
}NVIM_EQUIVALENT_PLMN_LIST_STRU;

/*en_NV_Item_Support_Freqbands 8229*/
/*
NVIM_UE_SUPPORT_FREQ_BAND_STRUṹ˵:
usWcdmaBandusGsmBandBitλʾûõƵΣbit1ƵI,bit2ƵII,
,λΪ1,ʾָ֧Ƶ.±ǱλƵζӦϵ:
-------------------------------------------------------------------------------
        bit8       bit7      bit6     bit5    bit4     bit3      bit2     bit1
-------------------------------------------------------------------------------
WCDMA   900(VIII)  2600(VII) 800(VI)  850(V)  1700(IV) 1800(III) 1900(II) 2100(I) oct1
        spare      spare     spare    spare   spare    spare     spare   J1700(IX)oct2
-------------------------------------------------------------------------------
GSMƵ 1900(VIII) 1800(VII) E900(VI) R900(V) P900(IV) 850(III)  480(II)  450(I)  oct3
        spare      spare     spare    spare   spare    spare     spare    700(IX) oct4
-------------------------------------------------------------------------------
aucUeSupportWcdmaBandaucUeSupportGsmBandʾUEֵ֧Ƶ,Դ洢˳
ȺʾƵ˳,0xffʾЧ.

:
oct1-oct4ֱǣ0x03,0x00,0x7B,0x00
   ûƵΪWWCDMA-I-2100, WCDMA-II-1900
                         G850(III),P900(IV),R900(V),E900(VI),1800(VII)
oct5-oct16ֱ:2,5,1,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
   UE֧WƵI,II,V,˳:II,V,I.
oct17-oct28ֱ:4,5,8,7,6,3,0xff,0xff,0xff,0xff,0xff,0xff
   UE֧GƵIII,IV,V,VI,VII,VIII,˳:IV,V,VIII,VII,VI,III.
*/
/*****************************************************************************
ṹ    : NAS_NVIM_UE_SUPPORT_FREQ_BAND_STRU
ṹ˵  : en_NV_Item_Support_Freqbands(8229)ṹ#
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    /* Modified by w00176964 for DTS201212345678, 2012-3-5, begin */
    VOS_UINT32                  ulWcdmaBand;
    VOS_UINT32                  ulGsmBand;
    /* Modified by w00176964 for DTS201212345678, 2012-3-5, end */
    VOS_UINT8                   aucUeSupportWcdmaBand[NVIM_MAX_FDD_FREQ_BANDS_NUM];
    VOS_UINT8                   aucUeSupportGsmBand[NVIM_MAX_FDD_FREQ_BANDS_NUM];
    VOS_UINT8                   aucReserved[24];        /* Ϊ֤nvһ± */
}NVIM_UE_SUPPORT_FREQ_BAND_STRU;

/*en_NV_Item_Roam_Capa 8266*/
/*****************************************************************************
 ṹ    : NAS_NVIM_ROAM_CFG_INFO_STRU
 ṹ˵  : en_NV_Item_Roam_Capa(8266) NVṹ#
  1.       : 2011818
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                               ucRoamFeatureFlg;                   /*¼Ƿ񼤻,VOS_FALSE:,VOS_TRUE:*/
    VOS_UINT8                               ucRoamCapability;                   /*¼ûõ*/
}NAS_NVIM_ROAM_CFG_INFO_STRU;

/*en_NV_Item_CustomizeService 8271*/
/*****************************************************************************
ṹ    : NAS_NVIM_CUSTOMIZE_SERVICE_STRU
ṹ˵  : en_NV_Item_CustomizeService(8271)ṹ#
            ڱӪ̶Ҫҵ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulStatus;           /*Ƿ񼤻01 */
    VOS_UINT32                          ulCustomizeService; /*ն˵1byteΪûпն4byte3byte*/
}NAS_NVIM_CUSTOMIZE_SERVICE_STRU;

/*en_NV_Item_RPlmnWithRat 8275*/
/*****************************************************************************
 ṹ    : NAS_MM_NVIM_RPLMN_WITH_RAT_STRU
 ṹ˵  : en_NV_Item_RPlmnWithRat(8275) NVṹ
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    NAS_NVIM_PLMN_ID_STRU               stGRplmn;                               /* G RPLMNϢ */
    NAS_NVIM_PLMN_ID_STRU               stWRplmn;                               /* W RPLMNϢ*/
    VOS_UINT8                           ucLastRplmnRat;                         /* ϴιػʱפĽ뼼0:GSM;1:WCDMA;0xFF:Чֵ */
    VOS_UINT8                           ucLastRplmnRatEnableFlg;                /* 0:NV δ; 1:NV */
    VOS_UINT8                           aucReserved[2];                          /*  */
}NAS_NVIM_RPLMN_WITH_RAT_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SEARCH_HPLMN_TIMER_STRU
 ṹ˵  : en_NV_Item_SearchHplmnTtimerValue NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                            ucStatus;                              /* 0:NV δ; 1:NV  */
    VOS_UINT8                            ucReserve;                             /* δ */
    VOS_UINT16                           usSrchHplmnTimerValue;                 /* VPLMN·״HPLMNʱ,λ: */

}NAS_MMC_NVIM_SEARCH_HPLMN_TIMER_STRU;

/*en_NV_Item_EFust_Service_Cfg 8285*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_EFUST_SERVICE_CFG_STRU
 ṹ˵  : en_NV_Item_EFust_Service_Cfg(8285) NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻0δ1 */
    VOS_UINT8                           ucForbidReg2GNetWork;                   /* 0EFust GSM־ȥʹܡEFust 2738GSM롣
                                                                                   öUESIMеEFust 2738λȷǷGSM룬
                                                                                   EFUSTļֹλͬʱΪ0ֹGSMעᣬGSMԽ롣
                                                                                   ע⣺SIMвEFust 2738λ˸ùܽUSIMЧ1EFust GSM־ʹ */
    VOS_UINT8                           ucForbidSndMsg;                         /* 0EFustŷͱ־ȥʹܡEFust 1012SMS͡
                                                                                   1EFustŷͱ־ʹܡNVöUESIMEFUST1012λ
                                                                                   ȷǷֹŷ,ֹλͬʱΪ0ֹSMS򣬶ſԷ͡*/
    VOS_UINT8                           ucReserved[13];
}NAS_MMC_NVIM_EFUST_SERVICE_CFG_STRU;

/*en_NV_Item_UE_MSCR_VERSION 8289*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_MSCR_VERSION_STRU
 ṹ˵  : en_NV_Item_UE_MSCR_VERSION(8289) NVṹ
 1.       : 2011714
          : z00161729
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻־, 0: 1:  */
    VOS_UINT8                           ucUeMscrVersion;                        /* նϱSGSN汾 */
}NAS_MMC_NVIM_MSCR_VERSION_STRU;

/*en_NV_Item_UE_SGSNR_VERSION 8290*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SGSNR_VERSION_STRU
 ṹ˵  : en_NV_Item_UE_SGSNR_VERSION(8290) NVṹ
 1.       : 2011714
          : z00161729
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻־, 0: 1:  */
    VOS_UINT8                           ucUeSgsnrVersion;                       /* նϱSGSN汾 */
}NAS_MMC_NVIM_SGSNR_VERSION_STRU;

/*en_NV_Item_SteeringofRoaming_SUPPORT_CTRL 8292*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_CS_REJ_SEARCH_SUPPORT_STRU
 ṹ˵  : en_NV_Item_SteeringofRoaming_SUPPORT_CTRL(8292) NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;                               /* NVǷ񼤻־, 0: 1:  */
    VOS_UINT8                           ucCsRejSearchSupportFlg;                /* vodafone,CSʧĴκ·,VOS_FALSE:֧,VOS_TRUE:֧ */
}NAS_MMC_NVIM_CS_REJ_SEARCH_SUPPORT_STRU;

/*en_NV_Item_Max_Forb_Roam_La 8320*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_MAX_FORB_ROAM_LA_STRU
 ṹ˵  : en_NV_Item_Max_Forb_Roam_La(8320) NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucMaxForbRoamLaFlg;                     /* NVõֹLAǷЧ: VOS_TRUE:valid;VOS_FALSE:INVALID */
    VOS_UINT8                           ucMaxForbRoamLaNum;                     /* NVõֹLA */
}NAS_MMC_NVIM_MAX_FORB_ROAM_LA_STRU;

/*en_NV_Item_Default_Max_Hplmn_Srch_Peri 8321*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_DEFAULT_MAX_HPLMN_PERIOD_STRU
 ṹ˵  : en_NV_Item_Default_Hplmn_Srch_Peri(8321) NVṹ
  1.       : 2011720
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucDefaultMaxHplmnPeriFlg;               /* ĬHPLMNǷЧ־,VOS_TRUE:valid;VOS_FALSE:INVALID */
    VOS_UINT8                           ucDefaultMaxHplmnTim;                   /* ûԶĬϵHPLMN */
}NAS_MMC_NVIM_DEFAULT_MAX_HPLMN_PERIOD_STRU;

/*en_NV_Item_USSD_Apha_To_Ascii 8327*/
/*USSDתַ*/
/*****************************************************************************
 ṹ    : NAS_SSA_NVIM_ALPHA_to_ASCII_STRU
 ṹ˵  : en_NV_Item_USSD_Apha_To_Ascii(8327) NVṹ
  1.       : 2011720
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                       ucStatus;            /*Ƿ񼤻01 */
    VOS_UINT8                       ucAlphaTransMode;    /* ַת*/
}NAS_SSA_NVIM_ALPHA_to_ASCII_STRU;

/*en_NV_Item_Register_Fail_Cnt 8338*/
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_REG_FAIL_CNT_STRU
 ṹ˵  : en_NV_Item_Register_Fail_Cnt(8338) NVṹ
  1.       : 2011725
           : z00161729
    ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvActiveFlag;                         /* ǰNVǷ񼤻 */
    VOS_UINT8                           ucRegFailCnt;                           /* NVõעʧܵĴĬֵΪ2עʧκ */
}NAS_MMC_NVIM_REG_FAIL_CNT_STRU;

/*en_NV_Item_CREG_CGREG_CI_Four_Byte_Rpt 8345*/
/* VDF: CREG/CGREG<CI>Ƿ4ֽϱNVƽṹ */
/*****************************************************************************
ṹ    : NAS_NV_CREG_CGREG_CI_FOUR_BYTE_RPT_STRU
ṹ˵  : en_NV_Item_CREG_CGREG_CI_Four_Byte_Rpt(8345)ṹ#
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucStatus;                        /* 1: NVЧ־λ0Ч */
    VOS_UINT8   ucCiBytesRpt;                    /* <CI>ϱֽ־02ֽϱ, 14ֽϱ */
}NAS_NV_CREG_CGREG_CI_FOUR_BYTE_RPT_STRU;

/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_DAIL_REJECT_CFG_STRU
 ṹ˵  : ¼en_NV_Item__Dell_Reject_Config NVݣű11,12,13,15,other cause,ʧ,ûӦԭNV
 1.       : 201236
          : w00176964
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucEnableFlg;                            /* űǷʹ VOS-TRUE:ű֧ VOS_FALSE:ű֧ܲ */
    VOS_UINT8                           aucReserve[1];
}NAS_MMC_NVIM_DAIL_REJECT_CFG_STRU;

/*h00218138, NDIS NV Struct, start, 2013-5-25*/
/* en_NV_Item_NDIS_DHCP_DEF_LEASE_TIME 8344 */
typedef struct
{
    VOS_UINT32                          ulDhcpLeaseHour;    /*Range:[0x1,0x2250]*/
}NDIS_NV_DHCP_LEASE_HOUR_STRU;

typedef struct
{
    VOS_UINT32                          ulIpv6Mtu;          /*Range:[1280,65535]*/
}NDIS_NV_IPV6_MTU_STRU;
/*h00218138, NDIS NV Struct, end, 2013-5-25*/

/*****************************************************************************
ṹ    : NAS_NVIM_CCALLSTATE_RPT_STATUS_STRU
ṹ˵  : en_NV_Item_CCallState_Rpt_Status nvid 9116(ѷ)
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucStatus;
    VOS_UINT8                           ucReserved;
}NAS_NVIM_CCALLSTATE_RPT_STATUS_STRU;

/*****************************************************************************
 ṹ    : NVIM_PLMN_EXACTLY_COMPARE_FLAG_STRU
 ṹ˵  : PLMNȽǷоȷȽϵķʽı
 ޸ʷ  :
 1.        : 2012087
           : l00128652
   ޸    : ½ṹ
*****************************************************************************/
typedef struct
{
   VOS_UINT8                            ucPlmnExactlyCompareFlag;               /* PLMNȽǷоȷȽϵķʽı */
   VOS_UINT8                            aucRsv[3];                              /* λ */
}NVIM_PLMN_EXACTLY_COMPARE_FLAG_STRU;

/* Added by z00220246 for DSDA Phase II, 2012-12-25, Begin */
/*****************************************************************************
ṹ    : PLATFORM_RAT_TYPE_ENUM
ṹ˵  : 뼼

  1.       : 20121225
           : z00220246
    ޸   : 
*******************************************************************************/
enum PLATFORM_RAT_TYPE_ENUM
{
    PLATFORM_RAT_GSM,                                                       /*GSM뼼 */
    PLATFORM_RAT_WCDMA,                                                     /* WCDMA뼼 */
    PLATFORM_RAT_LTE,                                                       /* LTE뼼 */
    PLATFORM_RAT_TDS,                                                       /* TDS뼼 */
    PLATFORM_RAT_BUTT
};
typedef VOS_UINT16 PLATFORM_RAT_TYPE_ENUM_UINT16;

#define PLATFORM_MAX_RAT_NUM            (7)                                    /* 뼼ֵ */

/*****************************************************************************
ṹ    : PLATAFORM_RAT_CAPABILITY_STRU
ṹ˵  : ƽֵ̨֧Ľ뼼

  1.       : 20121225
           : z00220246
    ޸   : 
*******************************************************************************/
typedef struct
{
    VOS_UINT16                           usRatNum;                              /* 뼼Ŀ*/
    PLATFORM_RAT_TYPE_ENUM_UINT16        aenRatList[PLATFORM_MAX_RAT_NUM];  /* 뼼 */
}PLATAFORM_RAT_CAPABILITY_STRU;
/* Added by z00220246 for DSDA Phase II, 2012-12-25, End */

/*en_NV_Item_Rplmn 8216*/
/*****************************************************************************
 ṹ    : NAS_NVIM_RPLMN_INFO_STRU
 ṹ˵  : en_NV_Item_Rplmn(8216) NVṹ(ѷ)
1.       : 2013522
         : m00217266
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           aucRplmnInfo[56];
}NAS_NVIM_RPLMN_INFO_STRU;

/* Modified by z00161729 for V9R1_SVLTE, 2013-6-20, begin */
/*****************************************************************************
 ṹ    : SVLTE_SUPPORT_FLAG_STRU
 ṹ˵  : en_NV_Item_SVLTE_FLAG NVṹ
 1.       : 2013620
          : z00161729
   ޸   : SVLTEǷ֧:0-֧֣1-֧
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucSvlteSupportFlag;                     /* SVLTEǷ֧:0-֧֣1-֧ */
    VOS_UINT8                           aucReserved[3];                         /*  */
}SVLTE_SUPPORT_FLAG_STRU;


/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ENABLE_LTE_TIMER_LEN_STRU
 ṹ˵  : en_NV_Item_Enable_Lte_Timer_Len NVṹ
 1.       : 201363
          : z00161729
   ޸   : enable lteʱʱ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucNvimActiveFlag;                       /* 0: nvδ1:nv */
    VOS_UINT8                           ucCsPsMode1EnableLteTimerLen;           /* 1)cs ps mode1 Lעeps onlyɹcs#16/#17/#22disable lteʱenable lteʱʱ
                                                                                   2)cs ps mode1 Lעcs epsʧԭֵother cause disable lteenable lteʱʱ,λ:ӣ nvʱΪ0Ĭ54 */
    VOS_UINT8                           ucCsfbEmgCallEnableLteTimerLen;         /* L½޷csfbguͨgudisable lteenable lteʱʱλ:ӣ nvʱΪ0Ĭ5 */
    VOS_UINT8                           ucReserved;
}NAS_MMC_NVIM_ENABLE_LTE_TIMER_LEN_STRU;

/* Modified by z00161729 for V9R1_SVLTE, 2013-6-20, end */

/* Added by z00234330 for DTS2013052301419, 2013-05-23, begin */
/*****************************************************************************
ṹ    : NAS_MMC_NVIM_ISR_CFG_STRU
ṹ˵  : ISRϢ
1.      : 20130523
        : z00234330
  ޸  : ISRͨNVIMжǷ֧
*****************************************************************************/
typedef struct
{
    VOS_UINT8                                               ucIsrSupport;       /* ISR ???? */
    VOS_UINT8                                               ucReserve1;
} NAS_NVIM_ISR_CFG_STRU;

/* Added by z00234330 for DTS2013052301419, 2013-05-23, end */

/* Added by w00242748 for DTS2013072200933, 2013-7-25, begin */
/*****************************************************************************
 ṹ    : CSFB_MT_FOLLOW_ON_SUPPORT_FLAG_STRU
 ṹ˵  : en_NV_Item_CSFB_MT_RAU_FOLLOW_ON_FLAG NVṹ
 1.       : 2013725
          : w00242748
   ޸   : Csfb mtУRAUǷҪfollow on:0-Ҫ1-Ҫ
 2.       : 2014610
          : w00242748
   ޸   : Csfb moУRAUǷҪfollow on:0-Ҫ1-Ҫ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucIsRauNeedFollowOnCsfbMtFlg;           /* Csfb mtУRAUǷҪfollow on:0-Ҫ1-Ҫ */
    VOS_UINT8                           ucIsRauNeedFollowOnCsfbMoFlg;           /* Csfb moУRAUǷҪfollow on:0-Ҫ1-Ҫ */
    VOS_UINT8                           aucReserved[2];                         /*  */
}NAS_MMC_CSFB_RAU_FOLLOW_ON_FLAG_STRU;
/* Modified by w00242748 for DTS2014053105098, 2014-6-10, end */
/* Added by w00242748 for DTS2013072200933, 2013-7-25, end */

/* Modified by z00161729 for svlte g-tl ps transfer optimize, 2013-11-18, begin */
/*****************************************************************************
 ṹ    : NV_DSDA_PLMN_SEARCH_ENHANCED_CFG_STRU
 ṹ˵  : en_NV_Item_DSDA_PLMN_SEARCH_ENHANCED_CFG NVṹ
  ˵: ͨModemϢǿ͵ԣǰֵ֧ĲΪ
  1)  ͨһModemPLMNϢ,FDDǷĲԡGUTL+Gİ汾ѾפڹGʱFDDƶֻҪ֧TDDģʽ
  2)  ͨModem1GSMϱLTDSϢ, Modem0֧GSM£T/LܹݴݵƵTDS/LTE
 1.       : 20131118
          : z00161729
   ޸   : ½
 2.       : 2014126
          : z00161729
   ޸   : DTS2014012305088֧ǿNCELLModem1ݹϢڵ£ͨʷƵ֧NCELL
*****************************************************************************/
typedef struct
{
   VOS_UINT16                           usSolutionMask;/*ͨModemϢǿ͵ԣBitλƸԣbitn=0nԹرգbitn=1nԿ
                                                         Ŀǰֻbit0bit1 Ч
                                                         BIT0˫ModemͨһModemPLMNϢFDDǷĲǷ
                                                         BIT1ͨModem1GSMϱLTDSϢ, Modem0֧GSM£T/LܹݴݵƵTDS/LTE
                                                               Modem1ݹϢڵ£ҲͨʷƵ֧NCELLƵucSolution2NcellSearchTimer
                                                         BIT2~BIT15:Ԥ*/
   VOS_UINT8                            ucSolution2NcellQuickSearchTimer;       /*ƵԵһ׶ʱλ룩*/

   /* Modified by z00161729 for DTS2014012305088, 2014-1-26, begin */
   VOS_UINT8                            ucSolution2NcellQuickSearchTimer2;      /* ƵԵĶ׶ʱλ룩*/
   VOS_UINT8                            aucAdditonCfg[4];
   /* Modified by z00161729 for DTS2014012305088, 2014-1-26, end */
}NV_DSDA_PLMN_SEARCH_ENHANCED_CFG_STRU;

/* Modified by z00161729 for svlte g-tl ps transfer optimize, 2013-11-18, end */

/* added by l65478 for DTS2013102508485 2014-01-13 begin */
/*****************************************************************************
ṹ    : NV_NAS_GMM_REL_CONN_AFTER_PDP_DEACT_STRU
ṹ˵  : en_NV_Item_NAS_GMM_REL_CONN_AFTER_PDP_DEACT(9140)ṹ
1.       : 20140113
         : l65478
  ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8   ucRelFlg;
    VOS_UINT8   ucReserve;
}NV_NAS_GMM_REL_CONN_AFTER_PDP_DEACT_STRU;
/* added by l65478 for DTS2013102508485 2014-01-13 end */

/* Added by f62575 for DTS2014012600456, 2014-02-10,Begin */
/*****************************************************************************
ṹ    : NAS_NVIM_WG_RF_MAIN_BAND_STRU
ṹ˵  : en_NV_Item_WG_RF_MAIN_BANDṹ
  1.       : 20140210
           : f62575
    ޸   : DTS2014012600456: en_NV_Item_WG_RF_MAIN_BAND޸Ϊڴлȡ
*****************************************************************************/
typedef struct
{
    VOS_UINT32                          ulWband;                                /* ֵ֧WCDMAͨ· */
    VOS_UINT32                          ulWbandExt;                             /* ֵ֧WCDMAͨ·չֶ */
    VOS_UINT32                          ulGband;                                /* ֵ֧GSMͨ· */
}NAS_NVIM_WG_RF_MAIN_BAND_STRU;
/* Added by f62575 for DTS2014012600456, 2014-02-10,End   */


/* Added by f00261443 for VoltePhaseIII , 2013-12-16, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_IMS_VOICE_MOBILE_MANAGEMENT
 ṹ˵  : en_NV_Item_IMS_VOICE_MOBILE_MANAGEMENT NVṹ
 1.       : 20131216
          : f00261443 
   ޸   : ISR״̬£LϵͳGULAIRAIδ仯ǷҪ
                LAURAU
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucImsVoiceInterSysLauEnable;           /* ISRϵͳL任GULAIδı䣬ǷҪǿLAU */
    VOS_UINT8                           ucImsVoiceMMEnable;         /* IMSƶԹ NV */
    VOS_UINT8                           aucReserved[2];             /*  */
}NAS_MMC_IMS_VOICE_MOBILE_MANAGEMENT;
/* Added by f00261443 for VoltePhaseIII , 2013-12-16, end */

/* Modified by z00161729 for DTS2014022206794, 2014-2-25, begin */
/*****************************************************************************
ṹ    : NAS_MMC_LTE_DISABLED_USE_LTE_INFO_FLAG_STRU
ṹ˵  : en_NV_Item_LTE_DISABLED_USE_LTE_INFO_FLAGṹ
  1.       : 20140225
           : z00161729
    ޸   : DTS2014022206794:GCF 9.2.1.2.1b/9.2.3.2.3/9.2.1.2.1ʧdisable lteʱrauҪLȡȫ

*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucLDisabledRauUseLInfoFlag;             /* l disabledrauǷҪlȡȫĻgutiӳϢvos_true:Ҫȡvos_false:ȡ*/
    VOS_UINT8                           ucReserved[3];
}NAS_MMC_LTE_DISABLED_USE_LTE_INFO_FLAG_STRU;

/* Modified by z00161729 for DTS2014022206794, 2014-2-25, end */

/* Add by f62575 for DTS2014012902032, 2014-02-13, begin */
/*****************************************************************************
ṹ    : NAS_MML_CS_ONLY_DATA_SERVICE_SUPPORT_FLG_STRU
ṹ˵  : en_NV_Item_CS_ONLY_DATA_SERVICE_SUPPORT_FLGṹ
  1.       : 20140213
           : f62575
    ޸   : DTS2014012902032: 
                 NVen_NV_Item_CS_ONLY_DATA_SERVICE_SUPPORT_FLGĽṹ
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucActiveFlg;                            /* Ƿ񼤻 */
    VOS_UINT8                           ucCsOnlyDataServiceSupportFlg;          /* PSעᱻֹ£Ƿҵ񴥷עı־ */
}NAS_MML_CS_ONLY_DATA_SERVICE_SUPPORT_FLG_STRU;
/* Add by f62575 for DTS2014012902032, 2014-02-13, end */
/* Added by w00176964 for High_Rat_Hplmn_Search, 2014-2-19, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_HIGH_PRIO_RAT_HPLMN_TIMER_CFG_STRU
 ṹ˵  : en_NV_Item_HIGH_PRIO_RAT_HPLMN_TIMER_INFO NVṹ
 1.       : 2014219
          : w00176964
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucActiveFLg;                             /* öʱǷʹ */
    VOS_UINT8                           aucRsv[3];
    VOS_UINT32                          ulFirstSearchTimeLen;                   /* high prio rat timerʱһεʱ λ: */
    VOS_UINT32                          ulFirstSearchTimeCount;                 /* high prio rat timerʱһʱ */
    VOS_UINT32                          ulNonFirstSearchTimeLen;                /* high prio rat timerʱ״εʱ λ: */
    VOS_UINT32                          ulRetrySearchTimeLen;                   /* high prio rat ѱֹԵʱ λ:*/
}NAS_MMC_NVIM_HIGH_PRIO_RAT_HPLMN_TIMER_CFG_STRU;

/* Added by w00176964 for High_Rat_Hplmn_Search, 2014-2-19, end */


/* Added by s00217060 for ultra_flash_csfb, 2014-05-30, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ULTRA_FLASH_CSFB_SUPPORT_FLG_STRU
 ṹ˵  : en_NV_Item_Ultra_Flash_Csfb_Support_Flg NVṹ
 1.       : 2014530
          : s00217060
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucUltraFlashCsfbSupportFLg;                 /* Ƿ֧ultra flash csfb */
    VOS_UINT8                           aucRsv[3];
}NAS_MMC_NVIM_ULTRA_FLASH_CSFB_SUPPORT_FLG_STRU;
/* Added by s00217060 for ultra_flash_csfb, 2014-05-30, end */

/* Added by B00269685 for DTS2014061603311, 2014-6-13, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_3GPP2_Uplmn_Not_Pref_STRU
 ṹ˵  : en_NV_Item_3GPP2_Uplmn_Not_Pref_Flg NVṹ
 1.       : 2014613
          : B00269685
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           uc3GPP2UplmnNotPrefFlg;                    /* Ƿ3GPP2 pref plmn */
    VOS_UINT8                           aucRsv[3];
}NAS_MMC_NVIM_3GPP2_UPLMN_NOT_PREF_STRU;
/* Added by B00269685 for DTS2014061603311, 2014-6-13, end */

/* Modified by w00242748 for DTS2014063003419, 2014-7-14, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_SYSCFG_TRIGGER_PLMN_SEARCH_CFG_STRU
 ṹ˵  : en_NV_Item_Syscfg_Trigger_Plmn_Search_Cfg NVṹ
 1.       : 2014714
          : w00242748
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucHighPrioRatPlmnSrchFlg;                  /* Ƿȼ뼼 */
    VOS_UINT8                           aucReserved1[3];
}NAS_MMC_NVIM_SYSCFG_TRIGGER_PLMN_SEARCH_CFG_STRU;
/* Modified by w00242748 for DTS2014063003419, 2014-7-14, end */


/* Added by b00269685 for DTS2015031909305, 2015-3-20, begin */
/*****************************************************************************
 ṹ    : NAS_MMC_NVIM_ROAM_DISPLAY_CFG_STRU
 ṹ˵  : en_NV_Item_Roam_Display_Cfg NVṹ
 1.       : 2015320
          : B00269685
   ޸   : ½
*****************************************************************************/
typedef struct
{
    VOS_UINT8                           ucHplmnInEplmnDisplayHomeFlg;
    VOS_UINT8                           ucReserved1;
    VOS_UINT8                           ucReserved2;
    VOS_UINT8                           ucReserved3;
}NAS_MMC_NVIM_ROAM_DISPLAY_CFG_STRU;
/* Added by b00269685 for DTS2015031909305, 2015-3-20, end */

/*****************************************************************************
  6 UNION
*****************************************************************************/


/*****************************************************************************
  7 Extern Global Variable
*****************************************************************************/


/*****************************************************************************
  8 Fuction Extern
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/










#if (VOS_OS_VER != VOS_WIN32)
#pragma pack()
#else
#pragma pack(pop)
#endif





#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of NasNvInterface.h */
