#!/bin/bash

usage1()
{
    echo "Error: Please input the webui version";
}

usage2()
{
    echo "Error: Please provide the ${FILE_NAME} image,thanks!"
}

if [ -z "${1}" ];then
    usage1
	exit 255
fi

rm -fr *.bin
cd ./Images

FILE_NAME=webui.cpio
if [ ! -f ${FILE_NAME} ];then usage2;exit 255; fi

cd ../

ZLIB_FILE_TEMP=zlib_temp
if [ ! -d ${ZLIB_FILE_TEMP} ];then mkdir ${ZLIB_FILE_TEMP}; fi
if [ -d ${ZLIB_FILE_TEMP} ];then rm -fr ${ZLIB_FILE_TEMP}/*.*; fi

rm -fr *.mbn
rm -fr *.MBN
rm -fr *.bin
rm -fr *.BIN

wine IsohdGen.exe -v${1} -t./Images/webuihd.img

./sign ./xml/packet_webui.xml -p ${1}

python compress.py c ./Images/webuihd_s.img ./${ZLIB_FILE_TEMP}/webuihd_s.zlib 9
python compress.py c ./Images/webui.cpio ./${ZLIB_FILE_TEMP}/webui.zlib 9

#7z decompress 
lzma -4vkf  ./Images/webuihd_s.img
lzma -4vkf  ./Images/webui.cpio
echo "##########  start to make zlib file #############"

./merge ./xml/packet_webui.xml -p UPDATE_${1}.BIN
./merge ./xml/packet_webui_zip.xml -p UPDATE_${1}.ZIP
./merge ./xml/packet_webui_7z.xml -p UPDATE_${1}.7Z

rm -fr *.MBN 
rm -fr MOBILE_CONNECT_HD.BIN

wine WizGen.exe "${1}" 
if [ ! -f UPDATE_${1}.BIN ] || [ ! -f UPDATE_${1}.ZIP ] || [ ! -f UPDATE_${1}.7Z ] || [ ! -f Update_*.exe ];then 
    echo "#####################################################################"
	echo "#### Sorry, packaged failed! The reason is unknown!"
	echo "#####################################################################"
	exit 255; 
fi
mv UPDATE_${1}.BIN ${FILE_WEB_PATH}
mv UPDATE_${1}.ZIP ${FILE_WEB_PATH}
mv UPDATE_${1}.7Z ${FILE_WEB_PATH}
mv Update_*.exe ${FILE_WEB_PATH}
echo "##########################################################################"
echo "######  Congratulations, packaged successful, go to ${FILE_WEB_PATH} get the upgrade package"   
echo "##########################################################################"
echo "######  webui ver                 ${WEBUI_VER}"
echo "##########################################################"
