#!/bin/bash

usage1()
{
    echo "Error: Please provide the dload_id";
}

usage2()
{
    echo "Error: Please provide the firmware version"
}

usage3()
{
    echo "Error: Please provide the dashboard version"
}

usage4()
{
    echo "Error: Please provide the product name"
}

usage5()
{
    echo "Error: Please input the webui version";
}

usage6()
{
    echo "Error: Please provide the ${FILE_NAME} image,thanks!"
}

if [ -z "${1}" ];then
    usage1
	exit 255
fi

if [ -z "${2}" ];then
    usage2
	exit 255
fi

if [ -z "${3}" ];then
    usage3
	exit 255
fi

if [ -z "${4}" ];then
    usage4
	exit 255
fi

if [ -z "${5}" ];then
    usage5
	exit 255
fi

rm -fr *.bin
cd ./Images

FILE_NAME=m3boot.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=ptable.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=fastboot.img
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=boot.img
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=bsp_mcore.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=lphy.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=balongv7r2_mcore.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=nv.bin
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
#FILE_NAME=logo
#if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=system.cpio
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=app.cpio
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=MOBILE_CONNECT.ISO
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
FILE_NAME=webui.cpio
if [ ! -f ${FILE_NAME} ];then usage6;exit 255; fi
cd ../


wine IsohdGen.exe  -v${3} -t./Images/ISOhd.iso
wine IsohdGen.exe  -v${3} -t./Images/ISOhd.iso

./sign ./xml/packet_fw_iso_webui.xml  -p ${1} ${2} ${3} ${5}

ZLIB_FILE_TEMP=zlib_temp
if [ ! -d ${ZLIB_FILE_TEMP} ];then mkdir ${ZLIB_FILE_TEMP}; fi
if [ -d ${ZLIB_FILE_TEMP} ];then rm -fr ${ZLIB_FILE_TEMP}/*.*; fi

rm -fr *.MBN
rm -fr *.bin
rm -fr *.BIN


python compress.py c ./Images/m3boot.bin ./${ZLIB_FILE_TEMP}/m3boot.zlib 9
python compress.py c ./Images/ptable.bin ./${ZLIB_FILE_TEMP}/ptable.zlib 9
python compress.py c ./Images/fastboot_s.img ./${ZLIB_FILE_TEMP}/fastboot_s.zlib 9
python compress.py c ./Images/bsp_mcore.bin ./${ZLIB_FILE_TEMP}/bsp_mcore.zlib 9
python compress.py c ./Images/lphy.bin ./${ZLIB_FILE_TEMP}/lphy.zlib 9
python compress.py c ./Images/balongv7r2_mcore.bin ./${ZLIB_FILE_TEMP}/balongv7r2_mcore.zlib 9
python compress.py c ./Images/nv.bin ./${ZLIB_FILE_TEMP}/nv.zlib 9
python compress.py c ./Images/boot.img ./${ZLIB_FILE_TEMP}/boot.zlib 9
#python compress.py c ./Images/logo ./${ZLIB_FILE_TEMP}/logo.zlib 9
python compress.py c ./Images/system.cpio ./${ZLIB_FILE_TEMP}/system.zlib 9
python compress.py c ./Images/app.cpio ./${ZLIB_FILE_TEMP}/app.zlib 9
python compress.py c ./Images/ISOhd.iso ./${ZLIB_FILE_TEMP}/ISOhd.zlib 9
python compress.py c ./Images/MOBILE_CONNECT.ISO ./${ZLIB_FILE_TEMP}/MOBILE_CONNECT.zlib 9
python compress.py c ./Images/webui.cpio ./${ZLIB_FILE_TEMP}/webui.zlib 9

#7z decompress 
lzma -4vkf ./Images/m3boot.bin 
lzma -4vkf  ./Images/ptable.bin
lzma -4vkf  ./Images/fastboot_s.img
lzma -4vkf  ./Images/bsp_mcore.bin
lzma -4vkf  ./Images/lphy.bin
lzma -4vkf  ./Images/balongv7r2_mcore.bin 
lzma -4vkf  ./Images/nv.bin
lzma -4vkf  ./Images/boot.img
#lzma -4vkf  ./Images/logo 
lzma -4vkf  ./Images/system.cpio
lzma -4vkf  ./Images/app.cpio 
lzma -4vkf  ./Images/ISOhd.iso 
lzma -4vkf  ./Images/MOBILE_CONNECT.ISO 
lzma -4vkf  ./Images/webui.cpio
echo "##########  start to make zlib file #############"

./merge ./xml/packet_fw_iso_webui.xml -p :${1}:${2} ${4}_UPDATE_${2}_${3}.BIN
./merge ./xml/packet_fw_iso_webui_zip.xml -p :${1}:${2} ${4}_UPDATE_${2}_${3}.ZIP
./merge ./xml/packet_fw_iso_webui_7z.xml -p :${1}:${2} ${4}_UPDATE_${2}_${3}.7Z

rm -fr *.MBN 
rm -fr MOBILE_CONNECT_HD.BIN

wine WizGen.exe "${4}" 
if [ ! -f *_UPDATE_${2}_${3}.BIN ] || [ ! -f *_UPDATE_${2}_${3}.ZIP ] || [ ! -f *_UPDATE_${2}_${3}.7Z ] || [ ! -f *_Update_*.exe ];then 
    echo "#####################################################################"
	echo "#### Sorry, packaged failed! The reason is unknown!"
	echo "#####################################################################"
	exit 255; 
fi

mv *_UPDATE_${2}_${3}.BIN ${FILE_FIRMWARE_PATH}
mv *_UPDATE_${2}_${3}.ZIP ${FILE_FIRMWARE_PATH}
mv *_UPDATE_${2}_${3}.7Z ${FILE_FIRMWARE_PATH}
mv *_Update_*.exe ${FILE_FIRMWARE_PATH}
echo "##########################################################################"
echo "######  Congratulations, packaged successful, go to ${FILE_FIRMWARE_PATH} get the upgrade package"   
echo "##########################################################################"
echo "######  package ver                   ${SOFTWARE_VER}"
echo "######  dload ID                      ${FILE_DLOAD_ID}"
echo "######  dashboard ver                 ${DASHBOARD_VER}"
echo "######  product name                  ${FILE_PRODUCT_NAME}"
echo "##########################################################"
