#!/bin/bash

usage1()
{
    echo "Error: Please provide the packaged kind,thanks!"
}

usage2()
{
    echo "Error: Please provide the dload_id";
}

usage3()
{
    echo "Error: Please provide the firmware version"
}

usage4()
{
    echo "Error: Please provide the dashboard version"
}

usage5()
{
    echo "Error: Please provide the product name"
}

usage6()
{
    echo "Error: Please provide the webui version"
}


if [ -z "${1}" ];then usage1;exit 255;fi

if [ -d autobin ];then rm -fr autobin; fi
if [ ! -d autobin ];then mkdir autobin; fi

echo "#!/bin/sh">VersionDefine.sh
echo "export set FILE_DLOAD_ID=${2}">VersionDefine.sh
echo "export set SOFTWARE_VER=${3}">>VersionDefine.sh
echo "export set DASHBOARD_VER=${4}">>VersionDefine.sh
echo "export set FILE_PRODUCT_NAME=${5}">>VersionDefine.sh
echo "export set WEBUI_VER=${6}">>VersionDefine.sh

if [ "${1}" == "ALL" ];then
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
	if [ -z "${4}" ];then usage4;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
    if [ -z "${6}" ];then usage6;exit 255;fi
	source ./Make_FW.sh
	source ./Make_FW_ISO_WEBUI.sh
	source ./Make_ISO.sh
	source ./Make_ISO_WEB.sh
	mv bin/* autobin/
elif [ "${1}" == "NO" ];then
    echo "UDP and mcpe remain haisi original state, do not pack one key upgrade file">autobin/readme.txt
elif [ "${1}" == "FW" ];then
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
	if [ -z "${4}" ];then usage4;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
	source ./Make_FW.sh
	mv ${FILE_FIRMWARE_PATH}/* autobin/
elif [ "${1}" == "FW_LOGO" ];then
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
    if [ -z "${4}" ];then usage4;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
	source ./Make_FW_LOGO.sh
	mv ${FILE_FIRMWARE_PATH}/* autobin/
elif [ "${1}" == "FW_WEBUI" ];then
    # only for cpe
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
    if [ -z "${4}" ];then usage4;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
    if [ -z "${6}" ];then usage6;exit 255;fi
	source ./Make_FW_WEBUI.sh
	#source ./Make_FW.sh
	source ./Make_WEBUI.sh
	mv bin/* autobin/
elif [ "${1}" == "FW_WEB" ];then
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
	echo "### warning we are not support this kind now!! ###"
elif [ "${1}" == "FW_WEB_ISO" ];then
    if [ -z "${2}" ];then usage2;exit 255;fi
    if [ -z "${3}" ];then usage3;exit 255;fi
	if [ -z "${4}" ];then usage4;exit 255;fi
    if [ -z "${5}" ];then usage5;exit 255;fi
    if [ -z "${6}" ];then usage6;exit 255;fi
	source ./Make_FW_ISO_WEBUI.sh
	mv ${FILE_FIRMWARE_PATH}/* autobin/
elif [ "${1}" == "WEB_ISO" ];then
	if [ -z "${4}" ];then usage4;exit 255;fi
	if [ -z "${6}" ];then usage4;exit 255;fi
	source ./Make_ISO_WEB.sh
	mv ${FILE_ISO_WEB_PATH}/* autobin/
elif [ "${1}" == "ISO" ];then
	if [ -z "${4}" ];then usage4;exit 255;fi
	source ./Make_ISO.sh
	mv ${FILE_ISO_PATH}/* autobin/
else
	echo "Error: Please provide the correct packaged kind,thanks!"
fi

echo "${FILE_DLOAD_ID} ${SOFTWARE_VER} ${FILE_PRODUCT_NAME} ${DASHBOARD_VER}"
cp bat/*.txt autobin/
exit
