#!/usr/bin/python
import os
import string
import sys
import binascii
webui_is_yaffs = 0
app_is_yaffs = 0
system_is_yaffs = 0
firm_dload_packet_dir = string.replace(os.path.abspath(sys.argv[1]), '//', '/')
ptable_bin = firm_dload_packet_dir + '/' + 'ptable.bin'
fp = open(ptable_bin,'r') 
#read ptale head
ptable_head = fp.read(48)
print 'ptable_head=',ptable_head

#parse partitions information
partition_dict = {}
running = True
while running:
    part_name = fp.read(16)
    end = '\0'
    nPos = part_name.index(end)
    part_name = part_name[0:nPos]
    #print 'part_name =',part_name
    if part_name == 'T':
        running = False
        continue
    fp.seek(8,1)
    
    lenth_org = fp.read(1)
    lenth1 = binascii.b2a_hex(lenth_org)
    
    lenth_org = fp.read(1)
    lenth2 = binascii.b2a_hex(lenth_org)
    
    lenth_org = fp.read(1)
    lenth3 = binascii.b2a_hex(lenth_org)
    
    lenth_org = fp.read(1)
    lenth4 = binascii.b2a_hex(lenth_org)
    
    part_lenth = lenth4 + lenth3 + lenth2 + lenth1
    part_lenth = string.atoi(part_lenth,16)
    #print part_lenth
    if part_name == 'system':
        fp.seek(12,1)
        propoty1_org = fp.read(1)
        propoty1 = binascii.b2a_hex(propoty1_org)
        print 'propoty1 =',propoty1
      	if propoty1 == '01':
      	    system_is_yaffs = 1
      	    print 'system_is_yaffs =',system_is_yaffs
        fp.seek(7,1)
        partition_dict[part_name] = part_lenth
    elif part_name == 'webui':
        fp.seek(12,1)
        propoty2_org = fp.read(1)
        propoty2 = binascii.b2a_hex(propoty2_org)
        print 'propoty2 =',propoty2
      	if propoty2 == '01':
      	    webui_is_yaffs = 1
      	    print 'webui_is_yaffs =',webui_is_yaffs
        fp.seek(7,1)
        partition_dict[part_name] = part_lenth
    elif part_name == 'app':
        fp.seek(12,1)
        propoty3_org = fp.read(1)
        propoty3 = binascii.b2a_hex(propoty3_org)
        print 'propoty3 =',propoty3
      	if propoty3 == '01':
      	    app_is_yaffs = 1
      	    print 'app_is_yaffs =',app_is_yaffs
        fp.seek(7,1)
        partition_dict[part_name] = part_lenth
    else:
        #print part_lenth
        fp.seek(20,1)
        partition_dict[part_name] = part_lenth
       
    
fp.close()

#print dictionnary 
print '%20s %20s' %('partition_name', 'partition_size')
for name,len in partition_dict.items():
    print '%20s %20s' %(name,hex(len))
        
#process name and len
for name,len in partition_dict.items():
    if name == 'kernel':
        bin_name = 'boot.img'
        cpio_bin_name = 'boot.img'
    elif name == 'm3boot':
        bin_name = 'm3boot.bin'
        cpio_bin_name = 'm3boot.bin'
    elif name == 'm3image':
        bin_name = 'bsp_mcore.bin'
        cpio_bin_name = 'bsp_mcore.bin'
    elif name == 'kernelblk':
        bin_name = 'boot.img'
        cpio_bin_name = 'boot.img'        
    elif name == 'fastboot':
        bin_name = 'fastboot.img'
        cpio_bin_name = 'fastboot.img'
    elif name == 'vxworks':
        bin_name = 'balongv7r2_mcore.bin'
        cpio_bin_name = 'balongv7r2_mcore.bin'
    elif name == 'nvimg':
        bin_name = 'nv.bin'
        cpio_bin_name = 'nv.bin'        
    elif name == 'dsp':
        bin_name = 'lphy.bin'
        cpio_bin_name = 'lphy.bin' 
    elif name == 'app':
        bin_name = 'app.img'
        cpio_bin_name = 'app.cpio'
    elif name == 'system':
        bin_name = 'system.img'
        cpio_bin_name = 'system.cpio'
    elif name == 'webui':
        #DTS2016011906908 add by x00205748 for webui.cpio size check begin
        bin_name = 'webui.cpio'
        #DTS2016011906908 add by x00205748 for webui.cpio size check end
        cpio_bin_name = 'webui.cpio'
    else:
        bin_name = ''    
        
    if bin_name != '':
        #EXCEPTION1:the bin_name is not exist
        bin_abs_path = firm_dload_packet_dir + '/' + bin_name
        cpio_abs_path = firm_dload_packet_dir + '/' + cpio_bin_name
        if not os.path.exists(bin_abs_path):
           print bin_abs_path,' is not exist' 
           continue
        else:
           fp = open(bin_abs_path,'r')
           fp.seek(0,2)
           bin_len = fp.tell()
           fp.close()
    else:
        continue
        
    print 'partition: %s' %(name)
    print 'partition_len =',len,'=',hex(len)
    print 'bin_len before compressed =',bin_len,'=',hex(bin_len)  
    if bin_name == 'webui.img':
        if webui_is_yaffs == 0:
            bin_len = bin_len * 7/10
    elif bin_name == 'app.img':
        if app_is_yaffs == 0:
            bin_len = bin_len * 7/10
    elif  bin_name == 'system.img':
        if system_is_yaffs == 0:
            print 'system_is_yaffs =',system_is_yaffs 
            bin_len = bin_len * 7/10
    else:
        bin_len = bin_len
    print 'bin_len after compressed =',bin_len
          
    
    #EXCEPTION2: bin's len is larger than the partitiion's len
    if bin_len >= len:
       print 'bin\'s len is larger than partition\'s len'
       print bin_abs_path
       os.system('rm -r -f ' + bin_abs_path)
       os.system('rm -r -f ' + cpio_abs_path)
       continue
         
    if len < 0:
        continue
    elif len <= 1*1024*1024:
        max_len = len/2
    elif len <= 2*1024*1024:
        max_len = len*8/10
    elif len <= 20*1024*1024:
        max_len = len*9/10
    else:
        max_len = len*95/100
    print 'max_len =',max_len,'=',hex(max_len)
    
    #EXCEPTION3: bin's len is larger than max_partion's len
    if bin_len > max_len:
        print bin_name,'is too big'
        os.system('rm -r -f ' + bin_abs_path)
        os.system('rm -r -f ' + cpio_abs_path)
        print bin_name,' is removed'
    else:
        print bin_name,' size is ok'    
        print ''
        
    
     
    #DTS2016011906908 add by x00205748 for webui.cpio size check begin
    # check cpio
    if bin_name == 'webui.cpio':
        partblks = len/(4*1024*64)
        cpio_check_cmd ="cd scripts && ./allign_4k.sh " + bin_abs_path + " " + str(partblks)
        print cpio_check_cmd
        rc = os.system(cpio_check_cmd)
        if rc != 0:
            print bin_name,'is too big'
            os.system('rm -r -f ' + bin_abs_path)
            os.system('rm -r -f ' + cpio_abs_path)
            print bin_name,'is removed'
    #DTS2016011906908 add by x00205748 for webui.cpio size check end
        
    
   
