/* link.RAM - gnu linker command file for VxWorks: RAM */

/* Copyright 1984-2007 Wind River Systems, Inc. */

/* This file was automatically generated using tool/common/ldscripts. */

/*
modification history
--------------------
01y,13nov08,mcm  Fix for WIND00143294 - gnu.linkonce.b sections not handled
                 correctly. Also added .bss.* and .sbss.*
01x,06may08,mcm  Changes for GNU Dwarf EH
01w,16oct07,sn   WIND00107939:fixed LMAs of .sdata etc. for Diab
01v,11jul07,pes  Update and rename generation of .kseg0data segment. (Renamed
                 to .kseg0bss.) Add .rodata.cst16 segment.
01u,07jul07,mcm  Fixing position of .tls* sections and adding support for tls
                 for GCC.
01t,08jun07,r_s  add support for Small Data Area segments.
01s,09nov06,gvm  Support for .tls_data, .tls_vars, and associated absolute
                 symbols in the Diab linker script
01r,25aug05,dlk  Support .text.init, .text.fast, .data.init, .data.fast.
01r,29jul05,slk  SPR 104264: fix MIPS romResident images
01q,06may05,rlg  changes for MIPS specific devices
01p,03jul04,f_b  Improved support for data alignment
01o,12dec03,sn   added more .rodata.str1.* handlers
01n,04dec03,sn   Diab: .rodata.* is not handled correctly by Diab linker; instead
		 use specific names
01m,28oct03,sn   Diab: collapse .rodata.cst* sections into .rodata
01l,29may02,tpw  Diab: pad out sections, needed for MIPS byteswap. SPR 78076
01k,24apr02,sn   GNU: SPR 75835 - added support for relocatable script link.OUT
01j,19apr02,tpw  Diab: provide _etext for ColdFire. SPR 75122
01i,06feb02,sn   Both: place .got2 to handle tramp.o (_x_gnu_tramp.o).
01h,25jan02,tpw  GNU: give debug sections explicit 0 addresses.
01g,14jan02,tpw  Diab: place .eh_frame data, in case of insistent GNU objects.
01f,14dec01,tpw  Diab: provide both underscore options of wrs_kernel* here too.
01e,05dec01,tpw  Both: Add .boot and .reset section support, for PPC 4xx series
                 and Book E.
01d,05dec01,tpw  Diab: Add .frame_info section to text region.
01c,03dec01,jab  Diab: replaced LOAD() with AT()
01b,14nov01,tpw  ALL: Correct some more bootrom/kernel issues.
01b,06nov01,tpw  GNU: Add /DISCARD/ directive to discard uninteresting sections
01a,01nov01,tpw  gnu script written
01a,29oct01,jab  diab script written
*/

ENTRY(_start)
SECTIONS
{
  .text      :
  {
    wrs_kernel_text_start = .; _wrs_kernel_text_start = .;
    _VX_START_TEXT = .;
    *(.text)
    wrs_kernel_text_fast = .; _wrs_kernel_text_fast = .;
    *(.text.fast)
    wrs_kernel_text_init = .; _wrs_kernel_text_init = .;
    *(.text.init)
    *(.text.*) *(.stub) *(.gnu.warning) *(.gnu.linkonce.t*)
    KEEP(*(.init)) KEEP(*(.fini))
    *(.glue_7t) *(.glue_7) *(.rdata)			/* for ARM */
    *(.mips16.fn.*) *(.mips16.call.*) *(.reginfo)	/* for MIPS */
    *(.rodata) *(.rodata.*) *(.gnu.linkonce.r*) *(.rodata1)
    . = ALIGN(16);
    . = ALIGN (4);
    *(.eh_frame_hdr)
    . = ALIGN (4);
    __EH_FRAME_BEGIN__ = .;
    KEEP (*(.eh_frame))
    LONG (0)
    . = ALIGN (4);
    *(.gcc_except_table .gcc_except_table.*)
  }
  .sdata2      : {
    _SDA2_BASE_ = . + 0x7ff0 ;
    *(.sdata2) *(.sbss2)				/* for PPC */
    . = ALIGN(16);
  }
  . = ALIGN(16);
  wrs_kernel_text_end = .; _wrs_kernel_text_end = .;
  etext = .; _etext = .;
  . = ALIGN(_VX_DATA_ALIGN);
  .data    :
  {
    wrs_kernel_data_start = .; _wrs_kernel_data_start = .;
    _VX_START_DATA = .;
	_sci_cfg_data_start = .;
    *(.sci.cfg.data)
    _sci_cfg_data_end = .;
    _sci_init_data_start = .;
    *(.sci.init.data)
    _sci_init_data_end = .;
    _sci_record_data_start = .;
    *(.sci.record.data)
    _sci_record_data_end = .;
    escidata = .;
    
    . = ALIGN(16);
    g_uw_phy_data_start = .;
    *(.phy_data)  
    g_uw_phy_data_end = .;
    . = ALIGN(16);	
    
    *(.data)
    wrs_kernel_data_fast = .; _wrs_kernel_data_fast = .;
    *(.data.fast)
    wrs_kernel_data_init = .; _wrs_kernel_data_init = .;
    *(.data.init)
    *(.data.*) *(.gnu.linkonce.d*) SORT(CONSTRUCTORS) *(.data1)
    KEEP (*crtbegin.o(.ctors))
    KEEP (*(EXCLUDE_FILE (*crtend.o) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
    KEEP (*crtbegin.o(.dtors))
    KEEP (*(EXCLUDE_FILE (*crtend.o) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*(.dtors))
    /* got*, dynamic, sdata*, lit[48], and sbss should follow _gp */
    *(.got.plt) *(.got) *(.dynamic)
    *(.got2)
    *(.lit8) *(.lit4)
    . = ALIGN(16);
  }
  wrs_kernel_tls_data_start = .; _wrs_kernel_tls_data_start = .;
  .tls_data     : {
    *(.tls_data)
  }
  wrs_kernel_tls_data_size = . - wrs_kernel_tls_data_start; _wrs_kernel_tls_data_size = . - _wrs_kernel_tls_data_start;
  wrs_kernel_tls_data_align = 16; _wrs_kernel_tls_data_align = 16;
  wrs_kernel_tls_vars_start = .; _wrs_kernel_tls_vars_start = .;
  .tls_vars     : {
    *(.tls_vars)
  }
  wrs_kernel_tls_vars_size = SIZEOF(.tls_vars); _wrs_kernel_tls_vars_size = SIZEOF(.tls_vars);
  . = ALIGN(16);
  _gp = ALIGN(16) + 0x7ff0;		/* set gp for MIPS startup code */
  .sdata     :
  {
    _SDA_BASE_ = . + 0x7ff0 ;
    *(.sdata) *(.sdata.*)
    . = ALIGN(16);
  }
  . = ALIGN(16);
  edata = .; _edata = .;
  wrs_kernel_data_end = .; _wrs_kernel_data_end = .;
  .sbss      :
  {
    wrs_kernel_bss_start = .; _wrs_kernel_bss_start = .;
    *(.sbss) *(.sbss.*) *(.scommon) 
    . = ALIGN(16);
  }
  .bss       :
  {
    *(.dynbss) *(.bss) *(.bss.*) *(COMMON) *(.gnu.linkonce.b*)
    . = ALIGN(16);
  }
  . = ALIGN(16);
  end = .; _end = .;
  wrs_kernel_bss_end = .; _wrs_kernel_bss_end = .;

  /DISCARD/ :
  {
  *(.note)				/* seen on Pentium ELF */
  *(.comment)				/* seen on PPC & SH ELF */
  *(.pdr)				/* seen on MIPS ELF */
  }
  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
}
