# @description:
#       caculate how mant tnode we need in yaffs2
# @depends:
#       only support yaffs2, nand page size 4K
# @author:
#       xuxiaocong 00205748
# @date:
#       2015/12/05
# @edit history:
#  when          who        why
#  2015/12/05  x00205478  creae this file 

#!/bin/bash

get_ntnodes()
{
    node=$1
    level=0
    rest=0
    total=0

    if [ $node -eq 0 ]
    then
        echo 0 
        return
    fi

    if [ $node -eq 1 ]
    then
        echo 1
        return
    fi

    while [ $node -ne 1 ];
    do
        if [ $level -eq 0 ]
        then
            let "rest = node%16"
            let "node = node/16"    
        else
            let "rest = node%8"
            let "node = node/8"    
        fi

        let "total += node"
        if [ $rest -ne 0 ]
        then
            let "total += 1"
            let "node += 1"
        fi
        
        let "level += 1"
    done 
    echo "$total"
}

get_ntnodes $1

exit 0
