# @description:
#       caculate how many checkpoint blocks we need in yaffs2
# @depends:
#       only support yaffs2, nand page size 4K
# @author:
#       xuxiaocong 00205748
# @date:
#       2015/12/05
# @edit history:
#  when          who        why
#  2015/12/05  x00205478  creae this file 

#!/bin/bash

#
# see  yaffs_yaffs2.c
#
#int yaffs_calc_checkpt_blocks_required(struct yaffs_dev *dev)
#		dev_blocks = dev->param.end_block - dev->param.start_block + 1;
#		n_bytes += sizeof(struct yaffs_checkpt_validity);
#		n_bytes += sizeof(struct yaffs_checkpt_dev);
#		n_bytes += dev_blocks * sizeof(struct yaffs_block_info);
#		n_bytes += dev_blocks * dev->chunk_bit_stride;
#		n_bytes +=
#		    (sizeof(struct yaffs_checkpt_obj) + sizeof(u32)) *
#		    dev->n_obj;
#		n_bytes += (dev->tnode_size + sizeof(u32)) * dev->n_tnodes;
#		n_bytes += sizeof(struct yaffs_checkpt_validity);
#		n_bytes += sizeof(u32);	/* checksum */

#		n_blocks =
#		    (n_bytes /
#		     (dev->data_bytes_per_chunk *
#		      dev->param.chunks_per_block)) + 3;

#		dev->checkpoint_blocks_required = n_blocks;

nblocks=$1
nobj=$2
ntnode=$3

nbytes=0
nchkpnt=0

let "nbytes += 16"
let "nbytes += 36"
let "nbytes += nblocks*8"
let "nbytes += nblocks*8"
let "nbytes += nobj*36"
let "nbytes += ntnode*36"
let "nbytes += 16"
let "nbytes += 4"

let "nchkpnt = nbytes/4096"
let "nchkpnt /= 64"
let "nchkpnt += 3"

echo "$nchkpnt"

exit 0
