# @description:
#       caculate how much space needed by file
# @depends:
#       only support yaffs2, nand page size 4K
# @author:
#       xuxiaocong 00205748
# @date:
#       2015/06/06
# @edit history:
#  when          who        why
#  2015/06/06  x00205478  creae this file 

#!/bin/bash

#webcpio路径
cpiopath=$1
webpath="webcpio_tmp"
#web分区block数
partblks=$2

total_page=0
total_blk=0
nobj=0

# see  
# reserved by yaffs2 = 5+1
reserv_blk=6
chkpnt_blk=0
page_per_blk=64

if [ $# != 2 ];then
    echo "usage: ./allign_4k.sh cpio_path part_blocks"
    exit 255
fi

#
# 函数名： get_pagenum_in_4k
# 输入：   文件大小
#          $1 文件大小
# 输出：   计算出该文件占用多少个page(4K 对齐)，以及存储这些page位置所需要的tnode数量
#          pagenum: 文件占用的page个数
#          tnodes:  文件占用的tnode个数
# 依赖：   对于每一个object计算一次
# 说明：   对于普通文件，obj_header占用一个page, 文件内容占据size/4096个page 
#          对于特殊文件，只包含obj_header,占用一个page
get_pagenum_in_4k()
{
    realsize=$1

    let "pagenum = realsize/4096"
    let "rest = realsize%4096"

    if [ $rest -ne 0 ];then
        let "pagenum += 1"
    fi

    # obj_header need one extra page
    let "pagenum += 1"

    if [ $1 -ne 0 ];then
        tnodes=`./get_ntnodes.sh $pagenum`
        let "ntnodes += tnodes"
    fi

    let "total_page += pagenum"
    let "nobj += 1"
}

# 
# 将cpio还原成文件
#
rm -rf $webpath
mkdir $webpath
cp $cpiopath $webpath
cd $webpath && cpio -idm < webui.cpio && rm -rf webui.cpio && cd ..

# 
# 遍历目录下面所有普通文件，计算其占用的page个数
#
for file in $(find $webpath -type f)
do
    #log=${file##*/}
    size=`ls -la $file | awk '{print $5}'`
    #echo "$file "
    let "common_files += 1"
    get_pagenum_in_4k $size
done

# 
# 遍历目录下面所有特殊文件(目录、软硬链接、设备文件等)，计算其占用的page个数
#
for file in $(find $webpath ! -type f)
do
    #echo "$file "
    let "special_files += 1"
    get_pagenum_in_4k 0
done

#
# 得到了所有文件占用的page个数，计算它们占用多少block
# 每个block有一个page用作summary, 所以实际只有63个可用
#
let "total_blk = total_page/63"
let "rest = total_page%63"

if [ $rest -ne 0 ];then
    let "total_blk += 1"
fi

#
# 修正计算出的ntnodes和nobj，保证跟/proc/yaffs输出的结果一致
#
let "ntnodes += 2"
let "nobj += 2"

#
# 计算checkpoint需要的block数
#
chkpnt_blk=`./get_nchkpnt.sh 192 $nobj $ntnodes`

#
# 最终的page数=文件占用page + summary + reserv + checkpoint
# 其中文件占用page就是total page， 通过遍历文件算出
# summary 是每一个block单独占用一个page
# reserved 是文件系统保留的5个block, 计算空间时+1=6
# checkpoint 在get_nchkpnt.sh脚本通过公式算出，是分区block数、tnode数、obj数乘以特定系数再加上3个blcok得出
#
let "total_page += total_blk"
let "ext_page += reserv_blk*64"
let "ext_page += chkpnt_blk*64"
let "total_page += ext_page"

echo "folder       : $webpath"
echo "common_files : $common_files"
echo "special_files: $special_files"
echo "total_pages  : $total_page"
echo "total_blocks : $total_blk"
echo "total_objs   : $nobj"
echo "total_tnodes : ${ntnodes}"

let "total_page *= 4"
echo "total_space  : ${total_page} KBytes"

let "maxblks = partblks*9/10"

rm -rf $webpath

if [ "$total_blk" -gt "$maxblks" ]
then
    echo "error: total blocks($total_blk) exceed 90% of partblks($partblks)"
    exit 255
fi 

exit 0
