#!/bin/sh

GIT_FILE=.repo/manifest.xml
OUT_FILE=`pwd`/git_total.log

###############################################################
#         List all git repository and run cmd
###############################################################
function run_cmd()
{
	while read LINE
	do
		git_path=`echo ${LINE} |grep '^<project path'|sed 's/=/ /g'|sed 's/\"//g'|awk '{print $3}'` > /dev/null
		isBlank=`echo "${git_path}"|grep -c ^[[:space:]]*$`  > /dev/null
        if [ "${isBlank}" -ne 0 ]; then
			continue
		fi
		
		echo "================= git ${1} ${git_path} =====================">>${OUT_FILE}
		if [ "${git_path}" == "vendor/hisi/modem/system/vxworks" ]; then
			echo "[INFO] ${git_path} is not exist!"
			continue
		fi
		if [ ! -d ./${git_path} ]; then 
			echo "[ERROR] ${git_path} is not exist!"
		fi 
		
		cd ./${git_path};git ${1} >>${OUT_FILE};cd - 
	done < ${GIT_FILE}
	echo -e "############################################################################"
	echo -e "#\033[40;36;1mPlease check log in `pwd`/${git_path}${OUT_FILE}\033[0m"
	echo -e "############################################################################"
}

function git_status()
{
	run_cmd status> /dev/null
}

echo "####################################################"
echo "#        Operate all git repository                 "
echo "####################################################"
cd ../../../
pwd >${OUT_FILE}

while true
do
echo "####################################################"
echo "###  Please choose what do you want to do:       ###"
echo "###  s: staus                                    ###"
echo "###  m: merge                                    ###"
echo "###  r: rebase                                   ###"
echo "###  c: commit                                   ###"
echo "###  q: exit                                     ###"
echo "####################################################"
echo -e "\033[40;36;1mPlease choose what do you want to do: \033[0m"
    read CMD
    case $CMD in
		s)
			git_status
			continue
			;;
		m)
			;;
		r)
			;;
		c)
			;;
		q)
			echo "Thank You, Bye Bye!"
			exit 0
			;;
		*)
			echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"
			continue;
			;;
	esac
done
echo "Thank you, Bye bye~"