#!/bin/bash

BUILD_PRODUCT=""
BUILD_MODE=""
BUILD_MODULE=""
CLEAN_MODULE=""


function build()
{
    case $BUILD_MODE in
		release)
			echo "Now going to build $BUILD_PRODUCT $BUILD_MODULE release, ready go!!!"
			./obuild.py product=hi6921_v711_$BUILD_PRODUCT $BUILD_MODULE publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
		;;
		burn)
			echo "Now going to build $BUILD_PRODUCT $BUILD_MODULE burn, ready go!!!"
			./obuild.py product=hi6921_v711_$BUILD_PRODUCT distclean
			./obuild.py product=hi6921_v711_$BUILD_PRODUCT $BUILD_MODULE NV_BURN=true publish=true		
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
		;;
		clean)		
			echo "Now going to Clean $BUILD_PRODUCT $CLEAN_MODULE, ready go!!!"
                        ./obuild.py product=hi6921_v711_$BUILD_PRODUCT $CLEAN_MODULE distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
	    ;;
	esac
}

function module_select()
{
	echo "|---------------------------------------------|"
	echo "|  1: all                                     |"
	echo "|  2: acore                                   |"
	if [[ ${BUILD_MODE} != "clean" ]] 
	then 
	    echo "|  3: ccore_libs                              |"
	else 
	    echo "|  3: ccore                                   |" 
	fi
        echo "|  4: mcore                                   |"
	if [[ ${BUILD_MODE} != "clean" ]] 
	then 
	    echo "|  5: mcore_libs                              |"
	    echo "|  6: libs                                    |"
#	    echo "|  7: pkg                                     |"
	fi	
	echo "|---------------------------------------------|"
	echo "|  q: exit                                    |"
	echo "|---------------------------------------------|"
    echo -e "\033[40;36;1mPlease choose build module: \033[0m"
	
	read LINE
    case $LINE in
		1)
		    BUILD_MODULE=""
			CLEAN_MODULE=""
		;;
		2)
			BUILD_MODULE="acore"
			CLEAN_MODULE="clean-acore"
		;;	
		3)
			BUILD_MODULE="ccore_libs"
			CLEAN_MODULE="clean-ccore"
		;;
		4)
			BUILD_MODULE="mcore"
			CLEAN_MODULE="clean-ccore"
		;;
		5)
		    if [[ ${BUILD_MODE} != "clean" ]] 
			then
				BUILD_MODULE="mcore_libs"
				CLEAN_MODULE=""
			else 
				echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"

				module_select
			fi
			    
		;;
		6)
		    if [[ ${BUILD_MODE} != "clean" ]] 
			then
			    BUILD_MODULE="libs"
				CLEAN_MODULE=""
			else 
			    echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"
				module_select
			fi
		;;		
		q)
			echo "Thank You, Bye Bye!"
			exit 0
		;;
		*)
			echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"
			module_select
		;;
	esac
}

function mode_select()
{
	echo "|---------------------------------------------|"
	echo "|  1: release                                 |"
	echo "|  2: burn                                    |"
	echo "|  3: clean                                   |"
	echo "|---------------------------------------------|"
	echo "|  q: exit                                    |"
	echo "|---------------------------------------------|"
	echo -e "\033[40;36;1mPlease choose build mode: \033[0m"
	
	read LINE
    case $LINE in
		1)
		    BUILD_MODE="release"
		;;
		2)
			BUILD_MODE="burn"
			
		;;	
        3)
		    BUILD_MODE="clean"
		;;		
		q)
			echo "Thank You, Bye Bye!"
			exit 0
		;;
		*)
			echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"
			mode_select
		;;
	esac
}
echo "##################################################################################################################################"
echo "#                                                                                                                                #"
echo "# x   x        xxxxxxxxx                                          x              x            x   x  x   x     x     x  xxxxxx   #"
echo "#  x  xxxxxxx  x   x   x                           xxxxxxxxx     x               xxxxx xxxx  x  x x x    x  xxxxxxx   x  x   x   #"
echo "#    x         x   x   x  xx  xxxxxxx xxxx   xxx       x        x     x         x  x   x  x xxxxx xx    x   x     x       x x    #"
echo "#   x xxxxxx   xxxxxxxxx   x  x x  x   x  x x   x  x   x   x   x       x           x   x  x       x   x x x xxxxxxx        x     #"
echo "# x   x    x   x   x   x   x  x    x   x  x x   x   x  x   x  xxxxxxxxxxx       xxxxxx x  x  xxxx  xxxx xx  x       xx    x x    #"
echo "#  x  x x  x   x   x   x   x x    x    xxx     x    x  x  x             x         x x  xxxx  x  x        x  xxxxxxx  x  xx x xx  #"
echo "#   xxxxxxxxx  xxxxxxxxx   x x    x    x x    x        x       xxxxxxxxx         x   x       xxxx x     x   x x x x  x     x     #"
echo "#    x     x       x        xx    x    x  x  x    xxxxxxxxxxx  x       x        x xxxxxxxx   x  x x  x  xx xx x x x  x   xxxxx   #"
echo "#    x  x  x   x x  x  x    x     x    x  x x          x       x       x          x      x   xxxx x x       xxxxxxx  x x   x     #"
echo "#  x xxxxxxxx  x x  x   x   x     x   xxx xxxxxxx      x       x       x          xxxxxxxx   x  x xx  x   x x x x x  xx xxxxxxx  #"
echo "# x        x  x  x    x x                              x       xxxxxxxxx          x      x   x  x x   x xx  x x x x  x     x     #"
echo "#        xx       xxxxx                                x       x       x          xxxxxxxx   x xx  xxxx     x    xx        x     #"
echo "#                                                                                                                                #"
echo "##################################################################################################################################"

while true
do
echo "####################################################"
echo "###  Please choose build product:                ###"
echo "###  1: e5                                       ###"
echo "###  2: wingle                                   ###"
echo "###  3: cpe                                      ###"
echo "###  4: stick                                    ###"
echo "###  5: hilink                                   ###"
echo "###  6: solution                                 ###"
echo "###  7: build all products above                 ###"
echo "###  8: clean all products above                 ###"
echo "###----------------------------------------------###"
echo "###  +: Build Coverity(just for E5)              ###"
echo "###  -: Build Fortify (just for E5)              ###"
echo "###----------------------------------------------###"
echo "###  q: exit                                     ###"
echo "####################################################"
echo -e "\033[40;36;1mPlease choose build product: \033[0m"
    read LINE
    case $LINE in

		1)
		    BUILD_PRODUCT="e5"
			mode_select
			module_select
			build			
		;;
		2)
		    BUILD_PRODUCT="wingle"
			mode_select
			module_select
			build			
		;;
		3)
		    BUILD_PRODUCT="cpe"
			mode_select
			module_select
			build			
		;;
		4)
		    BUILD_PRODUCT="stick"
			mode_select
			module_select
			build			
		;;
		5)
		    BUILD_PRODUCT="hilink"
			mode_select
			module_select
			build			
		;;
		6)
		    BUILD_PRODUCT="solution"
			mode_select
			module_select
			build			
		;;
		7)
		    echo "Now going to Build all products given above, ready go!!!"
			./obuild.py product=hi6921_v711_e5 distclean
			./obuild.py product=hi6921_v711_wingle distclean
			./obuild.py product=hi6921_v711_stick distclean
			./obuild.py product=hi6921_v711_cpe distclean
			./obuild.py product=hi6921_v711_hilink distclean
			./obuild.py product=hi6921_v711_solution distclean
			./obuild.py product=hi6921_v711_e5 publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			if [ ! -d "./delivery/build_all" ]; then mkdir "./delivery/build_all"; fi
			cp -fpr delivery/hi6921_v711_e5  delivery/build_all/
			./obuild.py product=hi6921_v711_e5 distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_wingle distclean
			./obuild.py product=hi6921_v711_wingle publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			cp -fpr delivery/hi6921_v711_wingle  delivery/build_all/
			./obuild.py product=hi6921_v711_wingle distclean
			./obuild.py product=hi6921_v711_cpe distclean
			./obuild.py product=hi6921_v711_cpe publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			cp -fpr delivery/hi6921_v711_cpe  delivery/build_all/
			./obuild.py product=hi6921_v711_cpe distclean
			./obuild.py product=hi6921_v711_stick distclean
			./obuild.py product=hi6921_v711_stick publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			cp -fpr delivery/hi6921_v711_stick  delivery/build_all/
			./obuild.py product=hi6921_v711_stick distclean
			./obuild.py product=hi6921_v711_hilink distclean
			./obuild.py product=hi6921_v711_hilink publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			cp -fpr delivery/hi6921_v711_hilink  delivery/build_all/
			./obuild.py product=hi6921_v711_hilink distclean
			./obuild.py product=hi6921_v711_solution distclean
			./obuild.py product=hi6921_v711_solution publish=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			cp -fpr delivery/hi6921_v711_solution  delivery/build_all/
		;;
		8)
		    echo "Now going to Clean all products given above, ready go!!!"
			./obuild.py product=hi6921_v711_e5   distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_wingle distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_cpe distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_stick distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_hilink distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
			./obuild.py product=hi6921_v711_solution distclean
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
		;;
		+)
		    echo "Now going to Build Coverity(just for E5), ready go!!!"
			./obuild.py product=hi6921_v711_e5 publish=true TQE=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
		;;
		-)
		    echo "Now going to Build Fortify(just for E5), ready go!!!"
			./obuild.py product=hi6921_v711_e5 publish=true FORTIFY=true
			if [ $? -ne 0 ]; then echo "#########   compile ERROR    #########"; exit 255; fi
		;;
		q)
			echo "Thank You, Bye Bye!"
			exit 0
		;;
		*)
			echo -e "\033[40;31;1mSorry, Not support, please check your input!\033[0m"
    esac
	echo "===================================================="
	echo ""
done



