# @description:
#       simplely build b310 cpe
# @depends:
#       none
# @author:
#       xuxiaocong 00205748
# @date:
#       2014/09/18
# @edit history:
#  when          who        why
#  2014/09/18  x00205478  creae this file 
#  2014/10/10  x00205478  support b315s-22 etc
#  2014/10/22  x00205478  support NV_BURN option
#  2014/10/27  x00205478  optimize build flow
#  2015/01/04  x00205478  simplize prod type
#  2015/01/12  c00121606  add ha35
#  2015/03/14  x00205748  support debug & ci option
#  2015/03/14  x00205748  support aging option
#  2015/05/27  wwx278429  close safe upgrade for aging
#  2015/08/26  wwx278429  support debug version macro
#  2015/10/13  x00205748  release version disable log 
#  2015/10/26  x00205748  support lite version

#!/bin/bash

all_sub_models[1]="b310"
all_sub_models[2]="b315"
all_sub_models[3]="ha35"

all_ver_types[1]="release"
all_ver_types[2]="factory"
all_ver_types[3]="debug"
all_ver_types[4]="ci"
all_ver_types[5]="aging"
all_ver_types[6]="lite"

product_name=hi6921_v711_cpe
sub_model=""
ver_type=""

nv_burn=""
codecc=""

make_py=./obuild.py
sw_ver=""

code_base=`cd ..;pwd`
config_base=`pwd`
prod_config_file="$code_base/config/product/hi6921_v711_cpe/define/product_config.define"
sys_start_file="$code_base/modem/eUAP/device/huawei-mbb/p711/cpe/release/rootdir/etc/huawei_process_start"
app_config_file="$code_base/modem/eUAP/device/huawei-mbb/p711/cpe/product.min"
mbb_config_file="$code_base/config/product/MBB_CONFIG/mbb_macro_config/$product_name.h"
nvm_config_file="$code_base/config/nvim/data/product/hi6921/NV_Diff_Config_CPE_Product.xml"

usage()
{
        echo "usage: ./build_cpe.sh cpe_sub_model ver_type " 
        echo -n "       sub models:"
        for i in "${all_sub_models[@]}"
        do
                echo -n " $i"
        done       

        echo     
        echo -n "       ver_type  :"
        for i in "${all_ver_types[@]}"
        do
                echo -n " $i"
        done            

        echo 
}

make_copy()
{
        config_dir=$config_base/b310_config/$1
        def_config_dir=$config_base/b310_config/default
        echo "current  model: $1"
        echo "default config: $def_config_dir"
        echo "configs   base: $config_dir"
        echo "source    base: $code_base"
        echo

        # always restore default config 
        cd $def_config_dir
        for dir in *
        do 
                if [ -d $dir ];then
                        cp -R $def_config_dir/$dir/* $code_base/$dir
                fi
        done

        cd $config_dir
        for dir in *
        do 
                if [ -d $dir ];then
                        cp -R $config_dir/$dir/* $code_base/$dir
                fi
        done
        
        # return to hisi/build
        cd $config_base
}

check_factory()
{
    if [ "$1" == "factory" ];then
        nv_burn="NV_BURN=true"
    fi
}

check_debug()
{
    if [ "$1" == "debug" ];then
        sed -i '/CFG_FEATURE_HISOCKET/s/OFF/ON/' $prod_config_file
        #/* BEGIN:   Added for PN:DTS2015110906115   by x00353189, 2015/11/1 > */
        sed -i '/CFG_FEATURE_DATALOCK_OPEN_HIDS/s/ON/OFF/' $prod_config_file
        sed -i '/FEATURE_DATALOCK_OPEN_AT_SHELL/d' $app_config_file
        #/* END:   Added for PN:DTS2015110906115   by x00353189, 2015/11/1 > */
        #/* BEGIN:   Added for PN:DTS2016010704417   by WX297026, 2016/01/12 > */
        sed -i '/CFG_PRODUCT_DLOAD_SOFTWARE_VER/s/DLOAD/NOTUSED/' $prod_config_file
        #/* END:   Added for PN:DTS2016010704417   by WX297026, 2016/01/12 > */
        sed -i '/CFG_PRODUCT_DEMO_SOFTWARE_VER/s/DEMO/DLOAD/' $prod_config_file
        sed -i '/MBB_FEATURE_RELEASE_DISABLE_LOG/d' $app_config_file
        echo "atproxy&" >> $sys_start_file
        echo "busybox telnetd -p 8023 -l sh" >> $sys_start_file
    fi 
}

check_ci()
{
    if [ "$1" == "ci" ];then
        codecc=true
        echo "codecc = $codecc"
    fi
}

check_aging()
{
    sed -i '/AGING/d' $app_config_file
    if [ "$1" == "aging" ];then
        sed -i '/LOCAL_CFLAGS += $(APP_DEFINE)/i\APP_DEFINE += -DFEATURE_HUAWEI_MBB_AGING' $app_config_file
        sed -i '/#define MBB_COMMON FEATURE_ON/a\#define FEATURE_HUAWEI_MBB_AGING FEATURE_ON' $mbb_config_file
        sed -i '/MBB_DLOAD_VER_VERIFY/s/ON/OFF/' $mbb_config_file
        nv_burn="NV_BURN=true"
    fi
}

check_lite()
{
    if [ "$1" == "lite" ];then
        make_py=./obuild_lite.py
    fi
}

#
# to make sure the version writen in NV 50018 and product_config.define
# is the same
#
sync_ver()
{
    sw_ver=`grep "CFG_PRODUCT_DLOAD_SOFTWARE_VER" $prod_config_file| sed -r 's/"/ /g' | awk '{print $3}'`
    sed -i -r "/NV_ID_DRV_NV_DRV_VERSION_REPLACE_I/s/,\{[0-9a-zA-Z.]*/,\{$sw_ver/" $nvm_config_file 
}

if [ "$#" != "2" ];then
    usage
    exit 255
else
    # get sub model: start
    for i in "${all_sub_models[@]}"
    do
        if [ "$i" == "$1" ];then
            sub_model=$1
            break
        fi      
    done

    if [ "$sub_model" == "" ];then
        echo "error: unsupport sub model $1"
        usage
        exit 254
    fi 
    # get sub model: end

    # get ver type: start
    for i in "${all_ver_types[@]}"
    do
        if [ "$i" == "$2" ];then
            ver_type=$2
            break
        fi      
    done

    if [ "$ver_type" == "" ];then
        echo "error: unsupport ver_type $2"
        usage
        exit 253
    fi 
    # get ver type: end
fi

check_factory $ver_type
check_ci      $ver_type

make_copy   $sub_model
check_aging $ver_type
check_debug $ver_type
check_lite  $ver_type

sync_ver
echo "now will build: $sub_model, ver_type=$ver_type sw_ver=$sw_ver"

#exit 0

if [ "$nv_burn" == "NV_BURN=true" ];then
        echo ""
        rm -fr delivery/hi6921_v711_cpe delivery/usbloader
        ./obuild.py product=$product_name distclean
        ./obuild.py product=$product_name NV_BURN=true publish=true MBB_DT=true

        if [ $? -ne 0 ]; then
                echo "#########   compile usbloader ERROR    #########";
                exit 255;
        fi

        cp -fpr delivery/hi6921_v711_cpe delivery/usbloader
        mv delivery/usbloader delivery/hi6921_v711_cpe/

        ./obuild.py product=$product_name distclean
fi

$make_py product=$product_name $nv_burn publish=true codecc=$codecc 
if [ $? -ne 0 ]; then
echo "#########    ${product_name} compile ERROR    ##############"
exit 255
fi

echo "############################################################"
echo "#########    ${product_name} compile OK       ##############"
echo "############################################################"

exit 0
