#!/bin/sh

#<interface_name> [<ISP_FLAGS><network_id><BSSID>] <SSID> <BSSID> <auth_alg> <proto> <key_mgmt> <pairwise> <psk or wepkey> [key index]
#network id 4 for private network

interface_name=$1
echo "use interface $interface_name"
cmd_hdr="wpa_cli -i$interface_name"


if [ "$2" = "WPS_PBC" ]; then
	$cmd_hdr remove_network 4	
	$cmd_hdr set ap_scan 1
	$cmd_hdr wps_pbc
	exit 0
elif [ "$2" = "WPS_PIN" ]; then
	$cmd_hdr remove_network 4	
	$cmd_hdr set ap_scan 1
	$cmd_hdr wps_pin any $3
	exit 0
elif [ "$2" = "ISP" ]; then
	network_id=$3
	bssid=$4
	$cmd_hdr disable_network all
	$cmd_hdr set_network $network_id bssid "$bssid"
	$cmd_hdr select_network $network_id
	exit 0
elif [ "$2" = "PRIVATE" ]; then
	shift
fi


$cmd_hdr sta_autoconnect 0
$cmd_hdr set ap_scan 0

network_id=4
$cmd_hdr remove_network $network_id
network_id=`$cmd_hdr add_network`

ssid="$2"
bssid="$3"
auth_alg="$4"
proto="$5"
key_mgmt="$6"
if [ "$key_mgmt" = "WPA-EAP" ]; then
	echo "connect to eap-sim hotspot"
	eap=SIM
	pairwise="TKIP CCMP"
elif [ "$key_mgmt" = "NONE" ]; then
	echo "connect to open hotspot"
elif [ "$key_mgmt" = "WEP" ]; then
	echo "connect to wep hotspot"	
	wep_key=$7
	wep_key_len=${#wep_key}
	if [ "$wep_key_len" = "5" -o "$wep_key_len" = "13" ]; then		
		wep_key=\"$wep_key\"
		echo "ascii wep key $wepkey"
	elif [ "$wep_key_len" = "10" -o "$wep_key_len" = "26" ]; then
		echo "hex wep key"
	fi
        wep_tx_keyidx=$8
elif [ "$key_mgmt" = "WPA-PSK" ]; then
	pairwise=$7
	psk=$8
fi
	

$cmd_hdr set_network $network_id ssid \""$ssid"\"
$cmd_hdr set_network $network_id bssid "$bssid"
$cmd_hdr set_network $network_id scan_ssid 1

if [ "$key_mgmt" = "NONE" ]; then
	$cmd_hdr set_network $network_id auth_alg OPEN
	$cmd_hdr set_network $network_id key_mgmt NONE
elif [ "$key_mgmt" = "WEP" ]; then
	$cmd_hdr set_network $network_id auth_alg "$auth_alg"
	$cmd_hdr set_network $network_id key_mgmt NONE
	$cmd_hdr set_network $network_id "wep_key$wep_tx_keyidx" $wep_key
	$cmd_hdr set_network $network_id wep_tx_keyidx "$wep_tx_keyidx"
elif [ "$key_mgmt" = "WPA-PSK" ]; then
	$cmd_hdr set_network $network_id auth_alg OPEN
	$cmd_hdr set_network $network_id proto "$proto"
	$cmd_hdr set_network $network_id key_mgmt WPA-PSK
	$cmd_hdr set_network $network_id pairwise "$pairwise"
	psk_len=${#psk}
	if [ "$psk_len" = "64" ]; then
		$cmd_hdr set_network $network_id psk $psk
	else
		$cmd_hdr set_network $network_id psk \"$psk\"
	fi
elif [ "$key_mgmt" = "WPA-EAP" ]; then	
	$cmd_hdr set_network $network_id auth_alg OPEN
	$cmd_hdr set_network $network_id proto "$proto"
	$cmd_hdr set_network $network_id key_mgmt "WPA-EAP"
	$cmd_hdr set_network $network_id pairwise "$pairwise"
	$cmd_hdr set_network $network_id eap "SIM"
	$cmd_hdr set_network $network_id pcsc \"\"
else
	echo "unknown key_mgmt $key_mgmt"
	exit 1
fi
$cmd_hdr select_network $network_id

