#!/bin/sh

if test $1 = "on"; then
	echo -e "\e[00;36m Audio Voice is On\e[00m"
	if test $2 = "headset"; then
		PHONE_ID=9
		CODEC_ID=49
		CODEC_PARAMS=67567716
	elif test $2 = "earpiece"; then
		PHONE_ID=5
		CODEC_ID=28
		CODEC_PARAMS=2556004
	else
		PHONE_ID=9
		CODEC_ID=49
		CODEC_PARAMS=67567716
	fi
	## Set Voice path to headset/earpiece mode
	amixer cset -Dphone numid=$PHONE_ID 36,36,36,36
	## Start Voice-Call streaming (up/down link)
	amixer cset -Dphone numid=29
	## Enable Codec through libacm
	amixer cset -Dcodec numid=$CODEC_ID $CODEC_PARAMS
fi

if test $1 = "off"; then
	echo -e "\e[00;31m Audio Voice is Off\e[00m"
	if test $2 = "headset"; then
		PHONE_ID=10
		CODEC_ID=50
		CODEC_PARAMS=67567716
	elif test $2 = "earpiece"; then
		PHONE_ID=6
		CODEC_ID=29
		CODEC_PARAMS=2556004
	else
		PHONE_ID=10
		CODEC_ID=50
		CODEC_PARAMS=67567716
	fi
	## Stop Voice-Call streaming (up/down link)
	amixer cset -Dphone numid=30
	## Disable Voice path in headset/earpiece mode
	amixer cset -Dphone numid=$PHONE_ID
	## Disable Codec through libacm
	amixer cset -Dcodec numid=$CODEC_ID $CODEC_PARAMS
fi
