#!/bin/sh

CmdLine="/proc/cmdline"
TEMP_DIR=/mrvlsys

SYSTEM_CONFIG_HOST=`grep "SYCG=3" $CmdLine|wc -l`
IP_TERMINATION_AUX=`grep "IPTM=5" $CmdLine|wc -l`

IMS_ENABLE=`grep "IMSC=1" $CmdLine|wc -l`
IMS_AUX=`grep "IMSC=5" $CmdLine|wc -l`
MIFI_ENABLE=`grep "MIFI=1" $CmdLine|wc -l`
GPS_AUX=`grep "GPSC=5" $CmdLine|wc -l`
IP_ADDRESS=`getprop persist.mrvl.net.static_ip`

#setup loopback interface needed by mtil sockets
ifconfig lo up

#GPS in Aux
if [ $GPS_AUX = '1' ]; then
	echo "Running GPS..." >> /dev/kmsg
	./run_gps.sh
fi

#IMS
if [ $IMS_ENABLE = '1' -o $IMS_AUX = '1' ]; then
	echo "Running IMS..." >> /dev/kmsg
	./run_ims.sh
fi

if [ $MIFI_ENABLE = '1' ]; then
	echo "Running APX Service..." >> /dev/kmsg
	psm_cmd set lan ip $IP_ADDRESS
	psm_cmd set lan dhcp.start ${IP_ADDRESS%.*}.100
	psm_cmd set lan dhcp.end ${IP_ADDRESS%.*}.200
	./run_apx.sh mifi
fi

# Termination in Aux
if [ $IP_TERMINATION_AUX = '1' ]; then
	if [ $SYSTEM_CONFIG_HOST = '1' ]; then
		#System in Host i.e. DATACARD
		echo "Running APX Service..." >> /dev/kmsg
		psm_cmd set lan ip $IP_ADDRESS
		./run_apx.sh datacard
	else
		if [ $MIFI_ENABLE = '0' ]; then
			#System in Target i.e. simple hostless
			echo "Running FAKE-APX Service - no webui..." >> /dev/kmsg
			#NAT rules:
			./iptables -t nat -A POSTROUTING -o ccinet0 -j MASQUERADE
			./iptables -A FORWARD -i ccinet0 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
			./iptables -A FORWARD -i usb0 -o ccinet0 -j ACCEPT
			./iptables -t nat -A POSTROUTING -o ccinet3 -j MASQUERADE
			./iptables -A FORWARD -i ccinet3 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
			./iptables -A FORWARD -i usb0 -o ccinet3 -j ACCEPT

			# Special rules for a new session starts from NW to PC
			#
			# Note:
			# 1. It relays on DHCP address allocation (currently hard coded)
			# 2. This rules are for development only and should be removed in a product!
			#./iptables -A PREROUTING -t nat -i ccinet0 -j DNAT --to-destination 192.168.42.149
			#./iptables -A PREROUTING -t nat -i ccinet3 -j DNAT --to-destination 192.168.42.149

			mkdir -p /data/misc/dhcp
			#dnsmasq needs these files priori run -eben if updated later
			touch /tmp/hosts
			touch /tmp/resolv.conf
			./dnsmasq -K -F ${IP_ADDRESS}00,${IP_ADDRESS}00,12h -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid < /dev/tty0

			# Setting DNS server.
			# NOTE: This line should be removed when connectivity manager will be ready.
			#setprop net.dns1 8.8.8.8 - > set by mtil server on PDP up
		fi
	fi
fi


