#!/bin/sh

# Script to modify iptable entries

if [ $1 = "ADD" ]; then
    action="-A";
elif [ $1 = "DEL" ]; then
    action="-D";
else
   action="";
fi

table=$2
interface=$3
protocol=$4
port=$5
policy=$6

if [ ! -z "$action" ]; then
    echo "iptables "$action $table "-i "$interface "-p "$protocol "--dport "$port "-j "$policy;
    iptables $action $table -i $interface -p $protocol --dport $port -j $policy;
    exit $?;
else
    echo "run_ims_nf_conf: Invalid Action:" $1;
    echo "Syntax: run_ims_nf_conf [ADD/DEL] table interface protocol dest-port [ACCEPT/DROP]";
    exit 1;
fi

