#!/bin/sh
TEMP_DIR=/mrvlsys
awk 'BEGIN{print "[/proc/cmdline]"};{for (i=1;i<=NF;i++){if ($i ~ /=/){print $i;}else{print $i "=1";}}}
' /proc/cmdline > ${TEMP_DIR}/cmdline

####################
# Production mode  #
####################

# All TEL applications have private but same SIGn-handler
# The Pthread SIG is running under disable-IRQ and takes a lot of time
# but we have specual monitor going to Kpanic when limit exceeded.
# To avoid Kpanic inside of TEL-SIG handler expand the limit-time
# We need permissions to do this
chmod 0660 /sys/devices/system/cpu/cpu0/timer_irq_latency

#Enable RAMDUMP for this boot only (not persistent)
setprop mrvl.ramdump.on 1

cd /marvell/tel

if [ -e /dev/rdr ]; then
# RAMDUMP is prepared by U-boot in RAM
#  ABORT further init and call for upload (ended by reboot)
./ramdump_upload.sh
exit 0
fi

i=`grep -c "PROD=1,2" /proc/cmdline`
if [ $i == '1' ]; then
	if [ "$1" != "I_respawned" ]; then
		echo "START PRODUCTION OVER UART" > /dev/ttyS0
		# respawn myself with output redirection
		# cat /proc/kmsg >> /data/dump_production_log &
		# echo "==== respawn /marvell/tel/run_android_bsp_only.sh ====" > /dev/ttyS0
		cd /marvell/tel
		./busybox sh ./run_eshel_bsp_only.sh I_respawned $* 1>/dev/kmsg 2>&1
		exit $?
	else
		echo StartLogging >> /data/dump_production_log
	fi
fi

# This script is PRODUCTION, CPSR must be disabled
echo 0 > $NVM_ROOT_DIR/eeh_cp_sr.cfg

# Release COMM from reset
# (used when power support is not available) ./hwacc w 0x40F5001C   1
chmod 774 /sys/power/cp
echo 1 > /sys/power/cp

# Set error log location to /data volume, default is NVM
# Should be before mtsd starts as diag should be able to override the setting
echo "/data/log" > ${TEMP_DIR}/diag_log_path

busybox sh diag_port_conf.sh
port=`cat ${TEMP_DIR}/at_port.txt`
#disable DVFM and LPM
echo 0 > /sys/power/mspm/mspm
echo 0 > /sys/power/mspm/prof
echo disable > /sys/devices/platform/pxa2xx-uart.0/set_uart2gpio

insmod seh.ko
insmod acipcdev.ko
insmod ci_data_drv.ko
insmod citty.ko
insmod ccinetdev.ko
insmod cidatatty.ko

# Currently WTPSP in not working, TBD
# init WTPSP command
insmod /marvell/tel/wtpsp.ko
mknod /dev/wtm c 150 0

# create link for Modem
ln -s /dev/ttyGS0 /dev/ttymodem
#insmod ppp.ko
chmod 664 /sys/class/android_usb/android0/*

chmod 777 /dbg /dbg/*

# setup NW configuration
IP_ADDRESS=`getprop persist.mrvl.net.static_ip`
busybox ifconfig usb0 $IP_ADDRESS netmask 255.255.255.0 up
busybox ifconfig lo 127.0.0.1

busybox ln -s /dev/ttyDIAG0 /dev/ttygserial

#################################################
# start User mode part.
# do not put ANY user mode before this line.
#################################################

i=`grep -c "PROD=1,3" /proc/cmdline`
## run dbg macro handler
#./dbg_macro_util &
#This proccess enables DIAG and must be before
#mtilatcmd (mtsd - MTIl Server, mtilatcmd - MTIL client)
./mtsd &

if [ $i == '0' ]; then
	if [ "$port" == "UART" ]; then
		#Set AT and Diag over UART
		./mtilatcmd -u 1 -e libmf253_prod_extra_atcmd.so &
		./mtilatcmd -e libmf253_prod_extra_atcmd.so &
	else
		#Set AT and Diag over USB
		./mtilatcmd -e libmf253_prod_extra_atcmd.so &
		#Run mtil client for ACM-0 interface
		./mtilatcmd -m /dev/ttyGS0 -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &
		#Run mtil client for ACM-1 interface
		./mtilatcmd -m /dev/ttyGS1 -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &

		j=0
		while [ $j -lt 10 ]
		do
			j=`expr $j + 1`
			if [ ! -e /mrvlsys/atcmdsrv_ok ]; then
				sleep 1
			else
				break
			fi
		done
		# set USB default configuration for production
		prod_conf="diag_acm,acm_at_0,acm_at_1"
		curr_conf=$(getprop sys.usb.config)
		if [ $curr_conf != $prod_conf ]; then
			setprop persist.sys.usb.config $prod_conf
			echo "setprop production config" > /dev/kmsg
		fi
	fi
	./eeh &
else
	# set USB L1 configuration for production (not persistent)
	setprop sys.usb.config "diag_acm,acm_at_0,acm_at_1"
	touch /NVM/jtag_is_running
	## run hwacc
	insmod hwmap.ko
	./eeh -M 2 -a 1 -A 1 &
fi

# MIM ./audioserver -D yes&
rm -rf /cache/fa_pxa*
#open voice path
sleep 1
/system/bin/voice_path_control_mf253 1 &
#Run VOICE app
sleep 1
/bin/zte_voice &
