#!/bin/sh
myself=${0##*/}
TEMP_DIR=/mrvlsys
NVM_DIR=/NVM

#Updating boot sequence number
[ -f ${NVM_DIR}/ml_boot_seq.txt ] &&
	a=`awk ' {a=$1+1;};END{print a}' ${NVM_DIR}/ml_boot_seq.txt` ||
	a=1;
echo $a > ${NVM_DIR}/ml_boot_seq.txt

#add all kernel command line tokens to properties
awk '{for (i=1;i<=NF;i++){if ($i ~ /=/){gsub("="," ",$i);print "ro.cmdline."$i;}else{print "ro.cmdline."$i" 1";}}}' /proc/cmdline | xargs -n 2 setprop
#add symbolic link to ml_vers from NVM
ln -s /system/etc/ml_vers.txt /NVM/ml_vers.txt

awk 'BEGIN{print "[/proc/cmdline]"};{for (i=1;i<=NF;i++){if ($i ~ /=/){print $i;}else{print $i "=1";}}}
' /proc/cmdline > ${TEMP_DIR}/cmdline

# Open for debug
#echo 7 > /proc/sys/kernel/printk

# Special permissions

# All TEL applications have private but same SIGn-handler
# The Pthread SIG is running under disable-IRQ and takes a lot of time
# but we have specual monitor going to Kpanic when limit exceeded.
# To avoid Kpanic inside of TEL-SIG handler expand the limit-time
# We need permissions to do this
chmod 0660 /sys/devices/system/cpu/cpu0/timer_irq_latency

cd /marvell/tel

if [ -e /dev/rdr ]; then
	# RAMDUMP is prepared by U-boot in RAM
	#  ABORT further init and call for upload (ended by reboot)
	./ramdump_upload.sh
exit 0
fi

#set cp_sr_enable silent reset enable
cp_sr_enable=`ml_ini -r -f /mrvlsys/cmdline -s /proc/cmdline -k CPSR -v 0`

#backup rw image of cp, rf and dsp.
if [ $cp_sr_enable == '1' ]; then
	/marvell/tel/cp_sr_backup.sh
fi

# configure properties and COM symlinks - MUST BE BEFORE RELEASE COMM FROM RESET!!!
#/system/marvell/tel/prop_cfg.sh

# Release COMM from reset
# (used when power support is not available) ./hwacc w 0x40F5001C   1
chmod 774 /sys/power/cp
echo 1 > /sys/power/cp

# Keep suplementary group root for accessing /sys files
mrvlacc="system system root"

# Set error log location to /data volume, default is NVM
# Should be before mtsd starts as diag should be able to override the setting

ml_setid $mrvlacc -- sh -c "echo /dbg/log > ${TEMP_DIR}/diag_log_path"

#enable DVFM and LPM
echo 1 > /sys/power/mspm/mspm
echo 1 > /sys/power/mspm/prof
insmod seh.ko
insmod acipcdev.ko
insmod ci_data_drv.ko
#sleep 1
insmod citty.ko
insmod ccinetdev.ko
insmod cidatatty.ko

# create link for Modem
ln -s /dev/ttyGS0 /dev/ttymodem
insmod ppp.ko

chmod 777 /dbg /dbg/*

# enable read/write from USB proc
chmod 664 /sys/class/android_usb/android0/*

# setup NW configuretion
./busybox sh /marvell/tel/run_nw_conf.sh

# sleep 1 sec before starting user mode applications
#sleep 1
#################################################
# start User mode part.
# do not put ANY user mode before this line.
#################################################

./mtsd --secure &
# wait for Diag, CCI registartion befor running any mtil clients
#sleep 1
./mtilatcmd -S -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &

# run mtil client for APX service
MIFI_ENABLE=`grep "MIFI=1" /proc/cmdline|wc -l`
DATACARD_ENABLE=`grep "SYCG=3" /proc/cmdline|grep "IPTM=5"|wc -l`
if [ $MIFI_ENABLE = '1' -o $DATACARD_ENABLE = '1' ]; then
./mtilatcmd -S -s /dev/cctdev2 -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &
fi

#number of silent reset, if cp_sr_enable =1
#it will confige 17 silent reset
if [ $cp_sr_enable == '1' ]; then
	ml_setid $mrvlacc -- sh -c "echo 17 > $NVM_ROOT_DIR/eeh_cp_sr.cfg"
	eeh_log_level="-M 3"
else
	ml_setid $mrvlacc -- sh -c "echo 0 > $NVM_ROOT_DIR/eeh_cp_sr.cfg"
fi

# MIM ./audioserver -D yes&

# EEH Operating defaults: -a 8 -A 8 -M 1
#   DEBUG options: -a 1 -A 1 =stall; -M 2 =always all logs
./eeh -s $eeh_log_level &

## run dbg macro handler
#./dbg_macro_util &


## run HAWK
ML_HAWK_ID=`getprop ro.cmdline.HAWK 0`
if [ $ML_HAWK_ID = '1' ]; then
	./hawk -f -t standalone &
fi

#Optional compuntents configurations
./busybox sh /marvell/tel/run_optional_comp.sh

#Run mtil client for ACM-0 interface
./mtilatcmd -m /dev/ttymodem -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &

#Run mtil client for ACM-1 interface
getprop | grep acm_at_1 > ${TEMP_DIR}/usbprop1
if [ $? == 0 ]; then
./mtilatcmd -m /dev/ttyGS1 -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &
fi

#Run mtil client for ACM-2 interface
getprop | grep acm_at_2 > ${TEMP_DIR}/usbprop2
if [ $? == 0 ]; then
./mtilatcmd -m /dev/ttyGS2 -e libatgpsext.so -e libmf253_prod_extra_atcmd.so &
fi

#Run audio_calibration and pluggin proxy process
audio_manager&

# increase writeback interval for powersaving
echo 3000 > /proc/sys/vm/dirty_writeback_centisecs

#open voice path
sleep 1
/system/bin/voice_path_control_mf253 1 &
#Run VOICE app
sleep 1
/bin/zte_voice &
#run FOTA update app
/bin/zte_fota_update &

